"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTraceAnalyticsDslRouter = registerTraceAnalyticsDslRouter;
var _configSchema = require("@osd/config-schema");
var _trace_analytics = require("../../common/constants/trace_analytics");
var _metrics_helper = require("../common/metrics/metrics_helper");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerTraceAnalyticsDslRouter(router) {
  router.post({
    path: _trace_analytics.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE,
    validate: false
  }, async (context, request, response) => {
    const params = {
      index: [_trace_analytics.DATA_PREPPER_INDEX_NAME, _trace_analytics.DATA_PREPPER_SERVICE_INDEX_NAME],
      allow_no_indices: false
    };
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.exists', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: _trace_analytics.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE,
    validate: false
  }, async (context, request, response) => {
    const params = {
      index: [_trace_analytics.JAEGER_INDEX_NAME, _trace_analytics.JAEGER_SERVICE_INDEX_NAME],
      allow_no_indices: false
    };
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.exists', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: _trace_analytics.TRACE_ANALYTICS_DSL_ROUTE,
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.maybe(_configSchema.schema.string()),
        from: _configSchema.schema.maybe(_configSchema.schema.number()),
        size: _configSchema.schema.number(),
        query: _configSchema.schema.maybe(_configSchema.schema.object({
          bool: _configSchema.schema.object({
            filter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            must: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            should: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            must_not: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            minimum_should_match: _configSchema.schema.maybe(_configSchema.schema.number()),
            adjust_pure_negative: _configSchema.schema.maybe(_configSchema.schema.boolean()),
            boost: _configSchema.schema.maybe(_configSchema.schema.any())
          })
        })),
        aggs: _configSchema.schema.maybe(_configSchema.schema.any()),
        aggregations: _configSchema.schema.maybe(_configSchema.schema.any()),
        sort: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
        _source: _configSchema.schema.maybe(_configSchema.schema.object({
          includes: _configSchema.schema.arrayOf(_configSchema.schema.string())
        })),
        script_fields: _configSchema.schema.maybe(_configSchema.schema.any())
      })
    }
  }, async (context, request, response) => {
    (0, _metrics_helper.addRequestToMetric)('trace_analytics', 'get', 'count');
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index: index || _trace_analytics.DATA_PREPPER_INDEX_NAME,
      size,
      body: rest
    };
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      (0, _metrics_helper.addRequestToMetric)('trace_analytics', 'get', error);
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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