
use builtin;
use str;

set edit:completion:arg-completer[rye] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'rye'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'rye'= {
            cand --env-file 'Load one or more .env files'
            cand --version 'Print the version'
            cand -h 'Print help'
            cand --help 'Print help'
            cand add 'Adds a Python package to this project'
            cand build 'Builds a package for distribution'
            cand config 'Reads or modifies the global `config.toml` file'
            cand fetch 'Fetches a Python interpreter for the local machine. This is an alias of `rye toolchain fetch`'
            cand fmt 'Run the code formatter on the project'
            cand init 'Initialize a new or existing Python project with Rye'
            cand install 'Installs a package as global tool. This is an alias of `rye tools install`'
            cand lock 'Updates the lockfiles without installing dependencies'
            cand lint 'Run the linter on the project'
            cand make-req 'Builds and prints a PEP 508 requirement string from parts'
            cand pin 'Pins a Python version to this project'
            cand publish 'Publish packages to a package repository'
            cand remove 'Removes a package from this project'
            cand run 'Runs a command installed into this package'
            cand show 'Prints the current state of the project'
            cand sync 'Updates the virtualenv based on the pyproject.toml'
            cand test 'Run the tests on the project'
            cand toolchain 'Helper utility to manage Python toolchains'
            cand tools 'Helper utility to manage global tools'
            cand self 'Rye self management'
            cand uninstall 'Uninstalls a global tool. This is an alias of `rye tools uninstall`'
            cand version 'Get or set project version'
            cand list 'Prints the currently installed packages'
            cand shell 'The shell command was removed'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rye;add'= {
            cand --git 'Install the given package from this git repository'
            cand --url 'Install the given package from this URL'
            cand --path 'Install the given package from this local path'
            cand --tag 'Install a specific tag'
            cand --rev 'Update to a specific git rev'
            cand --branch 'Update to a specific git branch'
            cand --features 'Adds a dependency with a specific feature'
            cand --optional 'Add this to an optional dependency group'
            cand --pin 'Overrides the pin operator'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --absolute 'Force non interpolated absolute paths'
            cand -d 'Add this as dev dependency'
            cand --dev 'Add this as dev dependency'
            cand --excluded 'Add this as an excluded dependency that will not be installed even if it''s a sub dependency'
            cand --pre 'Include pre-releases when finding a package version'
            cand --sync 'Runs `sync` even if auto-sync is disabled'
            cand --no-sync 'Does not run `sync` even if auto-sync is enabled'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;build'= {
            cand -p 'Build a specific package'
            cand --package 'Build a specific package'
            cand -o 'An output directory (defaults to `workspace/dist`)'
            cand --out 'An output directory (defaults to `workspace/dist`)'
            cand --pyproject 'Use this pyproject.toml file'
            cand --sdist 'Build a sdist'
            cand --wheel 'Build a wheel'
            cand -a 'Build all packages'
            cand --all 'Build all packages'
            cand -c 'Clean the output directory first'
            cand --clean 'Clean the output directory first'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;config'= {
            cand --format 'Request parseable output format rather than lines'
            cand --get 'Reads a config key'
            cand --set 'Sets a config key to a string'
            cand --set-int 'Sets a config key to an integer'
            cand --set-bool 'Sets a config key to a bool'
            cand --unset 'Remove a config key'
            cand --show-path 'Print the path to the config'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;fetch'= {
            cand --target-path 'Fetches the Python toolchain into an explicit location rather'
            cand -f 'Fetch the Python toolchain even if it is already installed'
            cand --force 'Fetch the Python toolchain even if it is already installed'
            cand --build-info 'Fetches with build info'
            cand --no-build-info 'Fetches without build info'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;fmt'= {
            cand -p 'Perform the operation on a specific package'
            cand --package 'Perform the operation on a specific package'
            cand --pyproject 'Use this pyproject.toml file'
            cand -a 'Perform the operation on all packages'
            cand --all 'Perform the operation on all packages'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand --check 'Run format in check mode'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;init'= {
            cand --min-py 'Minimal Python version supported by this project'
            cand -p 'Python version to use for the virtualenv'
            cand --py 'Python version to use for the virtualenv'
            cand --build-system 'Which build system should be used (defaults to hatchling)?'
            cand --license 'Which license should be used (SPDX identifier)?'
            cand --name 'The name of the package'
            cand -r 'Requirements files to initialize pyproject.toml with'
            cand --requirements 'Requirements files to initialize pyproject.toml with'
            cand --dev-requirements 'Development requirements files to initialize pyproject.toml with'
            cand --lib 'Generate a library project (default)'
            cand --script 'Generate an executable project'
            cand --no-readme 'Do not create a readme'
            cand --no-pin 'Do not create .python-version file (requires-python will be used)'
            cand --private 'Set "Private :: Do Not Upload" classifier, used for private projects'
            cand --no-import 'Don''t import from setup.cfg, setup.py, or requirements files'
            cand --virtual 'Initialize this as a virtual package'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;install'= {
            cand --git 'Install the given package from this git repository'
            cand --url 'Install the given package from this URL'
            cand --path 'Install the given package from this local path'
            cand --tag 'Install a specific tag'
            cand --rev 'Update to a specific git rev'
            cand --branch 'Update to a specific git branch'
            cand --features 'Adds a dependency with a specific feature'
            cand --include-dep 'Include scripts from a given dependency'
            cand --extra-requirement 'Additional dependencies to install that are not declared by the main package'
            cand -p 'Optionally the Python version to use'
            cand --python 'Optionally the Python version to use'
            cand --absolute 'Force non interpolated absolute paths'
            cand -f 'Force install the package even if it''s already there'
            cand --force 'Force install the package even if it''s already there'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;lock'= {
            cand --update 'Update a specific package'
            cand --features 'Extras/features to enable when locking the workspace'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --pyproject 'Use this pyproject.toml file'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand --update-all 'Update all packages to the latest'
            cand --pre 'Update to pre-release versions'
            cand --all-features 'Enables all features'
            cand --with-sources 'Set to true to lock with sources in the lockfile'
            cand --reset 'Reset prior lock options'
            cand --generate-hashes 'Set to true to lock with hashes in the lockfile'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;lint'= {
            cand -p 'Perform the operation on a specific package'
            cand --package 'Perform the operation on a specific package'
            cand --pyproject 'Use this pyproject.toml file'
            cand -a 'Perform the operation on all packages'
            cand --all 'Perform the operation on all packages'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand --fix 'Apply fixes'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;make-req'= {
            cand --git 'Install the given package from this git repository'
            cand --url 'Install the given package from this URL'
            cand --path 'Install the given package from this local path'
            cand --tag 'Install a specific tag'
            cand --rev 'Update to a specific git rev'
            cand --branch 'Update to a specific git branch'
            cand --features 'Adds a dependency with a specific feature'
            cand --absolute 'Force non interpolated absolute paths'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;pin'= {
            cand --pyproject 'Use this pyproject.toml file'
            cand --relaxed 'Issue a relaxed pin'
            cand --no-update-requires-python 'Prevent updating requires-python in the pyproject.toml'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;publish'= {
            cand -r 'The repository to publish to'
            cand --repository 'The repository to publish to'
            cand --repository-url 'The repository url to publish to'
            cand -u 'The username to authenticate to the repository with'
            cand --username 'The username to authenticate to the repository with'
            cand --token 'An access token used for the upload'
            cand -i 'GPG identity used to sign files'
            cand --identity 'GPG identity used to sign files'
            cand --cert 'Path to alternate CA bundle'
            cand --sign 'Sign files to upload using GPG'
            cand --skip-existing 'Skip files that have already been published (only applies to repositories supporting this feature)'
            cand -y 'Skip prompts'
            cand --yes 'Skip prompts'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;remove'= {
            cand --optional 'Remove this from an optional dependency group'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --dev 'Remove this from dev dependencies'
            cand --sync 'Runs `sync` even if auto-sync is disabled'
            cand --no-sync 'Does not run `sync` even if auto-sync is enabled'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;run'= {
            cand --pyproject 'Use this pyproject.toml file'
            cand -l 'List all commands'
            cand --list 'List all commands'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;show'= {
            cand --pyproject 'Use this pyproject.toml file'
            cand --installed-deps 'Print the installed dependencies from the venv'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;sync'= {
            cand --update 'Update a specific package'
            cand --features 'Extras/features to enable when syncing the workspace'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --pyproject 'Use this pyproject.toml file'
            cand -f 'Force the environment to be re-created'
            cand --force 'Force the environment to be re-created'
            cand --no-dev 'Do not include dev dependencies'
            cand --no-lock 'Do not update the lockfile'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand --update-all 'Update all packages to the latest'
            cand --pre 'Update to pre-release versions'
            cand --all-features 'Enables all features'
            cand --with-sources 'Set to true to lock with sources in the lockfile'
            cand --reset 'Do not reuse (reset) prior lock options'
            cand --generate-hashes 'Set to true to lock with hashes in the lockfile'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;test'= {
            cand -p 'Perform the operation on a specific package'
            cand --package 'Perform the operation on a specific package'
            cand --pyproject 'Use this pyproject.toml file'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand -a 'Perform the operation on all packages'
            cand --all 'Perform the operation on all packages'
            cand -s 's'
            cand --no-capture 'no-capture'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;toolchain'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand fetch 'Fetches a Python interpreter for the local machine. This is an alias of `rye toolchain fetch`'
            cand list 'List all registered toolchains'
            cand register 'Register a Python binary'
            cand remove 'Removes a toolchain'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rye;toolchain;fetch'= {
            cand --target-path 'Fetches the Python toolchain into an explicit location rather'
            cand -f 'Fetch the Python toolchain even if it is already installed'
            cand --force 'Fetch the Python toolchain even if it is already installed'
            cand --build-info 'Fetches with build info'
            cand --no-build-info 'Fetches without build info'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;toolchain;list'= {
            cand --format 'Request parseable output format'
            cand --include-downloadable 'Also include non installed, but downloadable toolchains'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;toolchain;register'= {
            cand -n 'Name of the toolchain.  If not provided a name is auto detected'
            cand --name 'Name of the toolchain.  If not provided a name is auto detected'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;toolchain;remove'= {
            cand -f 'Force removal even if the toolchain is in use'
            cand --force 'Force removal even if the toolchain is in use'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;toolchain;help'= {
            cand fetch 'Fetches a Python interpreter for the local machine. This is an alias of `rye toolchain fetch`'
            cand list 'List all registered toolchains'
            cand register 'Register a Python binary'
            cand remove 'Removes a toolchain'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rye;toolchain;help;fetch'= {
        }
        &'rye;toolchain;help;list'= {
        }
        &'rye;toolchain;help;register'= {
        }
        &'rye;toolchain;help;remove'= {
        }
        &'rye;toolchain;help;help'= {
        }
        &'rye;tools'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand install 'Installs a package as global tool. This is an alias of `rye tools install`'
            cand uninstall 'Uninstalls a global tool. This is an alias of `rye tools uninstall`'
            cand list 'List all registered tools'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rye;tools;install'= {
            cand --git 'Install the given package from this git repository'
            cand --url 'Install the given package from this URL'
            cand --path 'Install the given package from this local path'
            cand --tag 'Install a specific tag'
            cand --rev 'Update to a specific git rev'
            cand --branch 'Update to a specific git branch'
            cand --features 'Adds a dependency with a specific feature'
            cand --include-dep 'Include scripts from a given dependency'
            cand --extra-requirement 'Additional dependencies to install that are not declared by the main package'
            cand -p 'Optionally the Python version to use'
            cand --python 'Optionally the Python version to use'
            cand --absolute 'Force non interpolated absolute paths'
            cand -f 'Force install the package even if it''s already there'
            cand --force 'Force install the package even if it''s already there'
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;tools;uninstall'= {
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;tools;list'= {
            cand -s 'Show all the scripts installed by the tools'
            cand --include-scripts 'Show all the scripts installed by the tools'
            cand -v 'Show the version of tools'
            cand --include-version 'Show the version of tools'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;tools;help'= {
            cand install 'Installs a package as global tool. This is an alias of `rye tools install`'
            cand uninstall 'Uninstalls a global tool. This is an alias of `rye tools uninstall`'
            cand list 'List all registered tools'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rye;tools;help;install'= {
        }
        &'rye;tools;help;uninstall'= {
        }
        &'rye;tools;help;list'= {
        }
        &'rye;tools;help;help'= {
        }
        &'rye;self'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand completion 'Generates a completion script for a shell'
            cand update 'Performs an update of rye'
            cand install 'Triggers the initial installation of Rye'
            cand uninstall 'Uninstalls rye again'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rye;self;completion'= {
            cand -s 'The shell to generate a completion script for (defaults to ''bash'')'
            cand --shell 'The shell to generate a completion script for (defaults to ''bash'')'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;self;update'= {
            cand --version 'Update to a specific version'
            cand --tag 'Update to a specific tag'
            cand --rev 'Update to a specific git rev'
            cand --branch 'Update to a specific git branch'
            cand --force 'Force reinstallation'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;self;install'= {
            cand --toolchain 'Register a specific toolchain before bootstrap'
            cand --toolchain-version 'Use a specific toolchain version'
            cand -y 'Skip prompts'
            cand --yes 'Skip prompts'
            cand --modify-path 'Always modify without asking the PATH environment variable'
            cand --no-modify-path 'Do not modify the PATH environment variable'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rye;self;uninstall'= {
            cand -y 'Skip safety check'
            cand --yes 'Skip safety check'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;self;help'= {
            cand completion 'Generates a completion script for a shell'
            cand update 'Performs an update of rye'
            cand install 'Triggers the initial installation of Rye'
            cand uninstall 'Uninstalls rye again'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rye;self;help;completion'= {
        }
        &'rye;self;help;update'= {
        }
        &'rye;self;help;install'= {
        }
        &'rye;self;help;uninstall'= {
        }
        &'rye;self;help;help'= {
        }
        &'rye;uninstall'= {
            cand -v 'Enables verbose diagnostics'
            cand --verbose 'Enables verbose diagnostics'
            cand -q 'Turns off all output'
            cand --quiet 'Turns off all output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;version'= {
            cand -b 'The version bump to apply'
            cand --bump 'The version bump to apply'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;list'= {
            cand --pyproject 'Use this pyproject.toml file'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;shell'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rye;help'= {
            cand add 'Adds a Python package to this project'
            cand build 'Builds a package for distribution'
            cand config 'Reads or modifies the global `config.toml` file'
            cand fetch 'Fetches a Python interpreter for the local machine. This is an alias of `rye toolchain fetch`'
            cand fmt 'Run the code formatter on the project'
            cand init 'Initialize a new or existing Python project with Rye'
            cand install 'Installs a package as global tool. This is an alias of `rye tools install`'
            cand lock 'Updates the lockfiles without installing dependencies'
            cand lint 'Run the linter on the project'
            cand make-req 'Builds and prints a PEP 508 requirement string from parts'
            cand pin 'Pins a Python version to this project'
            cand publish 'Publish packages to a package repository'
            cand remove 'Removes a package from this project'
            cand run 'Runs a command installed into this package'
            cand show 'Prints the current state of the project'
            cand sync 'Updates the virtualenv based on the pyproject.toml'
            cand test 'Run the tests on the project'
            cand toolchain 'Helper utility to manage Python toolchains'
            cand tools 'Helper utility to manage global tools'
            cand self 'Rye self management'
            cand uninstall 'Uninstalls a global tool. This is an alias of `rye tools uninstall`'
            cand version 'Get or set project version'
            cand list 'Prints the currently installed packages'
            cand shell 'The shell command was removed'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rye;help;add'= {
        }
        &'rye;help;build'= {
        }
        &'rye;help;config'= {
        }
        &'rye;help;fetch'= {
        }
        &'rye;help;fmt'= {
        }
        &'rye;help;init'= {
        }
        &'rye;help;install'= {
        }
        &'rye;help;lock'= {
        }
        &'rye;help;lint'= {
        }
        &'rye;help;make-req'= {
        }
        &'rye;help;pin'= {
        }
        &'rye;help;publish'= {
        }
        &'rye;help;remove'= {
        }
        &'rye;help;run'= {
        }
        &'rye;help;show'= {
        }
        &'rye;help;sync'= {
        }
        &'rye;help;test'= {
        }
        &'rye;help;toolchain'= {
            cand fetch 'Fetches a Python interpreter for the local machine. This is an alias of `rye toolchain fetch`'
            cand list 'List all registered toolchains'
            cand register 'Register a Python binary'
            cand remove 'Removes a toolchain'
        }
        &'rye;help;toolchain;fetch'= {
        }
        &'rye;help;toolchain;list'= {
        }
        &'rye;help;toolchain;register'= {
        }
        &'rye;help;toolchain;remove'= {
        }
        &'rye;help;tools'= {
            cand install 'Installs a package as global tool. This is an alias of `rye tools install`'
            cand uninstall 'Uninstalls a global tool. This is an alias of `rye tools uninstall`'
            cand list 'List all registered tools'
        }
        &'rye;help;tools;install'= {
        }
        &'rye;help;tools;uninstall'= {
        }
        &'rye;help;tools;list'= {
        }
        &'rye;help;self'= {
            cand completion 'Generates a completion script for a shell'
            cand update 'Performs an update of rye'
            cand install 'Triggers the initial installation of Rye'
            cand uninstall 'Uninstalls rye again'
        }
        &'rye;help;self;completion'= {
        }
        &'rye;help;self;update'= {
        }
        &'rye;help;self;install'= {
        }
        &'rye;help;self;uninstall'= {
        }
        &'rye;help;uninstall'= {
        }
        &'rye;help;version'= {
        }
        &'rye;help;list'= {
        }
        &'rye;help;shell'= {
        }
        &'rye;help;help'= {
        }
    ]
    $completions[$command]
}
