"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationsDashboardsPlugin = void 0;
var _routes = require("./routes");
var _notificationsPlugin = require("./clusters/notificationsPlugin");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
class notificationsDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core) {
    this.logger.debug("notificationsDashboards: Setup");
    const router = core.http.createRouter();
    const notificationsClient = core.opensearch.legacy.createClient('opensearch_notifications', {
      plugins: [_notificationsPlugin.NotificationsPlugin]
    });
    core.http.registerRouteHandlerContext('notificationsContext', (context, request) => {
      return {
        logger: this.logger,
        notificationsClient
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router);
    return {};
  }
  start(core) {
    this.logger.debug("notificationsDashboards: Started");
    return {};
  }
  stop() {}
}
exports.notificationsDashboardsPlugin = notificationsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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