"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMESTAMP_DATATYPE = exports.SPARK_PARTITION_INFO = exports.SPARK_HIVE_TABLE_REGEX = exports.SKIPPING_INDEX_ACCELERATION_METHODS = exports.QUERY_LANGUAGE = exports.OLLY_QUESTION_URL_PARAM_KEY = exports.INDEX_URL_PARAM_KEY = exports.DEFAULT_DATA_SOURCE_TYPE_NAME = exports.DEFAULT_DATA_SOURCE_TYPE = exports.DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = exports.DEFAULT_DATA_SOURCE_NAME = exports.DATA_SOURCE_TYPE_URL_PARAM_KEY = exports.DATA_SOURCE_TYPES = exports.DATA_SOURCE_NAME_URL_PARAM_KEY = exports.CATALOG_CACHE_VERSION = exports.ASYNC_POLLING_INTERVAL = exports.ACC_INDEX_TYPE_DOCUMENTATION_URL = exports.ACCELERATION_TIME_INTERVAL = exports.ACCELERATION_S3_URL_REGEX = exports.ACCELERATION_INDEX_TYPES = exports.ACCELERATION_INDEX_NAME_REGEX = exports.ACCELERATION_INDEX_NAME_INFO = exports.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = exports.ACCELERATION_AGGREGRATION_FUNCTIONS = exports.ACCELERATION_ADD_FIELDS_TEXT = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const DATA_SOURCE_NAME_URL_PARAM_KEY = exports.DATA_SOURCE_NAME_URL_PARAM_KEY = 'datasourceName';
const DATA_SOURCE_TYPE_URL_PARAM_KEY = exports.DATA_SOURCE_TYPE_URL_PARAM_KEY = 'datasourceType';
const OLLY_QUESTION_URL_PARAM_KEY = exports.OLLY_QUESTION_URL_PARAM_KEY = 'olly_q';
const INDEX_URL_PARAM_KEY = exports.INDEX_URL_PARAM_KEY = 'indexPattern';
const DEFAULT_DATA_SOURCE_TYPE = exports.DEFAULT_DATA_SOURCE_TYPE = 'DEFAULT_INDEX_PATTERNS';
const DEFAULT_DATA_SOURCE_NAME = exports.DEFAULT_DATA_SOURCE_NAME = 'Default cluster';
const DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = exports.DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = 'OpenSearch';
const DEFAULT_DATA_SOURCE_TYPE_NAME = exports.DEFAULT_DATA_SOURCE_TYPE_NAME = 'Default Group';
let QUERY_LANGUAGE = exports.QUERY_LANGUAGE = /*#__PURE__*/function (QUERY_LANGUAGE) {
  QUERY_LANGUAGE["PPL"] = "PPL";
  QUERY_LANGUAGE["SQL"] = "SQL";
  QUERY_LANGUAGE["DQL"] = "DQL";
  return QUERY_LANGUAGE;
}({});
let DATA_SOURCE_TYPES = exports.DATA_SOURCE_TYPES = /*#__PURE__*/function (DATA_SOURCE_TYPES) {
  DATA_SOURCE_TYPES["DEFAULT_CLUSTER_TYPE"] = "DEFAULT_INDEX_PATTERNS";
  DATA_SOURCE_TYPES["SPARK"] = "spark";
  DATA_SOURCE_TYPES["S3Glue"] = "s3glue";
  return DATA_SOURCE_TYPES;
}({});
const ASYNC_POLLING_INTERVAL = exports.ASYNC_POLLING_INTERVAL = 2000;
const CATALOG_CACHE_VERSION = exports.CATALOG_CACHE_VERSION = '1.0';
const ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = exports.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = 'skipping';
const ACCELERATION_TIME_INTERVAL = exports.ACCELERATION_TIME_INTERVAL = [{
  text: 'millisecond(s)',
  value: 'millisecond'
}, {
  text: 'second(s)',
  value: 'second'
}, {
  text: 'minutes(s)',
  value: 'minute'
}, {
  text: 'hour(s)',
  value: 'hour'
}, {
  text: 'day(s)',
  value: 'day'
}, {
  text: 'week(s)',
  value: 'week'
}];
const ACCELERATION_ADD_FIELDS_TEXT = exports.ACCELERATION_ADD_FIELDS_TEXT = '(add fields here)';
const ACCELERATION_INDEX_NAME_REGEX = exports.ACCELERATION_INDEX_NAME_REGEX = /^[a-z][a-z_]*$/;
const ACCELERATION_S3_URL_REGEX = exports.ACCELERATION_S3_URL_REGEX = /^(s3|s3a):\/\/[a-zA-Z0-9.\-]+/;
const SPARK_HIVE_TABLE_REGEX = exports.SPARK_HIVE_TABLE_REGEX = /Provider:\s*hive/;
const TIMESTAMP_DATATYPE = exports.TIMESTAMP_DATATYPE = 'timestamp';
const ACCELERATION_INDEX_TYPES = exports.ACCELERATION_INDEX_TYPES = [{
  label: 'Skipping Index',
  value: 'skipping'
}, {
  label: 'Covering Index',
  value: 'covering'
}, {
  label: 'Materialized View',
  value: 'materialized'
}];
const ACC_INDEX_TYPE_DOCUMENTATION_URL = exports.ACC_INDEX_TYPE_DOCUMENTATION_URL = 'https://github.com/opensearch-project/opensearch-spark/blob/main/docs/index.md';
const ACCELERATION_INDEX_NAME_INFO = exports.ACCELERATION_INDEX_NAME_INFO = `All OpenSearch acceleration indices have a naming format of pattern: \`prefix_<index name>_suffix\`. They share a common prefix structure, which is \`flint_<data source name>_<database name>_<table name>_\`. Additionally, they may have a suffix that varies based on the index type. 
##### Skipping Index
- For 'Skipping' indices, a fixed index name 'skipping' is used, and this name cannot be modified by the user. The suffix added to this type is \`_index\`.
  - An example of a 'Skipping' index name would be: \`flint_mydatasource_mydb_mytable_skipping_index\`.
##### Covering Index
- 'Covering' indices allow users to specify their index name. The suffix added to this type is \`_index\`.
  - For instance, a 'Covering' index name could be: \`flint_mydatasource_mydb_mytable_myindexname_index\`.
##### Materialized View Index
- 'Materialized View' indices also enable users to define their index name, but they do not have a suffix.
  - An example of a 'Materialized View' index name might look like: \`flint_mydatasource_mydb_mytable_myindexname\`.
##### Note:
- All user given index names must be in lowercase letters. Index name cannot begin with underscores. Spaces, commas, and characters -, :, ", *, +, /, \, |, ?, #, >, or < are not allowed.  
  `;
const SKIPPING_INDEX_ACCELERATION_METHODS = exports.SKIPPING_INDEX_ACCELERATION_METHODS = [{
  value: 'PARTITION',
  text: 'Partition'
}, {
  value: 'VALUE_SET',
  text: 'Value Set'
}, {
  value: 'MIN_MAX',
  text: 'Min Max'
}, {
  value: 'BLOOM_FILTER',
  text: 'Bloom Filter'
}];
const ACCELERATION_AGGREGRATION_FUNCTIONS = exports.ACCELERATION_AGGREGRATION_FUNCTIONS = [{
  label: 'window.start'
}, {
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}];
const SPARK_PARTITION_INFO = exports.SPARK_PARTITION_INFO = `# Partition Information`;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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