from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TCollection import *
from OCC.Core.RWMesh import *
from OCC.Core.XCAFPrs import *
from OCC.Core.TDocStd import *
from OCC.Core.TDF import *
from OCC.Core.TColStd import *
from OCC.Core.Message import *
from OCC.Core.DE import *
from OCC.Core.Graphic3d import *
from OCC.Core.gp import *
from OCC.Core.XSControl import *
from OCC.Core.TopoDS import *


class RWPly_CafWriter(Standard_Transient):
    def __init__(self, theFile: str) -> None: ...
    def ChangeCoordinateSystemConverter(self) -> RWMesh_CoordinateSystemConverter: ...
    def CoordinateSystemConverter(self) -> RWMesh_CoordinateSystemConverter: ...
    def DefaultStyle(self) -> XCAFPrs_Style: ...
    def HasColors(self) -> bool: ...
    def HasFaceId(self) -> bool: ...
    def HasNormals(self) -> bool: ...
    def HasPartId(self) -> bool: ...
    def HasTexCoords(self) -> bool: ...
    def IsDoublePrecision(self) -> bool: ...
    @overload
    def Perform(self, theDocument: TDocStd_Document, theRootLabels: TDF_LabelSequence, theLabelFilter: TColStd_MapOfAsciiString, theFileInfo: TColStd_IndexedDataMapOfStringString, theProgress: Message_ProgressRange) -> bool: ...
    @overload
    def Perform(self, theDocument: TDocStd_Document, theFileInfo: TColStd_IndexedDataMapOfStringString, theProgress: Message_ProgressRange) -> bool: ...
    def SetColors(self, theToWrite: bool) -> None: ...
    def SetCoordinateSystemConverter(self, theConverter: RWMesh_CoordinateSystemConverter) -> None: ...
    def SetDefaultStyle(self, theStyle: XCAFPrs_Style) -> None: ...
    def SetDoublePrecision(self, theDoublePrec: bool) -> None: ...
    def SetFaceId(self, theSurfId: bool) -> None: ...
    def SetNormals(self, theHasNormals: bool) -> None: ...
    def SetPartId(self, theSurfId: bool) -> None: ...
    def SetTexCoords(self, theHasTexCoords: bool) -> None: ...

class RWPly_ConfigurationNode(DE_ConfigurationNode):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theNode: RWPly_ConfigurationNode) -> None: ...
    def BuildProvider(self) -> DE_Provider: ...
    def CheckContent(self, theBuffer: NCollection_Buffer) -> bool: ...
    def Copy(self) -> DE_ConfigurationNode: ...
    def GetExtensions(self) -> TColStd_ListOfAsciiString: ...
    def GetFormat(self) -> str: ...
    def GetVendor(self) -> str: ...
    def IsExportSupported(self) -> bool: ...
    def IsImportSupported(self) -> bool: ...
    def Load(self, theResource: DE_ConfigurationContext) -> bool: ...
    def Save(self) -> str: ...

class RWPly_PlyWriterContext:
    def __init__(self) -> None: ...
    def Close(self, theIsAborted: Optional[bool] = false) -> bool: ...
    def HasColors(self) -> bool: ...
    def HasNormals(self) -> bool: ...
    def HasSurfaceId(self) -> bool: ...
    def HasTexCoords(self) -> bool: ...
    def IsDoublePrecision(self) -> bool: ...
    def IsOpened(self) -> bool: ...
    def NbWrittenElements(self) -> int: ...
    def NbWrittenVertices(self) -> int: ...
    def SetColors(self, theToWrite: bool) -> None: ...
    def SetDoublePrecision(self, theDoublePrec: bool) -> None: ...
    def SetNormals(self, theHasNormals: bool) -> None: ...
    @overload
    def SetSurfaceId(self, theSurfId: bool) -> None: ...
    @overload
    def SetSurfaceId(self, theSurfId: int) -> None: ...
    def SetTexCoords(self, theHasTexCoords: bool) -> None: ...
    def SetVertexOffset(self, theOffset: int) -> None: ...
    def SurfaceId(self) -> int: ...
    def VertexOffset(self) -> int: ...
    def WriteHeader(self, theNbNodes: int, theNbElems: int, theFileInfo: TColStd_IndexedDataMapOfStringString) -> bool: ...
    def WriteQuad(self, theQuad: Graphic3d_Vec4i) -> bool: ...
    def WriteTriangle(self, theTri: Graphic3d_Vec3i) -> bool: ...
    def WriteVertex(self, thePoint: gp_Pnt, theNorm: Graphic3d_Vec3, theUV: Graphic3d_Vec2, theColor: Graphic3d_Vec4ub) -> bool: ...

class RWPly_Provider(DE_Provider):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theNode: DE_ConfigurationNode) -> None: ...
    def GetFormat(self) -> str: ...
    def GetVendor(self) -> str: ...
    @overload
    def Write(self, thePath: str, theDocument: TDocStd_Document, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theDocument: TDocStd_Document, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theShape: TopoDS_Shape, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theShape: TopoDS_Shape, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...

# harray1 classes
# harray2 classes
# hsequence classes

