# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from openstack.shared_file_system.v2._proxy import Proxy


class SharedFileSystemCloudMixin:
    share: Proxy

    def list_share_availability_zones(self):
        """List all availability zones for the Shared File Systems service.

        :returns: A list of Shared File Systems Availability Zones.
        """
        return list(self.share.availability_zones())
