/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.trinkets;

import com.shatteredpixel.shatteredpixeldungeon.items.trinkets.Trinket;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DimensionalSundial
extends Trinket {
    public static boolean sundialWarned = false;

    public DimensionalSundial() {
        this.image = ItemSpriteSheet.SUNDIAL;
    }

    @Override
    protected int upgradeEnergyCost() {
        return 5;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", (int)(100.0f * (DimensionalSundial.enemySpawnMultiplier(this.buffedLvl()) - 1.0f)));
    }

    public static float spawnMultiplierAtCurrentTime() {
        float spawnMulti = DimensionalSundial.enemySpawnMultiplier();
        if (spawnMulti > 1.0f) {
            Calendar cal = GregorianCalendar.getInstance();
            if (cal.get(11) >= 21 || cal.get(11) <= 6) {
                if (!sundialWarned) {
                    GLog.w(Messages.get(DimensionalSundial.class, "warning", new Object[0]), new Object[0]);
                    sundialWarned = true;
                }
                return spawnMulti;
            }
            return 1.0f;
        }
        return 1.0f;
    }

    public static float enemySpawnMultiplier() {
        return DimensionalSundial.enemySpawnMultiplier(DimensionalSundial.trinketLevel(DimensionalSundial.class));
    }

    public static float enemySpawnMultiplier(int level) {
        if (level == -1) {
            return 1.0f;
        }
        return 1.25f + 0.25f * (float)level;
    }
}

