/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.script.T;
import org.jmol.shape.Mesh;
import org.jmol.shape.Shape;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.StateManager;

public abstract class MeshCollection
extends Shape {
    protected JvxlData jvxlData;
    public int meshCount;
    public Mesh[] meshes = new Mesh[4];
    public Mesh currentMesh;
    public boolean isFixed;
    public int nUnnamed;
    public short colix;
    public boolean explicitID;
    protected String previousMeshID;
    protected Mesh linkedMesh;
    protected int modelIndex;
    protected float displayWithinDistance2;
    protected boolean isDisplayWithinNot;
    protected Lst<P3> displayWithinPoints;
    protected BS bsDisplay;
    public String[] title;
    protected Mesh pickedMesh;
    protected int pickedModel;
    protected int pickedVertex;
    protected T3 pickedPt;
    protected int[] connections;
    protected Map<String, Mesh> htObjects;
    protected int color;
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";

    private Mesh setMesh(String thisID) {
        this.linkedMesh = null;
        if (thisID == null || PT.isWild(thisID)) {
            if (thisID != null) {
                this.previousMeshID = thisID;
            }
            this.currentMesh = null;
            return null;
        }
        this.currentMesh = this.getMesh(thisID);
        if (this.currentMesh == null) {
            this.allocMesh(thisID, null);
        } else if (thisID.equals(PREVIOUS_MESH_ID)) {
            this.linkedMesh = this.currentMesh.linkedMesh;
        }
        if (this.currentMesh.thisID == null) {
            if (this.nUnnamed == 0 || this.getMesh(this.myType + this.nUnnamed) != null) {
                ++this.nUnnamed;
            }
            this.currentMesh.thisID = this.myType + this.nUnnamed;
            if (this.htObjects != null) {
                this.htObjects.put(this.currentMesh.thisID.toUpperCase(), this.currentMesh);
            }
        }
        this.previousMeshID = this.currentMesh.thisID;
        return this.currentMesh;
    }

    public void allocMesh(String thisID, Mesh m) {
        int index = this.meshCount++;
        this.meshes = (Mesh[])AU.ensureLength(this.meshes, this.meshCount * 2);
        this.meshes[index] = m == null ? new Mesh().mesh1(this.vwr, thisID, this.colix, index) : m;
        this.currentMesh = this.meshes[index];
        this.currentMesh.color = this.color;
        this.currentMesh.index = index;
        if (thisID != null && this.htObjects != null) {
            this.htObjects.put(thisID.toUpperCase(), this.currentMesh);
        }
        this.previousMeshID = null;
    }

    public void merge(MeshCollection mc) {
        for (int i = 0; i < mc.meshCount; ++i) {
            if (mc.meshes[i] == null) continue;
            Mesh m = mc.meshes[i];
            Mesh m0 = this.getMesh(m.thisID);
            if (m0 == null) {
                this.allocMesh(m.thisID, m);
                continue;
            }
            this.meshes[m0.index] = m;
            m.index = m0.index;
        }
        this.previousMeshID = null;
        this.currentMesh = null;
    }

    @Override
    public void initShape() {
        this.setMeshColor();
    }

    protected void setMeshColor() {
        this.colix = (short)5;
        this.color = -1;
    }

    protected void setPropMC(String propertyName, Object value, BS bs) {
        if ("init" == propertyName) {
            this.title = null;
            return;
        }
        if ("link" == propertyName) {
            if (this.meshCount >= 2 && this.currentMesh != null) {
                this.currentMesh.linkedMesh = this.meshes[this.meshCount - 2];
            }
            return;
        }
        if ("lattice" == propertyName) {
            if (this.currentMesh != null) {
                this.currentMesh.lattice = (P3)value;
            }
            return;
        }
        if ("symops" == propertyName) {
            if (this.currentMesh != null) {
                this.currentMesh.symops = (M4[])value;
                if (this.currentMesh.symops == null) {
                    return;
                }
                int n = this.currentMesh.symops.length;
                this.currentMesh.symopColixes = new short[n];
                int i = n;
                while (--i >= 0) {
                    this.currentMesh.symopColixes[i] = C.getColix(this.vwr.cm.ce.getArgbMinMax(i + 1, 1.0f, n));
                }
            }
            return;
        }
        if ("variables" == propertyName) {
            if (this.currentMesh != null && this.currentMesh.scriptCommand != null && !this.currentMesh.scriptCommand.startsWith("{")) {
                this.currentMesh.scriptCommand = "{\n" + StateManager.getVariableList((Map)value, 0, false, false) + "\n" + this.currentMesh.scriptCommand;
            }
            return;
        }
        if ("thisID" == propertyName) {
            String id = (String)value;
            this.setMesh(id);
            this.checkExplicit(id);
            return;
        }
        if ("title" == propertyName) {
            this.setTitle(value);
            return;
        }
        if ("delete" == propertyName) {
            this.deleteMesh();
            return;
        }
        if ("reset" == propertyName) {
            String thisID = (String)value;
            if (this.setMesh(thisID) == null) {
                return;
            }
            this.setMesh(thisID);
            return;
        }
        if ("color" == propertyName) {
            if (value == null) {
                return;
            }
            this.colix = C.getColixO(value);
            this.color = (Integer)value;
            if (this.currentMesh != null) {
                this.currentMesh.color = this.color;
            }
            this.setTokenProperty(1765808134, false, false);
            return;
        }
        if ("translucency" == propertyName) {
            this.setTokenProperty(603979967, ((String)value).equals("translucent"), false);
            return;
        }
        if ("hidden" == propertyName) {
            value = (Boolean)value != false ? 1073742334 : 1073742335;
            propertyName = "token";
        }
        if ("token" == propertyName) {
            int tok = (Integer)value;
            int tok2 = 0;
            boolean test = true;
            switch (tok) {
                case 1073741861: 
                case 1073741862: 
                case 1073741938: 
                case 1073741958: 
                case 0x40000088: 
                case 1073741964: 
                case 1073742072: 
                case 1073742182: 
                case 1073742335: 
                case 1112150019: 
                case 1610625028: {
                    break;
                }
                case 1073742334: {
                    test = false;
                    tok = 1073742335;
                    break;
                }
                case 0x4000004A: {
                    tok2 = 1073742018;
                    break;
                }
                case 1073742039: {
                    test = false;
                    tok = 0x4000004A;
                    tok2 = 1073742018;
                    break;
                }
                case 1073742018: {
                    tok2 = 0x4000004A;
                    break;
                }
                case 0x400000E4: {
                    test = false;
                    tok = 1073742018;
                    tok2 = 0x4000004A;
                    break;
                }
                case 1073742042: {
                    test = false;
                    tok = 1112150019;
                    break;
                }
                case 1073742046: {
                    test = false;
                    tok = 1073741938;
                    break;
                }
                case 1073742057: {
                    test = false;
                    tok = 1073741862;
                    break;
                }
                case 1073742060: {
                    test = false;
                    tok = 1073742182;
                    break;
                }
                case 1073742058: {
                    test = false;
                    tok = 0x40000088;
                    break;
                }
                default: {
                    Logger.error("PROBLEM IN MESHCOLLECTION: token? " + T.nameOf(tok));
                }
            }
            this.setTokenProperty(tok, test, false);
            if (tok2 != 0) {
                this.setTokenProperty(tok2, test, true);
            }
            return;
        }
        this.setPropS(propertyName, value, bs);
    }

    protected String[] setTitle(Object value) {
        if (value instanceof String) {
            int nLine = 1;
            String lines = (String)value;
            if (lines.length() > 0) {
                int i = lines.length();
                while (--i >= 0) {
                    if (lines.charAt(i) != '|') continue;
                    ++nLine;
                }
                this.title = new String[nLine];
                nLine = 0;
                int i0 = -1;
                for (int i2 = 0; i2 < lines.length(); ++i2) {
                    if (lines.charAt(i2) != '|') continue;
                    this.title[nLine++] = lines.substring(i0 + 1, i2);
                    i0 = i2;
                }
                this.title[nLine] = lines.substring(i0 + 1);
                return this.title;
            }
            value = null;
        }
        this.title = value == null ? null : (String[])value;
        return this.title;
    }

    protected void checkExplicit(String id) {
        if (this.explicitID) {
            return;
        }
        boolean bl = this.explicitID = id != null && !id.equals(PREVIOUS_MESH_ID);
        if (this.explicitID) {
            this.previousMeshID = id;
        }
    }

    protected void setTokenProperty(int tokProp, boolean bProp, boolean testD) {
        if (tokProp == 1073742072) {
            if (this.meshCount == 0) {
                return;
            }
            for (int i = 0; i < this.meshCount; ++i) {
                this.meshes[i].visible = false;
            }
            tokProp = 1073742335;
        }
        if (this.currentMesh == null) {
            String key = this.explicitID && PT.isWild(this.previousMeshID) ? this.previousMeshID : null;
            Lst<Mesh> list = this.getMeshList(key, false);
            int i = list.size();
            while (--i >= 0) {
                this.setMeshTokenProperty((Mesh)list.get(i), tokProp, bProp, testD);
            }
            if (list.size() == 1) {
                this.currentMesh = (Mesh)list.get(0);
            }
        } else {
            this.setMeshTokenProperty(this.currentMesh, tokProp, bProp, testD);
            if (this.linkedMesh != null) {
                this.setMeshTokenProperty(this.linkedMesh, tokProp, bProp, testD);
            }
        }
    }

    private void setMeshTokenProperty(Mesh m, int tokProp, boolean bProp, boolean testD) {
        if (testD && (!m.havePlanarContours || m.drawTriangles == m.showContourLines)) {
            return;
        }
        switch (tokProp) {
            case 1610625028: {
                m.bsDisplay = this.bsDisplay;
                if (this.bsDisplay == null && this.displayWithinPoints != null) {
                    m.setShowWithin(this.displayWithinPoints, this.displayWithinDistance2, this.isDisplayWithinNot);
                }
                return;
            }
            case 1073742335: {
                m.visible = bProp;
                return;
            }
            case 1765808134: {
                m.colix = this.colix;
                return;
            }
            case 603979967: {
                m.setTranslucent(bProp, this.translucentLevel);
                if (bProp && m.bsSlabGhost != null) {
                    m.resetSlab();
                }
                return;
            }
        }
        m.setTokenProperty(tokProp, bProp);
    }

    protected boolean getPropDataMC(String property, Object[] data) {
        Mesh m;
        if (property == "keys") {
            Lst keys = data[1] instanceof Lst ? (Lst)data[1] : new Lst();
            data[1] = keys;
            keys.addLast("count");
            keys.addLast("getCenter");
        }
        if (property == "getNames") {
            Map map = (Map)data[0];
            boolean withDollar = (Boolean)data[1];
            int i = this.meshCount;
            while (--i >= 0) {
                if (this.meshes[i] == null || this.meshes[i].vc == 0) continue;
                map.put((withDollar ? "$" : "") + this.meshes[i].thisID, T.tokenOr);
            }
            return true;
        }
        if (property == "getVertices") {
            m = this.getMesh((String)data[0]);
            if (m == null) {
                return false;
            }
            data[1] = m.vs;
            data[2] = m.getVisibleVertexBitSet();
            return true;
        }
        if (property == "points") {
            m = this.getMesh((String)data[0]);
            if (m == null) {
                return false;
            }
            BS bs = m.getVisibleVertexBitSet();
            P3[] pts = new P3[bs.cardinality()];
            int p = 0;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                pts[p++] = (P3)m.vs[i];
                i = bs.nextSetBit(i + 1);
            }
            data[1] = pts;
            return true;
        }
        if (property == "checkID") {
            Mesh m2;
            String key = (String)data[0];
            Lst<Mesh> list = this.getMeshList(key, true);
            if (list.size() == 0 || (m2 = (Mesh)list.get(0)) == null) {
                return false;
            }
            data[1] = m2.thisID;
            return true;
        }
        if (property == "index") {
            m = this.getMesh((String)data[0]);
            data[1] = m == null ? -1 : m.index;
            return true;
        }
        if (property == "getCenter") {
            String id = (String)data[0];
            int index = (Integer)data[1];
            Mesh m3 = this.getMesh(id);
            if (m3 == null || m3.vs == null) {
                return false;
            }
            data[2] = index == Integer.MAX_VALUE ? P3.new3(m3.index + 1, this.meshCount, m3.vc) : m3.vs[m3.getVertexIndexFromNumber(index)];
            return true;
        }
        return this.getPropShape(property, data);
    }

    protected Lst<Mesh> getMeshList(String key, boolean justOne) {
        Lst<Mesh> list = new Lst<Mesh>();
        if (key != null) {
            key = key.length() == 0 ? null : key.toUpperCase();
        }
        boolean isWild = PT.isWild(key);
        int i = this.meshCount;
        while (--i >= 0) {
            String id;
            if (key != null && !(id = this.meshes[i].thisID.toUpperCase()).equals(key) && (!isWild || !PT.isMatch(id, key, true, true))) continue;
            list.addLast(this.meshes[i]);
            if (!justOne) continue;
            break;
        }
        return list;
    }

    protected Object getPropMC(String property, int index) {
        Mesh m = this.currentMesh;
        if (index >= 0 && (index >= this.meshCount || (m = this.meshes[index]) == null)) {
            return null;
        }
        if (property == "count") {
            int n = 0;
            for (int i = 0; i < this.meshCount; ++i) {
                m = this.meshes[i];
                if (m == null || m.vc <= 0) continue;
                ++n;
            }
            return n;
        }
        if (property == "bsVertices") {
            if (m == null) {
                return null;
            }
            Lst<Object> lst = new Lst<Object>();
            lst.addLast(m.vs);
            lst.addLast(m.getVisibleVBS());
            return lst;
        }
        if (property == "ID") {
            return m == null ? null : m.thisID;
        }
        if (property.startsWith("list")) {
            boolean isNamed;
            this.clean();
            SB sb = new SB();
            int k = 0;
            boolean bl = isNamed = property.length() > 5;
            String id = property.equals("list") ? null : (isNamed ? property.substring(5) : (m == null ? null : m.thisID));
            for (int i = 0; i < this.meshCount; ++i) {
                Object info;
                m = this.meshes[i];
                if (id != null && !id.equalsIgnoreCase(m.thisID)) continue;
                sb.appendI(++k).append(" id:" + m.thisID).append("; model:" + this.vwr.getModelNumberDotted(m.modelIndex)).append("; vertices:" + m.vc).append("; polygons:" + m.pc).append("; visible:" + m.visible);
                float[] range = (float[])this.getProperty("dataRange", 0);
                if (range != null) {
                    sb.append("; dataRange:").append(Escape.eAF(range));
                }
                if (m.title != null) {
                    String s = "";
                    for (int j = 0; j < m.title.length; ++j) {
                        s = s + (j == 0 ? "; title:" : " | ") + m.title[j];
                    }
                    if (s.length() > 10000) {
                        s = s.substring(0, 10000) + "...";
                    }
                    sb.append(s);
                }
                sb.appendC('\n');
                if (!isNamed || (info = this.getProperty("jvxlFileInfo", 0)) == null) continue;
                sb.append((String)info).appendC('\n');
            }
            return sb.toString();
        }
        if (property == "values") {
            return this.getValues(m);
        }
        if (property == "vertices") {
            return this.getVertices(m);
        }
        if (property == "info") {
            if (m == null) {
                return null;
            }
            Map info = (Map)m.getInfo(false);
            if (info != null && this.jvxlData != null) {
                String ss = this.jvxlData.jvxlFileTitle;
                if (ss != null) {
                    info.put("jvxlFileTitle", ss.trim());
                }
                if ((ss = this.jvxlData.jvxlFileSource) != null) {
                    info.put("jvxlFileSource", ss);
                }
                if ((ss = this.jvxlData.jvxlFileMessage) != null) {
                    info.put("jvxlFileMessage", ss.trim());
                }
            }
            return info;
        }
        if (property == "data") {
            return m == null ? null : m.getInfo(true);
        }
        return null;
    }

    protected Object getValues(Mesh mesh) {
        return mesh == null ? null : mesh.vvs;
    }

    protected Object getVertices(Mesh mesh) {
        return mesh == null ? null : mesh.vs;
    }

    protected void clean() {
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i] != null && this.meshes[i].vc != 0) continue;
            this.deleteMeshI(i);
        }
    }

    private void deleteMesh() {
        if (this.explicitID && this.currentMesh != null) {
            this.deleteMeshI(this.currentMesh.index);
        } else {
            this.deleteMeshKey(this.explicitID && this.previousMeshID != null && PT.isWild(this.previousMeshID) ? this.previousMeshID : null);
        }
        this.currentMesh = null;
    }

    protected void deleteMeshKey(String key) {
        if (key == null || key.length() == 0) {
            int i = this.meshCount;
            while (--i >= 0) {
                this.meshes[i] = null;
            }
            this.meshCount = 0;
            this.nUnnamed = 0;
            if (this.htObjects != null) {
                this.htObjects.clear();
            }
        } else {
            Lst<Mesh> list = this.getMeshList(key, false);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.deleteMeshI(((Mesh)list.get((int)i)).index);
            }
        }
    }

    public void deleteMeshI(int i) {
        if (this.htObjects != null) {
            this.htObjects.remove(this.meshes[i].thisID.toUpperCase());
        }
        for (int j = i + 1; j < this.meshCount; ++j) {
            this.meshes[--this.meshes[j].index] = this.meshes[j];
        }
        this.meshes[--this.meshCount] = null;
    }

    protected void resetObjects() {
        this.htObjects.clear();
        int i = 0;
        while (i < this.meshCount) {
            Mesh m = this.meshes[i];
            m.index = i++;
            this.htObjects.put(m.thisID.toUpperCase(), m);
        }
    }

    public Mesh getMesh(String thisID) {
        int i = this.getIndexFromName(thisID);
        return i < 0 ? null : this.meshes[i];
    }

    @Override
    public int getIndexFromName(String id) {
        if (PREVIOUS_MESH_ID.equals(id)) {
            return this.previousMeshID == null ? this.meshCount - 1 : this.getIndexFromName(this.previousMeshID);
        }
        if (PT.isWild(id)) {
            Lst<Mesh> list = this.getMeshList(id, true);
            return list.size() == 0 ? -1 : ((Mesh)list.get((int)0)).index;
        }
        if (this.htObjects != null) {
            Mesh m = this.htObjects.get(id.toUpperCase());
            return m == null ? -1 : m.index;
        }
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i] == null || this.meshes[i].vc == 0 || !id.equalsIgnoreCase(this.meshes[i].thisID)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setModelVisibilityFlags(BS bsModels) {
        BS bsDeleted = this.vwr.slm.bsDeleted;
        int i = this.meshCount;
        while (--i >= 0) {
            Mesh mesh = this.meshes[i];
            mesh.visibilityFlags = mesh.visible && mesh.isValid && (mesh.modelIndex < 0 || bsModels.get(mesh.modelIndex) && (mesh.atomIndex < 0 || !this.ms.isAtomHidden(mesh.atomIndex) && (bsDeleted == null || !bsDeleted.get(mesh.atomIndex)))) ? this.vf : 0;
        }
    }

    protected void setStatusPicked(int flag, T3 v, Map<String, Object> map) {
        this.vwr.setStatusAtomPicked(flag, "[\"" + this.myType + "\"," + PT.esc(this.pickedMesh.thisID) + "," + this.pickedModel + "," + this.pickedVertex + "," + v.x + "," + v.y + "," + v.z + "," + (this.pickedMesh.title == null ? "\"\"" : PT.esc(this.pickedMesh.title[0])) + "]", map, false);
    }

    protected Map<String, Object> getPickedPoint(T3 v, int modelIndex) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (v != null) {
            map.put("pt", v);
            map.put("modelIndex", modelIndex);
            map.put("model", this.vwr.getModelNumberDotted(modelIndex));
            map.put("id", this.pickedMesh.thisID);
            map.put("vertex", this.pickedVertex + 1);
            map.put("type", this.myType);
        }
        return map;
    }
}

