/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.NullValueProvider;
import net.sf.sdedit.util.UIUtilities;
import net.sf.sdedit.util.Utilities;

public abstract class Configurator<T, C extends DataObject>
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 5822209294034960581L;
    protected static JFileChooser _fileChooser;
    protected static Set<String> fileTypes;
    private static FileFilter fileFilter;
    private Bean<C> bean;
    private PropertyDescriptor property;
    private String[] dependentProperty;
    private String[] dependentValue;
    private boolean[] isDependencyEquality;
    private volatile boolean isPerformingAction;

    protected static JFileChooser fileChooser() {
        if (_fileChooser == null) {
            _fileChooser = new JFileChooser(System.getProperty("user.home"));
            _fileChooser.setFileSelectionMode(2);
            _fileChooser.setMultiSelectionEnabled(true);
        }
        return _fileChooser;
    }

    public void addFileTypes(String ... types) {
        for (String type : types) {
            fileTypes.add(type.toLowerCase());
        }
        if (Configurator.fileChooser().getChoosableFileFilters().length == 1) {
            Configurator.fileChooser().addChoosableFileFilter(fileFilter);
        }
    }

    public void removeFileTypes(String ... types) {
        for (String type : types) {
            fileTypes.remove(type.toLowerCase());
        }
        if (fileTypes.isEmpty()) {
            Configurator.fileChooser().resetChoosableFileFilters();
            Configurator.fileChooser().setFileFilter(Configurator.fileChooser().getAcceptAllFileFilter());
        }
    }

    protected Configurator(Bean<C> bean, PropertyDescriptor property) {
        this.bean = bean;
        this.property = property;
        this.isPerformingAction = false;
        Adjustable adj = property.getWriteMethod().getAnnotation(Adjustable.class);
        if (!adj.depends().equals("")) {
            String[] dependencies = adj.depends().split(",");
            int n = dependencies.length;
            this.dependentProperty = new String[n];
            this.dependentValue = new String[n];
            this.isDependencyEquality = new boolean[n];
            for (int i = 0; i < n; ++i) {
                String dependency = dependencies[i];
                int eq = dependency.indexOf(61);
                if (eq == -1) {
                    this.isDependencyEquality[i] = dependency.charAt(0) != '!';
                    this.dependentProperty[i] = this.isDependencyEquality[i] ? dependency : dependency.substring(1);
                    this.dependentValue[i] = null;
                    continue;
                }
                this.isDependencyEquality[i] = dependency.charAt(eq - 1) != '!';
                this.dependentProperty[i] = this.isDependencyEquality[i] ? dependency.substring(0, eq) : dependency.substring(0, eq - 1);
                this.dependentValue[i] = dependency.substring(eq + 1);
            }
        }
        bean.addPropertyChangeListener(this);
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.property;
    }

    public int getLabelWidth() {
        return -1;
    }

    public void setLabelWidth(int width) {
    }

    protected abstract void refresh(T var1);

    protected T getNullValue() {
        return (T)NullValueProvider.getNullValue(this.property.getPropertyType());
    }

    public boolean isDependencySatisfied() {
        if (this.dependentProperty == null) {
            return true;
        }
        for (int i = 0; i < this.dependentProperty.length; ++i) {
            Object val = this.bean.getValue(this.dependentProperty[i]);
            boolean sat = this.dependentValue[i] == null ? (val == null ? false : (val.getClass().isArray() ? Array.getLength(val) > 0 : (val instanceof String ? ((String)val).trim().length() > 0 : true))) : this.dependentValue[i].equals(String.valueOf(val));
            if (!this.isDependencyEquality[i]) {
                boolean bl = sat = !sat;
            }
            if (sat) continue;
            return false;
        }
        return true;
    }

    public abstract void focus();

    public void setBean(Bean<C> bean) {
        this.bean = bean;
        bean.addPropertyChangeListener(this);
        this.refresh();
    }

    public Bean<C> getBean() {
        return this.bean;
    }

    public PropertyDescriptor getProperty() {
        return this.property;
    }

    public void refresh() {
        this.refresh(this.getValue());
        this.setEnabled(this.isDependencySatisfied());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(this.property.getName())) {
            this.refresh(evt.getNewValue());
        }
        this.setEnabled(this.isDependencySatisfied());
    }

    protected void applyValue(T value) {
        this.bean.setValue(this.property, value);
    }

    protected T getValue() {
        Object value = this.getBean().getValue(this.getProperty().getName());
        return (T)(value != null ? value : this.getNullValue());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._setEnabled(enabled);
        for (Component comp : this.getComponents()) {
            comp.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
        for (Component comp : UIUtilities.getDescendants(this)) {
            UIUtilities.setEditable(comp, editable);
        }
    }

    @Override
    public void setToolTipText(String tooltip) {
        super.setToolTipText(tooltip);
        for (Component comp : UIUtilities.getDescendants(this)) {
            if (!(comp instanceof JComponent)) continue;
            ((JComponent)comp).setToolTipText(tooltip);
        }
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        if (!this.isPerformingAction) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Configurator.this.isPerformingAction = true;
                    try {
                        Configurator.this._actionPerformed(e);
                    }
                    finally {
                        Configurator.this.isPerformingAction = false;
                    }
                }
            });
        }
    }

    protected Adjustable getAdjustable() {
        return this.property.getWriteMethod().getAnnotation(Adjustable.class);
    }

    protected abstract void _actionPerformed(ActionEvent var1);

    protected abstract void _setEnabled(boolean var1);

    static {
        fileTypes = new TreeSet<String>();
        fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName().toLowerCase();
                int c = name.lastIndexOf(46);
                if (c == -1) {
                    return false;
                }
                return fileTypes.contains(name.substring(c + 1));
            }

            @Override
            public String getDescription() {
                return Utilities.join(",", fileTypes);
            }
        };
    }
}

