// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_VIDEOINFO_H
#define _GSTREAMERMM_VIDEOINFO_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <gstreamermm/caps.h>
#include <gstreamermm/videoformat.h>
#include <gstreamermm/format.h>
#include <gstreamermm/videochroma.h>
#include <gst/video/video-info.h>
 

namespace Gst
{

  /** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var VideoInterlaceMode VIDEO_INTERLACE_MODE_PROGRESSIVE
 * All frames are progressive.
 * 
 *  @var VideoInterlaceMode VIDEO_INTERLACE_MODE_INTERLEAVED
 * 2 fields are interleaved in one video
 * frame. Extra buffer flags describe the field order.
 * 
 *  @var VideoInterlaceMode VIDEO_INTERLACE_MODE_MIXED
 * Frames contains both interlaced and
 * progressive video, the buffer flags describe the frame and fields.
 * 
 *  @var VideoInterlaceMode VIDEO_INTERLACE_MODE_FIELDS
 * 2 fields are stored in one buffer, use the
 * frame ID to get access to the required field. For multiview (the
 * 'views' property > 1) the fields of view N can be found at frame ID
 * (N * 2) and (N * 2) + 1.
 * Each field has only half the amount of lines as noted in the
 * height property. This mode requires multiple GstVideoMeta metadata
 * to describe the fields.
 * 
 *  @enum VideoInterlaceMode
 * 
 * The possible values of the Gst::VideoInterlaceMode describing the interlace
 * mode of the stream.
 *
 * @ingroup gstreamermmEnums
 */
enum VideoInterlaceMode
{
  VIDEO_INTERLACE_MODE_PROGRESSIVE,
  VIDEO_INTERLACE_MODE_INTERLEAVED,
  VIDEO_INTERLACE_MODE_MIXED,
  VIDEO_INTERLACE_MODE_FIELDS
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::VideoInterlaceMode> : public Glib::Value_Enum<Gst::VideoInterlaceMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

  /** 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_NONE
 * A special value indicating
 * no multiview information. Used in GstVideoInfo and other places to
 * indicate that no specific multiview handling has been requested or
 * provided. This value is never carried on caps.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_MONO
 * All frames are monoscopic.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_LEFT
 * All frames represent a left-eye view.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_RIGHT
 * All frames represent a right-eye view.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE
 * Left and right eye views are
 * provided in the left and right half of the frame respectively.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE_QUINCUNX
 * Left and right eye
 * views are provided in the left and right half of the frame, but
 * have been sampled using quincunx method, with half-pixel offset
 * between the 2 views.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_COLUMN_INTERLEAVED
 * Alternating vertical
 * columns of pixels represent the left and right eye view respectively.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_ROW_INTERLEAVED
 * Alternating horizontal
 * rows of pixels represent the left and right eye view respectively.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_TOP_BOTTOM
 * The top half of the frame
 * contains the left eye, and the bottom half the right eye.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_CHECKERBOARD
 * Pixels are arranged with
 * alternating pixels representing left and right eye views in a
 * checkerboard fashion.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_FRAME_BY_FRAME
 * Left and right eye views
 * are provided in separate frames alternately.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_MULTIVIEW_FRAME_BY_FRAME
 * Multiple
 * independent views are provided in separate frames in sequence.
 * This method only applies to raw video buffers at the moment.
 * Specific view identification is via the Gst::VideoMultiviewMeta
 * and Gst::VideoMeta(s) on raw video buffers.
 * 
 *  @var VideoMultiviewMode VIDEO_MULTIVIEW_MODE_SEPARATED
 * Multiple views are
 * provided as separate Gst::Memory framebuffers attached to each
 * Gst::Buffer, described by the Gst::VideoMultiviewMeta
 * and Gst::VideoMeta(s).
 * 
 *  @enum VideoMultiviewMode
 * 
 * All possible stereoscopic 3D and multiview representations.
 * In conjunction with Gst::VideoMultiviewFlags, describes how
 * multiview content is being transported in the stream.
 *
 * @ingroup gstreamermmEnums
 */
enum VideoMultiviewMode
{
  VIDEO_MULTIVIEW_MODE_NONE = -1,
  VIDEO_MULTIVIEW_MODE_MONO = 0,
  VIDEO_MULTIVIEW_MODE_LEFT = 1,
  VIDEO_MULTIVIEW_MODE_RIGHT = 2,
  VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE = 3,
  VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE_QUINCUNX = 4,
  VIDEO_MULTIVIEW_MODE_COLUMN_INTERLEAVED = 5,
  VIDEO_MULTIVIEW_MODE_ROW_INTERLEAVED = 6,
  VIDEO_MULTIVIEW_MODE_TOP_BOTTOM = 7,
  VIDEO_MULTIVIEW_MODE_CHECKERBOARD = 8,
  VIDEO_MULTIVIEW_MODE_FRAME_BY_FRAME = 32,
  VIDEO_MULTIVIEW_MODE_MULTIVIEW_FRAME_BY_FRAME = 33,
  VIDEO_MULTIVIEW_MODE_SEPARATED = 34
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::VideoMultiviewMode> : public Glib::Value_Enum<Gst::VideoMultiviewMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

  /** 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_NONE
 * A special value indicating
 * no frame packing info.
 * 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_MONO
 * All frames are monoscopic.
 * 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_LEFT
 * All frames represent a left-eye view.
 * 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_RIGHT
 * All frames represent a right-eye view.
 * 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE
 * Left and right eye views are
 * provided in the left and right half of the frame respectively.
 * 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE_QUINCUNX
 * Left and right eye
 * views are provided in the left and right half of the frame, but
 * have been sampled using quincunx method, with half-pixel offset
 * between the 2 views.
 * 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_COLUMN_INTERLEAVED
 * Alternating vertical
 * columns of pixels represent the left and right eye view respectively.
 * 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_ROW_INTERLEAVED
 * Alternating horizontal
 * rows of pixels represent the left and right eye view respectively.
 * 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_TOP_BOTTOM
 * The top half of the frame
 * contains the left eye, and the bottom half the right eye.
 * 
 *  @var VideoMultiviewFramePacking VIDEO_MULTIVIEW_FRAME_PACKING_CHECKERBOARD
 * Pixels are arranged with
 * alternating pixels representing left and right eye views in a
 * checkerboard fashion.
 * 
 *  @enum VideoMultiviewFramePacking
 * 
 * Gst::VideoMultiviewFramePacking represents the subset of Gst::VideoMultiviewMode
 * values that can be applied to any video frame without needing extra metadata.
 * It can be used by elements that provide a property to override the
 * multiview interpretation of a video stream when the video doesn't contain
 * any markers.
 * 
 * This enum is used (for example) on playbin, to re-interpret a played
 * video stream as a stereoscopic video. The individual enum values are
 * equivalent to and have the same value as the matching Gst::VideoMultiviewMode.
 *
 * @ingroup gstreamermmEnums
 */
enum VideoMultiviewFramePacking
{
  VIDEO_MULTIVIEW_FRAME_PACKING_NONE = -1,
  VIDEO_MULTIVIEW_FRAME_PACKING_MONO,
  VIDEO_MULTIVIEW_FRAME_PACKING_LEFT,
  VIDEO_MULTIVIEW_FRAME_PACKING_RIGHT,
  VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE,
  VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE_QUINCUNX,
  VIDEO_MULTIVIEW_FRAME_PACKING_COLUMN_INTERLEAVED,
  VIDEO_MULTIVIEW_FRAME_PACKING_ROW_INTERLEAVED,
  VIDEO_MULTIVIEW_FRAME_PACKING_TOP_BOTTOM,
  VIDEO_MULTIVIEW_FRAME_PACKING_CHECKERBOARD
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::VideoMultiviewFramePacking> : public Glib::Value_Enum<Gst::VideoMultiviewFramePacking>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

  /** 
 *  @var VideoMultiviewFlags VIDEO_MULTIVIEW_FLAGS_NONE
 * No flags.
 * 
 *  @var VideoMultiviewFlags VIDEO_MULTIVIEW_FLAGS_RIGHT_VIEW_FIRST
 * For stereo streams, the
 * normal arrangement of left and right views is reversed.
 * 
 *  @var VideoMultiviewFlags VIDEO_MULTIVIEW_FLAGS_LEFT_FLIPPED
 * The left view is vertically
 * mirrored.
 * 
 *  @var VideoMultiviewFlags VIDEO_MULTIVIEW_FLAGS_LEFT_FLOPPED
 * The left view is horizontally
 * mirrored.
 * 
 *  @var VideoMultiviewFlags VIDEO_MULTIVIEW_FLAGS_RIGHT_FLIPPED
 * The right view is
 * vertically mirrored.
 * 
 *  @var VideoMultiviewFlags VIDEO_MULTIVIEW_FLAGS_RIGHT_FLOPPED
 * The right view is
 * horizontally mirrored.
 * 
 *  @var VideoMultiviewFlags VIDEO_MULTIVIEW_FLAGS_HALF_ASPECT
 * For frame-packed
 * multiview modes, indicates that the individual
 * views have been encoded with half the true width or height
 * and should be scaled back up for display. This flag
 * is used for overriding input layout interpretation
 * by adjusting pixel-aspect-ratio.
 * For side-by-side, column interleaved or checkerboard packings, the
 * pixel width will be doubled. For row interleaved and top-bottom
 * encodings, pixel height will be doubled.
 * 
 *  @var VideoMultiviewFlags VIDEO_MULTIVIEW_FLAGS_MIXED_MONO
 * The video stream contains both
 * mono and multiview portions, signalled on each buffer by the
 * absence or presence of the @a GST_VIDEO_BUFFER_FLAG_MULTIPLE_VIEW
 * buffer flag.
 * 
 *  @enum VideoMultiviewFlags
 * 
 * GstVideoMultiviewFlags are used to indicate extra properties of a
 * stereo/multiview stream beyond the frame layout and buffer mapping
 * that is conveyed in the Gst::MultiviewMode.
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%VideoMultiviewFlags operator|(VideoMultiviewFlags, VideoMultiviewFlags)</tt><br>
 * <tt>%VideoMultiviewFlags operator&(VideoMultiviewFlags, VideoMultiviewFlags)</tt><br>
 * <tt>%VideoMultiviewFlags operator^(VideoMultiviewFlags, VideoMultiviewFlags)</tt><br>
 * <tt>%VideoMultiviewFlags operator~(VideoMultiviewFlags)</tt><br>
 * <tt>%VideoMultiviewFlags& operator|=(VideoMultiviewFlags&, VideoMultiviewFlags)</tt><br>
 * <tt>%VideoMultiviewFlags& operator&=(VideoMultiviewFlags&, VideoMultiviewFlags)</tt><br>
 * <tt>%VideoMultiviewFlags& operator^=(VideoMultiviewFlags&, VideoMultiviewFlags)</tt><br>
 */
enum VideoMultiviewFlags
{
  VIDEO_MULTIVIEW_FLAGS_NONE = 0x0,
  VIDEO_MULTIVIEW_FLAGS_RIGHT_VIEW_FIRST = (1 << 0),
  VIDEO_MULTIVIEW_FLAGS_LEFT_FLIPPED = (1 << 1),
  VIDEO_MULTIVIEW_FLAGS_LEFT_FLOPPED = (1 << 2),
  VIDEO_MULTIVIEW_FLAGS_RIGHT_FLIPPED = (1 << 3),
  VIDEO_MULTIVIEW_FLAGS_RIGHT_FLOPPED = (1 << 4),
  VIDEO_MULTIVIEW_FLAGS_HALF_ASPECT = (1 << 14),
  VIDEO_MULTIVIEW_FLAGS_MIXED_MONO = (1 << 15)
};

/** @ingroup gstreamermmEnums */
inline VideoMultiviewFlags operator|(VideoMultiviewFlags lhs, VideoMultiviewFlags rhs)
  { return static_cast<VideoMultiviewFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoMultiviewFlags operator&(VideoMultiviewFlags lhs, VideoMultiviewFlags rhs)
  { return static_cast<VideoMultiviewFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoMultiviewFlags operator^(VideoMultiviewFlags lhs, VideoMultiviewFlags rhs)
  { return static_cast<VideoMultiviewFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoMultiviewFlags operator~(VideoMultiviewFlags flags)
  { return static_cast<VideoMultiviewFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline VideoMultiviewFlags& operator|=(VideoMultiviewFlags& lhs, VideoMultiviewFlags rhs)
  { return (lhs = static_cast<VideoMultiviewFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline VideoMultiviewFlags& operator&=(VideoMultiviewFlags& lhs, VideoMultiviewFlags rhs)
  { return (lhs = static_cast<VideoMultiviewFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline VideoMultiviewFlags& operator^=(VideoMultiviewFlags& lhs, VideoMultiviewFlags rhs)
  { return (lhs = static_cast<VideoMultiviewFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::VideoMultiviewFlags> : public Glib::Value_Flags<Gst::VideoMultiviewFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

  /** 
 *  @var VideoFlags VIDEO_FLAG_NONE
 * No flags.
 * 
 *  @var VideoFlags VIDEO_FLAG_VARIABLE_FPS
 * A variable fps is selected, fps_n and fps_d
 * denote the maximum fps of the video.
 * 
 *  @var VideoFlags VIDEO_FLAG_PREMULTIPLIED_ALPHA
 * Each color has been scaled by the alpha
 * value.
 * 
 *  @enum VideoFlags
 * 
 * Extra video flags
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%VideoFlags operator|(VideoFlags, VideoFlags)</tt><br>
 * <tt>%VideoFlags operator&(VideoFlags, VideoFlags)</tt><br>
 * <tt>%VideoFlags operator^(VideoFlags, VideoFlags)</tt><br>
 * <tt>%VideoFlags operator~(VideoFlags)</tt><br>
 * <tt>%VideoFlags& operator|=(VideoFlags&, VideoFlags)</tt><br>
 * <tt>%VideoFlags& operator&=(VideoFlags&, VideoFlags)</tt><br>
 * <tt>%VideoFlags& operator^=(VideoFlags&, VideoFlags)</tt><br>
 */
enum VideoFlags
{
  VIDEO_FLAG_NONE = 0x0,
  VIDEO_FLAG_VARIABLE_FPS = (1 << 0),
  VIDEO_FLAG_PREMULTIPLIED_ALPHA = (1 << 1)
};

/** @ingroup gstreamermmEnums */
inline VideoFlags operator|(VideoFlags lhs, VideoFlags rhs)
  { return static_cast<VideoFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoFlags operator&(VideoFlags lhs, VideoFlags rhs)
  { return static_cast<VideoFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoFlags operator^(VideoFlags lhs, VideoFlags rhs)
  { return static_cast<VideoFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoFlags operator~(VideoFlags flags)
  { return static_cast<VideoFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline VideoFlags& operator|=(VideoFlags& lhs, VideoFlags rhs)
  { return (lhs = static_cast<VideoFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline VideoFlags& operator&=(VideoFlags& lhs, VideoFlags rhs)
  { return (lhs = static_cast<VideoFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline VideoFlags& operator^=(VideoFlags& lhs, VideoFlags rhs)
  { return (lhs = static_cast<VideoFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::VideoFlags> : public Glib::Value_Flags<Gst::VideoFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


/** Information describing image properties. This information can be filled
 * in from Gst::Caps with from_caps(). The information is also used
 * to store the specific video info when mapping a video frame with
 * VideoFrame::map().
 *
 * Last reviewed on 2016-09-14 (1.8.0).
 */
class VideoInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = VideoInfo;
  using BaseObjectType = GstVideoInfo;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  VideoInfo();
  VideoInfo(const VideoInfo& other);
  VideoInfo& operator=(const VideoInfo& other);

  /** This constructor allows to wrap both dynamic and static allocated
    * GstVideoInfo object. If castitem is either static allocated or
    * dynamic allocated, but will be freed somewhere else, @a take_ownership
    * should be set to false. If @a take_ownership is set to true, castitem
    * is freed in VideoInfo destructor.
    */
  VideoInfo(GstVideoInfo* castitem, bool take_ownership);
  ~VideoInfo();

  GstVideoInfo* gobj() { return gobject_; }
  const GstVideoInfo* gobj() const { return gobject_; }

  
  /** Initialize @a info with default values.
   */
  void init();
  
  /** Set the default info for a video frame of @a format and @a width and @a height.
   * 
   * @note This initializes @a info first, no values are preserved. This function
   * does not set the offsets correctly for interlaced vertically
   * subsampled formats.
   * 
   * @param format The format.
   * @param width A width.
   * @param height A height.
   */
  void set_format(Gst::VideoFormat format, guint width, guint height);
  
  /** Parse @a caps and update @a info.
   * 
   * @param caps A Gst::Caps.
   * @return <tt>true</tt> if @a caps could be parsed.
   */
  bool from_caps(const Glib::RefPtr<const Gst::Caps>& caps);
  
  /** Convert the values of @a info into a Gst::Caps.
   * 
   * @return A new Gst::Caps containing the info of @a info.
   */
  Glib::RefPtr<Gst::Caps> to_caps() const;;
  
  /** Converts among various Gst::Format types.  This function handles
   * GST_FORMAT_BYTES, GST_FORMAT_TIME, and GST_FORMAT_DEFAULT.  For
   * raw video, GST_FORMAT_DEFAULT corresponds to video frames.  This
   * function can be used to handle pad queries of the type GST_QUERY_CONVERT.
   * 
   * @param src_format Gst::Format of the @a src_value.
   * @param src_value Value to convert.
   * @param dest_format Gst::Format of the @a dest_value.
   * @param dest_value Pointer to destination value.
   * @return <tt>true</tt> if the conversion was successful.
   */
  bool convert(Gst::Format src_format, gint64 src_value, Gst::Format dest_format, gint64& dest_value);
  
  /** Compares two Gst::VideoInfo and returns whether they are equal or not
   * 
   * @param other A Gst::VideoInfo.
   * @return <tt>true</tt> if @a info and @a other are equal, else <tt>false</tt>.
   */
  bool is_equal(const Gst::VideoInfo& other) const;

  const VideoFormatInfo get_finfo() const;
  
  Gst::VideoInterlaceMode get_interlace_mode() const;
  void set_interlace_mode(const Gst::VideoInterlaceMode& value);
  
  Gst::VideoFlags get_flags() const;
  void set_flags(const Gst::VideoFlags& value);
  
  gint get_width() const;
  void set_width(const gint& value);
  
  gint get_height() const;
  void set_height(const gint& value);
  
  gsize get_size() const;
  void set_size(const gsize& value);
  
  gint get_views() const;
  void set_views(const gint& value);
  
  Gst::VideoChromaSite get_chroma_site() const;
  void set_chroma_site(const Gst::VideoChromaSite& value);
  
  gint get_par_n() const;
  void set_par_n(const gint& value);
  
  gint get_par_d() const;
  void set_par_d(const gint& value);
  
  gint get_fps_n() const;
  void set_fps_n(const gint& value);
  
  gint get_fps_d() const;
  void set_fps_d(const gint& value);
  
  Gst::VideoMultiviewMode get_multiview_mode() const;
  void set_multiview_mode(const Gst::VideoMultiviewMode& value);
  
  Gst::VideoMultiviewFlags get_multiview_flags() const;
  void set_multiview_flags(const Gst::VideoMultiviewFlags& value);

private:
  GstVideoInfo* gobject_;
  bool take_ownership;


};

}


#endif /* _GSTREAMERMM_VIDEOINFO_H */

