import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { ListTypeVersionsInput, ListTypeVersionsOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ListTypeVersionsCommand}.
 */
export interface ListTypeVersionsCommandInput extends ListTypeVersionsInput {
}
/**
 * @public
 *
 * The output of {@link ListTypeVersionsCommand}.
 */
export interface ListTypeVersionsCommandOutput extends ListTypeVersionsOutput, __MetadataBearer {
}
declare const ListTypeVersionsCommand_base: {
    new (input: ListTypeVersionsCommandInput): import("@smithy/smithy-client").CommandImpl<ListTypeVersionsCommandInput, ListTypeVersionsCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [ListTypeVersionsCommandInput]): import("@smithy/smithy-client").CommandImpl<ListTypeVersionsCommandInput, ListTypeVersionsCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns summary information about the versions of an extension.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, ListTypeVersionsCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, ListTypeVersionsCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // ListTypeVersionsInput
 *   Type: "RESOURCE" || "MODULE" || "HOOK",
 *   TypeName: "STRING_VALUE",
 *   Arn: "STRING_VALUE",
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 *   DeprecatedStatus: "LIVE" || "DEPRECATED",
 *   PublisherId: "STRING_VALUE",
 * };
 * const command = new ListTypeVersionsCommand(input);
 * const response = await client.send(command);
 * // { // ListTypeVersionsOutput
 * //   TypeVersionSummaries: [ // TypeVersionSummaries
 * //     { // TypeVersionSummary
 * //       Type: "RESOURCE" || "MODULE" || "HOOK",
 * //       TypeName: "STRING_VALUE",
 * //       VersionId: "STRING_VALUE",
 * //       IsDefaultVersion: true || false,
 * //       Arn: "STRING_VALUE",
 * //       TimeCreated: new Date("TIMESTAMP"),
 * //       Description: "STRING_VALUE",
 * //       PublicVersionNumber: "STRING_VALUE",
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListTypeVersionsCommandInput - {@link ListTypeVersionsCommandInput}
 * @returns {@link ListTypeVersionsCommandOutput}
 * @see {@link ListTypeVersionsCommandInput} for command's `input` shape.
 * @see {@link ListTypeVersionsCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CFNRegistryException} (client fault)
 *  <p>An error occurred during a CloudFormation registry operation.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 * @public
 */
export declare class ListTypeVersionsCommand extends ListTypeVersionsCommand_base {
}
