import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { ListTypesInput, ListTypesOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ListTypesCommand}.
 */
export interface ListTypesCommandInput extends ListTypesInput {
}
/**
 * @public
 *
 * The output of {@link ListTypesCommand}.
 */
export interface ListTypesCommandOutput extends ListTypesOutput, __MetadataBearer {
}
declare const ListTypesCommand_base: {
    new (input: ListTypesCommandInput): import("@smithy/smithy-client").CommandImpl<ListTypesCommandInput, ListTypesCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [ListTypesCommandInput]): import("@smithy/smithy-client").CommandImpl<ListTypesCommandInput, ListTypesCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns summary information about extension that have been registered with CloudFormation.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, ListTypesCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, ListTypesCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // ListTypesInput
 *   Visibility: "PUBLIC" || "PRIVATE",
 *   ProvisioningType: "NON_PROVISIONABLE" || "IMMUTABLE" || "FULLY_MUTABLE",
 *   DeprecatedStatus: "LIVE" || "DEPRECATED",
 *   Type: "RESOURCE" || "MODULE" || "HOOK",
 *   Filters: { // TypeFilters
 *     Category: "REGISTERED" || "ACTIVATED" || "THIRD_PARTY" || "AWS_TYPES",
 *     PublisherId: "STRING_VALUE",
 *     TypeNamePrefix: "STRING_VALUE",
 *   },
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 * };
 * const command = new ListTypesCommand(input);
 * const response = await client.send(command);
 * // { // ListTypesOutput
 * //   TypeSummaries: [ // TypeSummaries
 * //     { // TypeSummary
 * //       Type: "RESOURCE" || "MODULE" || "HOOK",
 * //       TypeName: "STRING_VALUE",
 * //       DefaultVersionId: "STRING_VALUE",
 * //       TypeArn: "STRING_VALUE",
 * //       LastUpdated: new Date("TIMESTAMP"),
 * //       Description: "STRING_VALUE",
 * //       PublisherId: "STRING_VALUE",
 * //       OriginalTypeName: "STRING_VALUE",
 * //       PublicVersionNumber: "STRING_VALUE",
 * //       LatestPublicVersion: "STRING_VALUE",
 * //       PublisherIdentity: "AWS_Marketplace" || "GitHub" || "Bitbucket",
 * //       PublisherName: "STRING_VALUE",
 * //       IsActivated: true || false,
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListTypesCommandInput - {@link ListTypesCommandInput}
 * @returns {@link ListTypesCommandOutput}
 * @see {@link ListTypesCommandInput} for command's `input` shape.
 * @see {@link ListTypesCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CFNRegistryException} (client fault)
 *  <p>An error occurred during a CloudFormation registry operation.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 * @public
 */
export declare class ListTypesCommand extends ListTypesCommand_base {
}
