import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { StartResourceScanInput, StartResourceScanOutput } from "../models/models_1";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link StartResourceScanCommand}.
 */
export interface StartResourceScanCommandInput extends StartResourceScanInput {
}
/**
 * @public
 *
 * The output of {@link StartResourceScanCommand}.
 */
export interface StartResourceScanCommandOutput extends StartResourceScanOutput, __MetadataBearer {
}
declare const StartResourceScanCommand_base: {
    new (input: StartResourceScanCommandInput): import("@smithy/smithy-client").CommandImpl<StartResourceScanCommandInput, StartResourceScanCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [StartResourceScanCommandInput]): import("@smithy/smithy-client").CommandImpl<StartResourceScanCommandInput, StartResourceScanCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Starts a scan of the resources in this account in this Region. You can the status of a scan using the
 *    <code>ListResourceScans</code> API action.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, StartResourceScanCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, StartResourceScanCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // StartResourceScanInput
 *   ClientRequestToken: "STRING_VALUE",
 * };
 * const command = new StartResourceScanCommand(input);
 * const response = await client.send(command);
 * // { // StartResourceScanOutput
 * //   ResourceScanId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param StartResourceScanCommandInput - {@link StartResourceScanCommandInput}
 * @returns {@link StartResourceScanCommandOutput}
 * @see {@link StartResourceScanCommandInput} for command's `input` shape.
 * @see {@link StartResourceScanCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link ResourceScanInProgressException} (client fault)
 *  <p>A resource scan is currently in progress. Only one can be run at a time for an account in a Region.</p>
 *
 * @throws {@link ResourceScanLimitExceededException} (client fault)
 *  <p>The limit on resource scans has been exceeded. Reasons include:</p>
 *          <ul>
 *             <li>
 *                <p>Exceeded the daily quota for resource scans.</p>
 *             </li>
 *             <li>
 *                <p>A resource scan recently failed. You must wait 10 minutes before starting a new resource scan.</p>
 *             </li>
 *             <li>
 *                <p>The last resource scan failed after exceeding 100,000 resources. When this happens, you must wait 24 hours
 *      before starting a new resource scan.</p>
 *             </li>
 *          </ul>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 * @public
 * @example To start a resource scan
 * ```javascript
 * // This example shows how to start a new resource scan
 * const input = {};
 * const command = new StartResourceScanCommand(input);
 * const response = await client.send(command);
 * /* response ==
 * {
 *   "ResourceScanId": "arn:aws:cloudformation:us-east-1:123456789012:resourceScan/88f09db1-d211-4cb7-964b-434e2b8469ca"
 * }
 * *\/
 * // example id: to-start-a-generated-template
 * ```
 *
 */
export declare class StartResourceScanCommand extends StartResourceScanCommand_base {
}
