# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

from typing import TypeVar

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

T = TypeVar("T", bound=Interface)


class WlRegistry(Interface):
    """Global registry object

    The singleton global registry object.  The server has a number of global
    objects that are available to all clients.  These objects typically
    represent an actual object in the server (for example, an input device) or
    they are singleton objects that provide extension functionality.

    When a client creates a registry object, the registry object will emit a
    global event for each global currently in the registry.  Globals come and
    go as a result of device or monitor hotplugs, reconfiguration or other
    events, and the registry will send out global and global_remove events to
    keep the client up to date with the changes.  To mark the end of the
    initial burst of events, the client can use the :func:`WlDisplay.sync()
    <pywayland.protocol.wayland.WlDisplay.sync>` request immediately after
    calling :func:`WlDisplay.get_registry()
    <pywayland.protocol.wayland.WlDisplay.get_registry>`.

    A client can bind to a global object by using the bind request.  This
    creates a client-side handle that lets the object emit events to the client
    and lets the client invoke requests on the object.
    """

    name = "wl_registry"
    version = 1


class WlRegistryProxy(Proxy[WlRegistry]):
    interface = WlRegistry

    @WlRegistry.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.NewId),
    )
    def bind(self, name: int, interface: type[T], version: int) -> Proxy[T]:
        """Bind an object to the display

        Binds a new, client-created object to the server using the specified
        name as the identifier.

        :param name:
            unique numeric name of the object
        :type name:
            `ArgumentType.Uint`
        :param interface:
            Interface name
        :type interface:
            `string`
        :param version:
            Interface version
        :type version:
            `int`
        :returns:
            :class:`pywayland.client.proxy.Proxy` of specified Interface --
            bounded object
        """
        id = self._marshal_constructor(0, interface, name, interface.name, version)
        return id


class WlRegistryResource(Resource):
    interface = WlRegistry

    @WlRegistry.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.String),
        Argument(ArgumentType.Uint),
    )
    def global_(self, name: int, interface: str, version: int) -> None:
        """Announce global object

        Notify the client of global objects.

        The event notifies the client that a global object with the given name
        is now available, and it implements the given version of the given
        interface.

        :param name:
            numeric name of the global object
        :type name:
            `ArgumentType.Uint`
        :param interface:
            interface implemented by the object
        :type interface:
            `ArgumentType.String`
        :param version:
            interface version
        :type version:
            `ArgumentType.Uint`
        """
        self._post_event(0, name, interface, version)

    @WlRegistry.event(
        Argument(ArgumentType.Uint),
    )
    def global_remove(self, name: int) -> None:
        """Announce removal of global object

        Notify the client of removed global objects.

        This event notifies the client that the global identified by name is no
        longer available.  If the client bound to the global using the bind
        request, the client should now destroy that object.

        The object remains valid and requests to the object will be ignored
        until the client destroys it, to avoid races between the global going
        away and a client sending a request to it.

        :param name:
            numeric name of the global object
        :type name:
            `ArgumentType.Uint`
        """
        self._post_event(1, name)


class WlRegistryGlobal(Global):
    interface = WlRegistry


WlRegistry._gen_c()
WlRegistry.proxy_class = WlRegistryProxy
WlRegistry.resource_class = WlRegistryResource
WlRegistry.global_class = WlRegistryGlobal
