/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.render;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.plus.render.OsmandRenderer;
import net.osmand.plus.render.RenderingIcons;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.util.Algorithms;
import net.sf.junidecode.Junidecode;
import net.sourceforge.offroad.TextStroke;
import net.sourceforge.offroad.ui.ColorUtils;
import org.apache.commons.logging.Log;

public class TextRenderer {
    private static final int MINIMAL_DISTANCE_BETWEEN_SHIELDS_IN_PIXEL = 200;
    private static final Log log = PlatformUtil.getLog(TextRenderer.class);
    List<TextDrawInfo> tempSearch = new ArrayList<TextDrawInfo>();

    private double sqr(double a) {
        return a * a;
    }

    private double fsqr(double pD) {
        return pD * pD;
    }

    boolean intersects(QuadRect tRect, float tRot, QuadRect sRect, float sRot) {
        if ((double)Math.abs(tRot) < 0.20943951023931953 && (double)Math.abs(sRot) < 0.20943951023931953) {
            return QuadRect.intersects(tRect, sRect);
        }
        double dist = Math.sqrt(this.sqr(tRect.centerX() - sRect.centerX()) + this.sqr(tRect.centerY() - sRect.centerY()));
        if (dist < 200.0) {
            return true;
        }
        if (Math.abs(Math.cos(tRot - sRot)) < 0.3) {
            tRot = (float)((double)tRot + 1.5707963267948966);
            double l = tRect.centerX() - tRect.height() / 2.0;
            double t = tRect.centerY() - tRect.width() / 2.0;
            tRect = new QuadRect(l, t, l + tRect.height(), t + tRect.width());
        }
        if (Math.abs(Math.sin(tRot - sRot)) < 0.3) {
            float diff = (float)(-Math.atan2(tRect.centerX() - sRect.centerX(), tRect.centerY() - sRect.centerY()) + 1.5707963267948966);
            double left = sRect.centerX() + dist * Math.cos(diff -= sRot) - tRect.width() / 2.0;
            double top = sRect.centerY() - dist * Math.sin(diff) - tRect.height() / 2.0;
            QuadRect nRect = new QuadRect(left, top, left + tRect.width(), top + tRect.height());
            return QuadRect.intersects(nRect, sRect);
        }
        return QuadRect.intersects(tRect, sRect);
    }

    void drawTestBox(Graphics2D pGraphics2d, Rectangle2D r, float rot, String text) {
        Graphics2D newGraphics = (Graphics2D)pGraphics2d.create();
        newGraphics.translate(r.getCenterX(), r.getCenterY());
        newGraphics.rotate((float)((double)(rot * 180.0f) / Math.PI));
        Rectangle2D.Double rs = new Rectangle2D.Double(-r.getWidth() / 2.0, -r.getHeight() / 2.0, r.getWidth() / 2.0, r.getHeight() / 2.0);
        newGraphics.drawRect((int)((RectangularShape)rs).getX(), (int)((RectangularShape)rs).getY(), (int)((RectangularShape)rs).getWidth(), (int)((RectangularShape)rs).getHeight());
        if (text != null) {
            newGraphics.drawString(text, (int)rs.getCenterX(), (int)rs.getCenterY());
        }
        newGraphics.dispose();
    }

    private boolean findTextIntersection(Graphics2D pGraphics2d, OsmandRenderer.RenderingContext rc, QuadTree<TextDrawInfo> boundIntersections, TextDrawInfo text) {
        boundIntersections.queryInBox(text.bounds, this.tempSearch);
        for (int i = 0; i < this.tempSearch.size(); ++i) {
            TextDrawInfo t = this.tempSearch.get(i);
            if (!this.intersects(text.bounds, text.pathRotate, t.bounds, t.pathRotate)) continue;
            return true;
        }
        if (text.minDistance > 0.0f) {
            QuadRect boundsSearch = new QuadRect(text.bounds);
            boundsSearch.inset(-Math.max(rc.getDensityValue(5.0f), text.minDistance), -rc.getDensityValue(15.0f));
            boundIntersections.queryInBox(boundsSearch, this.tempSearch);
            for (int i = 0; i < this.tempSearch.size(); ++i) {
                TextDrawInfo t = this.tempSearch.get(i);
                if (!(t.minDistance > 0.0f) || !t.text.equals(text.text) || !this.intersects(boundsSearch, text.pathRotate, t.bounds, t.pathRotate)) continue;
                return true;
            }
        }
        boundIntersections.insert(text, text.bounds);
        return false;
    }

    private void drawTextOnCanvas(Graphics2D pGraphics2d, String text, float centerX, float centerY, int shadowColor, float textShadow) {
        Graphics2D newGraphics = (Graphics2D)pGraphics2d.create();
        centerX -= (float)(newGraphics.getFontMetrics().stringWidth(text) / 2);
        if (textShadow > 0.0f) {
            Color c = newGraphics.getColor();
            newGraphics.setColor(this.createColor(shadowColor));
            newGraphics.setStroke(new BasicStroke(2.0f + textShadow));
            newGraphics.drawString(text, centerX, centerY);
            newGraphics.setStroke(new BasicStroke(2.0f));
            newGraphics.setColor(c);
        }
        newGraphics.drawString(text, centerX, centerY);
        newGraphics.dispose();
    }

    public void drawTextOverCanvas(OsmandRenderer.RenderingContext rc, Graphics2D pGraphics2d, String preferredLocale) {
        int size = rc.textToDraw.size();
        Graphics2D newGraphics = (Graphics2D)pGraphics2d.create();
        Collections.sort(rc.textToDraw, new Comparator<TextDrawInfo>(){

            @Override
            public int compare(TextDrawInfo object1, TextDrawInfo object2) {
                return object1.textOrder - object2.textOrder;
            }
        });
        QuadRect r = new QuadRect(0.0, 0.0, rc.width, rc.height);
        r.inset(-100.0, -100.0);
        QuadTree<TextDrawInfo> nonIntersectedBounds = new QuadTree<TextDrawInfo>(r, 4, 0.6f);
        for (int i = 0; i < size; ++i) {
            TextDrawInfo text = rc.textToDraw.get(i);
            if (text.text == null || text.text.length() <= 0) continue;
            if (preferredLocale.length() > 0) {
                text.text = Junidecode.unidecode((String)text.text);
            }
            float textSize = text.textSize * rc.textScale;
            int fontStyle = 0;
            fontStyle = text.bold && text.italic ? 3 : (text.bold ? 1 : (text.italic ? 2 : 0));
            Font textFont = newGraphics.getFont().deriveFont(fontStyle, textSize);
            newGraphics.setFont(textFont);
            newGraphics.setColor(this.createColor(text.textColor));
            FontMetrics metr = newGraphics.getFontMetrics();
            text.centerY += (float)(-metr.getAscent());
            boolean intersects = this.findTextIntersection(newGraphics, rc, nonIntersectedBounds, text);
            if (intersects) continue;
            if (text.drawOnPath != null) {
                float vOffset = text.vOffset - (float)(metr.getAscent() / 2 + metr.getDescent());
                if (text.textShadow > 0) {
                    newGraphics.setColor(this.createColor(text.textShadowColor));
                    newGraphics.setStroke(new TextStroke(text.text, textFont, false, false, -vOffset));
                    newGraphics.draw(text.drawOnPath);
                }
                newGraphics.setColor(this.createColor(text.textColor));
                newGraphics.setStroke(new TextStroke(text.text, textFont, false, false, -vOffset));
                newGraphics.draw(text.drawOnPath);
                newGraphics.setStroke(new BasicStroke(0.0f));
                continue;
            }
            this.drawShieldIcon(rc, newGraphics, text, text.shieldRes);
            this.drawShieldIcon(rc, newGraphics, text, text.shieldResIcon);
            this.drawWrappedText(newGraphics, text, textSize);
        }
        newGraphics.dispose();
    }

    public Color createColor(int colorInt) {
        return ColorUtils.create(colorInt);
    }

    private void drawShieldIcon(OsmandRenderer.RenderingContext rc, Graphics2D pGraphics2d, TextDrawInfo text, String sr) {
        if (sr != null) {
            float coef = rc.getDensityValue(rc.screenDensityRatio * rc.textScale);
            BufferedImage ico = RenderingIcons.getIcon(sr, true);
            log.debug((Object)("Got shield icon " + sr + ":" + ico.getWidth() + "x" + ico.getHeight()));
            if (ico != null) {
                float left = text.centerX - (float)(ico.getWidth() / 2) * coef - 0.5f;
                float top = text.centerY - (float)(ico.getHeight() / 2) * coef - (float)pGraphics2d.getFontMetrics().getDescent() - 0.5f;
                if (rc.screenDensityRatio != 1.0f) {
                    Rectangle2D.Float rf = new Rectangle2D.Float(left, top, left + (float)ico.getWidth() * coef, top + (float)ico.getHeight() * coef);
                    Rectangle2D.Float src = new Rectangle2D.Float(0.0f, 0.0f, ico.getWidth(), ico.getHeight());
                    pGraphics2d.drawImage(ico, (int)((RectangularShape)rf).getX(), (int)((RectangularShape)rf).getY(), (int)rf.getMaxX(), (int)rf.getMaxY(), (int)src.getMinX(), (int)src.getMinY(), (int)src.getMaxX(), (int)src.getMaxY(), null);
                } else {
                    pGraphics2d.drawImage((Image)ico, (int)left, (int)top, null);
                }
            }
        }
    }

    private void drawWrappedText(Graphics2D pGraphics2d, TextDrawInfo text, float textSize) {
        if (text.textWrap == 0) {
            text.textWrap = 40;
        }
        if (text.text.length() > text.textWrap) {
            int start = 0;
            int end = text.text.length();
            int lastSpace = -1;
            int line = 0;
            int pos = 0;
            int limit = 0;
            while (pos < end) {
                lastSpace = -1;
                limit += text.textWrap;
                while (pos < limit && pos < end) {
                    if (!Character.isLetterOrDigit(text.text.charAt(pos))) {
                        lastSpace = pos;
                    }
                    ++pos;
                }
                if (lastSpace == -1 || pos == end) {
                    this.drawTextOnCanvas(pGraphics2d, text.text.substring(start, pos), text.centerX, text.centerY + (float)line * (textSize + 2.0f), text.textShadowColor, text.textShadow);
                    start = pos;
                } else {
                    this.drawTextOnCanvas(pGraphics2d, text.text.substring(start, lastSpace), text.centerX, text.centerY + (float)line * (textSize + 2.0f), text.textShadowColor, text.textShadow);
                    start = lastSpace + 1;
                    limit += start - pos - 1;
                }
                ++line;
            }
        } else {
            this.drawTextOnCanvas(pGraphics2d, text.text, text.centerX, text.centerY, text.textShadowColor, text.textShadow);
        }
    }

    private void createTextDrawInfo(final BinaryMapDataObject o, RenderingRuleSearchRequest render, Graphics2D pGraphics2d, OsmandRenderer.RenderingContext rc, BinaryMapIndexReader.TagValuePair pair, double xMid, double yMid, Path2D pPath, Point2D[] points, final String name, String tagName) {
        render.setInitialTagValueZoom(pair.tag, pair.value, rc.zoom, o);
        render.setIntFilter(render.ALL.R_TEXT_LENGTH, name.length());
        render.setStringFilter(render.ALL.R_NAME_TAG, tagName);
        if (render.search(4) && render.getFloatPropertyValue(render.ALL.R_TEXT_SIZE) > 0.0f) {
            final TextDrawInfo text = new TextDrawInfo(name);
            text.fillProperties(rc, render, (float)xMid, (float)yMid);
            final String tagName2 = render.getStringPropertyValue(render.ALL.R_NAME_TAG2);
            if (!Algorithms.isEmpty(tagName2)) {
                o.getObjectNames().forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<String>(){

                    public boolean execute(int tagid, String nname) {
                        String tagNameN2 = o.getMapIndex().decodeType((int)tagid).tag;
                        if (tagName2.equals(tagNameN2)) {
                            if (nname != null && nname.trim().length() > 0 && !name.equals(nname)) {
                                text.text = text.text + " (" + nname + ")";
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
            Graphics2D newGraphics = (Graphics2D)pGraphics2d.create();
            float textSize = text.textSize * rc.textScale;
            int fontStyle = 0;
            fontStyle = text.bold && text.italic ? 3 : (text.bold ? 1 : (text.italic ? 2 : 0));
            Font textFont = newGraphics.getFont().deriveFont(fontStyle, textSize);
            newGraphics.setFont(textFont);
            FontMetrics metr = newGraphics.getFontMetrics();
            int stringWidth = metr.stringWidth(name);
            int stringHeight = metr.getHeight();
            text.bounds = new QuadRect(0.0, 0.0, stringWidth, stringHeight);
            text.bounds.inset(-rc.getDensityValue(3.0f), -rc.getDensityValue(10.0f));
            boolean display = true;
            if (pPath != null) {
                text.drawOnPath = pPath;
                display = this.calculatePathToRotate(rc, text, points, render.getIntPropertyValue(render.ALL.R_TEXT_ON_PATH, 0) != 0);
            }
            if (text.drawOnPath == null) {
                text.bounds.offset(text.centerX, text.centerY);
                text.bounds.offset(-text.bounds.width() / 2.0, -text.bounds.height() / 2.0);
            } else {
                text.bounds.offset((double)text.centerX - text.bounds.width() / 2.0, (double)text.centerY - text.bounds.height() / 2.0);
            }
            if (display) {
                OsmandRenderer.TextInfo info = new OsmandRenderer.TextInfo();
                info.mText = text.text;
                info.path = text.drawOnPath != null ? new Path2D.Double(text.drawOnPath) : text.bounds.toPath2D();
                rc.result.effectiveTextObjects.add(info);
                rc.textToDraw.add(text);
            }
        }
    }

    public void renderText(final BinaryMapDataObject obj, final RenderingRuleSearchRequest render, final Graphics2D pGraphics2d, final OsmandRenderer.RenderingContext rc, final BinaryMapIndexReader.TagValuePair pair, final double xMid, final double yMid, final Path2D pPath, final Point2D[] points) {
        TIntObjectHashMap<String> map = obj.getObjectNames();
        if (map != null) {
            boolean langContainedL;
            Integer langTagL = obj.getMapIndex().getRule("name:" + rc.preferredLocale, null);
            boolean bl = langContainedL = langTagL != null && map.containsKey(langTagL.intValue());
            if (!langContainedL) {
                langTagL = obj.getMapIndex().getRule("name:en", null);
                langContainedL = langTagL != null && map.containsKey(langTagL.intValue());
            }
            final int nameEncodingType = obj.getMapIndex().nameEncodingType;
            final boolean langContained = langContainedL;
            final int langTag = langContained ? langTagL : nameEncodingType;
            map.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<String>(){

                public boolean execute(int tag, String name) {
                    if (name != null && name.trim().length() > 0) {
                        if (langContained && tag == nameEncodingType) {
                            return true;
                        }
                        String nameTag = obj.getMapIndex().decodeType((int)tag).tag;
                        boolean skip = false;
                        if (nameTag.startsWith("name")) {
                            if (tag != langTag) {
                                skip = true;
                            } else {
                                nameTag = "";
                            }
                        }
                        if (!skip) {
                            TextRenderer.this.createTextDrawInfo(obj, render, pGraphics2d, rc, pair, xMid, yMid, pPath, points, name, nameTag);
                        }
                    }
                    return true;
                }
            });
        }
    }

    boolean calculatePathToRotate(OsmandRenderer.RenderingContext rc, TextDrawInfo p, Point2D[] points, boolean drawOnPath) {
        int len = points.length;
        if (!drawOnPath) {
            p.drawOnPath = null;
            float px = 0.0f;
            float py = 0.0f;
            for (int i = 1; i < len; ++i) {
                px = (float)((double)px + (points[i].getX() - points[i - 1].getX()));
                py = (float)((double)py + (points[i].getY() - points[i - 1].getY()));
            }
            if (px != 0.0f || py != 0.0f) {
                p.pathRotate = (float)(-Math.atan2(px, py) + 1.5707963267948966);
            }
            return true;
        }
        boolean inverse = false;
        float roadLength = 0.0f;
        boolean prevInside = false;
        float visibleRoadLength = 0.0f;
        float textw = (float)p.bounds.width();
        int last = 0;
        int startVisible = 0;
        float[] distances = new float[points.length - 1];
        float normalTextLen = 1.5f * textw;
        int i = 0;
        while (i < len) {
            boolean inside;
            boolean bl = inside = points[i].getX() >= 0.0 && points[i].getX() <= (double)rc.width && points[i].getY() >= 0.0 && points[i].getY() <= (double)rc.height;
            if (i > 0) {
                float d;
                distances[i - 1] = d = (float)Math.sqrt(this.fsqr(points[i].getX() - points[i - 1].getX()) + this.fsqr(points[i].getY() - points[i - 1].getY()));
                roadLength += d;
                if (inside) {
                    visibleRoadLength += d;
                    if (!prevInside) {
                        startVisible = i - 1;
                    }
                } else if (prevInside) {
                    if (visibleRoadLength >= normalTextLen) break;
                    visibleRoadLength = 0.0f;
                }
            }
            prevInside = inside;
            ++i;
            ++last;
        }
        if (textw >= roadLength) {
            return false;
        }
        int startInd = 0;
        int endInd = len;
        if (textw < visibleRoadLength && last - startVisible > 1) {
            startInd = startVisible;
            endInd = last;
            if (visibleRoadLength > 3.0f * textw) {
                boolean ch;
                do {
                    ch = false;
                    if (endInd - startInd > 2 && visibleRoadLength - distances[startInd] > normalTextLen) {
                        visibleRoadLength -= distances[startInd];
                        ++startInd;
                        ch = true;
                    }
                    if (endInd - startInd <= 2 || !(visibleRoadLength - distances[endInd - 2] > normalTextLen)) continue;
                    visibleRoadLength -= distances[endInd - 2];
                    --endInd;
                    ch = true;
                } while (ch);
            }
        }
        if (startInd > 0 || endInd < len) {
            Path2D.Double path = new Path2D.Double();
            for (int i2 = startInd; i2 < endInd; ++i2) {
                if (i2 == startInd) {
                    ((Path2D)path).moveTo(points[i2].getX(), points[i2].getY());
                    continue;
                }
                ((Path2D)path).lineTo(points[i2].getX(), points[i2].getY());
            }
            p.drawOnPath = path;
        }
        float px = 0.0f;
        float py = 0.0f;
        for (int i3 = startInd + 1; i3 < endInd; ++i3) {
            px = (float)((double)px + (points[i3].getX() - points[i3 - 1].getX()));
            py = (float)((double)py + (points[i3].getY() - points[i3 - 1].getY()));
        }
        float scale = 0.5f;
        float plen = (float)Math.sqrt(px * px + py * py);
        float ox = -py;
        float oy = px;
        if (plen > 0.0f) {
            float rot = (float)(-Math.atan2(px, py) + 1.5707963267948966);
            if (rot < 0.0f) {
                rot = (float)((double)rot + Math.PI * 2);
            }
            if ((double)rot > 1.5707963267948966 && (double)rot < 4.71238898038469) {
                rot = (float)((double)rot + Math.PI);
                inverse = true;
                ox = -ox;
                oy = -oy;
            }
            p.pathRotate = rot;
            ox = (float)((double)ox * (p.bounds.height() / (double)plen / 2.0));
            oy = (float)((double)oy * (p.bounds.height() / (double)plen / 2.0));
        }
        p.centerX = (float)(points[startInd].getX() + (double)(scale * px) + (double)ox);
        p.centerY = (float)(points[startInd].getY() + (double)(scale * py) + (double)oy);
        if (inverse) {
            Path2D.Double path = new Path2D.Double();
            for (int i4 = endInd - 1; i4 >= startInd; --i4) {
                if (i4 == endInd - 1) {
                    ((Path2D)path).moveTo(points[i4].getX(), points[i4].getY());
                    continue;
                }
                ((Path2D)path).lineTo(points[i4].getX(), points[i4].getY());
            }
            p.drawOnPath = path;
        }
        return true;
    }

    static class TextDrawInfo {
        String text = null;
        Path2D drawOnPath = null;
        QuadRect bounds = null;
        float vOffset = 0.0f;
        float centerX = 0.0f;
        float pathRotate = 0.0f;
        float centerY = 0.0f;
        float textSize = 0.0f;
        float minDistance = 0.0f;
        int textColor = Color.BLACK.getRGB();
        int textShadow = 0;
        int textWrap = 0;
        boolean bold = false;
        boolean italic = false;
        String shieldRes = null;
        String shieldResIcon = null;
        int textOrder = 100;
        int textShadowColor = Color.WHITE.getRGB();

        public TextDrawInfo(String text) {
            this.text = text;
        }

        public void fillProperties(OsmandRenderer.RenderingContext rc, RenderingRuleSearchRequest render, float centerX, float centerY) {
            this.centerX = centerX;
            this.vOffset = (int)rc.getComplexValue(render, render.ALL.R_TEXT_DY);
            this.centerY = centerY + this.vOffset;
            this.textColor = render.getIntPropertyValue(render.ALL.R_TEXT_COLOR);
            if (this.textColor == 0) {
                this.textColor = Color.BLACK.getRGB();
            }
            this.textSize = rc.getComplexValue(render, render.ALL.R_TEXT_SIZE);
            this.textShadow = (int)rc.getComplexValue(render, render.ALL.R_TEXT_HALO_RADIUS);
            this.textShadowColor = render.getIntPropertyValue(render.ALL.R_TEXT_HALO_COLOR);
            if (this.textShadowColor == 0) {
                this.textShadowColor = Color.WHITE.getRGB();
            }
            this.textWrap = (int)rc.getComplexValue(render, render.ALL.R_TEXT_WRAP_WIDTH);
            this.bold = render.getIntPropertyValue(render.ALL.R_TEXT_BOLD, 0) > 0;
            this.italic = render.getIntPropertyValue(render.ALL.R_TEXT_ITALIC, 0) > 0;
            this.minDistance = rc.getComplexValue(render, render.ALL.R_TEXT_MIN_DISTANCE);
            if (render.isSpecified(render.ALL.R_TEXT_SHIELD)) {
                this.shieldRes = render.getStringPropertyValue(render.ALL.R_TEXT_SHIELD);
            }
            if (render.isSpecified(render.ALL.R_ICON)) {
                this.shieldResIcon = render.getStringPropertyValue(render.ALL.R_ICON);
            }
            this.textOrder = render.getIntPropertyValue(render.ALL.R_TEXT_ORDER, 100);
        }
    }
}

