"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GET_FINDINGS_SORT_FIELDS = exports.DEFAULT_GET_FINDINGS_PARAMS = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// TODO DRAFT: Are these sortField options appropriate?
const GET_FINDINGS_SORT_FIELDS = exports.GET_FINDINGS_SORT_FIELDS = {
  INDEX: 'index',
  MONITOR_NAME: 'monitor_name',
  TIMESTAMP: 'timestamp'
};

// TODO DRAFT: RestGetFindingsAction.kt in the backend references a `missing` field in params.
//  Investigate if/how we should make use of that.
const DEFAULT_GET_FINDINGS_PARAMS = exports.DEFAULT_GET_FINDINGS_PARAMS = {
  // TODO DRAFT: Does providing a finding ID serve a particular function? Results with/without the ID seemed the same.
  id: undefined,
  from: 0,
  search: '',
  size: 20,
  sortDirection: 'desc',
  sortField: GET_FINDINGS_SORT_FIELDS.TIMESTAMP
};
class FindingService {
  constructor(esDriver) {
    _defineProperty(this, "getFindings", async (context, req, res) => {
      const {
        id = DEFAULT_GET_FINDINGS_PARAMS.id,
        from = DEFAULT_GET_FINDINGS_PARAMS.from,
        size = DEFAULT_GET_FINDINGS_PARAMS.size,
        search = DEFAULT_GET_FINDINGS_PARAMS.search,
        sortDirection = DEFAULT_GET_FINDINGS_PARAMS.sortDirection,
        sortField = DEFAULT_GET_FINDINGS_PARAMS.sortField
      } = req.query;
      var params;
      switch (sortField) {
        case GET_FINDINGS_SORT_FIELDS.INDEX:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        case GET_FINDINGS_SORT_FIELDS.MONITOR_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        default:
          // If the sortField parsed from the URL isn't a valid option for this API, use a default option.
          params = {
            sortString: GET_FINDINGS_SORT_FIELDS.TIMESTAMP,
            sortOrder: sortDirection
          };
      }
      if (!_lodash.default.isEmpty(id)) params.findingId = id;
      params.startIndex = from;
      params.size = size;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      const {
        callAsCurrentUser
      } = this.esDriver.asScoped(req);
      try {
        const resp = await callAsCurrentUser('alerting.getFindings', params);
        const findings = resp.findings.map(result => ({
          [result.finding.id]: {
            ...result
          }
        }));
        const totalFindings = resp.totalFindings;
        return res.ok({
          body: {
            ok: true,
            findings,
            totalFindings
          }
        });
      } catch (err) {
        console.log(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    this.esDriver = esDriver;
  }
}
exports.default = FindingService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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