/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.BinaryDocValues;
import org.opensearch.ExceptionsHelper;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.knn.index.VectorDataType;

public final class KNNVectorScriptDocValues
extends ScriptDocValues<float[]> {
    private final BinaryDocValues binaryDocValues;
    private final String fieldName;
    private final VectorDataType vectorDataType;
    private boolean docExists = false;

    public void setNextDocId(int docId) throws IOException {
        if (this.binaryDocValues.advanceExact(docId)) {
            this.docExists = true;
            return;
        }
        this.docExists = false;
    }

    public float[] getValue() {
        if (!this.docExists) {
            String errorMessage = String.format("One of the document doesn't have a value for field '%s'. This can be avoided by checking if a document has a value for the field or not by doc['%s'].size() == 0 ? 0 : {your script}", this.fieldName, this.fieldName);
            throw new IllegalStateException(errorMessage);
        }
        try {
            return this.vectorDataType.getVectorFromBytesRef(this.binaryDocValues.binaryValue());
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    public int size() {
        return this.docExists ? 1 : 0;
    }

    public float[] get(int i) {
        throw new UnsupportedOperationException("knn vector does not support this operation");
    }

    @Generated
    public KNNVectorScriptDocValues(BinaryDocValues binaryDocValues, String fieldName, VectorDataType vectorDataType) {
        this.binaryDocValues = binaryDocValues;
        this.fieldName = fieldName;
        this.vectorDataType = vectorDataType;
    }

    @Generated
    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }
}

