/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80BinaryDocValues;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;
import org.opensearch.knn.index.codec.util.SerializationMode;
import org.opensearch.knn.jni.JNICommons;

public class KNNCodecUtil {
    public static final int FLOAT_BYTE_SIZE = 4;
    public static final int JAVA_REFERENCE_SIZE = 4;
    public static final int JAVA_ARRAY_HEADER_SIZE = 12;
    public static final int JAVA_ROUNDING_NUMBER = 8;

    public static Pair getFloats(BinaryDocValues values) throws IOException {
        ArrayList<float[]> vectorList = new ArrayList<float[]>();
        ArrayList<Integer> docIdList = new ArrayList<Integer>();
        long vectorAddress = 0L;
        int dimension = 0;
        SerializationMode serializationMode = SerializationMode.COLLECTION_OF_FLOATS;
        long totalLiveDocs = KNNCodecUtil.getTotalLiveDocsCount(values);
        long vectorsStreamingMemoryLimit = KNNSettings.getVectorStreamingMemoryLimit().getBytes();
        long vectorsPerTransfer = Integer.MIN_VALUE;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            BytesRef bytesref = values.binaryValue();
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytesref.bytes, bytesref.offset, bytesref.length);){
                serializationMode = KNNVectorSerializerFactory.serializerModeFromStream(byteStream);
                KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByStreamContent(byteStream);
                float[] vector = vectorSerializer.byteToFloatArray(byteStream);
                dimension = vector.length;
                if (vectorsPerTransfer == Integer.MIN_VALUE && (vectorsPerTransfer = (long)(dimension * 4) * totalLiveDocs / vectorsStreamingMemoryLimit) == 0L) {
                    vectorsPerTransfer = totalLiveDocs;
                }
                if ((long)vectorList.size() == vectorsPerTransfer) {
                    vectorAddress = JNICommons.storeVectorData(vectorAddress, (float[][])vectorList.toArray((T[])new float[0][]), totalLiveDocs * (long)dimension);
                    vectorList = new ArrayList();
                }
                vectorList.add(vector);
            }
            docIdList.add(doc);
            doc = values.nextDoc();
        }
        if (!vectorList.isEmpty()) {
            vectorAddress = JNICommons.storeVectorData(vectorAddress, (float[][])vectorList.toArray((T[])new float[0][]), totalLiveDocs * (long)dimension);
        }
        return new Pair(docIdList.stream().mapToInt(Integer::intValue).toArray(), vectorAddress, dimension, serializationMode);
    }

    public static long calculateArraySize(int numVectors, int vectorLength, SerializationMode serializationMode) {
        int vectorsSize;
        if (serializationMode == SerializationMode.ARRAY) {
            int vectorsSize2;
            int vectorSize = vectorLength * 4 + 12;
            if (vectorSize % 8 != 0) {
                vectorSize += vectorSize % 8;
            }
            if ((vectorsSize2 = numVectors * (vectorSize + 4) + 12) % 8 != 0) {
                vectorsSize2 += vectorsSize2 % 8;
            }
            return vectorsSize2;
        }
        int vectorSize = vectorLength * 4;
        if (vectorSize % 8 != 0) {
            vectorSize += vectorSize % 8;
        }
        if ((vectorsSize = numVectors * (vectorSize + 4)) % 8 != 0) {
            vectorsSize += vectorsSize % 8;
        }
        return vectorsSize;
    }

    public static String buildEngineFileName(String segmentName, String latestBuildVersion, String fieldName, String extension) {
        return String.format("%s%s%s", KNNCodecUtil.buildEngineFilePrefix(segmentName), latestBuildVersion, KNNCodecUtil.buildEngineFileSuffix(fieldName, extension));
    }

    public static String buildEngineFilePrefix(String segmentName) {
        return String.format("%s_", segmentName);
    }

    public static String buildEngineFileSuffix(String fieldName, String extension) {
        return String.format("_%s%s", fieldName, extension);
    }

    private static long getTotalLiveDocsCount(BinaryDocValues binaryDocValues) {
        long totalLiveDocs = binaryDocValues instanceof KNN80BinaryDocValues ? ((KNN80BinaryDocValues)binaryDocValues).getTotalLiveDocs() : binaryDocValues.cost();
        return totalLiveDocs;
    }

    public static final class Pair {
        public int[] docs;
        private long vectorAddress;
        private int dimension;
        public SerializationMode serializationMode;

        @Generated
        public Pair(int[] docs, long vectorAddress, int dimension, SerializationMode serializationMode) {
            this.docs = docs;
            this.vectorAddress = vectorAddress;
            this.dimension = dimension;
            this.serializationMode = serializationMode;
        }

        @Generated
        public long getVectorAddress() {
            return this.vectorAddress;
        }

        @Generated
        public void setVectorAddress(long vectorAddress) {
            this.vectorAddress = vectorAddress;
        }

        @Generated
        public int getDimension() {
            return this.dimension;
        }

        @Generated
        public void setDimension(int dimension) {
            this.dimension = dimension;
        }
    }
}

