/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class ConnectorAction
implements ToXContentObject,
Writeable {
    public static final String ACTION_TYPE_FIELD = "action_type";
    public static final String METHOD_FIELD = "method";
    public static final String URL_FIELD = "url";
    public static final String HEADERS_FIELD = "headers";
    public static final String REQUEST_BODY_FIELD = "request_body";
    public static final String ACTION_PRE_PROCESS_FUNCTION = "pre_process_function";
    public static final String ACTION_POST_PROCESS_FUNCTION = "post_process_function";
    private ActionType actionType;
    private String method;
    private String url;
    private Map<String, String> headers;
    private String requestBody;
    private String preProcessFunction;
    private String postProcessFunction;

    public ConnectorAction(ActionType actionType, String method, String url, Map<String, String> headers, String requestBody, String preProcessFunction, String postProcessFunction) {
        if (actionType == null) {
            throw new IllegalArgumentException("action type can't null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url can't null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method can't null");
        }
        this.actionType = actionType;
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.requestBody = requestBody;
        this.preProcessFunction = preProcessFunction;
        this.postProcessFunction = postProcessFunction;
    }

    public ConnectorAction(StreamInput input) throws IOException {
        this.actionType = (ActionType)input.readEnum(ActionType.class);
        this.method = input.readString();
        this.url = input.readString();
        if (input.readBoolean()) {
            this.headers = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.requestBody = input.readOptionalString();
        this.preProcessFunction = input.readOptionalString();
        this.postProcessFunction = input.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.actionType);
        out.writeString(this.method);
        out.writeString(this.url);
        if (this.headers != null) {
            out.writeBoolean(true);
            out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.requestBody);
        out.writeOptionalString(this.preProcessFunction);
        out.writeOptionalString(this.postProcessFunction);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.actionType != null) {
            builder.field(ACTION_TYPE_FIELD, (Object)this.actionType);
        }
        if (this.method != null) {
            builder.field(METHOD_FIELD, this.method);
        }
        if (this.url != null) {
            builder.field(URL_FIELD, this.url);
        }
        if (this.headers != null) {
            builder.field(HEADERS_FIELD, this.headers);
        }
        if (this.requestBody != null) {
            builder.field(REQUEST_BODY_FIELD, this.requestBody);
        }
        if (this.preProcessFunction != null) {
            builder.field(ACTION_PRE_PROCESS_FUNCTION, this.preProcessFunction);
        }
        if (this.postProcessFunction != null) {
            builder.field(ACTION_POST_PROCESS_FUNCTION, this.postProcessFunction);
        }
        return builder.endObject();
    }

    public static ConnectorAction fromStream(StreamInput in) throws IOException {
        ConnectorAction action = new ConnectorAction(in);
        return action;
    }

    public static ConnectorAction parse(XContentParser parser) throws IOException {
        ActionType actionType = null;
        String method = null;
        String url = null;
        Map headers = null;
        String requestBody = null;
        String preProcessFunction = null;
        String postProcessFunction = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "action_type": {
                    actionType = ActionType.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    continue block18;
                }
                case "method": {
                    method = parser.text();
                    continue block18;
                }
                case "url": {
                    url = parser.text();
                    continue block18;
                }
                case "headers": {
                    headers = parser.mapStrings();
                    continue block18;
                }
                case "request_body": {
                    requestBody = parser.text();
                    continue block18;
                }
                case "pre_process_function": {
                    preProcessFunction = parser.text();
                    continue block18;
                }
                case "post_process_function": {
                    postProcessFunction = parser.text();
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return ConnectorAction.builder().actionType(actionType).method(method).url(url).headers(headers).requestBody(requestBody).preProcessFunction(preProcessFunction).postProcessFunction(postProcessFunction).build();
    }

    @Generated
    public static ConnectorActionBuilder builder() {
        return new ConnectorActionBuilder();
    }

    @Generated
    public ConnectorActionBuilder toBuilder() {
        return new ConnectorActionBuilder().actionType(this.actionType).method(this.method).url(this.url).headers(this.headers).requestBody(this.requestBody).preProcessFunction(this.preProcessFunction).postProcessFunction(this.postProcessFunction);
    }

    @Generated
    public ActionType getActionType() {
        return this.actionType;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getRequestBody() {
        return this.requestBody;
    }

    @Generated
    public String getPreProcessFunction() {
        return this.preProcessFunction;
    }

    @Generated
    public String getPostProcessFunction() {
        return this.postProcessFunction;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorAction)) {
            return false;
        }
        ConnectorAction other = (ConnectorAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ActionType this$actionType = this.getActionType();
        ActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$requestBody = this.getRequestBody();
        String other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        String this$preProcessFunction = this.getPreProcessFunction();
        String other$preProcessFunction = other.getPreProcessFunction();
        if (this$preProcessFunction == null ? other$preProcessFunction != null : !this$preProcessFunction.equals(other$preProcessFunction)) {
            return false;
        }
        String this$postProcessFunction = this.getPostProcessFunction();
        String other$postProcessFunction = other.getPostProcessFunction();
        return !(this$postProcessFunction == null ? other$postProcessFunction != null : !this$postProcessFunction.equals(other$postProcessFunction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConnectorAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        String $preProcessFunction = this.getPreProcessFunction();
        result = result * 59 + ($preProcessFunction == null ? 43 : $preProcessFunction.hashCode());
        String $postProcessFunction = this.getPostProcessFunction();
        result = result * 59 + ($postProcessFunction == null ? 43 : $postProcessFunction.hashCode());
        return result;
    }

    public static enum ActionType {
        PREDICT;

    }

    @Generated
    public static class ConnectorActionBuilder {
        @Generated
        private ActionType actionType;
        @Generated
        private String method;
        @Generated
        private String url;
        @Generated
        private Map<String, String> headers;
        @Generated
        private String requestBody;
        @Generated
        private String preProcessFunction;
        @Generated
        private String postProcessFunction;

        @Generated
        ConnectorActionBuilder() {
        }

        @Generated
        public ConnectorActionBuilder actionType(ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        @Generated
        public ConnectorActionBuilder method(String method) {
            this.method = method;
            return this;
        }

        @Generated
        public ConnectorActionBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public ConnectorActionBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public ConnectorActionBuilder requestBody(String requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        @Generated
        public ConnectorActionBuilder preProcessFunction(String preProcessFunction) {
            this.preProcessFunction = preProcessFunction;
            return this;
        }

        @Generated
        public ConnectorActionBuilder postProcessFunction(String postProcessFunction) {
            this.postProcessFunction = postProcessFunction;
            return this;
        }

        @Generated
        public ConnectorAction build() {
            return new ConnectorAction(this.actionType, this.method, this.url, this.headers, this.requestBody, this.preProcessFunction, this.postProcessFunction);
        }

        @Generated
        public String toString() {
            return "ConnectorAction.ConnectorActionBuilder(actionType=" + String.valueOf((Object)this.actionType) + ", method=" + this.method + ", url=" + this.url + ", headers=" + String.valueOf(this.headers) + ", requestBody=" + this.requestBody + ", preProcessFunction=" + this.preProcessFunction + ", postProcessFunction=" + this.postProcessFunction + ")";
        }
    }
}

