/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataset.remote;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.annotation.InputDataSet;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;

@InputDataSet(value=MLInputDataType.REMOTE)
public class RemoteInferenceInputDataSet
extends MLInputDataset {
    private Map<String, String> parameters;

    public RemoteInferenceInputDataSet(Map<String, String> parameters) {
        super(MLInputDataType.REMOTE);
        this.parameters = parameters;
    }

    public RemoteInferenceInputDataSet(StreamInput streamInput) throws IOException {
        super(MLInputDataType.REMOTE);
        if (streamInput.readBoolean()) {
            this.parameters = streamInput.readMap(s -> s.readString(), s -> s.readString());
        }
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        if (this.parameters != null) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            streamOutput.writeBoolean(false);
        }
    }

    @Generated
    public static RemoteInferenceInputDataSetBuilder builder() {
        return new RemoteInferenceInputDataSetBuilder();
    }

    @Generated
    public RemoteInferenceInputDataSetBuilder toBuilder() {
        return new RemoteInferenceInputDataSetBuilder().parameters(this.parameters);
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public static class RemoteInferenceInputDataSetBuilder {
        @Generated
        private Map<String, String> parameters;

        @Generated
        RemoteInferenceInputDataSetBuilder() {
        }

        @Generated
        public RemoteInferenceInputDataSetBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public RemoteInferenceInputDataSet build() {
            return new RemoteInferenceInputDataSet(this.parameters);
        }

        @Generated
        public String toString() {
            return "RemoteInferenceInputDataSet.RemoteInferenceInputDataSetBuilder(parameters=" + String.valueOf(this.parameters) + ")";
        }
    }
}

