/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.asyncquery;

import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.spark.asyncquery.AsyncQueryJobMetadataStorageService;
import org.opensearch.sql.spark.asyncquery.exceptions.AsyncQueryNotFoundException;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryId;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.execution.statestore.StateStore;

public class OpensearchAsyncQueryJobMetadataStorageService
implements AsyncQueryJobMetadataStorageService {
    private final StateStore stateStore;
    private static final Logger LOGGER = LogManager.getLogger(OpensearchAsyncQueryJobMetadataStorageService.class);

    @Override
    public void storeJobMetadata(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        AsyncQueryId queryId = asyncQueryJobMetadata.getQueryId();
        StateStore.createJobMetaData(this.stateStore, queryId.getDataSourceName()).apply(asyncQueryJobMetadata);
    }

    @Override
    public Optional<AsyncQueryJobMetadata> getJobMetadata(String qid) {
        try {
            AsyncQueryId queryId = new AsyncQueryId(qid);
            return StateStore.getJobMetaData(this.stateStore, queryId.getDataSourceName()).apply(queryId.docId());
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching the job metadata.", (Throwable)e);
            throw new AsyncQueryNotFoundException(String.format("Invalid QueryId: %s", qid));
        }
    }

    @Generated
    public OpensearchAsyncQueryJobMetadataStorageService(StateStore stateStore) {
        this.stateStore = stateStore;
    }
}

