/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.session;

import java.util.Optional;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.spark.client.EMRServerlessClientFactory;
import org.opensearch.sql.spark.execution.session.CreateSessionRequest;
import org.opensearch.sql.spark.execution.session.InteractiveSession;
import org.opensearch.sql.spark.execution.session.Session;
import org.opensearch.sql.spark.execution.session.SessionId;
import org.opensearch.sql.spark.execution.session.SessionModel;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.utils.RealTimeProvider;

public class SessionManager {
    private final StateStore stateStore;
    private final EMRServerlessClientFactory emrServerlessClientFactory;
    private Settings settings;

    public SessionManager(StateStore stateStore, EMRServerlessClientFactory emrServerlessClientFactory, Settings settings) {
        this.stateStore = stateStore;
        this.emrServerlessClientFactory = emrServerlessClientFactory;
        this.settings = settings;
    }

    public Session createSession(CreateSessionRequest request) {
        InteractiveSession session = InteractiveSession.builder().sessionId(SessionId.newSessionId(request.getDatasourceName())).stateStore(this.stateStore).serverlessClient(this.emrServerlessClientFactory.getClient()).build();
        session.open(request);
        return session;
    }

    public Optional<Session> getSession(SessionId sid, String dataSourceName) {
        Optional<SessionModel> model = StateStore.getSession(this.stateStore, dataSourceName).apply(sid.getSessionId());
        if (model.isPresent()) {
            InteractiveSession session = InteractiveSession.builder().sessionId(sid).stateStore(this.stateStore).serverlessClient(this.emrServerlessClientFactory.getClient()).sessionModel(model.get()).sessionInactivityTimeoutMilli((Long)this.settings.getSettingValue(Settings.Key.SESSION_INACTIVITY_TIMEOUT_MILLIS)).timeProvider(new RealTimeProvider()).build();
            return Optional.ofNullable(session);
        }
        return Optional.empty();
    }

    public Optional<Session> getSession(SessionId sid) {
        return this.getSession(sid, sid.getDataSourceName());
    }

    public boolean isEnabled() {
        return true;
    }
}

