# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network vpn-connection update",
)
class Update(AAZCommand):
    """Update a VPN connection.

    :example: Add BGP to an existing connection.
        az network vpn-connection update -g MyResourceGroup -n MyConnection --enable-bgp True
    """

    _aaz_info = {
        "version": "2015-06-15",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/connections/{}", "2015-06-15"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Connection name.",
            required=True,
            id_part="name",
        )
        _args_schema.enable_bgp = AAZBoolArg(
            options=["--enable-bgp"],
            help="Enable BGP (Border Gateway Protocol).",
            nullable=True,
        )
        _args_schema.routing_weight = AAZIntArg(
            options=["--routing-weight"],
            help="Connection routing weight.",
            nullable=True,
        )
        _args_schema.shared_key = AAZStrArg(
            options=["--shared-key"],
            help="Shared IPSec key.",
            nullable=True,
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...]. Use \"\" to clear existing tags.",
            nullable=True,
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "Parameters"

        # define Arg Group "Properties"
        return cls._args_schema

    _args_address_space_update = None

    @classmethod
    def _build_args_address_space_update(cls, _schema):
        if cls._args_address_space_update is not None:
            _schema.address_prefixes = cls._args_address_space_update.address_prefixes
            return

        cls._args_address_space_update = AAZObjectArg(
            nullable=True,
        )

        address_space_update = cls._args_address_space_update
        address_space_update.address_prefixes = AAZListArg(
            options=["address-prefixes"],
            help="A list of address blocks reserved for this virtual network in CIDR notation.",
            nullable=True,
        )

        address_prefixes = cls._args_address_space_update.address_prefixes
        address_prefixes.Element = AAZStrArg(
            nullable=True,
        )

        _schema.address_prefixes = cls._args_address_space_update.address_prefixes

    _args_bgp_settings_update = None

    @classmethod
    def _build_args_bgp_settings_update(cls, _schema):
        if cls._args_bgp_settings_update is not None:
            _schema.asn = cls._args_bgp_settings_update.asn
            _schema.bgp_peering_address = cls._args_bgp_settings_update.bgp_peering_address
            _schema.peer_weight = cls._args_bgp_settings_update.peer_weight
            return

        cls._args_bgp_settings_update = AAZObjectArg(
            nullable=True,
        )

        bgp_settings_update = cls._args_bgp_settings_update
        bgp_settings_update.asn = AAZIntArg(
            options=["asn"],
            help="The BGP speaker's ASN.",
            nullable=True,
        )
        bgp_settings_update.bgp_peering_address = AAZStrArg(
            options=["bgp-peering-address"],
            help="The BGP peering address and BGP identifier of this BGP speaker.",
            nullable=True,
        )
        bgp_settings_update.peer_weight = AAZIntArg(
            options=["peer-weight"],
            help="The weight added to routes learned from this BGP speaker.",
            nullable=True,
        )

        _schema.asn = cls._args_bgp_settings_update.asn
        _schema.bgp_peering_address = cls._args_bgp_settings_update.bgp_peering_address
        _schema.peer_weight = cls._args_bgp_settings_update.peer_weight

    _args_sub_resource_update = None

    @classmethod
    def _build_args_sub_resource_update(cls, _schema):
        if cls._args_sub_resource_update is not None:
            _schema.id = cls._args_sub_resource_update.id
            return

        cls._args_sub_resource_update = AAZObjectArg(
            nullable=True,
        )

        sub_resource_update = cls._args_sub_resource_update
        sub_resource_update.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
        )

        _schema.id = cls._args_sub_resource_update.id

    _args_virtual_network_gateway_update = None

    @classmethod
    def _build_args_virtual_network_gateway_update(cls, _schema):
        if cls._args_virtual_network_gateway_update is not None:
            _schema.bgp_settings = cls._args_virtual_network_gateway_update.bgp_settings
            _schema.enable_bgp = cls._args_virtual_network_gateway_update.enable_bgp
            _schema.etag = cls._args_virtual_network_gateway_update.etag
            _schema.gateway_default_site = cls._args_virtual_network_gateway_update.gateway_default_site
            _schema.gateway_type = cls._args_virtual_network_gateway_update.gateway_type
            _schema.ip_configurations = cls._args_virtual_network_gateway_update.ip_configurations
            _schema.location = cls._args_virtual_network_gateway_update.location
            _schema.provisioning_state = cls._args_virtual_network_gateway_update.provisioning_state
            _schema.resource_guid = cls._args_virtual_network_gateway_update.resource_guid
            _schema.sku = cls._args_virtual_network_gateway_update.sku
            _schema.tags = cls._args_virtual_network_gateway_update.tags
            _schema.vpn_client_configuration = cls._args_virtual_network_gateway_update.vpn_client_configuration
            _schema.vpn_type = cls._args_virtual_network_gateway_update.vpn_type
            return

        cls._args_virtual_network_gateway_update = AAZObjectArg(
            nullable=True,
        )

        virtual_network_gateway_update = cls._args_virtual_network_gateway_update
        virtual_network_gateway_update.etag = AAZStrArg(
            options=["etag"],
            help="Gets a unique read-only string that changes whenever the resource is updated.",
            nullable=True,
        )
        virtual_network_gateway_update.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            nullable=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        virtual_network_gateway_update.bgp_settings = AAZObjectArg(
            options=["bgp-settings"],
            help="Virtual network gateway's BGP speaker settings.",
            nullable=True,
        )
        cls._build_args_bgp_settings_update(virtual_network_gateway_update.bgp_settings)
        virtual_network_gateway_update.enable_bgp = AAZBoolArg(
            options=["enable-bgp"],
            help="Whether BGP is enabled for this virtual network gateway or not.",
            nullable=True,
        )
        virtual_network_gateway_update.gateway_default_site = AAZObjectArg(
            options=["gateway-default-site"],
            help="The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.",
            nullable=True,
        )
        cls._build_args_sub_resource_update(virtual_network_gateway_update.gateway_default_site)
        virtual_network_gateway_update.gateway_type = AAZStrArg(
            options=["gateway-type"],
            help="The type of this virtual network gateway.",
            nullable=True,
            enum={"ExpressRoute": "ExpressRoute", "Vpn": "Vpn"},
        )
        virtual_network_gateway_update.ip_configurations = AAZListArg(
            options=["ip-configurations"],
            help="IP configurations for virtual network gateway.",
            nullable=True,
        )
        virtual_network_gateway_update.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the VirtualNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
            nullable=True,
        )
        virtual_network_gateway_update.resource_guid = AAZStrArg(
            options=["resource-guid"],
            help="The resource GUID property of the VirtualNetworkGateway resource.",
            nullable=True,
        )
        virtual_network_gateway_update.sku = AAZObjectArg(
            options=["sku"],
            help="The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.",
            nullable=True,
        )
        virtual_network_gateway_update.vpn_client_configuration = AAZObjectArg(
            options=["vpn-client-configuration"],
            help="The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.",
            nullable=True,
        )
        virtual_network_gateway_update.vpn_type = AAZStrArg(
            options=["vpn-type"],
            help="The type of this virtual network gateway.",
            nullable=True,
            enum={"PolicyBased": "PolicyBased", "RouteBased": "RouteBased"},
        )
        virtual_network_gateway_update.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
            nullable=True,
        )

        ip_configurations = cls._args_virtual_network_gateway_update.ip_configurations
        ip_configurations.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_virtual_network_gateway_update.ip_configurations.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
            nullable=True,
        )
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
            nullable=True,
        )
        _element.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
            help="Gets or sets the privateIPAddress of the IP Configuration",
            nullable=True,
        )
        _element.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="The private IP address allocation method.",
            nullable=True,
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
            nullable=True,
        )
        _element.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="The reference to the public IP resource.",
            nullable=True,
        )
        cls._build_args_sub_resource_update(_element.public_ip_address)
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="The reference to the subnet resource.",
            nullable=True,
        )
        cls._build_args_sub_resource_update(_element.subnet)

        sku = cls._args_virtual_network_gateway_update.sku
        sku.capacity = AAZIntArg(
            options=["capacity"],
            help="The capacity.",
            nullable=True,
        )
        sku.name = AAZStrArg(
            options=["name"],
            help="Gateway SKU name.",
            nullable=True,
            enum={"Basic": "Basic", "HighPerformance": "HighPerformance", "Standard": "Standard"},
        )
        sku.tier = AAZStrArg(
            options=["tier"],
            help="Gateway SKU tier.",
            nullable=True,
            enum={"Basic": "Basic", "HighPerformance": "HighPerformance", "Standard": "Standard"},
        )

        vpn_client_configuration = cls._args_virtual_network_gateway_update.vpn_client_configuration
        vpn_client_configuration.vpn_client_address_pool = AAZObjectArg(
            options=["vpn-client-address-pool"],
            help="The reference to the address space resource which represents Address space for P2S VpnClient.",
            nullable=True,
        )
        cls._build_args_address_space_update(vpn_client_configuration.vpn_client_address_pool)
        vpn_client_configuration.vpn_client_revoked_certificates = AAZListArg(
            options=["vpn-client-revoked-certificates"],
            help="VpnClientRevokedCertificate for Virtual network gateway.",
            nullable=True,
        )
        vpn_client_configuration.vpn_client_root_certificates = AAZListArg(
            options=["vpn-client-root-certificates"],
            help="VpnClientRootCertificate for virtual network gateway.",
            nullable=True,
        )

        vpn_client_revoked_certificates = cls._args_virtual_network_gateway_update.vpn_client_configuration.vpn_client_revoked_certificates
        vpn_client_revoked_certificates.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_virtual_network_gateway_update.vpn_client_configuration.vpn_client_revoked_certificates.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
            nullable=True,
        )
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
            nullable=True,
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
            nullable=True,
        )
        _element.thumbprint = AAZStrArg(
            options=["thumbprint"],
            help="The revoked VPN client certificate thumbprint.",
            nullable=True,
        )

        vpn_client_root_certificates = cls._args_virtual_network_gateway_update.vpn_client_configuration.vpn_client_root_certificates
        vpn_client_root_certificates.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_virtual_network_gateway_update.vpn_client_configuration.vpn_client_root_certificates.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
            nullable=True,
        )
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
            nullable=True,
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
            nullable=True,
        )
        _element.public_cert_data = AAZStrArg(
            options=["public-cert-data"],
            help="The certificate public data.",
            nullable=True,
        )

        tags = cls._args_virtual_network_gateway_update.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        _schema.bgp_settings = cls._args_virtual_network_gateway_update.bgp_settings
        _schema.enable_bgp = cls._args_virtual_network_gateway_update.enable_bgp
        _schema.etag = cls._args_virtual_network_gateway_update.etag
        _schema.gateway_default_site = cls._args_virtual_network_gateway_update.gateway_default_site
        _schema.gateway_type = cls._args_virtual_network_gateway_update.gateway_type
        _schema.ip_configurations = cls._args_virtual_network_gateway_update.ip_configurations
        _schema.location = cls._args_virtual_network_gateway_update.location
        _schema.provisioning_state = cls._args_virtual_network_gateway_update.provisioning_state
        _schema.resource_guid = cls._args_virtual_network_gateway_update.resource_guid
        _schema.sku = cls._args_virtual_network_gateway_update.sku
        _schema.tags = cls._args_virtual_network_gateway_update.tags
        _schema.vpn_client_configuration = cls._args_virtual_network_gateway_update.vpn_client_configuration
        _schema.vpn_type = cls._args_virtual_network_gateway_update.vpn_type

    def _execute_operations(self):
        self.pre_operations()
        self.VirtualNetworkGatewayConnectionsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.VirtualNetworkGatewayConnectionsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualNetworkGatewayConnectionsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "virtualNetworkGatewayConnectionName", self.ctx.args.name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2015-06-15",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_virtual_network_gateway_connection_read(cls._schema_on_200)

            return cls._schema_on_200

    class VirtualNetworkGatewayConnectionsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "virtualNetworkGatewayConnectionName", self.ctx.args.name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2015-06-15",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_virtual_network_gateway_connection_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("enableBgp", AAZBoolType, ".enable_bgp")
                properties.set_prop("routingWeight", AAZIntType, ".routing_weight")
                properties.set_prop("sharedKey", AAZStrType, ".shared_key")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    @classmethod
    def _build_schema_address_space_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("addressPrefixes", AAZListType, ".address_prefixes")

        address_prefixes = _builder.get(".addressPrefixes")
        if address_prefixes is not None:
            address_prefixes.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_bgp_settings_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("asn", AAZIntType, ".asn")
        _builder.set_prop("bgpPeeringAddress", AAZStrType, ".bgp_peering_address")
        _builder.set_prop("peerWeight", AAZIntType, ".peer_weight")

    @classmethod
    def _build_schema_sub_resource_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_virtual_network_gateway_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
        _builder.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties")
        if properties is not None:
            cls._build_schema_bgp_settings_update(properties.set_prop("bgpSettings", AAZObjectType, ".bgp_settings"))
            properties.set_prop("enableBgp", AAZBoolType, ".enable_bgp")
            cls._build_schema_sub_resource_update(properties.set_prop("gatewayDefaultSite", AAZObjectType, ".gateway_default_site"))
            properties.set_prop("gatewayType", AAZStrType, ".gateway_type")
            properties.set_prop("ipConfigurations", AAZListType, ".ip_configurations")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("resourceGuid", AAZStrType, ".resource_guid")
            properties.set_prop("sku", AAZObjectType, ".sku")
            properties.set_prop("vpnClientConfiguration", AAZObjectType, ".vpn_client_configuration")
            properties.set_prop("vpnType", AAZStrType, ".vpn_type")

        ip_configurations = _builder.get(".properties.ipConfigurations")
        if ip_configurations is not None:
            ip_configurations.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.ipConfigurations[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.ipConfigurations[].properties")
        if properties is not None:
            properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
            properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            cls._build_schema_sub_resource_update(properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address"))
            cls._build_schema_sub_resource_update(properties.set_prop("subnet", AAZObjectType, ".subnet"))

        sku = _builder.get(".properties.sku")
        if sku is not None:
            sku.set_prop("capacity", AAZIntType, ".capacity")
            sku.set_prop("name", AAZStrType, ".name")
            sku.set_prop("tier", AAZStrType, ".tier")

        vpn_client_configuration = _builder.get(".properties.vpnClientConfiguration")
        if vpn_client_configuration is not None:
            cls._build_schema_address_space_update(vpn_client_configuration.set_prop("vpnClientAddressPool", AAZObjectType, ".vpn_client_address_pool"))
            vpn_client_configuration.set_prop("vpnClientRevokedCertificates", AAZListType, ".vpn_client_revoked_certificates")
            vpn_client_configuration.set_prop("vpnClientRootCertificates", AAZListType, ".vpn_client_root_certificates")

        vpn_client_revoked_certificates = _builder.get(".properties.vpnClientConfiguration.vpnClientRevokedCertificates")
        if vpn_client_revoked_certificates is not None:
            vpn_client_revoked_certificates.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.vpnClientConfiguration.vpnClientRevokedCertificates[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.vpnClientConfiguration.vpnClientRevokedCertificates[].properties")
        if properties is not None:
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("thumbprint", AAZStrType, ".thumbprint")

        vpn_client_root_certificates = _builder.get(".properties.vpnClientConfiguration.vpnClientRootCertificates")
        if vpn_client_root_certificates is not None:
            vpn_client_root_certificates.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.vpnClientConfiguration.vpnClientRootCertificates[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.vpnClientConfiguration.vpnClientRootCertificates[].properties")
        if properties is not None:
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("publicCertData", AAZStrType, ".public_cert_data")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    _schema_address_space_read = None

    @classmethod
    def _build_schema_address_space_read(cls, _schema):
        if cls._schema_address_space_read is not None:
            _schema.address_prefixes = cls._schema_address_space_read.address_prefixes
            return

        cls._schema_address_space_read = _schema_address_space_read = AAZObjectType()

        address_space_read = _schema_address_space_read
        address_space_read.address_prefixes = AAZListType(
            serialized_name="addressPrefixes",
        )

        address_prefixes = _schema_address_space_read.address_prefixes
        address_prefixes.Element = AAZStrType()

        _schema.address_prefixes = cls._schema_address_space_read.address_prefixes

    _schema_bgp_settings_read = None

    @classmethod
    def _build_schema_bgp_settings_read(cls, _schema):
        if cls._schema_bgp_settings_read is not None:
            _schema.asn = cls._schema_bgp_settings_read.asn
            _schema.bgp_peering_address = cls._schema_bgp_settings_read.bgp_peering_address
            _schema.peer_weight = cls._schema_bgp_settings_read.peer_weight
            return

        cls._schema_bgp_settings_read = _schema_bgp_settings_read = AAZObjectType()

        bgp_settings_read = _schema_bgp_settings_read
        bgp_settings_read.asn = AAZIntType()
        bgp_settings_read.bgp_peering_address = AAZStrType(
            serialized_name="bgpPeeringAddress",
        )
        bgp_settings_read.peer_weight = AAZIntType(
            serialized_name="peerWeight",
        )

        _schema.asn = cls._schema_bgp_settings_read.asn
        _schema.bgp_peering_address = cls._schema_bgp_settings_read.bgp_peering_address
        _schema.peer_weight = cls._schema_bgp_settings_read.peer_weight

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_virtual_network_gateway_connection_read = None

    @classmethod
    def _build_schema_virtual_network_gateway_connection_read(cls, _schema):
        if cls._schema_virtual_network_gateway_connection_read is not None:
            _schema.etag = cls._schema_virtual_network_gateway_connection_read.etag
            _schema.id = cls._schema_virtual_network_gateway_connection_read.id
            _schema.location = cls._schema_virtual_network_gateway_connection_read.location
            _schema.name = cls._schema_virtual_network_gateway_connection_read.name
            _schema.properties = cls._schema_virtual_network_gateway_connection_read.properties
            _schema.tags = cls._schema_virtual_network_gateway_connection_read.tags
            _schema.type = cls._schema_virtual_network_gateway_connection_read.type
            return

        cls._schema_virtual_network_gateway_connection_read = _schema_virtual_network_gateway_connection_read = AAZObjectType()

        virtual_network_gateway_connection_read = _schema_virtual_network_gateway_connection_read
        virtual_network_gateway_connection_read.etag = AAZStrType()
        virtual_network_gateway_connection_read.id = AAZStrType()
        virtual_network_gateway_connection_read.location = AAZStrType()
        virtual_network_gateway_connection_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_gateway_connection_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        virtual_network_gateway_connection_read.tags = AAZDictType()
        virtual_network_gateway_connection_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_gateway_connection_read.properties
        properties.authorization_key = AAZStrType(
            serialized_name="authorizationKey",
        )
        properties.connection_status = AAZStrType(
            serialized_name="connectionStatus",
        )
        properties.connection_type = AAZStrType(
            serialized_name="connectionType",
        )
        properties.egress_bytes_transferred = AAZIntType(
            serialized_name="egressBytesTransferred",
        )
        properties.enable_bgp = AAZBoolType(
            serialized_name="enableBgp",
        )
        properties.ingress_bytes_transferred = AAZIntType(
            serialized_name="ingressBytesTransferred",
        )
        properties.local_network_gateway2 = AAZObjectType(
            serialized_name="localNetworkGateway2",
        )
        properties.peer = AAZObjectType()
        cls._build_schema_sub_resource_read(properties.peer)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.routing_weight = AAZIntType(
            serialized_name="routingWeight",
        )
        properties.shared_key = AAZStrType(
            serialized_name="sharedKey",
        )
        properties.virtual_network_gateway1 = AAZObjectType(
            serialized_name="virtualNetworkGateway1",
        )
        cls._build_schema_virtual_network_gateway_read(properties.virtual_network_gateway1)
        properties.virtual_network_gateway2 = AAZObjectType(
            serialized_name="virtualNetworkGateway2",
        )
        cls._build_schema_virtual_network_gateway_read(properties.virtual_network_gateway2)

        local_network_gateway2 = _schema_virtual_network_gateway_connection_read.properties.local_network_gateway2
        local_network_gateway2.etag = AAZStrType()
        local_network_gateway2.id = AAZStrType()
        local_network_gateway2.location = AAZStrType()
        local_network_gateway2.name = AAZStrType(
            flags={"read_only": True},
        )
        local_network_gateway2.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        local_network_gateway2.tags = AAZDictType()
        local_network_gateway2.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_gateway_connection_read.properties.local_network_gateway2.properties
        properties.bgp_settings = AAZObjectType(
            serialized_name="bgpSettings",
        )
        cls._build_schema_bgp_settings_read(properties.bgp_settings)
        properties.gateway_ip_address = AAZStrType(
            serialized_name="gatewayIpAddress",
        )
        properties.local_network_address_space = AAZObjectType(
            serialized_name="localNetworkAddressSpace",
        )
        cls._build_schema_address_space_read(properties.local_network_address_space)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )

        tags = _schema_virtual_network_gateway_connection_read.properties.local_network_gateway2.tags
        tags.Element = AAZStrType()

        tags = _schema_virtual_network_gateway_connection_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_network_gateway_connection_read.etag
        _schema.id = cls._schema_virtual_network_gateway_connection_read.id
        _schema.location = cls._schema_virtual_network_gateway_connection_read.location
        _schema.name = cls._schema_virtual_network_gateway_connection_read.name
        _schema.properties = cls._schema_virtual_network_gateway_connection_read.properties
        _schema.tags = cls._schema_virtual_network_gateway_connection_read.tags
        _schema.type = cls._schema_virtual_network_gateway_connection_read.type

    _schema_virtual_network_gateway_read = None

    @classmethod
    def _build_schema_virtual_network_gateway_read(cls, _schema):
        if cls._schema_virtual_network_gateway_read is not None:
            _schema.etag = cls._schema_virtual_network_gateway_read.etag
            _schema.id = cls._schema_virtual_network_gateway_read.id
            _schema.location = cls._schema_virtual_network_gateway_read.location
            _schema.name = cls._schema_virtual_network_gateway_read.name
            _schema.properties = cls._schema_virtual_network_gateway_read.properties
            _schema.tags = cls._schema_virtual_network_gateway_read.tags
            _schema.type = cls._schema_virtual_network_gateway_read.type
            return

        cls._schema_virtual_network_gateway_read = _schema_virtual_network_gateway_read = AAZObjectType()

        virtual_network_gateway_read = _schema_virtual_network_gateway_read
        virtual_network_gateway_read.etag = AAZStrType()
        virtual_network_gateway_read.id = AAZStrType()
        virtual_network_gateway_read.location = AAZStrType()
        virtual_network_gateway_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_gateway_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        virtual_network_gateway_read.tags = AAZDictType()
        virtual_network_gateway_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_gateway_read.properties
        properties.bgp_settings = AAZObjectType(
            serialized_name="bgpSettings",
        )
        cls._build_schema_bgp_settings_read(properties.bgp_settings)
        properties.enable_bgp = AAZBoolType(
            serialized_name="enableBgp",
        )
        properties.gateway_default_site = AAZObjectType(
            serialized_name="gatewayDefaultSite",
        )
        cls._build_schema_sub_resource_read(properties.gateway_default_site)
        properties.gateway_type = AAZStrType(
            serialized_name="gatewayType",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.sku = AAZObjectType()
        properties.vpn_client_configuration = AAZObjectType(
            serialized_name="vpnClientConfiguration",
        )
        properties.vpn_type = AAZStrType(
            serialized_name="vpnType",
        )

        ip_configurations = _schema_virtual_network_gateway_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.ip_configurations.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.ip_configurations.Element.properties
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_sub_resource_read(properties.subnet)

        sku = _schema_virtual_network_gateway_read.properties.sku
        sku.capacity = AAZIntType()
        sku.name = AAZStrType()
        sku.tier = AAZStrType()

        vpn_client_configuration = _schema_virtual_network_gateway_read.properties.vpn_client_configuration
        vpn_client_configuration.vpn_client_address_pool = AAZObjectType(
            serialized_name="vpnClientAddressPool",
        )
        cls._build_schema_address_space_read(vpn_client_configuration.vpn_client_address_pool)
        vpn_client_configuration.vpn_client_revoked_certificates = AAZListType(
            serialized_name="vpnClientRevokedCertificates",
        )
        vpn_client_configuration.vpn_client_root_certificates = AAZListType(
            serialized_name="vpnClientRootCertificates",
        )

        vpn_client_revoked_certificates = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_revoked_certificates
        vpn_client_revoked_certificates.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_revoked_certificates.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_revoked_certificates.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.thumbprint = AAZStrType()

        vpn_client_root_certificates = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_root_certificates
        vpn_client_root_certificates.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_root_certificates.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_root_certificates.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_cert_data = AAZStrType(
            serialized_name="publicCertData",
        )

        tags = _schema_virtual_network_gateway_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_network_gateway_read.etag
        _schema.id = cls._schema_virtual_network_gateway_read.id
        _schema.location = cls._schema_virtual_network_gateway_read.location
        _schema.name = cls._schema_virtual_network_gateway_read.name
        _schema.properties = cls._schema_virtual_network_gateway_read.properties
        _schema.tags = cls._schema_virtual_network_gateway_read.tags
        _schema.type = cls._schema_virtual_network_gateway_read.type


__all__ = ["Update"]
