import * as LSP from 'vscode-languageserver/node';
import * as Parser from 'web-tree-sitter';
export type GlobalDeclarations = {
    [word: string]: LSP.SymbolInformation;
};
export type Declarations = {
    [word: string]: LSP.SymbolInformation[];
};
/**
 * Returns declarations (functions or variables) from a given root node
 * that would be available after sourcing the file. This currently does
 * not include global variables defined inside if statements or functions
 * as we do not do any flow tracing.
 *
 * Will only return one declaration per symbol name – the latest definition.
 * This behavior is consistent with how Bash behaves, but differs between
 * LSP servers.
 *
 * Used when finding declarations for sourced files and to get declarations
 * for the entire workspace.
 */
export declare function getGlobalDeclarations({ tree, uri, }: {
    tree: Parser.Tree;
    uri: string;
}): GlobalDeclarations;
/**
 * Returns all declarations (functions or variables) from a given tree.
 * This includes local variables.
 */
export declare function getAllDeclarationsInTree({ tree, uri, }: {
    tree: Parser.Tree;
    uri: string;
}): LSP.SymbolInformation[];
/**
 * Returns declarations available for the given file and location.
 * The heuristics used is a simplification compared to bash behaviour,
 * but deemed good enough, compared to the complexity of flow tracing.
 *
 * Used when getting declarations for the current scope.
 */
export declare function getLocalDeclarations({ node, rootNode, uri, }: {
    node: Parser.SyntaxNode | null;
    rootNode: Parser.SyntaxNode;
    uri: string;
}): Declarations;
