#!/usr/bin/env node
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 634:
/***/ ((module) => {

module.exports = require("open");

/***/ }),

/***/ 269:
/***/ ((module) => {

module.exports = require("url");

/***/ }),

/***/ 147:
/***/ ((module) => {

module.exports = JSON.parse('{"name":"@bitwarden/cli","description":"A secure and free password manager for all of your devices.","version":"2024.4.1","keywords":["bitwarden","password","vault","password manager","cli"],"author":"Bitwarden Inc. <hello@bitwarden.com> (https://bitwarden.com)","homepage":"https://bitwarden.com","repository":{"type":"git","url":"https://github.com/bitwarden/clients"},"license":"GPL-3.0-only","scripts":{"clean":"rimraf dist","build":"webpack","build:debug":"npm run build && node --inspect ./build/bw.js","build:watch":"webpack --watch","build:prod":"cross-env NODE_ENV=production webpack","build:prod:watch":"cross-env NODE_ENV=production webpack --watch","package":"npm run package:win && npm run package:mac && npm run package:lin","package:win":"pkg . --targets win-x64 --output ./dist/windows/bw.exe","package:mac":"pkg . --targets macos-x64 --output ./dist/macos/bw","package:lin":"pkg . --targets linux-x64 --output ./dist/linux/bw","debug":"node --inspect ./build/bw.js","dist":"npm run build:prod && npm run clean && npm run package","dist:win":"npm run build:prod && npm run clean && npm run package:win","dist:mac":"npm run build:prod && npm run clean && npm run package:mac","dist:lin":"npm run build:prod && npm run clean && npm run package:lin","publish:npm":"npm run build:prod && npm publish --access public","test":"jest","test:watch":"jest --watch","test:watch:all":"jest --watchAll"},"bin":{"bw":"build/bw.js"},"pkg":{"assets":["./build/**/*","../../node_modules/argon2/**/*"]},"dependencies":{"@koa/multer":"3.0.2","@koa/router":"12.0.1","argon2":"0.31.0","big-integer":"1.6.51","browser-hrtime":"1.1.8","chalk":"4.1.2","commander":"11.1.0","form-data":"4.0.0","https-proxy-agent":"7.0.2","inquirer":"8.2.6","jsdom":"23.0.1","jszip":"3.10.1","koa":"2.15.0","koa-bodyparser":"4.4.1","koa-json":"2.0.2","lowdb":"1.0.0","lunr":"2.3.9","multer":"1.4.5-lts.1","node-fetch":"2.6.12","node-forge":"1.3.1","open":"8.4.2","papaparse":"5.4.1","proper-lockfile":"4.1.2","rxjs":"7.8.1","tldts":"6.1.16","zxcvbn":"4.4.2"}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {

// UNUSED EXPORTS: Main

;// CONCATENATED MODULE: external "fs"
const external_fs_namespaceObject = require("fs");
;// CONCATENATED MODULE: external "path"
const external_path_namespaceObject = require("path");
;// CONCATENATED MODULE: external "commander"
const external_commander_namespaceObject = require("commander");
;// CONCATENATED MODULE: external "jsdom"
const external_jsdom_namespaceObject = require("jsdom");
;// CONCATENATED MODULE: external "rxjs"
const external_rxjs_namespaceObject = require("rxjs");
;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/authentication-type.ts
var AuthenticationType;
(function (AuthenticationType) {
    AuthenticationType[AuthenticationType["Password"] = 0] = "Password";
    AuthenticationType[AuthenticationType["Sso"] = 1] = "Sso";
    AuthenticationType[AuthenticationType["UserApiKey"] = 2] = "UserApiKey";
    AuthenticationType[AuthenticationType["AuthRequest"] = 3] = "AuthRequest";
    AuthenticationType[AuthenticationType["WebAuthn"] = 4] = "WebAuthn";
})(AuthenticationType || (AuthenticationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/token-two-factor.request.ts
class TokenTwoFactorRequest {
    constructor(provider = null, token = null, remember = false) {
        this.provider = provider;
        this.token = token;
        this.remember = remember;
    }
}

;// CONCATENATED MODULE: external "buffer/"
const _namespaceObject = require("buffer/");
;// CONCATENATED MODULE: external "tldts"
const external_tldts_namespaceObject = require("tldts");
;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/utils.ts
/* eslint-disable no-useless-escape */




const nodeURL = typeof window === "undefined" ? __webpack_require__(269) : null;
class Utils {
    static init() {
        if (Utils.inited) {
            return;
        }
        Utils.inited = true;
        Utils.isNode =
            typeof process !== "undefined" &&
                process.release != null &&
                process.release.name === "node";
        Utils.isBrowser = typeof window !== "undefined";
        Utils.isMobileBrowser = Utils.isBrowser && this.isMobile(window);
        Utils.isAppleMobileBrowser = Utils.isBrowser && this.isAppleMobile(window);
        if (Utils.isNode) {
            Utils.global = global;
        }
        else if (Utils.isBrowser) {
            Utils.global = window;
        }
        else {
            // If it's not browser or node then it must be a service worker
            Utils.global = self;
        }
    }
    static fromB64ToArray(str) {
        if (str == null) {
            return null;
        }
        if (Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "base64"));
        }
        else {
            const binaryString = Utils.global.atob(str);
            const bytes = new Uint8Array(binaryString.length);
            for (let i = 0; i < binaryString.length; i++) {
                bytes[i] = binaryString.charCodeAt(i);
            }
            return bytes;
        }
    }
    static fromUrlB64ToArray(str) {
        return Utils.fromB64ToArray(Utils.fromUrlB64ToB64(str));
    }
    static fromHexToArray(str) {
        if (Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "hex"));
        }
        else {
            const bytes = new Uint8Array(str.length / 2);
            for (let i = 0; i < str.length; i += 2) {
                bytes[i / 2] = parseInt(str.substr(i, 2), 16);
            }
            return bytes;
        }
    }
    static fromUtf8ToArray(str) {
        if (Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "utf8"));
        }
        else {
            const strUtf8 = unescape(encodeURIComponent(str));
            const arr = new Uint8Array(strUtf8.length);
            for (let i = 0; i < strUtf8.length; i++) {
                arr[i] = strUtf8.charCodeAt(i);
            }
            return arr;
        }
    }
    static fromByteStringToArray(str) {
        if (str == null) {
            return null;
        }
        const arr = new Uint8Array(str.length);
        for (let i = 0; i < str.length; i++) {
            arr[i] = str.charCodeAt(i);
        }
        return arr;
    }
    static fromBufferToB64(buffer) {
        if (buffer == null) {
            return null;
        }
        if (Utils.isNode) {
            return Buffer.from(buffer).toString("base64");
        }
        else {
            let binary = "";
            const bytes = new Uint8Array(buffer);
            for (let i = 0; i < bytes.byteLength; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            return Utils.global.btoa(binary);
        }
    }
    static fromBufferToUrlB64(buffer) {
        return Utils.fromB64toUrlB64(Utils.fromBufferToB64(buffer));
    }
    static fromB64toUrlB64(b64Str) {
        return b64Str.replace(/\+/g, "-").replace(/\//g, "_").replace(/=/g, "");
    }
    static fromBufferToUtf8(buffer) {
        return _namespaceObject.Buffer.from(buffer).toString("utf8");
    }
    static fromBufferToByteString(buffer) {
        return String.fromCharCode.apply(null, new Uint8Array(buffer));
    }
    // ref: https://stackoverflow.com/a/40031979/1090359
    static fromBufferToHex(buffer) {
        if (Utils.isNode) {
            return Buffer.from(buffer).toString("hex");
        }
        else {
            const bytes = new Uint8Array(buffer);
            return Array.prototype.map
                .call(bytes, (x) => ("00" + x.toString(16)).slice(-2))
                .join("");
        }
    }
    /**
     * Converts a hex string to an ArrayBuffer.
     * Note: this doesn't need any Node specific code as parseInt() / ArrayBuffer / Uint8Array
     * work the same in Node and the browser.
     * @param {string} hexString - A string of hexadecimal characters.
     * @returns {ArrayBuffer} The ArrayBuffer representation of the hex string.
     */
    static hexStringToArrayBuffer(hexString) {
        // Check if the hexString has an even length, as each hex digit represents half a byte (4 bits),
        // and it takes two hex digits to represent a full byte (8 bits).
        if (hexString.length % 2 !== 0) {
            throw "HexString has to be an even length";
        }
        // Create an ArrayBuffer with a length that is half the length of the hex string,
        // because each pair of hex digits will become a single byte.
        const arrayBuffer = new ArrayBuffer(hexString.length / 2);
        // Create a Uint8Array view on top of the ArrayBuffer (each position represents a byte)
        // as ArrayBuffers cannot be edited directly.
        const uint8Array = new Uint8Array(arrayBuffer);
        // Loop through the bytes
        for (let i = 0; i < uint8Array.length; i++) {
            // Extract two hex characters (1 byte)
            const hexByte = hexString.substr(i * 2, 2);
            // Convert hexByte into a decimal value from base 16. (ex: ff --> 255)
            const byteValue = parseInt(hexByte, 16);
            // Place the byte value into the uint8Array
            uint8Array[i] = byteValue;
        }
        return arrayBuffer;
    }
    static fromUrlB64ToB64(urlB64Str) {
        let output = urlB64Str.replace(/-/g, "+").replace(/_/g, "/");
        switch (output.length % 4) {
            case 0:
                break;
            case 2:
                output += "==";
                break;
            case 3:
                output += "=";
                break;
            default:
                throw new Error("Illegal base64url string!");
        }
        return output;
    }
    static fromUrlB64ToUtf8(urlB64Str) {
        return Utils.fromB64ToUtf8(Utils.fromUrlB64ToB64(urlB64Str));
    }
    static fromUtf8ToB64(utfStr) {
        if (Utils.isNode) {
            return Buffer.from(utfStr, "utf8").toString("base64");
        }
        else {
            return decodeURIComponent(escape(Utils.global.btoa(utfStr)));
        }
    }
    static fromUtf8ToUrlB64(utfStr) {
        return Utils.fromBufferToUrlB64(Utils.fromUtf8ToArray(utfStr));
    }
    static fromB64ToUtf8(b64Str) {
        if (Utils.isNode) {
            return Buffer.from(b64Str, "base64").toString("utf8");
        }
        else {
            return decodeURIComponent(escape(Utils.global.atob(b64Str)));
        }
    }
    // ref: http://stackoverflow.com/a/2117523/1090359
    static newGuid() {
        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
            const r = (Math.random() * 16) | 0;
            const v = c === "x" ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    static isGuid(id) {
        return RegExp(Utils.guidRegex, "i").test(id);
    }
    static getHostname(uriString) {
        if (Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        if (uriString.startsWith("file:")) {
            return null;
        }
        // Does uriString contain invalid characters
        // TODO Needs to possibly be extended, although '!' is a reserved character
        if (uriString.indexOf("!") > 0) {
            return null;
        }
        try {
            const hostname = (0,external_tldts_namespaceObject.getHostname)(uriString, { validHosts: this.validHosts });
            if (hostname != null) {
                return hostname;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getHost(uriString) {
        const url = Utils.getUrl(uriString);
        try {
            return url != null && url.host !== "" ? url.host : null;
        }
        catch (_a) {
            return null;
        }
    }
    static getDomain(uriString) {
        if (Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        try {
            const parseResult = (0,external_tldts_namespaceObject.parse)(uriString, {
                validHosts: this.validHosts,
                allowPrivateDomains: true,
            });
            if (parseResult != null && parseResult.hostname != null) {
                if (parseResult.hostname === "localhost" || parseResult.isIp) {
                    return parseResult.hostname;
                }
                if (parseResult.domain != null) {
                    return parseResult.domain;
                }
                return null;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getQueryParams(uriString) {
        const url = Utils.getUrl(uriString);
        if (url == null || url.search == null || url.search === "") {
            return null;
        }
        const map = new Map();
        const pairs = (url.search[0] === "?" ? url.search.substr(1) : url.search).split("&");
        pairs.forEach((pair) => {
            const parts = pair.split("=");
            if (parts.length < 1) {
                return;
            }
            map.set(decodeURIComponent(parts[0]).toLowerCase(), parts[1] == null ? "" : decodeURIComponent(parts[1]));
        });
        return map;
    }
    static getSortFunction(i18nService, prop) {
        return (a, b) => {
            if (a[prop] == null && b[prop] != null) {
                return -1;
            }
            if (a[prop] != null && b[prop] == null) {
                return 1;
            }
            if (a[prop] == null && b[prop] == null) {
                return 0;
            }
            // The `as unknown as string` here is unfortunate because typescript doesn't property understand that the return of T[prop] will be a string
            return i18nService.collator
                ? i18nService.collator.compare(a[prop], b[prop])
                : a[prop].localeCompare(b[prop]);
        };
    }
    static isNullOrWhitespace(str) {
        return str == null || typeof str !== "string" || str.trim() === "";
    }
    static isNullOrEmpty(str) {
        return str == null || typeof str !== "string" || str == "";
    }
    static isPromise(obj) {
        return (obj != undefined && typeof obj["then"] === "function" && typeof obj["catch"] === "function");
    }
    static nameOf(name) {
        return name;
    }
    static assign(target, source) {
        return Object.assign(target, source);
    }
    static iterateEnum(obj) {
        return Object.keys(obj).filter((k) => Number.isNaN(+k)).map((k) => obj[k]);
    }
    static getUrl(uriString) {
        if (this.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        return Utils.getUrlObject(uriString);
    }
    static camelToPascalCase(s) {
        return s.charAt(0).toUpperCase() + s.slice(1);
    }
    /**
     * There are a few ways to calculate text color for contrast, this one seems to fit accessibility guidelines best.
     * https://stackoverflow.com/a/3943023/6869691
     *
     * @param {string} bgColor
     * @param {number} [threshold] see stackoverflow link above
     * @param {boolean} [svgTextFill]
     * Indicates if this method is performed on an SVG <text> 'fill' attribute (e.g. <text fill="black"></text>).
     * This check is necessary because the '!important' tag cannot be used in a 'fill' attribute.
     */
    static pickTextColorBasedOnBgColor(bgColor, threshold = 186, svgTextFill = false) {
        const bgColorHexNums = bgColor.charAt(0) === "#" ? bgColor.substring(1, 7) : bgColor;
        const r = parseInt(bgColorHexNums.substring(0, 2), 16); // hexToR
        const g = parseInt(bgColorHexNums.substring(2, 4), 16); // hexToG
        const b = parseInt(bgColorHexNums.substring(4, 6), 16); // hexToB
        const blackColor = svgTextFill ? "black" : "black !important";
        const whiteColor = svgTextFill ? "white" : "white !important";
        return r * 0.299 + g * 0.587 + b * 0.114 > threshold ? blackColor : whiteColor;
    }
    static stringToColor(str) {
        let hash = 0;
        for (let i = 0; i < str.length; i++) {
            hash = str.charCodeAt(i) + ((hash << 5) - hash);
        }
        let color = "#";
        for (let i = 0; i < 3; i++) {
            const value = (hash >> (i * 8)) & 0xff;
            color += ("00" + value.toString(16)).substr(-2);
        }
        return color;
    }
    /**
     * @throws Will throw an error if the ContainerService has not been attached to the window object
     */
    static getContainerService() {
        if (this.global.bitwardenContainerService == null) {
            throw new Error("global bitwardenContainerService not initialized.");
        }
        return this.global.bitwardenContainerService;
    }
    static validateHexColor(color) {
        return /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/.test(color);
    }
    /**
     * Converts map to a Record<string, V> with the same data. Inverse of recordToMap
     * Useful in toJSON methods, since Maps are not serializable
     * @param map
     * @returns
     */
    static mapToRecord(map) {
        if (map == null) {
            return null;
        }
        if (!(map instanceof Map)) {
            return map;
        }
        return Object.fromEntries(map);
    }
    /**
     * Converts record to a Map<string, V> with the same data. Inverse of mapToRecord
     * Useful in fromJSON methods, since Maps are not serializable
     *
     * Warning: If the record has string keys that are numbers, they will be converted to numbers in the map
     * @param record
     * @returns
     */
    static recordToMap(record) {
        if (record == null) {
            return null;
        }
        else if (record instanceof Map) {
            return record;
        }
        const entries = Object.entries(record);
        if (entries.length === 0) {
            return new Map();
        }
        if (isNaN(Number(entries[0][0]))) {
            return new Map(entries);
        }
        else {
            return new Map(entries.map((e) => [Number(e[0]), e[1]]));
        }
    }
    /** Applies Object.assign, but converts the type nicely using Type-Fest Merge<Destination, Source> */
    static merge(destination, source) {
        return Object.assign(destination, source);
    }
    /**
     * encodeURIComponent escapes all characters except the following:
     * alphabetic, decimal digits, - _ . ! ~ * ' ( )
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent#encoding_for_rfc3986
     */
    static encodeRFC3986URIComponent(str) {
        return encodeURIComponent(str).replace(/[!'()*]/g, (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`);
    }
    /**
     * Normalizes a path for defense against attacks like traversals
     * @param denormalizedPath
     * @returns
     */
    static normalizePath(denormalizedPath) {
        return external_path_namespaceObject.normalize(decodeURIComponent(denormalizedPath)).replace(/^(\.\.(\/|\\|$))+/, "");
    }
    static isMobile(win) {
        let mobile = false;
        ((a) => {
            if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) ||
                /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) {
                mobile = true;
            }
        })(win.navigator.userAgent || win.navigator.vendor || win.opera);
        return mobile || win.navigator.userAgent.match(/iPad/i) != null;
    }
    static delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    /**
     * Generate an observable from a function that returns a promise.
     * Similar to the rxjs function {@link from} with one big exception:
     * {@link from} will not re-execute the function when observers resubscribe.
     * {@link Util.asyncToObservable} will execute `generator` for every
     * subscribe, making it ideal if the value ever needs to be refreshed.
     * */
    static asyncToObservable(generator) {
        return (0,external_rxjs_namespaceObject.of)(undefined).pipe((0,external_rxjs_namespaceObject.switchMap)(() => generator()));
    }
    /**
     * Return the number of days remaining before a target date arrives.
     * Returns 0 if the day has already passed.
     */
    static daysRemaining(targetDate) {
        const diffTime = targetDate.getTime() - Date.now();
        const msPerDay = 86400000;
        return Math.max(0, Math.floor(diffTime / msPerDay));
    }
    static isAppleMobile(win) {
        return (win.navigator.userAgent.match(/iPhone/i) != null ||
            win.navigator.userAgent.match(/iPad/i) != null);
    }
    static getUrlObject(uriString) {
        // All the methods below require a protocol to properly parse a URL string
        // Assume http if no other protocol is present
        const hasProtocol = uriString.indexOf("://") > -1;
        if (!hasProtocol && uriString.indexOf(".") > -1) {
            uriString = "http://" + uriString;
        }
        else if (!hasProtocol) {
            return null;
        }
        try {
            if (nodeURL != null) {
                return new nodeURL.URL(uriString);
            }
            return new URL(uriString);
        }
        catch (e) {
            // Ignore error
        }
        return null;
    }
}
Utils.inited = false;
Utils.isNode = false;
Utils.isBrowser = true;
Utils.isMobileBrowser = false;
Utils.isAppleMobileBrowser = false;
Utils.global = null;
// Transpiled version of /\p{Emoji_Presentation}/gu using https://mothereff.in/regexpu. Used for compatability in older browsers.
Utils.regexpEmojiPresentation = /(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])/g;
Utils.validHosts = ["localhost"];
Utils.originalMinimumPasswordLength = 8;
Utils.minimumPasswordLength = 12;
Utils.DomainMatchBlacklist = new Map([
    ["google.com", new Set(["script.google.com"])],
]);
Utils.guidRegex = /^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/;
Utils.init();

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/webauthn-login/request/webauthn-login-response.request.ts

class WebAuthnLoginResponseRequest {
    constructor(credential) {
        this.id = credential.id;
        this.rawId = Utils.fromBufferToUrlB64(credential.rawId);
        this.type = credential.type;
        // WARNING: do not add PRF information here by mapping
        // credential.getClientExtensionResults() into the extensions property,
        // as it will be sent to the server (leaking credentials).
        this.extensions = {}; // Extensions are handled client-side
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/webauthn-login/request/webauthn-login-assertion-response.request.ts


class WebAuthnLoginAssertionResponseRequest extends WebAuthnLoginResponseRequest {
    constructor(credential) {
        super(credential);
        if (!(credential.response instanceof AuthenticatorAssertionResponse)) {
            throw new Error("Invalid authenticator response");
        }
        this.response = {
            authenticatorData: Utils.fromBufferToUrlB64(credential.response.authenticatorData),
            signature: Utils.fromBufferToUrlB64(credential.response.signature),
            clientDataJSON: Utils.fromBufferToUrlB64(credential.response.clientDataJSON),
            userHandle: Utils.fromBufferToUrlB64(credential.response.userHandle),
        };
    }
    static fromJSON(json) {
        return Object.assign(Object.create(WebAuthnLoginAssertionResponseRequest.prototype), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/encryption-type.enum.ts
var EncryptionType;
(function (EncryptionType) {
    EncryptionType[EncryptionType["AesCbc256_B64"] = 0] = "AesCbc256_B64";
    EncryptionType[EncryptionType["AesCbc128_HmacSha256_B64"] = 1] = "AesCbc128_HmacSha256_B64";
    EncryptionType[EncryptionType["AesCbc256_HmacSha256_B64"] = 2] = "AesCbc256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_B64"] = 3] = "Rsa2048_OaepSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_B64"] = 4] = "Rsa2048_OaepSha1_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_HmacSha256_B64"] = 5] = "Rsa2048_OaepSha256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_HmacSha256_B64"] = 6] = "Rsa2048_OaepSha1_HmacSha256_B64";
})(EncryptionType || (EncryptionType = {}));
/** The expected number of parts to a serialized EncString of the given encryption type.
 * For example, an EncString of type AesCbc256_B64 will have 2 parts, and an EncString of type
 * AesCbc128_HmacSha256_B64 will have 3 parts.
 *
 * Example of annotated serialized EncStrings:
 * 0.iv|data
 * 1.iv|data|mac
 * 2.iv|data|mac
 * 3.data
 * 4.data
 *
 * @see EncString
 * @see EncryptionType
 * @see EncString.parseEncryptedString
 */
const EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE = {
    [EncryptionType.AesCbc256_B64]: 2,
    [EncryptionType.AesCbc128_HmacSha256_B64]: 3,
    [EncryptionType.AesCbc256_HmacSha256_B64]: 3,
    [EncryptionType.Rsa2048_OaepSha256_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha1_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64]: 2,
    [EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64]: 2,
};

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/file-upload-type.enum.ts
var FileUploadType;
(function (FileUploadType) {
    FileUploadType[FileUploadType["Direct"] = 0] = "Direct";
    FileUploadType[FileUploadType["Azure"] = 1] = "Azure";
})(FileUploadType || (FileUploadType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/hash-purpose.enum.ts
var HashPurpose;
(function (HashPurpose) {
    HashPurpose[HashPurpose["ServerAuthorization"] = 1] = "ServerAuthorization";
    HashPurpose[HashPurpose["LocalAuthorization"] = 2] = "LocalAuthorization";
})(HashPurpose || (HashPurpose = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/html-storage-location.enum.ts
var HtmlStorageLocation;
(function (HtmlStorageLocation) {
    HtmlStorageLocation["Local"] = "local";
    HtmlStorageLocation["Memory"] = "memory";
    HtmlStorageLocation["Session"] = "session";
})(HtmlStorageLocation || (HtmlStorageLocation = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/kdf-config.ts
class KdfConfig {
    constructor(iterations, memory, parallelism) {
        this.iterations = iterations;
        this.memory = memory;
        this.parallelism = parallelism;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/range-with-default.ts
/**
 * A range with a default value.
 *
 * Enforces constraints to ensure min > default > max.
 */
class RangeWithDefault {
    constructor(min, max, defaultValue) {
        this.min = min;
        this.max = max;
        this.defaultValue = defaultValue;
        if (min > max) {
            throw new Error(`${min} is greater than ${max}.`);
        }
        if (this.inRange(defaultValue) === false) {
            throw new Error("Default value is not in range.");
        }
    }
    inRange(value) {
        return value >= this.min && value <= this.max;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/kdf-type.enum.ts


var KdfType;
(function (KdfType) {
    KdfType[KdfType["PBKDF2_SHA256"] = 0] = "PBKDF2_SHA256";
    KdfType[KdfType["Argon2id"] = 1] = "Argon2id";
})(KdfType || (KdfType = {}));
const ARGON2_MEMORY = new RangeWithDefault(16, 1024, 64);
const ARGON2_PARALLELISM = new RangeWithDefault(1, 16, 4);
const ARGON2_ITERATIONS = new RangeWithDefault(2, 10, 3);
const DEFAULT_KDF_TYPE = KdfType.PBKDF2_SHA256;
const PBKDF2_ITERATIONS = new RangeWithDefault(600000, 2000000, 600000);
const DEFAULT_KDF_CONFIG = new KdfConfig(PBKDF2_ITERATIONS.defaultValue);

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/key-suffix-options.enum.ts
var KeySuffixOptions;
(function (KeySuffixOptions) {
    KeySuffixOptions["Auto"] = "auto";
    KeySuffixOptions["Biometric"] = "biometric";
    KeySuffixOptions["Pin"] = "pin";
})(KeySuffixOptions || (KeySuffixOptions = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/log-level-type.enum.ts
var LogLevelType;
(function (LogLevelType) {
    LogLevelType[LogLevelType["Debug"] = 0] = "Debug";
    LogLevelType[LogLevelType["Info"] = 1] = "Info";
    LogLevelType[LogLevelType["Warning"] = 2] = "Warning";
    LogLevelType[LogLevelType["Error"] = 3] = "Error";
})(LogLevelType || (LogLevelType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/storage-location.enum.ts
var StorageLocation;
(function (StorageLocation) {
    StorageLocation["Both"] = "both";
    StorageLocation["Disk"] = "disk";
    StorageLocation["Memory"] = "memory";
})(StorageLocation || (StorageLocation = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/theme-type.enum.ts
var ThemeType;
(function (ThemeType) {
    ThemeType["System"] = "system";
    ThemeType["Light"] = "light";
    ThemeType["Dark"] = "dark";
    ThemeType["Nord"] = "nord";
    ThemeType["SolarizedDark"] = "solarizedDark";
})(ThemeType || (ThemeType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/index.ts










;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/symmetric-crypto-key.ts


class SymmetricCryptoKey {
    constructor(key, encType) {
        if (key == null) {
            throw new Error("Must provide key");
        }
        if (encType == null) {
            if (key.byteLength === 32) {
                encType = EncryptionType.AesCbc256_B64;
            }
            else if (key.byteLength === 64) {
                encType = EncryptionType.AesCbc256_HmacSha256_B64;
            }
            else {
                throw new Error("Unable to determine encType.");
            }
        }
        this.key = key;
        this.encType = encType;
        if (encType === EncryptionType.AesCbc256_B64 && key.byteLength === 32) {
            this.encKey = key;
            this.macKey = null;
        }
        else if (encType === EncryptionType.AesCbc128_HmacSha256_B64 && key.byteLength === 32) {
            this.encKey = key.slice(0, 16);
            this.macKey = key.slice(16, 32);
        }
        else if (encType === EncryptionType.AesCbc256_HmacSha256_B64 && key.byteLength === 64) {
            this.encKey = key.slice(0, 32);
            this.macKey = key.slice(32, 64);
        }
        else {
            throw new Error("Unsupported encType/key length.");
        }
        if (this.key != null) {
            this.keyB64 = Utils.fromBufferToB64(this.key);
        }
        if (this.encKey != null) {
            this.encKeyB64 = Utils.fromBufferToB64(this.encKey);
        }
        if (this.macKey != null) {
            this.macKeyB64 = Utils.fromBufferToB64(this.macKey);
        }
    }
    toJSON() {
        // The whole object is constructed from the initial key, so just store the B64 key
        return { keyB64: this.keyB64 };
    }
    static fromString(s) {
        if (s == null) {
            return null;
        }
        const arrayBuffer = Utils.fromB64ToArray(s);
        return new SymmetricCryptoKey(arrayBuffer);
    }
    static fromJSON(obj) {
        return SymmetricCryptoKey.fromString(obj === null || obj === void 0 ? void 0 : obj.keyB64);
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/models/domain/login-credentials.ts




class PasswordLoginCredentials {
    constructor(email, masterPassword, captchaToken, twoFactor) {
        this.email = email;
        this.masterPassword = masterPassword;
        this.captchaToken = captchaToken;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.Password;
    }
}
class SsoLoginCredentials {
    constructor(code, codeVerifier, redirectUrl, orgId, 
    /**
     * Optional email address for SSO login.
     * Used for looking up 2FA token on clients that support remembering 2FA token.
     */
    email, twoFactor) {
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.redirectUrl = redirectUrl;
        this.orgId = orgId;
        this.email = email;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.Sso;
    }
}
class UserApiLoginCredentials {
    constructor(clientId, clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.type = AuthenticationType.UserApiKey;
    }
}
class AuthRequestLoginCredentials {
    constructor(email, accessCode, authRequestId, decryptedUserKey, decryptedMasterKey, decryptedMasterKeyHash, twoFactor) {
        this.email = email;
        this.accessCode = accessCode;
        this.authRequestId = authRequestId;
        this.decryptedUserKey = decryptedUserKey;
        this.decryptedMasterKey = decryptedMasterKey;
        this.decryptedMasterKeyHash = decryptedMasterKeyHash;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.AuthRequest;
    }
    static fromJSON(json) {
        return Object.assign(new AuthRequestLoginCredentials(json.email, json.accessCode, json.authRequestId, null, null, json.decryptedMasterKeyHash, json.twoFactor
            ? new TokenTwoFactorRequest(json.twoFactor.provider, json.twoFactor.token, json.twoFactor.remember)
            : json.twoFactor), {
            decryptedUserKey: SymmetricCryptoKey.fromJSON(json.decryptedUserKey),
            decryptedMasterKey: SymmetricCryptoKey.fromJSON(json.decryptedMasterKey),
        });
    }
}
class WebAuthnLoginCredentials {
    constructor(token, deviceResponse, prfKey) {
        this.token = token;
        this.deviceResponse = deviceResponse;
        this.prfKey = prfKey;
        this.type = AuthenticationType.WebAuthn;
    }
    static fromJSON(json) {
        return new WebAuthnLoginCredentials(json.token, Object.assign(Object.create(WebAuthnLoginAssertionResponseRequest.prototype), json.deviceResponse), SymmetricCryptoKey.fromJSON(json.prfKey));
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/models/domain/user-decryption-options.ts
/**
 * Key Connector decryption options. Intended to be sent to the client for use after authentication.
 * @see {@link UserDecryptionOptions}
 */
class user_decryption_options_KeyConnectorUserDecryptionOption {
    /**
     * Initializes a new instance of the KeyConnectorUserDecryptionOption from a response object.
     * @param response The key connector user decryption option response object.
     * @returns A new instance of the KeyConnectorUserDecryptionOption or undefined if `response` is nullish.
     */
    static fromResponse(response) {
        var _a;
        if (response == null) {
            return undefined;
        }
        const options = new user_decryption_options_KeyConnectorUserDecryptionOption();
        options.keyConnectorUrl = (_a = response === null || response === void 0 ? void 0 : response.keyConnectorUrl) !== null && _a !== void 0 ? _a : null;
        return options;
    }
    /**
     * Initializes a new instance of a KeyConnectorUserDecryptionOption from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the KeyConnectorUserDecryptionOption or undefined if `obj` is nullish.
     */
    static fromJSON(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new user_decryption_options_KeyConnectorUserDecryptionOption(), obj);
    }
}
/**
 * Trusted device decryption options. Intended to be sent to the client for use after authentication.
 * @see {@link UserDecryptionOptions}
 */
class user_decryption_options_TrustedDeviceUserDecryptionOption {
    /**
     * Initializes a new instance of the TrustedDeviceUserDecryptionOption from a response object.
     * @param response The trusted device user decryption option response object.
     * @returns A new instance of the TrustedDeviceUserDecryptionOption or undefined if `response` is nullish.
     */
    static fromResponse(response) {
        var _a, _b, _c;
        if (response == null) {
            return undefined;
        }
        const options = new user_decryption_options_TrustedDeviceUserDecryptionOption();
        options.hasAdminApproval = (_a = response === null || response === void 0 ? void 0 : response.hasAdminApproval) !== null && _a !== void 0 ? _a : false;
        options.hasLoginApprovingDevice = (_b = response === null || response === void 0 ? void 0 : response.hasLoginApprovingDevice) !== null && _b !== void 0 ? _b : false;
        options.hasManageResetPasswordPermission = (_c = response === null || response === void 0 ? void 0 : response.hasManageResetPasswordPermission) !== null && _c !== void 0 ? _c : false;
        return options;
    }
    /**
     * Initializes a new instance of the TrustedDeviceUserDecryptionOption from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the TrustedDeviceUserDecryptionOption or undefined if `obj` is nullish.
     */
    static fromJSON(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new user_decryption_options_TrustedDeviceUserDecryptionOption(), obj);
    }
}
/**
 * Represents the decryption options the user has configured on the server. This is intended to be sent
 * to the client on authentication, and can be used to determine how to decrypt the user's vault.
 */
class user_decryption_options_UserDecryptionOptions {
    /**
     * Initializes a new instance of the UserDecryptionOptions from a response object.
     * @param response user decryption options response object
     * @returns A new instance of the UserDecryptionOptions.
     * @throws If the response is nullish, this method will throw an error. User decryption options
     * are required for client initialization.
     */
    // TODO: Change response type to `UserDecryptionOptionsResponse` after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
    static fromResponse(response) {
        if (response == null) {
            throw new Error("User Decryption Options are required for client initialization.");
        }
        const decryptionOptions = new user_decryption_options_UserDecryptionOptions();
        if (response.userDecryptionOptions) {
            // If the response has userDecryptionOptions, this means it's on a post-TDE server version and can interrogate
            // the new decryption options.
            const responseOptions = response.userDecryptionOptions;
            decryptionOptions.hasMasterPassword = responseOptions.hasMasterPassword;
            decryptionOptions.trustedDeviceOption = user_decryption_options_TrustedDeviceUserDecryptionOption.fromResponse(responseOptions.trustedDeviceOption);
            decryptionOptions.keyConnectorOption = user_decryption_options_KeyConnectorUserDecryptionOption.fromResponse(responseOptions.keyConnectorOption);
        }
        else {
            // If the response does not have userDecryptionOptions, this means it's on a pre-TDE server version and so
            // we must base our decryption options on the presence of the keyConnectorUrl.
            // Note that the presence of keyConnectorUrl implies that the user does not have a master password, as in pre-TDE
            // server versions, a master password short-circuited the addition of the keyConnectorUrl to the response.
            // TODO: remove this check after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            const usingKeyConnector = response.keyConnectorUrl != null;
            decryptionOptions.hasMasterPassword = !usingKeyConnector;
            if (usingKeyConnector) {
                decryptionOptions.keyConnectorOption = new user_decryption_options_KeyConnectorUserDecryptionOption();
                decryptionOptions.keyConnectorOption.keyConnectorUrl = response.keyConnectorUrl;
            }
        }
        return decryptionOptions;
    }
    /**
     * Initializes a new instance of the UserDecryptionOptions from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the UserDecryptionOptions. Will initialize even if the JSON object is nullish.
     */
    static fromJSON(obj) {
        const decryptionOptions = Object.assign(new user_decryption_options_UserDecryptionOptions(), obj);
        decryptionOptions.trustedDeviceOption = user_decryption_options_TrustedDeviceUserDecryptionOption.fromJSON(obj === null || obj === void 0 ? void 0 : obj.trustedDeviceOption);
        decryptionOptions.keyConnectorOption = user_decryption_options_KeyConnectorUserDecryptionOption.fromJSON(obj === null || obj === void 0 ? void 0 : obj.keyConnectorOption);
        return decryptionOptions;
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/models/domain/index.ts




;// CONCATENATED MODULE: ../../libs/auth/src/common/models/spec/fake-user-decryption-options.ts

// To discourage creating new user decryption options, we don't expose a constructor.
// These helpers are for testing purposes only.
/** Testing helper for creating new instances of `UserDecryptionOptions` */
class FakeUserDecryptionOptions extends (/* unused pure expression or super */ null && (UserDecryptionOptions)) {
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/** Testing helper for creating new instances of `KeyConnectorUserDecryptionOption` */
class FakeKeyConnectorUserDecryptionOption extends (/* unused pure expression or super */ null && (KeyConnectorUserDecryptionOption)) {
    constructor(keyConnectorUrl) {
        super();
        this.keyConnectorUrl = keyConnectorUrl;
    }
}
/** Testing helper for creating new instances of `TrustedDeviceUserDecryptionOption` */
class FakeTrustedDeviceUserDecryptionOption extends (/* unused pure expression or super */ null && (TrustedDeviceUserDecryptionOption)) {
    constructor(hasAdminApproval, hasLoginApprovingDevice, hasManageResetPasswordPermission) {
        super();
        this.hasAdminApproval = hasAdminApproval;
        this.hasLoginApprovingDevice = hasLoginApprovingDevice;
        this.hasManageResetPasswordPermission = hasManageResetPasswordPermission;
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/models/spec/index.ts


;// CONCATENATED MODULE: ../../libs/auth/src/common/models/index.ts



;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/enc-string.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class EncString {
    constructor(encryptedStringOrType, data, iv, mac) {
        if (data != null) {
            this.initFromData(encryptedStringOrType, data, iv, mac);
        }
        else {
            this.initFromEncryptedString(encryptedStringOrType);
        }
    }
    get ivBytes() {
        return this.iv == null ? null : Utils.fromB64ToArray(this.iv);
    }
    get macBytes() {
        return this.mac == null ? null : Utils.fromB64ToArray(this.mac);
    }
    get dataBytes() {
        return this.data == null ? null : Utils.fromB64ToArray(this.data);
    }
    toJSON() {
        return this.encryptedString;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return new EncString(obj);
    }
    initFromData(encType, data, iv, mac) {
        if (iv != null) {
            this.encryptedString = (encType + "." + iv + "|" + data);
        }
        else {
            this.encryptedString = (encType + "." + data);
        }
        // mac
        if (mac != null) {
            this.encryptedString = (this.encryptedString + "|" + mac);
        }
        this.encryptionType = encType;
        this.data = data;
        this.iv = iv;
        this.mac = mac;
    }
    initFromEncryptedString(encryptedString) {
        this.encryptedString = encryptedString;
        if (!this.encryptedString) {
            return;
        }
        const { encType, encPieces } = EncString.parseEncryptedString(this.encryptedString);
        this.encryptionType = encType;
        if (encPieces.length !== EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType]) {
            return;
        }
        switch (encType) {
            case EncryptionType.AesCbc128_HmacSha256_B64:
            case EncryptionType.AesCbc256_HmacSha256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                this.mac = encPieces[2];
                break;
            case EncryptionType.AesCbc256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                break;
            case EncryptionType.Rsa2048_OaepSha256_B64:
            case EncryptionType.Rsa2048_OaepSha1_B64:
                this.data = encPieces[0];
                break;
            default:
                return;
        }
    }
    static parseEncryptedString(encryptedString) {
        const headerPieces = encryptedString.split(".");
        let encType;
        let encPieces = null;
        if (headerPieces.length === 2) {
            try {
                encType = parseInt(headerPieces[0], null);
                encPieces = headerPieces[1].split("|");
            }
            catch (e) {
                return;
            }
        }
        else {
            encPieces = encryptedString.split("|");
            encType =
                encPieces.length === 3
                    ? EncryptionType.AesCbc128_HmacSha256_B64
                    : EncryptionType.AesCbc256_B64;
        }
        return {
            encType,
            encPieces,
        };
    }
    static isSerializedEncString(s) {
        const { encType, encPieces } = this.parseEncryptedString(s);
        return EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType] === encPieces.length;
    }
    decrypt(orgId, key = null) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.decryptedValue != null) {
                return this.decryptedValue;
            }
            try {
                if (key == null) {
                    key = yield this.getKeyForDecryption(orgId);
                }
                if (key == null) {
                    throw new Error("No key to decrypt EncString with orgId " + orgId);
                }
                const encryptService = Utils.getContainerService().getEncryptService();
                this.decryptedValue = yield encryptService.decryptToUtf8(this, key);
            }
            catch (e) {
                this.decryptedValue = "[error: cannot decrypt]";
            }
            return this.decryptedValue;
        });
    }
    getKeyForDecryption(orgId) {
        return __awaiter(this, void 0, void 0, function* () {
            const cryptoService = Utils.getContainerService().getCryptoService();
            return orgId != null
                ? yield cryptoService.getOrgKey(orgId)
                : yield cryptoService.getUserKeyWithLegacySupport();
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/pin-crypto/pin-crypto.service.implementation.ts
var pin_crypto_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class PinCryptoService {
    constructor(stateService, cryptoService, vaultTimeoutSettingsService, logService) {
        this.stateService = stateService;
        this.cryptoService = cryptoService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.logService = logService;
    }
    decryptUserKeyWithPin(pin) {
        return pin_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            try {
                const pinLockType = yield this.vaultTimeoutSettingsService.isPinLockSet();
                const { pinKeyEncryptedUserKey, oldPinKeyEncryptedMasterKey } = yield this.getPinKeyEncryptedKeys(pinLockType);
                const kdf = yield this.stateService.getKdfType();
                const kdfConfig = yield this.stateService.getKdfConfig();
                let userKey;
                const email = yield this.stateService.getEmail();
                if (oldPinKeyEncryptedMasterKey) {
                    userKey = yield this.cryptoService.decryptAndMigrateOldPinKey(pinLockType === "TRANSIENT", pin, email, kdf, kdfConfig, oldPinKeyEncryptedMasterKey);
                }
                else {
                    userKey = yield this.cryptoService.decryptUserKeyWithPin(pin, email, kdf, kdfConfig, pinKeyEncryptedUserKey);
                }
                if (!userKey) {
                    this.logService.warning(`User key null after pin key decryption.`);
                    return null;
                }
                if (!(yield this.validatePin(userKey, pin))) {
                    this.logService.warning(`Pin key decryption successful but pin validation failed.`);
                    return null;
                }
                return userKey;
            }
            catch (error) {
                this.logService.error(`Error decrypting user key with pin: ${error}`);
                return null;
            }
        });
    }
    // Note: oldPinKeyEncryptedMasterKey is only used for migrating old pin keys
    // and will be null for all migrated accounts
    getPinKeyEncryptedKeys(pinLockType) {
        return pin_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            switch (pinLockType) {
                case "PERSISTANT": {
                    const pinKeyEncryptedUserKey = yield this.stateService.getPinKeyEncryptedUserKey();
                    const oldPinKeyEncryptedMasterKey = yield this.stateService.getEncryptedPinProtected();
                    return {
                        pinKeyEncryptedUserKey,
                        oldPinKeyEncryptedMasterKey: oldPinKeyEncryptedMasterKey
                            ? new EncString(oldPinKeyEncryptedMasterKey)
                            : undefined,
                    };
                }
                case "TRANSIENT": {
                    const pinKeyEncryptedUserKey = yield this.stateService.getPinKeyEncryptedUserKeyEphemeral();
                    const oldPinKeyEncryptedMasterKey = yield this.stateService.getDecryptedPinProtected();
                    return { pinKeyEncryptedUserKey, oldPinKeyEncryptedMasterKey };
                }
                case "DISABLED":
                    throw new Error("Pin is disabled");
                default: {
                    // Compile-time check for exhaustive switch
                    const _exhaustiveCheck = pinLockType;
                    return _exhaustiveCheck;
                }
            }
        });
    }
    validatePin(userKey, pin) {
        return pin_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            const protectedPin = yield this.stateService.getProtectedPin();
            const decryptedPin = yield this.cryptoService.decryptToUtf8(new EncString(protectedPin), userKey);
            return decryptedPin === pin;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/derive-definition.ts
/**
 * DeriveDefinitions describe state derived from another observable, the value type of which is given by `TFrom`.
 *
 * The StateDefinition is used to describe the domain of the state, and the DeriveDefinition
 * sub-divides that domain into specific keys. These keys are used to cache data in memory and enables derived state to
 * be calculated once regardless of multiple execution contexts.
 */
class DeriveDefinition {
    /**
     * Creates a new instance of a DeriveDefinition. Derived state is always stored in memory, so the storage location
     * defined in @link{StateDefinition} is ignored.
     *
     * @param stateDefinition The state definition for which this key belongs to.
     * @param uniqueDerivationName The name of the key, this should be unique per domain.
     * @param options A set of options to customize the behavior of {@link DeriveDefinition}.
     * @param options.derive A function to use to convert values from TFrom to TTo. This is called on each emit of the parent state observable
     * and the resulting value will be emitted from the derived state observable.
     * @param options.cleanupDelayMs The number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     * Defaults to 1000ms.
     * @param options.dependencyShape An object defining the dependencies of the derive function. The keys of the object are the names of the dependencies
     * and the values are the types of the dependencies.
     * for example:
     * ```
     * {
     *   myService: MyService,
     *   myOtherService: MyOtherService,
     * }
     * ```
     *
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     */
    constructor(stateDefinition, uniqueDerivationName, options) {
        this.stateDefinition = stateDefinition;
        this.uniqueDerivationName = uniqueDerivationName;
        this.options = options;
    }
    /**
     * Factory that produces a {@link DeriveDefinition} from a {@link KeyDefinition} or {@link DeriveDefinition} and new name.
     *
     * If a `KeyDefinition` is passed in, the returned definition will have the same key as the given key definition, but
     * will not collide with it in storage, even if they both reside in memory.
     *
     * If a `DeriveDefinition` is passed in, the returned definition will instead use the name given in the second position
     * of the tuple. It is up to you to ensure this is unique within the domain of derived state.
     *
     * @param options A set of options to customize the behavior of {@link DeriveDefinition}.
     * @param options.derive A function to use to convert values from TFrom to TTo. This is called on each emit of the parent state observable
     * and the resulting value will be emitted from the derived state observable.
     * @param options.cleanupDelayMs The number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     * Defaults to 1000ms.
     * @param options.dependencyShape An object defining the dependencies of the derive function. The keys of the object are the names of the dependencies
     * and the values are the types of the dependencies.
     * for example:
     * ```
     * {
     *   myService: MyService,
     *   myOtherService: MyOtherService,
     * }
     * ```
     *
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     * @param definition
     * @param options
     * @returns
     */
    static from(definition, options) {
        if (isFromDeriveDefinition(definition)) {
            return new DeriveDefinition(definition[0].stateDefinition, definition[1], options);
        }
        else {
            return new DeriveDefinition(definition.stateDefinition, definition.key, options);
        }
    }
    static fromWithUserId(definition, options) {
        if (isFromDeriveDefinition(definition)) {
            return new DeriveDefinition(definition[0].stateDefinition, definition[1], options);
        }
        else {
            return new DeriveDefinition(definition.stateDefinition, definition.key, options);
        }
    }
    get derive() {
        return this.options.derive;
    }
    deserialize(serialized) {
        return this.options.deserializer(serialized);
    }
    get cleanupDelayMs() {
        var _a;
        return this.options.cleanupDelayMs < 0 ? 0 : (_a = this.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : 1000;
    }
    get clearOnCleanup() {
        var _a;
        return (_a = this.options.clearOnCleanup) !== null && _a !== void 0 ? _a : true;
    }
    buildCacheKey(location) {
        return `derived_${location}_${this.stateDefinition.name}_${this.uniqueDerivationName}`;
    }
    /**
     * Creates a {@link StorageKey} that points to the data for the given derived definition.
     * @returns A key that is ready to be used in a storage service to get data.
     */
    get storageKey() {
        return `derived_${this.stateDefinition.name}_${this.uniqueDerivationName}`;
    }
}
function isFromDeriveDefinition(definition) {
    return Array.isArray(definition);
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/deserialization-helpers.ts
/**
 *
 * @param elementDeserializer
 * @returns
 */
function array(elementDeserializer) {
    return (array) => {
        if (array == null) {
            return null;
        }
        return array.map((element) => elementDeserializer(element));
    };
}
/**
 *
 * @param valueDeserializer
 */
function record(valueDeserializer) {
    return (jsonValue) => {
        if (jsonValue == null) {
            return null;
        }
        const output = {};
        for (const key in jsonValue) {
            output[key] = valueDeserializer(jsonValue[key]);
        }
        return output;
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/key-definition.ts

/**
 * KeyDefinitions describe the precise location to store data for a given piece of state.
 * The StateDefinition is used to describe the domain of the state, and the KeyDefinition
 * sub-divides that domain into specific keys.
 */
class KeyDefinition {
    /**
     * Creates a new instance of a KeyDefinition
     * @param stateDefinition The state definition for which this key belongs to.
     * @param key The name of the key, this should be unique per domain.
     * @param options A set of options to customize the behavior of {@link KeyDefinition}. All options are required.
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     */
    constructor(stateDefinition, key, options) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
        if (options.deserializer == null) {
            throw new Error(`'deserializer' is a required property on key ${this.errorKeyName}`);
        }
        if (options.cleanupDelayMs <= 0) {
            throw new Error(`'cleanupDelayMs' must be greater than 0. Value of ${options.cleanupDelayMs} passed to key ${this.errorKeyName} `);
        }
    }
    /**
     * Gets the deserializer configured for this {@link KeyDefinition}
     */
    get deserializer() {
        return this.options.deserializer;
    }
    /**
     * Gets the number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     */
    get cleanupDelayMs() {
        var _a;
        return this.options.cleanupDelayMs < 0 ? 0 : (_a = this.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : 1000;
    }
    /**
     * Creates a {@link KeyDefinition} for state that is an array.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} initialized for arrays, the options run
     * the deserializer on the provided options for each element of an array.
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.array<MyArrayElement>(MY_STATE, "key", {
     *   deserializer: (myJsonElement) => convertToElement(myJsonElement),
     * });
     * ```
     */
    static array(stateDefinition, key, 
    // We have them provide options for the element of the array, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: array((e) => options.deserializer(e)) }));
    }
    /**
     * Creates a {@link KeyDefinition} for state that is a record.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} that contains a serializer that will run the provided deserializer for each
     * value in a record and returns every key as a string.
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.record<MyRecordValue>(MY_STATE, "key", {
     *   deserializer: (myJsonValue) => convertToValue(myJsonValue),
     * });
     * ```
     */
    static record(stateDefinition, key, 
    // We have them provide options for the value of the record, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: record((v) => options.deserializer(v)) }));
    }
    get fullName() {
        return `${this.stateDefinition.name}_${this.key}`;
    }
    get errorKeyName() {
        return `${this.stateDefinition.name} > ${this.key}`;
    }
}
/**
 * Creates a {@link StorageKey}
 * @param keyDefinition The key definition of which data the key should point to.
 * @returns A key that is ready to be used in a storage service to get data.
 */
function globalKeyBuilder(keyDefinition) {
    return `global_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/user-key-definition.ts
var _a;


const USER_KEY_DEFINITION_MARKER = Symbol("UserKeyDefinition");
function isUserKeyDefinition(keyDefinition) {
    return (USER_KEY_DEFINITION_MARKER in keyDefinition &&
        keyDefinition[USER_KEY_DEFINITION_MARKER] === true);
}
class UserKeyDefinition {
    constructor(stateDefinition, key, options) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
        this[_a] = true;
        if (options.deserializer == null) {
            throw new Error(`'deserializer' is a required property on key ${this.errorKeyName}`);
        }
        if (options.cleanupDelayMs <= 0) {
            throw new Error(`'cleanupDelayMs' must be greater than 0. Value of ${options.cleanupDelayMs} passed to key ${this.errorKeyName} `);
        }
        // Filter out repeat values
        this.clearOn = Array.from(new Set(options.clearOn));
    }
    /**
     * Gets the deserializer configured for this {@link KeyDefinition}
     */
    get deserializer() {
        return this.options.deserializer;
    }
    /**
     * Gets the number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     */
    get cleanupDelayMs() {
        var _b;
        return this.options.cleanupDelayMs < 0 ? 0 : (_b = this.options.cleanupDelayMs) !== null && _b !== void 0 ? _b : 1000;
    }
    /**
     *
     * @param keyDefinition
     * @returns
     *
     * @deprecated You should not use this to convert, just create a {@link UserKeyDefinition}
     */
    static fromBaseKeyDefinition(keyDefinition) {
        return new UserKeyDefinition(keyDefinition.stateDefinition, keyDefinition.key, Object.assign(Object.assign({}, keyDefinition["options"]), { clearOn: [] }));
    }
    /**
     * Creates a {@link UserKeyDefinition} for state that is an array.
     * @param stateDefinition The state definition to be added to the UserKeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link UserKeyDefinition}.
     * @returns A {@link UserKeyDefinition} initialized for arrays, the options run
     * the deserializer on the provided options for each element of an array
     * **unless that array is null, in which case it will return an empty list.**
     *
     * @example
     * ```typescript
     * const MY_KEY = UserKeyDefinition.array<MyArrayElement>(MY_STATE, "key", {
     *   deserializer: (myJsonElement) => convertToElement(myJsonElement),
     * });
     * ```
     */
    static array(stateDefinition, key, 
    // We have them provide options for the element of the array, depending on future options we add, this could get a little weird.
    options) {
        return new UserKeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: array((e) => options.deserializer(e)) }));
    }
    /**
     * Creates a {@link UserKeyDefinition} for state that is a record.
     * @param stateDefinition The state definition to be added to the UserKeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link UserKeyDefinition}.
     * @returns A {@link UserKeyDefinition} that contains a serializer that will run the provided deserializer for each
     * value in a record and returns every key as a string **unless that record is null, in which case it will return an record.**
     *
     * @example
     * ```typescript
     * const MY_KEY = UserKeyDefinition.record<MyRecordValue>(MY_STATE, "key", {
     *   deserializer: (myJsonValue) => convertToValue(myJsonValue),
     * });
     * ```
     */
    static record(stateDefinition, key, 
    // We have them provide options for the value of the record, depending on future options we add, this could get a little weird.
    options) {
        return new UserKeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: record((v) => options.deserializer(v)) }));
    }
    get fullName() {
        return `${this.stateDefinition.name}_${this.key}`;
    }
    buildKey(userId) {
        if (!Utils.isGuid(userId)) {
            throw new Error(`You cannot build a user key without a valid UserId, building for key ${this.fullName}`);
        }
        return `user_${userId}_${this.stateDefinition.name}_${this.key}`;
    }
    get errorKeyName() {
        return `${this.stateDefinition.name} > ${this.key}`;
    }
}
_a = USER_KEY_DEFINITION_MARKER;

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-definition.ts
/**
 * Defines the base location and instruction of where this state is expected to be located.
 */
class StateDefinition {
    /**
     * Creates a new instance of {@link StateDefinition}, the creation of which is owned by the platform team.
     * @param name The name of the state, this needs to be unique from all other {@link StateDefinition}'s.
     * @param defaultStorageLocation The location of where this state should be stored.
     */
    constructor(name, defaultStorageLocation, storageLocationOverrides) {
        this.name = name;
        this.defaultStorageLocation = defaultStorageLocation;
        this.storageLocationOverrides = storageLocationOverrides !== null && storageLocationOverrides !== void 0 ? storageLocationOverrides : {};
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-definitions.ts

/**
 * `StateDefinition`s comes with some rules, to facilitate a quick review from
 * platform of this file, ensure you follow these rules, the ones marked with (tested)
 * have unit tests that you can run locally.
 *
 * 1. (tested) Names should not be null or undefined
 * 2. (tested) Name and storage location should be unique
 * 3. (tested) Name and storage location can't differ from another export by only casing
 * 4. (tested) Name should be longer than 3 characters. It should be descriptive, but brief.
 * 5. (tested) Name should not contain spaces or underscores
 * 6. Name should be human readable
 * 7. Name should be in camelCase format (unit tests ensure the first character is lowercase)
 * 8. Teams should only use state definitions they have created
 * 9. StateDefinitions should only be used for keys relating to the state name they chose
 *
 */
// Admin Console
const ORGANIZATIONS_DISK = new StateDefinition("organizations", "disk");
const POLICIES_DISK = new StateDefinition("policies", "disk");
const PROVIDERS_DISK = new StateDefinition("providers", "disk");
const ORGANIZATION_MANAGEMENT_PREFERENCES_DISK = new StateDefinition("organizationManagementPreferences", "disk", {
    web: "disk-local",
});
// Billing
const BILLING_DISK = new StateDefinition("billing", "disk");
// Auth
const KEY_CONNECTOR_DISK = new StateDefinition("keyConnector", "disk");
const ACCOUNT_MEMORY = new StateDefinition("account", "memory");
const MASTER_PASSWORD_MEMORY = new StateDefinition("masterPassword", "memory");
const MASTER_PASSWORD_DISK = new StateDefinition("masterPassword", "disk");
const AVATAR_DISK = new StateDefinition("avatar", "disk", { web: "disk-local" });
const ROUTER_DISK = new StateDefinition("router", "disk");
const LOGIN_EMAIL_DISK = new StateDefinition("loginEmail", "disk", {
    web: "disk-local",
});
const LOGIN_STRATEGY_MEMORY = new StateDefinition("loginStrategy", "memory");
const AUTH_REQUEST_DISK_LOCAL = new StateDefinition("authRequestLocal", "disk", {
    web: "disk-local",
});
const SSO_DISK = new StateDefinition("ssoLogin", "disk");
const TOKEN_DISK = new StateDefinition("token", "disk");
const TOKEN_DISK_LOCAL = new StateDefinition("tokenDiskLocal", "disk", {
    web: "disk-local",
});
const TOKEN_MEMORY = new StateDefinition("token", "memory");
const DEVICE_TRUST_DISK_LOCAL = new StateDefinition("deviceTrust", "disk", {
    web: "disk-local",
});
const USER_DECRYPTION_OPTIONS_DISK = new StateDefinition("userDecryptionOptions", "disk");
// Autofill
const BADGE_SETTINGS_DISK = new StateDefinition("badgeSettings", "disk");
const USER_NOTIFICATION_SETTINGS_DISK = new StateDefinition("userNotificationSettings", "disk");
const DOMAIN_SETTINGS_DISK = new StateDefinition("domainSettings", "disk");
const AUTOFILL_SETTINGS_DISK = new StateDefinition("autofillSettings", "disk");
const AUTOFILL_SETTINGS_DISK_LOCAL = new StateDefinition("autofillSettingsLocal", "disk", {
    web: "disk-local",
});
// Components
const NEW_WEB_LAYOUT_BANNER_DISK = new StateDefinition("newWebLayoutBanner", "disk", {
    web: "disk-local",
});
const UNASSIGNED_ITEMS_BANNER_DISK = new StateDefinition("unassignedItemsBanner", "disk", {
    web: "disk-local",
});
// Platform
const APPLICATION_ID_DISK = new StateDefinition("applicationId", "disk", {
    web: "disk-local",
});
const BIOMETRIC_SETTINGS_DISK = new StateDefinition("biometricSettings", "disk");
const CLEAR_EVENT_DISK = new StateDefinition("clearEvent", "disk");
const CONFIG_DISK = new StateDefinition("config", "disk", {
    web: "disk-local",
});
const CRYPTO_DISK = new StateDefinition("crypto", "disk");
const CRYPTO_MEMORY = new StateDefinition("crypto", "memory");
const DESKTOP_SETTINGS_DISK = new StateDefinition("desktopSettings", "disk");
const ENVIRONMENT_DISK = new StateDefinition("environment", "disk");
const ENVIRONMENT_MEMORY = new StateDefinition("environment", "memory");
const THEMING_DISK = new StateDefinition("theming", "disk", { web: "disk-local" });
const TRANSLATION_DISK = new StateDefinition("translation", "disk");
// Secrets Manager
const SM_ONBOARDING_DISK = new StateDefinition("smOnboarding", "disk", {
    web: "disk-local",
});
// Tools
const GENERATOR_DISK = new StateDefinition("generator", "disk");
const GENERATOR_MEMORY = new StateDefinition("generator", "memory");
const BROWSER_SEND_MEMORY = new StateDefinition("sendBrowser", "memory");
const EVENT_COLLECTION_DISK = new StateDefinition("eventCollection", "disk");
const SEND_DISK = new StateDefinition("encryptedSend", "disk", {
    web: "memory",
});
const SEND_MEMORY = new StateDefinition("decryptedSend", "memory", {
    browser: "memory-large-object",
});
// Vault
const COLLECTION_DATA = new StateDefinition("collection", "disk", {
    web: "memory",
});
const FOLDER_DISK = new StateDefinition("folder", "disk", { web: "memory" });
const VAULT_FILTER_DISK = new StateDefinition("vaultFilter", "disk", {
    web: "disk-local",
});
const VAULT_ONBOARDING = new StateDefinition("vaultOnboarding", "disk", {
    web: "disk-local",
});
const VAULT_SETTINGS_DISK = new StateDefinition("vaultSettings", "disk", {
    web: "disk-local",
});
const VAULT_BROWSER_MEMORY = new StateDefinition("vaultBrowser", "memory", {
    browser: "memory-large-object",
});
const VAULT_SEARCH_MEMORY = new StateDefinition("vaultSearch", "memory", {
    browser: "memory-large-object",
});
const CIPHERS_DISK = new StateDefinition("ciphers", "disk", { web: "memory" });
const CIPHERS_DISK_LOCAL = new StateDefinition("ciphersLocal", "disk", {
    web: "disk-local",
});
const CIPHERS_MEMORY = new StateDefinition("ciphersMemory", "memory", {
    browser: "memory-large-object",
});

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-event-registrar.service.ts
var state_event_registrar_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const STATE_LOCK_EVENT = KeyDefinition.array(CLEAR_EVENT_DISK, "lock", {
    deserializer: (e) => e,
});
const STATE_LOGOUT_EVENT = KeyDefinition.array(CLEAR_EVENT_DISK, "logout", {
    deserializer: (e) => e,
});
class StateEventRegistrarService {
    constructor(globalStateProvider, storageServiceProvider) {
        this.storageServiceProvider = storageServiceProvider;
        this.stateEventStateMap = {
            lock: globalStateProvider.get(STATE_LOCK_EVENT),
            logout: globalStateProvider.get(STATE_LOGOUT_EVENT),
        };
    }
    registerEvents(keyDefinition) {
        return state_event_registrar_service_awaiter(this, void 0, void 0, function* () {
            for (const clearEvent of keyDefinition.clearOn) {
                const eventState = this.stateEventStateMap[clearEvent];
                // Determine the storage location for this
                const [storageLocation] = this.storageServiceProvider.get(keyDefinition.stateDefinition.defaultStorageLocation, keyDefinition.stateDefinition.storageLocationOverrides);
                const newEvent = {
                    state: keyDefinition.stateDefinition.name,
                    key: keyDefinition.key,
                    location: storageLocation,
                };
                // Only update the event state if the existing list doesn't have a matching entry
                yield eventState.update((existingTickets) => {
                    existingTickets !== null && existingTickets !== void 0 ? existingTickets : (existingTickets = []);
                    existingTickets.push(newEvent);
                    return existingTickets;
                }, {
                    shouldUpdate: (currentTickets) => {
                        return (
                        // If the current tickets are null, then it will for sure be added
                        currentTickets == null ||
                            // If an existing match couldn't be found, we also need to add one
                            currentTickets.findIndex((e) => e.state === newEvent.state &&
                                e.key === newEvent.key &&
                                e.location === newEvent.location) === -1);
                    },
                });
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-event-runner.service.ts
var state_event_runner_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class StateEventRunnerService {
    constructor(globalStateProvider, storageServiceProvider) {
        this.storageServiceProvider = storageServiceProvider;
        this.stateEventMap = {
            lock: globalStateProvider.get(STATE_LOCK_EVENT),
            logout: globalStateProvider.get(STATE_LOGOUT_EVENT),
        };
    }
    handleEvent(event, userId) {
        return state_event_runner_service_awaiter(this, void 0, void 0, function* () {
            let tickets = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateEventMap[event].state$);
            tickets !== null && tickets !== void 0 ? tickets : (tickets = []);
            const failures = [];
            for (const ticket of tickets) {
                try {
                    const [, service] = this.storageServiceProvider.get(ticket.location, {});
                    const ticketStorageKey = this.storageKeyFor(userId, ticket);
                    // Evaluate current value so we can avoid writing to state if we don't need to
                    const currentValue = yield service.get(ticketStorageKey);
                    if (currentValue != null) {
                        yield service.remove(ticketStorageKey);
                    }
                }
                catch (err) {
                    let errorMessage = "Unknown Error";
                    if (typeof err === "object" && "message" in err && typeof err.message === "string") {
                        errorMessage = err.message;
                    }
                    failures.push(`${errorMessage} in ${ticket.state} > ${ticket.key} located ${ticket.location}`);
                }
            }
            if (failures.length > 0) {
                // Throw aggregated error
                throw new Error(`One or more errors occurred while handling event '${event}' for user ${userId}.\n${failures.join("\n")}`);
            }
        });
    }
    storageKeyFor(userId, ticket) {
        const userKey = new UserKeyDefinition(new StateDefinition(ticket.state, ticket.location), ticket.key, {
            deserializer: (v) => v,
            clearOn: [],
        });
        return userKey.buildKey(userId);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/index.ts










;// CONCATENATED MODULE: ../../libs/auth/src/common/services/login-email/login-email.service.ts
var login_email_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const STORED_EMAIL = new KeyDefinition(LOGIN_EMAIL_DISK, "storedEmail", {
    deserializer: (value) => value,
});
class LoginEmailService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
        this.storedEmailState = this.stateProvider.getGlobal(STORED_EMAIL);
        this.storedEmail$ = this.storedEmailState.state$;
    }
    getEmail() {
        return this.email;
    }
    setEmail(email) {
        this.email = email;
    }
    getRememberEmail() {
        return this.rememberEmail;
    }
    setRememberEmail(value) {
        this.rememberEmail = value;
    }
    clearValues() {
        this.email = null;
        this.rememberEmail = null;
    }
    saveEmailSettings() {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            yield this.storedEmailState.update(() => (this.rememberEmail ? this.email : null));
            this.clearValues();
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/passwordless-auth.request.ts
class PasswordlessAuthRequest {
    constructor(key, masterPasswordHash, deviceIdentifier, requestApproved) {
        this.key = key;
        this.masterPasswordHash = masterPasswordHash;
        this.deviceIdentifier = deviceIdentifier;
        this.requestApproved = requestApproved;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/prelogin.request.ts
class PreloginRequest {
    constructor(email) {
        this.email = email;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/base.response.ts
class BaseResponse {
    constructor(response) {
        this.response = response;
    }
    getResponseProperty(propertyName, response = null, exactName = false) {
        if (propertyName == null || propertyName === "") {
            throw new Error("propertyName must not be null/empty.");
        }
        if (response == null && this.response != null) {
            response = this.response;
        }
        if (response == null) {
            return null;
        }
        if (!exactName && response[propertyName] === undefined) {
            let otherCasePropertyName = null;
            if (propertyName.charAt(0) === propertyName.charAt(0).toUpperCase()) {
                otherCasePropertyName = propertyName.charAt(0).toLowerCase();
            }
            else {
                otherCasePropertyName = propertyName.charAt(0).toUpperCase();
            }
            if (propertyName.length > 1) {
                otherCasePropertyName += propertyName.slice(1);
            }
            propertyName = otherCasePropertyName;
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toLowerCase();
            }
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toUpperCase();
            }
        }
        return response[propertyName];
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/error.response.ts


class ErrorResponse extends BaseResponse {
    constructor(response, status, identityResponse) {
        var _a, _b;
        super(response);
        let errorModel = null;
        if (response != null) {
            const responseErrorModel = this.getResponseProperty("ErrorModel");
            if (responseErrorModel && identityResponse) {
                errorModel = responseErrorModel;
            }
            else {
                errorModel = response;
            }
        }
        if (status === 429) {
            this.message = "Rate limit exceeded. Try again later.";
        }
        else if (errorModel) {
            this.message = this.getResponseProperty("Message", errorModel);
            this.validationErrors = this.getResponseProperty("ValidationErrors", errorModel);
            this.captchaSiteKey = (_b = (_a = this.validationErrors) === null || _a === void 0 ? void 0 : _a.HCaptcha_SiteKey) === null || _b === void 0 ? void 0 : _b[0];
            this.captchaRequired = !Utils.isNullOrWhitespace(this.captchaSiteKey);
        }
        this.statusCode = status;
    }
    getSingleMessage() {
        if (this.validationErrors == null) {
            return this.message;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            if (this.validationErrors[key].length) {
                return this.validationErrors[key][0];
            }
        }
        return this.message;
    }
    getAllMessages() {
        const messages = [];
        if (this.validationErrors == null) {
            return messages;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            this.validationErrors[key].forEach((item) => {
                let prefix = "";
                if (key.indexOf("[") > -1 && key.indexOf("]") > -1) {
                    const lastSep = key.lastIndexOf(".");
                    prefix = key.substr(0, lastSep > -1 ? lastSep : key.length) + ": ";
                }
                messages.push(prefix + item);
            });
        }
        return messages;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/device.request.ts
class DeviceRequest {
    constructor(appId, platformUtilsService) {
        this.type = platformUtilsService.getDevice();
        this.name = platformUtilsService.getDeviceString();
        this.identifier = appId;
        this.pushToken = null;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(DeviceRequest.prototype), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/token.request.ts
class TokenRequest {
    constructor(twoFactor, device) {
        this.twoFactor = twoFactor;
        this.device = device != null ? device : null;
    }
    // eslint-disable-next-line
    alterIdentityTokenHeaders(headers) {
        // Implemented in subclass if required
    }
    setTwoFactor(twoFactor) {
        this.twoFactor = twoFactor;
    }
    setAuthRequestAccessCode(accessCode) {
        this.authRequest = accessCode;
    }
    toIdentityToken(clientId) {
        const obj = {
            scope: "api offline_access",
            client_id: clientId,
        };
        if (this.device) {
            obj.deviceType = this.device.type;
            obj.deviceIdentifier = this.device.identifier;
            obj.deviceName = this.device.name;
            // no push tokens for browser apps yet
            // obj.devicePushToken = this.device.pushToken;
        }
        //passswordless login
        if (this.authRequest) {
            obj.authRequest = this.authRequest;
        }
        if (this.twoFactor) {
            if (this.twoFactor.token && this.twoFactor.provider != null) {
                obj.twoFactorToken = this.twoFactor.token;
                obj.twoFactorProvider = this.twoFactor.provider;
                obj.twoFactorRemember = this.twoFactor.remember ? "1" : "0";
            }
        }
        return obj;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/password-token.request.ts




class PasswordTokenRequest extends TokenRequest {
    constructor(email, masterPasswordHash, captchaResponse, twoFactor, device) {
        super(twoFactor, device);
        this.email = email;
        this.masterPasswordHash = masterPasswordHash;
        this.captchaResponse = captchaResponse;
        this.twoFactor = twoFactor;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "password";
        obj.username = this.email;
        obj.password = this.masterPasswordHash;
        if (this.captchaResponse != null) {
            obj.captchaResponse = this.captchaResponse;
        }
        return obj;
    }
    alterIdentityTokenHeaders(headers) {
        headers.set("Auth-Email", Utils.fromUtf8ToUrlB64(this.email));
    }
    static fromJSON(json) {
        return Object.assign(Object.create(PasswordTokenRequest.prototype), json, {
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/two-factor-provider-type.ts
var TwoFactorProviderType;
(function (TwoFactorProviderType) {
    TwoFactorProviderType[TwoFactorProviderType["Authenticator"] = 0] = "Authenticator";
    TwoFactorProviderType[TwoFactorProviderType["Email"] = 1] = "Email";
    TwoFactorProviderType[TwoFactorProviderType["Duo"] = 2] = "Duo";
    TwoFactorProviderType[TwoFactorProviderType["Yubikey"] = 3] = "Yubikey";
    TwoFactorProviderType[TwoFactorProviderType["U2f"] = 4] = "U2f";
    TwoFactorProviderType[TwoFactorProviderType["Remember"] = 5] = "Remember";
    TwoFactorProviderType[TwoFactorProviderType["OrganizationDuo"] = 6] = "OrganizationDuo";
    TwoFactorProviderType[TwoFactorProviderType["WebAuthn"] = 7] = "WebAuthn";
})(TwoFactorProviderType || (TwoFactorProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/force-set-password-reason.ts
/*
 * This enum is used to determine if a user should be forced to initially set or reset their password
 * on login (server flag) or unlock via MP (client evaluation).
 */
var ForceSetPasswordReason;
(function (ForceSetPasswordReason) {
    /**
     * A password reset should not be forced.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["None"] = 0] = "None";
    /**
     * Occurs when an organization admin forces a user to reset their password.
     * Communicated via server flag.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["AdminForcePasswordReset"] = 1] = "AdminForcePasswordReset";
    /**
     * Occurs when a user logs in / unlocks their vault with a master password that does not meet an organization's
     * master password policy that is enforced on login/unlock.
     * Only set client side b/c server can't evaluate MP.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["WeakMasterPassword"] = 2] = "WeakMasterPassword";
    /**
     * Occurs when a TDE user without a password obtains the password reset permission.
     * Set post login & decryption client side and by server in sync (to catch logged in users).
     */
    ForceSetPasswordReason[ForceSetPasswordReason["TdeUserWithoutPasswordHasPasswordResetPermission"] = 3] = "TdeUserWithoutPasswordHasPasswordResetPermission";
})(ForceSetPasswordReason || (ForceSetPasswordReason = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/auth-result.ts


class AuthResult {
    constructor() {
        this.captchaSiteKey = "";
        // TODO: PM-3287 - Remove this after 3 releases of backwards compatibility. - Target release 2023.12 for removal
        /**
         * @deprecated
         * Replace with using UserDecryptionOptions to determine if the user does
         * not have a master password and is not using Key Connector.
         * */
        this.resetMasterPassword = false;
        this.forcePasswordReset = ForceSetPasswordReason.None;
        this.twoFactorProviders = null;
    }
    get requiresCaptcha() {
        return !Utils.isNullOrWhitespace(this.captchaSiteKey);
    }
    get requiresTwoFactor() {
        return this.twoFactorProviders != null;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-captcha.response.ts

class IdentityCaptchaResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.siteKey = this.getResponseProperty("HCaptcha_SiteKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/master-password-policy.response.ts

class MasterPasswordPolicyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.minComplexity = this.getResponseProperty("MinComplexity");
        this.minLength = this.getResponseProperty("MinLength");
        this.requireUpper = this.getResponseProperty("RequireUpper");
        this.requireLower = this.getResponseProperty("RequireLower");
        this.requireNumbers = this.getResponseProperty("RequireNumbers");
        this.requireSpecial = this.getResponseProperty("RequireSpecial");
        this.enforceOnLogin = this.getResponseProperty("EnforceOnLogin");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/key-connector-user-decryption-option.response.ts

class KeyConnectorUserDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/trusted-device-user-decryption-option.response.ts


class TrustedDeviceUserDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.hasAdminApproval = this.getResponseProperty("HasAdminApproval");
        this.hasLoginApprovingDevice = this.getResponseProperty("HasLoginApprovingDevice");
        this.hasManageResetPasswordPermission = this.getResponseProperty("HasManageResetPasswordPermission");
        if (response.EncryptedPrivateKey) {
            this.encryptedPrivateKey = new EncString(this.getResponseProperty("EncryptedPrivateKey"));
        }
        if (response.EncryptedUserKey) {
            this.encryptedUserKey = new EncString(this.getResponseProperty("EncryptedUserKey"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/webauthn-prf-decryption-option.response.ts


class WebAuthnPrfDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        if (response.EncryptedPrivateKey) {
            this.encryptedPrivateKey = new EncString(this.getResponseProperty("EncryptedPrivateKey"));
        }
        if (response.EncryptedUserKey) {
            this.encryptedUserKey = new EncString(this.getResponseProperty("EncryptedUserKey"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/user-decryption-options.response.ts




class UserDecryptionOptionsResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.hasMasterPassword = this.getResponseProperty("HasMasterPassword");
        if (response.TrustedDeviceOption) {
            this.trustedDeviceOption = new TrustedDeviceUserDecryptionOptionResponse(this.getResponseProperty("TrustedDeviceOption"));
        }
        if (response.KeyConnectorOption) {
            this.keyConnectorOption = new KeyConnectorUserDecryptionOptionResponse(this.getResponseProperty("KeyConnectorOption"));
        }
        if (response.WebAuthnPrfOption) {
            this.webAuthnPrfOption = new WebAuthnPrfDecryptionOptionResponse(this.getResponseProperty("WebAuthnPrfOption"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-token.response.ts



class IdentityTokenResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.accessToken = response.access_token;
        this.expiresIn = response.expires_in;
        this.refreshToken = response.refresh_token;
        this.tokenType = response.token_type;
        this.resetMasterPassword = this.getResponseProperty("ResetMasterPassword");
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.key = this.getResponseProperty("Key");
        this.twoFactorToken = this.getResponseProperty("TwoFactorToken");
        this.kdf = this.getResponseProperty("Kdf");
        this.kdfIterations = this.getResponseProperty("KdfIterations");
        this.kdfMemory = this.getResponseProperty("KdfMemory");
        this.kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.forcePasswordReset = this.getResponseProperty("ForcePasswordReset");
        this.apiUseKeyConnector = this.getResponseProperty("ApiUseKeyConnector");
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
        if (response.UserDecryptionOptions) {
            this.userDecryptionOptions = new UserDecryptionOptionsResponse(this.getResponseProperty("UserDecryptionOptions"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-two-factor.response.ts


class IdentityTwoFactorResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.twoFactorProviders2 = new Map();
        this.captchaToken = this.getResponseProperty("CaptchaBypassToken");
        this.twoFactorProviders = this.getResponseProperty("TwoFactorProviders");
        const twoFactorProviders2 = this.getResponseProperty("TwoFactorProviders2");
        if (twoFactorProviders2 != null) {
            for (const prop in twoFactorProviders2) {
                // eslint-disable-next-line
                if (twoFactorProviders2.hasOwnProperty(prop)) {
                    this.twoFactorProviders2.set(parseInt(prop, null), twoFactorProviders2[prop]);
                }
            }
        }
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
        this.ssoEmail2faSessionToken = this.getResponseProperty("SsoEmail2faSessionToken");
        this.email = this.getResponseProperty("Email");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/enums/client-type.enum.ts
var ClientType;
(function (ClientType) {
    ClientType["Web"] = "web";
    ClientType["Browser"] = "browser";
    ClientType["Desktop"] = "desktop";
    // Mobile = "mobile",
    ClientType["Cli"] = "cli";
    // DirectoryConnector = "connector",
})(ClientType || (ClientType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/device-type.enum.ts
var DeviceType;
(function (DeviceType) {
    DeviceType[DeviceType["Android"] = 0] = "Android";
    DeviceType[DeviceType["iOS"] = 1] = "iOS";
    DeviceType[DeviceType["ChromeExtension"] = 2] = "ChromeExtension";
    DeviceType[DeviceType["FirefoxExtension"] = 3] = "FirefoxExtension";
    DeviceType[DeviceType["OperaExtension"] = 4] = "OperaExtension";
    DeviceType[DeviceType["EdgeExtension"] = 5] = "EdgeExtension";
    DeviceType[DeviceType["WindowsDesktop"] = 6] = "WindowsDesktop";
    DeviceType[DeviceType["MacOsDesktop"] = 7] = "MacOsDesktop";
    DeviceType[DeviceType["LinuxDesktop"] = 8] = "LinuxDesktop";
    DeviceType[DeviceType["ChromeBrowser"] = 9] = "ChromeBrowser";
    DeviceType[DeviceType["FirefoxBrowser"] = 10] = "FirefoxBrowser";
    DeviceType[DeviceType["OperaBrowser"] = 11] = "OperaBrowser";
    DeviceType[DeviceType["EdgeBrowser"] = 12] = "EdgeBrowser";
    DeviceType[DeviceType["IEBrowser"] = 13] = "IEBrowser";
    DeviceType[DeviceType["UnknownBrowser"] = 14] = "UnknownBrowser";
    DeviceType[DeviceType["AndroidAmazon"] = 15] = "AndroidAmazon";
    DeviceType[DeviceType["UWP"] = 16] = "UWP";
    DeviceType[DeviceType["SafariBrowser"] = 17] = "SafariBrowser";
    DeviceType[DeviceType["VivaldiBrowser"] = 18] = "VivaldiBrowser";
    DeviceType[DeviceType["VivaldiExtension"] = 19] = "VivaldiExtension";
    DeviceType[DeviceType["SafariExtension"] = 20] = "SafariExtension";
    DeviceType[DeviceType["SDK"] = 21] = "SDK";
    DeviceType[DeviceType["Server"] = 22] = "Server";
    DeviceType[DeviceType["WindowsCLI"] = 23] = "WindowsCLI";
    DeviceType[DeviceType["MacOsCLI"] = 24] = "MacOsCLI";
    DeviceType[DeviceType["LinuxCLI"] = 25] = "LinuxCLI";
})(DeviceType || (DeviceType = {}));
const MobileDeviceTypes = new Set([
    DeviceType.Android,
    DeviceType.iOS,
    DeviceType.AndroidAmazon,
]);
const DesktopDeviceTypes = new Set([
    DeviceType.WindowsDesktop,
    DeviceType.MacOsDesktop,
    DeviceType.LinuxDesktop,
    DeviceType.UWP,
    DeviceType.WindowsCLI,
    DeviceType.MacOsCLI,
    DeviceType.LinuxCLI,
]);

;// CONCATENATED MODULE: ../../libs/common/src/enums/event-system-user.enum.ts
// Note: the enum key is used to describe the EventSystemUser in the UI. Be careful about changing it.
var EventSystemUser;
(function (EventSystemUser) {
    EventSystemUser[EventSystemUser["SCIM"] = 1] = "SCIM";
    EventSystemUser[EventSystemUser["DomainVerification"] = 2] = "DomainVerification";
})(EventSystemUser || (EventSystemUser = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/event-type.enum.ts
// Increment by 100 for each new set of events
var EventType;
(function (EventType) {
    EventType[EventType["User_LoggedIn"] = 1000] = "User_LoggedIn";
    EventType[EventType["User_ChangedPassword"] = 1001] = "User_ChangedPassword";
    EventType[EventType["User_Updated2fa"] = 1002] = "User_Updated2fa";
    EventType[EventType["User_Disabled2fa"] = 1003] = "User_Disabled2fa";
    EventType[EventType["User_Recovered2fa"] = 1004] = "User_Recovered2fa";
    EventType[EventType["User_FailedLogIn"] = 1005] = "User_FailedLogIn";
    EventType[EventType["User_FailedLogIn2fa"] = 1006] = "User_FailedLogIn2fa";
    EventType[EventType["User_ClientExportedVault"] = 1007] = "User_ClientExportedVault";
    EventType[EventType["User_UpdatedTempPassword"] = 1008] = "User_UpdatedTempPassword";
    EventType[EventType["User_MigratedKeyToKeyConnector"] = 1009] = "User_MigratedKeyToKeyConnector";
    EventType[EventType["User_RequestedDeviceApproval"] = 1010] = "User_RequestedDeviceApproval";
    EventType[EventType["Cipher_Created"] = 1100] = "Cipher_Created";
    EventType[EventType["Cipher_Updated"] = 1101] = "Cipher_Updated";
    EventType[EventType["Cipher_Deleted"] = 1102] = "Cipher_Deleted";
    EventType[EventType["Cipher_AttachmentCreated"] = 1103] = "Cipher_AttachmentCreated";
    EventType[EventType["Cipher_AttachmentDeleted"] = 1104] = "Cipher_AttachmentDeleted";
    EventType[EventType["Cipher_Shared"] = 1105] = "Cipher_Shared";
    EventType[EventType["Cipher_UpdatedCollections"] = 1106] = "Cipher_UpdatedCollections";
    EventType[EventType["Cipher_ClientViewed"] = 1107] = "Cipher_ClientViewed";
    EventType[EventType["Cipher_ClientToggledPasswordVisible"] = 1108] = "Cipher_ClientToggledPasswordVisible";
    EventType[EventType["Cipher_ClientToggledHiddenFieldVisible"] = 1109] = "Cipher_ClientToggledHiddenFieldVisible";
    EventType[EventType["Cipher_ClientToggledCardCodeVisible"] = 1110] = "Cipher_ClientToggledCardCodeVisible";
    EventType[EventType["Cipher_ClientCopiedPassword"] = 1111] = "Cipher_ClientCopiedPassword";
    EventType[EventType["Cipher_ClientCopiedHiddenField"] = 1112] = "Cipher_ClientCopiedHiddenField";
    EventType[EventType["Cipher_ClientCopiedCardCode"] = 1113] = "Cipher_ClientCopiedCardCode";
    EventType[EventType["Cipher_ClientAutofilled"] = 1114] = "Cipher_ClientAutofilled";
    EventType[EventType["Cipher_SoftDeleted"] = 1115] = "Cipher_SoftDeleted";
    EventType[EventType["Cipher_Restored"] = 1116] = "Cipher_Restored";
    EventType[EventType["Cipher_ClientToggledCardNumberVisible"] = 1117] = "Cipher_ClientToggledCardNumberVisible";
    EventType[EventType["Cipher_ClientToggledTOTPSeedVisible"] = 1118] = "Cipher_ClientToggledTOTPSeedVisible";
    EventType[EventType["Collection_Created"] = 1300] = "Collection_Created";
    EventType[EventType["Collection_Updated"] = 1301] = "Collection_Updated";
    EventType[EventType["Collection_Deleted"] = 1302] = "Collection_Deleted";
    EventType[EventType["Group_Created"] = 1400] = "Group_Created";
    EventType[EventType["Group_Updated"] = 1401] = "Group_Updated";
    EventType[EventType["Group_Deleted"] = 1402] = "Group_Deleted";
    EventType[EventType["OrganizationUser_Invited"] = 1500] = "OrganizationUser_Invited";
    EventType[EventType["OrganizationUser_Confirmed"] = 1501] = "OrganizationUser_Confirmed";
    EventType[EventType["OrganizationUser_Updated"] = 1502] = "OrganizationUser_Updated";
    EventType[EventType["OrganizationUser_Removed"] = 1503] = "OrganizationUser_Removed";
    EventType[EventType["OrganizationUser_UpdatedGroups"] = 1504] = "OrganizationUser_UpdatedGroups";
    EventType[EventType["OrganizationUser_UnlinkedSso"] = 1505] = "OrganizationUser_UnlinkedSso";
    EventType[EventType["OrganizationUser_ResetPassword_Enroll"] = 1506] = "OrganizationUser_ResetPassword_Enroll";
    EventType[EventType["OrganizationUser_ResetPassword_Withdraw"] = 1507] = "OrganizationUser_ResetPassword_Withdraw";
    EventType[EventType["OrganizationUser_AdminResetPassword"] = 1508] = "OrganizationUser_AdminResetPassword";
    EventType[EventType["OrganizationUser_ResetSsoLink"] = 1509] = "OrganizationUser_ResetSsoLink";
    EventType[EventType["OrganizationUser_FirstSsoLogin"] = 1510] = "OrganizationUser_FirstSsoLogin";
    EventType[EventType["OrganizationUser_Revoked"] = 1511] = "OrganizationUser_Revoked";
    EventType[EventType["OrganizationUser_Restored"] = 1512] = "OrganizationUser_Restored";
    EventType[EventType["OrganizationUser_ApprovedAuthRequest"] = 1513] = "OrganizationUser_ApprovedAuthRequest";
    EventType[EventType["OrganizationUser_RejectedAuthRequest"] = 1514] = "OrganizationUser_RejectedAuthRequest";
    EventType[EventType["Organization_Updated"] = 1600] = "Organization_Updated";
    EventType[EventType["Organization_PurgedVault"] = 1601] = "Organization_PurgedVault";
    EventType[EventType["Organization_ClientExportedVault"] = 1602] = "Organization_ClientExportedVault";
    EventType[EventType["Organization_VaultAccessed"] = 1603] = "Organization_VaultAccessed";
    EventType[EventType["Organization_EnabledSso"] = 1604] = "Organization_EnabledSso";
    EventType[EventType["Organization_DisabledSso"] = 1605] = "Organization_DisabledSso";
    EventType[EventType["Organization_EnabledKeyConnector"] = 1606] = "Organization_EnabledKeyConnector";
    EventType[EventType["Organization_DisabledKeyConnector"] = 1607] = "Organization_DisabledKeyConnector";
    EventType[EventType["Organization_SponsorshipsSynced"] = 1608] = "Organization_SponsorshipsSynced";
    EventType[EventType["Organization_CollectionManagementUpdated"] = 1609] = "Organization_CollectionManagementUpdated";
    EventType[EventType["Policy_Updated"] = 1700] = "Policy_Updated";
    EventType[EventType["ProviderUser_Invited"] = 1800] = "ProviderUser_Invited";
    EventType[EventType["ProviderUser_Confirmed"] = 1801] = "ProviderUser_Confirmed";
    EventType[EventType["ProviderUser_Updated"] = 1802] = "ProviderUser_Updated";
    EventType[EventType["ProviderUser_Removed"] = 1803] = "ProviderUser_Removed";
    EventType[EventType["ProviderOrganization_Created"] = 1900] = "ProviderOrganization_Created";
    EventType[EventType["ProviderOrganization_Added"] = 1901] = "ProviderOrganization_Added";
    EventType[EventType["ProviderOrganization_Removed"] = 1902] = "ProviderOrganization_Removed";
    EventType[EventType["ProviderOrganization_VaultAccessed"] = 1903] = "ProviderOrganization_VaultAccessed";
    EventType[EventType["OrganizationDomain_Added"] = 2000] = "OrganizationDomain_Added";
    EventType[EventType["OrganizationDomain_Removed"] = 2001] = "OrganizationDomain_Removed";
    EventType[EventType["OrganizationDomain_Verified"] = 2002] = "OrganizationDomain_Verified";
    EventType[EventType["OrganizationDomain_NotVerified"] = 2003] = "OrganizationDomain_NotVerified";
    EventType[EventType["Secret_Retrieved"] = 2100] = "Secret_Retrieved";
})(EventType || (EventType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/http-status-code.enum.ts
/**
 * Hypertext Transfer Protocol (HTTP) response status codes.
 *
 * @see {@link https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}
 * src: https://gist.github.com/RWOverdijk/6cef816cfdf5722228e01cc05fd4b094
 */
var HttpStatusCode;
(function (HttpStatusCode) {
    /**
     * The server has received the request headers and the client should proceed to send the request body
     * (in the case of a request for which a body needs to be sent; for example, a POST request).
     * Sending a large request body to a server after a request has been rejected for inappropriate headers would be inefficient.
     * To have a server check the request's headers, a client must send Expect: 100-continue as a header in its initial request
     * and receive a 100 Continue status code in response before sending the body. The response 417 Expectation Failed indicates the request should not be continued.
     */
    HttpStatusCode[HttpStatusCode["Continue"] = 100] = "Continue";
    /**
     * The requester has asked the server to switch protocols and the server has agreed to do so.
     */
    HttpStatusCode[HttpStatusCode["SwitchingProtocols"] = 101] = "SwitchingProtocols";
    /**
     * A WebDAV request may contain many sub-requests involving file operations, requiring a long time to complete the request.
     * This code indicates that the server has received and is processing the request, but no response is available yet.
     * This prevents the client from timing out and assuming the request was lost.
     */
    HttpStatusCode[HttpStatusCode["Processing"] = 102] = "Processing";
    // **********************************************************************************************************
    // 200s - SUCCESS
    // **********************************************************************************************************
    /**
     * Standard response for successful HTTP requests.
     * The actual response will depend on the request method used.
     * In a GET request, the response will contain an entity corresponding to the requested resource.
     * In a POST request, the response will contain an entity describing or containing the result of the action.
     */
    HttpStatusCode[HttpStatusCode["Ok"] = 200] = "Ok";
    /**
     * The request has been fulfilled, resulting in the creation of a new resource.
     */
    HttpStatusCode[HttpStatusCode["Created"] = 201] = "Created";
    /**
     * The request has been accepted for processing, but the processing has not been completed.
     * The request might or might not be eventually acted upon, and may be disallowed when processing occurs.
     */
    HttpStatusCode[HttpStatusCode["Accepted"] = 202] = "Accepted";
    /**
     * SINCE HTTP/1.1
     * The server is a transforming proxy that received a 200 OK from its origin,
     * but is returning a modified version of the origin's response.
     */
    HttpStatusCode[HttpStatusCode["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
    /**
     * The server successfully processed the request and is not returning any content.
     */
    HttpStatusCode[HttpStatusCode["NoContent"] = 204] = "NoContent";
    /**
     * The server successfully processed the request, but is not returning any content.
     * Unlike a 204 response, this response requires that the requester reset the document view.
     */
    HttpStatusCode[HttpStatusCode["ResetContent"] = 205] = "ResetContent";
    /**
     * The server is delivering only part of the resource (byte serving) due to a range header sent by the client.
     * The range header is used by HTTP clients to enable resuming of interrupted downloads,
     * or split a download into multiple simultaneous streams.
     */
    HttpStatusCode[HttpStatusCode["PartialContent"] = 206] = "PartialContent";
    /**
     * The message body that follows is an XML message and can contain a number of separate response codes,
     * depending on how many sub-requests were made.
     */
    HttpStatusCode[HttpStatusCode["MultiStatus"] = 207] = "MultiStatus";
    /**
     * The members of a DAV binding have already been enumerated in a preceding part of the (multistatus) response,
     * and are not being included again.
     */
    HttpStatusCode[HttpStatusCode["AlreadyReported"] = 208] = "AlreadyReported";
    /**
     * The server has fulfilled a request for the resource,
     * and the response is a representation of the result of one or more instance-manipulations applied to the current instance.
     */
    HttpStatusCode[HttpStatusCode["ImUsed"] = 226] = "ImUsed";
    // **********************************************************************************************************
    // 300s - Redirections
    // **********************************************************************************************************
    /**
     * Indicates multiple options for the resource from which the client may choose (via agent-driven content negotiation).
     * For example, this code could be used to present multiple video format options,
     * to list files with different filename extensions, or to suggest word-sense disambiguation.
     */
    HttpStatusCode[HttpStatusCode["MultipleChoices"] = 300] = "MultipleChoices";
    /**
     * This and all future requests should be directed to the given URI.
     */
    HttpStatusCode[HttpStatusCode["MovedPermanently"] = 301] = "MovedPermanently";
    /**
     * This is an example of industry practice contradicting the standard.
     * The HTTP/1.0 specification (RFC 1945) required the client to perform a temporary redirect
     * (the original describing phrase was "Moved Temporarily"), but popular browsers implemented 302
     * with the functionality of a 303 See Other. Therefore, HTTP/1.1 added status codes 303 and 307
     * to distinguish between the two behaviours. However, some Web applications and frameworks
     * use the 302 status code as if it were the 303.
     */
    HttpStatusCode[HttpStatusCode["Found"] = 302] = "Found";
    /**
     * SINCE HTTP/1.1
     * The response to the request can be found under another URI using a GET method.
     * When received in response to a POST (or PUT/DELETE), the client should presume that
     * the server has received the data and should issue a redirect with a separate GET message.
     */
    HttpStatusCode[HttpStatusCode["SeeOther"] = 303] = "SeeOther";
    /**
     * Indicates that the resource has not been modified since the version specified by the request headers If-Modified-Since or If-None-Match.
     * In such case, there is no need to retransmit the resource since the client still has a previously-downloaded copy.
     */
    HttpStatusCode[HttpStatusCode["NotModified"] = 304] = "NotModified";
    /**
     * SINCE HTTP/1.1
     * The requested resource is available only through a proxy, the address for which is provided in the response.
     * Many HTTP clients (such as Mozilla and Internet Explorer) do not correctly handle responses with this status code, primarily for security reasons.
     */
    HttpStatusCode[HttpStatusCode["UseProxy"] = 305] = "UseProxy";
    /**
     * No longer used. Originally meant "Subsequent requests should use the specified proxy."
     */
    HttpStatusCode[HttpStatusCode["SwitchProxy"] = 306] = "SwitchProxy";
    /**
     * SINCE HTTP/1.1
     * In this case, the request should be repeated with another URI; however, future requests should still use the original URI.
     * In contrast to how 302 was historically implemented, the request method is not allowed to be changed when reissuing the original request.
     * For example, a POST request should be repeated using another POST request.
     */
    HttpStatusCode[HttpStatusCode["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    /**
     * The request and all future requests should be repeated using another URI.
     * 307 and 308 parallel the behaviors of 302 and 301, but do not allow the HTTP method to change.
     * So, for example, submitting a form to a permanently redirected resource may continue smoothly.
     */
    HttpStatusCode[HttpStatusCode["PermanentRedirect"] = 308] = "PermanentRedirect";
    // **********************************************************************************************************
    // 400s - Client / User messed up
    // **********************************************************************************************************
    /**
     * The server cannot or will not process the request due to an apparent client error
     * (e.g., malformed request syntax, too large size, invalid request message framing, or deceptive request routing).
     */
    HttpStatusCode[HttpStatusCode["BadRequest"] = 400] = "BadRequest";
    /**
     * Similar to 403 Forbidden, but specifically for use when authentication is required and has failed or has not yet
     * been provided. The response must include a WWW-Authenticate header field containing a challenge applicable to the
     * requested resource. See Basic access authentication and Digest access authentication. 401 semantically means
     * "unauthenticated",i.e. the user does not have the necessary credentials.
     */
    HttpStatusCode[HttpStatusCode["Unauthorized"] = 401] = "Unauthorized";
    /**
     * Reserved for future use. The original intention was that this code might be used as part of some form of digital
     * cash or micro payment scheme, but that has not happened, and this code is not usually used.
     * Google Developers API uses this status if a particular developer has exceeded the daily limit on requests.
     */
    HttpStatusCode[HttpStatusCode["PaymentRequired"] = 402] = "PaymentRequired";
    /**
     * The request was valid, but the server is refusing action.
     * The user might not have the necessary permissions for a resource.
     */
    HttpStatusCode[HttpStatusCode["Forbidden"] = 403] = "Forbidden";
    /**
     * The requested resource could not be found but may be available in the future.
     * Subsequent requests by the client are permissible.
     */
    HttpStatusCode[HttpStatusCode["NotFound"] = 404] = "NotFound";
    /**
     * A request method is not supported for the requested resource;
     * for example, a GET request on a form that requires data to be presented via POST, or a PUT request on a read-only resource.
     */
    HttpStatusCode[HttpStatusCode["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    /**
     * The requested resource is capable of generating only content not acceptable according to the Accept headers sent in the request.
     */
    HttpStatusCode[HttpStatusCode["NotAcceptable"] = 406] = "NotAcceptable";
    /**
     * The client must first authenticate itself with the proxy.
     */
    HttpStatusCode[HttpStatusCode["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
    /**
     * The server timed out waiting for the request.
     * According to HTTP specifications:
     * "The client did not produce a request within the time that the server was prepared to wait. The client MAY repeat the request without modifications at any later time."
     */
    HttpStatusCode[HttpStatusCode["RequestTimeout"] = 408] = "RequestTimeout";
    /**
     * Indicates that the request could not be processed because of conflict in the request,
     * such as an edit conflict between multiple simultaneous updates.
     */
    HttpStatusCode[HttpStatusCode["Conflict"] = 409] = "Conflict";
    /**
     * Indicates that the resource requested is no longer available and will not be available again.
     * This should be used when a resource has been intentionally removed and the resource should be purged.
     * Upon receiving a 410 status code, the client should not request the resource in the future.
     * Clients such as search engines should remove the resource from their indices.
     * Most use cases do not require clients and search engines to purge the resource, and a "404 Not Found" may be used instead.
     */
    HttpStatusCode[HttpStatusCode["Gone"] = 410] = "Gone";
    /**
     * The request did not specify the length of its content, which is required by the requested resource.
     */
    HttpStatusCode[HttpStatusCode["LengthRequired"] = 411] = "LengthRequired";
    /**
     * The server does not meet one of the preconditions that the requester put on the request.
     */
    HttpStatusCode[HttpStatusCode["PreconditionFailed"] = 412] = "PreconditionFailed";
    /**
     * The request is larger than the server is willing or able to process. Previously called "Request Entity Too Large".
     */
    HttpStatusCode[HttpStatusCode["PayloadTooLarge"] = 413] = "PayloadTooLarge";
    /**
     * The URI provided was too long for the server to process. Often the result of too much data being encoded as a query-string of a GET request,
     * in which case it should be converted to a POST request.
     * Called "Request-URI Too Long" previously.
     */
    HttpStatusCode[HttpStatusCode["UriTooLong"] = 414] = "UriTooLong";
    /**
     * The request entity has a media type which the server or resource does not support.
     * For example, the client uploads an image as image/svg+xml, but the server requires that images use a different format.
     */
    HttpStatusCode[HttpStatusCode["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
    /**
     * The client has asked for a portion of the file (byte serving), but the server cannot supply that portion.
     * For example, if the client asked for a part of the file that lies beyond the end of the file.
     * Called "Requested Range Not Satisfiable" previously.
     */
    HttpStatusCode[HttpStatusCode["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
    /**
     * The server cannot meet the requirements of the Expect request-header field.
     */
    HttpStatusCode[HttpStatusCode["ExpectationFailed"] = 417] = "ExpectationFailed";
    /**
     * This code was defined in 1998 as one of the traditional IETF April Fools' jokes, in RFC 2324, Hyper Text Coffee Pot Control Protocol,
     * and is not expected to be implemented by actual HTTP servers. The RFC specifies this code should be returned by
     * teapots requested to brew coffee. This HTTP status is used as an Easter egg in some websites, including Google.com.
     */
    HttpStatusCode[HttpStatusCode["IAmATeapot"] = 418] = "IAmATeapot";
    /**
     * The request was directed at a server that is not able to produce a response (for example because a connection reuse).
     */
    HttpStatusCode[HttpStatusCode["MisdirectedRequest"] = 421] = "MisdirectedRequest";
    /**
     * The request was well-formed but was unable to be followed due to semantic errors.
     */
    HttpStatusCode[HttpStatusCode["UnprocessableEntity"] = 422] = "UnprocessableEntity";
    /**
     * The resource that is being accessed is locked.
     */
    HttpStatusCode[HttpStatusCode["Locked"] = 423] = "Locked";
    /**
     * The request failed due to failure of a previous request (e.g., a PROPPATCH).
     */
    HttpStatusCode[HttpStatusCode["FailedDependency"] = 424] = "FailedDependency";
    /**
     * The client should switch to a different protocol such as TLS/1.0, given in the Upgrade header field.
     */
    HttpStatusCode[HttpStatusCode["UpgradeRequired"] = 426] = "UpgradeRequired";
    /**
     * The origin server requires the request to be conditional.
     * Intended to prevent "the 'lost update' problem, where a client
     * GETs a resource's state, modifies it, and PUTs it back to the server,
     * when meanwhile a third party has modified the state on the server, leading to a conflict."
     */
    HttpStatusCode[HttpStatusCode["PreconditionRequired"] = 428] = "PreconditionRequired";
    /**
     * The user has sent too many requests in a given amount of time. Intended for use with rate-limiting schemes.
     */
    HttpStatusCode[HttpStatusCode["TooManyRequests"] = 429] = "TooManyRequests";
    /**
     * The server is unwilling to process the request because either an individual header field,
     * or all the header fields collectively, are too large.
     */
    HttpStatusCode[HttpStatusCode["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
    /**
     * A server operator has received a legal demand to deny access to a resource or to a set of resources
     * that includes the requested resource. The code 451 was chosen as a reference to the novel Fahrenheit 451.
     */
    HttpStatusCode[HttpStatusCode["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
    // **********************************************************************************************************
    // 500s - Server messed up
    // **********************************************************************************************************
    /**
     * A generic error message, given when an unexpected condition was encountered and no more specific message is suitable.
     */
    HttpStatusCode[HttpStatusCode["InternalServerError"] = 500] = "InternalServerError";
    /**
     * The server either does not recognize the request method, or it lacks the ability to fulfill the request.
     * Usually this implies future availability (e.g., a new feature of a web-service API).
     */
    HttpStatusCode[HttpStatusCode["NotImplemented"] = 501] = "NotImplemented";
    /**
     * The server was acting as a gateway or proxy and received an invalid response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["BadGateway"] = 502] = "BadGateway";
    /**
     * The server is currently unavailable (because it is overloaded or down for maintenance).
     * Generally, this is a temporary state.
     */
    HttpStatusCode[HttpStatusCode["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    /**
     * The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["GatewayTimeout"] = 504] = "GatewayTimeout";
    /**
     * The server does not support the HTTP protocol version used in the request
     */
    HttpStatusCode[HttpStatusCode["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
    /**
     * Transparent content negotiation for the request results in a circular reference.
     */
    HttpStatusCode[HttpStatusCode["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
    /**
     * The server is unable to store the representation needed to complete the request.
     */
    HttpStatusCode[HttpStatusCode["InsufficientStorage"] = 507] = "InsufficientStorage";
    /**
     * The server detected an infinite loop while processing the request.
     */
    HttpStatusCode[HttpStatusCode["LoopDetected"] = 508] = "LoopDetected";
    /**
     * Further extensions to the request are required for the server to fulfill it.
     */
    HttpStatusCode[HttpStatusCode["NotExtended"] = 510] = "NotExtended";
    /**
     * The client needs to authenticate to gain network access.
     * Intended for use by intercepting proxies used to control access to the network (e.g., "captive portals" used
     * to require agreement to Terms of Service before granting full Internet access via a Wi-Fi hotspot).
     */
    HttpStatusCode[HttpStatusCode["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/integration-type.enum.ts
var IntegrationType;
(function (IntegrationType) {
    IntegrationType["Integration"] = "integration";
    IntegrationType["SDK"] = "sdk";
})(IntegrationType || (IntegrationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/native-messaging-version.enum.ts
var NativeMessagingVersion;
(function (NativeMessagingVersion) {
    NativeMessagingVersion[NativeMessagingVersion["One"] = 1] = "One";
    NativeMessagingVersion[NativeMessagingVersion["Latest"] = 1] = "Latest";
})(NativeMessagingVersion || (NativeMessagingVersion = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/notification-type.enum.ts
var NotificationType;
(function (NotificationType) {
    NotificationType[NotificationType["SyncCipherUpdate"] = 0] = "SyncCipherUpdate";
    NotificationType[NotificationType["SyncCipherCreate"] = 1] = "SyncCipherCreate";
    NotificationType[NotificationType["SyncLoginDelete"] = 2] = "SyncLoginDelete";
    NotificationType[NotificationType["SyncFolderDelete"] = 3] = "SyncFolderDelete";
    NotificationType[NotificationType["SyncCiphers"] = 4] = "SyncCiphers";
    NotificationType[NotificationType["SyncVault"] = 5] = "SyncVault";
    NotificationType[NotificationType["SyncOrgKeys"] = 6] = "SyncOrgKeys";
    NotificationType[NotificationType["SyncFolderCreate"] = 7] = "SyncFolderCreate";
    NotificationType[NotificationType["SyncFolderUpdate"] = 8] = "SyncFolderUpdate";
    NotificationType[NotificationType["SyncCipherDelete"] = 9] = "SyncCipherDelete";
    NotificationType[NotificationType["SyncSettings"] = 10] = "SyncSettings";
    NotificationType[NotificationType["LogOut"] = 11] = "LogOut";
    NotificationType[NotificationType["SyncSendCreate"] = 12] = "SyncSendCreate";
    NotificationType[NotificationType["SyncSendUpdate"] = 13] = "SyncSendUpdate";
    NotificationType[NotificationType["SyncSendDelete"] = 14] = "SyncSendDelete";
    NotificationType[NotificationType["AuthRequest"] = 15] = "AuthRequest";
    NotificationType[NotificationType["AuthRequestResponse"] = 16] = "AuthRequestResponse";
    NotificationType[NotificationType["SyncOrganizations"] = 17] = "SyncOrganizations";
})(NotificationType || (NotificationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/product-type.enum.ts
var ProductType;
(function (ProductType) {
    ProductType[ProductType["Free"] = 0] = "Free";
    ProductType[ProductType["Families"] = 1] = "Families";
    ProductType[ProductType["Teams"] = 2] = "Teams";
    ProductType[ProductType["Enterprise"] = 3] = "Enterprise";
    ProductType[ProductType["TeamsStarter"] = 4] = "TeamsStarter";
})(ProductType || (ProductType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/index.ts










;// CONCATENATED MODULE: ../../libs/common/src/models/request/keys.request.ts
class KeysRequest {
    constructor(publicKey, encryptedPrivateKey) {
        this.publicKey = publicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/account.ts



class EncryptionPair {
    toJSON() {
        return {
            encrypted: this.encrypted,
            decrypted: this.decrypted instanceof ArrayBuffer
                ? Utils.fromBufferToByteString(this.decrypted)
                : this.decrypted,
        };
    }
    static fromJSON(obj, decryptedFromJson, encryptedFromJson) {
        if (obj == null) {
            return null;
        }
        const pair = new EncryptionPair();
        if ((obj === null || obj === void 0 ? void 0 : obj.encrypted) != null) {
            pair.encrypted = encryptedFromJson
                ? encryptedFromJson(obj.encrypted)
                : obj.encrypted;
        }
        if ((obj === null || obj === void 0 ? void 0 : obj.decrypted) != null) {
            pair.decrypted = decryptedFromJson
                ? decryptedFromJson(obj.decrypted)
                : obj.decrypted;
        }
        return pair;
    }
}
class DataEncryptionPair {
}
class AccountData {
    constructor() {
        this.passwordGenerationHistory = new EncryptionPair();
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountData(), obj);
    }
}
class AccountKeys {
    constructor() {
        /** @deprecated July 2023, left for migration purposes*/
        this.cryptoSymmetricKey = new EncryptionPair();
    }
    toJSON() {
        // If you pass undefined into fromBufferToByteString, you will get an empty string back
        // which will cause all sorts of headaches down the line when you try to getPublicKey
        // and expect a Uint8Array and get an empty string instead.
        return Utils.merge(this, {
            publicKey: this.publicKey ? Utils.fromBufferToByteString(this.publicKey) : undefined,
        });
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountKeys(), obj, {
            cryptoSymmetricKey: EncryptionPair.fromJSON(obj === null || obj === void 0 ? void 0 : obj.cryptoSymmetricKey, SymmetricCryptoKey.fromJSON),
            publicKey: Utils.fromByteStringToArray(obj === null || obj === void 0 ? void 0 : obj.publicKey),
        });
    }
    static initRecordEncryptionPairsFromJSON(obj) {
        return EncryptionPair.fromJSON(obj, (decObj) => {
            if (obj == null) {
                return null;
            }
            const record = {};
            for (const id in decObj) {
                record[id] = SymmetricCryptoKey.fromJSON(decObj[id]);
            }
            return record;
        });
    }
}
class AccountProfile {
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountProfile(), obj);
    }
}
class AccountSettings {
    constructor() {
        this.vaultTimeoutAction = "lock";
        /** @deprecated July 2023, left for migration purposes*/
        this.pinProtected = new EncryptionPair();
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountSettings(), obj, {
            pinProtected: EncryptionPair.fromJSON(obj === null || obj === void 0 ? void 0 : obj.pinProtected, EncString.fromJSON),
        });
    }
}
class AccountTokens {
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountTokens(), obj);
    }
}
class Account {
    constructor(init) {
        this.data = new AccountData();
        this.keys = new AccountKeys();
        this.profile = new AccountProfile();
        this.settings = new AccountSettings();
        this.tokens = new AccountTokens();
        Object.assign(this, {
            data: Object.assign(Object.assign({}, new AccountData()), init === null || init === void 0 ? void 0 : init.data),
            keys: Object.assign(Object.assign({}, new AccountKeys()), init === null || init === void 0 ? void 0 : init.keys),
            profile: Object.assign(Object.assign({}, new AccountProfile()), init === null || init === void 0 ? void 0 : init.profile),
            settings: Object.assign(Object.assign({}, new AccountSettings()), init === null || init === void 0 ? void 0 : init.settings),
            tokens: Object.assign(Object.assign({}, new AccountTokens()), init === null || init === void 0 ? void 0 : init.tokens),
        });
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new Account({}), json, {
            keys: AccountKeys.fromJSON(json === null || json === void 0 ? void 0 : json.keys),
            data: AccountData.fromJSON(json === null || json === void 0 ? void 0 : json.data),
            profile: AccountProfile.fromJSON(json === null || json === void 0 ? void 0 : json.profile),
            settings: AccountSettings.fromJSON(json === null || json === void 0 ? void 0 : json.settings),
            tokens: AccountTokens.fromJSON(json === null || json === void 0 ? void 0 : json.tokens),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/login.strategy.ts
var login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












class LoginStrategyData {
}
class LoginStrategy {
    constructor(accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, billingAccountProfileStateService) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.userDecryptionOptionsService = userDecryptionOptionsService;
        this.billingAccountProfileStateService = billingAccountProfileStateService;
    }
    logInTwoFactor(twoFactor, captchaResponse = null) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = this.cache.value;
            data.tokenRequest.setTwoFactor(twoFactor);
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    startLogIn() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            this.twoFactorService.clearSelectedProvider();
            const tokenRequest = this.cache.value.tokenRequest;
            const response = yield this.apiService.postIdentityToken(tokenRequest);
            if (response instanceof IdentityTwoFactorResponse) {
                return [yield this.processTwoFactorResponse(response), response];
            }
            else if (response instanceof IdentityCaptchaResponse) {
                return [yield this.processCaptchaResponse(response), response];
            }
            else if (response instanceof IdentityTokenResponse) {
                return [yield this.processTokenResponse(response), response];
            }
            throw new Error("Invalid response object.");
        });
    }
    buildDeviceRequest() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const appId = yield this.appIdService.getAppId();
            return new DeviceRequest(appId, this.platformUtilsService);
        });
    }
    /**
     * Builds the TokenTwoFactorRequest to be used within other login strategies token requests
     * to the server.
     * If the user provided a 2FA token in an already created TokenTwoFactorRequest, it will be used.
     * If not, and the user has previously remembered a 2FA token, it will be used.
     * If neither of these are true, an empty TokenTwoFactorRequest will be returned.
     * @param userProvidedTwoFactor - optional - The 2FA token request provided by the caller
     * @param email - optional - ensure that email is provided for any login strategies that support remember 2FA functionality
     * @returns a promise which resolves to a TokenTwoFactorRequest to be sent to the server
     */
    buildTwoFactor(userProvidedTwoFactor, email) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            if (userProvidedTwoFactor != null) {
                return userProvidedTwoFactor;
            }
            if (email) {
                const storedTwoFactorToken = yield this.tokenService.getTwoFactorToken(email);
                if (storedTwoFactorToken != null) {
                    return new TokenTwoFactorRequest(TwoFactorProviderType.Remember, storedTwoFactorToken, false);
                }
            }
            return new TokenTwoFactorRequest();
        });
    }
    /**
     * Initializes the account with information from the IdTokenResponse after successful login.
     * It also sets the access token and refresh token in the token service.
     *
     * @param {IdentityTokenResponse} tokenResponse - The response from the server containing the identity token.
     * @returns {Promise<void>} - A promise that resolves when the account information has been successfully saved.
     */
    saveAccountInformation(tokenResponse) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const accountInformation = yield this.tokenService.decodeAccessToken(tokenResponse.accessToken);
            const userId = accountInformation.sub;
            const vaultTimeoutAction = yield this.stateService.getVaultTimeoutAction({ userId });
            const vaultTimeout = yield this.stateService.getVaultTimeout({ userId });
            // set access token and refresh token before account initialization so authN status can be accurate
            // User id will be derived from the access token.
            yield this.tokenService.setTokens(tokenResponse.accessToken, vaultTimeoutAction, vaultTimeout, tokenResponse.refreshToken);
            yield this.stateService.addAccount(new Account({
                profile: Object.assign(Object.assign({}, new AccountProfile()), {
                    userId,
                    name: accountInformation.name,
                    email: accountInformation.email,
                    kdfIterations: tokenResponse.kdfIterations,
                    kdfMemory: tokenResponse.kdfMemory,
                    kdfParallelism: tokenResponse.kdfParallelism,
                    kdfType: tokenResponse.kdf,
                }),
                tokens: Object.assign({}, new AccountTokens()),
            }));
            yield this.userDecryptionOptionsService.setUserDecryptionOptions(user_decryption_options_UserDecryptionOptions.fromResponse(tokenResponse));
            yield this.billingAccountProfileStateService.setHasPremium(accountInformation.premium, false);
            return userId;
        });
    }
    processTokenResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            // Old encryption keys must be migrated, but is currently only available on web.
            // Other clients shouldn't continue the login process.
            if (this.encryptionKeyMigrationRequired(response)) {
                result.requiresEncryptionKeyMigration = true;
                if (this.platformUtilsService.getClientType() !== ClientType.Web) {
                    return result;
                }
            }
            result.resetMasterPassword = response.resetMasterPassword;
            // Convert boolean to enum
            if (response.forcePasswordReset) {
                result.forcePasswordReset = ForceSetPasswordReason.AdminForcePasswordReset;
            }
            // Must come before setting keys, user key needs email to update additional keys
            const userId = yield this.saveAccountInformation(response);
            if (response.twoFactorToken != null) {
                // note: we can read email from access token b/c it was saved in saveAccountInformation
                const userEmail = yield this.tokenService.getEmail();
                yield this.tokenService.setTwoFactorToken(userEmail, response.twoFactorToken);
            }
            yield this.setMasterKey(response);
            yield this.setUserKey(response, userId);
            yield this.setPrivateKey(response);
            this.messagingService.send("loggedIn");
            return result;
        });
    }
    // Old accounts used master key for encryption. We are forcing migrations but only need to
    // check on password logins
    encryptionKeyMigrationRequired(response) {
        return false;
    }
    createKeyPairForOldAccount() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            try {
                const [publicKey, privateKey] = yield this.cryptoService.makeKeyPair();
                yield this.apiService.postAccountKeys(new KeysRequest(publicKey, privateKey.encryptedString));
                return privateKey.encryptedString;
            }
            catch (e) {
                this.logService.error(e);
            }
        });
    }
    /**
     * Handles the response from the server when a 2FA is required.
     * It clears any existing 2FA token, as it's no longer valid, and sets up the necessary data for the 2FA process.
     *
     * @param {IdentityTwoFactorResponse} response - The response from the server indicating that 2FA is required.
     * @returns {Promise<AuthResult>} - A promise that resolves to an AuthResult object
     */
    processTwoFactorResponse(response) {
        var _a;
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            // If we get a 2FA required response, then we should clear the 2FA token
            // just in case as it is no longer valid.
            yield this.clearTwoFactorToken();
            const result = new AuthResult();
            result.twoFactorProviders = response.twoFactorProviders2;
            this.twoFactorService.setProviders(response);
            this.cache.next(Object.assign(Object.assign({}, this.cache.value), { captchaBypassToken: (_a = response.captchaToken) !== null && _a !== void 0 ? _a : null }));
            result.ssoEmail2FaSessionToken = response.ssoEmail2faSessionToken;
            result.email = response.email;
            return result;
        });
    }
    /**
     * Clears the 2FA token from the token service using the user's email if it exists
     */
    clearTwoFactorToken() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const email = this.cache.value.userEnteredEmail;
            if (email) {
                yield this.tokenService.clearTwoFactorToken(email);
            }
        });
    }
    processCaptchaResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            result.captchaSiteKey = response.siteKey;
            return result;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/auth-request-login.strategy.ts
var auth_request_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class AuthRequestLoginStrategyData {
    static fromJSON(obj) {
        const data = Object.assign(new AuthRequestLoginStrategyData(), obj, {
            tokenRequest: PasswordTokenRequest.fromJSON(obj.tokenRequest),
            authRequestCredentials: AuthRequestLoginCredentials.fromJSON(obj.authRequestCredentials),
        });
        return data;
    }
}
class AuthRequestLoginStrategy extends LoginStrategy {
    constructor(data, accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, deviceTrustCryptoService, billingAccountProfileStateService) {
        super(accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, billingAccountProfileStateService);
        this.deviceTrustCryptoService = deviceTrustCryptoService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
        this.email$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((data) => data.tokenRequest.email));
        this.accessCode$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((data) => data.authRequestCredentials.accessCode));
        this.authRequestId$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((data) => data.authRequestCredentials.authRequestId));
    }
    logIn(credentials) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new AuthRequestLoginStrategyData();
            data.tokenRequest = new PasswordTokenRequest(credentials.email, credentials.accessCode, null, yield this.buildTwoFactor(credentials.twoFactor, credentials.email), yield this.buildDeviceRequest());
            data.tokenRequest.setAuthRequestAccessCode(credentials.authRequestId);
            data.authRequestCredentials = credentials;
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = this.cache.value;
            data.tokenRequest.captchaResponse = captchaResponse !== null && captchaResponse !== void 0 ? captchaResponse : data.captchaBypassToken;
            this.cache.next(data);
            return _super.logInTwoFactor.call(this, twoFactor);
        });
    }
    setMasterKey(response) {
        var _a;
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const authRequestCredentials = this.cache.value.authRequestCredentials;
            if (authRequestCredentials.decryptedMasterKey &&
                authRequestCredentials.decryptedMasterKeyHash) {
                const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
                yield this.masterPasswordService.setMasterKey(authRequestCredentials.decryptedMasterKey, userId);
                yield this.masterPasswordService.setMasterKeyHash(authRequestCredentials.decryptedMasterKeyHash, userId);
            }
        });
    }
    setUserKey(response, userId) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const authRequestCredentials = this.cache.value.authRequestCredentials;
            // User now may or may not have a master password
            // but set the master key encrypted user key if it exists regardless
            yield this.cryptoService.setMasterKeyEncryptedUserKey(response.key);
            if (authRequestCredentials.decryptedUserKey) {
                yield this.cryptoService.setUserKey(authRequestCredentials.decryptedUserKey);
            }
            else {
                yield this.trySetUserKeyWithMasterKey();
                // Establish trust if required after setting user key
                yield this.deviceTrustCryptoService.trustDeviceIfRequired(userId);
            }
        });
    }
    trySetUserKeyWithMasterKey() {
        var _a;
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            if (masterKey) {
                const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
                yield this.cryptoService.setUserKey(userKey);
            }
        });
    }
    setPrivateKey(response) {
        var _a;
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
        });
    }
    exportCache() {
        return {
            authRequest: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/domain-base.ts
var domain_base_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// https://contributing.bitwarden.com/architecture/clients/data-model#domain
class Domain {
    buildDomainModel(domain, dataObj, map, notEncList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = dataObj[map[prop] || prop];
            if (notEncList.indexOf(prop) > -1) {
                domain[prop] = objProp ? objProp : null;
            }
            else {
                domain[prop] = objProp ? new EncString(objProp) : null;
            }
        }
    }
    buildDataModel(domain, dataObj, map, notEncStringList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = domain[map[prop] || prop];
            if (notEncStringList.indexOf(prop) > -1) {
                dataObj[prop] = objProp != null ? objProp : null;
            }
            else {
                dataObj[prop] = objProp != null ? objProp.encryptedString : null;
            }
        }
    }
    decryptObj(viewModel, map, orgId, key = null) {
        return domain_base_awaiter(this, void 0, void 0, function* () {
            const promises = [];
            const self = this;
            for (const prop in map) {
                // eslint-disable-next-line
                if (!map.hasOwnProperty(prop)) {
                    continue;
                }
                (function (theProp) {
                    const p = Promise.resolve()
                        .then(() => {
                        const mapProp = map[theProp] || theProp;
                        if (self[mapProp]) {
                            return self[mapProp].decrypt(orgId, key);
                        }
                        return null;
                    })
                        .then((val) => {
                        viewModel[theProp] = val;
                    });
                    promises.push(p);
                })(prop);
            }
            yield Promise.all(promises);
            return viewModel;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/master-password-policy-options.ts

class MasterPasswordPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        this.minComplexity = 0;
        this.minLength = 0;
        this.requireUpper = false;
        this.requireLower = false;
        this.requireNumbers = false;
        this.requireSpecial = false;
        /**
         * Flag to indicate if the policy should be enforced on login.
         * If true, and the user's password does not meet the policy requirements,
         * the user will be forced to update their password.
         */
        this.enforceOnLogin = false;
    }
    static fromResponse(policy) {
        if (policy == null) {
            return null;
        }
        const options = new MasterPasswordPolicyOptions();
        options.minComplexity = policy.minComplexity;
        options.minLength = policy.minLength;
        options.requireUpper = policy.requireUpper;
        options.requireLower = policy.requireLower;
        options.requireNumbers = policy.requireNumbers;
        options.requireSpecial = policy.requireSpecial;
        options.enforceOnLogin = policy.enforceOnLogin;
        return options;
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/password-login.strategy.ts
var password_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








class PasswordLoginStrategyData {
    constructor() {
        /**
         * Tracks if the user needs to update their password due to
         * a password that does not meet an organization's master password policy.
         */
        this.forcePasswordResetReason = ForceSetPasswordReason.None;
    }
    static fromJSON(obj) {
        const data = Object.assign(new PasswordLoginStrategyData(), obj, {
            tokenRequest: PasswordTokenRequest.fromJSON(obj.tokenRequest),
            masterKey: SymmetricCryptoKey.fromJSON(obj.masterKey),
        });
        return data;
    }
}
class PasswordLoginStrategy extends LoginStrategy {
    constructor(data, accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, passwordStrengthService, policyService, loginStrategyService, billingAccountProfileStateService) {
        super(accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, billingAccountProfileStateService);
        this.stateService = stateService;
        this.passwordStrengthService = passwordStrengthService;
        this.policyService = policyService;
        this.loginStrategyService = loginStrategyService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
        this.email$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.tokenRequest.email));
        this.serverMasterKeyHash$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.tokenRequest.masterPasswordHash));
        this.localMasterKeyHash$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.localMasterKeyHash));
    }
    logIn(credentials) {
        var _a;
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const { email, masterPassword, captchaToken, twoFactor } = credentials;
            const data = new PasswordLoginStrategyData();
            data.masterKey = yield this.loginStrategyService.makePreloginKey(masterPassword, email);
            data.userEnteredEmail = email;
            // Hash the password early (before authentication) so we don't persist it in memory in plaintext
            data.localMasterKeyHash = yield this.cryptoService.hashMasterKey(masterPassword, data.masterKey, HashPurpose.LocalAuthorization);
            const serverMasterKeyHash = yield this.cryptoService.hashMasterKey(masterPassword, data.masterKey);
            data.tokenRequest = new PasswordTokenRequest(email, serverMasterKeyHash, captchaToken, yield this.buildTwoFactor(twoFactor, email), yield this.buildDeviceRequest());
            this.cache.next(data);
            const [authResult, identityResponse] = yield this.startLogIn();
            const masterPasswordPolicyOptions = this.getMasterPasswordPolicyOptionsFromResponse(identityResponse);
            // The identity result can contain master password policies for the user's organizations
            if (masterPasswordPolicyOptions === null || masterPasswordPolicyOptions === void 0 ? void 0 : masterPasswordPolicyOptions.enforceOnLogin) {
                // If there is a policy active, evaluate the supplied password before its no longer in memory
                const meetsRequirements = this.evaluateMasterPassword(credentials, masterPasswordPolicyOptions);
                if (!meetsRequirements) {
                    if (authResult.requiresCaptcha || authResult.requiresTwoFactor) {
                        // Save the flag to this strategy for later use as the master password is about to pass out of scope
                        this.cache.next(Object.assign(Object.assign({}, this.cache.value), { forcePasswordResetReason: ForceSetPasswordReason.WeakMasterPassword }));
                    }
                    else {
                        // Authentication was successful, save the force update password options with the state service
                        const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
                        yield this.masterPasswordService.setForceSetPasswordReason(ForceSetPasswordReason.WeakMasterPassword, userId);
                        authResult.forcePasswordReset = ForceSetPasswordReason.WeakMasterPassword;
                    }
                }
            }
            return authResult;
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        var _a;
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = this.cache.value;
            data.tokenRequest.captchaResponse = captchaResponse !== null && captchaResponse !== void 0 ? captchaResponse : data.captchaBypassToken;
            this.cache.next(data);
            const result = yield _super.logInTwoFactor.call(this, twoFactor);
            // 2FA was successful, save the force update password options with the state service if defined
            const forcePasswordResetReason = this.cache.value.forcePasswordResetReason;
            if (!result.requiresTwoFactor &&
                !result.requiresCaptcha &&
                forcePasswordResetReason != ForceSetPasswordReason.None) {
                const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
                yield this.masterPasswordService.setForceSetPasswordReason(forcePasswordResetReason, userId);
                result.forcePasswordReset = forcePasswordResetReason;
            }
            return result;
        });
    }
    setMasterKey(response) {
        var _a;
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const { masterKey, localMasterKeyHash } = this.cache.value;
            const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
            yield this.masterPasswordService.setMasterKey(masterKey, userId);
            yield this.masterPasswordService.setMasterKeyHash(localMasterKeyHash, userId);
        });
    }
    setUserKey(response, userId) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            // If migration is required, we won't have a user key to set yet.
            if (this.encryptionKeyMigrationRequired(response)) {
                return;
            }
            yield this.cryptoService.setMasterKeyEncryptedUserKey(response.key);
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            if (masterKey) {
                const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
                yield this.cryptoService.setUserKey(userKey);
            }
        });
    }
    setPrivateKey(response) {
        var _a;
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
        });
    }
    encryptionKeyMigrationRequired(response) {
        return !response.key;
    }
    getMasterPasswordPolicyOptionsFromResponse(response) {
        if (response == null || response instanceof IdentityCaptchaResponse) {
            return null;
        }
        return MasterPasswordPolicyOptions.fromResponse(response.masterPasswordPolicy);
    }
    evaluateMasterPassword({ masterPassword, email }, options) {
        var _a;
        const passwordStrength = (_a = this.passwordStrengthService.getPasswordStrength(masterPassword, email)) === null || _a === void 0 ? void 0 : _a.score;
        return this.policyService.evaluateMasterPassword(passwordStrength, masterPassword, options);
    }
    exportCache() {
        return {
            password: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/sso-token.request.ts



class SsoTokenRequest extends TokenRequest {
    constructor(code, codeVerifier, redirectUri, twoFactor, device) {
        super(twoFactor, device);
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.redirectUri = redirectUri;
        this.twoFactor = twoFactor;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "authorization_code";
        obj.code = this.code;
        obj.code_verifier = this.codeVerifier;
        obj.redirect_uri = this.redirectUri;
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(SsoTokenRequest.prototype), json, {
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/sso-login.strategy.ts
var sso_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class SsoLoginStrategyData {
    static fromJSON(obj) {
        return Object.assign(new SsoLoginStrategyData(), obj, {
            tokenRequest: SsoTokenRequest.fromJSON(obj.tokenRequest),
        });
    }
}
class SsoLoginStrategy extends LoginStrategy {
    constructor(data, accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, keyConnectorService, deviceTrustCryptoService, authRequestService, i18nService, billingAccountProfileStateService) {
        super(accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, billingAccountProfileStateService);
        this.keyConnectorService = keyConnectorService;
        this.deviceTrustCryptoService = deviceTrustCryptoService;
        this.authRequestService = authRequestService;
        this.i18nService = i18nService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
        this.email$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.email));
        this.orgId$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.orgId));
        this.ssoEmail2FaSessionToken$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.ssoEmail2FaSessionToken));
    }
    logIn(credentials) {
        var _a;
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new SsoLoginStrategyData();
            data.orgId = credentials.orgId;
            data.userEnteredEmail = credentials.email;
            data.tokenRequest = new SsoTokenRequest(credentials.code, credentials.codeVerifier, credentials.redirectUrl, yield this.buildTwoFactor(credentials.twoFactor, credentials.email), yield this.buildDeviceRequest());
            this.cache.next(data);
            const [ssoAuthResult] = yield this.startLogIn();
            const email = ssoAuthResult.email;
            const ssoEmail2FaSessionToken = ssoAuthResult.ssoEmail2FaSessionToken;
            // Auth guard currently handles redirects for this.
            if (ssoAuthResult.forcePasswordReset == ForceSetPasswordReason.AdminForcePasswordReset) {
                const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
                yield this.masterPasswordService.setForceSetPasswordReason(ssoAuthResult.forcePasswordReset, userId);
            }
            this.cache.next(Object.assign(Object.assign({}, this.cache.value), { email,
                ssoEmail2FaSessionToken }));
            return ssoAuthResult;
        });
    }
    setMasterKey(tokenResponse) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            // The only way we can be setting a master key at this point is if we are using Key Connector.
            // First, check to make sure that we should do so based on the token response.
            if (this.shouldSetMasterKeyFromKeyConnector(tokenResponse)) {
                // If we're here, we know that the user should use Key Connector (they have a KeyConnectorUrl) and does not have a master password.
                // We can now check the key on the token response to see whether they are a brand new user or an existing user.
                // The presence of a masterKeyEncryptedUserKey indicates that the user has already been provisioned in Key Connector.
                const newSsoUser = tokenResponse.key == null;
                if (newSsoUser) {
                    yield this.keyConnectorService.convertNewSsoUserToKeyConnector(tokenResponse, this.cache.value.orgId);
                }
                else {
                    const keyConnectorUrl = this.getKeyConnectorUrl(tokenResponse);
                    yield this.keyConnectorService.setMasterKeyFromUrl(keyConnectorUrl);
                }
            }
        });
    }
    /**
     * Determines if it is possible set the `masterKey` from Key Connector.
     * @param tokenResponse
     * @returns `true` if the master key can be set from Key Connector, `false` otherwise
     */
    shouldSetMasterKeyFromKeyConnector(tokenResponse) {
        var _a;
        const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
        if (userDecryptionOptions != null) {
            const userHasMasterPassword = userDecryptionOptions.hasMasterPassword;
            const userHasKeyConnectorUrl = ((_a = userDecryptionOptions.keyConnectorOption) === null || _a === void 0 ? void 0 : _a.keyConnectorUrl) != null;
            // In order for us to set the master key from Key Connector, we need to have a Key Connector URL
            // and the user must not have a master password.
            return userHasKeyConnectorUrl && !userHasMasterPassword;
        }
        else {
            // In pre-TDE versions of the server, the userDecryptionOptions will not be present.
            // In this case, we can determine if the user has a master password and has a Key Connector URL by
            // just checking the keyConnectorUrl property. This is because the server short-circuits on the response
            // and will not pass back the URL in the response if the user has a master password.
            // TODO: remove compatibility check after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            return tokenResponse.keyConnectorUrl != null;
        }
    }
    getKeyConnectorUrl(tokenResponse) {
        var _a, _b;
        // TODO: remove tokenResponse.keyConnectorUrl reference after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
        const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
        return ((_a = tokenResponse.keyConnectorUrl) !== null && _a !== void 0 ? _a : (_b = userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.keyConnectorOption) === null || _b === void 0 ? void 0 : _b.keyConnectorUrl);
    }
    // TODO: future passkey login strategy will need to support setting user key (decrypting via TDE or admin approval request)
    // so might be worth moving this logic to a common place (base login strategy or a separate service?)
    setUserKey(tokenResponse, userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKeyEncryptedUserKey = tokenResponse.key;
            // Note: masterKeyEncryptedUserKey is undefined for SSO JIT provisioned users
            // on account creation and subsequent logins (confirmed or unconfirmed)
            // but that is fine for TDE so we cannot return if it is undefined
            if (masterKeyEncryptedUserKey) {
                // set the master key encrypted user key if it exists
                yield this.cryptoService.setMasterKeyEncryptedUserKey(masterKeyEncryptedUserKey);
            }
            const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
            // Note: TDE and key connector are mutually exclusive
            if (userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.trustedDeviceOption) {
                yield this.trySetUserKeyWithApprovedAdminRequestIfExists(userId);
                const hasUserKey = yield this.cryptoService.hasUserKey();
                // Only try to set user key with device key if admin approval request was not successful
                if (!hasUserKey) {
                    yield this.trySetUserKeyWithDeviceKey(tokenResponse, userId);
                }
            }
            else if (masterKeyEncryptedUserKey != null &&
                this.getKeyConnectorUrl(tokenResponse) != null) {
                // Key connector enabled for user
                yield this.trySetUserKeyWithMasterKey();
            }
            // Note: In the traditional SSO flow with MP without key connector, the lock component
            // is responsible for deriving master key from MP entry and then decrypting the user key
        });
    }
    trySetUserKeyWithApprovedAdminRequestIfExists(userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            // At this point a user could have an admin auth request that has been approved
            const adminAuthReqStorable = yield this.authRequestService.getAdminAuthRequest(userId);
            if (!adminAuthReqStorable) {
                return;
            }
            // Call server to see if admin auth request has been approved
            let adminAuthReqResponse;
            try {
                adminAuthReqResponse = yield this.apiService.getAuthRequest(adminAuthReqStorable.id);
            }
            catch (error) {
                if (error instanceof ErrorResponse && error.statusCode === HttpStatusCode.NotFound) {
                    // if we get a 404, it means the auth request has been deleted so clear it from storage
                    yield this.authRequestService.clearAdminAuthRequest(userId);
                }
                // Always return on an error here as we don't want to block the user from logging in
                return;
            }
            if (adminAuthReqResponse === null || adminAuthReqResponse === void 0 ? void 0 : adminAuthReqResponse.requestApproved) {
                // if masterPasswordHash has a value, we will always receive authReqResponse.key
                // as authRequestPublicKey(masterKey) + authRequestPublicKey(masterPasswordHash)
                if (adminAuthReqResponse.masterPasswordHash) {
                    yield this.authRequestService.setKeysAfterDecryptingSharedMasterKeyAndHash(adminAuthReqResponse, adminAuthReqStorable.privateKey);
                }
                else {
                    // if masterPasswordHash is null, we will always receive authReqResponse.key
                    // as authRequestPublicKey(userKey)
                    yield this.authRequestService.setUserKeyAfterDecryptingSharedUserKey(adminAuthReqResponse, adminAuthReqStorable.privateKey);
                }
                if (yield this.cryptoService.hasUserKey()) {
                    // Now that we have a decrypted user key in memory, we can check if we
                    // need to establish trust on the current device
                    yield this.deviceTrustCryptoService.trustDeviceIfRequired(userId);
                    // if we successfully decrypted the user key, we can delete the admin auth request out of state
                    // TODO: eventually we post and clean up DB as well once consumed on client
                    yield this.authRequestService.clearAdminAuthRequest(userId);
                    this.platformUtilsService.showToast("success", null, this.i18nService.t("loginApproved"));
                }
            }
        });
    }
    trySetUserKeyWithDeviceKey(tokenResponse, userId) {
        var _a;
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const trustedDeviceOption = (_a = tokenResponse.userDecryptionOptions) === null || _a === void 0 ? void 0 : _a.trustedDeviceOption;
            const deviceKey = yield this.deviceTrustCryptoService.getDeviceKey(userId);
            const encDevicePrivateKey = trustedDeviceOption === null || trustedDeviceOption === void 0 ? void 0 : trustedDeviceOption.encryptedPrivateKey;
            const encUserKey = trustedDeviceOption === null || trustedDeviceOption === void 0 ? void 0 : trustedDeviceOption.encryptedUserKey;
            if (!deviceKey || !encDevicePrivateKey || !encUserKey) {
                return;
            }
            const userKey = yield this.deviceTrustCryptoService.decryptUserKeyWithDeviceKey(userId, encDevicePrivateKey, encUserKey, deviceKey);
            if (userKey) {
                yield this.cryptoService.setUserKey(userKey);
            }
        });
    }
    trySetUserKeyWithMasterKey() {
        var _a;
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            // There is a scenario in which the master key is not set here. That will occur if the user
            // has a master password and is using Key Connector. In that case, we cannot set the master key
            // because the user hasn't entered their master password yet.
            // Instead, we'll return here and let the migration to Key Connector handle setting the master key.
            if (!masterKey) {
                return;
            }
            const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
            yield this.cryptoService.setUserKey(userKey);
        });
    }
    setPrivateKey(tokenResponse) {
        var _a;
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const newSsoUser = tokenResponse.key == null;
            if (!newSsoUser) {
                yield this.cryptoService.setPrivateKey((_a = tokenResponse.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
            }
        });
    }
    exportCache() {
        return {
            sso: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/user-api-token.request.ts



class UserApiTokenRequest extends TokenRequest {
    constructor(clientId, clientSecret, twoFactor, device) {
        super(twoFactor, device);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.twoFactor = twoFactor;
    }
    toIdentityToken() {
        const obj = super.toIdentityToken(this.clientId);
        obj.scope = this.clientId.startsWith("organization") ? "api.organization" : "api";
        obj.grant_type = "client_credentials";
        obj.client_secret = this.clientSecret;
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(UserApiTokenRequest.prototype), json, {
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/user-api-login.strategy.ts
var user_api_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class UserApiLoginStrategyData {
    static fromJSON(obj) {
        return Object.assign(new UserApiLoginStrategyData(), obj, {
            tokenRequest: UserApiTokenRequest.fromJSON(obj.tokenRequest),
        });
    }
}
class UserApiLoginStrategy extends LoginStrategy {
    constructor(data, accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, environmentService, keyConnectorService, billingAccountProfileStateService) {
        super(accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, billingAccountProfileStateService);
        this.environmentService = environmentService;
        this.keyConnectorService = keyConnectorService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
    }
    logIn(credentials) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new UserApiLoginStrategyData();
            data.tokenRequest = new UserApiTokenRequest(credentials.clientId, credentials.clientSecret, yield this.buildTwoFactor(), yield this.buildDeviceRequest());
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    setMasterKey(response) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            if (response.apiUseKeyConnector) {
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const keyConnectorUrl = env.getKeyConnectorUrl();
                yield this.keyConnectorService.setMasterKeyFromUrl(keyConnectorUrl);
            }
        });
    }
    setUserKey(response, userId) {
        var _a;
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setMasterKeyEncryptedUserKey(response.key);
            if (response.apiUseKeyConnector) {
                const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
                const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
                if (masterKey) {
                    const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
                    yield this.cryptoService.setUserKey(userKey);
                }
            }
        });
    }
    setPrivateKey(response) {
        var _a;
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
        });
    }
    saveAccountInformation(tokenResponse) {
        const _super = Object.create(null, {
            saveAccountInformation: { get: () => super.saveAccountInformation }
        });
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            const userId = yield _super.saveAccountInformation.call(this, tokenResponse);
            const vaultTimeout = yield this.stateService.getVaultTimeout();
            const vaultTimeoutAction = yield this.stateService.getVaultTimeoutAction();
            const tokenRequest = this.cache.value.tokenRequest;
            yield this.tokenService.setClientId(tokenRequest.clientId, vaultTimeoutAction, vaultTimeout);
            yield this.tokenService.setClientSecret(tokenRequest.clientSecret, vaultTimeoutAction, vaultTimeout);
            return userId;
        });
    }
    exportCache() {
        return {
            userApiKey: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/webauthn-login-token.request.ts




class WebAuthnLoginTokenRequest extends TokenRequest {
    constructor(token, deviceResponse, device) {
        super(undefined, device);
        this.token = token;
        this.deviceResponse = deviceResponse;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "webauthn";
        obj.token = this.token;
        // must be a string b/c sending as form encoded data
        obj.deviceResponse = JSON.stringify(this.deviceResponse);
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(WebAuthnLoginTokenRequest.prototype), json, {
            deviceResponse: WebAuthnLoginAssertionResponseRequest.fromJSON(json.deviceResponse),
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/login-strategies/webauthn-login.strategy.ts
var webauthn_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class WebAuthnLoginStrategyData {
    static fromJSON(obj) {
        return Object.assign(new WebAuthnLoginStrategyData(), obj, {
            tokenRequest: WebAuthnLoginTokenRequest.fromJSON(obj.tokenRequest),
            credentials: WebAuthnLoginCredentials.fromJSON(obj.credentials),
        });
    }
}
class WebAuthnLoginStrategy extends LoginStrategy {
    constructor(data, accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, billingAccountProfileStateService) {
        super(accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, billingAccountProfileStateService);
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
    }
    logIn(credentials) {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new WebAuthnLoginStrategyData();
            data.credentials = credentials;
            data.tokenRequest = new WebAuthnLoginTokenRequest(credentials.token, credentials.deviceResponse, yield this.buildDeviceRequest());
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    logInTwoFactor() {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            throw new Error("2FA not supported yet for WebAuthn Login.");
        });
    }
    setMasterKey() {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            return Promise.resolve();
        });
    }
    setUserKey(idTokenResponse, userId) {
        var _a;
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKeyEncryptedUserKey = idTokenResponse.key;
            if (masterKeyEncryptedUserKey) {
                // set the master key encrypted user key if it exists
                yield this.cryptoService.setMasterKeyEncryptedUserKey(masterKeyEncryptedUserKey);
            }
            const userDecryptionOptions = idTokenResponse === null || idTokenResponse === void 0 ? void 0 : idTokenResponse.userDecryptionOptions;
            if (userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.webAuthnPrfOption) {
                const webAuthnPrfOption = (_a = idTokenResponse.userDecryptionOptions) === null || _a === void 0 ? void 0 : _a.webAuthnPrfOption;
                const credentials = this.cache.value.credentials;
                // confirm we still have the prf key
                if (!credentials.prfKey) {
                    return;
                }
                // decrypt prf encrypted private key
                const privateKey = yield this.cryptoService.decryptToBytes(webAuthnPrfOption.encryptedPrivateKey, credentials.prfKey);
                // decrypt user key with private key
                const userKey = yield this.cryptoService.rsaDecrypt(webAuthnPrfOption.encryptedUserKey.encryptedString, privateKey);
                if (userKey) {
                    yield this.cryptoService.setUserKey(new SymmetricCryptoKey(userKey));
                }
            }
        });
    }
    setPrivateKey(response) {
        var _a;
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
        });
    }
    exportCache() {
        return {
            webAuthn: this.cache.value,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/login-strategies/login-strategy.state.ts






/**
 * The current login strategy in use.
 */
const CURRENT_LOGIN_STRATEGY_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "currentLoginStrategy", {
    deserializer: (data) => data,
});
/**
 * The expiration date for the login strategy cache.
 * Used as a backup to the timer set on the service.
 */
const CACHE_EXPIRATION_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "loginStrategyCacheExpiration", {
    deserializer: (data) => (data ? null : new Date(data)),
});
/**
 * Auth Request notification for all instances of the login strategy service.
 * Note: this isn't an ideal approach, but allows both a background and
 * foreground instance to send out the notification.
 * TODO: Move to Auth Request service.
 */
const AUTH_REQUEST_PUSH_NOTIFICATION_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "authRequestPushNotification", {
    deserializer: (data) => data,
});
/**
 * A cache for login strategies to use for data persistence through
 * the login process.
 */
const CACHE_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "loginStrategyCache", {
    deserializer: (data) => {
        if (data == null) {
            return null;
        }
        return {
            password: data.password ? PasswordLoginStrategyData.fromJSON(data.password) : undefined,
            sso: data.sso ? SsoLoginStrategyData.fromJSON(data.sso) : undefined,
            userApiKey: data.userApiKey
                ? UserApiLoginStrategyData.fromJSON(data.userApiKey)
                : undefined,
            authRequest: data.authRequest
                ? AuthRequestLoginStrategyData.fromJSON(data.authRequest)
                : undefined,
            webAuthn: data.webAuthn ? WebAuthnLoginStrategyData.fromJSON(data.webAuthn) : undefined,
        };
    },
});

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/login-strategies/login-strategy.service.ts
var login_strategy_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













const sessionTimeoutLength = 2 * 60 * 1000; // 2 minutes
class LoginStrategyService {
    constructor(accountService, masterPasswordService, cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, keyConnectorService, environmentService, stateService, twoFactorService, i18nService, encryptService, passwordStrengthService, policyService, deviceTrustCryptoService, authRequestService, userDecryptionOptionsService, stateProvider, billingAccountProfileStateService) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.keyConnectorService = keyConnectorService;
        this.environmentService = environmentService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.i18nService = i18nService;
        this.encryptService = encryptService;
        this.passwordStrengthService = passwordStrengthService;
        this.policyService = policyService;
        this.deviceTrustCryptoService = deviceTrustCryptoService;
        this.authRequestService = authRequestService;
        this.userDecryptionOptionsService = userDecryptionOptionsService;
        this.stateProvider = stateProvider;
        this.billingAccountProfileStateService = billingAccountProfileStateService;
        this.currentAuthnTypeState = this.stateProvider.get(CURRENT_LOGIN_STRATEGY_KEY);
        this.loginStrategyCacheState = this.stateProvider.get(CACHE_KEY);
        this.loginStrategyCacheExpirationState = this.stateProvider.get(CACHE_EXPIRATION_KEY);
        this.authRequestPushNotificationState = this.stateProvider.get(AUTH_REQUEST_PUSH_NOTIFICATION_KEY);
        this.currentAuthType$ = this.currentAuthnTypeState.state$;
        this.loginStrategy$ = this.currentAuthnTypeState.state$.pipe((0,external_rxjs_namespaceObject.distinctUntilChanged)(), (0,external_rxjs_namespaceObject.combineLatestWith)(this.loginStrategyCacheState.state$), this.initializeLoginStrategy.bind(this), (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
    }
    getEmail() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("email$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.email$);
            }
            return null;
        });
    }
    getMasterPasswordHash() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("serverMasterKeyHash$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.serverMasterKeyHash$);
            }
            return null;
        });
    }
    getSsoEmail2FaSessionToken() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("ssoEmail2FaSessionToken$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.ssoEmail2FaSessionToken$);
            }
            return null;
        });
    }
    getAccessCode() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("accessCode$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.accessCode$);
            }
            return null;
        });
    }
    getAuthRequestId() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if ("authRequestId$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.authRequestId$);
            }
            return null;
        });
    }
    logIn(credentials) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearCache();
            yield this.currentAuthnTypeState.update((_) => credentials.type);
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            // Note: We aren't passing the credentials directly to the strategy since they are
            // created in the popup and can cause DeadObject references on Firefox.
            // This is a shallow copy, but use deep copy in future if objects are added to credentials
            // that were created in popup.
            // If the popup uses its own instance of this service, this can be removed.
            const ownedCredentials = Object.assign({}, credentials);
            const result = yield strategy.logIn(ownedCredentials);
            if (result != null && !result.requiresTwoFactor) {
                yield this.clearCache();
            }
            else {
                // Cache the strategy data so we can attempt again later with 2fa. Cache supports different contexts
                yield this.loginStrategyCacheState.update((_) => strategy.exportCache());
                yield this.startSessionTimeout();
            }
            return result;
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            if (!(yield this.isSessionValid())) {
                throw new Error(this.i18nService.t("sessionTimeout"));
            }
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if (strategy == null) {
                throw new Error("No login strategy found.");
            }
            try {
                const result = yield strategy.logInTwoFactor(twoFactor, captchaResponse);
                // Only clear cache if 2FA token has been accepted, otherwise we need to be able to try again
                if (result != null && !result.requiresTwoFactor && !result.requiresCaptcha) {
                    yield this.clearCache();
                }
                return result;
            }
            catch (e) {
                // API exceptions are okay, but if there are any unhandled client-side errors then clear cache to be safe
                if (!(e instanceof ErrorResponse)) {
                    yield this.clearCache();
                }
                throw e;
            }
        });
    }
    makePreloginKey(masterPassword, email) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            email = email.trim().toLowerCase();
            let kdf = null;
            let kdfConfig = null;
            try {
                const preloginResponse = yield this.apiService.postPrelogin(new PreloginRequest(email));
                if (preloginResponse != null) {
                    kdf = preloginResponse.kdf;
                    kdfConfig = new KdfConfig(preloginResponse.kdfIterations, preloginResponse.kdfMemory, preloginResponse.kdfParallelism);
                }
            }
            catch (e) {
                if (e == null || e.statusCode !== 404) {
                    throw e;
                }
            }
            return yield this.cryptoService.makeMasterKey(masterPassword, email, kdf, kdfConfig);
        });
    }
    // TODO: move to auth request service
    passwordlessLogin(id, key, requestApproved) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const pubKey = Utils.fromB64ToArray(key);
            const userId = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$)).id;
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            let keyToEncrypt;
            let encryptedMasterKeyHash = null;
            if (masterKey) {
                keyToEncrypt = masterKey.encKey;
                // Only encrypt the master password hash if masterKey exists as
                // we won't have a masterKeyHash without a masterKey
                const masterKeyHash = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKeyHash$(userId));
                if (masterKeyHash != null) {
                    encryptedMasterKeyHash = yield this.cryptoService.rsaEncrypt(Utils.fromUtf8ToArray(masterKeyHash), pubKey);
                }
            }
            else {
                const userKey = yield this.cryptoService.getUserKey();
                keyToEncrypt = userKey.key;
            }
            const encryptedKey = yield this.cryptoService.rsaEncrypt(keyToEncrypt, pubKey);
            const request = new PasswordlessAuthRequest(encryptedKey.encryptedString, encryptedMasterKeyHash === null || encryptedMasterKeyHash === void 0 ? void 0 : encryptedMasterKeyHash.encryptedString, yield this.appIdService.getAppId(), requestApproved);
            return yield this.apiService.putAuthRequest(id, request);
        });
    }
    clearCache() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.currentAuthnTypeState.update((_) => null);
            yield this.loginStrategyCacheState.update((_) => null);
            yield this.clearSessionTimeout();
        });
    }
    startSessionTimeout() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearSessionTimeout();
            yield this.loginStrategyCacheExpirationState.update((_) => new Date(Date.now() + sessionTimeoutLength));
            this.sessionTimeout = setTimeout(() => this.clearCache(), sessionTimeoutLength);
        });
    }
    clearSessionTimeout() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.loginStrategyCacheExpirationState.update((_) => null);
            this.sessionTimeout = null;
        });
    }
    isSessionValid() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const cache = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategyCacheState.state$);
            if (cache == null) {
                return false;
            }
            const expiration = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategyCacheExpirationState.state$);
            if (expiration != null && expiration < new Date()) {
                yield this.clearCache();
                return false;
            }
            return true;
        });
    }
    initializeLoginStrategy(source) {
        return source.pipe((0,external_rxjs_namespaceObject.map)(([strategy, data]) => {
            if (strategy == null) {
                return null;
            }
            switch (strategy) {
                case AuthenticationType.Password:
                    return new PasswordLoginStrategy(data === null || data === void 0 ? void 0 : data.password, this.accountService, this.masterPasswordService, this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.userDecryptionOptionsService, this.passwordStrengthService, this.policyService, this, this.billingAccountProfileStateService);
                case AuthenticationType.Sso:
                    return new SsoLoginStrategy(data === null || data === void 0 ? void 0 : data.sso, this.accountService, this.masterPasswordService, this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.userDecryptionOptionsService, this.keyConnectorService, this.deviceTrustCryptoService, this.authRequestService, this.i18nService, this.billingAccountProfileStateService);
                case AuthenticationType.UserApiKey:
                    return new UserApiLoginStrategy(data === null || data === void 0 ? void 0 : data.userApiKey, this.accountService, this.masterPasswordService, this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.userDecryptionOptionsService, this.environmentService, this.keyConnectorService, this.billingAccountProfileStateService);
                case AuthenticationType.AuthRequest:
                    return new AuthRequestLoginStrategy(data === null || data === void 0 ? void 0 : data.authRequest, this.accountService, this.masterPasswordService, this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.userDecryptionOptionsService, this.deviceTrustCryptoService, this.billingAccountProfileStateService);
                case AuthenticationType.WebAuthn:
                    return new WebAuthnLoginStrategy(data === null || data === void 0 ? void 0 : data.webAuthn, this.accountService, this.masterPasswordService, this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.userDecryptionOptionsService, this.billingAccountProfileStateService);
            }
        }));
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/user-decryption-options/user-decryption-options.service.ts
var user_decryption_options_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const USER_DECRYPTION_OPTIONS = new UserKeyDefinition(USER_DECRYPTION_OPTIONS_DISK, "decryptionOptions", {
    deserializer: (decryptionOptions) => user_decryption_options_UserDecryptionOptions.fromJSON(decryptionOptions),
    clearOn: ["logout"],
});
class UserDecryptionOptionsService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
        this.userDecryptionOptionsState = this.stateProvider.getActive(USER_DECRYPTION_OPTIONS);
        this.userDecryptionOptions$ = this.userDecryptionOptionsState.state$;
        this.hasMasterPassword$ = this.userDecryptionOptions$.pipe((0,external_rxjs_namespaceObject.map)((options) => { var _a; return (_a = options === null || options === void 0 ? void 0 : options.hasMasterPassword) !== null && _a !== void 0 ? _a : false; }));
    }
    userDecryptionOptionsById$(userId) {
        return this.stateProvider.getUser(userId, USER_DECRYPTION_OPTIONS).state$;
    }
    setUserDecryptionOptions(userDecryptionOptions) {
        return user_decryption_options_service_awaiter(this, void 0, void 0, function* () {
            yield this.userDecryptionOptionsState.update((_) => userDecryptionOptions);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/admin-auth-req-storable.ts

class AdminAuthRequestStorable {
    constructor(init) {
        if (init) {
            Object.assign(this, init);
        }
    }
    toJSON() {
        return {
            id: this.id,
            privateKey: Utils.fromBufferToByteString(this.privateKey),
        };
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        let privateKeyBuffer = null;
        if (obj.privateKey) {
            privateKeyBuffer = Utils.fromByteStringToArray(obj.privateKey);
        }
        return new AdminAuthRequestStorable({
            id: obj.id,
            privateKey: privateKeyBuffer,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/auth-request/auth-request.service.ts
var auth_request_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






/**
 * Disk-local to maintain consistency between tabs (even though
 * approvals are currently only available on desktop). We don't
 * want to clear this on logout as it's a user preference.
 */
const ACCEPT_AUTH_REQUESTS_KEY = new UserKeyDefinition(AUTH_REQUEST_DISK_LOCAL, "acceptAuthRequests", {
    deserializer: (value) => value !== null && value !== void 0 ? value : false,
    clearOn: [],
});
/**
 * Disk-local to maintain consistency between tabs. We don't want to
 * clear this on logout since admin auth requests are long-lived.
 */
const ADMIN_AUTH_REQUEST_KEY = new UserKeyDefinition(AUTH_REQUEST_DISK_LOCAL, "adminAuthRequest", {
    deserializer: (value) => value,
    clearOn: [],
});
class AuthRequestService {
    constructor(appIdService, accountService, masterPasswordService, cryptoService, apiService, stateProvider) {
        this.appIdService = appIdService;
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.stateProvider = stateProvider;
        this.authRequestPushNotificationSubject = new external_rxjs_namespaceObject.Subject();
        this.authRequestPushNotification$ = this.authRequestPushNotificationSubject.asObservable();
    }
    getAcceptAuthRequests(userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            const value = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, ACCEPT_AUTH_REQUESTS_KEY).state$);
            return value;
        });
    }
    setAcceptAuthRequests(accept, userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            yield this.stateProvider.setUserState(ACCEPT_AUTH_REQUESTS_KEY, accept, userId);
        });
    }
    getAdminAuthRequest(userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            const authRequestSerialized = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, ADMIN_AUTH_REQUEST_KEY).state$);
            const adminAuthRequestStorable = AdminAuthRequestStorable.fromJSON(authRequestSerialized);
            return adminAuthRequestStorable;
        });
    }
    setAdminAuthRequest(authRequest, userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            if (authRequest == null) {
                throw new Error("Auth request is required");
            }
            yield this.stateProvider.setUserState(ADMIN_AUTH_REQUEST_KEY, authRequest.toJSON(), userId);
        });
    }
    clearAdminAuthRequest(userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            yield this.stateProvider.setUserState(ADMIN_AUTH_REQUEST_KEY, null, userId);
        });
    }
    approveOrDenyAuthRequest(approve, authRequest) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (!authRequest.id) {
                throw new Error("Auth request has no id");
            }
            if (!authRequest.publicKey) {
                throw new Error("Auth request has no public key");
            }
            const pubKey = Utils.fromB64ToArray(authRequest.publicKey);
            const userId = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$)).id;
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            const masterKeyHash = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKeyHash$(userId));
            let encryptedMasterKeyHash;
            let keyToEncrypt;
            if (masterKey && masterKeyHash) {
                // Only encrypt the master password hash if masterKey exists as
                // we won't have a masterKeyHash without a masterKey
                encryptedMasterKeyHash = yield this.cryptoService.rsaEncrypt(Utils.fromUtf8ToArray(masterKeyHash), pubKey);
                keyToEncrypt = masterKey.encKey;
            }
            else {
                const userKey = yield this.cryptoService.getUserKey();
                keyToEncrypt = userKey.key;
            }
            const encryptedKey = yield this.cryptoService.rsaEncrypt(keyToEncrypt, pubKey);
            const response = new PasswordlessAuthRequest(encryptedKey.encryptedString, encryptedMasterKeyHash === null || encryptedMasterKeyHash === void 0 ? void 0 : encryptedMasterKeyHash.encryptedString, yield this.appIdService.getAppId(), approve);
            return yield this.apiService.putAuthRequest(authRequest.id, response);
        });
    }
    setUserKeyAfterDecryptingSharedUserKey(authReqResponse, authReqPrivateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield this.decryptPubKeyEncryptedUserKey(authReqResponse.key, authReqPrivateKey);
            yield this.cryptoService.setUserKey(userKey);
        });
    }
    setKeysAfterDecryptingSharedMasterKeyAndHash(authReqResponse, authReqPrivateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const { masterKey, masterKeyHash } = yield this.decryptPubKeyEncryptedMasterKeyAndHash(authReqResponse.key, authReqResponse.masterPasswordHash, authReqPrivateKey);
            // Decrypt and set user key in state
            const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
            // Set masterKey + masterKeyHash in state after decryption (in case decryption fails)
            const userId = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$)).id;
            yield this.masterPasswordService.setMasterKey(masterKey, userId);
            yield this.masterPasswordService.setMasterKeyHash(masterKeyHash, userId);
            yield this.cryptoService.setUserKey(userKey);
        });
    }
    // Decryption helpers
    decryptPubKeyEncryptedUserKey(pubKeyEncryptedUserKey, privateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const decryptedUserKeyBytes = yield this.cryptoService.rsaDecrypt(pubKeyEncryptedUserKey, privateKey);
            return new SymmetricCryptoKey(decryptedUserKeyBytes);
        });
    }
    decryptPubKeyEncryptedMasterKeyAndHash(pubKeyEncryptedMasterKey, pubKeyEncryptedMasterKeyHash, privateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const decryptedMasterKeyArrayBuffer = yield this.cryptoService.rsaDecrypt(pubKeyEncryptedMasterKey, privateKey);
            const decryptedMasterKeyHashArrayBuffer = yield this.cryptoService.rsaDecrypt(pubKeyEncryptedMasterKeyHash, privateKey);
            const masterKey = new SymmetricCryptoKey(decryptedMasterKeyArrayBuffer);
            const masterKeyHash = Utils.fromBufferToUtf8(decryptedMasterKeyHashArrayBuffer);
            return {
                masterKey,
                masterKeyHash,
            };
        });
    }
    sendAuthRequestPushNotification(notification) {
        if (notification.id != null) {
            this.authRequestPushNotificationSubject.next(notification.id);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/index.ts






;// CONCATENATED MODULE: ../../libs/auth/src/common/utilities/decode-jwt-token-to-json.utility.ts

function decodeJwtTokenToJson(jwtToken) {
    if (jwtToken == null) {
        throw new Error("JWT token not found");
    }
    const parts = jwtToken.split(".");
    if (parts.length !== 3) {
        throw new Error("JWT must have 3 parts");
    }
    // JWT has 3 parts: header, payload, signature separated by '.'
    // So, grab the payload to decode
    const encodedPayload = parts[1];
    let decodedPayloadJSON;
    try {
        // Attempt to decode from URL-safe Base64 to UTF-8
        decodedPayloadJSON = Utils.fromUrlB64ToUtf8(encodedPayload);
    }
    catch (decodingError) {
        throw new Error("Cannot decode the token");
    }
    try {
        // Attempt to parse the JSON payload
        const decodedToken = JSON.parse(decodedPayloadJSON);
        return decodedToken;
    }
    catch (jsonError) {
        throw new Error("Cannot parse the token's payload into JSON");
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/utilities/index.ts


;// CONCATENATED MODULE: ../../libs/auth/src/common/index.ts
/**
 * This barrel file should only contain non-Angular exports
 */





;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/api-key.response.ts

class ApiKeyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.apiKey = this.getResponseProperty("ApiKey");
        this.revisionDate = new Date(this.getResponseProperty("RevisionDate"));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/sso.ts
var SsoType;
(function (SsoType) {
    SsoType[SsoType["None"] = 0] = "None";
    SsoType[SsoType["OpenIdConnect"] = 1] = "OpenIdConnect";
    SsoType[SsoType["Saml2"] = 2] = "Saml2";
})(SsoType || (SsoType = {}));
var MemberDecryptionType;
(function (MemberDecryptionType) {
    MemberDecryptionType[MemberDecryptionType["MasterPassword"] = 0] = "MasterPassword";
    MemberDecryptionType[MemberDecryptionType["KeyConnector"] = 1] = "KeyConnector";
    MemberDecryptionType[MemberDecryptionType["TrustedDeviceEncryption"] = 2] = "TrustedDeviceEncryption";
})(MemberDecryptionType || (MemberDecryptionType = {}));
var OpenIdConnectRedirectBehavior;
(function (OpenIdConnectRedirectBehavior) {
    OpenIdConnectRedirectBehavior[OpenIdConnectRedirectBehavior["RedirectGet"] = 0] = "RedirectGet";
    OpenIdConnectRedirectBehavior[OpenIdConnectRedirectBehavior["FormPost"] = 1] = "FormPost";
})(OpenIdConnectRedirectBehavior || (OpenIdConnectRedirectBehavior = {}));
var Saml2BindingType;
(function (Saml2BindingType) {
    Saml2BindingType[Saml2BindingType["HttpRedirect"] = 1] = "HttpRedirect";
    Saml2BindingType[Saml2BindingType["HttpPost"] = 2] = "HttpPost";
})(Saml2BindingType || (Saml2BindingType = {}));
var Saml2NameIdFormat;
(function (Saml2NameIdFormat) {
    Saml2NameIdFormat[Saml2NameIdFormat["NotConfigured"] = 0] = "NotConfigured";
    Saml2NameIdFormat[Saml2NameIdFormat["Unspecified"] = 1] = "Unspecified";
    Saml2NameIdFormat[Saml2NameIdFormat["EmailAddress"] = 2] = "EmailAddress";
    Saml2NameIdFormat[Saml2NameIdFormat["X509SubjectName"] = 3] = "X509SubjectName";
    Saml2NameIdFormat[Saml2NameIdFormat["WindowsDomainQualifiedName"] = 4] = "WindowsDomainQualifiedName";
    Saml2NameIdFormat[Saml2NameIdFormat["KerberosPrincipalName"] = 5] = "KerberosPrincipalName";
    Saml2NameIdFormat[Saml2NameIdFormat["EntityIdentifier"] = 6] = "EntityIdentifier";
    Saml2NameIdFormat[Saml2NameIdFormat["Persistent"] = 7] = "Persistent";
    Saml2NameIdFormat[Saml2NameIdFormat["Transient"] = 8] = "Transient";
})(Saml2NameIdFormat || (Saml2NameIdFormat = {}));
var Saml2SigningBehavior;
(function (Saml2SigningBehavior) {
    Saml2SigningBehavior[Saml2SigningBehavior["IfIdpWantAuthnRequestsSigned"] = 0] = "IfIdpWantAuthnRequestsSigned";
    Saml2SigningBehavior[Saml2SigningBehavior["Always"] = 1] = "Always";
    Saml2SigningBehavior[Saml2SigningBehavior["Never"] = 3] = "Never";
})(Saml2SigningBehavior || (Saml2SigningBehavior = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/api/sso-config.api.ts


class SsoConfigApi extends BaseResponse {
    static fromView(view, api = new SsoConfigApi()) {
        api.configType = view.configType;
        api.memberDecryptionType = view.memberDecryptionType;
        api.keyConnectorUrl = view.keyConnectorUrl;
        if (api.configType === SsoType.OpenIdConnect) {
            api.authority = view.openId.authority;
            api.clientId = view.openId.clientId;
            api.clientSecret = view.openId.clientSecret;
            api.metadataAddress = view.openId.metadataAddress;
            api.redirectBehavior = view.openId.redirectBehavior;
            api.getClaimsFromUserInfoEndpoint = view.openId.getClaimsFromUserInfoEndpoint;
            api.additionalScopes = view.openId.additionalScopes;
            api.additionalUserIdClaimTypes = view.openId.additionalUserIdClaimTypes;
            api.additionalEmailClaimTypes = view.openId.additionalEmailClaimTypes;
            api.additionalNameClaimTypes = view.openId.additionalNameClaimTypes;
            api.acrValues = view.openId.acrValues;
            api.expectedReturnAcrValue = view.openId.expectedReturnAcrValue;
        }
        else if (api.configType === SsoType.Saml2) {
            api.spUniqueEntityId = view.saml.spUniqueEntityId;
            api.spNameIdFormat = view.saml.spNameIdFormat;
            api.spOutboundSigningAlgorithm = view.saml.spOutboundSigningAlgorithm;
            api.spSigningBehavior = view.saml.spSigningBehavior;
            api.spMinIncomingSigningAlgorithm = view.saml.spMinIncomingSigningAlgorithm;
            api.spWantAssertionsSigned = view.saml.spWantAssertionsSigned;
            api.spValidateCertificates = view.saml.spValidateCertificates;
            api.idpEntityId = view.saml.idpEntityId;
            api.idpBindingType = view.saml.idpBindingType;
            api.idpSingleSignOnServiceUrl = view.saml.idpSingleSignOnServiceUrl;
            api.idpSingleLogoutServiceUrl = view.saml.idpSingleLogoutServiceUrl;
            api.idpX509PublicCert = view.saml.idpX509PublicCert;
            api.idpOutboundSigningAlgorithm = view.saml.idpOutboundSigningAlgorithm;
            api.idpAllowUnsolicitedAuthnResponse = view.saml.idpAllowUnsolicitedAuthnResponse;
            api.idpWantAuthnRequestsSigned = view.saml.idpWantAuthnRequestsSigned;
            // Value is inverted in the api model (disable instead of allow)
            api.idpDisableOutboundLogoutRequests = !view.saml.idpAllowOutboundLogoutRequests;
        }
        return api;
    }
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.configType = this.getResponseProperty("ConfigType");
        this.memberDecryptionType = this.getResponseProperty("MemberDecryptionType");
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        this.authority = this.getResponseProperty("Authority");
        this.clientId = this.getResponseProperty("ClientId");
        this.clientSecret = this.getResponseProperty("ClientSecret");
        this.metadataAddress = this.getResponseProperty("MetadataAddress");
        this.redirectBehavior = this.getResponseProperty("RedirectBehavior");
        this.getClaimsFromUserInfoEndpoint = this.getResponseProperty("GetClaimsFromUserInfoEndpoint");
        this.additionalScopes = this.getResponseProperty("AdditionalScopes");
        this.additionalUserIdClaimTypes = this.getResponseProperty("AdditionalUserIdClaimTypes");
        this.additionalEmailClaimTypes = this.getResponseProperty("AdditionalEmailClaimTypes");
        this.additionalNameClaimTypes = this.getResponseProperty("AdditionalNameClaimTypes");
        this.acrValues = this.getResponseProperty("AcrValues");
        this.expectedReturnAcrValue = this.getResponseProperty("ExpectedReturnAcrValue");
        this.spUniqueEntityId = this.getResponseProperty("SpUniqueEntityId");
        this.spNameIdFormat = this.getResponseProperty("SpNameIdFormat");
        this.spOutboundSigningAlgorithm = this.getResponseProperty("SpOutboundSigningAlgorithm");
        this.spSigningBehavior = this.getResponseProperty("SpSigningBehavior");
        this.spMinIncomingSigningAlgorithm = this.getResponseProperty("SpMinIncomingSigningAlgorithm");
        this.spWantAssertionsSigned = this.getResponseProperty("SpWantAssertionsSigned");
        this.spValidateCertificates = this.getResponseProperty("SpValidateCertificates");
        this.idpEntityId = this.getResponseProperty("IdpEntityId");
        this.idpBindingType = this.getResponseProperty("IdpBindingType");
        this.idpSingleSignOnServiceUrl = this.getResponseProperty("IdpSingleSignOnServiceUrl");
        this.idpSingleLogoutServiceUrl = this.getResponseProperty("IdpSingleLogoutServiceUrl");
        this.idpX509PublicCert = this.getResponseProperty("IdpX509PublicCert");
        this.idpOutboundSigningAlgorithm = this.getResponseProperty("IdpOutboundSigningAlgorithm");
        this.idpAllowUnsolicitedAuthnResponse = this.getResponseProperty("IdpAllowUnsolicitedAuthnResponse");
        this.idpDisableOutboundLogoutRequests = this.getResponseProperty("IdpDisableOutboundLogoutRequests");
        this.idpWantAuthnRequestsSigned = this.getResponseProperty("IdpWantAuthnRequestsSigned");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/organization-sso.response.ts


class OrganizationSsoResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.enabled = this.getResponseProperty("Enabled");
        this.identifier = this.getResponseProperty("Identifier");
        this.data =
            this.getResponseProperty("Data") != null
                ? new SsoConfigApi(this.getResponseProperty("Data"))
                : null;
        this.urls = new SsoUrls(this.getResponseProperty("Urls"));
    }
}
class SsoUrls extends BaseResponse {
    constructor(response) {
        super(response);
        this.callbackPath = this.getResponseProperty("CallbackPath");
        this.signedOutCallbackPath = this.getResponseProperty("SignedOutCallbackPath");
        this.spEntityId = this.getResponseProperty("SpEntityId");
        this.spEntityIdStatic = this.getResponseProperty("SpEntityIdStatic");
        this.spMetadataUrl = this.getResponseProperty("SpMetadataUrl");
        this.spAcsUrl = this.getResponseProperty("SpAcsUrl");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/billing.response.ts

class BillingResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.invoices = [];
        this.transactions = [];
        this.balance = this.getResponseProperty("Balance");
        const paymentSource = this.getResponseProperty("PaymentSource");
        const transactions = this.getResponseProperty("Transactions");
        const invoices = this.getResponseProperty("Invoices");
        this.paymentSource = paymentSource == null ? null : new BillingSourceResponse(paymentSource);
        if (transactions != null) {
            this.transactions = transactions.map((t) => new BillingTransactionResponse(t));
        }
        if (invoices != null) {
            this.invoices = invoices.map((i) => new BillingInvoiceResponse(i));
        }
    }
    get hasNoHistory() {
        return this.invoices.length == 0 && this.transactions.length == 0;
    }
}
class BillingSourceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.type = this.getResponseProperty("Type");
        this.cardBrand = this.getResponseProperty("CardBrand");
        this.description = this.getResponseProperty("Description");
        this.needsVerification = this.getResponseProperty("NeedsVerification");
    }
}
class BillingInvoiceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.url = this.getResponseProperty("Url");
        this.pdfUrl = this.getResponseProperty("PdfUrl");
        this.number = this.getResponseProperty("Number");
        this.paid = this.getResponseProperty("Paid");
        this.date = this.getResponseProperty("Date");
        this.amount = this.getResponseProperty("Amount");
    }
}
class BillingTransactionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.createdDate = this.getResponseProperty("CreatedDate");
        this.amount = this.getResponseProperty("Amount");
        this.refunded = this.getResponseProperty("Refunded");
        this.partiallyRefunded = this.getResponseProperty("PartiallyRefunded");
        this.refundedAmount = this.getResponseProperty("RefundedAmount");
        this.type = this.getResponseProperty("Type");
        this.paymentMethodType = this.getResponseProperty("PaymentMethodType");
        this.details = this.getResponseProperty("Details");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/plan.response.ts

class PlanResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.type = this.getResponseProperty("Type");
        this.product = this.getResponseProperty("Product");
        this.name = this.getResponseProperty("Name");
        this.isAnnual = this.getResponseProperty("IsAnnual");
        this.nameLocalizationKey = this.getResponseProperty("NameLocalizationKey");
        this.descriptionLocalizationKey = this.getResponseProperty("DescriptionLocalizationKey");
        this.canBeUsedByBusiness = this.getResponseProperty("CanBeUsedByBusiness");
        this.trialPeriodDays = this.getResponseProperty("TrialPeriodDays");
        this.hasSelfHost = this.getResponseProperty("HasSelfHost");
        this.hasPolicies = this.getResponseProperty("HasPolicies");
        this.hasGroups = this.getResponseProperty("HasGroups");
        this.hasDirectory = this.getResponseProperty("HasDirectory");
        this.hasEvents = this.getResponseProperty("HasEvents");
        this.hasTotp = this.getResponseProperty("HasTotp");
        this.has2fa = this.getResponseProperty("Has2fa");
        this.hasApi = this.getResponseProperty("HasApi");
        this.hasSso = this.getResponseProperty("HasSso");
        this.hasResetPassword = this.getResponseProperty("HasResetPassword");
        this.usersGetPremium = this.getResponseProperty("UsersGetPremium");
        this.upgradeSortOrder = this.getResponseProperty("UpgradeSortOrder");
        this.displaySortOrder = this.getResponseProperty("DisplaySortOrder");
        this.legacyYear = this.getResponseProperty("LegacyYear");
        this.disabled = this.getResponseProperty("Disabled");
        const passwordManager = this.getResponseProperty("PasswordManager");
        const secretsManager = this.getResponseProperty("SecretsManager");
        this.PasswordManager =
            passwordManager == null ? null : new PasswordManagerPlanFeaturesResponse(passwordManager);
        this.SecretsManager =
            secretsManager == null ? null : new SecretsManagerPlanFeaturesResponse(secretsManager);
    }
}
class SecretsManagerPlanFeaturesResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.stripeSeatPlanId = this.getResponseProperty("StripeSeatPlanId");
        this.baseSeats = this.getResponseProperty("BaseSeats");
        this.basePrice = this.getResponseProperty("BasePrice");
        this.seatPrice = this.getResponseProperty("SeatPrice");
        this.hasAdditionalSeatsOption = this.getResponseProperty("HasAdditionalSeatsOption");
        this.maxAdditionalSeats = this.getResponseProperty("MaxAdditionalSeats");
        this.maxSeats = this.getResponseProperty("MaxSeats");
        this.stripeServiceAccountPlanId = this.getResponseProperty("StripeServiceAccountPlanId");
        this.additionalPricePerServiceAccount = this.getResponseProperty("AdditionalPricePerServiceAccount");
        this.baseServiceAccount = this.getResponseProperty("BaseServiceAccount");
        this.maxServiceAccount = this.getResponseProperty("MaxServiceAccount");
        this.hasAdditionalServiceAccountOption = this.getResponseProperty("HasAdditionalServiceAccountOption");
        this.maxAdditionalServiceAccounts = this.getResponseProperty("MaxAdditionalServiceAccounts");
        this.maxProjects = this.getResponseProperty("MaxProjects");
    }
}
class PasswordManagerPlanFeaturesResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.stripePlanId = this.getResponseProperty("StripePlanId");
        this.stripeSeatPlanId = this.getResponseProperty("StripeSeatPlanId");
        this.stripeStoragePlanId = this.getResponseProperty("StripeStoragePlanId");
        this.stripePremiumAccessPlanId = this.getResponseProperty("StripePremiumAccessPlanId");
        this.basePrice = this.getResponseProperty("BasePrice");
        this.seatPrice = this.getResponseProperty("SeatPrice");
        this.baseSeats = this.getResponseProperty("BaseSeats");
        this.maxAdditionalSeats = this.getResponseProperty("MaxAdditionalSeats");
        this.premiumAccessOptionPrice = this.getResponseProperty("PremiumAccessOptionPrice");
        this.maxSeats = this.getResponseProperty("MaxSeats");
        this.additionalStoragePricePerGb = this.getResponseProperty("AdditionalStoragePricePerGb");
        this.hasAdditionalSeatsOption = this.getResponseProperty("HasAdditionalSeatsOption");
        this.baseStorageGb = this.getResponseProperty("BaseStorageGb");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.hasAdditionalStorageOption = this.getResponseProperty("HasAdditionalStorageOption");
        this.maxAdditionalStorage = this.getResponseProperty("MaxAdditionalStorage");
        this.hasPremiumAccessOption = this.getResponseProperty("HasPremiumAccessOption");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization.response.ts


class OrganizationResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.businessName = this.getResponseProperty("BusinessName");
        this.businessAddress1 = this.getResponseProperty("BusinessAddress1");
        this.businessAddress2 = this.getResponseProperty("BusinessAddress2");
        this.businessAddress3 = this.getResponseProperty("BusinessAddress3");
        this.businessCountry = this.getResponseProperty("BusinessCountry");
        this.businessTaxNumber = this.getResponseProperty("BusinessTaxNumber");
        this.billingEmail = this.getResponseProperty("BillingEmail");
        const plan = this.getResponseProperty("Plan");
        this.plan = plan == null ? null : new PlanResponse(plan);
        this.planType = this.getResponseProperty("PlanType");
        this.seats = this.getResponseProperty("Seats");
        this.maxAutoscaleSeats = this.getResponseProperty("MaxAutoscaleSeats");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.useGroups = this.getResponseProperty("UseGroups");
        this.useDirectory = this.getResponseProperty("UseDirectory");
        this.useEvents = this.getResponseProperty("UseEvents");
        this.useTotp = this.getResponseProperty("UseTotp");
        this.use2fa = this.getResponseProperty("Use2fa");
        this.useApi = this.getResponseProperty("UseApi");
        this.useResetPassword = this.getResponseProperty("UseResetPassword");
        this.useSecretsManager = this.getResponseProperty("UseSecretsManager");
        this.hasPublicAndPrivateKeys = this.getResponseProperty("HasPublicAndPrivateKeys");
        this.usePasswordManager = this.getResponseProperty("UsePasswordManager");
        this.smSeats = this.getResponseProperty("SmSeats");
        this.smServiceAccounts = this.getResponseProperty("SmServiceAccounts");
        this.maxAutoscaleSmSeats = this.getResponseProperty("MaxAutoscaleSmSeats");
        this.maxAutoscaleSmServiceAccounts = this.getResponseProperty("MaxAutoscaleSmServiceAccounts");
        this.limitCollectionCreationDeletion = this.getResponseProperty("LimitCollectionCreationDeletion");
        this.allowAdminAccessToAllCollectionItems = this.getResponseProperty("AllowAdminAccessToAllCollectionItems");
        this.flexibleCollections = this.getResponseProperty("FlexibleCollections");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/subscription.response.ts

class SubscriptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.storageName = this.getResponseProperty("StorageName");
        this.storageGb = this.getResponseProperty("StorageGb");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.license = this.getResponseProperty("License");
        this.expiration = this.getResponseProperty("Expiration");
        const subscription = this.getResponseProperty("Subscription");
        const upcomingInvoice = this.getResponseProperty("UpcomingInvoice");
        this.subscription = subscription == null ? null : new BillingSubscriptionResponse(subscription);
        this.upcomingInvoice =
            upcomingInvoice == null
                ? null
                : new BillingSubscriptionUpcomingInvoiceResponse(upcomingInvoice);
    }
}
class BillingSubscriptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.items = [];
        this.trialStartDate = this.getResponseProperty("TrialStartDate");
        this.trialEndDate = this.getResponseProperty("TrialEndDate");
        this.periodStartDate = this.getResponseProperty("PeriodStartDate");
        this.periodEndDate = this.getResponseProperty("PeriodEndDate");
        this.cancelledDate = this.getResponseProperty("CancelledDate");
        this.cancelAtEndDate = this.getResponseProperty("CancelAtEndDate");
        this.status = this.getResponseProperty("Status");
        this.cancelled = this.getResponseProperty("Cancelled");
        const items = this.getResponseProperty("Items");
        if (items != null) {
            this.items = items.map((i) => new BillingSubscriptionItemResponse(i));
        }
        this.collectionMethod = this.getResponseProperty("CollectionMethod");
        this.suspensionDate = this.getResponseProperty("SuspensionDate");
        this.unpaidPeriodEndDate = this.getResponseProperty("unpaidPeriodEndDate");
        this.gracePeriod = this.getResponseProperty("GracePeriod");
    }
}
class BillingSubscriptionItemResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.productId = this.getResponseProperty("ProductId");
        this.name = this.getResponseProperty("Name");
        this.amount = this.getResponseProperty("Amount");
        this.quantity = this.getResponseProperty("Quantity");
        this.interval = this.getResponseProperty("Interval");
        this.sponsoredSubscriptionItem = this.getResponseProperty("SponsoredSubscriptionItem");
        this.addonSubscriptionItem = this.getResponseProperty("AddonSubscriptionItem");
    }
}
class BillingSubscriptionUpcomingInvoiceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.date = this.getResponseProperty("Date");
        this.amount = this.getResponseProperty("Amount");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/organization-subscription.response.ts



class OrganizationSubscriptionResponse extends OrganizationResponse {
    constructor(response) {
        super(response);
        this.storageName = this.getResponseProperty("StorageName");
        this.storageGb = this.getResponseProperty("StorageGb");
        const subscription = this.getResponseProperty("Subscription");
        this.subscription = subscription == null ? null : new BillingSubscriptionResponse(subscription);
        const upcomingInvoice = this.getResponseProperty("UpcomingInvoice");
        this.upcomingInvoice =
            upcomingInvoice == null
                ? null
                : new BillingSubscriptionUpcomingInvoiceResponse(upcomingInvoice);
        const customerDiscount = this.getResponseProperty("CustomerDiscount");
        this.customerDiscount =
            customerDiscount == null ? null : new BillingCustomerDiscount(customerDiscount);
        this.expiration = this.getResponseProperty("Expiration");
        this.expirationWithoutGracePeriod = this.getResponseProperty("ExpirationWithoutGracePeriod");
    }
}
class BillingCustomerDiscount extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.active = this.getResponseProperty("Active");
        this.percentOff = this.getResponseProperty("PercentOff");
        this.appliesTo = this.getResponseProperty("AppliesTo");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/api/permissions.api.ts

class PermissionsApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return this;
        }
        this.accessEventLogs = this.getResponseProperty("AccessEventLogs");
        this.accessImportExport = this.getResponseProperty("AccessImportExport");
        this.accessReports = this.getResponseProperty("AccessReports");
        this.createNewCollections = this.getResponseProperty("CreateNewCollections");
        this.editAnyCollection = this.getResponseProperty("EditAnyCollection");
        this.deleteAnyCollection = this.getResponseProperty("DeleteAnyCollection");
        this.editAssignedCollections = this.getResponseProperty("EditAssignedCollections");
        this.deleteAssignedCollections = this.getResponseProperty("DeleteAssignedCollections");
        this.manageCiphers = this.getResponseProperty("ManageCiphers");
        this.manageGroups = this.getResponseProperty("ManageGroups");
        this.manageSso = this.getResponseProperty("ManageSso");
        this.managePolicies = this.getResponseProperty("ManagePolicies");
        this.manageUsers = this.getResponseProperty("ManageUsers");
        this.manageResetPassword = this.getResponseProperty("ManageResetPassword");
        this.manageScim = this.getResponseProperty("ManageScim");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-organization.response.ts


class ProfileOrganizationResponse extends BaseResponse {
    constructor(response) {
        var _a, _b, _c, _d;
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.usePolicies = this.getResponseProperty("UsePolicies");
        this.useGroups = this.getResponseProperty("UseGroups");
        this.useDirectory = this.getResponseProperty("UseDirectory");
        this.useEvents = this.getResponseProperty("UseEvents");
        this.useTotp = this.getResponseProperty("UseTotp");
        this.use2fa = this.getResponseProperty("Use2fa");
        this.useApi = this.getResponseProperty("UseApi");
        this.useSso = this.getResponseProperty("UseSso");
        this.useKeyConnector = (_a = this.getResponseProperty("UseKeyConnector")) !== null && _a !== void 0 ? _a : false;
        this.useScim = (_b = this.getResponseProperty("UseScim")) !== null && _b !== void 0 ? _b : false;
        this.useCustomPermissions = (_c = this.getResponseProperty("UseCustomPermissions")) !== null && _c !== void 0 ? _c : false;
        this.useResetPassword = this.getResponseProperty("UseResetPassword");
        this.useSecretsManager = this.getResponseProperty("UseSecretsManager");
        this.usePasswordManager = this.getResponseProperty("UsePasswordManager");
        this.useActivateAutofillPolicy = this.getResponseProperty("UseActivateAutofillPolicy");
        this.selfHost = this.getResponseProperty("SelfHost");
        this.usersGetPremium = this.getResponseProperty("UsersGetPremium");
        this.seats = this.getResponseProperty("Seats");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.key = this.getResponseProperty("Key");
        this.hasPublicAndPrivateKeys = this.getResponseProperty("HasPublicAndPrivateKeys");
        this.status = this.getResponseProperty("Status");
        this.type = this.getResponseProperty("Type");
        this.enabled = this.getResponseProperty("Enabled");
        this.ssoBound = this.getResponseProperty("SsoBound");
        this.identifier = this.getResponseProperty("Identifier");
        this.permissions = new PermissionsApi(this.getResponseProperty("permissions"));
        this.resetPasswordEnrolled = this.getResponseProperty("ResetPasswordEnrolled");
        this.userId = this.getResponseProperty("UserId");
        this.providerId = this.getResponseProperty("ProviderId");
        this.providerName = this.getResponseProperty("ProviderName");
        this.providerType = this.getResponseProperty("ProviderType");
        this.familySponsorshipFriendlyName = this.getResponseProperty("FamilySponsorshipFriendlyName");
        this.familySponsorshipAvailable = this.getResponseProperty("FamilySponsorshipAvailable");
        this.planProductType = this.getResponseProperty("PlanProductType");
        this.keyConnectorEnabled = (_d = this.getResponseProperty("KeyConnectorEnabled")) !== null && _d !== void 0 ? _d : false;
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        const familySponsorshipLastSyncDateString = this.getResponseProperty("FamilySponsorshipLastSyncDate");
        if (familySponsorshipLastSyncDateString) {
            this.familySponsorshipLastSyncDate = new Date(familySponsorshipLastSyncDateString);
        }
        const familySponsorshipValidUntilString = this.getResponseProperty("FamilySponsorshipValidUntil");
        if (familySponsorshipValidUntilString) {
            this.familySponsorshipValidUntil = new Date(familySponsorshipValidUntilString);
        }
        this.familySponsorshipToDelete = this.getResponseProperty("FamilySponsorshipToDelete");
        this.accessSecretsManager = this.getResponseProperty("AccessSecretsManager");
        this.limitCollectionCreationDeletion = this.getResponseProperty("LimitCollectionCreationDeletion");
        this.allowAdminAccessToAllCollectionItems = this.getResponseProperty("AllowAdminAccessToAllCollectionItems");
        this.flexibleCollections = this.getResponseProperty("FlexibleCollections");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-provider-organization.response.ts

class ProfileProviderOrganizationResponse extends ProfileOrganizationResponse {
    constructor(response) {
        super(response);
        this.keyConnectorEnabled = false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-provider.response.ts


class ProfileProviderResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.key = this.getResponseProperty("Key");
        this.status = this.getResponseProperty("Status");
        this.type = this.getResponseProperty("Type");
        this.enabled = this.getResponseProperty("Enabled");
        this.permissions = new PermissionsApi(this.getResponseProperty("permissions"));
        this.userId = this.getResponseProperty("UserId");
        this.useEvents = this.getResponseProperty("UseEvents");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/profile.response.ts




class ProfileResponse extends BaseResponse {
    constructor(response) {
        var _a, _b;
        super(response);
        this.organizations = [];
        this.providers = [];
        this.providerOrganizations = [];
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.email = this.getResponseProperty("Email");
        this.emailVerified = this.getResponseProperty("EmailVerified");
        this.masterPasswordHint = this.getResponseProperty("MasterPasswordHint");
        this.premiumPersonally = this.getResponseProperty("Premium");
        this.premiumFromOrganization = this.getResponseProperty("PremiumFromOrganization");
        this.culture = this.getResponseProperty("Culture");
        this.twoFactorEnabled = this.getResponseProperty("TwoFactorEnabled");
        this.key = this.getResponseProperty("Key");
        this.avatarColor = this.getResponseProperty("AvatarColor");
        this.creationDate = this.getResponseProperty("CreationDate");
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.securityStamp = this.getResponseProperty("SecurityStamp");
        this.forcePasswordReset = (_a = this.getResponseProperty("ForcePasswordReset")) !== null && _a !== void 0 ? _a : false;
        this.usesKeyConnector = (_b = this.getResponseProperty("UsesKeyConnector")) !== null && _b !== void 0 ? _b : false;
        const organizations = this.getResponseProperty("Organizations");
        if (organizations != null) {
            this.organizations = organizations.map((o) => new ProfileOrganizationResponse(o));
        }
        const providers = this.getResponseProperty("Providers");
        if (providers != null) {
            this.providers = providers.map((o) => new ProfileProviderResponse(o));
        }
        const providerOrganizations = this.getResponseProperty("ProviderOrganizations");
        if (providerOrganizations != null) {
            this.providerOrganizations = providerOrganizations.map((o) => new ProfileProviderOrganizationResponse(o));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/payment.response.ts


class PaymentResponse extends BaseResponse {
    constructor(response) {
        super(response);
        const userProfile = this.getResponseProperty("UserProfile");
        if (userProfile != null) {
            this.userProfile = new ProfileResponse(userProfile);
        }
        this.paymentIntentClientSecret = this.getResponseProperty("PaymentIntentClientSecret");
        this.success = this.getResponseProperty("Success");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/tax-info.response.ts

class TaxInfoResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.taxId = this.getResponseProperty("TaxIdNumber");
        this.taxIdType = this.getResponseProperty("TaxIdType");
        this.line1 = this.getResponseProperty("Line1");
        this.line2 = this.getResponseProperty("Line2");
        this.city = this.getResponseProperty("City");
        this.state = this.getResponseProperty("State");
        this.postalCode = this.getResponseProperty("PostalCode");
        this.country = this.getResponseProperty("Country");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/list.response.ts

class ListResponse extends BaseResponse {
    constructor(response, t) {
        super(response);
        const data = this.getResponseProperty("Data");
        this.data = data == null ? [] : data.map((dr) => new t(dr));
        this.continuationToken = this.getResponseProperty("ContinuationToken");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-api-key-information.response.ts

class OrganizationApiKeyInformationResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.keyType = this.getResponseProperty("KeyType");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-auto-enroll-status.response.ts

class OrganizationAutoEnrollStatusResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.resetPasswordEnabled = this.getResponseProperty("ResetPasswordEnabled");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/keys.response.ts

class KeysResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.publicKey = this.getResponseProperty("PublicKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-keys.response.ts

class OrganizationKeysResponse extends KeysResponse {
    constructor(response) {
        super(response);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization/organization-api.service.ts
var organization_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












class OrganizationApiService {
    constructor(apiService, syncService) {
        this.apiService = apiService;
        this.syncService = syncService;
    }
    get(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id, null, true, true);
            return new OrganizationResponse(r);
        });
    }
    getBilling(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/billing", null, true, true);
            return new BillingResponse(r);
        });
    }
    getSubscription(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/subscription", null, true, true);
            return new OrganizationSubscriptionResponse(r);
        });
    }
    getLicense(id, installationId) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("GET", "/organizations/" + id + "/license?installationId=" + installationId, null, true, true);
        });
    }
    getAutoEnrollStatus(identifier) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + identifier + "/auto-enroll-status", null, true, true);
            return new OrganizationAutoEnrollStatusResponse(r);
        });
    }
    create(request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations", request, true, true);
            // Forcing a sync will notify organization service that they need to repull
            yield this.syncService.fullSync(true);
            return new OrganizationResponse(r);
        });
    }
    createLicense(data) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/licenses/self-hosted", data, true, true);
            return new OrganizationResponse(r);
        });
    }
    save(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + id, request, true, true);
            const data = new OrganizationResponse(r);
            yield this.syncService.fullSync(true);
            return data;
        });
    }
    updatePayment(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/payment", request, true, false);
        });
    }
    upgrade(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/upgrade", request, true, true);
            return new PaymentResponse(r);
        });
    }
    updatePasswordManagerSeats(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/subscription", request, true, false);
        });
    }
    updateSecretsManagerSubscription(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/sm-subscription", request, true, false);
        });
    }
    updateSeats(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/seat", request, true, true);
            return new PaymentResponse(r);
        });
    }
    updateStorage(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/storage", request, true, true);
            return new PaymentResponse(r);
        });
    }
    verifyBank(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/verify-bank", request, true, false);
        });
    }
    reinstate(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/reinstate", null, true, false);
        });
    }
    leave(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/leave", null, true, false);
            yield this.syncService.fullSync(true);
        });
    }
    delete(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("DELETE", "/organizations/" + id, request, true, false);
            yield this.syncService.fullSync(true);
        });
    }
    updateLicense(id, data) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/licenses/self-hosted/" + id, data, true, false);
        });
    }
    importDirectory(organizationId, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + organizationId + "/import", request, true, false);
        });
    }
    getOrCreateApiKey(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/api-key", request, true, true);
            return new ApiKeyResponse(r);
        });
    }
    getApiKeyInformation(id, organizationApiKeyType = null) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const uri = organizationApiKeyType === null
                ? "/organizations/" + id + "/api-key-information"
                : "/organizations/" + id + "/api-key-information/" + organizationApiKeyType;
            const r = yield this.apiService.send("GET", uri, null, true, true);
            return new ListResponse(r, OrganizationApiKeyInformationResponse);
        });
    }
    rotateApiKey(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/rotate-api-key", request, true, true);
            return new ApiKeyResponse(r);
        });
    }
    getTaxInfo(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/tax", null, true, true);
            return new TaxInfoResponse(r);
        });
    }
    updateTaxInfo(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            // Can't broadcast anything because the response doesn't have content
            return this.apiService.send("PUT", "/organizations/" + id + "/tax", request, true, false);
        });
    }
    getKeys(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/keys", null, true, true);
            return new OrganizationKeysResponse(r);
        });
    }
    updateKeys(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/keys", request, true, true);
            // Not broadcasting anything because data on this response doesn't correspond to `Organization`
            return new OrganizationKeysResponse(r);
        });
    }
    getSso(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/sso", null, true, true);
            return new OrganizationSsoResponse(r);
        });
    }
    updateSso(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/sso", request, true, true);
            // Not broadcasting anything because data on this response doesn't correspond to `Organization`
            return new OrganizationSsoResponse(r);
        });
    }
    selfHostedSyncLicense(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/licenses/self-hosted/" + id + "/sync/", null, true, false);
        });
    }
    subscribeToSecretsManager(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/subscribe-secrets-manager", request, true, true);
            return new ProfileOrganizationResponse(r);
        });
    }
    updateCollectionManagement(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + id + "/collection-management", request, true, true);
            const data = new OrganizationResponse(r);
            yield this.syncService.fullSync(true);
            return data;
        });
    }
    enableCollectionEnhancements(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/enable-collection-enhancements", null, true, false);
            yield this.syncService.fullSync(true);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/data/organization.data.ts
class OrganizationData {
    constructor(response, options) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.name = response.name;
        this.status = response.status;
        this.type = response.type;
        this.enabled = response.enabled;
        this.usePolicies = response.usePolicies;
        this.useGroups = response.useGroups;
        this.useDirectory = response.useDirectory;
        this.useEvents = response.useEvents;
        this.useTotp = response.useTotp;
        this.use2fa = response.use2fa;
        this.useApi = response.useApi;
        this.useSso = response.useSso;
        this.useKeyConnector = response.useKeyConnector;
        this.useScim = response.useScim;
        this.useCustomPermissions = response.useCustomPermissions;
        this.useResetPassword = response.useResetPassword;
        this.useSecretsManager = response.useSecretsManager;
        this.usePasswordManager = response.usePasswordManager;
        this.useActivateAutofillPolicy = response.useActivateAutofillPolicy;
        this.selfHost = response.selfHost;
        this.usersGetPremium = response.usersGetPremium;
        this.seats = response.seats;
        this.maxCollections = response.maxCollections;
        this.maxStorageGb = response.maxStorageGb;
        this.ssoBound = response.ssoBound;
        this.identifier = response.identifier;
        this.permissions = response.permissions;
        this.resetPasswordEnrolled = response.resetPasswordEnrolled;
        this.userId = response.userId;
        this.hasPublicAndPrivateKeys = response.hasPublicAndPrivateKeys;
        this.providerId = response.providerId;
        this.providerName = response.providerName;
        this.providerType = response.providerType;
        this.familySponsorshipFriendlyName = response.familySponsorshipFriendlyName;
        this.familySponsorshipAvailable = response.familySponsorshipAvailable;
        this.planProductType = response.planProductType;
        this.keyConnectorEnabled = response.keyConnectorEnabled;
        this.keyConnectorUrl = response.keyConnectorUrl;
        this.familySponsorshipLastSyncDate = response.familySponsorshipLastSyncDate;
        this.familySponsorshipValidUntil = response.familySponsorshipValidUntil;
        this.familySponsorshipToDelete = response.familySponsorshipToDelete;
        this.accessSecretsManager = response.accessSecretsManager;
        this.limitCollectionCreationDeletion = response.limitCollectionCreationDeletion;
        this.allowAdminAccessToAllCollectionItems = response.allowAdminAccessToAllCollectionItems;
        this.flexibleCollections = response.flexibleCollections;
        this.isMember = options.isMember;
        this.isProviderUser = options.isProviderUser;
    }
    static fromJSON(obj) {
        return Object.assign(new OrganizationData(), obj, {
            familySponsorshipLastSyncDate: obj.familySponsorshipLastSyncDate != null
                ? new Date(obj.familySponsorshipLastSyncDate)
                : obj.familySponsorshipLastSyncDate,
            familySponsorshipValidUntil: obj.familySponsorshipValidUntil != null
                ? new Date(obj.familySponsorshipValidUntil)
                : obj.familySponsorshipValidUntil,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-api-key-type.enum.ts
var OrganizationApiKeyType;
(function (OrganizationApiKeyType) {
    OrganizationApiKeyType[OrganizationApiKeyType["Default"] = 0] = "Default";
    OrganizationApiKeyType[OrganizationApiKeyType["BillingSync"] = 1] = "BillingSync";
    OrganizationApiKeyType[OrganizationApiKeyType["Scim"] = 2] = "Scim";
})(OrganizationApiKeyType || (OrganizationApiKeyType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-connection-type.enum.ts
var OrganizationConnectionType;
(function (OrganizationConnectionType) {
    OrganizationConnectionType[OrganizationConnectionType["CloudBillingSync"] = 1] = "CloudBillingSync";
    OrganizationConnectionType[OrganizationConnectionType["Scim"] = 2] = "Scim";
})(OrganizationConnectionType || (OrganizationConnectionType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-user-status-type.enum.ts
var OrganizationUserStatusType;
(function (OrganizationUserStatusType) {
    OrganizationUserStatusType[OrganizationUserStatusType["Invited"] = 0] = "Invited";
    OrganizationUserStatusType[OrganizationUserStatusType["Accepted"] = 1] = "Accepted";
    OrganizationUserStatusType[OrganizationUserStatusType["Confirmed"] = 2] = "Confirmed";
    OrganizationUserStatusType[OrganizationUserStatusType["Revoked"] = -1] = "Revoked";
})(OrganizationUserStatusType || (OrganizationUserStatusType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-user-type.enum.ts
var OrganizationUserType;
(function (OrganizationUserType) {
    OrganizationUserType[OrganizationUserType["Owner"] = 0] = "Owner";
    OrganizationUserType[OrganizationUserType["Admin"] = 1] = "Admin";
    OrganizationUserType[OrganizationUserType["User"] = 2] = "User";
    /**
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     */
    OrganizationUserType[OrganizationUserType["Manager"] = 3] = "Manager";
    OrganizationUserType[OrganizationUserType["Custom"] = 4] = "Custom";
})(OrganizationUserType || (OrganizationUserType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/policy-type.enum.ts
var policy_type_enum_PolicyType;
(function (PolicyType) {
    PolicyType[PolicyType["TwoFactorAuthentication"] = 0] = "TwoFactorAuthentication";
    PolicyType[PolicyType["MasterPassword"] = 1] = "MasterPassword";
    PolicyType[PolicyType["PasswordGenerator"] = 2] = "PasswordGenerator";
    PolicyType[PolicyType["SingleOrg"] = 3] = "SingleOrg";
    PolicyType[PolicyType["RequireSso"] = 4] = "RequireSso";
    PolicyType[PolicyType["PersonalOwnership"] = 5] = "PersonalOwnership";
    PolicyType[PolicyType["DisableSend"] = 6] = "DisableSend";
    PolicyType[PolicyType["SendOptions"] = 7] = "SendOptions";
    PolicyType[PolicyType["ResetPassword"] = 8] = "ResetPassword";
    PolicyType[PolicyType["MaximumVaultTimeout"] = 9] = "MaximumVaultTimeout";
    PolicyType[PolicyType["DisablePersonalVaultExport"] = 10] = "DisablePersonalVaultExport";
    PolicyType[PolicyType["ActivateAutofill"] = 11] = "ActivateAutofill";
})(policy_type_enum_PolicyType || (policy_type_enum_PolicyType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-type.enum.ts
var ProviderType;
(function (ProviderType) {
    ProviderType[ProviderType["Msp"] = 0] = "Msp";
    ProviderType[ProviderType["Reseller"] = 1] = "Reseller";
})(ProviderType || (ProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-user-status-type.enum.ts
var ProviderUserStatusType;
(function (ProviderUserStatusType) {
    ProviderUserStatusType[ProviderUserStatusType["Invited"] = 0] = "Invited";
    ProviderUserStatusType[ProviderUserStatusType["Accepted"] = 1] = "Accepted";
    ProviderUserStatusType[ProviderUserStatusType["Confirmed"] = 2] = "Confirmed";
    ProviderUserStatusType[ProviderUserStatusType["Revoked"] = -1] = "Revoked";
})(ProviderUserStatusType || (ProviderUserStatusType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-user-type.enum.ts
var ProviderUserType;
(function (ProviderUserType) {
    ProviderUserType[ProviderUserType["ProviderAdmin"] = 0] = "ProviderAdmin";
    ProviderUserType[ProviderUserType["ServiceUser"] = 1] = "ServiceUser";
})(ProviderUserType || (ProviderUserType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/scim-provider-type.enum.ts
var ScimProviderType;
(function (ScimProviderType) {
    ScimProviderType[ScimProviderType["Default"] = 0] = "Default";
    ScimProviderType[ScimProviderType["AzureAd"] = 1] = "AzureAd";
    ScimProviderType[ScimProviderType["Okta"] = 2] = "Okta";
    ScimProviderType[ScimProviderType["OneLogin"] = 3] = "OneLogin";
    ScimProviderType[ScimProviderType["JumpCloud"] = 4] = "JumpCloud";
    ScimProviderType[ScimProviderType["GoogleWorkspace"] = 5] = "GoogleWorkspace";
    ScimProviderType[ScimProviderType["Rippling"] = 6] = "Rippling";
})(ScimProviderType || (ScimProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/index.ts










;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/organization.ts

class Organization {
    constructor(obj) {
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.name = obj.name;
        this.status = obj.status;
        this.type = obj.type;
        this.enabled = obj.enabled;
        this.usePolicies = obj.usePolicies;
        this.useGroups = obj.useGroups;
        this.useDirectory = obj.useDirectory;
        this.useEvents = obj.useEvents;
        this.useTotp = obj.useTotp;
        this.use2fa = obj.use2fa;
        this.useApi = obj.useApi;
        this.useSso = obj.useSso;
        this.useKeyConnector = obj.useKeyConnector;
        this.useScim = obj.useScim;
        this.useCustomPermissions = obj.useCustomPermissions;
        this.useResetPassword = obj.useResetPassword;
        this.useSecretsManager = obj.useSecretsManager;
        this.usePasswordManager = obj.usePasswordManager;
        this.useActivateAutofillPolicy = obj.useActivateAutofillPolicy;
        this.selfHost = obj.selfHost;
        this.usersGetPremium = obj.usersGetPremium;
        this.seats = obj.seats;
        this.maxCollections = obj.maxCollections;
        this.maxStorageGb = obj.maxStorageGb;
        this.ssoBound = obj.ssoBound;
        this.identifier = obj.identifier;
        this.permissions = obj.permissions;
        this.resetPasswordEnrolled = obj.resetPasswordEnrolled;
        this.userId = obj.userId;
        this.hasPublicAndPrivateKeys = obj.hasPublicAndPrivateKeys;
        this.providerId = obj.providerId;
        this.providerName = obj.providerName;
        this.providerType = obj.providerType;
        this.isProviderUser = obj.isProviderUser;
        this.isMember = obj.isMember;
        this.familySponsorshipFriendlyName = obj.familySponsorshipFriendlyName;
        this.familySponsorshipAvailable = obj.familySponsorshipAvailable;
        this.planProductType = obj.planProductType;
        this.keyConnectorEnabled = obj.keyConnectorEnabled;
        this.keyConnectorUrl = obj.keyConnectorUrl;
        this.familySponsorshipLastSyncDate = obj.familySponsorshipLastSyncDate;
        this.familySponsorshipValidUntil = obj.familySponsorshipValidUntil;
        this.familySponsorshipToDelete = obj.familySponsorshipToDelete;
        this.accessSecretsManager = obj.accessSecretsManager;
        this.limitCollectionCreationDeletion = obj.limitCollectionCreationDeletion;
        this.allowAdminAccessToAllCollectionItems = obj.allowAdminAccessToAllCollectionItems;
        this.flexibleCollections = obj.flexibleCollections;
    }
    get canAccess() {
        if (this.isOwner) {
            return true;
        }
        return this.enabled && this.status === OrganizationUserStatusType.Confirmed;
    }
    /**
     * Whether a user has Manager permissions or greater
     *
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     */
    get isManager() {
        return this.type === OrganizationUserType.Manager || this.isAdmin;
    }
    /**
     * Whether a user has Admin permissions or greater
     */
    get isAdmin() {
        return this.type === OrganizationUserType.Admin || this.isOwner;
    }
    /**
     * Whether a user has Owner permissions (including ProviderUsers)
     */
    get isOwner() {
        return this.type === OrganizationUserType.Owner || this.isProviderUser;
    }
    get canAccessEventLogs() {
        return (this.isAdmin || this.permissions.accessEventLogs) && this.useEvents;
    }
    get canAccessImportExport() {
        return this.isAdmin || this.permissions.accessImportExport;
    }
    get canAccessReports() {
        return this.isAdmin || this.permissions.accessReports;
    }
    get canCreateNewCollections() {
        if (this.flexibleCollections) {
            return (!this.limitCollectionCreationDeletion ||
                this.isAdmin ||
                this.permissions.createNewCollections);
        }
        return this.isManager || this.permissions.createNewCollections;
    }
    canEditAnyCollection(flexibleCollectionsV1Enabled) {
        if (!this.flexibleCollections || !flexibleCollectionsV1Enabled) {
            // Pre-Flexible Collections v1 logic
            return this.isAdmin || this.permissions.editAnyCollection;
        }
        // Post Flexible Collections V1, the allowAdminAccessToAllCollectionItems flag can restrict admins
        // Providers and custom users with canEditAnyCollection are not affected by allowAdminAccessToAllCollectionItems flag
        return (this.isProviderUser ||
            (this.type === OrganizationUserType.Custom && this.permissions.editAnyCollection) ||
            (this.allowAdminAccessToAllCollectionItems && this.isAdmin));
    }
    canEditUnassignedCiphers() {
        // TODO: Update this to exclude Providers if provider access is restricted in AC-1707
        return this.isAdmin || this.permissions.editAnyCollection;
    }
    canEditAllCiphers(flexibleCollectionsV1Enabled) {
        // Before Flexible Collections, any admin or anyone with editAnyCollection permission could edit all ciphers
        if (!this.flexibleCollections || !flexibleCollectionsV1Enabled) {
            return this.isAdmin || this.permissions.editAnyCollection;
        }
        // Post Flexible Collections V1, the allowAdminAccessToAllCollectionItems flag can restrict admins
        // Providers and custom users with canEditAnyCollection are not affected by allowAdminAccessToAllCollectionItems flag
        return (this.isProviderUser ||
            (this.type === OrganizationUserType.Custom && this.permissions.editAnyCollection) ||
            (this.allowAdminAccessToAllCollectionItems && this.isAdmin));
    }
    get canDeleteAnyCollection() {
        return this.isAdmin || this.permissions.deleteAnyCollection;
    }
    /**
     * Whether the user can view all collection information, such as collection name and access.
     * This does not indicate that the user can view items inside any collection - for that, see {@link canEditAllCiphers}
     */
    get canViewAllCollections() {
        // Admins can always see all collections even if collection management settings prevent them from editing them or seeing items
        return this.isAdmin || this.permissions.editAnyCollection || this.canDeleteAnyCollection;
    }
    /**
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     * This will always return false if FlexibleCollections flag is on.
     */
    get canEditAssignedCollections() {
        return this.isManager || this.permissions.editAssignedCollections;
    }
    /**
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     * This will always return false if FlexibleCollections flag is on.
     */
    get canDeleteAssignedCollections() {
        return this.isManager || this.permissions.deleteAssignedCollections;
    }
    /**
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     * This will always return false if FlexibleCollections flag is on.
     */
    get canViewAssignedCollections() {
        return this.canDeleteAssignedCollections || this.canEditAssignedCollections;
    }
    get canManageGroups() {
        return (this.isAdmin || this.permissions.manageGroups) && this.useGroups;
    }
    get canManageSso() {
        return (this.isAdmin || this.permissions.manageSso) && this.useSso;
    }
    get canManageDomainVerification() {
        return (this.isAdmin || this.permissions.manageSso) && this.useSso;
    }
    get canManageScim() {
        return (this.isAdmin || this.permissions.manageScim) && this.useScim;
    }
    get canManagePolicies() {
        return (this.isAdmin || this.permissions.managePolicies) && this.usePolicies;
    }
    get canManageUsers() {
        return this.isAdmin || this.permissions.manageUsers;
    }
    get canManageUsersPassword() {
        return this.isAdmin || this.permissions.manageResetPassword;
    }
    get canManageDeviceApprovals() {
        return (this.isAdmin || this.permissions.manageResetPassword) && this.useSso;
    }
    get isExemptFromPolicies() {
        return this.canManagePolicies;
    }
    get canViewSubscription() {
        if (this.canEditSubscription) {
            return true;
        }
        return this.hasProvider && this.providerType === ProviderType.Msp
            ? this.isProviderUser
            : this.isOwner;
    }
    get canEditSubscription() {
        return this.hasProvider ? this.isProviderUser : this.isOwner;
    }
    get canEditPaymentMethods() {
        return this.canEditSubscription;
    }
    get canViewBillingHistory() {
        return this.canEditSubscription;
    }
    get hasProvider() {
        return this.providerId != null || this.providerName != null;
    }
    get hasReseller() {
        return this.hasProvider && this.providerType === ProviderType.Reseller;
    }
    get canAccessSecretsManager() {
        return this.useSecretsManager && this.accessSecretsManager;
    }
    get isFreeOrg() {
        // return true if organization needs to be upgraded from a free org
        return !this.useTotp;
    }
    get canManageSponsorships() {
        return this.familySponsorshipAvailable || this.familySponsorshipFriendlyName !== null;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new Organization(), json, {
            familySponsorshipLastSyncDate: new Date(json.familySponsorshipLastSyncDate),
            familySponsorshipValidUntil: new Date(json.familySponsorshipValidUntil),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization/organization.service.ts
var organization_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




/**
 * The `KeyDefinition` for accessing organization lists in application state.
 * @todo Ideally this wouldn't require a `fromJSON()` call, but `OrganizationData`
 * has some properties that contain functions. This should probably get
 * cleaned up.
 */
const ORGANIZATIONS = UserKeyDefinition.record(ORGANIZATIONS_DISK, "organizations", {
    deserializer: (obj) => OrganizationData.fromJSON(obj),
    clearOn: ["logout"],
});
/**
 * Filter out organizations from an observable that __do not__ offer a
 * families-for-enterprise sponsorship to members.
 * @returns a function that can be used in `Observable<Organization[]>` pipes,
 * like `organizationService.organizations$`
 */
function mapToExcludeOrganizationsWithoutFamilySponsorshipSupport() {
    return (0,external_rxjs_namespaceObject.map)((orgs) => orgs.filter((o) => o.canManageSponsorships));
}
/**
 * Filter out organizations from an observable that the organization user
 * __is not__ a direct member of. This will exclude organizations only
 * accessible as a provider.
 * @returns a function that can be used in `Observable<Organization[]>` pipes,
 * like `organizationService.organizations$`
 */
function mapToExcludeProviderOrganizations() {
    return (0,external_rxjs_namespaceObject.map)((orgs) => orgs.filter((o) => o.isMember));
}
/**
 * Map an observable stream of organizations down to a boolean indicating
 * if any organizations exist (`orgs.length > 0`).
 * @returns a function that can be used in `Observable<Organization[]>` pipes,
 * like `organizationService.organizations$`
 */
function mapToBooleanHasAnyOrganizations() {
    return (0,external_rxjs_namespaceObject.map)((orgs) => orgs.length > 0);
}
/**
 * Map an observable stream of organizations down to a single organization.
 * @param `organizationId` The ID of the organization you'd like to subscribe to
 * @returns a function that can be used in `Observable<Organization[]>` pipes,
 * like `organizationService.organizations$`
 */
function mapToSingleOrganization(organizationId) {
    return (0,external_rxjs_namespaceObject.map)((orgs) => orgs === null || orgs === void 0 ? void 0 : orgs.find((o) => o.id === organizationId));
}
class OrganizationService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
        this.organizations$ = this.getOrganizationsFromState$();
        this.memberOrganizations$ = this.organizations$.pipe(mapToExcludeProviderOrganizations());
        this.canManageSponsorships$ = this.organizations$.pipe(mapToExcludeOrganizationsWithoutFamilySponsorshipSupport(), mapToBooleanHasAnyOrganizations());
    }
    get$(id) {
        return this.organizations$.pipe(mapToSingleOrganization(id));
    }
    getAll$(userId) {
        return this.getOrganizationsFromState$(userId);
    }
    getAll(userId) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.getOrganizationsFromState$(userId));
        });
    }
    hasOrganizations() {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizations$.pipe(mapToBooleanHasAnyOrganizations()));
        });
    }
    upsert(organization, userId) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateFor(userId).update((existingOrganizations) => {
                const organizations = existingOrganizations !== null && existingOrganizations !== void 0 ? existingOrganizations : {};
                organizations[organization.id] = organization;
                return organizations;
            });
        });
    }
    get(id) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizations$.pipe(mapToSingleOrganization(id)));
        });
    }
    /**
     * @deprecated For the CLI only
     * @param id id of the organization
     */
    getFromState(id) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.organizations$.pipe(mapToSingleOrganization(id)));
        });
    }
    replace(organizations, userId) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateFor(userId).update(() => organizations);
        });
    }
    // Ideally this method would be renamed to organizations$() and the
    // $organizations observable as it stands would be removed. This will
    // require updates to callers, and so this method exists as a temporary
    // workaround until we have time & a plan to update callers.
    //
    // It can be thought of as "organizations$ but with a userId option".
    getOrganizationsFromState$(userId) {
        return this.stateFor(userId).state$.pipe(this.mapOrganizationRecordToArray());
    }
    /**
     * Accepts a record of `OrganizationData`, which is how we store the
     * organization list as a JSON object on disk, to an array of
     * `Organization`, which is how the data is published to callers of the
     * service.
     * @returns a function that can be used to pipe organization data from
     * stored state to an exposed object easily consumable by others.
     */
    mapOrganizationRecordToArray() {
        return (0,external_rxjs_namespaceObject.map)((orgs) => { var _a; return (_a = Object.values(orgs !== null && orgs !== void 0 ? orgs : {})) === null || _a === void 0 ? void 0 : _a.map((o) => new Organization(o)); });
    }
    /**
     * Fetches the organization list from on disk state for the specified user.
     * @param userId the user ID to fetch the organization list for. Defaults to
     * the currently active user.
     * @returns an observable of organization state as it is stored on disk.
     */
    stateFor(userId) {
        return userId
            ? this.stateProvider.getUser(userId, ORGANIZATIONS)
            : this.stateProvider.getActive(ORGANIZATIONS);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/selection-read-only.response.ts

class SelectionReadOnlyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.readOnly = this.getResponseProperty("ReadOnly");
        this.hidePasswords = this.getResponseProperty("HidePasswords");
        this.manage = this.getResponseProperty("Manage");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization-user/responses/organization-user.response.ts



class OrganizationUserResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.collections = [];
        this.groups = [];
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.type = this.getResponseProperty("Type");
        this.status = this.getResponseProperty("Status");
        this.permissions = new PermissionsApi(this.getResponseProperty("Permissions"));
        this.externalId = this.getResponseProperty("ExternalId");
        this.accessAll = this.getResponseProperty("AccessAll");
        this.accessSecretsManager = this.getResponseProperty("AccessSecretsManager");
        this.resetPasswordEnrolled = this.getResponseProperty("ResetPasswordEnrolled");
        this.hasMasterPassword = this.getResponseProperty("HasMasterPassword");
        const collections = this.getResponseProperty("Collections");
        if (collections != null) {
            this.collections = collections.map((c) => new SelectionReadOnlyResponse(c));
        }
        const groups = this.getResponseProperty("Groups");
        if (groups != null) {
            this.groups = groups;
        }
    }
}
class OrganizationUserUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        var _a;
        super(response);
        this.name = this.getResponseProperty("Name");
        this.email = this.getResponseProperty("Email");
        this.avatarColor = this.getResponseProperty("AvatarColor");
        this.twoFactorEnabled = this.getResponseProperty("TwoFactorEnabled");
        this.usesKeyConnector = (_a = this.getResponseProperty("UsesKeyConnector")) !== null && _a !== void 0 ? _a : false;
    }
}
class OrganizationUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        super(response);
    }
}
class OrganizationUserResetPasswordDetailsResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.kdf = this.getResponseProperty("Kdf");
        this.kdfIterations = this.getResponseProperty("KdfIterations");
        this.kdfMemory = this.getResponseProperty("KdfMemory");
        this.kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.resetPasswordKey = this.getResponseProperty("ResetPasswordKey");
        this.encryptedPrivateKey = this.getResponseProperty("EncryptedPrivateKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization-user/responses/organization-user-bulk.response.ts

class OrganizationUserBulkResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.error = this.getResponseProperty("Error");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization-user/responses/organization-user-bulk-public-key.response.ts

class OrganizationUserBulkPublicKeyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.key = this.getResponseProperty("Key");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization-user/requests/organization-user-bulk.request.ts
class OrganizationUserBulkRequest {
    constructor(ids) {
        this.ids = ids == null ? [] : ids;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization-user/organization-user.service.implementation.ts
var organization_user_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class OrganizationUserServiceImplementation {
    constructor(apiService) {
        this.apiService = apiService;
    }
    getOrganizationUser(organizationId, id, options) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users/${id}?${params.toString()}`, null, true, true);
            return new OrganizationUserDetailsResponse(r);
        });
    }
    getOrganizationUserGroups(organizationId, id) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/users/" + id + "/groups", null, true, true);
            return r;
        });
    }
    getAllUsers(organizationId, options) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeCollections) {
                params.set("includeCollections", "true");
            }
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users?${params.toString()}`, null, true, true);
            return new ListResponse(r, OrganizationUserUserDetailsResponse);
        });
    }
    getOrganizationUserResetPasswordDetails(organizationId, id) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/users/" + id + "/reset-password-details", null, true, true);
            return new OrganizationUserResetPasswordDetailsResponse(r);
        });
    }
    postOrganizationUserInvite(organizationId, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/invite", request, true, false);
    }
    postOrganizationUserReinvite(organizationId, id) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/reinvite", null, true, false);
    }
    postManyOrganizationUserReinvite(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/reinvite", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    postOrganizationUserAcceptInit(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept-init", request, true, false);
    }
    postOrganizationUserAccept(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept", request, true, false);
    }
    postOrganizationUserConfirm(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/confirm", request, true, false);
    }
    postOrganizationUsersPublicKey(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/public-keys", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkPublicKeyResponse);
        });
    }
    postOrganizationUserBulkConfirm(organizationId, request) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/confirm", request, true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    putOrganizationUserBulkEnableSecretsManager(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/enable-secrets-manager", new OrganizationUserBulkRequest(ids), true, false);
        });
    }
    putOrganizationUser(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id, request, true, false);
    }
    putOrganizationUserResetPasswordEnrollment(organizationId, userId, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + userId + "/reset-password-enrollment", request, true, false);
    }
    putOrganizationUserResetPassword(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/reset-password", request, true, false);
    }
    deleteOrganizationUser(organizationId, id) {
        return this.apiService.send("DELETE", "/organizations/" + organizationId + "/users/" + id, null, true, false);
    }
    deleteManyOrganizationUsers(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("DELETE", "/organizations/" + organizationId + "/users", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    revokeOrganizationUser(organizationId, id) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/revoke", null, true, false);
    }
    revokeManyOrganizationUsers(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/revoke", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    restoreOrganizationUser(organizationId, id) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/restore", null, true, false);
    }
    restoreManyOrganizationUsers(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/restore", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/data/policy.data.ts
class PolicyData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.type = response.type;
        this.data = response.data;
        this.enabled = response.enabled;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/policy.ts


class Policy extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.organizationId = obj.organizationId;
        this.type = obj.type;
        this.data = obj.data;
        this.enabled = obj.enabled;
    }
    static fromResponse(response) {
        return new Policy(new PolicyData(response));
    }
    static fromListResponse(response) {
        var _a, _b;
        return (_b = (_a = response.data) === null || _a === void 0 ? void 0 : _a.map((d) => Policy.fromResponse(d))) !== null && _b !== void 0 ? _b : undefined;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/policy.response.ts

class PolicyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.organizationId = this.getResponseProperty("OrganizationId");
        this.type = this.getResponseProperty("Type");
        this.data = this.getResponseProperty("Data");
        this.enabled = this.getResponseProperty("Enabled");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/policy/policy-api.service.ts
var policy_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








class PolicyApiService {
    constructor(policyService, apiService) {
        this.policyService = policyService;
        this.apiService = apiService;
    }
    getPolicy(organizationId, type) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/policies/" + type, null, true, true);
            return new PolicyResponse(r);
        });
    }
    getPolicies(organizationId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/policies", null, true, true);
            return new ListResponse(r, PolicyResponse);
        });
    }
    getPoliciesByToken(organizationId, token, email, organizationUserId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" +
                organizationId +
                "/policies/token?" +
                "token=" +
                encodeURIComponent(token) +
                "&email=" +
                Utils.encodeRFC3986URIComponent(email) +
                "&organizationUserId=" +
                organizationUserId, null, false, true);
            return new ListResponse(r, PolicyResponse);
        });
    }
    getMasterPasswordPolicyResponseForOrgUser(organizationId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const response = yield this.apiService.send("GET", "/organizations/" + organizationId + "/policies/master-password", null, true, true);
            return new PolicyResponse(response);
        });
    }
    getMasterPasswordPolicyOptsForOrgUser(orgId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            try {
                const masterPasswordPolicyResponse = yield this.getMasterPasswordPolicyResponseForOrgUser(orgId);
                const masterPasswordPolicy = Policy.fromResponse(masterPasswordPolicyResponse);
                if (!masterPasswordPolicy) {
                    return null;
                }
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.policyService.masterPasswordPolicyOptions$([masterPasswordPolicy]));
            }
            catch (error) {
                // If policy not found, return null
                if (error instanceof ErrorResponse && error.statusCode === HttpStatusCode.NotFound) {
                    return null;
                }
                // otherwise rethrow error
                throw error;
            }
        });
    }
    putPolicy(organizationId, type, request) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/policies/" + type, request, true, true);
            const response = new PolicyResponse(r);
            const data = new PolicyData(response);
            yield this.policyService.upsert(data);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/reset-password-policy-options.ts

class ResetPasswordPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        this.autoEnrollEnabled = false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/policy/policy.service.ts
var policy_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






const policyRecordToArray = (policiesMap) => Object.values(policiesMap || {}).map((f) => new Policy(f));
const POLICIES = UserKeyDefinition.record(POLICIES_DISK, "policies", {
    deserializer: (policyData) => policyData,
    clearOn: ["logout"],
});
class PolicyService {
    constructor(stateProvider, organizationService) {
        this.stateProvider = stateProvider;
        this.organizationService = organizationService;
        this.activeUserPolicyState = this.stateProvider.getActive(POLICIES);
        this.activeUserPolicies$ = this.activeUserPolicyState.state$.pipe((0,external_rxjs_namespaceObject.map)((policyData) => policyRecordToArray(policyData)));
        this.policies$ = this.activeUserPolicies$;
    }
    get$(policyType) {
        const filteredPolicies$ = this.activeUserPolicies$.pipe((0,external_rxjs_namespaceObject.map)((policies) => policies.filter((p) => p.type === policyType)));
        return (0,external_rxjs_namespaceObject.combineLatest)([filteredPolicies$, this.organizationService.organizations$]).pipe((0,external_rxjs_namespaceObject.map)(([policies, organizations]) => { var _a, _b; return (_b = (_a = this.enforcedPolicyFilter(policies, organizations)) === null || _a === void 0 ? void 0 : _a.at(0)) !== null && _b !== void 0 ? _b : null; }));
    }
    getAll$(policyType, userId) {
        const filteredPolicies$ = this.stateProvider.getUserState$(POLICIES, userId).pipe((0,external_rxjs_namespaceObject.map)((policyData) => policyRecordToArray(policyData)), (0,external_rxjs_namespaceObject.map)((policies) => policies.filter((p) => p.type === policyType)));
        return (0,external_rxjs_namespaceObject.combineLatest)([filteredPolicies$, this.organizationService.getAll$(userId)]).pipe((0,external_rxjs_namespaceObject.map)(([policies, organizations]) => this.enforcedPolicyFilter(policies, organizations)));
    }
    getAll(policyType) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.policies$.pipe((0,external_rxjs_namespaceObject.map)((policies) => policies.filter((p) => p.type === policyType))));
        });
    }
    policyAppliesToActiveUser$(policyType) {
        return this.get$(policyType).pipe((0,external_rxjs_namespaceObject.map)((policy) => policy != null));
    }
    policyAppliesToUser(policyType) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.policyAppliesToActiveUser$(policyType));
        });
    }
    enforcedPolicyFilter(policies, organizations) {
        const orgDict = Object.fromEntries(organizations.map((o) => [o.id, o]));
        return policies.filter((policy) => {
            const organization = orgDict[policy.organizationId];
            // This shouldn't happen, i.e. the user should only have policies for orgs they are a member of
            // But if it does, err on the side of enforcing the policy
            if (organization == null) {
                return true;
            }
            return (policy.enabled &&
                organization.status >= OrganizationUserStatusType.Accepted &&
                organization.usePolicies &&
                !this.isExemptFromPolicy(policy.type, organization));
        });
    }
    masterPasswordPolicyOptions$(policies) {
        const observable = policies ? (0,external_rxjs_namespaceObject.of)(policies) : this.policies$;
        return observable.pipe((0,external_rxjs_namespaceObject.map)((obsPolicies) => {
            let enforcedOptions = null;
            const filteredPolicies = obsPolicies.filter((p) => p.type === policy_type_enum_PolicyType.MasterPassword);
            if (filteredPolicies == null || filteredPolicies.length === 0) {
                return enforcedOptions;
            }
            filteredPolicies.forEach((currentPolicy) => {
                if (!currentPolicy.enabled || currentPolicy.data == null) {
                    return;
                }
                if (enforcedOptions == null) {
                    enforcedOptions = new MasterPasswordPolicyOptions();
                }
                if (currentPolicy.data.minComplexity != null &&
                    currentPolicy.data.minComplexity > enforcedOptions.minComplexity) {
                    enforcedOptions.minComplexity = currentPolicy.data.minComplexity;
                }
                if (currentPolicy.data.minLength != null &&
                    currentPolicy.data.minLength > enforcedOptions.minLength) {
                    enforcedOptions.minLength = currentPolicy.data.minLength;
                }
                if (currentPolicy.data.requireUpper) {
                    enforcedOptions.requireUpper = true;
                }
                if (currentPolicy.data.requireLower) {
                    enforcedOptions.requireLower = true;
                }
                if (currentPolicy.data.requireNumbers) {
                    enforcedOptions.requireNumbers = true;
                }
                if (currentPolicy.data.requireSpecial) {
                    enforcedOptions.requireSpecial = true;
                }
                if (currentPolicy.data.enforceOnLogin) {
                    enforcedOptions.enforceOnLogin = true;
                }
            });
            return enforcedOptions;
        }));
    }
    evaluateMasterPassword(passwordStrength, newPassword, enforcedPolicyOptions) {
        if (enforcedPolicyOptions == null) {
            return true;
        }
        if (enforcedPolicyOptions.minComplexity > 0 &&
            enforcedPolicyOptions.minComplexity > passwordStrength) {
            return false;
        }
        if (enforcedPolicyOptions.minLength > 0 &&
            enforcedPolicyOptions.minLength > newPassword.length) {
            return false;
        }
        if (enforcedPolicyOptions.requireUpper && newPassword.toLocaleLowerCase() === newPassword) {
            return false;
        }
        if (enforcedPolicyOptions.requireLower && newPassword.toLocaleUpperCase() === newPassword) {
            return false;
        }
        if (enforcedPolicyOptions.requireNumbers && !/[0-9]/.test(newPassword)) {
            return false;
        }
        // eslint-disable-next-line
        if (enforcedPolicyOptions.requireSpecial && !/[!@#$%\^&*]/g.test(newPassword)) {
            return false;
        }
        return true;
    }
    getResetPasswordPolicyOptions(policies, orgId) {
        var _a, _b, _c;
        const resetPasswordPolicyOptions = new ResetPasswordPolicyOptions();
        if (policies == null || orgId == null) {
            return [resetPasswordPolicyOptions, false];
        }
        const policy = policies.find((p) => p.organizationId === orgId && p.type === policy_type_enum_PolicyType.ResetPassword && p.enabled);
        resetPasswordPolicyOptions.autoEnrollEnabled = (_b = (_a = policy === null || policy === void 0 ? void 0 : policy.data) === null || _a === void 0 ? void 0 : _a.autoEnrollEnabled) !== null && _b !== void 0 ? _b : false;
        return [resetPasswordPolicyOptions, (_c = policy === null || policy === void 0 ? void 0 : policy.enabled) !== null && _c !== void 0 ? _c : false];
    }
    upsert(policy) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            yield this.activeUserPolicyState.update((policies) => {
                policies !== null && policies !== void 0 ? policies : (policies = {});
                policies[policy.id] = policy;
                return policies;
            });
        });
    }
    replace(policies) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            yield this.activeUserPolicyState.update(() => policies);
        });
    }
    /**
     * Determines whether an orgUser is exempt from a specific policy because of their role
     * Generally orgUsers who can manage policies are exempt from them, but some policies are stricter
     */
    isExemptFromPolicy(policyType, organization) {
        switch (policyType) {
            case policy_type_enum_PolicyType.MaximumVaultTimeout:
                // Max Vault Timeout applies to everyone except owners
                return organization.isOwner;
            case policy_type_enum_PolicyType.PasswordGenerator:
                // password generation policy applies to everyone
                return false;
            default:
                return organization.canManagePolicies;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/provider/provider.response.ts

class ProviderResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.businessName = this.getResponseProperty("BusinessName");
        this.billingEmail = this.getResponseProperty("BillingEmail");
        this.creationDate = this.getResponseProperty("CreationDate");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/provider/provider-api.service.ts
var provider_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class ProviderApiService {
    constructor(apiService) {
        this.apiService = apiService;
    }
    postProviderSetup(id, request) {
        return provider_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/providers/" + id + "/setup", request, true, true);
            return new ProviderResponse(r);
        });
    }
    getProvider(id) {
        return provider_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/providers/" + id, null, true, true);
            return new ProviderResponse(r);
        });
    }
    putProvider(id, request) {
        return provider_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/providers/" + id, request, true, true);
            return new ProviderResponse(r);
        });
    }
    providerRecoverDeleteToken(providerId, request) {
        return this.apiService.send("POST", "/providers/" + providerId + "/delete-recover-token", request, false, false);
    }
    deleteProvider(id) {
        return provider_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("DELETE", "/providers/" + id, null, true, false);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/provider.ts

class Provider {
    constructor(obj) {
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.name = obj.name;
        this.status = obj.status;
        this.type = obj.type;
        this.enabled = obj.enabled;
        this.userId = obj.userId;
        this.useEvents = obj.useEvents;
    }
    get canAccess() {
        if (this.isProviderAdmin) {
            return true;
        }
        return this.enabled && this.status === ProviderUserStatusType.Confirmed;
    }
    get canCreateOrganizations() {
        return this.enabled && this.isProviderAdmin;
    }
    get canManageUsers() {
        return this.isProviderAdmin;
    }
    get canAccessEventLogs() {
        return this.isProviderAdmin;
    }
    get isProviderAdmin() {
        return this.type === ProviderUserType.ProviderAdmin;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/provider.service.ts
var provider_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const PROVIDERS = UserKeyDefinition.record(PROVIDERS_DISK, "providers", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
function mapToSingleProvider(providerId) {
    return (0,external_rxjs_namespaceObject.map)((providers) => providers === null || providers === void 0 ? void 0 : providers.find((p) => p.id === providerId));
}
class ProviderService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
    }
    providers$(userId) {
        // FIXME: Can be replaced with `getUserStateOrDefault$` if we weren't trying to pick this.
        return (userId != null
            ? this.stateProvider.getUser(userId, PROVIDERS).state$
            : this.stateProvider.activeUserId$.pipe((0,external_rxjs_namespaceObject.take)(1), (0,external_rxjs_namespaceObject.switchMap)((userId) => userId != null ? this.stateProvider.getUser(userId, PROVIDERS).state$ : (0,external_rxjs_namespaceObject.of)(null)))).pipe(this.mapProviderRecordToArray());
    }
    mapProviderRecordToArray() {
        return (0,external_rxjs_namespaceObject.map)((providers) => { var _a; return (_a = Object.values(providers !== null && providers !== void 0 ? providers : {})) === null || _a === void 0 ? void 0 : _a.map((o) => new Provider(o)); });
    }
    get(id) {
        return provider_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.providers$().pipe(mapToSingleProvider(id)));
        });
    }
    getAll() {
        return provider_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.providers$());
        });
    }
    save(providers, userId) {
        return provider_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.setUserState(PROVIDERS, providers, userId);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/abstractions/account.service.ts
function accountInfoEqual(a, b) {
    return (a === null || a === void 0 ? void 0 : a.email) === (b === null || b === void 0 ? void 0 : b.email) && (a === null || a === void 0 ? void 0 : a.name) === (b === null || b === void 0 ? void 0 : b.name);
}
class AccountService {
}
class InternalAccountService extends (/* unused pure expression or super */ null && (AccountService)) {
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/account.service.ts
var account_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ACCOUNT_ACCOUNTS = KeyDefinition.record(ACCOUNT_MEMORY, "accounts", {
    deserializer: (accountInfo) => accountInfo,
});
const ACCOUNT_ACTIVE_ACCOUNT_ID = new KeyDefinition(ACCOUNT_MEMORY, "activeAccountId", {
    deserializer: (id) => id,
});
class AccountServiceImplementation {
    constructor(messagingService, logService, globalStateProvider) {
        this.messagingService = messagingService;
        this.logService = logService;
        this.globalStateProvider = globalStateProvider;
        this.lock = new external_rxjs_namespaceObject.Subject();
        this.logout = new external_rxjs_namespaceObject.Subject();
        this.accountsState = this.globalStateProvider.get(ACCOUNT_ACCOUNTS);
        this.activeAccountIdState = this.globalStateProvider.get(ACCOUNT_ACTIVE_ACCOUNT_ID);
        this.accounts$ = this.accountsState.state$.pipe((0,external_rxjs_namespaceObject.map)((accounts) => (accounts == null ? {} : accounts)));
        this.activeAccount$ = this.activeAccountIdState.state$.pipe((0,external_rxjs_namespaceObject.combineLatestWith)(this.accounts$), (0,external_rxjs_namespaceObject.map)(([id, accounts]) => (id ? Object.assign({ id }, accounts[id]) : undefined)), (0,external_rxjs_namespaceObject.distinctUntilChanged)((a, b) => (a === null || a === void 0 ? void 0 : a.id) === (b === null || b === void 0 ? void 0 : b.id) && accountInfoEqual(a, b)), (0,external_rxjs_namespaceObject.shareReplay)({ bufferSize: 1, refCount: false }));
    }
    addAccount(userId, accountData) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.accountsState.update((accounts) => {
                accounts || (accounts = {});
                accounts[userId] = accountData;
                return accounts;
            });
        });
    }
    setAccountName(userId, name) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccountInfo(userId, { name });
        });
    }
    setAccountEmail(userId, email) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccountInfo(userId, { email });
        });
    }
    switchAccount(userId) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.activeAccountIdState.update((_, accounts) => {
                if (userId == null) {
                    // indicates no account is active
                    return null;
                }
                if ((accounts === null || accounts === void 0 ? void 0 : accounts[userId]) == null) {
                    throw new Error("Account does not exist");
                }
                return userId;
            }, {
                combineLatestWith: this.accounts$,
                shouldUpdate: (id) => {
                    // update only if userId changes
                    return id !== userId;
                },
            });
        });
    }
    // TODO: update to use our own account status settings. Requires inverting direction of state service accounts flow
    delete() {
        var _a;
        return account_service_awaiter(this, void 0, void 0, function* () {
            try {
                (_a = this.messagingService) === null || _a === void 0 ? void 0 : _a.send("logout");
            }
            catch (e) {
                this.logService.error(e);
                throw e;
            }
        });
    }
    setAccountInfo(userId, update) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            function newAccountInfo(oldAccountInfo) {
                return Object.assign(Object.assign({}, oldAccountInfo), update);
            }
            yield this.accountsState.update((accounts) => {
                accounts[userId] = newAccountInfo(accounts[userId]);
                return accounts;
            }, {
                // Avoid unnecessary updates
                // TODO: Faster comparison, maybe include a hash on the objects?
                shouldUpdate: (accounts) => {
                    if ((accounts === null || accounts === void 0 ? void 0 : accounts[userId]) == null) {
                        throw new Error("Account does not exist");
                    }
                    return !accountInfoEqual(accounts[userId], newAccountInfo(accounts[userId]));
                },
            });
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/authentication-status.ts
var AuthenticationStatus;
(function (AuthenticationStatus) {
    AuthenticationStatus[AuthenticationStatus["LoggedOut"] = 0] = "LoggedOut";
    AuthenticationStatus[AuthenticationStatus["Locked"] = 1] = "Locked";
    AuthenticationStatus[AuthenticationStatus["Unlocked"] = 2] = "Unlocked";
})(AuthenticationStatus || (AuthenticationStatus = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/auth.service.ts
var auth_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class AuthService {
    constructor(accountService, messagingService, cryptoService, apiService, stateService, tokenService) {
        this.accountService = accountService;
        this.messagingService = messagingService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.stateService = stateService;
        this.tokenService = tokenService;
        this.activeAccountStatus$ = this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((account) => account === null || account === void 0 ? void 0 : account.id), (0,external_rxjs_namespaceObject.switchMap)((userId) => {
            return this.authStatusFor$(userId);
        }));
        this.authStatuses$ = this.accountService.accounts$.pipe((0,external_rxjs_namespaceObject.map)((accounts) => Object.keys(accounts)), (0,external_rxjs_namespaceObject.switchMap)((entries) => (0,external_rxjs_namespaceObject.combineLatest)(entries.map((userId) => this.authStatusFor$(userId).pipe((0,external_rxjs_namespaceObject.map)((status) => ({ userId, status })))))), (0,external_rxjs_namespaceObject.map)((statuses) => {
            return statuses.reduce((acc, { userId, status }) => {
                acc[userId] = status;
                return acc;
            }, {});
        }));
    }
    authStatusFor$(userId) {
        if (userId == null) {
            return (0,external_rxjs_namespaceObject.of)(AuthenticationStatus.LoggedOut);
        }
        return (0,external_rxjs_namespaceObject.combineLatest)([
            this.cryptoService.getInMemoryUserKeyFor$(userId),
            this.tokenService.hasAccessToken$(userId),
        ]).pipe((0,external_rxjs_namespaceObject.map)(([userKey, hasAccessToken]) => {
            if (!hasAccessToken) {
                return AuthenticationStatus.LoggedOut;
            }
            if (!userKey) {
                return AuthenticationStatus.Locked;
            }
            return AuthenticationStatus.Unlocked;
        }), (0,external_rxjs_namespaceObject.distinctUntilChanged)(), (0,external_rxjs_namespaceObject.shareReplay)({ bufferSize: 1, refCount: false }));
    }
    getAuthStatus(userId) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            // If we don't have an access token or userId, we're logged out
            const isAuthenticated = yield this.stateService.getIsAuthenticated({ userId: userId });
            if (!isAuthenticated) {
                return AuthenticationStatus.LoggedOut;
            }
            // Note: since we aggresively set the auto user key to memory if it exists on app init (see InitService)
            // we only need to check if the user key is in memory.
            const hasUserKey = yield this.cryptoService.hasUserKeyInMemory(userId);
            return hasUserKey ? AuthenticationStatus.Unlocked : AuthenticationStatus.Locked;
        });
    }
    logOut(callback) {
        callback();
        this.messagingService.send("loggedOut");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/update-avatar.request.ts
class UpdateAvatarRequest {
    constructor(avatarColor) {
        this.avatarColor = avatarColor;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/avatar.service.ts
var avatar_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const AVATAR_COLOR = new UserKeyDefinition(AVATAR_DISK, "avatarColor", {
    deserializer: (value) => value,
    clearOn: [],
});
class AvatarService {
    constructor(apiService, stateProvider) {
        this.apiService = apiService;
        this.stateProvider = stateProvider;
        this.avatarColor$ = this.stateProvider.getActive(AVATAR_COLOR).state$;
    }
    setAvatarColor(color) {
        return avatar_service_awaiter(this, void 0, void 0, function* () {
            const { avatarColor } = yield this.apiService.putAvatar(new UpdateAvatarRequest(color));
            yield this.stateProvider.setUserState(AVATAR_COLOR, avatarColor);
        });
    }
    setSyncAvatarColor(userId, color) {
        return avatar_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.getUser(userId, AVATAR_COLOR).update(() => color);
        });
    }
    getUserAvatarColor$(userId) {
        return this.stateProvider.getUser(userId, AVATAR_COLOR).state$;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/secret-verification.request.ts
class SecretVerificationRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/update-devices-trust.request.ts

class UpdateDevicesTrustRequest extends SecretVerificationRequest {
}
class DeviceKeysUpdateRequest {
}
class OtherDeviceKeysUpdateRequest extends (/* unused pure expression or super */ null && (DeviceKeysUpdateRequest)) {
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/device-trust-crypto.service.implementation.ts
var device_trust_crypto_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






/** Uses disk storage so that the device key can persist after log out and tab removal. */
const DEVICE_KEY = new UserKeyDefinition(DEVICE_TRUST_DISK_LOCAL, "deviceKey", {
    deserializer: (deviceKey) => SymmetricCryptoKey.fromJSON(deviceKey),
    clearOn: [], // Device key is needed to log back into device, so we can't clear it automatically during lock or logout
});
/** Uses disk storage so that the shouldTrustDevice bool can persist across login. */
const SHOULD_TRUST_DEVICE = new UserKeyDefinition(DEVICE_TRUST_DISK_LOCAL, "shouldTrustDevice", {
    deserializer: (shouldTrustDevice) => shouldTrustDevice,
    clearOn: [], // Need to preserve the user setting, so we can't clear it automatically during lock or logout
});
class DeviceTrustCryptoService {
    constructor(keyGenerationService, cryptoFunctionService, cryptoService, encryptService, appIdService, devicesApiService, i18nService, platformUtilsService, stateProvider, secureStorageService, userDecryptionOptionsService) {
        this.keyGenerationService = keyGenerationService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.cryptoService = cryptoService;
        this.encryptService = encryptService;
        this.appIdService = appIdService;
        this.devicesApiService = devicesApiService;
        this.i18nService = i18nService;
        this.platformUtilsService = platformUtilsService;
        this.stateProvider = stateProvider;
        this.secureStorageService = secureStorageService;
        this.userDecryptionOptionsService = userDecryptionOptionsService;
        this.platformSupportsSecureStorage = this.platformUtilsService.supportsSecureStorage();
        this.deviceKeySecureStorageKey = "_deviceKey";
        this.supportsDeviceTrust$ = this.userDecryptionOptionsService.userDecryptionOptions$.pipe((0,external_rxjs_namespaceObject.map)((options) => { var _a; return (_a = (options === null || options === void 0 ? void 0 : options.trustedDeviceOption) != null) !== null && _a !== void 0 ? _a : false; }));
    }
    /**
     * @description Retrieves the users choice to trust the device which can only happen after decryption
     * Note: this value should only be used once and then reset
     */
    getShouldTrustDevice(userId) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("UserId is required. Cannot get should trust device.");
            }
            const shouldTrustDevice = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(SHOULD_TRUST_DEVICE, userId));
            return shouldTrustDevice;
        });
    }
    setShouldTrustDevice(userId, value) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("UserId is required. Cannot set should trust device.");
            }
            yield this.stateProvider.setUserState(SHOULD_TRUST_DEVICE, value, userId);
        });
    }
    trustDeviceIfRequired(userId) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("UserId is required. Cannot trust device if required.");
            }
            const shouldTrustDevice = yield this.getShouldTrustDevice(userId);
            if (shouldTrustDevice) {
                yield this.trustDevice(userId);
                // reset the trust choice
                yield this.setShouldTrustDevice(userId, false);
            }
        });
    }
    trustDevice(userId) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("UserId is required. Cannot trust device.");
            }
            // Attempt to get user key
            const userKey = yield this.cryptoService.getUserKey();
            // If user key is not found, throw error
            if (!userKey) {
                throw new Error("User symmetric key not found");
            }
            // Generate deviceKey
            const deviceKey = yield this.makeDeviceKey();
            // Generate asymmetric RSA key pair: devicePrivateKey, devicePublicKey
            const [devicePublicKey, devicePrivateKey] = yield this.cryptoFunctionService.rsaGenerateKeyPair(2048);
            const [devicePublicKeyEncryptedUserKey, userKeyEncryptedDevicePublicKey, deviceKeyEncryptedDevicePrivateKey,] = yield Promise.all([
                // Encrypt user key with the DevicePublicKey
                this.cryptoService.rsaEncrypt(userKey.key, devicePublicKey),
                // Encrypt devicePublicKey with user key
                this.encryptService.encrypt(devicePublicKey, userKey),
                // Encrypt devicePrivateKey with deviceKey
                this.encryptService.encrypt(devicePrivateKey, deviceKey),
            ]);
            // Send encrypted keys to server
            const deviceIdentifier = yield this.appIdService.getAppId();
            const deviceResponse = yield this.devicesApiService.updateTrustedDeviceKeys(deviceIdentifier, devicePublicKeyEncryptedUserKey.encryptedString, userKeyEncryptedDevicePublicKey.encryptedString, deviceKeyEncryptedDevicePrivateKey.encryptedString);
            // store device key in local/secure storage if enc keys posted to server successfully
            yield this.setDeviceKey(userId, deviceKey);
            this.platformUtilsService.showToast("success", null, this.i18nService.t("deviceTrusted"));
            return deviceResponse;
        });
    }
    rotateDevicesTrust(userId, newUserKey, masterPasswordHash) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("UserId is required. Cannot rotate device's trust.");
            }
            const currentDeviceKey = yield this.getDeviceKey(userId);
            if (currentDeviceKey == null) {
                // If the current device doesn't have a device key available to it, then we can't
                // rotate any trust at all, so early return.
                return;
            }
            // At this point of rotating their keys, they should still have their old user key in state
            const oldUserKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.cryptoService.activeUserKey$);
            const deviceIdentifier = yield this.appIdService.getAppId();
            const secretVerificationRequest = new SecretVerificationRequest();
            secretVerificationRequest.masterPasswordHash = masterPasswordHash;
            // Get the keys that are used in rotating a devices keys from the server
            const currentDeviceKeys = yield this.devicesApiService.getDeviceKeys(deviceIdentifier, secretVerificationRequest);
            // Decrypt the existing device public key with the old user key
            const decryptedDevicePublicKey = yield this.encryptService.decryptToBytes(currentDeviceKeys.encryptedPublicKey, oldUserKey);
            // Encrypt the brand new user key with the now-decrypted public key for the device
            const encryptedNewUserKey = yield this.cryptoService.rsaEncrypt(newUserKey.key, decryptedDevicePublicKey);
            // Re-encrypt the device public key with the new user key
            const encryptedDevicePublicKey = yield this.encryptService.encrypt(decryptedDevicePublicKey, newUserKey);
            const currentDeviceUpdateRequest = new DeviceKeysUpdateRequest();
            currentDeviceUpdateRequest.encryptedUserKey = encryptedNewUserKey.encryptedString;
            currentDeviceUpdateRequest.encryptedPublicKey = encryptedDevicePublicKey.encryptedString;
            // TODO: For device management, allow this method to take an array of device ids that can be looped over and individually rotated
            // then it can be added to trustRequest.otherDevices.
            const trustRequest = new UpdateDevicesTrustRequest();
            trustRequest.masterPasswordHash = masterPasswordHash;
            trustRequest.currentDevice = currentDeviceUpdateRequest;
            trustRequest.otherDevices = [];
            yield this.devicesApiService.updateTrust(trustRequest, deviceIdentifier);
        });
    }
    getDeviceKey(userId) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("UserId is required. Cannot get device key.");
            }
            if (this.platformSupportsSecureStorage) {
                const deviceKeyB64 = yield this.secureStorageService.get(`${userId}${this.deviceKeySecureStorageKey}`, this.getSecureStorageOptions(userId));
                const deviceKey = SymmetricCryptoKey.fromJSON(deviceKeyB64);
                return deviceKey;
            }
            const deviceKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(DEVICE_KEY, userId));
            return deviceKey;
        });
    }
    setDeviceKey(userId, deviceKey) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("UserId is required. Cannot set device key.");
            }
            if (this.platformSupportsSecureStorage) {
                yield this.secureStorageService.save(`${userId}${this.deviceKeySecureStorageKey}`, deviceKey, this.getSecureStorageOptions(userId));
                return;
            }
            yield this.stateProvider.setUserState(DEVICE_KEY, deviceKey === null || deviceKey === void 0 ? void 0 : deviceKey.toJSON(), userId);
        });
    }
    makeDeviceKey() {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            // Create 512-bit device key
            const deviceKey = (yield this.keyGenerationService.createKey(512));
            return deviceKey;
        });
    }
    decryptUserKeyWithDeviceKey(userId, encryptedDevicePrivateKey, encryptedUserKey, deviceKey) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("UserId is required. Cannot decrypt user key with device key.");
            }
            if (!deviceKey) {
                // User doesn't have a device key anymore so device is untrusted
                return null;
            }
            try {
                // attempt to decrypt encryptedDevicePrivateKey with device key
                const devicePrivateKey = yield this.encryptService.decryptToBytes(encryptedDevicePrivateKey, deviceKey);
                // Attempt to decrypt encryptedUserDataKey with devicePrivateKey
                const userKey = yield this.cryptoService.rsaDecrypt(encryptedUserKey.encryptedString, devicePrivateKey);
                return new SymmetricCryptoKey(userKey);
            }
            catch (e) {
                // If either decryption effort fails, we want to remove the device key
                yield this.setDeviceKey(userId, null);
                return null;
            }
        });
    }
    getSecureStorageOptions(userId) {
        return {
            storageLocation: StorageLocation.Disk,
            useSecureStorage: true,
            userId: userId,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/abstractions/devices/responses/device.response.ts

class DeviceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.name = this.getResponseProperty("Name");
        this.identifier = this.getResponseProperty("Identifier");
        this.type = this.getResponseProperty("Type");
        this.creationDate = this.getResponseProperty("CreationDate");
        this.revisionDate = this.getResponseProperty("RevisionDate");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/protected-device.response.ts


class ProtectedDeviceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("id");
        this.name = this.getResponseProperty("name");
        this.identifier = this.getResponseProperty("identifier");
        this.type = this.getResponseProperty("type");
        this.creationDate = new Date(this.getResponseProperty("creationDate"));
        if (response.encryptedUserKey) {
            this.encryptedUserKey = new EncString(this.getResponseProperty("encryptedUserKey"));
        }
        if (response.encryptedPublicKey) {
            this.encryptedPublicKey = new EncString(this.getResponseProperty("encryptedPublicKey"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/devices/requests/trusted-device-keys.request.ts
class TrustedDeviceKeysRequest {
    constructor(encryptedUserKey, encryptedPublicKey, encryptedPrivateKey) {
        this.encryptedUserKey = encryptedUserKey;
        this.encryptedPublicKey = encryptedPublicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/devices-api.service.implementation.ts
var devices_api_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class DevicesApiServiceImplementation {
    constructor(apiService) {
        this.apiService = apiService;
    }
    getKnownDevice(email, deviceIdentifier) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/devices/knowndevice", null, false, true, null, (headers) => {
                headers.set("X-Device-Identifier", deviceIdentifier);
                headers.set("X-Request-Email", Utils.fromUtf8ToUrlB64(email));
            });
            return r;
        });
    }
    /**
     * Get device by identifier
     * @param deviceIdentifier - client generated id (not device id in DB)
     */
    getDeviceByIdentifier(deviceIdentifier) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", `/devices/identifier/${deviceIdentifier}`, null, true, true);
            return new DeviceResponse(r);
        });
    }
    getDevices() {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/devices", null, true, true, null);
            return new ListResponse(r, DeviceResponse);
        });
    }
    updateTrustedDeviceKeys(deviceIdentifier, devicePublicKeyEncryptedUserKey, userKeyEncryptedDevicePublicKey, deviceKeyEncryptedDevicePrivateKey) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const request = new TrustedDeviceKeysRequest(devicePublicKeyEncryptedUserKey, userKeyEncryptedDevicePublicKey, deviceKeyEncryptedDevicePrivateKey);
            const result = yield this.apiService.send("PUT", `/devices/${deviceIdentifier}/keys`, request, true, true);
            return new DeviceResponse(result);
        });
    }
    updateTrust(updateDevicesTrustRequestModel, deviceIdentifier) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/devices/update-trust", updateDevicesTrustRequestModel, true, false, null, (headers) => {
                headers.set("Device-Identifier", deviceIdentifier);
            });
        });
    }
    getDeviceKeys(deviceIdentifier, secretVerificationRequest) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const result = yield this.apiService.send("POST", `/devices/${deviceIdentifier}/retrieve-keys`, secretVerificationRequest, true, true);
            return new ProtectedDeviceResponse(result);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/key-connector-user-key.request.ts
class KeyConnectorUserKeyRequest {
    constructor(key) {
        this.key = key;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/set-key-connector-key.request.ts
class SetKeyConnectorKeyRequest {
    constructor(key, kdf, kdfConfig, orgIdentifier, keys) {
        this.key = key;
        this.kdf = kdf;
        this.kdfIterations = kdfConfig.iterations;
        this.kdfMemory = kdfConfig.memory;
        this.kdfParallelism = kdfConfig.parallelism;
        this.orgIdentifier = orgIdentifier;
        this.keys = keys;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/key-connector.service.ts
var key_connector_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};









const USES_KEY_CONNECTOR = new UserKeyDefinition(KEY_CONNECTOR_DISK, "usesKeyConnector", {
    deserializer: (usesKeyConnector) => usesKeyConnector,
    clearOn: ["logout"],
});
const CONVERT_ACCOUNT_TO_KEY_CONNECTOR = new UserKeyDefinition(KEY_CONNECTOR_DISK, "convertAccountToKeyConnector", {
    deserializer: (convertAccountToKeyConnector) => convertAccountToKeyConnector,
    clearOn: ["logout"],
});
class KeyConnectorService {
    constructor(accountService, masterPasswordService, cryptoService, apiService, tokenService, logService, organizationService, keyGenerationService, logoutCallback, stateProvider) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.logService = logService;
        this.organizationService = organizationService;
        this.keyGenerationService = keyGenerationService;
        this.logoutCallback = logoutCallback;
        this.stateProvider = stateProvider;
        this.usesKeyConnectorState = this.stateProvider.getActive(USES_KEY_CONNECTOR);
        this.convertAccountToKeyConnectorState = this.stateProvider.getActive(CONVERT_ACCOUNT_TO_KEY_CONNECTOR);
    }
    setUsesKeyConnector(usesKeyConnector) {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            yield this.usesKeyConnectorState.update(() => usesKeyConnector);
        });
    }
    getUsesKeyConnector() {
        return (0,external_rxjs_namespaceObject.firstValueFrom)(this.usesKeyConnectorState.state$);
    }
    userNeedsMigration() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const loggedInUsingSso = yield this.tokenService.getIsExternal();
            const requiredByOrganization = (yield this.getManagingOrganization()) != null;
            const userIsNotUsingKeyConnector = !(yield this.getUsesKeyConnector());
            return loggedInUsingSso && requiredByOrganization && userIsNotUsingKeyConnector;
        });
    }
    migrateUser() {
        var _a;
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const organization = yield this.getManagingOrganization();
            const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            const keyConnectorRequest = new KeyConnectorUserKeyRequest(masterKey.encKeyB64);
            try {
                yield this.apiService.postUserKeyToKeyConnector(organization.keyConnectorUrl, keyConnectorRequest);
            }
            catch (e) {
                this.handleKeyConnectorError(e);
            }
            yield this.apiService.postConvertToKeyConnector();
        });
    }
    // TODO: UserKey should be renamed to MasterKey and typed accordingly
    setMasterKeyFromUrl(url) {
        var _a;
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            try {
                const masterKeyResponse = yield this.apiService.getMasterKeyFromKeyConnector(url);
                const keyArr = Utils.fromB64ToArray(masterKeyResponse.key);
                const masterKey = new SymmetricCryptoKey(keyArr);
                const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
                yield this.masterPasswordService.setMasterKey(masterKey, userId);
            }
            catch (e) {
                this.handleKeyConnectorError(e);
            }
        });
    }
    getManagingOrganization() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const orgs = yield this.organizationService.getAll();
            return orgs.find((o) => o.keyConnectorEnabled &&
                o.type !== OrganizationUserType.Admin &&
                o.type !== OrganizationUserType.Owner &&
                !o.isProviderUser);
        });
    }
    convertNewSsoUserToKeyConnector(tokenResponse, orgId) {
        var _a, _b;
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            // TODO: Remove after tokenResponse.keyConnectorUrl is deprecated in 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            const { kdf, kdfIterations, kdfMemory, kdfParallelism, keyConnectorUrl: legacyKeyConnectorUrl, userDecryptionOptions, } = tokenResponse;
            const password = yield this.keyGenerationService.createKey(512);
            const kdfConfig = new KdfConfig(kdfIterations, kdfMemory, kdfParallelism);
            const masterKey = yield this.cryptoService.makeMasterKey(password.keyB64, yield this.tokenService.getEmail(), kdf, kdfConfig);
            const keyConnectorRequest = new KeyConnectorUserKeyRequest(masterKey.encKeyB64);
            const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
            yield this.masterPasswordService.setMasterKey(masterKey, userId);
            const userKey = yield this.cryptoService.makeUserKey(masterKey);
            yield this.cryptoService.setUserKey(userKey[0]);
            yield this.cryptoService.setMasterKeyEncryptedUserKey(userKey[1].encryptedString);
            const [pubKey, privKey] = yield this.cryptoService.makeKeyPair();
            try {
                const keyConnectorUrl = legacyKeyConnectorUrl !== null && legacyKeyConnectorUrl !== void 0 ? legacyKeyConnectorUrl : (_b = userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.keyConnectorOption) === null || _b === void 0 ? void 0 : _b.keyConnectorUrl;
                yield this.apiService.postUserKeyToKeyConnector(keyConnectorUrl, keyConnectorRequest);
            }
            catch (e) {
                this.handleKeyConnectorError(e);
            }
            const keys = new KeysRequest(pubKey, privKey.encryptedString);
            const setPasswordRequest = new SetKeyConnectorKeyRequest(userKey[1].encryptedString, kdf, kdfConfig, orgId, keys);
            yield this.apiService.postSetKeyConnectorKey(setPasswordRequest);
        });
    }
    setConvertAccountRequired(status) {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            yield this.convertAccountToKeyConnectorState.update(() => status);
        });
    }
    getConvertAccountRequired() {
        return (0,external_rxjs_namespaceObject.firstValueFrom)(this.convertAccountToKeyConnectorState.state$);
    }
    removeConvertAccountRequired() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            yield this.setConvertAccountRequired(null);
        });
    }
    handleKeyConnectorError(e) {
        this.logService.error(e);
        if (this.logoutCallback != null) {
            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            this.logoutCallback(false);
        }
        throw new Error("Key Connector error");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/master-password/master-password.service.ts
var master_password_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





/** Memory since master key shouldn't be available on lock */
const MASTER_KEY = new UserKeyDefinition(MASTER_PASSWORD_MEMORY, "masterKey", {
    deserializer: (masterKey) => SymmetricCryptoKey.fromJSON(masterKey),
    clearOn: ["lock", "logout"],
});
/** Disk since master key hash is used for unlock */
const MASTER_KEY_HASH = new UserKeyDefinition(MASTER_PASSWORD_DISK, "masterKeyHash", {
    deserializer: (masterKeyHash) => masterKeyHash,
    clearOn: ["logout"],
});
/** Disk to persist through lock */
const MASTER_KEY_ENCRYPTED_USER_KEY = new UserKeyDefinition(MASTER_PASSWORD_DISK, "masterKeyEncryptedUserKey", {
    deserializer: (key) => key,
    clearOn: ["logout"],
});
/** Disk to persist through lock and account switches */
const FORCE_SET_PASSWORD_REASON = new UserKeyDefinition(MASTER_PASSWORD_DISK, "forceSetPasswordReason", {
    deserializer: (reason) => reason,
    clearOn: ["logout"],
});
class MasterPasswordService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
    }
    masterKey$(userId) {
        if (userId == null) {
            throw new Error("User ID is required.");
        }
        return this.stateProvider.getUser(userId, MASTER_KEY).state$;
    }
    masterKeyHash$(userId) {
        if (userId == null) {
            throw new Error("User ID is required.");
        }
        return this.stateProvider.getUser(userId, MASTER_KEY_HASH).state$;
    }
    forceSetPasswordReason$(userId) {
        if (userId == null) {
            throw new Error("User ID is required.");
        }
        return this.stateProvider
            .getUser(userId, FORCE_SET_PASSWORD_REASON)
            .state$.pipe((0,external_rxjs_namespaceObject.map)((reason) => reason !== null && reason !== void 0 ? reason : ForceSetPasswordReason.None));
    }
    // TODO: Remove this method and decrypt directly in the service instead
    getMasterKeyEncryptedUserKey(userId) {
        return master_password_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required.");
            }
            const key = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, MASTER_KEY_ENCRYPTED_USER_KEY).state$);
            return EncString.fromJSON(key);
        });
    }
    setMasterKey(masterKey, userId) {
        return master_password_service_awaiter(this, void 0, void 0, function* () {
            if (masterKey == null) {
                throw new Error("Master key is required.");
            }
            if (userId == null) {
                throw new Error("User ID is required.");
            }
            yield this.stateProvider.getUser(userId, MASTER_KEY).update((_) => masterKey);
        });
    }
    clearMasterKey(userId) {
        return master_password_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required.");
            }
            yield this.stateProvider.getUser(userId, MASTER_KEY).update((_) => null);
        });
    }
    setMasterKeyHash(masterKeyHash, userId) {
        return master_password_service_awaiter(this, void 0, void 0, function* () {
            if (masterKeyHash == null) {
                throw new Error("Master key hash is required.");
            }
            if (userId == null) {
                throw new Error("User ID is required.");
            }
            yield this.stateProvider.getUser(userId, MASTER_KEY_HASH).update((_) => masterKeyHash);
        });
    }
    clearMasterKeyHash(userId) {
        return master_password_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required.");
            }
            yield this.stateProvider.getUser(userId, MASTER_KEY_HASH).update((_) => null);
        });
    }
    setMasterKeyEncryptedUserKey(encryptedKey, userId) {
        return master_password_service_awaiter(this, void 0, void 0, function* () {
            if (encryptedKey == null) {
                throw new Error("Encrypted Key is required.");
            }
            if (userId == null) {
                throw new Error("User ID is required.");
            }
            yield this.stateProvider
                .getUser(userId, MASTER_KEY_ENCRYPTED_USER_KEY)
                .update((_) => encryptedKey.toJSON());
        });
    }
    setForceSetPasswordReason(reason, userId) {
        return master_password_service_awaiter(this, void 0, void 0, function* () {
            if (reason == null) {
                throw new Error("Reason is required.");
            }
            if (userId == null) {
                throw new Error("User ID is required.");
            }
            yield this.stateProvider.getUser(userId, FORCE_SET_PASSWORD_REASON).update((_) => reason);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/enums/vault-timeout-action.enum.ts
var VaultTimeoutAction;
(function (VaultTimeoutAction) {
    VaultTimeoutAction["Lock"] = "lock";
    VaultTimeoutAction["LogOut"] = "logOut";
})(VaultTimeoutAction || (VaultTimeoutAction = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/token.state.ts

// Note: all tokens / API key information must be cleared on logout.
// because we are using secure storage, we must manually call to clean up our tokens.
// See stateService.deAuthenticateAccount for where we call clearTokens(...)
const ACCESS_TOKEN_DISK = new UserKeyDefinition(TOKEN_DISK, "accessToken", {
    deserializer: (accessToken) => accessToken,
    clearOn: [], // Manually handled
});
const ACCESS_TOKEN_MEMORY = new UserKeyDefinition(TOKEN_MEMORY, "accessToken", {
    deserializer: (accessToken) => accessToken,
    clearOn: [], // Manually handled
});
const REFRESH_TOKEN_DISK = new UserKeyDefinition(TOKEN_DISK, "refreshToken", {
    deserializer: (refreshToken) => refreshToken,
    clearOn: [], // Manually handled
});
const REFRESH_TOKEN_MEMORY = new UserKeyDefinition(TOKEN_MEMORY, "refreshToken", {
    deserializer: (refreshToken) => refreshToken,
    clearOn: [], // Manually handled
});
const EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL = KeyDefinition.record(TOKEN_DISK_LOCAL, "emailTwoFactorTokenRecord", {
    deserializer: (emailTwoFactorTokenRecord) => emailTwoFactorTokenRecord,
});
const API_KEY_CLIENT_ID_DISK = new UserKeyDefinition(TOKEN_DISK, "apiKeyClientId", {
    deserializer: (apiKeyClientId) => apiKeyClientId,
    clearOn: [], // Manually handled
});
const API_KEY_CLIENT_ID_MEMORY = new UserKeyDefinition(TOKEN_MEMORY, "apiKeyClientId", {
    deserializer: (apiKeyClientId) => apiKeyClientId,
    clearOn: [], // Manually handled
});
const API_KEY_CLIENT_SECRET_DISK = new UserKeyDefinition(TOKEN_DISK, "apiKeyClientSecret", {
    deserializer: (apiKeyClientSecret) => apiKeyClientSecret,
    clearOn: [], // Manually handled
});
const API_KEY_CLIENT_SECRET_MEMORY = new UserKeyDefinition(TOKEN_MEMORY, "apiKeyClientSecret", {
    deserializer: (apiKeyClientSecret) => apiKeyClientSecret,
    clearOn: [], // Manually handled
});

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/token.service.ts
var token_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








var TokenStorageLocation;
(function (TokenStorageLocation) {
    TokenStorageLocation["Disk"] = "disk";
    TokenStorageLocation["SecureStorage"] = "secureStorage";
    TokenStorageLocation["Memory"] = "memory";
})(TokenStorageLocation || (TokenStorageLocation = {}));
class TokenService {
    constructor(
    // Note: we cannot use ActiveStateProvider because if we ever want to inject
    // this service into the AccountService, we will make a circular dependency
    singleUserStateProvider, globalStateProvider, platformSupportsSecureStorage, secureStorageService, keyGenerationService, encryptService, logService) {
        this.singleUserStateProvider = singleUserStateProvider;
        this.globalStateProvider = globalStateProvider;
        this.platformSupportsSecureStorage = platformSupportsSecureStorage;
        this.secureStorageService = secureStorageService;
        this.keyGenerationService = keyGenerationService;
        this.encryptService = encryptService;
        this.logService = logService;
        this.accessTokenKeySecureStorageKey = "_accessTokenKey";
        this.refreshTokenSecureStorageKey = "_refreshToken";
        this.initializeState();
    }
    hasAccessToken$(userId) {
        // FIXME Once once vault timeout action is observable, we can use it to determine storage location
        // and avoid the need to check both disk and memory.
        return (0,external_rxjs_namespaceObject.combineLatest)([
            this.singleUserStateProvider.get(userId, ACCESS_TOKEN_DISK).state$,
            this.singleUserStateProvider.get(userId, ACCESS_TOKEN_MEMORY).state$,
        ]).pipe((0,external_rxjs_namespaceObject.map)(([disk, memory]) => Boolean(disk || memory)));
    }
    // pivoting to an approach where we create a symmetric key we store in secure storage
    // which is used to protect the data before persisting to disk.
    // We will also use the same symmetric key to decrypt the data when reading from disk.
    initializeState() {
        this.emailTwoFactorTokenRecordGlobalState = this.globalStateProvider.get(EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL);
        this.activeUserIdGlobalState = this.globalStateProvider.get(ACCOUNT_ACTIVE_ACCOUNT_ID);
    }
    setTokens(accessToken, vaultTimeoutAction, vaultTimeout, refreshToken, clientIdClientSecret) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            if (!accessToken) {
                throw new Error("Access token is required.");
            }
            // get user id the access token
            const userId = yield this.getUserIdFromAccessToken(accessToken);
            if (!userId) {
                throw new Error("User id not found. Cannot set tokens.");
            }
            yield this._setAccessToken(accessToken, vaultTimeoutAction, vaultTimeout, userId);
            if (refreshToken) {
                yield this.setRefreshToken(refreshToken, vaultTimeoutAction, vaultTimeout, userId);
            }
            if (clientIdClientSecret != null) {
                yield this.setClientId(clientIdClientSecret[0], vaultTimeoutAction, vaultTimeout, userId);
                yield this.setClientSecret(clientIdClientSecret[1], vaultTimeoutAction, vaultTimeout, userId);
            }
        });
    }
    getAccessTokenKey(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const accessTokenKeyB64 = yield this.secureStorageService.get(`${userId}${this.accessTokenKeySecureStorageKey}`, this.getSecureStorageOptions(userId));
            if (!accessTokenKeyB64) {
                return null;
            }
            const accessTokenKey = SymmetricCryptoKey.fromJSON(accessTokenKeyB64);
            return accessTokenKey;
        });
    }
    createAndSaveAccessTokenKey(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const newAccessTokenKey = (yield this.keyGenerationService.createKey(512));
            yield this.secureStorageService.save(`${userId}${this.accessTokenKeySecureStorageKey}`, newAccessTokenKey, this.getSecureStorageOptions(userId));
            return newAccessTokenKey;
        });
    }
    clearAccessTokenKey(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.secureStorageService.remove(`${userId}${this.accessTokenKeySecureStorageKey}`, this.getSecureStorageOptions(userId));
        });
    }
    getOrCreateAccessTokenKey(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            if (!this.platformSupportsSecureStorage) {
                throw new Error("Platform does not support secure storage. Cannot obtain access token key.");
            }
            if (!userId) {
                throw new Error("User id not found. Cannot obtain access token key.");
            }
            // First see if we have an accessTokenKey in secure storage and return it if we do
            let accessTokenKey = yield this.getAccessTokenKey(userId);
            if (!accessTokenKey) {
                // Otherwise, create a new one and save it to secure storage, then return it
                accessTokenKey = yield this.createAndSaveAccessTokenKey(userId);
            }
            return accessTokenKey;
        });
    }
    encryptAccessToken(accessToken, userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const accessTokenKey = yield this.getOrCreateAccessTokenKey(userId);
            return yield this.encryptService.encrypt(accessToken, accessTokenKey);
        });
    }
    decryptAccessToken(encryptedAccessToken, userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const accessTokenKey = yield this.getAccessTokenKey(userId);
            if (!accessTokenKey) {
                // If we don't have an accessTokenKey, then that means we don't have an access token as it hasn't been set yet
                // and we have to return null here to properly indicate the the user isn't logged in.
                return null;
            }
            const decryptedAccessToken = yield this.encryptService.decryptToUtf8(encryptedAccessToken, accessTokenKey);
            return decryptedAccessToken;
        });
    }
    /**
     * Internal helper for set access token which always requires user id.
     * This is useful because setTokens always will have a user id from the access token whereas
     * the public setAccessToken method does not.
     */
    _setAccessToken(accessToken, vaultTimeoutAction, vaultTimeout, userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const storageLocation = yield this.determineStorageLocation(vaultTimeoutAction, vaultTimeout, true);
            switch (storageLocation) {
                case TokenStorageLocation.SecureStorage: {
                    // Secure storage implementations have variable length limitations (Windows), so we cannot
                    // store the access token directly. Instead, we encrypt with accessTokenKey and store that
                    // in secure storage.
                    const encryptedAccessToken = yield this.encryptAccessToken(accessToken, userId);
                    // Save the encrypted access token to disk
                    yield this.singleUserStateProvider
                        .get(userId, ACCESS_TOKEN_DISK)
                        .update((_) => encryptedAccessToken.encryptedString);
                    // TODO: PM-6408 - https://bitwarden.atlassian.net/browse/PM-6408
                    // 2024-02-20: Remove access token from memory so that we migrate to encrypt the access token over time.
                    // Remove this call to remove the access token from memory after 3 releases.
                    yield this.singleUserStateProvider.get(userId, ACCESS_TOKEN_MEMORY).update((_) => null);
                    return;
                }
                case TokenStorageLocation.Disk:
                    // Access token stored on disk unencrypted as platform does not support secure storage
                    yield this.singleUserStateProvider
                        .get(userId, ACCESS_TOKEN_DISK)
                        .update((_) => accessToken);
                    return;
                case TokenStorageLocation.Memory:
                    // Access token stored in memory due to vault timeout settings
                    yield this.singleUserStateProvider
                        .get(userId, ACCESS_TOKEN_MEMORY)
                        .update((_) => accessToken);
                    return;
            }
        });
    }
    setAccessToken(accessToken, vaultTimeoutAction, vaultTimeout) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            if (!accessToken) {
                throw new Error("Access token is required.");
            }
            const userId = yield this.getUserIdFromAccessToken(accessToken);
            // If we don't have a user id, we can't save the value
            if (!userId) {
                throw new Error("User id not found. Cannot save access token.");
            }
            yield this._setAccessToken(accessToken, vaultTimeoutAction, vaultTimeout, userId);
        });
    }
    clearAccessToken(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            // If we don't have a user id, we can't clear the value
            if (!userId) {
                throw new Error("User id not found. Cannot clear access token.");
            }
            // TODO: re-eval this implementation once we get shared key definitions for vault timeout and vault timeout action data.
            // we can't determine storage location w/out vaultTimeoutAction and vaultTimeout
            // but we can simply clear all locations to avoid the need to require those parameters.
            if (this.platformSupportsSecureStorage) {
                // Always clear the access token key when clearing the access token
                // The next set of the access token will create a new access token key
                yield this.clearAccessTokenKey(userId);
            }
            // Platform doesn't support secure storage, so use state provider implementation
            yield this.singleUserStateProvider.get(userId, ACCESS_TOKEN_DISK).update((_) => null);
            yield this.singleUserStateProvider.get(userId, ACCESS_TOKEN_MEMORY).update((_) => null);
        });
    }
    getAccessToken(userId) {
        var _a;
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            if (!userId) {
                return undefined;
            }
            // Try to get the access token from memory
            const accessTokenMemory = yield this.getStateValueByUserIdAndKeyDef(userId, ACCESS_TOKEN_MEMORY);
            if (accessTokenMemory != null) {
                return accessTokenMemory;
            }
            // If memory is null, read from disk
            const accessTokenDisk = yield this.getStateValueByUserIdAndKeyDef(userId, ACCESS_TOKEN_DISK);
            if (!accessTokenDisk) {
                return null;
            }
            if (this.platformSupportsSecureStorage) {
                const accessTokenKey = yield this.getAccessTokenKey(userId);
                if (!accessTokenKey) {
                    // We know this is an unencrypted access token because we don't have an access token key
                    return accessTokenDisk;
                }
                try {
                    const encryptedAccessTokenEncString = new EncString(accessTokenDisk);
                    const decryptedAccessToken = yield this.decryptAccessToken(encryptedAccessTokenEncString, userId);
                    return decryptedAccessToken;
                }
                catch (error) {
                    // If an error occurs during decryption, return null for logout.
                    // We don't try to recover here since we'd like to know
                    // if access token and key are getting out of sync.
                    this.logService.error(`Failed to decrypt access token: ${(_a = error === null || error === void 0 ? void 0 : error.message) !== null && _a !== void 0 ? _a : "Unknown error."}`);
                    return null;
                }
            }
            return accessTokenDisk;
        });
    }
    // Private because we only ever set the refresh token when also setting the access token
    // and we need the user id from the access token to save to secure storage
    setRefreshToken(refreshToken, vaultTimeoutAction, vaultTimeout, userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            // If we don't have a user id, we can't save the value
            if (!userId) {
                throw new Error("User id not found. Cannot save refresh token.");
            }
            const storageLocation = yield this.determineStorageLocation(vaultTimeoutAction, vaultTimeout, true);
            switch (storageLocation) {
                case TokenStorageLocation.SecureStorage:
                    yield this.saveStringToSecureStorage(userId, this.refreshTokenSecureStorageKey, refreshToken);
                    // TODO: PM-6408 - https://bitwarden.atlassian.net/browse/PM-6408
                    // 2024-02-20: Remove refresh token from memory and disk so that we migrate to secure storage over time.
                    // Remove these 2 calls to remove the refresh token from memory and disk after 3 releases.
                    yield this.singleUserStateProvider.get(userId, REFRESH_TOKEN_DISK).update((_) => null);
                    yield this.singleUserStateProvider.get(userId, REFRESH_TOKEN_MEMORY).update((_) => null);
                    return;
                case TokenStorageLocation.Disk:
                    yield this.singleUserStateProvider
                        .get(userId, REFRESH_TOKEN_DISK)
                        .update((_) => refreshToken);
                    return;
                case TokenStorageLocation.Memory:
                    yield this.singleUserStateProvider
                        .get(userId, REFRESH_TOKEN_MEMORY)
                        .update((_) => refreshToken);
                    return;
            }
        });
    }
    getRefreshToken(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            if (!userId) {
                return undefined;
            }
            // pre-secure storage migration:
            // Always read memory first b/c faster
            const refreshTokenMemory = yield this.getStateValueByUserIdAndKeyDef(userId, REFRESH_TOKEN_MEMORY);
            if (refreshTokenMemory != null) {
                return refreshTokenMemory;
            }
            // if memory is null, read from disk and then secure storage
            const refreshTokenDisk = yield this.getStateValueByUserIdAndKeyDef(userId, REFRESH_TOKEN_DISK);
            if (refreshTokenDisk != null) {
                return refreshTokenDisk;
            }
            if (this.platformSupportsSecureStorage) {
                const refreshTokenSecureStorage = yield this.getStringFromSecureStorage(userId, this.refreshTokenSecureStorageKey);
                if (refreshTokenSecureStorage != null) {
                    return refreshTokenSecureStorage;
                }
            }
            return null;
        });
    }
    clearRefreshToken(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            // If we don't have a user id, we can't clear the value
            if (!userId) {
                throw new Error("User id not found. Cannot clear refresh token.");
            }
            // TODO: re-eval this once we get shared key definitions for vault timeout and vault timeout action data.
            // we can't determine storage location w/out vaultTimeoutAction and vaultTimeout
            // but we can simply clear all locations to avoid the need to require those parameters
            if (this.platformSupportsSecureStorage) {
                yield this.secureStorageService.remove(`${userId}${this.refreshTokenSecureStorageKey}`, this.getSecureStorageOptions(userId));
            }
            // Platform doesn't support secure storage, so use state provider implementation
            yield this.singleUserStateProvider.get(userId, REFRESH_TOKEN_MEMORY).update((_) => null);
            yield this.singleUserStateProvider.get(userId, REFRESH_TOKEN_DISK).update((_) => null);
        });
    }
    setClientId(clientId, vaultTimeoutAction, vaultTimeout, userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            // If we don't have a user id, we can't save the value
            if (!userId) {
                throw new Error("User id not found. Cannot save client id.");
            }
            const storageLocation = yield this.determineStorageLocation(vaultTimeoutAction, vaultTimeout, false);
            if (storageLocation === TokenStorageLocation.Disk) {
                yield this.singleUserStateProvider
                    .get(userId, API_KEY_CLIENT_ID_DISK)
                    .update((_) => clientId);
            }
            else if (storageLocation === TokenStorageLocation.Memory) {
                yield this.singleUserStateProvider
                    .get(userId, API_KEY_CLIENT_ID_MEMORY)
                    .update((_) => clientId);
            }
        });
    }
    getClientId(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            if (!userId) {
                return undefined;
            }
            // Always read memory first b/c faster
            const apiKeyClientIdMemory = yield this.getStateValueByUserIdAndKeyDef(userId, API_KEY_CLIENT_ID_MEMORY);
            if (apiKeyClientIdMemory != null) {
                return apiKeyClientIdMemory;
            }
            // if memory is null, read from disk
            return yield this.getStateValueByUserIdAndKeyDef(userId, API_KEY_CLIENT_ID_DISK);
        });
    }
    clearClientId(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            // If we don't have a user id, we can't clear the value
            if (!userId) {
                throw new Error("User id not found. Cannot clear client id.");
            }
            // TODO: re-eval this once we get shared key definitions for vault timeout and vault timeout action data.
            // we can't determine storage location w/out vaultTimeoutAction and vaultTimeout
            // but we can simply clear both locations to avoid the need to require those parameters
            // Platform doesn't support secure storage, so use state provider implementation
            yield this.singleUserStateProvider.get(userId, API_KEY_CLIENT_ID_MEMORY).update((_) => null);
            yield this.singleUserStateProvider.get(userId, API_KEY_CLIENT_ID_DISK).update((_) => null);
        });
    }
    setClientSecret(clientSecret, vaultTimeoutAction, vaultTimeout, userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            if (!userId) {
                throw new Error("User id not found. Cannot save client secret.");
            }
            const storageLocation = yield this.determineStorageLocation(vaultTimeoutAction, vaultTimeout, false);
            if (storageLocation === TokenStorageLocation.Disk) {
                yield this.singleUserStateProvider
                    .get(userId, API_KEY_CLIENT_SECRET_DISK)
                    .update((_) => clientSecret);
            }
            else if (storageLocation === TokenStorageLocation.Memory) {
                yield this.singleUserStateProvider
                    .get(userId, API_KEY_CLIENT_SECRET_MEMORY)
                    .update((_) => clientSecret);
            }
        });
    }
    getClientSecret(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            if (!userId) {
                return undefined;
            }
            // Always read memory first b/c faster
            const apiKeyClientSecretMemory = yield this.getStateValueByUserIdAndKeyDef(userId, API_KEY_CLIENT_SECRET_MEMORY);
            if (apiKeyClientSecretMemory != null) {
                return apiKeyClientSecretMemory;
            }
            // if memory is null, read from disk
            return yield this.getStateValueByUserIdAndKeyDef(userId, API_KEY_CLIENT_SECRET_DISK);
        });
    }
    clearClientSecret(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            // If we don't have a user id, we can't clear the value
            if (!userId) {
                throw new Error("User id not found. Cannot clear client secret.");
            }
            // TODO: re-eval this once we get shared key definitions for vault timeout and vault timeout action data.
            // we can't determine storage location w/out vaultTimeoutAction and vaultTimeout
            // but we can simply clear both locations to avoid the need to require those parameters
            // Platform doesn't support secure storage, so use state provider implementation
            yield this.singleUserStateProvider
                .get(userId, API_KEY_CLIENT_SECRET_MEMORY)
                .update((_) => null);
            yield this.singleUserStateProvider.get(userId, API_KEY_CLIENT_SECRET_DISK).update((_) => null);
        });
    }
    setTwoFactorToken(email, twoFactorToken) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.emailTwoFactorTokenRecordGlobalState.update((emailTwoFactorTokenRecord) => {
                emailTwoFactorTokenRecord !== null && emailTwoFactorTokenRecord !== void 0 ? emailTwoFactorTokenRecord : (emailTwoFactorTokenRecord = {});
                emailTwoFactorTokenRecord[email] = twoFactorToken;
                return emailTwoFactorTokenRecord;
            });
        });
    }
    getTwoFactorToken(email) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const emailTwoFactorTokenRecord = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.emailTwoFactorTokenRecordGlobalState.state$);
            if (!emailTwoFactorTokenRecord) {
                return null;
            }
            return emailTwoFactorTokenRecord[email];
        });
    }
    clearTwoFactorToken(email) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.emailTwoFactorTokenRecordGlobalState.update((emailTwoFactorTokenRecord) => {
                emailTwoFactorTokenRecord !== null && emailTwoFactorTokenRecord !== void 0 ? emailTwoFactorTokenRecord : (emailTwoFactorTokenRecord = {});
                delete emailTwoFactorTokenRecord[email];
                return emailTwoFactorTokenRecord;
            });
        });
    }
    // TODO: stop accepting optional userIds
    clearTokens(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserIdGlobalState.state$));
            if (!userId) {
                throw new Error("User id not found. Cannot clear tokens.");
            }
            yield Promise.all([
                this.clearAccessToken(userId),
                this.clearRefreshToken(userId),
                this.clearClientId(userId),
                this.clearClientSecret(userId),
            ]);
        });
    }
    // jwthelper methods
    // ref https://github.com/auth0/angular-jwt/blob/master/src/angularJwt/services/jwt.js
    decodeAccessToken(token) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            token = token !== null && token !== void 0 ? token : (yield this.getAccessToken());
            if (token == null) {
                throw new Error("Access token not found.");
            }
            return decodeJwtTokenToJson(token);
        });
    }
    // TODO: PM-6678- tech debt - consider consolidating the return types of all these access
    // token data retrieval methods to return null if something goes wrong instead of throwing an error.
    getTokenExpirationDate() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            let decoded;
            try {
                decoded = yield this.decodeAccessToken();
            }
            catch (error) {
                throw new Error("Failed to decode access token: " + error.message);
            }
            // per RFC, exp claim is optional but if it exists, it should be a number
            if (!decoded || typeof decoded.exp !== "number") {
                return null;
            }
            // The 0 in Date(0) is the key; it sets the date to the epoch
            const expirationDate = new Date(0);
            expirationDate.setUTCSeconds(decoded.exp);
            return expirationDate;
        });
    }
    tokenSecondsRemaining(offsetSeconds = 0) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const date = yield this.getTokenExpirationDate();
            if (date == null) {
                return 0;
            }
            const msRemaining = date.valueOf() - (new Date().valueOf() + offsetSeconds * 1000);
            return Math.round(msRemaining / 1000);
        });
    }
    tokenNeedsRefresh(minutes = 5) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const sRemaining = yield this.tokenSecondsRemaining();
            return sRemaining < 60 * minutes;
        });
    }
    getUserId() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            let decoded;
            try {
                decoded = yield this.decodeAccessToken();
            }
            catch (error) {
                throw new Error("Failed to decode access token: " + error.message);
            }
            if (!decoded || typeof decoded.sub !== "string") {
                throw new Error("No user id found");
            }
            return decoded.sub;
        });
    }
    getUserIdFromAccessToken(accessToken) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            let decoded;
            try {
                decoded = yield this.decodeAccessToken(accessToken);
            }
            catch (error) {
                throw new Error("Failed to decode access token: " + error.message);
            }
            if (!decoded || typeof decoded.sub !== "string") {
                throw new Error("No user id found");
            }
            return decoded.sub;
        });
    }
    getEmail() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            let decoded;
            try {
                decoded = yield this.decodeAccessToken();
            }
            catch (error) {
                throw new Error("Failed to decode access token: " + error.message);
            }
            if (!decoded || typeof decoded.email !== "string") {
                throw new Error("No email found");
            }
            return decoded.email;
        });
    }
    getEmailVerified() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            let decoded;
            try {
                decoded = yield this.decodeAccessToken();
            }
            catch (error) {
                throw new Error("Failed to decode access token: " + error.message);
            }
            if (!decoded || typeof decoded.email_verified !== "boolean") {
                throw new Error("No email verification found");
            }
            return decoded.email_verified;
        });
    }
    getName() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            let decoded;
            try {
                decoded = yield this.decodeAccessToken();
            }
            catch (error) {
                throw new Error("Failed to decode access token: " + error.message);
            }
            if (!decoded || typeof decoded.name !== "string") {
                return null;
            }
            return decoded.name;
        });
    }
    getIssuer() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            let decoded;
            try {
                decoded = yield this.decodeAccessToken();
            }
            catch (error) {
                throw new Error("Failed to decode access token: " + error.message);
            }
            if (!decoded || typeof decoded.iss !== "string") {
                throw new Error("No issuer found");
            }
            return decoded.iss;
        });
    }
    getIsExternal() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            let decoded;
            try {
                decoded = yield this.decodeAccessToken();
            }
            catch (error) {
                throw new Error("Failed to decode access token: " + error.message);
            }
            return Array.isArray(decoded.amr) && decoded.amr.includes("external");
        });
    }
    getStateValueByUserIdAndKeyDef(userId, storageLocation) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            // read from single user state provider
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.singleUserStateProvider.get(userId, storageLocation).state$);
        });
    }
    determineStorageLocation(vaultTimeoutAction, vaultTimeout, useSecureStorage) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            if (vaultTimeoutAction === VaultTimeoutAction.LogOut && vaultTimeout != null) {
                return TokenStorageLocation.Memory;
            }
            else {
                if (useSecureStorage && this.platformSupportsSecureStorage) {
                    return TokenStorageLocation.SecureStorage;
                }
                return TokenStorageLocation.Disk;
            }
        });
    }
    saveStringToSecureStorage(userId, storageKey, value) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.secureStorageService.save(`${userId}${storageKey}`, value, this.getSecureStorageOptions(userId));
        });
    }
    getStringFromSecureStorage(userId, storageKey) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            // If we have a user ID, read from secure storage.
            return yield this.secureStorageService.get(`${userId}${storageKey}`, this.getSecureStorageOptions(userId));
        });
    }
    getSecureStorageOptions(userId) {
        return {
            storageLocation: StorageLocation.Disk,
            useSecureStorage: true,
            userId: userId,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/two-factor.service.ts

const TwoFactorProviders = {
    [TwoFactorProviderType.Authenticator]: {
        type: TwoFactorProviderType.Authenticator,
        name: null,
        description: null,
        priority: 1,
        sort: 1,
        premium: false,
    },
    [TwoFactorProviderType.Yubikey]: {
        type: TwoFactorProviderType.Yubikey,
        name: null,
        description: null,
        priority: 3,
        sort: 2,
        premium: true,
    },
    [TwoFactorProviderType.Duo]: {
        type: TwoFactorProviderType.Duo,
        name: "Duo",
        description: null,
        priority: 2,
        sort: 3,
        premium: true,
    },
    [TwoFactorProviderType.OrganizationDuo]: {
        type: TwoFactorProviderType.OrganizationDuo,
        name: "Duo (Organization)",
        description: null,
        priority: 10,
        sort: 4,
        premium: false,
    },
    [TwoFactorProviderType.Email]: {
        type: TwoFactorProviderType.Email,
        name: null,
        description: null,
        priority: 0,
        sort: 6,
        premium: false,
    },
    [TwoFactorProviderType.WebAuthn]: {
        type: TwoFactorProviderType.WebAuthn,
        name: null,
        description: null,
        priority: 4,
        sort: 5,
        premium: false,
    },
};
class TwoFactorService {
    constructor(i18nService, platformUtilsService) {
        this.i18nService = i18nService;
        this.platformUtilsService = platformUtilsService;
        this.selectedTwoFactorProviderType = null;
    }
    init() {
        TwoFactorProviders[TwoFactorProviderType.Email].name = this.i18nService.t("emailTitle");
        TwoFactorProviders[TwoFactorProviderType.Email].description = this.i18nService.t("emailDesc");
        TwoFactorProviders[TwoFactorProviderType.Authenticator].name =
            this.i18nService.t("authenticatorAppTitle");
        TwoFactorProviders[TwoFactorProviderType.Authenticator].description =
            this.i18nService.t("authenticatorAppDesc");
        TwoFactorProviders[TwoFactorProviderType.Duo].description = this.i18nService.t("duoDesc");
        TwoFactorProviders[TwoFactorProviderType.OrganizationDuo].name =
            "Duo (" + this.i18nService.t("organization") + ")";
        TwoFactorProviders[TwoFactorProviderType.OrganizationDuo].description =
            this.i18nService.t("duoOrganizationDesc");
        TwoFactorProviders[TwoFactorProviderType.WebAuthn].name = this.i18nService.t("webAuthnTitle");
        TwoFactorProviders[TwoFactorProviderType.WebAuthn].description =
            this.i18nService.t("webAuthnDesc");
        TwoFactorProviders[TwoFactorProviderType.Yubikey].name = this.i18nService.t("yubiKeyTitle");
        TwoFactorProviders[TwoFactorProviderType.Yubikey].description =
            this.i18nService.t("yubiKeyDesc");
    }
    getSupportedProviders(win) {
        const providers = [];
        if (this.twoFactorProvidersData == null) {
            return providers;
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.OrganizationDuo) &&
            this.platformUtilsService.supportsDuo()) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.OrganizationDuo]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Authenticator)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Authenticator]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Yubikey)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Yubikey]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Duo) &&
            this.platformUtilsService.supportsDuo()) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Duo]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.WebAuthn) &&
            this.platformUtilsService.supportsWebAuthn(win)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.WebAuthn]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Email)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Email]);
        }
        return providers;
    }
    getDefaultProvider(webAuthnSupported) {
        if (this.twoFactorProvidersData == null) {
            return null;
        }
        if (this.selectedTwoFactorProviderType != null &&
            this.twoFactorProvidersData.has(this.selectedTwoFactorProviderType)) {
            return this.selectedTwoFactorProviderType;
        }
        let providerType = null;
        let providerPriority = -1;
        this.twoFactorProvidersData.forEach((_value, type) => {
            const provider = TwoFactorProviders[type];
            if (provider != null && provider.priority > providerPriority) {
                if (type === TwoFactorProviderType.WebAuthn && !webAuthnSupported) {
                    return;
                }
                providerType = type;
                providerPriority = provider.priority;
            }
        });
        return providerType;
    }
    setSelectedProvider(type) {
        this.selectedTwoFactorProviderType = type;
    }
    clearSelectedProvider() {
        this.selectedTwoFactorProviderType = null;
    }
    setProviders(response) {
        this.twoFactorProvidersData = response.twoFactorProviders2;
    }
    clearProviders() {
        this.twoFactorProvidersData = null;
    }
    getProviders() {
        return this.twoFactorProvidersData;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/user-verification/user-verification-api.service.ts
var user_verification_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class UserVerificationApiService {
    constructor(apiService) {
        this.apiService = apiService;
    }
    postAccountVerifyOTP(request) {
        return this.apiService.send("POST", "/accounts/verify-otp", request, true, false);
    }
    postAccountRequestOTP() {
        return user_verification_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/accounts/request-otp", null, true, false);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/verification-type.ts
var VerificationType;
(function (VerificationType) {
    VerificationType[VerificationType["MasterPassword"] = 0] = "MasterPassword";
    VerificationType[VerificationType["OTP"] = 1] = "OTP";
    VerificationType[VerificationType["PIN"] = 2] = "PIN";
    VerificationType[VerificationType["Biometrics"] = 3] = "Biometrics";
})(VerificationType || (VerificationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/verify-otp.request.ts
class VerifyOTPRequest {
    constructor(OTP) {
        this.OTP = OTP;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/types/verification.ts
function verificationHasSecret(verification) {
    return "secret" in verification;
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/user-verification/user-verification.service.ts
var user_verification_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






/**
 * Used for general-purpose user verification throughout the app.
 * Use it to verify the input collected by UserVerificationComponent.
 */
class UserVerificationService {
    constructor(stateService, cryptoService, accountService, masterPasswordService, i18nService, userVerificationApiService, userDecryptionOptionsService, pinCryptoService, logService, vaultTimeoutSettingsService, platformUtilsService) {
        this.stateService = stateService;
        this.cryptoService = cryptoService;
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.i18nService = i18nService;
        this.userVerificationApiService = userVerificationApiService;
        this.userDecryptionOptionsService = userDecryptionOptionsService;
        this.pinCryptoService = pinCryptoService;
        this.logService = logService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.platformUtilsService = platformUtilsService;
    }
    getAvailableVerificationOptions(verificationType) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            if (verificationType === "client") {
                const [userHasMasterPassword, pinLockType, biometricsLockSet, biometricsUserKeyStored] = yield Promise.all([
                    this.hasMasterPasswordAndMasterKeyHash(),
                    this.vaultTimeoutSettingsService.isPinLockSet(),
                    this.vaultTimeoutSettingsService.isBiometricLockSet(),
                    this.cryptoService.hasUserKeyStored(KeySuffixOptions.Biometric),
                ]);
                // note: we do not need to check this.platformUtilsService.supportsBiometric() because
                // we can just use the logic below which works for both desktop & the browser extension.
                return {
                    client: {
                        masterPassword: userHasMasterPassword,
                        pin: pinLockType !== "DISABLED",
                        biometrics: biometricsLockSet &&
                            (biometricsUserKeyStored || !this.platformUtilsService.supportsSecureStorage()),
                    },
                    server: {
                        masterPassword: false,
                        otp: false,
                    },
                };
            }
            else {
                // server
                // Don't check if have MP hash locally, because we are going to send the secret to the server to be verified.
                const userHasMasterPassword = yield this.hasMasterPassword();
                return {
                    client: {
                        masterPassword: false,
                        pin: false,
                        biometrics: false,
                    },
                    server: { masterPassword: userHasMasterPassword, otp: !userHasMasterPassword },
                };
            }
        });
    }
    /**
     * Create a new request model to be used for server-side verification
     * @param verification User-supplied verification data (Master Password or OTP)
     * @param requestClass The request model to create
     * @param alreadyHashed Whether the master password is already hashed
     */
    buildRequest(verification, requestClass, alreadyHashed) {
        var _a;
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            this.validateSecretInput(verification);
            const request = requestClass != null ? new requestClass() : new SecretVerificationRequest();
            if (verification.type === VerificationType.OTP) {
                request.otp = verification.secret;
            }
            else {
                const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
                let masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
                if (!masterKey && !alreadyHashed) {
                    masterKey = yield this.cryptoService.makeMasterKey(verification.secret, yield this.stateService.getEmail(), yield this.stateService.getKdfType(), yield this.stateService.getKdfConfig());
                }
                request.masterPasswordHash = alreadyHashed
                    ? verification.secret
                    : yield this.cryptoService.hashMasterKey(verification.secret, masterKey);
            }
            return request;
        });
    }
    /**
     * Used to verify Master Password, PIN, or biometrics client-side, or send the OTP to the server for verification (with no other data)
     * Generally used for client-side verification only.
     * @param verification User-supplied verification data (OTP, MP, PIN, or biometrics)
     */
    verifyUser(verification) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            if (verificationHasSecret(verification)) {
                this.validateSecretInput(verification);
            }
            switch (verification.type) {
                case VerificationType.OTP:
                    return this.verifyUserByOTP(verification);
                case VerificationType.MasterPassword:
                    return this.verifyUserByMasterPassword(verification);
                case VerificationType.PIN:
                    return this.verifyUserByPIN(verification);
                case VerificationType.Biometrics:
                    return this.verifyUserByBiometrics();
                default: {
                    // Compile-time check for exhaustive switch
                    const _exhaustiveCheck = verification;
                    return _exhaustiveCheck;
                }
            }
        });
    }
    verifyUserByOTP(verification) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            const request = new VerifyOTPRequest(verification.secret);
            try {
                yield this.userVerificationApiService.postAccountVerifyOTP(request);
            }
            catch (e) {
                throw new Error(this.i18nService.t("invalidVerificationCode"));
            }
            return true;
        });
    }
    verifyUserByMasterPassword(verification) {
        var _a;
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            const userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
            let masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            if (!masterKey) {
                masterKey = yield this.cryptoService.makeMasterKey(verification.secret, yield this.stateService.getEmail(), yield this.stateService.getKdfType(), yield this.stateService.getKdfConfig());
            }
            const passwordValid = yield this.cryptoService.compareAndUpdateKeyHash(verification.secret, masterKey);
            if (!passwordValid) {
                throw new Error(this.i18nService.t("invalidMasterPassword"));
            }
            // TODO: we should re-evaluate later on if user verification should have the side effect of modifying state. Probably not.
            yield this.masterPasswordService.setMasterKey(masterKey, userId);
            return true;
        });
    }
    verifyUserByPIN(verification) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield this.pinCryptoService.decryptUserKeyWithPin(verification.secret);
            return userKey != null;
        });
    }
    verifyUserByBiometrics() {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            let userKey;
            // Biometrics crashes and doesn't return a value if the user cancels the prompt
            try {
                userKey = yield this.cryptoService.getUserKeyFromStorage(KeySuffixOptions.Biometric);
            }
            catch (e) {
                this.logService.error(`Biometrics User Verification failed: ${e.message}`);
                // So, any failures should be treated as a failed verification
                return false;
            }
            return userKey != null;
        });
    }
    requestOTP() {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            yield this.userVerificationApiService.postAccountRequestOTP();
        });
    }
    /**
     * Check if user has master password or can only use passwordless technologies to log in
     * Note: This only checks the server, not the local state
     * @param userId The user id to check. If not provided, the current user is used
     * @returns True if the user has a master password
     * @deprecated Use UserDecryptionOptionsService.hasMasterPassword$ instead
     */
    hasMasterPassword(userId) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            if (userId) {
                const decryptionOptions = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.userDecryptionOptionsService.userDecryptionOptionsById$(userId));
                if ((decryptionOptions === null || decryptionOptions === void 0 ? void 0 : decryptionOptions.hasMasterPassword) != undefined) {
                    return decryptionOptions.hasMasterPassword;
                }
            }
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.userDecryptionOptionsService.hasMasterPassword$);
        });
    }
    hasMasterPasswordAndMasterKeyHash(userId) {
        var _a;
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id);
            return ((yield this.hasMasterPassword(userId)) &&
                (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKeyHash$(userId))) != null);
        });
    }
    validateSecretInput(verification) {
        if ((verification === null || verification === void 0 ? void 0 : verification.secret) == null || verification.secret === "") {
            switch (verification.type) {
                case VerificationType.OTP:
                    throw new Error(this.i18nService.t("verificationCodeRequired"));
                case VerificationType.MasterPassword:
                    throw new Error(this.i18nService.t("masterPasswordRequired"));
                case VerificationType.PIN:
                    throw new Error(this.i18nService.t("pinRequired"));
            }
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/domain-service.ts
/*
  See full documentation at:
    https://bitwarden.com/help/uri-match-detection/#match-detection-options

  Domain: "the top-level domain and second-level domain of the URI match the detected resource",
  Host: "the hostname and (if specified) port of the URI matches the detected resource",
  StartsWith: "the detected resource starts with the URI, regardless of what follows it",
  Exact: "the URI matches the detected resource exactly",
  RegularExpression: "the detected resource matches a specified regular expression",
  Never: "never offer auto-fill for the item",
*/
const UriMatchStrategy = {
    Domain: 0,
    Host: 1,
    StartsWith: 2,
    Exact: 3,
    RegularExpression: 4,
    Never: 5,
};

;// CONCATENATED MODULE: ../../libs/common/src/autofill/services/domain-settings.service.ts
var domain_settings_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




const SHOW_FAVICONS = new KeyDefinition(DOMAIN_SETTINGS_DISK, "showFavicons", {
    deserializer: (value) => value !== null && value !== void 0 ? value : true,
});
const NEVER_DOMAINS = new KeyDefinition(DOMAIN_SETTINGS_DISK, "neverDomains", {
    deserializer: (value) => value !== null && value !== void 0 ? value : null,
});
const EQUIVALENT_DOMAINS = new UserKeyDefinition(DOMAIN_SETTINGS_DISK, "equivalentDomains", {
    deserializer: (value) => value !== null && value !== void 0 ? value : null,
    clearOn: ["logout"],
});
const DEFAULT_URI_MATCH_STRATEGY = new UserKeyDefinition(DOMAIN_SETTINGS_DISK, "defaultUriMatchStrategy", {
    deserializer: (value) => value !== null && value !== void 0 ? value : UriMatchStrategy.Domain,
    clearOn: [],
});
class DomainSettingsService {
}
class DefaultDomainSettingsService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
        this.showFaviconsState = this.stateProvider.getGlobal(SHOW_FAVICONS);
        this.showFavicons$ = this.showFaviconsState.state$.pipe((0,external_rxjs_namespaceObject.map)((x) => x !== null && x !== void 0 ? x : true));
        this.neverDomainsState = this.stateProvider.getGlobal(NEVER_DOMAINS);
        this.neverDomains$ = this.neverDomainsState.state$.pipe((0,external_rxjs_namespaceObject.map)((x) => x !== null && x !== void 0 ? x : null));
        this.equivalentDomainsState = this.stateProvider.getActive(EQUIVALENT_DOMAINS);
        this.equivalentDomains$ = this.equivalentDomainsState.state$.pipe((0,external_rxjs_namespaceObject.map)((x) => x !== null && x !== void 0 ? x : null));
        this.defaultUriMatchStrategyState = this.stateProvider.getActive(DEFAULT_URI_MATCH_STRATEGY);
        this.defaultUriMatchStrategy$ = this.defaultUriMatchStrategyState.state$.pipe((0,external_rxjs_namespaceObject.map)((x) => x !== null && x !== void 0 ? x : UriMatchStrategy.Domain));
    }
    setShowFavicons(newValue) {
        return domain_settings_service_awaiter(this, void 0, void 0, function* () {
            yield this.showFaviconsState.update(() => newValue);
        });
    }
    setNeverDomains(newValue) {
        return domain_settings_service_awaiter(this, void 0, void 0, function* () {
            yield this.neverDomainsState.update(() => newValue);
        });
    }
    setEquivalentDomains(newValue) {
        return domain_settings_service_awaiter(this, void 0, void 0, function* () {
            yield this.equivalentDomainsState.update(() => newValue);
        });
    }
    setDefaultUriMatchStrategy(newValue) {
        return domain_settings_service_awaiter(this, void 0, void 0, function* () {
            yield this.defaultUriMatchStrategyState.update(() => newValue);
        });
    }
    getUrlEquivalentDomains(url) {
        const domains$ = this.equivalentDomains$.pipe((0,external_rxjs_namespaceObject.map)((equivalentDomains) => {
            const domain = Utils.getDomain(url);
            if (domain == null || equivalentDomains == null) {
                return new Set();
            }
            const equivalents = equivalentDomains.filter((ed) => ed.includes(domain)).flat();
            return new Set(equivalents);
        }));
        return domains$;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/services/account/billing-account-profile-state.service.ts
var billing_account_profile_state_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const BILLING_ACCOUNT_PROFILE_KEY_DEFINITION = new UserKeyDefinition(BILLING_DISK, "accountProfile", {
    deserializer: (billingAccountProfile) => billingAccountProfile,
    clearOn: ["logout"],
});
class DefaultBillingAccountProfileStateService {
    constructor(stateProvider) {
        this.billingAccountProfileState = stateProvider.getActive(BILLING_ACCOUNT_PROFILE_KEY_DEFINITION);
        // Setup an observable that will always track the currently active user
        // but will fallback to emitting null when there is no active user.
        const billingAccountProfileOrNull = stateProvider.activeUserId$.pipe((0,external_rxjs_namespaceObject.switchMap)((userId) => userId != null
            ? stateProvider.getUser(userId, BILLING_ACCOUNT_PROFILE_KEY_DEFINITION).state$
            : (0,external_rxjs_namespaceObject.of)(null)));
        this.hasPremiumFromAnyOrganization$ = billingAccountProfileOrNull.pipe((0,external_rxjs_namespaceObject.map)((billingAccountProfile) => !!(billingAccountProfile === null || billingAccountProfile === void 0 ? void 0 : billingAccountProfile.hasPremiumFromAnyOrganization)));
        this.hasPremiumPersonally$ = billingAccountProfileOrNull.pipe((0,external_rxjs_namespaceObject.map)((billingAccountProfile) => !!(billingAccountProfile === null || billingAccountProfile === void 0 ? void 0 : billingAccountProfile.hasPremiumPersonally)));
        this.hasPremiumFromAnySource$ = billingAccountProfileOrNull.pipe((0,external_rxjs_namespaceObject.map)((billingAccountProfile) => (billingAccountProfile === null || billingAccountProfile === void 0 ? void 0 : billingAccountProfile.hasPremiumFromAnyOrganization) === true ||
            (billingAccountProfile === null || billingAccountProfile === void 0 ? void 0 : billingAccountProfile.hasPremiumPersonally) === true));
    }
    setHasPremium(hasPremiumPersonally, hasPremiumFromAnyOrganization) {
        return billing_account_profile_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.billingAccountProfileState.update((billingAccountProfile) => {
                return {
                    hasPremiumPersonally: hasPremiumPersonally,
                    hasPremiumFromAnyOrganization: hasPremiumFromAnyOrganization,
                };
            });
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/biometrics/biometric.state.ts

/**
 * Indicates whether the user elected to store a biometric key to unlock their vault.
 */
const BIOMETRIC_UNLOCK_ENABLED = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "biometricUnlockEnabled", {
    deserializer: (obj) => obj,
    clearOn: [],
});
/**
 * Boolean indicating the user has elected to require a password to use their biometric key upon starting the application.
 *
 * A true setting controls whether {@link ENCRYPTED_CLIENT_KEY_HALF} is set.
 */
const REQUIRE_PASSWORD_ON_START = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "requirePasswordOnStart", {
    deserializer: (value) => value,
    clearOn: [],
});
/**
 * If the user has elected to require a password on first unlock of an application instance, this key will store the
 * encrypted client key half used to unlock the vault.
 *
 * For operating systems without application-level key storage, this key half is concatenated with a signature
 * provided by the OS and used to encrypt the biometric key prior to storage.
 */
const ENCRYPTED_CLIENT_KEY_HALF = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "clientKeyHalf", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
/**
 * Indicates the user has been warned about the security implications of using biometrics and, depending on the OS,
 * recommended to require a password on first unlock of an application instance.
 */
const DISMISSED_REQUIRE_PASSWORD_ON_START_CALLOUT = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "dismissedBiometricRequirePasswordOnStartCallout", {
    deserializer: (obj) => obj,
    clearOn: [],
});
/**
 * Stores whether the user has elected to cancel the biometric prompt. This is stored on disk due to process-reload
 * wiping memory state. We don't want to prompt the user again if they've elected to cancel.
 */
const PROMPT_CANCELLED = KeyDefinition.record(BIOMETRIC_SETTINGS_DISK, "promptCancelled", {
    deserializer: (obj) => obj,
});
/**
 * Stores whether the user has elected to automatically prompt for biometric unlock on application start.
 */
const PROMPT_AUTOMATICALLY = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "promptAutomatically", {
    deserializer: (obj) => obj,
    clearOn: [],
});
/**
 * Stores whether or not IPC handshake has been validated this session.
 */
const FINGERPRINT_VALIDATED = new KeyDefinition(BIOMETRIC_SETTINGS_DISK, "fingerprintValidated", {
    deserializer: (obj) => obj,
});

;// CONCATENATED MODULE: ../../libs/common/src/platform/biometrics/biometric-state.service.ts
var biometric_state_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class BiometricStateService {
}
class DefaultBiometricStateService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
        this.biometricUnlockEnabledState = this.stateProvider.getActive(BIOMETRIC_UNLOCK_ENABLED);
        this.biometricUnlockEnabled$ = this.biometricUnlockEnabledState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.requirePasswordOnStartState = this.stateProvider.getActive(REQUIRE_PASSWORD_ON_START);
        this.requirePasswordOnStart$ = this.requirePasswordOnStartState.state$.pipe((0,external_rxjs_namespaceObject.map)((value) => !!value));
        this.encryptedClientKeyHalfState = this.stateProvider.getActive(ENCRYPTED_CLIENT_KEY_HALF);
        this.encryptedClientKeyHalf$ = this.encryptedClientKeyHalfState.state$.pipe((0,external_rxjs_namespaceObject.map)(encryptedClientKeyHalfToEncString));
        this.dismissedRequirePasswordOnStartCalloutState = this.stateProvider.getActive(DISMISSED_REQUIRE_PASSWORD_ON_START_CALLOUT);
        this.dismissedRequirePasswordOnStartCallout$ =
            this.dismissedRequirePasswordOnStartCalloutState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.promptCancelledState = this.stateProvider.getGlobal(PROMPT_CANCELLED);
        this.promptCancelled$ = (0,external_rxjs_namespaceObject.combineLatest)([
            this.stateProvider.activeUserId$,
            this.promptCancelledState.state$,
        ]).pipe((0,external_rxjs_namespaceObject.map)(([userId, record]) => {
            var _a;
            return (_a = record === null || record === void 0 ? void 0 : record[userId]) !== null && _a !== void 0 ? _a : false;
        }));
        this.promptAutomaticallyState = this.stateProvider.getActive(PROMPT_AUTOMATICALLY);
        this.promptAutomatically$ = this.promptAutomaticallyState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.fingerprintValidatedState = this.stateProvider.getGlobal(FINGERPRINT_VALIDATED);
        this.fingerprintValidated$ = this.fingerprintValidatedState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
    }
    setBiometricUnlockEnabled(enabled) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.biometricUnlockEnabledState.update(() => enabled);
        });
    }
    getBiometricUnlockEnabled(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, BIOMETRIC_UNLOCK_ENABLED).state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean)));
        });
    }
    setRequirePasswordOnStart(value) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            let currentActiveId;
            yield this.requirePasswordOnStartState.update((_, [userId]) => {
                currentActiveId = userId;
                return value;
            }, {
                combineLatestWith: this.requirePasswordOnStartState.combinedState$,
            });
            if (!value) {
                yield this.removeEncryptedClientKeyHalf(currentActiveId);
            }
        });
    }
    setEncryptedClientKeyHalf(encryptedKeyHalf, userId) {
        var _a;
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            const value = (_a = encryptedKeyHalf === null || encryptedKeyHalf === void 0 ? void 0 : encryptedKeyHalf.encryptedString) !== null && _a !== void 0 ? _a : null;
            if (userId) {
                yield this.stateProvider.getUser(userId, ENCRYPTED_CLIENT_KEY_HALF).update(() => value);
            }
            else {
                yield this.encryptedClientKeyHalfState.update(() => value);
            }
        });
    }
    removeEncryptedClientKeyHalf(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.getUser(userId, ENCRYPTED_CLIENT_KEY_HALF).update(() => null);
        });
    }
    getRequirePasswordOnStart(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            return !!(yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, REQUIRE_PASSWORD_ON_START).state$));
        });
    }
    getEncryptedClientKeyHalf(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider
                .getUser(userId, ENCRYPTED_CLIENT_KEY_HALF)
                .state$.pipe((0,external_rxjs_namespaceObject.map)(encryptedClientKeyHalfToEncString)));
        });
    }
    logout(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.getUser(userId, ENCRYPTED_CLIENT_KEY_HALF).update(() => null);
            yield this.resetUserPromptCancelled(userId);
            // Persist auto prompt setting through logout
            // Persist dismissed require password on start callout through logout
        });
    }
    setDismissedRequirePasswordOnStartCallout() {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.dismissedRequirePasswordOnStartCalloutState.update(() => true);
        });
    }
    resetUserPromptCancelled(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.getGlobal(PROMPT_CANCELLED).update((data, activeUserId) => {
                delete data[userId !== null && userId !== void 0 ? userId : activeUserId];
                return data;
            }, {
                combineLatestWith: this.stateProvider.activeUserId$,
                shouldUpdate: (data, activeUserId) => (data === null || data === void 0 ? void 0 : data[userId !== null && userId !== void 0 ? userId : activeUserId]) != null,
            });
        });
    }
    setUserPromptCancelled() {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.promptCancelledState.update((record, userId) => {
                record !== null && record !== void 0 ? record : (record = {});
                record[userId] = true;
                return record;
            }, {
                combineLatestWith: this.stateProvider.activeUserId$,
                shouldUpdate: (_, userId) => {
                    if (userId == null) {
                        throw new Error("Cannot update biometric prompt cancelled state without an active user");
                    }
                    return true;
                },
            });
        });
    }
    resetAllPromptCancelled() {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.promptCancelledState.update(() => null);
        });
    }
    setPromptAutomatically(prompt) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.promptAutomaticallyState.update(() => prompt);
        });
    }
    setFingerprintValidated(validated) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.fingerprintValidatedState.update(() => validated);
        });
    }
}
function encryptedClientKeyHalfToEncString(encryptedKeyHalf) {
    return encryptedKeyHalf == null ? null : new EncString(encryptedKeyHalf);
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/factories/account-factory.ts
class AccountFactory {
    constructor(accountConstructor) {
        this.accountConstructor = accountConstructor;
    }
    create(args) {
        return new this.accountConstructor(args);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/factories/global-state-factory.ts
class GlobalStateFactory {
    constructor(globalStateConstructor) {
        this.globalStateConstructor = globalStateConstructor;
    }
    create(args) {
        return new this.globalStateConstructor(args);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/factories/state-factory.ts


class StateFactory {
    constructor(globalStateConstructor, accountConstructor) {
        this.globalStateFactory = new GlobalStateFactory(globalStateConstructor);
        this.accountFactory = new AccountFactory(accountConstructor);
    }
    createGlobal(args) {
        return this.globalStateFactory.create(args);
    }
    createAccount(args) {
        return this.accountFactory.create(args);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/messaging/message.listener.ts

/**
 * A class that allows for listening to messages coming through the application,
 * allows for listening of all messages or just the messages you care about.
 *
 * @note Consider NOT using messaging at all if you can. State Providers offer an observable stream of
 * data that is persisted. This can serve messages that might have been used to notify of settings changes
 * or vault data changes and those observables should be preferred over messaging.
 */
class MessageListener {
    constructor(messageStream) {
        this.messageStream = messageStream;
        /**
         * A stream of all messages sent through the application. It does not contain type information for the
         * other properties on the messages. You are encouraged to instead subscribe to an individual message
         * through {@link messages$}.
         */
        this.allMessages$ = this.messageStream;
    }
    /**
     * Creates an observable stream filtered to just the command given via the {@link CommandDefinition} and typed
     * to the generic contained in the CommandDefinition. Be careful using this method unless all your messages are being
     * sent through `MessageSender.send`, if that isn't the case you should have lower confidence in the message
     * payload being the expected type.
     *
     * @param commandDefinition The CommandDefinition containing the information about the message type you care about.
     */
    messages$(commandDefinition) {
        return this.allMessages$.pipe((0,external_rxjs_namespaceObject.filter)((msg) => (msg === null || msg === void 0 ? void 0 : msg.command) === commandDefinition.command));
    }
}
/**
 * A helper property for returning a MessageListener that will never emit any messages and will immediately complete.
 */
MessageListener.EMPTY = new MessageListener(external_rxjs_namespaceObject.EMPTY);

;// CONCATENATED MODULE: ../../libs/common/src/platform/messaging/message.sender.ts
class MultiMessageSender {
    constructor(innerMessageSenders) {
        this.innerMessageSenders = innerMessageSenders;
    }
    send(commandDefinition, payload = {}) {
        for (const messageSender of this.innerMessageSenders) {
            messageSender.send(commandDefinition, payload);
        }
    }
}
class MessageSender {
    /**
     * A helper method for combine multiple {@link MessageSender}'s.
     * @param messageSenders The message senders that should be combined.
     * @returns A message sender that will relay all messages to the given message senders.
     */
    static combine(...messageSenders) {
        return new MultiMessageSender(messageSenders);
    }
}
/**
 * A helper property for creating a {@link MessageSender} that sends to nowhere.
 */
MessageSender.EMPTY = new MultiMessageSender([]);

;// CONCATENATED MODULE: ../../libs/common/src/platform/messaging/helpers.ts

const getCommand = (commandDefinition) => {
    if (typeof commandDefinition === "string") {
        return commandDefinition;
    }
    else {
        return commandDefinition.command;
    }
};
const EXTERNAL_SOURCE_TAG = Symbol("externalSource");
const isExternalMessage = (message) => {
    return (message === null || message === void 0 ? void 0 : message[EXTERNAL_SOURCE_TAG]) === true;
};
const tagAsExternal = (0,external_rxjs_namespaceObject.map)((message) => {
    return Object.assign(message, { [EXTERNAL_SOURCE_TAG]: true });
});

;// CONCATENATED MODULE: ../../libs/common/src/platform/messaging/index.ts





;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/global-state.ts
class GlobalState {
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/app-id.service.ts
var app_id_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const APP_ID_KEY = new KeyDefinition(APPLICATION_ID_DISK, "appId", {
    deserializer: (value) => value,
});
const ANONYMOUS_APP_ID_KEY = new KeyDefinition(APPLICATION_ID_DISK, "anonymousAppId", {
    deserializer: (value) => value,
});
class AppIdService {
    constructor(globalStateProvider) {
        const appIdState = globalStateProvider.get(APP_ID_KEY);
        const anonymousAppIdState = globalStateProvider.get(ANONYMOUS_APP_ID_KEY);
        this.appId$ = appIdState.state$.pipe((0,external_rxjs_namespaceObject.tap)((appId) => app_id_service_awaiter(this, void 0, void 0, function* () {
            if (!appId) {
                yield appIdState.update(() => Utils.newGuid());
            }
        })), (0,external_rxjs_namespaceObject.filter)((appId) => !!appId));
        this.anonymousAppId$ = anonymousAppIdState.state$.pipe((0,external_rxjs_namespaceObject.tap)((appId) => app_id_service_awaiter(this, void 0, void 0, function* () {
            if (!appId) {
                yield anonymousAppIdState.update(() => Utils.newGuid());
            }
        })), (0,external_rxjs_namespaceObject.filter)((appId) => !!appId));
    }
    getAppId() {
        return app_id_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.appId$);
        });
    }
    getAnonymousAppId() {
        return app_id_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.anonymousAppId$);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/response/server-config.response.ts

class ServerConfigResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.featureStates = {};
        if (response == null) {
            return;
        }
        this.version = this.getResponseProperty("Version");
        this.gitHash = this.getResponseProperty("GitHash");
        this.server = new ThirdPartyServerConfigResponse(this.getResponseProperty("Server"));
        this.environment = new EnvironmentServerConfigResponse(this.getResponseProperty("Environment"));
        this.featureStates = this.getResponseProperty("FeatureStates");
    }
}
class EnvironmentServerConfigResponse extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.cloudRegion = this.getResponseProperty("CloudRegion");
        this.vault = this.getResponseProperty("Vault");
        this.api = this.getResponseProperty("Api");
        this.identity = this.getResponseProperty("Identity");
        this.notifications = this.getResponseProperty("Notifications");
        this.sso = this.getResponseProperty("Sso");
    }
}
class ThirdPartyServerConfigResponse extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.name = this.getResponseProperty("Name");
        this.url = this.getResponseProperty("Url");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/config/config-api.service.ts
var config_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class ConfigApiService {
    constructor(apiService, tokenService) {
        this.apiService = apiService;
        this.tokenService = tokenService;
    }
    get(userId) {
        return config_api_service_awaiter(this, void 0, void 0, function* () {
            // Authentication adds extra context to config responses, if the user has an access token, we want to use it
            // We don't particularly care about ensuring the token is valid and not expired, just that it exists
            const authed = userId == null ? false : (yield this.tokenService.getAccessToken(userId)) != null;
            const r = yield this.apiService.send("GET", "/config", null, authed, true);
            return new ServerConfigResponse(r);
        });
    }
}

;// CONCATENATED MODULE: external "semver"
const external_semver_namespaceObject = require("semver");
;// CONCATENATED MODULE: ../../libs/common/src/platform/abstractions/config/server-config.ts
const dayInMilliseconds = 24 * 3600 * 1000;
class ServerConfig {
    constructor(serverConfigData) {
        var _a, _b;
        this.featureStates = {};
        this.version = serverConfigData.version;
        this.gitHash = serverConfigData.gitHash;
        this.server = serverConfigData.server;
        this.utcDate = new Date(serverConfigData.utcDate);
        this.environment = serverConfigData.environment;
        this.featureStates = serverConfigData.featureStates;
        if (((_a = this.server) === null || _a === void 0 ? void 0 : _a.name) == null && ((_b = this.server) === null || _b === void 0 ? void 0 : _b.url) == null) {
            this.server = null;
        }
    }
    getAgeInMilliseconds() {
        var _a;
        return new Date().getTime() - ((_a = this.utcDate) === null || _a === void 0 ? void 0 : _a.getTime());
    }
    isValid() {
        return this.getAgeInMilliseconds() <= dayInMilliseconds;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return new ServerConfig(obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/abstractions/environment.service.ts
/**
 * A subset of available regions, additional regions can be loaded through configuration.
 */
var Region;
(function (Region) {
    Region["US"] = "US";
    Region["EU"] = "EU";
    Region["SelfHosted"] = "Self-hosted";
})(Region || (Region = {}));
/**
 * The environment service. Provides access to set the current environment urls and region.
 */
class EnvironmentService {
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/data/server-config.data.ts
class ServerConfigData {
    constructor(serverConfigResponse) {
        this.featureStates = {};
        this.version = serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.version;
        this.gitHash = serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.gitHash;
        this.server = (serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.server)
            ? new ThirdPartyServerConfigData(serverConfigResponse.server)
            : null;
        this.utcDate = new Date().toISOString();
        this.environment = (serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.environment)
            ? new EnvironmentServerConfigData(serverConfigResponse.environment)
            : null;
        this.featureStates = serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.featureStates;
    }
    static fromJSON(obj) {
        return Object.assign(new ServerConfigData({}), obj, {
            server: (obj === null || obj === void 0 ? void 0 : obj.server) ? ThirdPartyServerConfigData.fromJSON(obj.server) : null,
            environment: (obj === null || obj === void 0 ? void 0 : obj.environment) ? EnvironmentServerConfigData.fromJSON(obj.environment) : null,
        });
    }
}
class ThirdPartyServerConfigData {
    constructor(response) {
        this.name = response.name;
        this.url = response.url;
    }
    static fromJSON(obj) {
        return Object.assign(new ThirdPartyServerConfigData({}), obj);
    }
}
class EnvironmentServerConfigData {
    constructor(response) {
        this.cloudRegion = response.cloudRegion;
        this.vault = response.vault;
        this.api = response.api;
        this.identity = response.identity;
        this.notifications = response.notifications;
        this.sso = response.sso;
    }
    static fromJSON(obj) {
        return Object.assign(new EnvironmentServerConfigData({}), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/config/default-config.service.ts
var default_config_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






const RETRIEVAL_INTERVAL = 3600000; // 1 hour
const USER_SERVER_CONFIG = new UserKeyDefinition(CONFIG_DISK, "serverConfig", {
    deserializer: (data) => (data == null ? null : ServerConfig.fromJSON(data)),
    clearOn: ["logout"],
});
const GLOBAL_SERVER_CONFIGURATIONS = KeyDefinition.record(CONFIG_DISK, "byServer", {
    deserializer: (data) => (data == null ? null : ServerConfig.fromJSON(data)),
});
// FIXME: currently we are limited to api requests for active users. Update to accept a UserId and APIUrl once ApiService supports it.
class DefaultConfigService {
    constructor(configApiService, environmentService, logService, stateProvider) {
        this.configApiService = configApiService;
        this.environmentService = environmentService;
        this.logService = logService;
        this.stateProvider = stateProvider;
        this.failedFetchFallbackSubject = new external_rxjs_namespaceObject.Subject();
        const apiUrl$ = this.environmentService.environment$.pipe((0,external_rxjs_namespaceObject.map)((environment) => environment.getApiUrl()));
        this.serverConfig$ = (0,external_rxjs_namespaceObject.combineLatest)([this.stateProvider.activeUserId$, apiUrl$]).pipe((0,external_rxjs_namespaceObject.switchMap)(([userId, apiUrl]) => {
            const config$ = userId == null ? this.globalConfigFor$(apiUrl) : this.userConfigFor$(userId);
            return config$.pipe((0,external_rxjs_namespaceObject.map)((config) => [config, userId, apiUrl]));
        }), (0,external_rxjs_namespaceObject.tap)((rec) => default_config_service_awaiter(this, void 0, void 0, function* () {
            const [existingConfig, userId, apiUrl] = rec;
            // Grab new config if older retrieval interval
            if (!existingConfig || this.olderThanRetrievalInterval(existingConfig.utcDate)) {
                yield this.renewConfig(existingConfig, userId, apiUrl);
            }
        })), (0,external_rxjs_namespaceObject.switchMap)(([existingConfig]) => {
            // If we needed to fetch, stop this emit, we'll get a new one after update
            // This is split up with the above tap because we need to return an observable from a failed promise,
            // which isn't very doable since promises are converted to observables in switchMap
            if (!existingConfig || this.olderThanRetrievalInterval(existingConfig.utcDate)) {
                return external_rxjs_namespaceObject.NEVER;
            }
            return (0,external_rxjs_namespaceObject.of)(existingConfig);
        }), 
        // If fetch fails, we'll emit on this subject to fallback to the existing config
        (0,external_rxjs_namespaceObject.mergeWith)(this.failedFetchFallbackSubject), (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
        this.cloudRegion$ = this.serverConfig$.pipe((0,external_rxjs_namespaceObject.map)((config) => { var _a, _b; return (_b = (_a = config === null || config === void 0 ? void 0 : config.environment) === null || _a === void 0 ? void 0 : _a.cloudRegion) !== null && _b !== void 0 ? _b : Region.US; }));
    }
    getFeatureFlag$(key, defaultValue) {
        return this.serverConfig$.pipe((0,external_rxjs_namespaceObject.map)((serverConfig) => {
            if ((serverConfig === null || serverConfig === void 0 ? void 0 : serverConfig.featureStates) == null || serverConfig.featureStates[key] == null) {
                return defaultValue;
            }
            return serverConfig.featureStates[key];
        }));
    }
    getFeatureFlag(key, defaultValue) {
        return default_config_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.getFeatureFlag$(key, defaultValue));
        });
    }
    checkServerMeetsVersionRequirement$(minimumRequiredServerVersion) {
        return this.serverConfig$.pipe((0,external_rxjs_namespaceObject.map)((serverConfig) => {
            if (serverConfig == null) {
                return false;
            }
            const serverVersion = new external_semver_namespaceObject.SemVer(serverConfig.version);
            return serverVersion.compare(minimumRequiredServerVersion) >= 0;
        }));
    }
    ensureConfigFetched() {
        return default_config_service_awaiter(this, void 0, void 0, function* () {
            // Triggering a retrieval for the given user ensures that the config is less than RETRIEVAL_INTERVAL old
            yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.serverConfig$);
        });
    }
    olderThanRetrievalInterval(date) {
        return new Date().getTime() - date.getTime() > RETRIEVAL_INTERVAL;
    }
    // Updates the on-disk configuration with a newly retrieved configuration
    renewConfig(existingConfig, userId, apiUrl) {
        var _a, _b, _c;
        return default_config_service_awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield this.configApiService.get(userId);
                const newConfig = new ServerConfig(new ServerConfigData(response));
                // Update the environment region
                if (((_a = newConfig === null || newConfig === void 0 ? void 0 : newConfig.environment) === null || _a === void 0 ? void 0 : _a.cloudRegion) != null &&
                    ((_b = existingConfig === null || existingConfig === void 0 ? void 0 : existingConfig.environment) === null || _b === void 0 ? void 0 : _b.cloudRegion) != newConfig.environment.cloudRegion) {
                    // Null userId sets global, otherwise sets to the given user
                    yield this.environmentService.setCloudRegion(userId, (_c = newConfig === null || newConfig === void 0 ? void 0 : newConfig.environment) === null || _c === void 0 ? void 0 : _c.cloudRegion);
                }
                if (userId == null) {
                    // update global state with new pulled config
                    yield this.stateProvider.getGlobal(GLOBAL_SERVER_CONFIGURATIONS).update((configs) => {
                        return Object.assign(Object.assign({}, configs), { [apiUrl]: newConfig });
                    });
                }
                else {
                    // update state with new pulled config
                    yield this.stateProvider.setUserState(USER_SERVER_CONFIG, newConfig, userId);
                }
            }
            catch (e) {
                // mutate error to be handled by catchError
                this.logService.error(`Unable to fetch ServerConfig from ${apiUrl}: ${e === null || e === void 0 ? void 0 : e.message}`);
                // Emit the existing config
                this.failedFetchFallbackSubject.next(existingConfig);
            }
        });
    }
    globalConfigFor$(apiUrl) {
        return this.stateProvider
            .getGlobal(GLOBAL_SERVER_CONFIGURATIONS)
            .state$.pipe((0,external_rxjs_namespaceObject.map)((configs) => configs === null || configs === void 0 ? void 0 : configs[apiUrl]));
    }
    userConfigFor$(userId) {
        return this.stateProvider.getUser(userId, USER_SERVER_CONFIG).state$;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/container.service.ts
class ContainerService {
    constructor(cryptoService, encryptService) {
        this.cryptoService = cryptoService;
        this.encryptService = encryptService;
    }
    attachToGlobal(global) {
        if (!global.bitwardenContainerService) {
            global.bitwardenContainerService = this;
        }
    }
    /**
     * @throws Will throw if CryptoService was not instantiated and provided to the ContainerService constructor
     */
    getCryptoService() {
        if (this.cryptoService == null) {
            throw new Error("ContainerService.cryptoService not initialized.");
        }
        return this.cryptoService;
    }
    /**
     * @throws Will throw if EncryptService was not instantiated and provided to the ContainerService constructor
     */
    getEncryptService() {
        if (this.encryptService == null) {
            throw new Error("ContainerService.encryptService not initialized.");
        }
        return this.encryptService;
    }
}

;// CONCATENATED MODULE: external "big-integer"
const external_big_integer_namespaceObject = require("big-integer");
;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/sequentialize.ts
/**
 * Use as a Decorator on async functions, it will prevent multiple 'active' calls as the same time
 *
 * If a promise was returned from a previous call to this function, that hasn't yet resolved it will
 * be returned, instead of calling the original function again
 *
 * Results are not cached, once the promise has returned, the next call will result in a fresh call
 *
 * Read more at https://github.com/bitwarden/jslib/pull/7
 */
function sequentialize(cacheKey) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        const caches = new Map();
        const getCache = (obj) => {
            let cache = caches.get(obj);
            if (cache != null) {
                return cache;
            }
            cache = new Map();
            caches.set(obj, cache);
            return cache;
        };
        return {
            value: function (...args) {
                const cache = getCache(this);
                const argsCacheKey = cacheKey(args);
                let response = cache.get(argsCacheKey);
                if (response != null) {
                    return response;
                }
                const onFinally = () => {
                    cache.delete(argsCacheKey);
                    if (cache.size === 0) {
                        caches.delete(this);
                    }
                };
                response = originalMethod
                    .apply(this, args)
                    .then((val) => {
                    onFinally();
                    return val;
                })
                    .catch((err) => {
                    onFinally();
                    throw err;
                });
                cache.set(argsCacheKey, response);
                return response;
            },
        };
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/wordlist.ts
// EFF's Long Wordlist from https://www.eff.org/dice
const EFFLongWordList = [
    "abacus",
    "abdomen",
    "abdominal",
    "abide",
    "abiding",
    "ability",
    "ablaze",
    "able",
    "abnormal",
    "abrasion",
    "abrasive",
    "abreast",
    "abridge",
    "abroad",
    "abruptly",
    "absence",
    "absentee",
    "absently",
    "absinthe",
    "absolute",
    "absolve",
    "abstain",
    "abstract",
    "absurd",
    "accent",
    "acclaim",
    "acclimate",
    "accompany",
    "account",
    "accuracy",
    "accurate",
    "accustom",
    "acetone",
    "achiness",
    "aching",
    "acid",
    "acorn",
    "acquaint",
    "acquire",
    "acre",
    "acrobat",
    "acronym",
    "acting",
    "action",
    "activate",
    "activator",
    "active",
    "activism",
    "activist",
    "activity",
    "actress",
    "acts",
    "acutely",
    "acuteness",
    "aeration",
    "aerobics",
    "aerosol",
    "aerospace",
    "afar",
    "affair",
    "affected",
    "affecting",
    "affection",
    "affidavit",
    "affiliate",
    "affirm",
    "affix",
    "afflicted",
    "affluent",
    "afford",
    "affront",
    "aflame",
    "afloat",
    "aflutter",
    "afoot",
    "afraid",
    "afterglow",
    "afterlife",
    "aftermath",
    "aftermost",
    "afternoon",
    "aged",
    "ageless",
    "agency",
    "agenda",
    "agent",
    "aggregate",
    "aghast",
    "agile",
    "agility",
    "aging",
    "agnostic",
    "agonize",
    "agonizing",
    "agony",
    "agreeable",
    "agreeably",
    "agreed",
    "agreeing",
    "agreement",
    "aground",
    "ahead",
    "ahoy",
    "aide",
    "aids",
    "aim",
    "ajar",
    "alabaster",
    "alarm",
    "albatross",
    "album",
    "alfalfa",
    "algebra",
    "algorithm",
    "alias",
    "alibi",
    "alienable",
    "alienate",
    "aliens",
    "alike",
    "alive",
    "alkaline",
    "alkalize",
    "almanac",
    "almighty",
    "almost",
    "aloe",
    "aloft",
    "aloha",
    "alone",
    "alongside",
    "aloof",
    "alphabet",
    "alright",
    "although",
    "altitude",
    "alto",
    "aluminum",
    "alumni",
    "always",
    "amaretto",
    "amaze",
    "amazingly",
    "amber",
    "ambiance",
    "ambiguity",
    "ambiguous",
    "ambition",
    "ambitious",
    "ambulance",
    "ambush",
    "amendable",
    "amendment",
    "amends",
    "amenity",
    "amiable",
    "amicably",
    "amid",
    "amigo",
    "amino",
    "amiss",
    "ammonia",
    "ammonium",
    "amnesty",
    "amniotic",
    "among",
    "amount",
    "amperage",
    "ample",
    "amplifier",
    "amplify",
    "amply",
    "amuck",
    "amulet",
    "amusable",
    "amused",
    "amusement",
    "amuser",
    "amusing",
    "anaconda",
    "anaerobic",
    "anagram",
    "anatomist",
    "anatomy",
    "anchor",
    "anchovy",
    "ancient",
    "android",
    "anemia",
    "anemic",
    "aneurism",
    "anew",
    "angelfish",
    "angelic",
    "anger",
    "angled",
    "angler",
    "angles",
    "angling",
    "angrily",
    "angriness",
    "anguished",
    "angular",
    "animal",
    "animate",
    "animating",
    "animation",
    "animator",
    "anime",
    "animosity",
    "ankle",
    "annex",
    "annotate",
    "announcer",
    "annoying",
    "annually",
    "annuity",
    "anointer",
    "another",
    "answering",
    "antacid",
    "antarctic",
    "anteater",
    "antelope",
    "antennae",
    "anthem",
    "anthill",
    "anthology",
    "antibody",
    "antics",
    "antidote",
    "antihero",
    "antiquely",
    "antiques",
    "antiquity",
    "antirust",
    "antitoxic",
    "antitrust",
    "antiviral",
    "antivirus",
    "antler",
    "antonym",
    "antsy",
    "anvil",
    "anybody",
    "anyhow",
    "anymore",
    "anyone",
    "anyplace",
    "anything",
    "anytime",
    "anyway",
    "anywhere",
    "aorta",
    "apache",
    "apostle",
    "appealing",
    "appear",
    "appease",
    "appeasing",
    "appendage",
    "appendix",
    "appetite",
    "appetizer",
    "applaud",
    "applause",
    "apple",
    "appliance",
    "applicant",
    "applied",
    "apply",
    "appointee",
    "appraisal",
    "appraiser",
    "apprehend",
    "approach",
    "approval",
    "approve",
    "apricot",
    "april",
    "apron",
    "aptitude",
    "aptly",
    "aqua",
    "aqueduct",
    "arbitrary",
    "arbitrate",
    "ardently",
    "area",
    "arena",
    "arguable",
    "arguably",
    "argue",
    "arise",
    "armadillo",
    "armband",
    "armchair",
    "armed",
    "armful",
    "armhole",
    "arming",
    "armless",
    "armoire",
    "armored",
    "armory",
    "armrest",
    "army",
    "aroma",
    "arose",
    "around",
    "arousal",
    "arrange",
    "array",
    "arrest",
    "arrival",
    "arrive",
    "arrogance",
    "arrogant",
    "arson",
    "art",
    "ascend",
    "ascension",
    "ascent",
    "ascertain",
    "ashamed",
    "ashen",
    "ashes",
    "ashy",
    "aside",
    "askew",
    "asleep",
    "asparagus",
    "aspect",
    "aspirate",
    "aspire",
    "aspirin",
    "astonish",
    "astound",
    "astride",
    "astrology",
    "astronaut",
    "astronomy",
    "astute",
    "atlantic",
    "atlas",
    "atom",
    "atonable",
    "atop",
    "atrium",
    "atrocious",
    "atrophy",
    "attach",
    "attain",
    "attempt",
    "attendant",
    "attendee",
    "attention",
    "attentive",
    "attest",
    "attic",
    "attire",
    "attitude",
    "attractor",
    "attribute",
    "atypical",
    "auction",
    "audacious",
    "audacity",
    "audible",
    "audibly",
    "audience",
    "audio",
    "audition",
    "augmented",
    "august",
    "authentic",
    "author",
    "autism",
    "autistic",
    "autograph",
    "automaker",
    "automated",
    "automatic",
    "autopilot",
    "available",
    "avalanche",
    "avatar",
    "avenge",
    "avenging",
    "avenue",
    "average",
    "aversion",
    "avert",
    "aviation",
    "aviator",
    "avid",
    "avoid",
    "await",
    "awaken",
    "award",
    "aware",
    "awhile",
    "awkward",
    "awning",
    "awoke",
    "awry",
    "axis",
    "babble",
    "babbling",
    "babied",
    "baboon",
    "backache",
    "backboard",
    "backboned",
    "backdrop",
    "backed",
    "backer",
    "backfield",
    "backfire",
    "backhand",
    "backing",
    "backlands",
    "backlash",
    "backless",
    "backlight",
    "backlit",
    "backlog",
    "backpack",
    "backpedal",
    "backrest",
    "backroom",
    "backshift",
    "backside",
    "backslid",
    "backspace",
    "backspin",
    "backstab",
    "backstage",
    "backtalk",
    "backtrack",
    "backup",
    "backward",
    "backwash",
    "backwater",
    "backyard",
    "bacon",
    "bacteria",
    "bacterium",
    "badass",
    "badge",
    "badland",
    "badly",
    "badness",
    "baffle",
    "baffling",
    "bagel",
    "bagful",
    "baggage",
    "bagged",
    "baggie",
    "bagginess",
    "bagging",
    "baggy",
    "bagpipe",
    "baguette",
    "baked",
    "bakery",
    "bakeshop",
    "baking",
    "balance",
    "balancing",
    "balcony",
    "balmy",
    "balsamic",
    "bamboo",
    "banana",
    "banish",
    "banister",
    "banjo",
    "bankable",
    "bankbook",
    "banked",
    "banker",
    "banking",
    "banknote",
    "bankroll",
    "banner",
    "bannister",
    "banshee",
    "banter",
    "barbecue",
    "barbed",
    "barbell",
    "barber",
    "barcode",
    "barge",
    "bargraph",
    "barista",
    "baritone",
    "barley",
    "barmaid",
    "barman",
    "barn",
    "barometer",
    "barrack",
    "barracuda",
    "barrel",
    "barrette",
    "barricade",
    "barrier",
    "barstool",
    "bartender",
    "barterer",
    "bash",
    "basically",
    "basics",
    "basil",
    "basin",
    "basis",
    "basket",
    "batboy",
    "batch",
    "bath",
    "baton",
    "bats",
    "battalion",
    "battered",
    "battering",
    "battery",
    "batting",
    "battle",
    "bauble",
    "bazooka",
    "blabber",
    "bladder",
    "blade",
    "blah",
    "blame",
    "blaming",
    "blanching",
    "blandness",
    "blank",
    "blaspheme",
    "blasphemy",
    "blast",
    "blatancy",
    "blatantly",
    "blazer",
    "blazing",
    "bleach",
    "bleak",
    "bleep",
    "blemish",
    "blend",
    "bless",
    "blighted",
    "blimp",
    "bling",
    "blinked",
    "blinker",
    "blinking",
    "blinks",
    "blip",
    "blissful",
    "blitz",
    "blizzard",
    "bloated",
    "bloating",
    "blob",
    "blog",
    "bloomers",
    "blooming",
    "blooper",
    "blot",
    "blouse",
    "blubber",
    "bluff",
    "bluish",
    "blunderer",
    "blunt",
    "blurb",
    "blurred",
    "blurry",
    "blurt",
    "blush",
    "blustery",
    "boaster",
    "boastful",
    "boasting",
    "boat",
    "bobbed",
    "bobbing",
    "bobble",
    "bobcat",
    "bobsled",
    "bobtail",
    "bodacious",
    "body",
    "bogged",
    "boggle",
    "bogus",
    "boil",
    "bok",
    "bolster",
    "bolt",
    "bonanza",
    "bonded",
    "bonding",
    "bondless",
    "boned",
    "bonehead",
    "boneless",
    "bonelike",
    "boney",
    "bonfire",
    "bonnet",
    "bonsai",
    "bonus",
    "bony",
    "boogeyman",
    "boogieman",
    "book",
    "boondocks",
    "booted",
    "booth",
    "bootie",
    "booting",
    "bootlace",
    "bootleg",
    "boots",
    "boozy",
    "borax",
    "boring",
    "borough",
    "borrower",
    "borrowing",
    "boss",
    "botanical",
    "botanist",
    "botany",
    "botch",
    "both",
    "bottle",
    "bottling",
    "bottom",
    "bounce",
    "bouncing",
    "bouncy",
    "bounding",
    "boundless",
    "bountiful",
    "bovine",
    "boxcar",
    "boxer",
    "boxing",
    "boxlike",
    "boxy",
    "breach",
    "breath",
    "breeches",
    "breeching",
    "breeder",
    "breeding",
    "breeze",
    "breezy",
    "brethren",
    "brewery",
    "brewing",
    "briar",
    "bribe",
    "brick",
    "bride",
    "bridged",
    "brigade",
    "bright",
    "brilliant",
    "brim",
    "bring",
    "brink",
    "brisket",
    "briskly",
    "briskness",
    "bristle",
    "brittle",
    "broadband",
    "broadcast",
    "broaden",
    "broadly",
    "broadness",
    "broadside",
    "broadways",
    "broiler",
    "broiling",
    "broken",
    "broker",
    "bronchial",
    "bronco",
    "bronze",
    "bronzing",
    "brook",
    "broom",
    "brought",
    "browbeat",
    "brownnose",
    "browse",
    "browsing",
    "bruising",
    "brunch",
    "brunette",
    "brunt",
    "brush",
    "brussels",
    "brute",
    "brutishly",
    "bubble",
    "bubbling",
    "bubbly",
    "buccaneer",
    "bucked",
    "bucket",
    "buckle",
    "buckshot",
    "buckskin",
    "bucktooth",
    "buckwheat",
    "buddhism",
    "buddhist",
    "budding",
    "buddy",
    "budget",
    "buffalo",
    "buffed",
    "buffer",
    "buffing",
    "buffoon",
    "buggy",
    "bulb",
    "bulge",
    "bulginess",
    "bulgur",
    "bulk",
    "bulldog",
    "bulldozer",
    "bullfight",
    "bullfrog",
    "bullhorn",
    "bullion",
    "bullish",
    "bullpen",
    "bullring",
    "bullseye",
    "bullwhip",
    "bully",
    "bunch",
    "bundle",
    "bungee",
    "bunion",
    "bunkbed",
    "bunkhouse",
    "bunkmate",
    "bunny",
    "bunt",
    "busboy",
    "bush",
    "busily",
    "busload",
    "bust",
    "busybody",
    "buzz",
    "cabana",
    "cabbage",
    "cabbie",
    "cabdriver",
    "cable",
    "caboose",
    "cache",
    "cackle",
    "cacti",
    "cactus",
    "caddie",
    "caddy",
    "cadet",
    "cadillac",
    "cadmium",
    "cage",
    "cahoots",
    "cake",
    "calamari",
    "calamity",
    "calcium",
    "calculate",
    "calculus",
    "caliber",
    "calibrate",
    "calm",
    "caloric",
    "calorie",
    "calzone",
    "camcorder",
    "cameo",
    "camera",
    "camisole",
    "camper",
    "campfire",
    "camping",
    "campsite",
    "campus",
    "canal",
    "canary",
    "cancel",
    "candied",
    "candle",
    "candy",
    "cane",
    "canine",
    "canister",
    "cannabis",
    "canned",
    "canning",
    "cannon",
    "cannot",
    "canola",
    "canon",
    "canopener",
    "canopy",
    "canteen",
    "canyon",
    "capable",
    "capably",
    "capacity",
    "cape",
    "capillary",
    "capital",
    "capitol",
    "capped",
    "capricorn",
    "capsize",
    "capsule",
    "caption",
    "captivate",
    "captive",
    "captivity",
    "capture",
    "caramel",
    "carat",
    "caravan",
    "carbon",
    "cardboard",
    "carded",
    "cardiac",
    "cardigan",
    "cardinal",
    "cardstock",
    "carefully",
    "caregiver",
    "careless",
    "caress",
    "caretaker",
    "cargo",
    "caring",
    "carless",
    "carload",
    "carmaker",
    "carnage",
    "carnation",
    "carnival",
    "carnivore",
    "carol",
    "carpenter",
    "carpentry",
    "carpool",
    "carport",
    "carried",
    "carrot",
    "carrousel",
    "carry",
    "cartel",
    "cartload",
    "carton",
    "cartoon",
    "cartridge",
    "cartwheel",
    "carve",
    "carving",
    "carwash",
    "cascade",
    "case",
    "cash",
    "casing",
    "casino",
    "casket",
    "cassette",
    "casually",
    "casualty",
    "catacomb",
    "catalog",
    "catalyst",
    "catalyze",
    "catapult",
    "cataract",
    "catatonic",
    "catcall",
    "catchable",
    "catcher",
    "catching",
    "catchy",
    "caterer",
    "catering",
    "catfight",
    "catfish",
    "cathedral",
    "cathouse",
    "catlike",
    "catnap",
    "catnip",
    "catsup",
    "cattail",
    "cattishly",
    "cattle",
    "catty",
    "catwalk",
    "caucasian",
    "caucus",
    "causal",
    "causation",
    "cause",
    "causing",
    "cauterize",
    "caution",
    "cautious",
    "cavalier",
    "cavalry",
    "caviar",
    "cavity",
    "cedar",
    "celery",
    "celestial",
    "celibacy",
    "celibate",
    "celtic",
    "cement",
    "census",
    "ceramics",
    "ceremony",
    "certainly",
    "certainty",
    "certified",
    "certify",
    "cesarean",
    "cesspool",
    "chafe",
    "chaffing",
    "chain",
    "chair",
    "chalice",
    "challenge",
    "chamber",
    "chamomile",
    "champion",
    "chance",
    "change",
    "channel",
    "chant",
    "chaos",
    "chaperone",
    "chaplain",
    "chapped",
    "chaps",
    "chapter",
    "character",
    "charbroil",
    "charcoal",
    "charger",
    "charging",
    "chariot",
    "charity",
    "charm",
    "charred",
    "charter",
    "charting",
    "chase",
    "chasing",
    "chaste",
    "chastise",
    "chastity",
    "chatroom",
    "chatter",
    "chatting",
    "chatty",
    "cheating",
    "cheddar",
    "cheek",
    "cheer",
    "cheese",
    "cheesy",
    "chef",
    "chemicals",
    "chemist",
    "chemo",
    "cherisher",
    "cherub",
    "chess",
    "chest",
    "chevron",
    "chevy",
    "chewable",
    "chewer",
    "chewing",
    "chewy",
    "chief",
    "chihuahua",
    "childcare",
    "childhood",
    "childish",
    "childless",
    "childlike",
    "chili",
    "chill",
    "chimp",
    "chip",
    "chirping",
    "chirpy",
    "chitchat",
    "chivalry",
    "chive",
    "chloride",
    "chlorine",
    "choice",
    "chokehold",
    "choking",
    "chomp",
    "chooser",
    "choosing",
    "choosy",
    "chop",
    "chosen",
    "chowder",
    "chowtime",
    "chrome",
    "chubby",
    "chuck",
    "chug",
    "chummy",
    "chump",
    "chunk",
    "churn",
    "chute",
    "cider",
    "cilantro",
    "cinch",
    "cinema",
    "cinnamon",
    "circle",
    "circling",
    "circular",
    "circulate",
    "circus",
    "citable",
    "citadel",
    "citation",
    "citizen",
    "citric",
    "citrus",
    "city",
    "civic",
    "civil",
    "clad",
    "claim",
    "clambake",
    "clammy",
    "clamor",
    "clamp",
    "clamshell",
    "clang",
    "clanking",
    "clapped",
    "clapper",
    "clapping",
    "clarify",
    "clarinet",
    "clarity",
    "clash",
    "clasp",
    "class",
    "clatter",
    "clause",
    "clavicle",
    "claw",
    "clay",
    "clean",
    "clear",
    "cleat",
    "cleaver",
    "cleft",
    "clench",
    "clergyman",
    "clerical",
    "clerk",
    "clever",
    "clicker",
    "client",
    "climate",
    "climatic",
    "cling",
    "clinic",
    "clinking",
    "clip",
    "clique",
    "cloak",
    "clobber",
    "clock",
    "clone",
    "cloning",
    "closable",
    "closure",
    "clothes",
    "clothing",
    "cloud",
    "clover",
    "clubbed",
    "clubbing",
    "clubhouse",
    "clump",
    "clumsily",
    "clumsy",
    "clunky",
    "clustered",
    "clutch",
    "clutter",
    "coach",
    "coagulant",
    "coastal",
    "coaster",
    "coasting",
    "coastland",
    "coastline",
    "coat",
    "coauthor",
    "cobalt",
    "cobbler",
    "cobweb",
    "cocoa",
    "coconut",
    "cod",
    "coeditor",
    "coerce",
    "coexist",
    "coffee",
    "cofounder",
    "cognition",
    "cognitive",
    "cogwheel",
    "coherence",
    "coherent",
    "cohesive",
    "coil",
    "coke",
    "cola",
    "cold",
    "coleslaw",
    "coliseum",
    "collage",
    "collapse",
    "collar",
    "collected",
    "collector",
    "collide",
    "collie",
    "collision",
    "colonial",
    "colonist",
    "colonize",
    "colony",
    "colossal",
    "colt",
    "coma",
    "come",
    "comfort",
    "comfy",
    "comic",
    "coming",
    "comma",
    "commence",
    "commend",
    "comment",
    "commerce",
    "commode",
    "commodity",
    "commodore",
    "common",
    "commotion",
    "commute",
    "commuting",
    "compacted",
    "compacter",
    "compactly",
    "compactor",
    "companion",
    "company",
    "compare",
    "compel",
    "compile",
    "comply",
    "component",
    "composed",
    "composer",
    "composite",
    "compost",
    "composure",
    "compound",
    "compress",
    "comprised",
    "computer",
    "computing",
    "comrade",
    "concave",
    "conceal",
    "conceded",
    "concept",
    "concerned",
    "concert",
    "conch",
    "concierge",
    "concise",
    "conclude",
    "concrete",
    "concur",
    "condense",
    "condiment",
    "condition",
    "condone",
    "conducive",
    "conductor",
    "conduit",
    "cone",
    "confess",
    "confetti",
    "confidant",
    "confident",
    "confider",
    "confiding",
    "configure",
    "confined",
    "confining",
    "confirm",
    "conflict",
    "conform",
    "confound",
    "confront",
    "confused",
    "confusing",
    "confusion",
    "congenial",
    "congested",
    "congrats",
    "congress",
    "conical",
    "conjoined",
    "conjure",
    "conjuror",
    "connected",
    "connector",
    "consensus",
    "consent",
    "console",
    "consoling",
    "consonant",
    "constable",
    "constant",
    "constrain",
    "constrict",
    "construct",
    "consult",
    "consumer",
    "consuming",
    "contact",
    "container",
    "contempt",
    "contend",
    "contented",
    "contently",
    "contents",
    "contest",
    "context",
    "contort",
    "contour",
    "contrite",
    "control",
    "contusion",
    "convene",
    "convent",
    "copartner",
    "cope",
    "copied",
    "copier",
    "copilot",
    "coping",
    "copious",
    "copper",
    "copy",
    "coral",
    "cork",
    "cornball",
    "cornbread",
    "corncob",
    "cornea",
    "corned",
    "corner",
    "cornfield",
    "cornflake",
    "cornhusk",
    "cornmeal",
    "cornstalk",
    "corny",
    "coronary",
    "coroner",
    "corporal",
    "corporate",
    "corral",
    "correct",
    "corridor",
    "corrode",
    "corroding",
    "corrosive",
    "corsage",
    "corset",
    "cortex",
    "cosigner",
    "cosmetics",
    "cosmic",
    "cosmos",
    "cosponsor",
    "cost",
    "cottage",
    "cotton",
    "couch",
    "cough",
    "could",
    "countable",
    "countdown",
    "counting",
    "countless",
    "country",
    "county",
    "courier",
    "covenant",
    "cover",
    "coveted",
    "coveting",
    "coyness",
    "cozily",
    "coziness",
    "cozy",
    "crabbing",
    "crabgrass",
    "crablike",
    "crabmeat",
    "cradle",
    "cradling",
    "crafter",
    "craftily",
    "craftsman",
    "craftwork",
    "crafty",
    "cramp",
    "cranberry",
    "crane",
    "cranial",
    "cranium",
    "crank",
    "crate",
    "crave",
    "craving",
    "crawfish",
    "crawlers",
    "crawling",
    "crayfish",
    "crayon",
    "crazed",
    "crazily",
    "craziness",
    "crazy",
    "creamed",
    "creamer",
    "creamlike",
    "crease",
    "creasing",
    "creatable",
    "create",
    "creation",
    "creative",
    "creature",
    "credible",
    "credibly",
    "credit",
    "creed",
    "creme",
    "creole",
    "crepe",
    "crept",
    "crescent",
    "crested",
    "cresting",
    "crestless",
    "crevice",
    "crewless",
    "crewman",
    "crewmate",
    "crib",
    "cricket",
    "cried",
    "crier",
    "crimp",
    "crimson",
    "cringe",
    "cringing",
    "crinkle",
    "crinkly",
    "crisped",
    "crisping",
    "crisply",
    "crispness",
    "crispy",
    "criteria",
    "critter",
    "croak",
    "crock",
    "crook",
    "croon",
    "crop",
    "cross",
    "crouch",
    "crouton",
    "crowbar",
    "crowd",
    "crown",
    "crucial",
    "crudely",
    "crudeness",
    "cruelly",
    "cruelness",
    "cruelty",
    "crumb",
    "crummiest",
    "crummy",
    "crumpet",
    "crumpled",
    "cruncher",
    "crunching",
    "crunchy",
    "crusader",
    "crushable",
    "crushed",
    "crusher",
    "crushing",
    "crust",
    "crux",
    "crying",
    "cryptic",
    "crystal",
    "cubbyhole",
    "cube",
    "cubical",
    "cubicle",
    "cucumber",
    "cuddle",
    "cuddly",
    "cufflink",
    "culinary",
    "culminate",
    "culpable",
    "culprit",
    "cultivate",
    "cultural",
    "culture",
    "cupbearer",
    "cupcake",
    "cupid",
    "cupped",
    "cupping",
    "curable",
    "curator",
    "curdle",
    "cure",
    "curfew",
    "curing",
    "curled",
    "curler",
    "curliness",
    "curling",
    "curly",
    "curry",
    "curse",
    "cursive",
    "cursor",
    "curtain",
    "curtly",
    "curtsy",
    "curvature",
    "curve",
    "curvy",
    "cushy",
    "cusp",
    "cussed",
    "custard",
    "custodian",
    "custody",
    "customary",
    "customer",
    "customize",
    "customs",
    "cut",
    "cycle",
    "cyclic",
    "cycling",
    "cyclist",
    "cylinder",
    "cymbal",
    "cytoplasm",
    "cytoplast",
    "dab",
    "dad",
    "daffodil",
    "dagger",
    "daily",
    "daintily",
    "dainty",
    "dairy",
    "daisy",
    "dallying",
    "dance",
    "dancing",
    "dandelion",
    "dander",
    "dandruff",
    "dandy",
    "danger",
    "dangle",
    "dangling",
    "daredevil",
    "dares",
    "daringly",
    "darkened",
    "darkening",
    "darkish",
    "darkness",
    "darkroom",
    "darling",
    "darn",
    "dart",
    "darwinism",
    "dash",
    "dastardly",
    "data",
    "datebook",
    "dating",
    "daughter",
    "daunting",
    "dawdler",
    "dawn",
    "daybed",
    "daybreak",
    "daycare",
    "daydream",
    "daylight",
    "daylong",
    "dayroom",
    "daytime",
    "dazzler",
    "dazzling",
    "deacon",
    "deafening",
    "deafness",
    "dealer",
    "dealing",
    "dealmaker",
    "dealt",
    "dean",
    "debatable",
    "debate",
    "debating",
    "debit",
    "debrief",
    "debtless",
    "debtor",
    "debug",
    "debunk",
    "decade",
    "decaf",
    "decal",
    "decathlon",
    "decay",
    "deceased",
    "deceit",
    "deceiver",
    "deceiving",
    "december",
    "decency",
    "decent",
    "deception",
    "deceptive",
    "decibel",
    "decidable",
    "decimal",
    "decimeter",
    "decipher",
    "deck",
    "declared",
    "decline",
    "decode",
    "decompose",
    "decorated",
    "decorator",
    "decoy",
    "decrease",
    "decree",
    "dedicate",
    "dedicator",
    "deduce",
    "deduct",
    "deed",
    "deem",
    "deepen",
    "deeply",
    "deepness",
    "deface",
    "defacing",
    "defame",
    "default",
    "defeat",
    "defection",
    "defective",
    "defendant",
    "defender",
    "defense",
    "defensive",
    "deferral",
    "deferred",
    "defiance",
    "defiant",
    "defile",
    "defiling",
    "define",
    "definite",
    "deflate",
    "deflation",
    "deflator",
    "deflected",
    "deflector",
    "defog",
    "deforest",
    "defraud",
    "defrost",
    "deftly",
    "defuse",
    "defy",
    "degraded",
    "degrading",
    "degrease",
    "degree",
    "dehydrate",
    "deity",
    "dejected",
    "delay",
    "delegate",
    "delegator",
    "delete",
    "deletion",
    "delicacy",
    "delicate",
    "delicious",
    "delighted",
    "delirious",
    "delirium",
    "deliverer",
    "delivery",
    "delouse",
    "delta",
    "deluge",
    "delusion",
    "deluxe",
    "demanding",
    "demeaning",
    "demeanor",
    "demise",
    "democracy",
    "democrat",
    "demote",
    "demotion",
    "demystify",
    "denatured",
    "deniable",
    "denial",
    "denim",
    "denote",
    "dense",
    "density",
    "dental",
    "dentist",
    "denture",
    "deny",
    "deodorant",
    "deodorize",
    "departed",
    "departure",
    "depict",
    "deplete",
    "depletion",
    "deplored",
    "deploy",
    "deport",
    "depose",
    "depraved",
    "depravity",
    "deprecate",
    "depress",
    "deprive",
    "depth",
    "deputize",
    "deputy",
    "derail",
    "deranged",
    "derby",
    "derived",
    "desecrate",
    "deserve",
    "deserving",
    "designate",
    "designed",
    "designer",
    "designing",
    "deskbound",
    "desktop",
    "deskwork",
    "desolate",
    "despair",
    "despise",
    "despite",
    "destiny",
    "destitute",
    "destruct",
    "detached",
    "detail",
    "detection",
    "detective",
    "detector",
    "detention",
    "detergent",
    "detest",
    "detonate",
    "detonator",
    "detoxify",
    "detract",
    "deuce",
    "devalue",
    "deviancy",
    "deviant",
    "deviate",
    "deviation",
    "deviator",
    "device",
    "devious",
    "devotedly",
    "devotee",
    "devotion",
    "devourer",
    "devouring",
    "devoutly",
    "dexterity",
    "dexterous",
    "diabetes",
    "diabetic",
    "diabolic",
    "diagnoses",
    "diagnosis",
    "diagram",
    "dial",
    "diameter",
    "diaper",
    "diaphragm",
    "diary",
    "dice",
    "dicing",
    "dictate",
    "dictation",
    "dictator",
    "difficult",
    "diffused",
    "diffuser",
    "diffusion",
    "diffusive",
    "dig",
    "dilation",
    "diligence",
    "diligent",
    "dill",
    "dilute",
    "dime",
    "diminish",
    "dimly",
    "dimmed",
    "dimmer",
    "dimness",
    "dimple",
    "diner",
    "dingbat",
    "dinghy",
    "dinginess",
    "dingo",
    "dingy",
    "dining",
    "dinner",
    "diocese",
    "dioxide",
    "diploma",
    "dipped",
    "dipper",
    "dipping",
    "directed",
    "direction",
    "directive",
    "directly",
    "directory",
    "direness",
    "dirtiness",
    "disabled",
    "disagree",
    "disallow",
    "disarm",
    "disarray",
    "disaster",
    "disband",
    "disbelief",
    "disburse",
    "discard",
    "discern",
    "discharge",
    "disclose",
    "discolor",
    "discount",
    "discourse",
    "discover",
    "discuss",
    "disdain",
    "disengage",
    "disfigure",
    "disgrace",
    "dish",
    "disinfect",
    "disjoin",
    "disk",
    "dislike",
    "disliking",
    "dislocate",
    "dislodge",
    "disloyal",
    "dismantle",
    "dismay",
    "dismiss",
    "dismount",
    "disobey",
    "disorder",
    "disown",
    "disparate",
    "disparity",
    "dispatch",
    "dispense",
    "dispersal",
    "dispersed",
    "disperser",
    "displace",
    "display",
    "displease",
    "disposal",
    "dispose",
    "disprove",
    "dispute",
    "disregard",
    "disrupt",
    "dissuade",
    "distance",
    "distant",
    "distaste",
    "distill",
    "distinct",
    "distort",
    "distract",
    "distress",
    "district",
    "distrust",
    "ditch",
    "ditto",
    "ditzy",
    "dividable",
    "divided",
    "dividend",
    "dividers",
    "dividing",
    "divinely",
    "diving",
    "divinity",
    "divisible",
    "divisibly",
    "division",
    "divisive",
    "divorcee",
    "dizziness",
    "dizzy",
    "doable",
    "docile",
    "dock",
    "doctrine",
    "document",
    "dodge",
    "dodgy",
    "doily",
    "doing",
    "dole",
    "dollar",
    "dollhouse",
    "dollop",
    "dolly",
    "dolphin",
    "domain",
    "domelike",
    "domestic",
    "dominion",
    "dominoes",
    "donated",
    "donation",
    "donator",
    "donor",
    "donut",
    "doodle",
    "doorbell",
    "doorframe",
    "doorknob",
    "doorman",
    "doormat",
    "doornail",
    "doorpost",
    "doorstep",
    "doorstop",
    "doorway",
    "doozy",
    "dork",
    "dormitory",
    "dorsal",
    "dosage",
    "dose",
    "dotted",
    "doubling",
    "douche",
    "dove",
    "down",
    "dowry",
    "doze",
    "drab",
    "dragging",
    "dragonfly",
    "dragonish",
    "dragster",
    "drainable",
    "drainage",
    "drained",
    "drainer",
    "drainpipe",
    "dramatic",
    "dramatize",
    "drank",
    "drapery",
    "drastic",
    "draw",
    "dreaded",
    "dreadful",
    "dreadlock",
    "dreamboat",
    "dreamily",
    "dreamland",
    "dreamless",
    "dreamlike",
    "dreamt",
    "dreamy",
    "drearily",
    "dreary",
    "drench",
    "dress",
    "drew",
    "dribble",
    "dried",
    "drier",
    "drift",
    "driller",
    "drilling",
    "drinkable",
    "drinking",
    "dripping",
    "drippy",
    "drivable",
    "driven",
    "driver",
    "driveway",
    "driving",
    "drizzle",
    "drizzly",
    "drone",
    "drool",
    "droop",
    "drop-down",
    "dropbox",
    "dropkick",
    "droplet",
    "dropout",
    "dropper",
    "drove",
    "drown",
    "drowsily",
    "drudge",
    "drum",
    "dry",
    "dubbed",
    "dubiously",
    "duchess",
    "duckbill",
    "ducking",
    "duckling",
    "ducktail",
    "ducky",
    "duct",
    "dude",
    "duffel",
    "dugout",
    "duh",
    "duke",
    "duller",
    "dullness",
    "duly",
    "dumping",
    "dumpling",
    "dumpster",
    "duo",
    "dupe",
    "duplex",
    "duplicate",
    "duplicity",
    "durable",
    "durably",
    "duration",
    "duress",
    "during",
    "dusk",
    "dust",
    "dutiful",
    "duty",
    "duvet",
    "dwarf",
    "dweeb",
    "dwelled",
    "dweller",
    "dwelling",
    "dwindle",
    "dwindling",
    "dynamic",
    "dynamite",
    "dynasty",
    "dyslexia",
    "dyslexic",
    "each",
    "eagle",
    "earache",
    "eardrum",
    "earflap",
    "earful",
    "earlobe",
    "early",
    "earmark",
    "earmuff",
    "earphone",
    "earpiece",
    "earplugs",
    "earring",
    "earshot",
    "earthen",
    "earthlike",
    "earthling",
    "earthly",
    "earthworm",
    "earthy",
    "earwig",
    "easeful",
    "easel",
    "easiest",
    "easily",
    "easiness",
    "easing",
    "eastbound",
    "eastcoast",
    "easter",
    "eastward",
    "eatable",
    "eaten",
    "eatery",
    "eating",
    "eats",
    "ebay",
    "ebony",
    "ebook",
    "ecard",
    "eccentric",
    "echo",
    "eclair",
    "eclipse",
    "ecologist",
    "ecology",
    "economic",
    "economist",
    "economy",
    "ecosphere",
    "ecosystem",
    "edge",
    "edginess",
    "edging",
    "edgy",
    "edition",
    "editor",
    "educated",
    "education",
    "educator",
    "eel",
    "effective",
    "effects",
    "efficient",
    "effort",
    "eggbeater",
    "egging",
    "eggnog",
    "eggplant",
    "eggshell",
    "egomaniac",
    "egotism",
    "egotistic",
    "either",
    "eject",
    "elaborate",
    "elastic",
    "elated",
    "elbow",
    "eldercare",
    "elderly",
    "eldest",
    "electable",
    "election",
    "elective",
    "elephant",
    "elevate",
    "elevating",
    "elevation",
    "elevator",
    "eleven",
    "elf",
    "eligible",
    "eligibly",
    "eliminate",
    "elite",
    "elitism",
    "elixir",
    "elk",
    "ellipse",
    "elliptic",
    "elm",
    "elongated",
    "elope",
    "eloquence",
    "eloquent",
    "elsewhere",
    "elude",
    "elusive",
    "elves",
    "email",
    "embargo",
    "embark",
    "embassy",
    "embattled",
    "embellish",
    "ember",
    "embezzle",
    "emblaze",
    "emblem",
    "embody",
    "embolism",
    "emboss",
    "embroider",
    "emcee",
    "emerald",
    "emergency",
    "emission",
    "emit",
    "emote",
    "emoticon",
    "emotion",
    "empathic",
    "empathy",
    "emperor",
    "emphases",
    "emphasis",
    "emphasize",
    "emphatic",
    "empirical",
    "employed",
    "employee",
    "employer",
    "emporium",
    "empower",
    "emptier",
    "emptiness",
    "empty",
    "emu",
    "enable",
    "enactment",
    "enamel",
    "enchanted",
    "enchilada",
    "encircle",
    "enclose",
    "enclosure",
    "encode",
    "encore",
    "encounter",
    "encourage",
    "encroach",
    "encrust",
    "encrypt",
    "endanger",
    "endeared",
    "endearing",
    "ended",
    "ending",
    "endless",
    "endnote",
    "endocrine",
    "endorphin",
    "endorse",
    "endowment",
    "endpoint",
    "endurable",
    "endurance",
    "enduring",
    "energetic",
    "energize",
    "energy",
    "enforced",
    "enforcer",
    "engaged",
    "engaging",
    "engine",
    "engorge",
    "engraved",
    "engraver",
    "engraving",
    "engross",
    "engulf",
    "enhance",
    "enigmatic",
    "enjoyable",
    "enjoyably",
    "enjoyer",
    "enjoying",
    "enjoyment",
    "enlarged",
    "enlarging",
    "enlighten",
    "enlisted",
    "enquirer",
    "enrage",
    "enrich",
    "enroll",
    "enslave",
    "ensnare",
    "ensure",
    "entail",
    "entangled",
    "entering",
    "entertain",
    "enticing",
    "entire",
    "entitle",
    "entity",
    "entomb",
    "entourage",
    "entrap",
    "entree",
    "entrench",
    "entrust",
    "entryway",
    "entwine",
    "enunciate",
    "envelope",
    "enviable",
    "enviably",
    "envious",
    "envision",
    "envoy",
    "envy",
    "enzyme",
    "epic",
    "epidemic",
    "epidermal",
    "epidermis",
    "epidural",
    "epilepsy",
    "epileptic",
    "epilogue",
    "epiphany",
    "episode",
    "equal",
    "equate",
    "equation",
    "equator",
    "equinox",
    "equipment",
    "equity",
    "equivocal",
    "eradicate",
    "erasable",
    "erased",
    "eraser",
    "erasure",
    "ergonomic",
    "errand",
    "errant",
    "erratic",
    "error",
    "erupt",
    "escalate",
    "escalator",
    "escapable",
    "escapade",
    "escapist",
    "escargot",
    "eskimo",
    "esophagus",
    "espionage",
    "espresso",
    "esquire",
    "essay",
    "essence",
    "essential",
    "establish",
    "estate",
    "esteemed",
    "estimate",
    "estimator",
    "estranged",
    "estrogen",
    "etching",
    "eternal",
    "eternity",
    "ethanol",
    "ether",
    "ethically",
    "ethics",
    "euphemism",
    "evacuate",
    "evacuee",
    "evade",
    "evaluate",
    "evaluator",
    "evaporate",
    "evasion",
    "evasive",
    "even",
    "everglade",
    "evergreen",
    "everybody",
    "everyday",
    "everyone",
    "evict",
    "evidence",
    "evident",
    "evil",
    "evoke",
    "evolution",
    "evolve",
    "exact",
    "exalted",
    "example",
    "excavate",
    "excavator",
    "exceeding",
    "exception",
    "excess",
    "exchange",
    "excitable",
    "exciting",
    "exclaim",
    "exclude",
    "excluding",
    "exclusion",
    "exclusive",
    "excretion",
    "excretory",
    "excursion",
    "excusable",
    "excusably",
    "excuse",
    "exemplary",
    "exemplify",
    "exemption",
    "exerciser",
    "exert",
    "exes",
    "exfoliate",
    "exhale",
    "exhaust",
    "exhume",
    "exile",
    "existing",
    "exit",
    "exodus",
    "exonerate",
    "exorcism",
    "exorcist",
    "expand",
    "expanse",
    "expansion",
    "expansive",
    "expectant",
    "expedited",
    "expediter",
    "expel",
    "expend",
    "expenses",
    "expensive",
    "expert",
    "expire",
    "expiring",
    "explain",
    "expletive",
    "explicit",
    "explode",
    "exploit",
    "explore",
    "exploring",
    "exponent",
    "exporter",
    "exposable",
    "expose",
    "exposure",
    "express",
    "expulsion",
    "exquisite",
    "extended",
    "extending",
    "extent",
    "extenuate",
    "exterior",
    "external",
    "extinct",
    "extortion",
    "extradite",
    "extras",
    "extrovert",
    "extrude",
    "extruding",
    "exuberant",
    "fable",
    "fabric",
    "fabulous",
    "facebook",
    "facecloth",
    "facedown",
    "faceless",
    "facelift",
    "faceplate",
    "faceted",
    "facial",
    "facility",
    "facing",
    "facsimile",
    "faction",
    "factoid",
    "factor",
    "factsheet",
    "factual",
    "faculty",
    "fade",
    "fading",
    "failing",
    "falcon",
    "fall",
    "false",
    "falsify",
    "fame",
    "familiar",
    "family",
    "famine",
    "famished",
    "fanatic",
    "fancied",
    "fanciness",
    "fancy",
    "fanfare",
    "fang",
    "fanning",
    "fantasize",
    "fantastic",
    "fantasy",
    "fascism",
    "fastball",
    "faster",
    "fasting",
    "fastness",
    "faucet",
    "favorable",
    "favorably",
    "favored",
    "favoring",
    "favorite",
    "fax",
    "feast",
    "federal",
    "fedora",
    "feeble",
    "feed",
    "feel",
    "feisty",
    "feline",
    "felt-tip",
    "feminine",
    "feminism",
    "feminist",
    "feminize",
    "femur",
    "fence",
    "fencing",
    "fender",
    "ferment",
    "fernlike",
    "ferocious",
    "ferocity",
    "ferret",
    "ferris",
    "ferry",
    "fervor",
    "fester",
    "festival",
    "festive",
    "festivity",
    "fetal",
    "fetch",
    "fever",
    "fiber",
    "fiction",
    "fiddle",
    "fiddling",
    "fidelity",
    "fidgeting",
    "fidgety",
    "fifteen",
    "fifth",
    "fiftieth",
    "fifty",
    "figment",
    "figure",
    "figurine",
    "filing",
    "filled",
    "filler",
    "filling",
    "film",
    "filter",
    "filth",
    "filtrate",
    "finale",
    "finalist",
    "finalize",
    "finally",
    "finance",
    "financial",
    "finch",
    "fineness",
    "finer",
    "finicky",
    "finished",
    "finisher",
    "finishing",
    "finite",
    "finless",
    "finlike",
    "fiscally",
    "fit",
    "five",
    "flaccid",
    "flagman",
    "flagpole",
    "flagship",
    "flagstick",
    "flagstone",
    "flail",
    "flakily",
    "flaky",
    "flame",
    "flammable",
    "flanked",
    "flanking",
    "flannels",
    "flap",
    "flaring",
    "flashback",
    "flashbulb",
    "flashcard",
    "flashily",
    "flashing",
    "flashy",
    "flask",
    "flatbed",
    "flatfoot",
    "flatly",
    "flatness",
    "flatten",
    "flattered",
    "flatterer",
    "flattery",
    "flattop",
    "flatware",
    "flatworm",
    "flavored",
    "flavorful",
    "flavoring",
    "flaxseed",
    "fled",
    "fleshed",
    "fleshy",
    "flick",
    "flier",
    "flight",
    "flinch",
    "fling",
    "flint",
    "flip",
    "flirt",
    "float",
    "flock",
    "flogging",
    "flop",
    "floral",
    "florist",
    "floss",
    "flounder",
    "flyable",
    "flyaway",
    "flyer",
    "flying",
    "flyover",
    "flypaper",
    "foam",
    "foe",
    "fog",
    "foil",
    "folic",
    "folk",
    "follicle",
    "follow",
    "fondling",
    "fondly",
    "fondness",
    "fondue",
    "font",
    "food",
    "fool",
    "footage",
    "football",
    "footbath",
    "footboard",
    "footer",
    "footgear",
    "foothill",
    "foothold",
    "footing",
    "footless",
    "footman",
    "footnote",
    "footpad",
    "footpath",
    "footprint",
    "footrest",
    "footsie",
    "footsore",
    "footwear",
    "footwork",
    "fossil",
    "foster",
    "founder",
    "founding",
    "fountain",
    "fox",
    "foyer",
    "fraction",
    "fracture",
    "fragile",
    "fragility",
    "fragment",
    "fragrance",
    "fragrant",
    "frail",
    "frame",
    "framing",
    "frantic",
    "fraternal",
    "frayed",
    "fraying",
    "frays",
    "freckled",
    "freckles",
    "freebase",
    "freebee",
    "freebie",
    "freedom",
    "freefall",
    "freehand",
    "freeing",
    "freeload",
    "freely",
    "freemason",
    "freeness",
    "freestyle",
    "freeware",
    "freeway",
    "freewill",
    "freezable",
    "freezing",
    "freight",
    "french",
    "frenzied",
    "frenzy",
    "frequency",
    "frequent",
    "fresh",
    "fretful",
    "fretted",
    "friction",
    "friday",
    "fridge",
    "fried",
    "friend",
    "frighten",
    "frightful",
    "frigidity",
    "frigidly",
    "frill",
    "fringe",
    "frisbee",
    "frisk",
    "fritter",
    "frivolous",
    "frolic",
    "from",
    "front",
    "frostbite",
    "frosted",
    "frostily",
    "frosting",
    "frostlike",
    "frosty",
    "froth",
    "frown",
    "frozen",
    "fructose",
    "frugality",
    "frugally",
    "fruit",
    "frustrate",
    "frying",
    "gab",
    "gaffe",
    "gag",
    "gainfully",
    "gaining",
    "gains",
    "gala",
    "gallantly",
    "galleria",
    "gallery",
    "galley",
    "gallon",
    "gallows",
    "gallstone",
    "galore",
    "galvanize",
    "gambling",
    "game",
    "gaming",
    "gamma",
    "gander",
    "gangly",
    "gangrene",
    "gangway",
    "gap",
    "garage",
    "garbage",
    "garden",
    "gargle",
    "garland",
    "garlic",
    "garment",
    "garnet",
    "garnish",
    "garter",
    "gas",
    "gatherer",
    "gathering",
    "gating",
    "gauging",
    "gauntlet",
    "gauze",
    "gave",
    "gawk",
    "gazing",
    "gear",
    "gecko",
    "geek",
    "geiger",
    "gem",
    "gender",
    "generic",
    "generous",
    "genetics",
    "genre",
    "gentile",
    "gentleman",
    "gently",
    "gents",
    "geography",
    "geologic",
    "geologist",
    "geology",
    "geometric",
    "geometry",
    "geranium",
    "gerbil",
    "geriatric",
    "germicide",
    "germinate",
    "germless",
    "germproof",
    "gestate",
    "gestation",
    "gesture",
    "getaway",
    "getting",
    "getup",
    "giant",
    "gibberish",
    "giblet",
    "giddily",
    "giddiness",
    "giddy",
    "gift",
    "gigabyte",
    "gigahertz",
    "gigantic",
    "giggle",
    "giggling",
    "giggly",
    "gigolo",
    "gilled",
    "gills",
    "gimmick",
    "girdle",
    "giveaway",
    "given",
    "giver",
    "giving",
    "gizmo",
    "gizzard",
    "glacial",
    "glacier",
    "glade",
    "gladiator",
    "gladly",
    "glamorous",
    "glamour",
    "glance",
    "glancing",
    "glandular",
    "glare",
    "glaring",
    "glass",
    "glaucoma",
    "glazing",
    "gleaming",
    "gleeful",
    "glider",
    "gliding",
    "glimmer",
    "glimpse",
    "glisten",
    "glitch",
    "glitter",
    "glitzy",
    "gloater",
    "gloating",
    "gloomily",
    "gloomy",
    "glorified",
    "glorifier",
    "glorify",
    "glorious",
    "glory",
    "gloss",
    "glove",
    "glowing",
    "glowworm",
    "glucose",
    "glue",
    "gluten",
    "glutinous",
    "glutton",
    "gnarly",
    "gnat",
    "goal",
    "goatskin",
    "goes",
    "goggles",
    "going",
    "goldfish",
    "goldmine",
    "goldsmith",
    "golf",
    "goliath",
    "gonad",
    "gondola",
    "gone",
    "gong",
    "good",
    "gooey",
    "goofball",
    "goofiness",
    "goofy",
    "google",
    "goon",
    "gopher",
    "gore",
    "gorged",
    "gorgeous",
    "gory",
    "gosling",
    "gossip",
    "gothic",
    "gotten",
    "gout",
    "gown",
    "grab",
    "graceful",
    "graceless",
    "gracious",
    "gradation",
    "graded",
    "grader",
    "gradient",
    "grading",
    "gradually",
    "graduate",
    "graffiti",
    "grafted",
    "grafting",
    "grain",
    "granddad",
    "grandkid",
    "grandly",
    "grandma",
    "grandpa",
    "grandson",
    "granite",
    "granny",
    "granola",
    "grant",
    "granular",
    "grape",
    "graph",
    "grapple",
    "grappling",
    "grasp",
    "grass",
    "gratified",
    "gratify",
    "grating",
    "gratitude",
    "gratuity",
    "gravel",
    "graveness",
    "graves",
    "graveyard",
    "gravitate",
    "gravity",
    "gravy",
    "gray",
    "grazing",
    "greasily",
    "greedily",
    "greedless",
    "greedy",
    "green",
    "greeter",
    "greeting",
    "grew",
    "greyhound",
    "grid",
    "grief",
    "grievance",
    "grieving",
    "grievous",
    "grill",
    "grimace",
    "grimacing",
    "grime",
    "griminess",
    "grimy",
    "grinch",
    "grinning",
    "grip",
    "gristle",
    "grit",
    "groggily",
    "groggy",
    "groin",
    "groom",
    "groove",
    "grooving",
    "groovy",
    "grope",
    "ground",
    "grouped",
    "grout",
    "grove",
    "grower",
    "growing",
    "growl",
    "grub",
    "grudge",
    "grudging",
    "grueling",
    "gruffly",
    "grumble",
    "grumbling",
    "grumbly",
    "grumpily",
    "grunge",
    "grunt",
    "guacamole",
    "guidable",
    "guidance",
    "guide",
    "guiding",
    "guileless",
    "guise",
    "gulf",
    "gullible",
    "gully",
    "gulp",
    "gumball",
    "gumdrop",
    "gumminess",
    "gumming",
    "gummy",
    "gurgle",
    "gurgling",
    "guru",
    "gush",
    "gusto",
    "gusty",
    "gutless",
    "guts",
    "gutter",
    "guy",
    "guzzler",
    "gyration",
    "habitable",
    "habitant",
    "habitat",
    "habitual",
    "hacked",
    "hacker",
    "hacking",
    "hacksaw",
    "had",
    "haggler",
    "haiku",
    "half",
    "halogen",
    "halt",
    "halved",
    "halves",
    "hamburger",
    "hamlet",
    "hammock",
    "hamper",
    "hamster",
    "hamstring",
    "handbag",
    "handball",
    "handbook",
    "handbrake",
    "handcart",
    "handclap",
    "handclasp",
    "handcraft",
    "handcuff",
    "handed",
    "handful",
    "handgrip",
    "handgun",
    "handheld",
    "handiness",
    "handiwork",
    "handlebar",
    "handled",
    "handler",
    "handling",
    "handmade",
    "handoff",
    "handpick",
    "handprint",
    "handrail",
    "handsaw",
    "handset",
    "handsfree",
    "handshake",
    "handstand",
    "handwash",
    "handwork",
    "handwoven",
    "handwrite",
    "handyman",
    "hangnail",
    "hangout",
    "hangover",
    "hangup",
    "hankering",
    "hankie",
    "hanky",
    "haphazard",
    "happening",
    "happier",
    "happiest",
    "happily",
    "happiness",
    "happy",
    "harbor",
    "hardcopy",
    "hardcore",
    "hardcover",
    "harddisk",
    "hardened",
    "hardener",
    "hardening",
    "hardhat",
    "hardhead",
    "hardiness",
    "hardly",
    "hardness",
    "hardship",
    "hardware",
    "hardwired",
    "hardwood",
    "hardy",
    "harmful",
    "harmless",
    "harmonica",
    "harmonics",
    "harmonize",
    "harmony",
    "harness",
    "harpist",
    "harsh",
    "harvest",
    "hash",
    "hassle",
    "haste",
    "hastily",
    "hastiness",
    "hasty",
    "hatbox",
    "hatchback",
    "hatchery",
    "hatchet",
    "hatching",
    "hatchling",
    "hate",
    "hatless",
    "hatred",
    "haunt",
    "haven",
    "hazard",
    "hazelnut",
    "hazily",
    "haziness",
    "hazing",
    "hazy",
    "headache",
    "headband",
    "headboard",
    "headcount",
    "headdress",
    "headed",
    "header",
    "headfirst",
    "headgear",
    "heading",
    "headlamp",
    "headless",
    "headlock",
    "headphone",
    "headpiece",
    "headrest",
    "headroom",
    "headscarf",
    "headset",
    "headsman",
    "headstand",
    "headstone",
    "headway",
    "headwear",
    "heap",
    "heat",
    "heave",
    "heavily",
    "heaviness",
    "heaving",
    "hedge",
    "hedging",
    "heftiness",
    "hefty",
    "helium",
    "helmet",
    "helper",
    "helpful",
    "helping",
    "helpless",
    "helpline",
    "hemlock",
    "hemstitch",
    "hence",
    "henchman",
    "henna",
    "herald",
    "herbal",
    "herbicide",
    "herbs",
    "heritage",
    "hermit",
    "heroics",
    "heroism",
    "herring",
    "herself",
    "hertz",
    "hesitancy",
    "hesitant",
    "hesitate",
    "hexagon",
    "hexagram",
    "hubcap",
    "huddle",
    "huddling",
    "huff",
    "hug",
    "hula",
    "hulk",
    "hull",
    "human",
    "humble",
    "humbling",
    "humbly",
    "humid",
    "humiliate",
    "humility",
    "humming",
    "hummus",
    "humongous",
    "humorist",
    "humorless",
    "humorous",
    "humpback",
    "humped",
    "humvee",
    "hunchback",
    "hundredth",
    "hunger",
    "hungrily",
    "hungry",
    "hunk",
    "hunter",
    "hunting",
    "huntress",
    "huntsman",
    "hurdle",
    "hurled",
    "hurler",
    "hurling",
    "hurray",
    "hurricane",
    "hurried",
    "hurry",
    "hurt",
    "husband",
    "hush",
    "husked",
    "huskiness",
    "hut",
    "hybrid",
    "hydrant",
    "hydrated",
    "hydration",
    "hydrogen",
    "hydroxide",
    "hyperlink",
    "hypertext",
    "hyphen",
    "hypnoses",
    "hypnosis",
    "hypnotic",
    "hypnotism",
    "hypnotist",
    "hypnotize",
    "hypocrisy",
    "hypocrite",
    "ibuprofen",
    "ice",
    "iciness",
    "icing",
    "icky",
    "icon",
    "icy",
    "idealism",
    "idealist",
    "idealize",
    "ideally",
    "idealness",
    "identical",
    "identify",
    "identity",
    "ideology",
    "idiocy",
    "idiom",
    "idly",
    "igloo",
    "ignition",
    "ignore",
    "iguana",
    "illicitly",
    "illusion",
    "illusive",
    "image",
    "imaginary",
    "imagines",
    "imaging",
    "imbecile",
    "imitate",
    "imitation",
    "immature",
    "immerse",
    "immersion",
    "imminent",
    "immobile",
    "immodest",
    "immorally",
    "immortal",
    "immovable",
    "immovably",
    "immunity",
    "immunize",
    "impaired",
    "impale",
    "impart",
    "impatient",
    "impeach",
    "impeding",
    "impending",
    "imperfect",
    "imperial",
    "impish",
    "implant",
    "implement",
    "implicate",
    "implicit",
    "implode",
    "implosion",
    "implosive",
    "imply",
    "impolite",
    "important",
    "importer",
    "impose",
    "imposing",
    "impotence",
    "impotency",
    "impotent",
    "impound",
    "imprecise",
    "imprint",
    "imprison",
    "impromptu",
    "improper",
    "improve",
    "improving",
    "improvise",
    "imprudent",
    "impulse",
    "impulsive",
    "impure",
    "impurity",
    "iodine",
    "iodize",
    "ion",
    "ipad",
    "iphone",
    "ipod",
    "irate",
    "irk",
    "iron",
    "irregular",
    "irrigate",
    "irritable",
    "irritably",
    "irritant",
    "irritate",
    "islamic",
    "islamist",
    "isolated",
    "isolating",
    "isolation",
    "isotope",
    "issue",
    "issuing",
    "italicize",
    "italics",
    "item",
    "itinerary",
    "itunes",
    "ivory",
    "ivy",
    "jab",
    "jackal",
    "jacket",
    "jackknife",
    "jackpot",
    "jailbird",
    "jailbreak",
    "jailer",
    "jailhouse",
    "jalapeno",
    "jam",
    "janitor",
    "january",
    "jargon",
    "jarring",
    "jasmine",
    "jaundice",
    "jaunt",
    "java",
    "jawed",
    "jawless",
    "jawline",
    "jaws",
    "jaybird",
    "jaywalker",
    "jazz",
    "jeep",
    "jeeringly",
    "jellied",
    "jelly",
    "jersey",
    "jester",
    "jet",
    "jiffy",
    "jigsaw",
    "jimmy",
    "jingle",
    "jingling",
    "jinx",
    "jitters",
    "jittery",
    "job",
    "jockey",
    "jockstrap",
    "jogger",
    "jogging",
    "john",
    "joining",
    "jokester",
    "jokingly",
    "jolliness",
    "jolly",
    "jolt",
    "jot",
    "jovial",
    "joyfully",
    "joylessly",
    "joyous",
    "joyride",
    "joystick",
    "jubilance",
    "jubilant",
    "judge",
    "judgingly",
    "judicial",
    "judiciary",
    "judo",
    "juggle",
    "juggling",
    "jugular",
    "juice",
    "juiciness",
    "juicy",
    "jujitsu",
    "jukebox",
    "july",
    "jumble",
    "jumbo",
    "jump",
    "junction",
    "juncture",
    "june",
    "junior",
    "juniper",
    "junkie",
    "junkman",
    "junkyard",
    "jurist",
    "juror",
    "jury",
    "justice",
    "justifier",
    "justify",
    "justly",
    "justness",
    "juvenile",
    "kabob",
    "kangaroo",
    "karaoke",
    "karate",
    "karma",
    "kebab",
    "keenly",
    "keenness",
    "keep",
    "keg",
    "kelp",
    "kennel",
    "kept",
    "kerchief",
    "kerosene",
    "kettle",
    "kick",
    "kiln",
    "kilobyte",
    "kilogram",
    "kilometer",
    "kilowatt",
    "kilt",
    "kimono",
    "kindle",
    "kindling",
    "kindly",
    "kindness",
    "kindred",
    "kinetic",
    "kinfolk",
    "king",
    "kinship",
    "kinsman",
    "kinswoman",
    "kissable",
    "kisser",
    "kissing",
    "kitchen",
    "kite",
    "kitten",
    "kitty",
    "kiwi",
    "kleenex",
    "knapsack",
    "knee",
    "knelt",
    "knickers",
    "knoll",
    "koala",
    "kooky",
    "kosher",
    "krypton",
    "kudos",
    "kung",
    "labored",
    "laborer",
    "laboring",
    "laborious",
    "labrador",
    "ladder",
    "ladies",
    "ladle",
    "ladybug",
    "ladylike",
    "lagged",
    "lagging",
    "lagoon",
    "lair",
    "lake",
    "lance",
    "landed",
    "landfall",
    "landfill",
    "landing",
    "landlady",
    "landless",
    "landline",
    "landlord",
    "landmark",
    "landmass",
    "landmine",
    "landowner",
    "landscape",
    "landside",
    "landslide",
    "language",
    "lankiness",
    "lanky",
    "lantern",
    "lapdog",
    "lapel",
    "lapped",
    "lapping",
    "laptop",
    "lard",
    "large",
    "lark",
    "lash",
    "lasso",
    "last",
    "latch",
    "late",
    "lather",
    "latitude",
    "latrine",
    "latter",
    "latticed",
    "launch",
    "launder",
    "laundry",
    "laurel",
    "lavender",
    "lavish",
    "laxative",
    "lazily",
    "laziness",
    "lazy",
    "lecturer",
    "left",
    "legacy",
    "legal",
    "legend",
    "legged",
    "leggings",
    "legible",
    "legibly",
    "legislate",
    "lego",
    "legroom",
    "legume",
    "legwarmer",
    "legwork",
    "lemon",
    "lend",
    "length",
    "lens",
    "lent",
    "leotard",
    "lesser",
    "letdown",
    "lethargic",
    "lethargy",
    "letter",
    "lettuce",
    "level",
    "leverage",
    "levers",
    "levitate",
    "levitator",
    "liability",
    "liable",
    "liberty",
    "librarian",
    "library",
    "licking",
    "licorice",
    "lid",
    "life",
    "lifter",
    "lifting",
    "liftoff",
    "ligament",
    "likely",
    "likeness",
    "likewise",
    "liking",
    "lilac",
    "lilly",
    "lily",
    "limb",
    "limeade",
    "limelight",
    "limes",
    "limit",
    "limping",
    "limpness",
    "line",
    "lingo",
    "linguini",
    "linguist",
    "lining",
    "linked",
    "linoleum",
    "linseed",
    "lint",
    "lion",
    "lip",
    "liquefy",
    "liqueur",
    "liquid",
    "lisp",
    "list",
    "litigate",
    "litigator",
    "litmus",
    "litter",
    "little",
    "livable",
    "lived",
    "lively",
    "liver",
    "livestock",
    "lividly",
    "living",
    "lizard",
    "lubricant",
    "lubricate",
    "lucid",
    "luckily",
    "luckiness",
    "luckless",
    "lucrative",
    "ludicrous",
    "lugged",
    "lukewarm",
    "lullaby",
    "lumber",
    "luminance",
    "luminous",
    "lumpiness",
    "lumping",
    "lumpish",
    "lunacy",
    "lunar",
    "lunchbox",
    "luncheon",
    "lunchroom",
    "lunchtime",
    "lung",
    "lurch",
    "lure",
    "luridness",
    "lurk",
    "lushly",
    "lushness",
    "luster",
    "lustfully",
    "lustily",
    "lustiness",
    "lustrous",
    "lusty",
    "luxurious",
    "luxury",
    "lying",
    "lyrically",
    "lyricism",
    "lyricist",
    "lyrics",
    "macarena",
    "macaroni",
    "macaw",
    "mace",
    "machine",
    "machinist",
    "magazine",
    "magenta",
    "maggot",
    "magical",
    "magician",
    "magma",
    "magnesium",
    "magnetic",
    "magnetism",
    "magnetize",
    "magnifier",
    "magnify",
    "magnitude",
    "magnolia",
    "mahogany",
    "maimed",
    "majestic",
    "majesty",
    "majorette",
    "majority",
    "makeover",
    "maker",
    "makeshift",
    "making",
    "malformed",
    "malt",
    "mama",
    "mammal",
    "mammary",
    "mammogram",
    "manager",
    "managing",
    "manatee",
    "mandarin",
    "mandate",
    "mandatory",
    "mandolin",
    "manger",
    "mangle",
    "mango",
    "mangy",
    "manhandle",
    "manhole",
    "manhood",
    "manhunt",
    "manicotti",
    "manicure",
    "manifesto",
    "manila",
    "mankind",
    "manlike",
    "manliness",
    "manly",
    "manmade",
    "manned",
    "mannish",
    "manor",
    "manpower",
    "mantis",
    "mantra",
    "manual",
    "many",
    "map",
    "marathon",
    "marauding",
    "marbled",
    "marbles",
    "marbling",
    "march",
    "mardi",
    "margarine",
    "margarita",
    "margin",
    "marigold",
    "marina",
    "marine",
    "marital",
    "maritime",
    "marlin",
    "marmalade",
    "maroon",
    "married",
    "marrow",
    "marry",
    "marshland",
    "marshy",
    "marsupial",
    "marvelous",
    "marxism",
    "mascot",
    "masculine",
    "mashed",
    "mashing",
    "massager",
    "masses",
    "massive",
    "mastiff",
    "matador",
    "matchbook",
    "matchbox",
    "matcher",
    "matching",
    "matchless",
    "material",
    "maternal",
    "maternity",
    "math",
    "mating",
    "matriarch",
    "matrimony",
    "matrix",
    "matron",
    "matted",
    "matter",
    "maturely",
    "maturing",
    "maturity",
    "mauve",
    "maverick",
    "maximize",
    "maximum",
    "maybe",
    "mayday",
    "mayflower",
    "moaner",
    "moaning",
    "mobile",
    "mobility",
    "mobilize",
    "mobster",
    "mocha",
    "mocker",
    "mockup",
    "modified",
    "modify",
    "modular",
    "modulator",
    "module",
    "moisten",
    "moistness",
    "moisture",
    "molar",
    "molasses",
    "mold",
    "molecular",
    "molecule",
    "molehill",
    "mollusk",
    "mom",
    "monastery",
    "monday",
    "monetary",
    "monetize",
    "moneybags",
    "moneyless",
    "moneywise",
    "mongoose",
    "mongrel",
    "monitor",
    "monkhood",
    "monogamy",
    "monogram",
    "monologue",
    "monopoly",
    "monorail",
    "monotone",
    "monotype",
    "monoxide",
    "monsieur",
    "monsoon",
    "monstrous",
    "monthly",
    "monument",
    "moocher",
    "moodiness",
    "moody",
    "mooing",
    "moonbeam",
    "mooned",
    "moonlight",
    "moonlike",
    "moonlit",
    "moonrise",
    "moonscape",
    "moonshine",
    "moonstone",
    "moonwalk",
    "mop",
    "morale",
    "morality",
    "morally",
    "morbidity",
    "morbidly",
    "morphine",
    "morphing",
    "morse",
    "mortality",
    "mortally",
    "mortician",
    "mortified",
    "mortify",
    "mortuary",
    "mosaic",
    "mossy",
    "most",
    "mothball",
    "mothproof",
    "motion",
    "motivate",
    "motivator",
    "motive",
    "motocross",
    "motor",
    "motto",
    "mountable",
    "mountain",
    "mounted",
    "mounting",
    "mourner",
    "mournful",
    "mouse",
    "mousiness",
    "moustache",
    "mousy",
    "mouth",
    "movable",
    "move",
    "movie",
    "moving",
    "mower",
    "mowing",
    "much",
    "muck",
    "mud",
    "mug",
    "mulberry",
    "mulch",
    "mule",
    "mulled",
    "mullets",
    "multiple",
    "multiply",
    "multitask",
    "multitude",
    "mumble",
    "mumbling",
    "mumbo",
    "mummified",
    "mummify",
    "mummy",
    "mumps",
    "munchkin",
    "mundane",
    "municipal",
    "muppet",
    "mural",
    "murkiness",
    "murky",
    "murmuring",
    "muscular",
    "museum",
    "mushily",
    "mushiness",
    "mushroom",
    "mushy",
    "music",
    "musket",
    "muskiness",
    "musky",
    "mustang",
    "mustard",
    "muster",
    "mustiness",
    "musty",
    "mutable",
    "mutate",
    "mutation",
    "mute",
    "mutilated",
    "mutilator",
    "mutiny",
    "mutt",
    "mutual",
    "muzzle",
    "myself",
    "myspace",
    "mystified",
    "mystify",
    "myth",
    "nacho",
    "nag",
    "nail",
    "name",
    "naming",
    "nanny",
    "nanometer",
    "nape",
    "napkin",
    "napped",
    "napping",
    "nappy",
    "narrow",
    "nastily",
    "nastiness",
    "national",
    "native",
    "nativity",
    "natural",
    "nature",
    "naturist",
    "nautical",
    "navigate",
    "navigator",
    "navy",
    "nearby",
    "nearest",
    "nearly",
    "nearness",
    "neatly",
    "neatness",
    "nebula",
    "nebulizer",
    "nectar",
    "negate",
    "negation",
    "negative",
    "neglector",
    "negligee",
    "negligent",
    "negotiate",
    "nemeses",
    "nemesis",
    "neon",
    "nephew",
    "nerd",
    "nervous",
    "nervy",
    "nest",
    "net",
    "neurology",
    "neuron",
    "neurosis",
    "neurotic",
    "neuter",
    "neutron",
    "never",
    "next",
    "nibble",
    "nickname",
    "nicotine",
    "niece",
    "nifty",
    "nimble",
    "nimbly",
    "nineteen",
    "ninetieth",
    "ninja",
    "nintendo",
    "ninth",
    "nuclear",
    "nuclei",
    "nucleus",
    "nugget",
    "nullify",
    "number",
    "numbing",
    "numbly",
    "numbness",
    "numeral",
    "numerate",
    "numerator",
    "numeric",
    "numerous",
    "nuptials",
    "nursery",
    "nursing",
    "nurture",
    "nutcase",
    "nutlike",
    "nutmeg",
    "nutrient",
    "nutshell",
    "nuttiness",
    "nutty",
    "nuzzle",
    "nylon",
    "oaf",
    "oak",
    "oasis",
    "oat",
    "obedience",
    "obedient",
    "obituary",
    "object",
    "obligate",
    "obliged",
    "oblivion",
    "oblivious",
    "oblong",
    "obnoxious",
    "oboe",
    "obscure",
    "obscurity",
    "observant",
    "observer",
    "observing",
    "obsessed",
    "obsession",
    "obsessive",
    "obsolete",
    "obstacle",
    "obstinate",
    "obstruct",
    "obtain",
    "obtrusive",
    "obtuse",
    "obvious",
    "occultist",
    "occupancy",
    "occupant",
    "occupier",
    "occupy",
    "ocean",
    "ocelot",
    "octagon",
    "octane",
    "october",
    "octopus",
    "ogle",
    "oil",
    "oink",
    "ointment",
    "okay",
    "old",
    "olive",
    "olympics",
    "omega",
    "omen",
    "ominous",
    "omission",
    "omit",
    "omnivore",
    "onboard",
    "oncoming",
    "ongoing",
    "onion",
    "online",
    "onlooker",
    "only",
    "onscreen",
    "onset",
    "onshore",
    "onslaught",
    "onstage",
    "onto",
    "onward",
    "onyx",
    "oops",
    "ooze",
    "oozy",
    "opacity",
    "opal",
    "open",
    "operable",
    "operate",
    "operating",
    "operation",
    "operative",
    "operator",
    "opium",
    "opossum",
    "opponent",
    "oppose",
    "opposing",
    "opposite",
    "oppressed",
    "oppressor",
    "opt",
    "opulently",
    "osmosis",
    "other",
    "otter",
    "ouch",
    "ought",
    "ounce",
    "outage",
    "outback",
    "outbid",
    "outboard",
    "outbound",
    "outbreak",
    "outburst",
    "outcast",
    "outclass",
    "outcome",
    "outdated",
    "outdoors",
    "outer",
    "outfield",
    "outfit",
    "outflank",
    "outgoing",
    "outgrow",
    "outhouse",
    "outing",
    "outlast",
    "outlet",
    "outline",
    "outlook",
    "outlying",
    "outmatch",
    "outmost",
    "outnumber",
    "outplayed",
    "outpost",
    "outpour",
    "output",
    "outrage",
    "outrank",
    "outreach",
    "outright",
    "outscore",
    "outsell",
    "outshine",
    "outshoot",
    "outsider",
    "outskirts",
    "outsmart",
    "outsource",
    "outspoken",
    "outtakes",
    "outthink",
    "outward",
    "outweigh",
    "outwit",
    "oval",
    "ovary",
    "oven",
    "overact",
    "overall",
    "overarch",
    "overbid",
    "overbill",
    "overbite",
    "overblown",
    "overboard",
    "overbook",
    "overbuilt",
    "overcast",
    "overcoat",
    "overcome",
    "overcook",
    "overcrowd",
    "overdraft",
    "overdrawn",
    "overdress",
    "overdrive",
    "overdue",
    "overeager",
    "overeater",
    "overexert",
    "overfed",
    "overfeed",
    "overfill",
    "overflow",
    "overfull",
    "overgrown",
    "overhand",
    "overhang",
    "overhaul",
    "overhead",
    "overhear",
    "overheat",
    "overhung",
    "overjoyed",
    "overkill",
    "overlabor",
    "overlaid",
    "overlap",
    "overlay",
    "overload",
    "overlook",
    "overlord",
    "overlying",
    "overnight",
    "overpass",
    "overpay",
    "overplant",
    "overplay",
    "overpower",
    "overprice",
    "overrate",
    "overreach",
    "overreact",
    "override",
    "overripe",
    "overrule",
    "overrun",
    "overshoot",
    "overshot",
    "oversight",
    "oversized",
    "oversleep",
    "oversold",
    "overspend",
    "overstate",
    "overstay",
    "overstep",
    "overstock",
    "overstuff",
    "oversweet",
    "overtake",
    "overthrow",
    "overtime",
    "overtly",
    "overtone",
    "overture",
    "overturn",
    "overuse",
    "overvalue",
    "overview",
    "overwrite",
    "owl",
    "oxford",
    "oxidant",
    "oxidation",
    "oxidize",
    "oxidizing",
    "oxygen",
    "oxymoron",
    "oyster",
    "ozone",
    "paced",
    "pacemaker",
    "pacific",
    "pacifier",
    "pacifism",
    "pacifist",
    "pacify",
    "padded",
    "padding",
    "paddle",
    "paddling",
    "padlock",
    "pagan",
    "pager",
    "paging",
    "pajamas",
    "palace",
    "palatable",
    "palm",
    "palpable",
    "palpitate",
    "paltry",
    "pampered",
    "pamperer",
    "pampers",
    "pamphlet",
    "panama",
    "pancake",
    "pancreas",
    "panda",
    "pandemic",
    "pang",
    "panhandle",
    "panic",
    "panning",
    "panorama",
    "panoramic",
    "panther",
    "pantomime",
    "pantry",
    "pants",
    "pantyhose",
    "paparazzi",
    "papaya",
    "paper",
    "paprika",
    "papyrus",
    "parabola",
    "parachute",
    "parade",
    "paradox",
    "paragraph",
    "parakeet",
    "paralegal",
    "paralyses",
    "paralysis",
    "paralyze",
    "paramedic",
    "parameter",
    "paramount",
    "parasail",
    "parasite",
    "parasitic",
    "parcel",
    "parched",
    "parchment",
    "pardon",
    "parish",
    "parka",
    "parking",
    "parkway",
    "parlor",
    "parmesan",
    "parole",
    "parrot",
    "parsley",
    "parsnip",
    "partake",
    "parted",
    "parting",
    "partition",
    "partly",
    "partner",
    "partridge",
    "party",
    "passable",
    "passably",
    "passage",
    "passcode",
    "passenger",
    "passerby",
    "passing",
    "passion",
    "passive",
    "passivism",
    "passover",
    "passport",
    "password",
    "pasta",
    "pasted",
    "pastel",
    "pastime",
    "pastor",
    "pastrami",
    "pasture",
    "pasty",
    "patchwork",
    "patchy",
    "paternal",
    "paternity",
    "path",
    "patience",
    "patient",
    "patio",
    "patriarch",
    "patriot",
    "patrol",
    "patronage",
    "patronize",
    "pauper",
    "pavement",
    "paver",
    "pavestone",
    "pavilion",
    "paving",
    "pawing",
    "payable",
    "payback",
    "paycheck",
    "payday",
    "payee",
    "payer",
    "paying",
    "payment",
    "payphone",
    "payroll",
    "pebble",
    "pebbly",
    "pecan",
    "pectin",
    "peculiar",
    "peddling",
    "pediatric",
    "pedicure",
    "pedigree",
    "pedometer",
    "pegboard",
    "pelican",
    "pellet",
    "pelt",
    "pelvis",
    "penalize",
    "penalty",
    "pencil",
    "pendant",
    "pending",
    "penholder",
    "penknife",
    "pennant",
    "penniless",
    "penny",
    "penpal",
    "pension",
    "pentagon",
    "pentagram",
    "pep",
    "perceive",
    "percent",
    "perch",
    "percolate",
    "perennial",
    "perfected",
    "perfectly",
    "perfume",
    "periscope",
    "perish",
    "perjurer",
    "perjury",
    "perkiness",
    "perky",
    "perm",
    "peroxide",
    "perpetual",
    "perplexed",
    "persecute",
    "persevere",
    "persuaded",
    "persuader",
    "pesky",
    "peso",
    "pessimism",
    "pessimist",
    "pester",
    "pesticide",
    "petal",
    "petite",
    "petition",
    "petri",
    "petroleum",
    "petted",
    "petticoat",
    "pettiness",
    "petty",
    "petunia",
    "phantom",
    "phobia",
    "phoenix",
    "phonebook",
    "phoney",
    "phonics",
    "phoniness",
    "phony",
    "phosphate",
    "photo",
    "phrase",
    "phrasing",
    "placard",
    "placate",
    "placidly",
    "plank",
    "planner",
    "plant",
    "plasma",
    "plaster",
    "plastic",
    "plated",
    "platform",
    "plating",
    "platinum",
    "platonic",
    "platter",
    "platypus",
    "plausible",
    "plausibly",
    "playable",
    "playback",
    "player",
    "playful",
    "playgroup",
    "playhouse",
    "playing",
    "playlist",
    "playmaker",
    "playmate",
    "playoff",
    "playpen",
    "playroom",
    "playset",
    "plaything",
    "playtime",
    "plaza",
    "pleading",
    "pleat",
    "pledge",
    "plentiful",
    "plenty",
    "plethora",
    "plexiglas",
    "pliable",
    "plod",
    "plop",
    "plot",
    "plow",
    "ploy",
    "pluck",
    "plug",
    "plunder",
    "plunging",
    "plural",
    "plus",
    "plutonium",
    "plywood",
    "poach",
    "pod",
    "poem",
    "poet",
    "pogo",
    "pointed",
    "pointer",
    "pointing",
    "pointless",
    "pointy",
    "poise",
    "poison",
    "poker",
    "poking",
    "polar",
    "police",
    "policy",
    "polio",
    "polish",
    "politely",
    "polka",
    "polo",
    "polyester",
    "polygon",
    "polygraph",
    "polymer",
    "poncho",
    "pond",
    "pony",
    "popcorn",
    "pope",
    "poplar",
    "popper",
    "poppy",
    "popsicle",
    "populace",
    "popular",
    "populate",
    "porcupine",
    "pork",
    "porous",
    "porridge",
    "portable",
    "portal",
    "portfolio",
    "porthole",
    "portion",
    "portly",
    "portside",
    "poser",
    "posh",
    "posing",
    "possible",
    "possibly",
    "possum",
    "postage",
    "postal",
    "postbox",
    "postcard",
    "posted",
    "poster",
    "posting",
    "postnasal",
    "posture",
    "postwar",
    "pouch",
    "pounce",
    "pouncing",
    "pound",
    "pouring",
    "pout",
    "powdered",
    "powdering",
    "powdery",
    "power",
    "powwow",
    "pox",
    "praising",
    "prance",
    "prancing",
    "pranker",
    "prankish",
    "prankster",
    "prayer",
    "praying",
    "preacher",
    "preaching",
    "preachy",
    "preamble",
    "precinct",
    "precise",
    "precision",
    "precook",
    "precut",
    "predator",
    "predefine",
    "predict",
    "preface",
    "prefix",
    "preflight",
    "preformed",
    "pregame",
    "pregnancy",
    "pregnant",
    "preheated",
    "prelaunch",
    "prelaw",
    "prelude",
    "premiere",
    "premises",
    "premium",
    "prenatal",
    "preoccupy",
    "preorder",
    "prepaid",
    "prepay",
    "preplan",
    "preppy",
    "preschool",
    "prescribe",
    "preseason",
    "preset",
    "preshow",
    "president",
    "presoak",
    "press",
    "presume",
    "presuming",
    "preteen",
    "pretended",
    "pretender",
    "pretense",
    "pretext",
    "pretty",
    "pretzel",
    "prevail",
    "prevalent",
    "prevent",
    "preview",
    "previous",
    "prewar",
    "prewashed",
    "prideful",
    "pried",
    "primal",
    "primarily",
    "primary",
    "primate",
    "primer",
    "primp",
    "princess",
    "print",
    "prior",
    "prism",
    "prison",
    "prissy",
    "pristine",
    "privacy",
    "private",
    "privatize",
    "prize",
    "proactive",
    "probable",
    "probably",
    "probation",
    "probe",
    "probing",
    "probiotic",
    "problem",
    "procedure",
    "process",
    "proclaim",
    "procreate",
    "procurer",
    "prodigal",
    "prodigy",
    "produce",
    "product",
    "profane",
    "profanity",
    "professed",
    "professor",
    "profile",
    "profound",
    "profusely",
    "progeny",
    "prognosis",
    "program",
    "progress",
    "projector",
    "prologue",
    "prolonged",
    "promenade",
    "prominent",
    "promoter",
    "promotion",
    "prompter",
    "promptly",
    "prone",
    "prong",
    "pronounce",
    "pronto",
    "proofing",
    "proofread",
    "proofs",
    "propeller",
    "properly",
    "property",
    "proponent",
    "proposal",
    "propose",
    "props",
    "prorate",
    "protector",
    "protegee",
    "proton",
    "prototype",
    "protozoan",
    "protract",
    "protrude",
    "proud",
    "provable",
    "proved",
    "proven",
    "provided",
    "provider",
    "providing",
    "province",
    "proving",
    "provoke",
    "provoking",
    "provolone",
    "prowess",
    "prowler",
    "prowling",
    "proximity",
    "proxy",
    "prozac",
    "prude",
    "prudishly",
    "prune",
    "pruning",
    "pry",
    "psychic",
    "public",
    "publisher",
    "pucker",
    "pueblo",
    "pug",
    "pull",
    "pulmonary",
    "pulp",
    "pulsate",
    "pulse",
    "pulverize",
    "puma",
    "pumice",
    "pummel",
    "punch",
    "punctual",
    "punctuate",
    "punctured",
    "pungent",
    "punisher",
    "punk",
    "pupil",
    "puppet",
    "puppy",
    "purchase",
    "pureblood",
    "purebred",
    "purely",
    "pureness",
    "purgatory",
    "purge",
    "purging",
    "purifier",
    "purify",
    "purist",
    "puritan",
    "purity",
    "purple",
    "purplish",
    "purposely",
    "purr",
    "purse",
    "pursuable",
    "pursuant",
    "pursuit",
    "purveyor",
    "pushcart",
    "pushchair",
    "pusher",
    "pushiness",
    "pushing",
    "pushover",
    "pushpin",
    "pushup",
    "pushy",
    "putdown",
    "putt",
    "puzzle",
    "puzzling",
    "pyramid",
    "pyromania",
    "python",
    "quack",
    "quadrant",
    "quail",
    "quaintly",
    "quake",
    "quaking",
    "qualified",
    "qualifier",
    "qualify",
    "quality",
    "qualm",
    "quantum",
    "quarrel",
    "quarry",
    "quartered",
    "quarterly",
    "quarters",
    "quartet",
    "quench",
    "query",
    "quicken",
    "quickly",
    "quickness",
    "quicksand",
    "quickstep",
    "quiet",
    "quill",
    "quilt",
    "quintet",
    "quintuple",
    "quirk",
    "quit",
    "quiver",
    "quizzical",
    "quotable",
    "quotation",
    "quote",
    "rabid",
    "race",
    "racing",
    "racism",
    "rack",
    "racoon",
    "radar",
    "radial",
    "radiance",
    "radiantly",
    "radiated",
    "radiation",
    "radiator",
    "radio",
    "radish",
    "raffle",
    "raft",
    "rage",
    "ragged",
    "raging",
    "ragweed",
    "raider",
    "railcar",
    "railing",
    "railroad",
    "railway",
    "raisin",
    "rake",
    "raking",
    "rally",
    "ramble",
    "rambling",
    "ramp",
    "ramrod",
    "ranch",
    "rancidity",
    "random",
    "ranged",
    "ranger",
    "ranging",
    "ranked",
    "ranking",
    "ransack",
    "ranting",
    "rants",
    "rare",
    "rarity",
    "rascal",
    "rash",
    "rasping",
    "ravage",
    "raven",
    "ravine",
    "raving",
    "ravioli",
    "ravishing",
    "reabsorb",
    "reach",
    "reacquire",
    "reaction",
    "reactive",
    "reactor",
    "reaffirm",
    "ream",
    "reanalyze",
    "reappear",
    "reapply",
    "reappoint",
    "reapprove",
    "rearrange",
    "rearview",
    "reason",
    "reassign",
    "reassure",
    "reattach",
    "reawake",
    "rebalance",
    "rebate",
    "rebel",
    "rebirth",
    "reboot",
    "reborn",
    "rebound",
    "rebuff",
    "rebuild",
    "rebuilt",
    "reburial",
    "rebuttal",
    "recall",
    "recant",
    "recapture",
    "recast",
    "recede",
    "recent",
    "recess",
    "recharger",
    "recipient",
    "recital",
    "recite",
    "reckless",
    "reclaim",
    "recliner",
    "reclining",
    "recluse",
    "reclusive",
    "recognize",
    "recoil",
    "recollect",
    "recolor",
    "reconcile",
    "reconfirm",
    "reconvene",
    "recopy",
    "record",
    "recount",
    "recoup",
    "recovery",
    "recreate",
    "rectal",
    "rectangle",
    "rectified",
    "rectify",
    "recycled",
    "recycler",
    "recycling",
    "reemerge",
    "reenact",
    "reenter",
    "reentry",
    "reexamine",
    "referable",
    "referee",
    "reference",
    "refill",
    "refinance",
    "refined",
    "refinery",
    "refining",
    "refinish",
    "reflected",
    "reflector",
    "reflex",
    "reflux",
    "refocus",
    "refold",
    "reforest",
    "reformat",
    "reformed",
    "reformer",
    "reformist",
    "refract",
    "refrain",
    "refreeze",
    "refresh",
    "refried",
    "refueling",
    "refund",
    "refurbish",
    "refurnish",
    "refusal",
    "refuse",
    "refusing",
    "refutable",
    "refute",
    "regain",
    "regalia",
    "regally",
    "reggae",
    "regime",
    "region",
    "register",
    "registrar",
    "registry",
    "regress",
    "regretful",
    "regroup",
    "regular",
    "regulate",
    "regulator",
    "rehab",
    "reheat",
    "rehire",
    "rehydrate",
    "reimburse",
    "reissue",
    "reiterate",
    "rejoice",
    "rejoicing",
    "rejoin",
    "rekindle",
    "relapse",
    "relapsing",
    "relatable",
    "related",
    "relation",
    "relative",
    "relax",
    "relay",
    "relearn",
    "release",
    "relenting",
    "reliable",
    "reliably",
    "reliance",
    "reliant",
    "relic",
    "relieve",
    "relieving",
    "relight",
    "relish",
    "relive",
    "reload",
    "relocate",
    "relock",
    "reluctant",
    "rely",
    "remake",
    "remark",
    "remarry",
    "rematch",
    "remedial",
    "remedy",
    "remember",
    "reminder",
    "remindful",
    "remission",
    "remix",
    "remnant",
    "remodeler",
    "remold",
    "remorse",
    "remote",
    "removable",
    "removal",
    "removed",
    "remover",
    "removing",
    "rename",
    "renderer",
    "rendering",
    "rendition",
    "renegade",
    "renewable",
    "renewably",
    "renewal",
    "renewed",
    "renounce",
    "renovate",
    "renovator",
    "rentable",
    "rental",
    "rented",
    "renter",
    "reoccupy",
    "reoccur",
    "reopen",
    "reorder",
    "repackage",
    "repacking",
    "repaint",
    "repair",
    "repave",
    "repaying",
    "repayment",
    "repeal",
    "repeated",
    "repeater",
    "repent",
    "rephrase",
    "replace",
    "replay",
    "replica",
    "reply",
    "reporter",
    "repose",
    "repossess",
    "repost",
    "repressed",
    "reprimand",
    "reprint",
    "reprise",
    "reproach",
    "reprocess",
    "reproduce",
    "reprogram",
    "reps",
    "reptile",
    "reptilian",
    "repugnant",
    "repulsion",
    "repulsive",
    "repurpose",
    "reputable",
    "reputably",
    "request",
    "require",
    "requisite",
    "reroute",
    "rerun",
    "resale",
    "resample",
    "rescuer",
    "reseal",
    "research",
    "reselect",
    "reseller",
    "resemble",
    "resend",
    "resent",
    "reset",
    "reshape",
    "reshoot",
    "reshuffle",
    "residence",
    "residency",
    "resident",
    "residual",
    "residue",
    "resigned",
    "resilient",
    "resistant",
    "resisting",
    "resize",
    "resolute",
    "resolved",
    "resonant",
    "resonate",
    "resort",
    "resource",
    "respect",
    "resubmit",
    "result",
    "resume",
    "resupply",
    "resurface",
    "resurrect",
    "retail",
    "retainer",
    "retaining",
    "retake",
    "retaliate",
    "retention",
    "rethink",
    "retinal",
    "retired",
    "retiree",
    "retiring",
    "retold",
    "retool",
    "retorted",
    "retouch",
    "retrace",
    "retract",
    "retrain",
    "retread",
    "retreat",
    "retrial",
    "retrieval",
    "retriever",
    "retry",
    "return",
    "retying",
    "retype",
    "reunion",
    "reunite",
    "reusable",
    "reuse",
    "reveal",
    "reveler",
    "revenge",
    "revenue",
    "reverb",
    "revered",
    "reverence",
    "reverend",
    "reversal",
    "reverse",
    "reversing",
    "reversion",
    "revert",
    "revisable",
    "revise",
    "revision",
    "revisit",
    "revivable",
    "revival",
    "reviver",
    "reviving",
    "revocable",
    "revoke",
    "revolt",
    "revolver",
    "revolving",
    "reward",
    "rewash",
    "rewind",
    "rewire",
    "reword",
    "rework",
    "rewrap",
    "rewrite",
    "rhyme",
    "ribbon",
    "ribcage",
    "rice",
    "riches",
    "richly",
    "richness",
    "rickety",
    "ricotta",
    "riddance",
    "ridden",
    "ride",
    "riding",
    "rifling",
    "rift",
    "rigging",
    "rigid",
    "rigor",
    "rimless",
    "rimmed",
    "rind",
    "rink",
    "rinse",
    "rinsing",
    "riot",
    "ripcord",
    "ripeness",
    "ripening",
    "ripping",
    "ripple",
    "rippling",
    "riptide",
    "rise",
    "rising",
    "risk",
    "risotto",
    "ritalin",
    "ritzy",
    "rival",
    "riverbank",
    "riverbed",
    "riverboat",
    "riverside",
    "riveter",
    "riveting",
    "roamer",
    "roaming",
    "roast",
    "robbing",
    "robe",
    "robin",
    "robotics",
    "robust",
    "rockband",
    "rocker",
    "rocket",
    "rockfish",
    "rockiness",
    "rocking",
    "rocklike",
    "rockslide",
    "rockstar",
    "rocky",
    "rogue",
    "roman",
    "romp",
    "rope",
    "roping",
    "roster",
    "rosy",
    "rotten",
    "rotting",
    "rotunda",
    "roulette",
    "rounding",
    "roundish",
    "roundness",
    "roundup",
    "roundworm",
    "routine",
    "routing",
    "rover",
    "roving",
    "royal",
    "rubbed",
    "rubber",
    "rubbing",
    "rubble",
    "rubdown",
    "ruby",
    "ruckus",
    "rudder",
    "rug",
    "ruined",
    "rule",
    "rumble",
    "rumbling",
    "rummage",
    "rumor",
    "runaround",
    "rundown",
    "runner",
    "running",
    "runny",
    "runt",
    "runway",
    "rupture",
    "rural",
    "ruse",
    "rush",
    "rust",
    "rut",
    "sabbath",
    "sabotage",
    "sacrament",
    "sacred",
    "sacrifice",
    "sadden",
    "saddlebag",
    "saddled",
    "saddling",
    "sadly",
    "sadness",
    "safari",
    "safeguard",
    "safehouse",
    "safely",
    "safeness",
    "saffron",
    "saga",
    "sage",
    "sagging",
    "saggy",
    "said",
    "saint",
    "sake",
    "salad",
    "salami",
    "salaried",
    "salary",
    "saline",
    "salon",
    "saloon",
    "salsa",
    "salt",
    "salutary",
    "salute",
    "salvage",
    "salvaging",
    "salvation",
    "same",
    "sample",
    "sampling",
    "sanction",
    "sanctity",
    "sanctuary",
    "sandal",
    "sandbag",
    "sandbank",
    "sandbar",
    "sandblast",
    "sandbox",
    "sanded",
    "sandfish",
    "sanding",
    "sandlot",
    "sandpaper",
    "sandpit",
    "sandstone",
    "sandstorm",
    "sandworm",
    "sandy",
    "sanitary",
    "sanitizer",
    "sank",
    "santa",
    "sapling",
    "sappiness",
    "sappy",
    "sarcasm",
    "sarcastic",
    "sardine",
    "sash",
    "sasquatch",
    "sassy",
    "satchel",
    "satiable",
    "satin",
    "satirical",
    "satisfied",
    "satisfy",
    "saturate",
    "saturday",
    "sauciness",
    "saucy",
    "sauna",
    "savage",
    "savanna",
    "saved",
    "savings",
    "savior",
    "savor",
    "saxophone",
    "say",
    "scabbed",
    "scabby",
    "scalded",
    "scalding",
    "scale",
    "scaling",
    "scallion",
    "scallop",
    "scalping",
    "scam",
    "scandal",
    "scanner",
    "scanning",
    "scant",
    "scapegoat",
    "scarce",
    "scarcity",
    "scarecrow",
    "scared",
    "scarf",
    "scarily",
    "scariness",
    "scarring",
    "scary",
    "scavenger",
    "scenic",
    "schedule",
    "schematic",
    "scheme",
    "scheming",
    "schilling",
    "schnapps",
    "scholar",
    "science",
    "scientist",
    "scion",
    "scoff",
    "scolding",
    "scone",
    "scoop",
    "scooter",
    "scope",
    "scorch",
    "scorebook",
    "scorecard",
    "scored",
    "scoreless",
    "scorer",
    "scoring",
    "scorn",
    "scorpion",
    "scotch",
    "scoundrel",
    "scoured",
    "scouring",
    "scouting",
    "scouts",
    "scowling",
    "scrabble",
    "scraggly",
    "scrambled",
    "scrambler",
    "scrap",
    "scratch",
    "scrawny",
    "screen",
    "scribble",
    "scribe",
    "scribing",
    "scrimmage",
    "script",
    "scroll",
    "scrooge",
    "scrounger",
    "scrubbed",
    "scrubber",
    "scruffy",
    "scrunch",
    "scrutiny",
    "scuba",
    "scuff",
    "sculptor",
    "sculpture",
    "scurvy",
    "scuttle",
    "secluded",
    "secluding",
    "seclusion",
    "second",
    "secrecy",
    "secret",
    "sectional",
    "sector",
    "secular",
    "securely",
    "security",
    "sedan",
    "sedate",
    "sedation",
    "sedative",
    "sediment",
    "seduce",
    "seducing",
    "segment",
    "seismic",
    "seizing",
    "seldom",
    "selected",
    "selection",
    "selective",
    "selector",
    "self",
    "seltzer",
    "semantic",
    "semester",
    "semicolon",
    "semifinal",
    "seminar",
    "semisoft",
    "semisweet",
    "senate",
    "senator",
    "send",
    "senior",
    "senorita",
    "sensation",
    "sensitive",
    "sensitize",
    "sensually",
    "sensuous",
    "sepia",
    "september",
    "septic",
    "septum",
    "sequel",
    "sequence",
    "sequester",
    "series",
    "sermon",
    "serotonin",
    "serpent",
    "serrated",
    "serve",
    "service",
    "serving",
    "sesame",
    "sessions",
    "setback",
    "setting",
    "settle",
    "settling",
    "setup",
    "sevenfold",
    "seventeen",
    "seventh",
    "seventy",
    "severity",
    "shabby",
    "shack",
    "shaded",
    "shadily",
    "shadiness",
    "shading",
    "shadow",
    "shady",
    "shaft",
    "shakable",
    "shakily",
    "shakiness",
    "shaking",
    "shaky",
    "shale",
    "shallot",
    "shallow",
    "shame",
    "shampoo",
    "shamrock",
    "shank",
    "shanty",
    "shape",
    "shaping",
    "share",
    "sharpener",
    "sharper",
    "sharpie",
    "sharply",
    "sharpness",
    "shawl",
    "sheath",
    "shed",
    "sheep",
    "sheet",
    "shelf",
    "shell",
    "shelter",
    "shelve",
    "shelving",
    "sherry",
    "shield",
    "shifter",
    "shifting",
    "shiftless",
    "shifty",
    "shimmer",
    "shimmy",
    "shindig",
    "shine",
    "shingle",
    "shininess",
    "shining",
    "shiny",
    "ship",
    "shirt",
    "shivering",
    "shock",
    "shone",
    "shoplift",
    "shopper",
    "shopping",
    "shoptalk",
    "shore",
    "shortage",
    "shortcake",
    "shortcut",
    "shorten",
    "shorter",
    "shorthand",
    "shortlist",
    "shortly",
    "shortness",
    "shorts",
    "shortwave",
    "shorty",
    "shout",
    "shove",
    "showbiz",
    "showcase",
    "showdown",
    "shower",
    "showgirl",
    "showing",
    "showman",
    "shown",
    "showoff",
    "showpiece",
    "showplace",
    "showroom",
    "showy",
    "shrank",
    "shrapnel",
    "shredder",
    "shredding",
    "shrewdly",
    "shriek",
    "shrill",
    "shrimp",
    "shrine",
    "shrink",
    "shrivel",
    "shrouded",
    "shrubbery",
    "shrubs",
    "shrug",
    "shrunk",
    "shucking",
    "shudder",
    "shuffle",
    "shuffling",
    "shun",
    "shush",
    "shut",
    "shy",
    "siamese",
    "siberian",
    "sibling",
    "siding",
    "sierra",
    "siesta",
    "sift",
    "sighing",
    "silenced",
    "silencer",
    "silent",
    "silica",
    "silicon",
    "silk",
    "silliness",
    "silly",
    "silo",
    "silt",
    "silver",
    "similarly",
    "simile",
    "simmering",
    "simple",
    "simplify",
    "simply",
    "sincere",
    "sincerity",
    "singer",
    "singing",
    "single",
    "singular",
    "sinister",
    "sinless",
    "sinner",
    "sinuous",
    "sip",
    "siren",
    "sister",
    "sitcom",
    "sitter",
    "sitting",
    "situated",
    "situation",
    "sixfold",
    "sixteen",
    "sixth",
    "sixties",
    "sixtieth",
    "sixtyfold",
    "sizable",
    "sizably",
    "size",
    "sizing",
    "sizzle",
    "sizzling",
    "skater",
    "skating",
    "skedaddle",
    "skeletal",
    "skeleton",
    "skeptic",
    "sketch",
    "skewed",
    "skewer",
    "skid",
    "skied",
    "skier",
    "skies",
    "skiing",
    "skilled",
    "skillet",
    "skillful",
    "skimmed",
    "skimmer",
    "skimming",
    "skimpily",
    "skincare",
    "skinhead",
    "skinless",
    "skinning",
    "skinny",
    "skintight",
    "skipper",
    "skipping",
    "skirmish",
    "skirt",
    "skittle",
    "skydiver",
    "skylight",
    "skyline",
    "skype",
    "skyrocket",
    "skyward",
    "slab",
    "slacked",
    "slacker",
    "slacking",
    "slackness",
    "slacks",
    "slain",
    "slam",
    "slander",
    "slang",
    "slapping",
    "slapstick",
    "slashed",
    "slashing",
    "slate",
    "slather",
    "slaw",
    "sled",
    "sleek",
    "sleep",
    "sleet",
    "sleeve",
    "slept",
    "sliceable",
    "sliced",
    "slicer",
    "slicing",
    "slick",
    "slider",
    "slideshow",
    "sliding",
    "slighted",
    "slighting",
    "slightly",
    "slimness",
    "slimy",
    "slinging",
    "slingshot",
    "slinky",
    "slip",
    "slit",
    "sliver",
    "slobbery",
    "slogan",
    "sloped",
    "sloping",
    "sloppily",
    "sloppy",
    "slot",
    "slouching",
    "slouchy",
    "sludge",
    "slug",
    "slum",
    "slurp",
    "slush",
    "sly",
    "small",
    "smartly",
    "smartness",
    "smasher",
    "smashing",
    "smashup",
    "smell",
    "smelting",
    "smile",
    "smilingly",
    "smirk",
    "smite",
    "smith",
    "smitten",
    "smock",
    "smog",
    "smoked",
    "smokeless",
    "smokiness",
    "smoking",
    "smoky",
    "smolder",
    "smooth",
    "smother",
    "smudge",
    "smudgy",
    "smuggler",
    "smuggling",
    "smugly",
    "smugness",
    "snack",
    "snagged",
    "snaking",
    "snap",
    "snare",
    "snarl",
    "snazzy",
    "sneak",
    "sneer",
    "sneeze",
    "sneezing",
    "snide",
    "sniff",
    "snippet",
    "snipping",
    "snitch",
    "snooper",
    "snooze",
    "snore",
    "snoring",
    "snorkel",
    "snort",
    "snout",
    "snowbird",
    "snowboard",
    "snowbound",
    "snowcap",
    "snowdrift",
    "snowdrop",
    "snowfall",
    "snowfield",
    "snowflake",
    "snowiness",
    "snowless",
    "snowman",
    "snowplow",
    "snowshoe",
    "snowstorm",
    "snowsuit",
    "snowy",
    "snub",
    "snuff",
    "snuggle",
    "snugly",
    "snugness",
    "speak",
    "spearfish",
    "spearhead",
    "spearman",
    "spearmint",
    "species",
    "specimen",
    "specked",
    "speckled",
    "specks",
    "spectacle",
    "spectator",
    "spectrum",
    "speculate",
    "speech",
    "speed",
    "spellbind",
    "speller",
    "spelling",
    "spendable",
    "spender",
    "spending",
    "spent",
    "spew",
    "sphere",
    "spherical",
    "sphinx",
    "spider",
    "spied",
    "spiffy",
    "spill",
    "spilt",
    "spinach",
    "spinal",
    "spindle",
    "spinner",
    "spinning",
    "spinout",
    "spinster",
    "spiny",
    "spiral",
    "spirited",
    "spiritism",
    "spirits",
    "spiritual",
    "splashed",
    "splashing",
    "splashy",
    "splatter",
    "spleen",
    "splendid",
    "splendor",
    "splice",
    "splicing",
    "splinter",
    "splotchy",
    "splurge",
    "spoilage",
    "spoiled",
    "spoiler",
    "spoiling",
    "spoils",
    "spoken",
    "spokesman",
    "sponge",
    "spongy",
    "sponsor",
    "spoof",
    "spookily",
    "spooky",
    "spool",
    "spoon",
    "spore",
    "sporting",
    "sports",
    "sporty",
    "spotless",
    "spotlight",
    "spotted",
    "spotter",
    "spotting",
    "spotty",
    "spousal",
    "spouse",
    "spout",
    "sprain",
    "sprang",
    "sprawl",
    "spray",
    "spree",
    "sprig",
    "spring",
    "sprinkled",
    "sprinkler",
    "sprint",
    "sprite",
    "sprout",
    "spruce",
    "sprung",
    "spry",
    "spud",
    "spur",
    "sputter",
    "spyglass",
    "squabble",
    "squad",
    "squall",
    "squander",
    "squash",
    "squatted",
    "squatter",
    "squatting",
    "squeak",
    "squealer",
    "squealing",
    "squeamish",
    "squeegee",
    "squeeze",
    "squeezing",
    "squid",
    "squiggle",
    "squiggly",
    "squint",
    "squire",
    "squirt",
    "squishier",
    "squishy",
    "stability",
    "stabilize",
    "stable",
    "stack",
    "stadium",
    "staff",
    "stage",
    "staging",
    "stagnant",
    "stagnate",
    "stainable",
    "stained",
    "staining",
    "stainless",
    "stalemate",
    "staleness",
    "stalling",
    "stallion",
    "stamina",
    "stammer",
    "stamp",
    "stand",
    "stank",
    "staple",
    "stapling",
    "starboard",
    "starch",
    "stardom",
    "stardust",
    "starfish",
    "stargazer",
    "staring",
    "stark",
    "starless",
    "starlet",
    "starlight",
    "starlit",
    "starring",
    "starry",
    "starship",
    "starter",
    "starting",
    "startle",
    "startling",
    "startup",
    "starved",
    "starving",
    "stash",
    "state",
    "static",
    "statistic",
    "statue",
    "stature",
    "status",
    "statute",
    "statutory",
    "staunch",
    "stays",
    "steadfast",
    "steadier",
    "steadily",
    "steadying",
    "steam",
    "steed",
    "steep",
    "steerable",
    "steering",
    "steersman",
    "stegosaur",
    "stellar",
    "stem",
    "stench",
    "stencil",
    "step",
    "stereo",
    "sterile",
    "sterility",
    "sterilize",
    "sterling",
    "sternness",
    "sternum",
    "stew",
    "stick",
    "stiffen",
    "stiffly",
    "stiffness",
    "stifle",
    "stifling",
    "stillness",
    "stilt",
    "stimulant",
    "stimulate",
    "stimuli",
    "stimulus",
    "stinger",
    "stingily",
    "stinging",
    "stingray",
    "stingy",
    "stinking",
    "stinky",
    "stipend",
    "stipulate",
    "stir",
    "stitch",
    "stock",
    "stoic",
    "stoke",
    "stole",
    "stomp",
    "stonewall",
    "stoneware",
    "stonework",
    "stoning",
    "stony",
    "stood",
    "stooge",
    "stool",
    "stoop",
    "stoplight",
    "stoppable",
    "stoppage",
    "stopped",
    "stopper",
    "stopping",
    "stopwatch",
    "storable",
    "storage",
    "storeroom",
    "storewide",
    "storm",
    "stout",
    "stove",
    "stowaway",
    "stowing",
    "straddle",
    "straggler",
    "strained",
    "strainer",
    "straining",
    "strangely",
    "stranger",
    "strangle",
    "strategic",
    "strategy",
    "stratus",
    "straw",
    "stray",
    "streak",
    "stream",
    "street",
    "strength",
    "strenuous",
    "strep",
    "stress",
    "stretch",
    "strewn",
    "stricken",
    "strict",
    "stride",
    "strife",
    "strike",
    "striking",
    "strive",
    "striving",
    "strobe",
    "strode",
    "stroller",
    "strongbox",
    "strongly",
    "strongman",
    "struck",
    "structure",
    "strudel",
    "struggle",
    "strum",
    "strung",
    "strut",
    "stubbed",
    "stubble",
    "stubbly",
    "stubborn",
    "stucco",
    "stuck",
    "student",
    "studied",
    "studio",
    "study",
    "stuffed",
    "stuffing",
    "stuffy",
    "stumble",
    "stumbling",
    "stump",
    "stung",
    "stunned",
    "stunner",
    "stunning",
    "stunt",
    "stupor",
    "sturdily",
    "sturdy",
    "styling",
    "stylishly",
    "stylist",
    "stylized",
    "stylus",
    "suave",
    "subarctic",
    "subatomic",
    "subdivide",
    "subdued",
    "subduing",
    "subfloor",
    "subgroup",
    "subheader",
    "subject",
    "sublease",
    "sublet",
    "sublevel",
    "sublime",
    "submarine",
    "submerge",
    "submersed",
    "submitter",
    "subpanel",
    "subpar",
    "subplot",
    "subprime",
    "subscribe",
    "subscript",
    "subsector",
    "subside",
    "subsiding",
    "subsidize",
    "subsidy",
    "subsoil",
    "subsonic",
    "substance",
    "subsystem",
    "subtext",
    "subtitle",
    "subtly",
    "subtotal",
    "subtract",
    "subtype",
    "suburb",
    "subway",
    "subwoofer",
    "subzero",
    "succulent",
    "such",
    "suction",
    "sudden",
    "sudoku",
    "suds",
    "sufferer",
    "suffering",
    "suffice",
    "suffix",
    "suffocate",
    "suffrage",
    "sugar",
    "suggest",
    "suing",
    "suitable",
    "suitably",
    "suitcase",
    "suitor",
    "sulfate",
    "sulfide",
    "sulfite",
    "sulfur",
    "sulk",
    "sullen",
    "sulphate",
    "sulphuric",
    "sultry",
    "superbowl",
    "superglue",
    "superhero",
    "superior",
    "superjet",
    "superman",
    "supermom",
    "supernova",
    "supervise",
    "supper",
    "supplier",
    "supply",
    "support",
    "supremacy",
    "supreme",
    "surcharge",
    "surely",
    "sureness",
    "surface",
    "surfacing",
    "surfboard",
    "surfer",
    "surgery",
    "surgical",
    "surging",
    "surname",
    "surpass",
    "surplus",
    "surprise",
    "surreal",
    "surrender",
    "surrogate",
    "surround",
    "survey",
    "survival",
    "survive",
    "surviving",
    "survivor",
    "sushi",
    "suspect",
    "suspend",
    "suspense",
    "sustained",
    "sustainer",
    "swab",
    "swaddling",
    "swagger",
    "swampland",
    "swan",
    "swapping",
    "swarm",
    "sway",
    "swear",
    "sweat",
    "sweep",
    "swell",
    "swept",
    "swerve",
    "swifter",
    "swiftly",
    "swiftness",
    "swimmable",
    "swimmer",
    "swimming",
    "swimsuit",
    "swimwear",
    "swinger",
    "swinging",
    "swipe",
    "swirl",
    "switch",
    "swivel",
    "swizzle",
    "swooned",
    "swoop",
    "swoosh",
    "swore",
    "sworn",
    "swung",
    "sycamore",
    "sympathy",
    "symphonic",
    "symphony",
    "symptom",
    "synapse",
    "syndrome",
    "synergy",
    "synopses",
    "synopsis",
    "synthesis",
    "synthetic",
    "syrup",
    "system",
    "t-shirt",
    "tabasco",
    "tabby",
    "tableful",
    "tables",
    "tablet",
    "tableware",
    "tabloid",
    "tackiness",
    "tacking",
    "tackle",
    "tackling",
    "tacky",
    "taco",
    "tactful",
    "tactical",
    "tactics",
    "tactile",
    "tactless",
    "tadpole",
    "taekwondo",
    "tag",
    "tainted",
    "take",
    "taking",
    "talcum",
    "talisman",
    "tall",
    "talon",
    "tamale",
    "tameness",
    "tamer",
    "tamper",
    "tank",
    "tanned",
    "tannery",
    "tanning",
    "tantrum",
    "tapeless",
    "tapered",
    "tapering",
    "tapestry",
    "tapioca",
    "tapping",
    "taps",
    "tarantula",
    "target",
    "tarmac",
    "tarnish",
    "tarot",
    "tartar",
    "tartly",
    "tartness",
    "task",
    "tassel",
    "taste",
    "tastiness",
    "tasting",
    "tasty",
    "tattered",
    "tattle",
    "tattling",
    "tattoo",
    "taunt",
    "tavern",
    "thank",
    "that",
    "thaw",
    "theater",
    "theatrics",
    "thee",
    "theft",
    "theme",
    "theology",
    "theorize",
    "thermal",
    "thermos",
    "thesaurus",
    "these",
    "thesis",
    "thespian",
    "thicken",
    "thicket",
    "thickness",
    "thieving",
    "thievish",
    "thigh",
    "thimble",
    "thing",
    "think",
    "thinly",
    "thinner",
    "thinness",
    "thinning",
    "thirstily",
    "thirsting",
    "thirsty",
    "thirteen",
    "thirty",
    "thong",
    "thorn",
    "those",
    "thousand",
    "thrash",
    "thread",
    "threaten",
    "threefold",
    "thrift",
    "thrill",
    "thrive",
    "thriving",
    "throat",
    "throbbing",
    "throng",
    "throttle",
    "throwaway",
    "throwback",
    "thrower",
    "throwing",
    "thud",
    "thumb",
    "thumping",
    "thursday",
    "thus",
    "thwarting",
    "thyself",
    "tiara",
    "tibia",
    "tidal",
    "tidbit",
    "tidiness",
    "tidings",
    "tidy",
    "tiger",
    "tighten",
    "tightly",
    "tightness",
    "tightrope",
    "tightwad",
    "tigress",
    "tile",
    "tiling",
    "till",
    "tilt",
    "timid",
    "timing",
    "timothy",
    "tinderbox",
    "tinfoil",
    "tingle",
    "tingling",
    "tingly",
    "tinker",
    "tinkling",
    "tinsel",
    "tinsmith",
    "tint",
    "tinwork",
    "tiny",
    "tipoff",
    "tipped",
    "tipper",
    "tipping",
    "tiptoeing",
    "tiptop",
    "tiring",
    "tissue",
    "trace",
    "tracing",
    "track",
    "traction",
    "tractor",
    "trade",
    "trading",
    "tradition",
    "traffic",
    "tragedy",
    "trailing",
    "trailside",
    "train",
    "traitor",
    "trance",
    "tranquil",
    "transfer",
    "transform",
    "translate",
    "transpire",
    "transport",
    "transpose",
    "trapdoor",
    "trapeze",
    "trapezoid",
    "trapped",
    "trapper",
    "trapping",
    "traps",
    "trash",
    "travel",
    "traverse",
    "travesty",
    "tray",
    "treachery",
    "treading",
    "treadmill",
    "treason",
    "treat",
    "treble",
    "tree",
    "trekker",
    "tremble",
    "trembling",
    "tremor",
    "trench",
    "trend",
    "trespass",
    "triage",
    "trial",
    "triangle",
    "tribesman",
    "tribunal",
    "tribune",
    "tributary",
    "tribute",
    "triceps",
    "trickery",
    "trickily",
    "tricking",
    "trickle",
    "trickster",
    "tricky",
    "tricolor",
    "tricycle",
    "trident",
    "tried",
    "trifle",
    "trifocals",
    "trillion",
    "trilogy",
    "trimester",
    "trimmer",
    "trimming",
    "trimness",
    "trinity",
    "trio",
    "tripod",
    "tripping",
    "triumph",
    "trivial",
    "trodden",
    "trolling",
    "trombone",
    "trophy",
    "tropical",
    "tropics",
    "trouble",
    "troubling",
    "trough",
    "trousers",
    "trout",
    "trowel",
    "truce",
    "truck",
    "truffle",
    "trump",
    "trunks",
    "trustable",
    "trustee",
    "trustful",
    "trusting",
    "trustless",
    "truth",
    "try",
    "tubby",
    "tubeless",
    "tubular",
    "tucking",
    "tuesday",
    "tug",
    "tuition",
    "tulip",
    "tumble",
    "tumbling",
    "tummy",
    "turban",
    "turbine",
    "turbofan",
    "turbojet",
    "turbulent",
    "turf",
    "turkey",
    "turmoil",
    "turret",
    "turtle",
    "tusk",
    "tutor",
    "tutu",
    "tux",
    "tweak",
    "tweed",
    "tweet",
    "tweezers",
    "twelve",
    "twentieth",
    "twenty",
    "twerp",
    "twice",
    "twiddle",
    "twiddling",
    "twig",
    "twilight",
    "twine",
    "twins",
    "twirl",
    "twistable",
    "twisted",
    "twister",
    "twisting",
    "twisty",
    "twitch",
    "twitter",
    "tycoon",
    "tying",
    "tyke",
    "udder",
    "ultimate",
    "ultimatum",
    "ultra",
    "umbilical",
    "umbrella",
    "umpire",
    "unabashed",
    "unable",
    "unadorned",
    "unadvised",
    "unafraid",
    "unaired",
    "unaligned",
    "unaltered",
    "unarmored",
    "unashamed",
    "unaudited",
    "unawake",
    "unaware",
    "unbaked",
    "unbalance",
    "unbeaten",
    "unbend",
    "unbent",
    "unbiased",
    "unbitten",
    "unblended",
    "unblessed",
    "unblock",
    "unbolted",
    "unbounded",
    "unboxed",
    "unbraided",
    "unbridle",
    "unbroken",
    "unbuckled",
    "unbundle",
    "unburned",
    "unbutton",
    "uncanny",
    "uncapped",
    "uncaring",
    "uncertain",
    "unchain",
    "unchanged",
    "uncharted",
    "uncheck",
    "uncivil",
    "unclad",
    "unclaimed",
    "unclamped",
    "unclasp",
    "uncle",
    "unclip",
    "uncloak",
    "unclog",
    "unclothed",
    "uncoated",
    "uncoiled",
    "uncolored",
    "uncombed",
    "uncommon",
    "uncooked",
    "uncork",
    "uncorrupt",
    "uncounted",
    "uncouple",
    "uncouth",
    "uncover",
    "uncross",
    "uncrown",
    "uncrushed",
    "uncured",
    "uncurious",
    "uncurled",
    "uncut",
    "undamaged",
    "undated",
    "undaunted",
    "undead",
    "undecided",
    "undefined",
    "underage",
    "underarm",
    "undercoat",
    "undercook",
    "undercut",
    "underdog",
    "underdone",
    "underfed",
    "underfeed",
    "underfoot",
    "undergo",
    "undergrad",
    "underhand",
    "underline",
    "underling",
    "undermine",
    "undermost",
    "underpaid",
    "underpass",
    "underpay",
    "underrate",
    "undertake",
    "undertone",
    "undertook",
    "undertow",
    "underuse",
    "underwear",
    "underwent",
    "underwire",
    "undesired",
    "undiluted",
    "undivided",
    "undocked",
    "undoing",
    "undone",
    "undrafted",
    "undress",
    "undrilled",
    "undusted",
    "undying",
    "unearned",
    "unearth",
    "unease",
    "uneasily",
    "uneasy",
    "uneatable",
    "uneaten",
    "unedited",
    "unelected",
    "unending",
    "unengaged",
    "unenvied",
    "unequal",
    "unethical",
    "uneven",
    "unexpired",
    "unexposed",
    "unfailing",
    "unfair",
    "unfasten",
    "unfazed",
    "unfeeling",
    "unfiled",
    "unfilled",
    "unfitted",
    "unfitting",
    "unfixable",
    "unfixed",
    "unflawed",
    "unfocused",
    "unfold",
    "unfounded",
    "unframed",
    "unfreeze",
    "unfrosted",
    "unfrozen",
    "unfunded",
    "unglazed",
    "ungloved",
    "unglue",
    "ungodly",
    "ungraded",
    "ungreased",
    "unguarded",
    "unguided",
    "unhappily",
    "unhappy",
    "unharmed",
    "unhealthy",
    "unheard",
    "unhearing",
    "unheated",
    "unhelpful",
    "unhidden",
    "unhinge",
    "unhitched",
    "unholy",
    "unhook",
    "unicorn",
    "unicycle",
    "unified",
    "unifier",
    "uniformed",
    "uniformly",
    "unify",
    "unimpeded",
    "uninjured",
    "uninstall",
    "uninsured",
    "uninvited",
    "union",
    "uniquely",
    "unisexual",
    "unison",
    "unissued",
    "unit",
    "universal",
    "universe",
    "unjustly",
    "unkempt",
    "unkind",
    "unknotted",
    "unknowing",
    "unknown",
    "unlaced",
    "unlatch",
    "unlawful",
    "unleaded",
    "unlearned",
    "unleash",
    "unless",
    "unleveled",
    "unlighted",
    "unlikable",
    "unlimited",
    "unlined",
    "unlinked",
    "unlisted",
    "unlit",
    "unlivable",
    "unloaded",
    "unloader",
    "unlocked",
    "unlocking",
    "unlovable",
    "unloved",
    "unlovely",
    "unloving",
    "unluckily",
    "unlucky",
    "unmade",
    "unmanaged",
    "unmanned",
    "unmapped",
    "unmarked",
    "unmasked",
    "unmasking",
    "unmatched",
    "unmindful",
    "unmixable",
    "unmixed",
    "unmolded",
    "unmoral",
    "unmovable",
    "unmoved",
    "unmoving",
    "unnamable",
    "unnamed",
    "unnatural",
    "unneeded",
    "unnerve",
    "unnerving",
    "unnoticed",
    "unopened",
    "unopposed",
    "unpack",
    "unpadded",
    "unpaid",
    "unpainted",
    "unpaired",
    "unpaved",
    "unpeeled",
    "unpicked",
    "unpiloted",
    "unpinned",
    "unplanned",
    "unplanted",
    "unpleased",
    "unpledged",
    "unplowed",
    "unplug",
    "unpopular",
    "unproven",
    "unquote",
    "unranked",
    "unrated",
    "unraveled",
    "unreached",
    "unread",
    "unreal",
    "unreeling",
    "unrefined",
    "unrelated",
    "unrented",
    "unrest",
    "unretired",
    "unrevised",
    "unrigged",
    "unripe",
    "unrivaled",
    "unroasted",
    "unrobed",
    "unroll",
    "unruffled",
    "unruly",
    "unrushed",
    "unsaddle",
    "unsafe",
    "unsaid",
    "unsalted",
    "unsaved",
    "unsavory",
    "unscathed",
    "unscented",
    "unscrew",
    "unsealed",
    "unseated",
    "unsecured",
    "unseeing",
    "unseemly",
    "unseen",
    "unselect",
    "unselfish",
    "unsent",
    "unsettled",
    "unshackle",
    "unshaken",
    "unshaved",
    "unshaven",
    "unsheathe",
    "unshipped",
    "unsightly",
    "unsigned",
    "unskilled",
    "unsliced",
    "unsmooth",
    "unsnap",
    "unsocial",
    "unsoiled",
    "unsold",
    "unsolved",
    "unsorted",
    "unspoiled",
    "unspoken",
    "unstable",
    "unstaffed",
    "unstamped",
    "unsteady",
    "unsterile",
    "unstirred",
    "unstitch",
    "unstopped",
    "unstuck",
    "unstuffed",
    "unstylish",
    "unsubtle",
    "unsubtly",
    "unsuited",
    "unsure",
    "unsworn",
    "untagged",
    "untainted",
    "untaken",
    "untamed",
    "untangled",
    "untapped",
    "untaxed",
    "unthawed",
    "unthread",
    "untidy",
    "untie",
    "until",
    "untimed",
    "untimely",
    "untitled",
    "untoasted",
    "untold",
    "untouched",
    "untracked",
    "untrained",
    "untreated",
    "untried",
    "untrimmed",
    "untrue",
    "untruth",
    "unturned",
    "untwist",
    "untying",
    "unusable",
    "unused",
    "unusual",
    "unvalued",
    "unvaried",
    "unvarying",
    "unveiled",
    "unveiling",
    "unvented",
    "unviable",
    "unvisited",
    "unvocal",
    "unwanted",
    "unwarlike",
    "unwary",
    "unwashed",
    "unwatched",
    "unweave",
    "unwed",
    "unwelcome",
    "unwell",
    "unwieldy",
    "unwilling",
    "unwind",
    "unwired",
    "unwitting",
    "unwomanly",
    "unworldly",
    "unworn",
    "unworried",
    "unworthy",
    "unwound",
    "unwoven",
    "unwrapped",
    "unwritten",
    "unzip",
    "upbeat",
    "upchuck",
    "upcoming",
    "upcountry",
    "update",
    "upfront",
    "upgrade",
    "upheaval",
    "upheld",
    "uphill",
    "uphold",
    "uplifted",
    "uplifting",
    "upload",
    "upon",
    "upper",
    "upright",
    "uprising",
    "upriver",
    "uproar",
    "uproot",
    "upscale",
    "upside",
    "upstage",
    "upstairs",
    "upstart",
    "upstate",
    "upstream",
    "upstroke",
    "upswing",
    "uptake",
    "uptight",
    "uptown",
    "upturned",
    "upward",
    "upwind",
    "uranium",
    "urban",
    "urchin",
    "urethane",
    "urgency",
    "urgent",
    "urging",
    "urologist",
    "urology",
    "usable",
    "usage",
    "useable",
    "used",
    "uselessly",
    "user",
    "usher",
    "usual",
    "utensil",
    "utility",
    "utilize",
    "utmost",
    "utopia",
    "utter",
    "vacancy",
    "vacant",
    "vacate",
    "vacation",
    "vagabond",
    "vagrancy",
    "vagrantly",
    "vaguely",
    "vagueness",
    "valiant",
    "valid",
    "valium",
    "valley",
    "valuables",
    "value",
    "vanilla",
    "vanish",
    "vanity",
    "vanquish",
    "vantage",
    "vaporizer",
    "variable",
    "variably",
    "varied",
    "variety",
    "various",
    "varmint",
    "varnish",
    "varsity",
    "varying",
    "vascular",
    "vaseline",
    "vastly",
    "vastness",
    "veal",
    "vegan",
    "veggie",
    "vehicular",
    "velcro",
    "velocity",
    "velvet",
    "vendetta",
    "vending",
    "vendor",
    "veneering",
    "vengeful",
    "venomous",
    "ventricle",
    "venture",
    "venue",
    "venus",
    "verbalize",
    "verbally",
    "verbose",
    "verdict",
    "verify",
    "verse",
    "version",
    "versus",
    "vertebrae",
    "vertical",
    "vertigo",
    "very",
    "vessel",
    "vest",
    "veteran",
    "veto",
    "vexingly",
    "viability",
    "viable",
    "vibes",
    "vice",
    "vicinity",
    "victory",
    "video",
    "viewable",
    "viewer",
    "viewing",
    "viewless",
    "viewpoint",
    "vigorous",
    "village",
    "villain",
    "vindicate",
    "vineyard",
    "vintage",
    "violate",
    "violation",
    "violator",
    "violet",
    "violin",
    "viper",
    "viral",
    "virtual",
    "virtuous",
    "virus",
    "visa",
    "viscosity",
    "viscous",
    "viselike",
    "visible",
    "visibly",
    "vision",
    "visiting",
    "visitor",
    "visor",
    "vista",
    "vitality",
    "vitalize",
    "vitally",
    "vitamins",
    "vivacious",
    "vividly",
    "vividness",
    "vixen",
    "vocalist",
    "vocalize",
    "vocally",
    "vocation",
    "voice",
    "voicing",
    "void",
    "volatile",
    "volley",
    "voltage",
    "volumes",
    "voter",
    "voting",
    "voucher",
    "vowed",
    "vowel",
    "voyage",
    "wackiness",
    "wad",
    "wafer",
    "waffle",
    "waged",
    "wager",
    "wages",
    "waggle",
    "wagon",
    "wake",
    "waking",
    "walk",
    "walmart",
    "walnut",
    "walrus",
    "waltz",
    "wand",
    "wannabe",
    "wanted",
    "wanting",
    "wasabi",
    "washable",
    "washbasin",
    "washboard",
    "washbowl",
    "washcloth",
    "washday",
    "washed",
    "washer",
    "washhouse",
    "washing",
    "washout",
    "washroom",
    "washstand",
    "washtub",
    "wasp",
    "wasting",
    "watch",
    "water",
    "waviness",
    "waving",
    "wavy",
    "whacking",
    "whacky",
    "wham",
    "wharf",
    "wheat",
    "whenever",
    "whiff",
    "whimsical",
    "whinny",
    "whiny",
    "whisking",
    "whoever",
    "whole",
    "whomever",
    "whoopee",
    "whooping",
    "whoops",
    "why",
    "wick",
    "widely",
    "widen",
    "widget",
    "widow",
    "width",
    "wieldable",
    "wielder",
    "wife",
    "wifi",
    "wikipedia",
    "wildcard",
    "wildcat",
    "wilder",
    "wildfire",
    "wildfowl",
    "wildland",
    "wildlife",
    "wildly",
    "wildness",
    "willed",
    "willfully",
    "willing",
    "willow",
    "willpower",
    "wilt",
    "wimp",
    "wince",
    "wincing",
    "wind",
    "wing",
    "winking",
    "winner",
    "winnings",
    "winter",
    "wipe",
    "wired",
    "wireless",
    "wiring",
    "wiry",
    "wisdom",
    "wise",
    "wish",
    "wisplike",
    "wispy",
    "wistful",
    "wizard",
    "wobble",
    "wobbling",
    "wobbly",
    "wok",
    "wolf",
    "wolverine",
    "womanhood",
    "womankind",
    "womanless",
    "womanlike",
    "womanly",
    "womb",
    "woof",
    "wooing",
    "wool",
    "woozy",
    "word",
    "work",
    "worried",
    "worrier",
    "worrisome",
    "worry",
    "worsening",
    "worshiper",
    "worst",
    "wound",
    "woven",
    "wow",
    "wrangle",
    "wrath",
    "wreath",
    "wreckage",
    "wrecker",
    "wrecking",
    "wrench",
    "wriggle",
    "wriggly",
    "wrinkle",
    "wrinkly",
    "wrist",
    "writing",
    "written",
    "wrongdoer",
    "wronged",
    "wrongful",
    "wrongly",
    "wrongness",
    "wrought",
    "xbox",
    "xerox",
    "yahoo",
    "yam",
    "yanking",
    "yapping",
    "yard",
    "yarn",
    "yeah",
    "yearbook",
    "yearling",
    "yearly",
    "yearning",
    "yeast",
    "yelling",
    "yelp",
    "yen",
    "yesterday",
    "yiddish",
    "yield",
    "yin",
    "yippee",
    "yo-yo",
    "yodel",
    "yoga",
    "yogurt",
    "yonder",
    "yoyo",
    "yummy",
    "zap",
    "zealous",
    "zebra",
    "zen",
    "zeppelin",
    "zero",
    "zestfully",
    "zesty",
    "zigzagged",
    "zipfile",
    "zipping",
    "zippy",
    "zips",
    "zit",
    "zodiac",
    "zombie",
    "zone",
    "zoning",
    "zookeeper",
    "zoologist",
    "zoology",
    "zoom",
];

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/encrypted-organization-key.ts
var encrypted_organization_key_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class BaseEncryptedOrganizationKey {
    static fromData(data) {
        switch (data.type) {
            case "organization":
                return new EncryptedOrganizationKey(data.key);
            case "provider":
                return new ProviderEncryptedOrganizationKey(data.key, data.providerId);
            default:
                return null;
        }
    }
}
class EncryptedOrganizationKey {
    constructor(key) {
        this.key = key;
    }
    decrypt(cryptoService) {
        return encrypted_organization_key_awaiter(this, void 0, void 0, function* () {
            const decValue = yield cryptoService.rsaDecrypt(this.key);
            return new SymmetricCryptoKey(decValue);
        });
    }
    toData() {
        return {
            type: "organization",
            key: this.key,
        };
    }
}
class ProviderEncryptedOrganizationKey {
    constructor(key, providerId) {
        this.key = key;
        this.providerId = providerId;
    }
    decrypt(cryptoService) {
        return encrypted_organization_key_awaiter(this, void 0, void 0, function* () {
            const providerKey = yield cryptoService.getProviderKey(this.providerId);
            const decValue = yield cryptoService.decryptToBytes(new EncString(this.key), providerKey);
            return new SymmetricCryptoKey(decValue);
        });
    }
    toData() {
        return {
            type: "provider",
            key: this.key,
            providerId: this.providerId,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/key-state/org-keys.state.ts
var org_keys_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const USER_ENCRYPTED_ORGANIZATION_KEYS = UserKeyDefinition.record(CRYPTO_DISK, "organizationKeys", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
const USER_ORGANIZATION_KEYS = DeriveDefinition.from(USER_ENCRYPTED_ORGANIZATION_KEYS, {
    deserializer: (obj) => {
        const result = {};
        for (const orgId of Object.keys(obj !== null && obj !== void 0 ? obj : {})) {
            result[orgId] = SymmetricCryptoKey.fromJSON(obj[orgId]);
        }
        return result;
    },
    derive: (from, { cryptoService }) => org_keys_state_awaiter(void 0, void 0, void 0, function* () {
        const result = {};
        for (const orgId of Object.keys(from !== null && from !== void 0 ? from : {})) {
            if (result[orgId] != null) {
                continue;
            }
            const encrypted = BaseEncryptedOrganizationKey.fromData(from[orgId]);
            const decrypted = yield encrypted.decrypt(cryptoService);
            result[orgId] = decrypted;
        }
        return result;
    }),
});

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/key-state/provider-keys.state.ts
var provider_keys_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const USER_ENCRYPTED_PROVIDER_KEYS = UserKeyDefinition.record(CRYPTO_DISK, "providerKeys", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
const USER_PROVIDER_KEYS = DeriveDefinition.from(USER_ENCRYPTED_PROVIDER_KEYS, {
    deserializer: (obj) => {
        const result = {};
        for (const providerId of Object.keys(obj !== null && obj !== void 0 ? obj : {})) {
            result[providerId] = SymmetricCryptoKey.fromJSON(obj[providerId]);
        }
        return result;
    },
    derive: (from, { encryptService, cryptoService }) => provider_keys_state_awaiter(void 0, void 0, void 0, function* () {
        const result = {};
        for (const providerId of Object.keys(from !== null && from !== void 0 ? from : {})) {
            if (result[providerId] != null) {
                continue;
            }
            const encrypted = new EncString(from[providerId]);
            const privateKey = yield cryptoService.getPrivateKey();
            const decrypted = yield encryptService.rsaDecrypt(encrypted, privateKey);
            const providerKey = new SymmetricCryptoKey(decrypted);
            result[providerId] = providerKey;
        }
        return result;
    }),
});

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/key-state/user-key.state.ts
var user_key_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const USER_EVER_HAD_USER_KEY = new UserKeyDefinition(CRYPTO_DISK, "everHadUserKey", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
const USER_ENCRYPTED_PRIVATE_KEY = new UserKeyDefinition(CRYPTO_DISK, "privateKey", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
const USER_PRIVATE_KEY = DeriveDefinition.fromWithUserId(USER_ENCRYPTED_PRIVATE_KEY, {
    deserializer: (obj) => new Uint8Array(Object.values(obj)),
    derive: ([userId, encPrivateKeyString], { encryptService, getUserKey }) => user_key_state_awaiter(void 0, void 0, void 0, function* () {
        if (encPrivateKeyString == null) {
            return null;
        }
        const userKey = yield getUserKey(userId);
        if (userKey == null) {
            return null;
        }
        const encPrivateKey = new EncString(encPrivateKeyString);
        const privateKey = (yield encryptService.decryptToBytes(encPrivateKey, userKey));
        return privateKey;
    }),
});
const USER_PUBLIC_KEY = DeriveDefinition.from([USER_PRIVATE_KEY, "publicKey"], {
    deserializer: (obj) => new Uint8Array(Object.values(obj)),
    derive: (privateKey, { cryptoFunctionService }) => user_key_state_awaiter(void 0, void 0, void 0, function* () {
        if (privateKey == null) {
            return null;
        }
        return (yield cryptoFunctionService.rsaExtractPublicKey(privateKey));
    }),
});
const USER_KEY = new UserKeyDefinition(CRYPTO_MEMORY, "userKey", {
    deserializer: (obj) => SymmetricCryptoKey.fromJSON(obj),
    clearOn: ["logout", "lock"],
});

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/crypto.service.ts
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var crypto_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











class CryptoService {
    constructor(masterPasswordService, keyGenerationService, cryptoFunctionService, encryptService, platformUtilService, logService, stateService, accountService, stateProvider) {
        this.masterPasswordService = masterPasswordService;
        this.keyGenerationService = keyGenerationService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.encryptService = encryptService;
        this.platformUtilService = platformUtilService;
        this.logService = logService;
        this.stateService = stateService;
        this.accountService = accountService;
        this.stateProvider = stateProvider;
        // User Key
        this.activeUserKeyState = stateProvider.getActive(USER_KEY);
        this.activeUserKey$ = this.activeUserKeyState.state$;
        this.activeUserEverHadUserKey = stateProvider.getActive(USER_EVER_HAD_USER_KEY);
        this.everHadUserKey$ = this.activeUserEverHadUserKey.state$.pipe((0,external_rxjs_namespaceObject.map)((x) => x !== null && x !== void 0 ? x : false));
        // User Asymmetric Key Pair
        this.activeUserEncryptedPrivateKeyState = stateProvider.getActive(USER_ENCRYPTED_PRIVATE_KEY);
        this.activeUserPrivateKeyState = stateProvider.getDerived(this.activeUserEncryptedPrivateKeyState.combinedState$.pipe((0,external_rxjs_namespaceObject.filter)(([_userId, key]) => key != null)), USER_PRIVATE_KEY, {
            encryptService: this.encryptService,
            getUserKey: (userId) => this.getUserKey(userId),
        });
        this.activeUserPrivateKey$ = this.activeUserPrivateKeyState.state$; // may be null
        this.activeUserPublicKeyState = stateProvider.getDerived(this.activeUserPrivateKey$.pipe((0,external_rxjs_namespaceObject.filter)((key) => key != null)), USER_PUBLIC_KEY, {
            cryptoFunctionService: this.cryptoFunctionService,
        });
        this.activeUserPublicKey$ = this.activeUserPublicKeyState.state$; // may be null
        // Organization keys
        this.activeUserEncryptedOrgKeysState = stateProvider.getActive(USER_ENCRYPTED_ORGANIZATION_KEYS);
        this.activeUserOrgKeysState = stateProvider.getDerived(this.activeUserEncryptedOrgKeysState.state$.pipe((0,external_rxjs_namespaceObject.filter)((keys) => keys != null)), USER_ORGANIZATION_KEYS, { cryptoService: this });
        this.activeUserOrgKeys$ = this.activeUserOrgKeysState.state$; // null handled by `derive` function
        // Provider keys
        this.activeUserEncryptedProviderKeysState = stateProvider.getActive(USER_ENCRYPTED_PROVIDER_KEYS);
        this.activeUserProviderKeysState = stateProvider.getDerived(this.activeUserEncryptedProviderKeysState.state$.pipe((0,external_rxjs_namespaceObject.filter)((keys) => keys != null)), USER_PROVIDER_KEYS, { encryptService: this.encryptService, cryptoService: this });
        this.activeUserProviderKeys$ = this.activeUserProviderKeysState.state$; // null handled by `derive` function
    }
    setUserKey(key, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No key provided. Lock the user to clear the key");
            }
            // Set userId to ensure we have one for the account status update
            [userId, key] = yield this.stateProvider.setUserState(USER_KEY, key, userId);
            yield this.stateProvider.setUserState(USER_EVER_HAD_USER_KEY, true, userId);
            yield this.storeAdditionalKeys(key, userId);
        });
    }
    refreshAdditionalKeys() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const key = yield this.getUserKey();
            yield this.setUserKey(key);
        });
    }
    getInMemoryUserKeyFor$(userId) {
        return this.stateProvider.getUserState$(USER_KEY, userId);
    }
    getUserKey(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(USER_KEY, userId));
            return userKey;
        });
    }
    isLegacyUser(masterKey, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$));
            masterKey !== null && masterKey !== void 0 ? masterKey : (masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId)));
            return yield this.validateUserKey(masterKey);
        });
    }
    // TODO: legacy support for user key is no longer needed since we require users to migrate on login
    getUserKeyWithLegacySupport(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$));
            const userKey = yield this.getUserKey(userId);
            if (userKey) {
                return userKey;
            }
            // Legacy support: encryption used to be done with the master key (derived from master password).
            // Users who have not migrated will have a null user key and must use the master key instead.
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            return masterKey;
        });
    }
    getUserKeyFromStorage(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield this.getKeyFromStorage(keySuffix, userId);
            if (userKey) {
                if (!(yield this.validateUserKey(userKey))) {
                    this.logService.warning("Invalid key, throwing away stored keys");
                    yield this.clearAllStoredUserKeys(userId);
                }
                return userKey;
            }
        });
    }
    hasUserKey(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$));
            if (userId == null) {
                return false;
            }
            return yield this.hasUserKeyInMemory(userId);
        });
    }
    hasUserKeyInMemory(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$));
            if (userId == null) {
                return false;
            }
            return (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(USER_KEY, userId))) != null;
        });
    }
    hasUserKeyStored(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.getKeyFromStorage(keySuffix, userId)) != null;
        });
    }
    makeUserKey(masterKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (!masterKey) {
                const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$);
                masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            }
            if (masterKey == null) {
                throw new Error("No Master Key found.");
            }
            const newUserKey = yield this.keyGenerationService.createKey(512);
            return this.buildProtectedSymmetricKey(masterKey, newUserKey.key);
        });
    }
    /**
     * Clears the user key. Clears all stored versions of the user keys as well, such as the biometrics key
     * @param userId The desired user
     */
    clearUserKey(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                // nothing to do
                return;
            }
            // Set userId to ensure we have one for the account status update
            yield this.stateProvider.setUserState(USER_KEY, null, userId);
            yield this.clearAllStoredUserKeys(userId);
        });
    }
    clearStoredUserKey(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (keySuffix === KeySuffixOptions.Auto) {
                // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
                // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                this.clearDeprecatedKeys(KeySuffixOptions.Auto, userId);
            }
            if (keySuffix === KeySuffixOptions.Pin) {
                // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                this.stateService.setPinKeyEncryptedUserKeyEphemeral(null, { userId: userId });
                // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                this.clearDeprecatedKeys(KeySuffixOptions.Pin, userId);
            }
        });
    }
    setMasterKeyEncryptedUserKey(userKeyMasterKey, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$));
            yield this.masterPasswordService.setMasterKeyEncryptedUserKey(new EncString(userKeyMasterKey), userId);
        });
    }
    // TODO: Move to MasterPasswordService
    getOrDeriveMasterKey(password, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$));
            let masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            return (masterKey || (masterKey = yield this.makeMasterKey(password, yield this.stateService.getEmail({ userId: userId }), yield this.stateService.getKdfType({ userId: userId }), yield this.stateService.getKdfConfig({ userId: userId }))));
        });
    }
    /**
     * Derive a master key from a password and email.
     *
     * @remarks
     * Does not validate the kdf config to ensure it satisfies the minimum requirements for the given kdf type.
     * TODO: Move to MasterPasswordService
     */
    makeMasterKey(password, email, kdf, KdfConfig) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.keyGenerationService.deriveKeyFromPassword(password, email, kdf, KdfConfig));
        });
    }
    encryptUserKeyWithMasterKey(masterKey, userKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userKey || (userKey = yield this.getUserKey());
            return yield this.buildProtectedSymmetricKey(masterKey, userKey.key);
        });
    }
    // TODO: move to master password service
    decryptUserKeyWithMasterKey(masterKey, userKey, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$));
            userKey !== null && userKey !== void 0 ? userKey : (userKey = yield this.masterPasswordService.getMasterKeyEncryptedUserKey(userId));
            masterKey !== null && masterKey !== void 0 ? masterKey : (masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId)));
            if (masterKey == null) {
                throw new Error("No master key found.");
            }
            // Try one more way to get the user key if it still wasn't found.
            if (userKey == null) {
                const deprecatedKey = yield this.stateService.getEncryptedCryptoSymmetricKey({
                    userId: userId,
                });
                if (deprecatedKey == null) {
                    throw new Error("No encrypted user key found.");
                }
                userKey = new EncString(deprecatedKey);
            }
            let decUserKey;
            if (userKey.encryptionType === EncryptionType.AesCbc256_B64) {
                decUserKey = yield this.encryptService.decryptToBytes(userKey, masterKey);
            }
            else if (userKey.encryptionType === EncryptionType.AesCbc256_HmacSha256_B64) {
                const newKey = yield this.stretchKey(masterKey);
                decUserKey = yield this.encryptService.decryptToBytes(userKey, newKey);
            }
            else {
                throw new Error("Unsupported encryption type.");
            }
            if (decUserKey == null) {
                return null;
            }
            return new SymmetricCryptoKey(decUserKey);
        });
    }
    // TODO: move to MasterPasswordService
    hashMasterKey(password, key, hashPurpose) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (!key) {
                const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$);
                key = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            }
            if (password == null || key == null) {
                throw new Error("Invalid parameters.");
            }
            const iterations = hashPurpose === HashPurpose.LocalAuthorization ? 2 : 1;
            const hash = yield this.cryptoFunctionService.pbkdf2(key.key, password, "sha256", iterations);
            return Utils.fromBufferToB64(hash);
        });
    }
    // TODO: move to MasterPasswordService
    compareAndUpdateKeyHash(masterPassword, masterKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$);
            const storedPasswordHash = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKeyHash$(userId));
            if (masterPassword != null && storedPasswordHash != null) {
                const localKeyHash = yield this.hashMasterKey(masterPassword, masterKey, HashPurpose.LocalAuthorization);
                if (localKeyHash != null && storedPasswordHash === localKeyHash) {
                    return true;
                }
                // TODO: remove serverKeyHash check in 1-2 releases after everyone's keyHash has been updated
                const serverKeyHash = yield this.hashMasterKey(masterPassword, masterKey, HashPurpose.ServerAuthorization);
                if (serverKeyHash != null && storedPasswordHash === serverKeyHash) {
                    yield this.masterPasswordService.setMasterKeyHash(localKeyHash, userId);
                    return true;
                }
            }
            return false;
        });
    }
    setOrgKeys(orgs = [], providerOrgs = []) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            this.activeUserEncryptedOrgKeysState.update((_) => {
                const encOrgKeyData = {};
                orgs.forEach((org) => {
                    encOrgKeyData[org.id] = {
                        type: "organization",
                        key: org.key,
                    };
                });
                providerOrgs.forEach((org) => {
                    encOrgKeyData[org.id] = {
                        type: "provider",
                        providerId: org.providerId,
                        key: org.key,
                    };
                });
                return encOrgKeyData;
            });
        });
    }
    getOrgKey(orgId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserOrgKeys$))[orgId];
        });
    }
    getOrgKeys() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserOrgKeys$);
        });
    }
    makeDataEncKey(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No key provided");
            }
            const newSymKey = yield this.keyGenerationService.createKey(512);
            return this.buildProtectedSymmetricKey(key, newSymKey.key);
        });
    }
    clearOrgKeys(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                // nothing to do
                return;
            }
            yield this.stateProvider.setUserState(USER_ENCRYPTED_ORGANIZATION_KEYS, null, userId);
        });
    }
    setProviderKeys(providers) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.activeUserEncryptedProviderKeysState.update((_) => {
                const encProviderKeys = {};
                providers.forEach((provider) => {
                    encProviderKeys[provider.id] = provider.key;
                });
                return encProviderKeys;
            });
        });
    }
    getProviderKey(providerId) {
        var _a;
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (providerId == null) {
                return null;
            }
            return (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserProviderKeys$))[providerId]) !== null && _a !== void 0 ? _a : null;
        });
    }
    getProviderKeys() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserProviderKeys$);
        });
    }
    clearProviderKeys(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                // nothing to do
                return;
            }
            yield this.stateProvider.setUserState(USER_ENCRYPTED_PROVIDER_KEYS, null, userId);
        });
    }
    getPublicKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserPublicKey$);
        });
    }
    makeOrgKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const shareKey = yield this.keyGenerationService.createKey(512);
            const publicKey = yield this.getPublicKey();
            const encShareKey = yield this.rsaEncrypt(shareKey.key, publicKey);
            return [encShareKey, shareKey];
        });
    }
    setPrivateKey(encPrivateKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (encPrivateKey == null) {
                return;
            }
            yield this.activeUserEncryptedPrivateKeyState.update(() => encPrivateKey);
        });
    }
    getPrivateKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserPrivateKey$);
        });
    }
    getFingerprint(fingerprintMaterial, publicKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (publicKey == null) {
                publicKey = yield this.getPublicKey();
            }
            if (publicKey === null) {
                throw new Error("No public key available.");
            }
            const keyFingerprint = yield this.cryptoFunctionService.hash(publicKey, "sha256");
            const userFingerprint = yield this.cryptoFunctionService.hkdfExpand(keyFingerprint, fingerprintMaterial, 32, "sha256");
            return this.hashPhrase(userFingerprint);
        });
    }
    makeKeyPair(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            // Default to user key
            key || (key = yield this.getUserKeyWithLegacySupport());
            const keyPair = yield this.cryptoFunctionService.rsaGenerateKeyPair(2048);
            const publicB64 = Utils.fromBufferToB64(keyPair[0]);
            const privateEnc = yield this.encryptService.encrypt(keyPair[1], key);
            return [publicB64, privateEnc];
        });
    }
    /**
     * Clears the user's key pair
     * @param userId The desired user
     */
    clearKeyPair(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                // nothing to do
                return;
            }
            yield this.stateProvider.setUserState(USER_ENCRYPTED_PRIVATE_KEY, null, userId);
        });
    }
    makePinKey(pin, salt, kdf, kdfConfig) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const pinKey = yield this.keyGenerationService.deriveKeyFromPassword(pin, salt, kdf, kdfConfig);
            return (yield this.stretchKey(pinKey));
        });
    }
    clearPinKeys(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setPinKeyEncryptedUserKey(null, { userId: userId });
            yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(null, { userId: userId });
            yield this.stateService.setProtectedPin(null, { userId: userId });
            yield this.clearDeprecatedKeys(KeySuffixOptions.Pin, userId);
        });
    }
    decryptUserKeyWithPin(pin, salt, kdf, kdfConfig, pinProtectedUserKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            pinProtectedUserKey || (pinProtectedUserKey = yield this.stateService.getPinKeyEncryptedUserKey());
            pinProtectedUserKey || (pinProtectedUserKey = yield this.stateService.getPinKeyEncryptedUserKeyEphemeral());
            if (!pinProtectedUserKey) {
                throw new Error("No PIN protected key found.");
            }
            const pinKey = yield this.makePinKey(pin, salt, kdf, kdfConfig);
            const userKey = yield this.encryptService.decryptToBytes(pinProtectedUserKey, pinKey);
            return new SymmetricCryptoKey(userKey);
        });
    }
    // only for migration purposes
    decryptMasterKeyWithPin(pin, salt, kdf, kdfConfig, pinProtectedMasterKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (!pinProtectedMasterKey) {
                const pinProtectedMasterKeyString = yield this.stateService.getEncryptedPinProtected();
                if (pinProtectedMasterKeyString == null) {
                    throw new Error("No PIN protected key found.");
                }
                pinProtectedMasterKey = new EncString(pinProtectedMasterKeyString);
            }
            const pinKey = yield this.makePinKey(pin, salt, kdf, kdfConfig);
            const masterKey = yield this.encryptService.decryptToBytes(pinProtectedMasterKey, pinKey);
            return new SymmetricCryptoKey(masterKey);
        });
    }
    makeSendKey(keyMaterial) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield this.keyGenerationService.deriveKeyFromMaterial(keyMaterial, "bitwarden-send", "send");
        });
    }
    makeCipherKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.keyGenerationService.createKey(512));
        });
    }
    clearKeys(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$));
            if (userId == null) {
                throw new Error("Cannot clear keys, no user Id resolved.");
            }
            yield this.masterPasswordService.clearMasterKeyHash(userId);
            yield this.clearUserKey(userId);
            yield this.clearOrgKeys(userId);
            yield this.clearProviderKeys(userId);
            yield this.clearKeyPair(userId);
            yield this.clearPinKeys(userId);
            yield this.stateProvider.setUserState(USER_EVER_HAD_USER_KEY, null, userId);
        });
    }
    rsaEncrypt(data, publicKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (publicKey == null) {
                publicKey = yield this.getPublicKey();
            }
            if (publicKey == null) {
                throw new Error("Public key unavailable.");
            }
            const encBytes = yield this.cryptoFunctionService.rsaEncrypt(data, publicKey, "sha1");
            return new EncString(EncryptionType.Rsa2048_OaepSha1_B64, Utils.fromBufferToB64(encBytes));
        });
    }
    rsaDecrypt(encValue, privateKeyValue) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const headerPieces = encValue.split(".");
            let encType = null;
            let encPieces;
            if (headerPieces.length === 1) {
                encType = EncryptionType.Rsa2048_OaepSha256_B64;
                encPieces = [headerPieces[0]];
            }
            else if (headerPieces.length === 2) {
                try {
                    encType = parseInt(headerPieces[0], null);
                    encPieces = headerPieces[1].split("|");
                }
                catch (e) {
                    this.logService.error(e);
                }
            }
            switch (encType) {
                case EncryptionType.Rsa2048_OaepSha256_B64:
                case EncryptionType.Rsa2048_OaepSha1_B64:
                case EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64: // HmacSha256 types are deprecated
                case EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                    break;
                default:
                    throw new Error("encType unavailable.");
            }
            if (encPieces == null || encPieces.length <= 0) {
                throw new Error("encPieces unavailable.");
            }
            const data = Utils.fromB64ToArray(encPieces[0]);
            const privateKey = privateKeyValue !== null && privateKeyValue !== void 0 ? privateKeyValue : (yield this.getPrivateKey());
            if (privateKey == null) {
                throw new Error("No private key.");
            }
            let alg = "sha1";
            switch (encType) {
                case EncryptionType.Rsa2048_OaepSha256_B64:
                case EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64:
                    alg = "sha256";
                    break;
                case EncryptionType.Rsa2048_OaepSha1_B64:
                case EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                    break;
                default:
                    throw new Error("encType unavailable.");
            }
            return this.cryptoFunctionService.rsaDecrypt(data, privateKey, alg);
        });
    }
    // EFForg/OpenWireless
    // ref https://github.com/EFForg/OpenWireless/blob/master/app/js/diceware.js
    randomNumber(min, max) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let rval = 0;
            const range = max - min + 1;
            const bitsNeeded = Math.ceil(Math.log2(range));
            if (bitsNeeded > 53) {
                throw new Error("We cannot generate numbers larger than 53 bits.");
            }
            const bytesNeeded = Math.ceil(bitsNeeded / 8);
            const mask = Math.pow(2, bitsNeeded) - 1;
            // 7776 -> (2^13 = 8192) -1 == 8191 or 0x00001111 11111111
            // Fill a byte array with N random numbers
            const byteArray = new Uint8Array(yield this.cryptoFunctionService.randomBytes(bytesNeeded));
            let p = (bytesNeeded - 1) * 8;
            for (let i = 0; i < bytesNeeded; i++) {
                rval += byteArray[i] * Math.pow(2, p);
                p -= 8;
            }
            // Use & to apply the mask and reduce the number of recursive lookups
            rval = rval & mask;
            if (rval >= range) {
                // Integer out of acceptable range
                return this.randomNumber(min, max);
            }
            // Return an integer that falls within the range
            return min + rval;
        });
    }
    // ---HELPERS---
    validateUserKey(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (!key) {
                return false;
            }
            try {
                const [userId, encPrivateKey] = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserEncryptedPrivateKeyState.combinedState$);
                if (encPrivateKey == null) {
                    return false;
                }
                // Can decrypt private key
                const privateKey = yield USER_PRIVATE_KEY.derive([userId, encPrivateKey], {
                    encryptService: this.encryptService,
                    getUserKey: () => Promise.resolve(key),
                });
                if (privateKey == null) {
                    // failed to decrypt
                    return false;
                }
                // Can successfully derive public key
                const publicKey = yield USER_PUBLIC_KEY.derive(privateKey, {
                    cryptoFunctionService: this.cryptoFunctionService,
                });
                if (publicKey == null) {
                    // failed to decrypt
                    return false;
                }
            }
            catch (e) {
                return false;
            }
            return true;
        });
    }
    /**
     * Initialize all necessary crypto keys needed for a new account.
     * Warning! This completely replaces any existing keys!
     */
    initAccount() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const userKey = (yield this.keyGenerationService.createKey(512));
            const [publicKey, privateKey] = yield this.makeKeyPair(userKey);
            yield this.setUserKey(userKey);
            yield this.activeUserEncryptedPrivateKeyState.update(() => privateKey.encryptedString);
            return {
                userKey,
                publicKey,
                privateKey,
            };
        });
    }
    /**
     * Generates any additional keys if needed. Additional keys are
     * keys such as biometrics, auto, and pin keys.
     * Useful to make sure other keys stay in sync when the user key
     * has been rotated.
     * @param key The user key
     * @param userId The desired user
     */
    storeAdditionalKeys(key, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const storeAuto = yield this.shouldStoreKey(KeySuffixOptions.Auto, userId);
            if (storeAuto) {
                yield this.stateService.setUserKeyAutoUnlock(key.keyB64, { userId: userId });
            }
            else {
                yield this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
            }
            yield this.clearDeprecatedKeys(KeySuffixOptions.Auto, userId);
            const storePin = yield this.shouldStoreKey(KeySuffixOptions.Pin, userId);
            if (storePin) {
                yield this.storePinKey(key, userId);
                // We can't always clear deprecated keys because the pin is only
                // migrated once used to unlock
                yield this.clearDeprecatedKeys(KeySuffixOptions.Pin, userId);
            }
            else {
                yield this.stateService.setPinKeyEncryptedUserKey(null, { userId: userId });
                yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(null, { userId: userId });
            }
        });
    }
    /**
     * Stores the pin key if needed. If MP on Reset is enabled, stores the
     * ephemeral version.
     * @param key The user key
     */
    storePinKey(key, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const pin = yield this.encryptService.decryptToUtf8(new EncString(yield this.stateService.getProtectedPin({ userId: userId })), key);
            const pinKey = yield this.makePinKey(pin, yield this.stateService.getEmail({ userId: userId }), yield this.stateService.getKdfType({ userId: userId }), yield this.stateService.getKdfConfig({ userId: userId }));
            const encPin = yield this.encryptService.encrypt(key.key, pinKey);
            if ((yield this.stateService.getPinKeyEncryptedUserKey({ userId: userId })) != null) {
                yield this.stateService.setPinKeyEncryptedUserKey(encPin, { userId: userId });
            }
            else {
                yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(encPin, { userId: userId });
            }
        });
    }
    shouldStoreKey(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let shouldStoreKey = false;
            switch (keySuffix) {
                case KeySuffixOptions.Auto: {
                    const vaultTimeout = yield this.stateService.getVaultTimeout({ userId: userId });
                    shouldStoreKey = vaultTimeout == null;
                    break;
                }
                case KeySuffixOptions.Pin: {
                    const protectedPin = yield this.stateService.getProtectedPin({ userId: userId });
                    shouldStoreKey = !!protectedPin;
                    break;
                }
            }
            return shouldStoreKey;
        });
    }
    getKeyFromStorage(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (keySuffix === KeySuffixOptions.Auto) {
                const userKey = yield this.stateService.getUserKeyAutoUnlock({ userId: userId });
                if (userKey) {
                    return new SymmetricCryptoKey(Utils.fromB64ToArray(userKey));
                }
            }
            return null;
        });
    }
    /**
     * Validate that the KDF config follows the requirements for the given KDF type.
     *
     * @remarks
     * Should always be called before updating a users KDF config.
     */
    validateKdfConfig(kdf, kdfConfig) {
        switch (kdf) {
            case KdfType.PBKDF2_SHA256:
                if (!PBKDF2_ITERATIONS.inRange(kdfConfig.iterations)) {
                    throw new Error(`PBKDF2 iterations must be between ${PBKDF2_ITERATIONS.min} and ${PBKDF2_ITERATIONS.max}`);
                }
                break;
            case KdfType.Argon2id:
                if (!ARGON2_ITERATIONS.inRange(kdfConfig.iterations)) {
                    throw new Error(`Argon2 iterations must be between ${ARGON2_ITERATIONS.min} and ${ARGON2_ITERATIONS.max}`);
                }
                if (!ARGON2_MEMORY.inRange(kdfConfig.memory)) {
                    throw new Error(`Argon2 memory must be between ${ARGON2_MEMORY.min}mb and ${ARGON2_MEMORY.max}mb`);
                }
                if (!ARGON2_PARALLELISM.inRange(kdfConfig.parallelism)) {
                    throw new Error(`Argon2 parallelism must be between ${ARGON2_PARALLELISM.min} and ${ARGON2_PARALLELISM.max}.`);
                }
                break;
        }
    }
    clearAllStoredUserKeys(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
            yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(null, { userId: userId });
        });
    }
    stretchKey(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const newKey = new Uint8Array(64);
            const encKey = yield this.cryptoFunctionService.hkdfExpand(key.key, "enc", 32, "sha256");
            const macKey = yield this.cryptoFunctionService.hkdfExpand(key.key, "mac", 32, "sha256");
            newKey.set(new Uint8Array(encKey));
            newKey.set(new Uint8Array(macKey), 32);
            return new SymmetricCryptoKey(newKey);
        });
    }
    hashPhrase(hash, minimumEntropy = 64) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const entropyPerWord = Math.log(EFFLongWordList.length) / Math.log(2);
            let numWords = Math.ceil(minimumEntropy / entropyPerWord);
            const hashArr = Array.from(new Uint8Array(hash));
            const entropyAvailable = hashArr.length * 4;
            if (numWords * entropyPerWord > entropyAvailable) {
                throw new Error("Output entropy of hash function is too small");
            }
            const phrase = [];
            let hashNumber = external_big_integer_namespaceObject.fromArray(hashArr, 256);
            while (numWords--) {
                const remainder = hashNumber.mod(EFFLongWordList.length);
                hashNumber = hashNumber.divide(EFFLongWordList.length);
                phrase.push(EFFLongWordList[remainder]);
            }
            return phrase;
        });
    }
    buildProtectedSymmetricKey(encryptionKey, newSymKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let protectedSymKey = null;
            if (encryptionKey.key.byteLength === 32) {
                const stretchedEncryptionKey = yield this.stretchKey(encryptionKey);
                protectedSymKey = yield this.encryptService.encrypt(newSymKey, stretchedEncryptionKey);
            }
            else if (encryptionKey.key.byteLength === 64) {
                protectedSymKey = yield this.encryptService.encrypt(newSymKey, encryptionKey);
            }
            else {
                throw new Error("Invalid key size.");
            }
            return [new SymmetricCryptoKey(newSymKey), protectedSymKey];
        });
    }
    // --LEGACY METHODS--
    // We previously used the master key for additional keys, but now we use the user key.
    // These methods support migrating the old keys to the new ones.
    // TODO: Remove after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3475)
    clearDeprecatedKeys(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (keySuffix === KeySuffixOptions.Auto) {
                yield this.stateService.setCryptoMasterKeyAuto(null, { userId: userId });
            }
            else if (keySuffix === KeySuffixOptions.Pin) {
                yield this.stateService.setEncryptedPinProtected(null, { userId: userId });
                yield this.stateService.setDecryptedPinProtected(null, { userId: userId });
            }
        });
    }
    migrateAutoKeyIfNeeded(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const oldAutoKey = yield this.stateService.getCryptoMasterKeyAuto({ userId: userId });
            if (!oldAutoKey) {
                return;
            }
            // Decrypt
            const masterKey = new SymmetricCryptoKey(Utils.fromB64ToArray(oldAutoKey));
            if (yield this.isLegacyUser(masterKey, userId)) {
                // Legacy users don't have a user key, so no need to migrate.
                // Instead, set the master key for additional isLegacyUser checks that will log the user out.
                userId !== null && userId !== void 0 ? userId : (userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$));
                yield this.masterPasswordService.setMasterKey(masterKey, userId);
                return;
            }
            const encryptedUserKey = yield this.stateService.getEncryptedCryptoSymmetricKey({
                userId: userId,
            });
            const userKey = yield this.decryptUserKeyWithMasterKey(masterKey, new EncString(encryptedUserKey), userId);
            // Migrate
            yield this.stateService.setUserKeyAutoUnlock(userKey.keyB64, { userId: userId });
            yield this.stateService.setCryptoMasterKeyAuto(null, { userId: userId });
            // Set encrypted user key in case user immediately locks without syncing
            yield this.setMasterKeyEncryptedUserKey(encryptedUserKey);
        });
    }
    decryptAndMigrateOldPinKey(masterPasswordOnRestart, pin, email, kdf, kdfConfig, oldPinKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            // Decrypt
            const masterKey = yield this.decryptMasterKeyWithPin(pin, email, kdf, kdfConfig, oldPinKey);
            const encUserKey = yield this.stateService.getEncryptedCryptoSymmetricKey();
            const userKey = yield this.decryptUserKeyWithMasterKey(masterKey, new EncString(encUserKey));
            // Migrate
            const pinKey = yield this.makePinKey(pin, email, kdf, kdfConfig);
            const pinProtectedKey = yield this.encryptService.encrypt(userKey.key, pinKey);
            if (masterPasswordOnRestart) {
                yield this.stateService.setDecryptedPinProtected(null);
                yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(pinProtectedKey);
            }
            else {
                yield this.stateService.setEncryptedPinProtected(null);
                yield this.stateService.setPinKeyEncryptedUserKey(pinProtectedKey);
                // We previously only set the protected pin if MP on Restart was enabled
                // now we set it regardless
                const encPin = yield this.encryptService.encrypt(pin, userKey);
                yield this.stateService.setProtectedPin(encPin.encryptedString);
            }
            // This also clears the old Biometrics key since the new Biometrics key will
            // be created when the user key is set.
            yield this.stateService.setCryptoMasterKeyBiometric(null);
            return userKey;
        });
    }
    // --DEPRECATED METHODS--
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.encrypt
     */
    encrypt(plainValue, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key || (key = yield this.getUserKeyWithLegacySupport());
            return yield this.encryptService.encrypt(plainValue, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.encryptToBytes
     */
    encryptToBytes(plainValue, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key || (key = yield this.getUserKeyWithLegacySupport());
            return this.encryptService.encryptToBytes(plainValue, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.decryptToBytes
     */
    decryptToBytes(encString, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key || (key = yield this.getUserKeyWithLegacySupport());
            return this.encryptService.decryptToBytes(encString, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.decryptToUtf8
     */
    decryptToUtf8(encString, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key || (key = yield this.getUserKeyWithLegacySupport());
            return yield this.encryptService.decryptToUtf8(encString, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.decryptToBytes
     */
    decryptFromBytes(encBuffer, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (encBuffer == null) {
                throw new Error("No buffer provided for decryption.");
            }
            key || (key = yield this.getUserKeyWithLegacySupport());
            return this.encryptService.decryptToBytes(encBuffer, key);
        });
    }
}
__decorate([
    sequentialize(() => "getOrgKeys"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], CryptoService.prototype, "getOrgKeys", null);
__decorate([
    sequentialize(() => "getProviderKeys"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], CryptoService.prototype, "getProviderKeys", null);

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/enc-array-buffer.ts
var enc_array_buffer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const ENC_TYPE_LENGTH = 1;
const IV_LENGTH = 16;
const MAC_LENGTH = 32;
const MIN_DATA_LENGTH = 1;
class EncArrayBuffer {
    constructor(buffer) {
        this.buffer = buffer;
        this.encryptionType = null;
        this.dataBytes = null;
        this.ivBytes = null;
        this.macBytes = null;
        const encBytes = buffer;
        const encType = encBytes[0];
        switch (encType) {
            case EncryptionType.AesCbc128_HmacSha256_B64:
            case EncryptionType.AesCbc256_HmacSha256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH);
                this.macBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH);
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH);
                break;
            }
            case EncryptionType.AesCbc256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH);
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH);
                break;
            }
            default:
                this.throwDecryptionError();
        }
        this.encryptionType = encType;
    }
    throwDecryptionError() {
        throw new Error("Error parsing encrypted ArrayBuffer: data is corrupted or has an invalid format.");
    }
    static fromResponse(response) {
        return enc_array_buffer_awaiter(this, void 0, void 0, function* () {
            const buffer = yield response.arrayBuffer();
            if (buffer == null) {
                throw new Error("Cannot create EncArrayBuffer from Response - Response is empty");
            }
            return new EncArrayBuffer(new Uint8Array(buffer));
        });
    }
    static fromB64(b64) {
        const buffer = Utils.fromB64ToArray(b64);
        return new EncArrayBuffer(buffer);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/encrypted-object.ts
class EncryptedObject {
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/cryptography/encrypt.service.implementation.ts
var encrypt_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class EncryptServiceImplementation {
    constructor(cryptoFunctionService, logService, logMacFailures) {
        this.cryptoFunctionService = cryptoFunctionService;
        this.logService = logService;
        this.logMacFailures = logMacFailures;
    }
    encrypt(plainValue, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No encryption key provided.");
            }
            if (plainValue == null) {
                return Promise.resolve(null);
            }
            let plainBuf;
            if (typeof plainValue === "string") {
                plainBuf = Utils.fromUtf8ToArray(plainValue);
            }
            else {
                plainBuf = plainValue;
            }
            const encObj = yield this.aesEncrypt(plainBuf, key);
            const iv = Utils.fromBufferToB64(encObj.iv);
            const data = Utils.fromBufferToB64(encObj.data);
            const mac = encObj.mac != null ? Utils.fromBufferToB64(encObj.mac) : null;
            return new EncString(encObj.key.encType, data, iv, mac);
        });
    }
    encryptToBytes(plainValue, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No encryption key provided.");
            }
            const encValue = yield this.aesEncrypt(plainValue, key);
            let macLen = 0;
            if (encValue.mac != null) {
                macLen = encValue.mac.byteLength;
            }
            const encBytes = new Uint8Array(1 + encValue.iv.byteLength + macLen + encValue.data.byteLength);
            encBytes.set([encValue.key.encType]);
            encBytes.set(new Uint8Array(encValue.iv), 1);
            if (encValue.mac != null) {
                encBytes.set(new Uint8Array(encValue.mac), 1 + encValue.iv.byteLength);
            }
            encBytes.set(new Uint8Array(encValue.data), 1 + encValue.iv.byteLength + macLen);
            return new EncArrayBuffer(encBytes);
        });
    }
    decryptToUtf8(encString, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No key provided for decryption.");
            }
            key = this.resolveLegacyKey(key, encString);
            if (key.macKey != null && (encString === null || encString === void 0 ? void 0 : encString.mac) == null) {
                this.logService.error("mac required.");
                return null;
            }
            if (key.encType !== encString.encryptionType) {
                this.logService.error("encType unavailable.");
                return null;
            }
            const fastParams = this.cryptoFunctionService.aesDecryptFastParameters(encString.data, encString.iv, encString.mac, key);
            if (fastParams.macKey != null && fastParams.mac != null) {
                const computedMac = yield this.cryptoFunctionService.hmacFast(fastParams.macData, fastParams.macKey, "sha256");
                const macsEqual = yield this.cryptoFunctionService.compareFast(fastParams.mac, computedMac);
                if (!macsEqual) {
                    this.logMacFailed("mac failed.");
                    return null;
                }
            }
            return yield this.cryptoFunctionService.aesDecryptFast(fastParams, "cbc");
        });
    }
    decryptToBytes(encThing, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No encryption key provided.");
            }
            if (encThing == null) {
                throw new Error("Nothing provided for decryption.");
            }
            key = this.resolveLegacyKey(key, encThing);
            if (key.macKey != null && encThing.macBytes == null) {
                return null;
            }
            if (key.encType !== encThing.encryptionType) {
                return null;
            }
            if (key.macKey != null && encThing.macBytes != null) {
                const macData = new Uint8Array(encThing.ivBytes.byteLength + encThing.dataBytes.byteLength);
                macData.set(new Uint8Array(encThing.ivBytes), 0);
                macData.set(new Uint8Array(encThing.dataBytes), encThing.ivBytes.byteLength);
                const computedMac = yield this.cryptoFunctionService.hmac(macData, key.macKey, "sha256");
                if (computedMac === null) {
                    return null;
                }
                const macsMatch = yield this.cryptoFunctionService.compare(encThing.macBytes, computedMac);
                if (!macsMatch) {
                    this.logMacFailed("mac failed.");
                    return null;
                }
            }
            const result = yield this.cryptoFunctionService.aesDecrypt(encThing.dataBytes, encThing.ivBytes, key.encKey, "cbc");
            return result !== null && result !== void 0 ? result : null;
        });
    }
    rsaEncrypt(data, publicKey) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (data == null) {
                throw new Error("No data provided for encryption.");
            }
            if (publicKey == null) {
                throw new Error("No public key provided for encryption.");
            }
            const encrypted = yield this.cryptoFunctionService.rsaEncrypt(data, publicKey, "sha1");
            return new EncString(EncryptionType.Rsa2048_OaepSha1_B64, Utils.fromBufferToB64(encrypted));
        });
    }
    rsaDecrypt(data, privateKey) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (data == null) {
                throw new Error("No data provided for decryption.");
            }
            let algorithm;
            switch (data.encryptionType) {
                case EncryptionType.Rsa2048_OaepSha1_B64:
                case EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                    algorithm = "sha1";
                    break;
                case EncryptionType.Rsa2048_OaepSha256_B64:
                case EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64:
                    algorithm = "sha256";
                    break;
                default:
                    throw new Error("Invalid encryption type.");
            }
            if (privateKey == null) {
                throw new Error("No private key provided for decryption.");
            }
            return this.cryptoFunctionService.rsaDecrypt(data.dataBytes, privateKey, algorithm);
        });
    }
    decryptItems(items, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (items == null || items.length < 1) {
                return [];
            }
            // don't use promise.all because this task is not io bound
            const results = [];
            for (let i = 0; i < items.length; i++) {
                results.push(yield items[i].decrypt(key));
            }
            return results;
        });
    }
    hash(value, algorithm) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            const hashArray = yield this.cryptoFunctionService.hash(value, algorithm);
            return Utils.fromBufferToB64(hashArray);
        });
    }
    aesEncrypt(data, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            const obj = new EncryptedObject();
            obj.key = key;
            obj.iv = yield this.cryptoFunctionService.randomBytes(16);
            obj.data = yield this.cryptoFunctionService.aesEncrypt(data, obj.iv, obj.key.encKey);
            if (obj.key.macKey != null) {
                const macData = new Uint8Array(obj.iv.byteLength + obj.data.byteLength);
                macData.set(new Uint8Array(obj.iv), 0);
                macData.set(new Uint8Array(obj.data), obj.iv.byteLength);
                obj.mac = yield this.cryptoFunctionService.hmac(macData, obj.key.macKey, "sha256");
            }
            return obj;
        });
    }
    logMacFailed(msg) {
        if (this.logMacFailures) {
            this.logService.error(msg);
        }
    }
    /**
     * Transform into new key for the old encrypt-then-mac scheme if required, otherwise return the current key unchanged
     * @param encThing The encrypted object (e.g. encString or encArrayBuffer) that you want to decrypt
     */
    resolveLegacyKey(key, encThing) {
        if (encThing.encryptionType === EncryptionType.AesCbc128_HmacSha256_B64 &&
            key.encType === EncryptionType.AesCbc256_B64) {
            return new SymmetricCryptoKey(key.key, EncryptionType.AesCbc128_HmacSha256_B64);
        }
        return key;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/default-environment.service.ts
var default_environment_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class EnvironmentUrls {
    constructor() {
        this.base = null;
        this.api = null;
        this.identity = null;
        this.icons = null;
        this.notifications = null;
        this.events = null;
        this.webVault = null;
        this.keyConnector = null;
    }
}
class EnvironmentState {
    static fromJSON(obj) {
        return Object.assign(new EnvironmentState(), obj);
    }
}
const GLOBAL_ENVIRONMENT_KEY = new KeyDefinition(ENVIRONMENT_DISK, "environment", {
    deserializer: EnvironmentState.fromJSON,
});
const USER_ENVIRONMENT_KEY = new UserKeyDefinition(ENVIRONMENT_DISK, "environment", {
    deserializer: EnvironmentState.fromJSON,
    clearOn: ["logout"],
});
const GLOBAL_CLOUD_REGION_KEY = new KeyDefinition(ENVIRONMENT_MEMORY, "cloudRegion", {
    deserializer: (b) => b,
});
const USER_CLOUD_REGION_KEY = new UserKeyDefinition(ENVIRONMENT_MEMORY, "cloudRegion", {
    deserializer: (b) => b,
    clearOn: ["logout"],
});
/**
 * The production regions available for selection.
 *
 * In the future we desire to load these urls from the config endpoint.
 */
const PRODUCTION_REGIONS = [
    {
        key: Region.US,
        domain: "bitwarden.com",
        urls: {
            base: null,
            api: "https://api.bitwarden.com",
            identity: "https://identity.bitwarden.com",
            icons: "https://icons.bitwarden.net",
            webVault: "https://vault.bitwarden.com",
            notifications: "https://notifications.bitwarden.com",
            events: "https://events.bitwarden.com",
            scim: "https://scim.bitwarden.com",
        },
    },
    {
        key: Region.EU,
        domain: "bitwarden.eu",
        urls: {
            base: null,
            api: "https://api.bitwarden.eu",
            identity: "https://identity.bitwarden.eu",
            icons: "https://icons.bitwarden.eu",
            webVault: "https://vault.bitwarden.eu",
            notifications: "https://notifications.bitwarden.eu",
            events: "https://events.bitwarden.eu",
            scim: "https://scim.bitwarden.eu",
        },
    },
];
/**
 * The default region when starting the app.
 */
const DEFAULT_REGION = Region.US;
/**
 * The default region configuration.
 */
const DEFAULT_REGION_CONFIG = PRODUCTION_REGIONS.find((r) => r.key === DEFAULT_REGION);
class DefaultEnvironmentService {
    constructor(stateProvider, accountService) {
        this.stateProvider = stateProvider;
        this.accountService = accountService;
        // We intentionally don't want the helper on account service, we want the null back if there is no active user
        this.activeAccountId$ = this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => a === null || a === void 0 ? void 0 : a.id));
        this.globalState = this.stateProvider.getGlobal(GLOBAL_ENVIRONMENT_KEY);
        this.globalCloudRegionState = this.stateProvider.getGlobal(GLOBAL_CLOUD_REGION_KEY);
        const account$ = this.activeAccountId$.pipe(
        // Use == here to not trigger on undefined -> null transition
        (0,external_rxjs_namespaceObject.distinctUntilChanged)((oldUserId, newUserId) => oldUserId == newUserId));
        this.environment$ = account$.pipe((0,external_rxjs_namespaceObject.switchMap)((userId) => {
            const t = userId
                ? this.stateProvider.getUser(userId, USER_ENVIRONMENT_KEY).state$
                : this.stateProvider.getGlobal(GLOBAL_ENVIRONMENT_KEY).state$;
            return t;
        }), (0,external_rxjs_namespaceObject.map)((state) => {
            return this.buildEnvironment(state === null || state === void 0 ? void 0 : state.region, state === null || state === void 0 ? void 0 : state.urls);
        }));
        this.cloudWebVaultUrl$ = account$.pipe((0,external_rxjs_namespaceObject.switchMap)((userId) => {
            const t = userId
                ? this.stateProvider.getUser(userId, USER_CLOUD_REGION_KEY).state$
                : this.stateProvider.getGlobal(GLOBAL_CLOUD_REGION_KEY).state$;
            return t;
        }), (0,external_rxjs_namespaceObject.map)((region) => {
            if (region != null) {
                const config = this.getRegionConfig(region);
                if (config != null) {
                    return config.urls.webVault;
                }
            }
            return DEFAULT_REGION_CONFIG.urls.webVault;
        }));
    }
    availableRegions() {
        var _a;
        const additionalRegions = (_a = process.env.ADDITIONAL_REGIONS) !== null && _a !== void 0 ? _a : [];
        return PRODUCTION_REGIONS.concat(additionalRegions);
    }
    /**
     * Get the region configuration for the given region.
     */
    getRegionConfig(region) {
        return this.availableRegions().find((r) => r.key === region);
    }
    setEnvironment(region, urls) {
        return default_environment_service_awaiter(this, void 0, void 0, function* () {
            // Unknown regions are treated as self-hosted
            if (this.getRegionConfig(region) == null) {
                region = Region.SelfHosted;
            }
            // If self-hosted ensure urls are valid else fallback to default region
            if (region == Region.SelfHosted && isEmpty(urls)) {
                region = DEFAULT_REGION;
            }
            if (region != Region.SelfHosted) {
                yield this.globalState.update(() => ({
                    region: region,
                    urls: null,
                }));
                return null;
            }
            else {
                // Clean the urls
                urls.base = formatUrl(urls.base);
                urls.webVault = formatUrl(urls.webVault);
                urls.api = formatUrl(urls.api);
                urls.identity = formatUrl(urls.identity);
                urls.icons = formatUrl(urls.icons);
                urls.notifications = formatUrl(urls.notifications);
                urls.events = formatUrl(urls.events);
                urls.keyConnector = formatUrl(urls.keyConnector);
                urls.scim = null;
                yield this.globalState.update(() => ({
                    region: region,
                    urls: {
                        base: urls.base,
                        api: urls.api,
                        identity: urls.identity,
                        webVault: urls.webVault,
                        icons: urls.icons,
                        notifications: urls.notifications,
                        events: urls.events,
                        keyConnector: urls.keyConnector,
                    },
                }));
                return urls;
            }
        });
    }
    /**
     * Helper for building the environment from state. Performs some general sanitization to avoid invalid regions and urls.
     */
    buildEnvironment(region, urls) {
        // Unknown regions are treated as self-hosted
        if (this.getRegionConfig(region) == null) {
            region = Region.SelfHosted;
        }
        // If self-hosted ensure urls are valid else fallback to default region
        if (region == Region.SelfHosted && isEmpty(urls)) {
            region = DEFAULT_REGION;
        }
        // Load urls from region config
        if (region != Region.SelfHosted) {
            const regionConfig = this.getRegionConfig(region);
            if (regionConfig != null) {
                return new CloudEnvironment(regionConfig);
            }
        }
        return new SelfHostedEnvironment(urls);
    }
    setCloudRegion(userId, region) {
        return default_environment_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                yield this.globalCloudRegionState.update(() => region);
            }
            else {
                yield this.stateProvider.getUser(userId, USER_CLOUD_REGION_KEY).update(() => region);
            }
        });
    }
    getEnvironment(userId) {
        return default_environment_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environment$);
            }
            const state = yield this.getEnvironmentState(userId);
            return this.buildEnvironment(state.region, state.urls);
        });
    }
    getEnvironmentState(userId) {
        return default_environment_service_awaiter(this, void 0, void 0, function* () {
            // Previous rules dictated that we only get from user scoped state if there is an active user.
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeAccountId$);
            return activeUserId == null
                ? yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.globalState.state$)
                : yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId !== null && userId !== void 0 ? userId : activeUserId, USER_ENVIRONMENT_KEY).state$);
        });
    }
    seedUserEnvironment(userId) {
        return default_environment_service_awaiter(this, void 0, void 0, function* () {
            const global = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.globalState.state$);
            yield this.stateProvider.getUser(userId, USER_ENVIRONMENT_KEY).update(() => global);
        });
    }
}
function formatUrl(url) {
    if (url == null || url === "") {
        return null;
    }
    url = url.replace(/\/+$/g, "");
    if (!url.startsWith("http://") && !url.startsWith("https://")) {
        url = "https://" + url;
    }
    return url.trim();
}
function isEmpty(u) {
    if (u == null) {
        return true;
    }
    return (u.base == null &&
        u.webVault == null &&
        u.api == null &&
        u.identity == null &&
        u.icons == null &&
        u.notifications == null &&
        u.events == null);
}
class UrlEnvironment {
    constructor(region, urls) {
        this.region = region;
        this.urls = urls;
        // Scim is always null for self-hosted
        if (region == Region.SelfHosted) {
            this.urls.scim = null;
        }
    }
    getRegion() {
        return this.region;
    }
    getUrls() {
        return {
            base: this.urls.base,
            webVault: this.urls.webVault,
            api: this.urls.api,
            identity: this.urls.identity,
            icons: this.urls.icons,
            notifications: this.urls.notifications,
            events: this.urls.events,
            keyConnector: this.urls.keyConnector,
            scim: this.urls.scim,
        };
    }
    hasBaseUrl() {
        return this.urls.base != null;
    }
    getWebVaultUrl() {
        return this.getUrl("webVault", "");
    }
    getApiUrl() {
        return this.getUrl("api", "/api");
    }
    getEventsUrl() {
        return this.getUrl("events", "/events");
    }
    getIconsUrl() {
        return this.getUrl("icons", "/icons");
    }
    getIdentityUrl() {
        return this.getUrl("identity", "/identity");
    }
    getKeyConnectorUrl() {
        return this.urls.keyConnector;
    }
    getNotificationsUrl() {
        return this.getUrl("notifications", "/notifications");
    }
    getScimUrl() {
        if (this.urls.scim != null) {
            return this.urls.scim + "/v2";
        }
        return this.getWebVaultUrl() === "https://vault.bitwarden.com"
            ? "https://scim.bitwarden.com/v2"
            : this.getWebVaultUrl() + "/scim/v2";
    }
    getSendUrl() {
        return this.getWebVaultUrl() === "https://vault.bitwarden.com"
            ? "https://send.bitwarden.com/#"
            : this.getWebVaultUrl() + "/#/send/";
    }
    /**
     * Presume that if the region is not self-hosted, it is cloud.
     */
    isCloud() {
        return this.region !== Region.SelfHosted;
    }
    /**
     * Helper for getting an URL.
     *
     * @param key Key of the URL to get from URLs
     * @param baseSuffix Suffix to append to the base URL if the url is not set
     * @returns
     */
    getUrl(key, baseSuffix) {
        if (this.urls[key] != null) {
            return this.urls[key];
        }
        if (this.urls.base) {
            return this.urls.base + baseSuffix;
        }
        return DEFAULT_REGION_CONFIG.urls[key];
    }
}
/**
 * Denote a cloud environment.
 */
class CloudEnvironment extends UrlEnvironment {
    constructor(config) {
        super(config.key, config.urls);
        this.config = config;
    }
    /**
     * Cloud always returns nice urls, i.e. bitwarden.com instead of vault.bitwarden.com.
     */
    getHostname() {
        return this.config.domain;
    }
}
class SelfHostedEnvironment extends UrlEnvironment {
    constructor(urls) {
        super(Region.SelfHosted, urls);
    }
    getHostname() {
        return Utils.getHost(this.getWebVaultUrl());
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/file-upload/azure-file-upload.service.ts
var azure_file_upload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const MAX_SINGLE_BLOB_UPLOAD_SIZE = 256 * 1024 * 1024; // 256 MiB
const MAX_BLOCKS_PER_BLOB = 50000;
class AzureFileUploadService {
    constructor(logService) {
        this.logService = logService;
    }
    upload(url, data, renewalCallback) {
        return azure_file_upload_service_awaiter(this, void 0, void 0, function* () {
            if (data.buffer.byteLength <= MAX_SINGLE_BLOB_UPLOAD_SIZE) {
                return yield this.azureUploadBlob(url, data);
            }
            else {
                return yield this.azureUploadBlocks(url, data, renewalCallback);
            }
        });
    }
    azureUploadBlob(url, data) {
        return azure_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const urlObject = Utils.getUrl(url);
            const headers = new Headers({
                "x-ms-date": new Date().toUTCString(),
                "x-ms-version": urlObject.searchParams.get("sv"),
                "Content-Length": data.buffer.byteLength.toString(),
                "x-ms-blob-type": "BlockBlob",
            });
            const request = new Request(url, {
                body: data.buffer,
                cache: "no-store",
                method: "PUT",
                headers: headers,
            });
            const blobResponse = yield fetch(request);
            if (blobResponse.status !== 201) {
                throw new Error(`Failed to create Azure blob: ${blobResponse.status}`);
            }
        });
    }
    azureUploadBlocks(url, data, renewalCallback) {
        return azure_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const baseUrl = Utils.getUrl(url);
            const blockSize = this.getMaxBlockSize(baseUrl.searchParams.get("sv"));
            let blockIndex = 0;
            const numBlocks = Math.ceil(data.buffer.byteLength / blockSize);
            const blocksStaged = [];
            if (numBlocks > MAX_BLOCKS_PER_BLOB) {
                throw new Error(`Cannot upload file, exceeds maximum size of ${blockSize * MAX_BLOCKS_PER_BLOB}`);
            }
            // eslint-disable-next-line
            try {
                while (blockIndex < numBlocks) {
                    url = yield this.renewUrlIfNecessary(url, renewalCallback);
                    const blockUrl = Utils.getUrl(url);
                    const blockId = this.encodedBlockId(blockIndex);
                    blockUrl.searchParams.append("comp", "block");
                    blockUrl.searchParams.append("blockid", blockId);
                    const start = blockIndex * blockSize;
                    const blockData = data.buffer.slice(start, start + blockSize);
                    const blockHeaders = new Headers({
                        "x-ms-date": new Date().toUTCString(),
                        "x-ms-version": blockUrl.searchParams.get("sv"),
                        "Content-Length": blockData.byteLength.toString(),
                    });
                    const blockRequest = new Request(blockUrl.toString(), {
                        body: blockData,
                        cache: "no-store",
                        method: "PUT",
                        headers: blockHeaders,
                    });
                    const blockResponse = yield fetch(blockRequest);
                    if (blockResponse.status !== 201) {
                        const message = `Unsuccessful block PUT. Received status ${blockResponse.status}`;
                        this.logService.error(message + "\n" + (yield blockResponse.json()));
                        throw new Error(message);
                    }
                    blocksStaged.push(blockId);
                    blockIndex++;
                }
                url = yield this.renewUrlIfNecessary(url, renewalCallback);
                const blockListUrl = Utils.getUrl(url);
                const blockListXml = this.blockListXml(blocksStaged);
                blockListUrl.searchParams.append("comp", "blocklist");
                const headers = new Headers({
                    "x-ms-date": new Date().toUTCString(),
                    "x-ms-version": blockListUrl.searchParams.get("sv"),
                    "Content-Length": blockListXml.length.toString(),
                });
                const request = new Request(blockListUrl.toString(), {
                    body: blockListXml,
                    cache: "no-store",
                    method: "PUT",
                    headers: headers,
                });
                const response = yield fetch(request);
                if (response.status !== 201) {
                    const message = `Unsuccessful block list PUT. Received status ${response.status}`;
                    this.logService.error(message + "\n" + (yield response.json()));
                    throw new Error(message);
                }
            }
            catch (e) {
                throw e;
            }
        });
    }
    renewUrlIfNecessary(url, renewalCallback) {
        var _a;
        return azure_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const urlObject = Utils.getUrl(url);
            const expiry = new Date((_a = urlObject.searchParams.get("se")) !== null && _a !== void 0 ? _a : "");
            if (isNaN(expiry.getTime())) {
                expiry.setTime(Date.now() + 3600000);
            }
            if (expiry.getTime() < Date.now() + 1000) {
                return yield renewalCallback();
            }
            return url;
        });
    }
    encodedBlockId(blockIndex) {
        // Encoded blockId max size is 64, so pre-encoding max size is 48
        const utfBlockId = ("000000000000000000000000000000000000000000000000" + blockIndex.toString()).slice(-48);
        return Utils.fromUtf8ToB64(utfBlockId);
    }
    blockListXml(blockIdList) {
        let xml = '<?xml version="1.0" encoding="utf-8"?><BlockList>';
        blockIdList.forEach((blockId) => {
            xml += `<Latest>${blockId}</Latest>`;
        });
        xml += "</BlockList>";
        return xml;
    }
    getMaxBlockSize(version) {
        if (Version.compare(version, "2019-12-12") >= 0) {
            return 4000 * 1024 * 1024; // 4000 MiB
        }
        else if (Version.compare(version, "2016-05-31") >= 0) {
            return 100 * 1024 * 1024; // 100 MiB
        }
        else {
            return 4 * 1024 * 1024; // 4 MiB
        }
    }
}
class Version {
    /**
     * Compares two Azure Versions against each other
     * @param a Version to compare
     * @param b Version to compare
     * @returns a number less than zero if b is newer than a, 0 if equal,
     * and greater than zero if a is newer than b
     */
    static compare(a, b) {
        if (typeof a === "string") {
            a = new Version(a);
        }
        if (typeof b === "string") {
            b = new Version(b);
        }
        return a.year !== b.year
            ? a.year - b.year
            : a.month !== b.month
                ? a.month - b.month
                : a.day !== b.day
                    ? a.day - b.day
                    : 0;
    }
    constructor(version) {
        this.year = 0;
        this.month = 0;
        this.day = 0;
        try {
            const parts = version.split("-").map((v) => Number.parseInt(v, 10));
            this.year = parts[0];
            this.month = parts[1];
            this.day = parts[2];
        }
        catch (_a) {
            // Ignore error
        }
    }
    /**
     * Compares two Azure Versions against each other
     * @param compareTo Version to compare against
     * @returns a number less than zero if compareTo is newer, 0 if equal,
     * and greater than zero if this is greater than compareTo
     */
    compare(compareTo) {
        return Version.compare(this, compareTo);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/file-upload/bitwarden-file-upload.service.ts
var bitwarden_file_upload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class BitwardenFileUploadService {
    upload(encryptedFileName, encryptedFileData, apiCall) {
        return bitwarden_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const fd = new FormData();
            try {
                const blob = new Blob([encryptedFileData.buffer], { type: "application/octet-stream" });
                fd.append("data", blob, encryptedFileName);
            }
            catch (e) {
                if (Utils.isNode && !Utils.isBrowser) {
                    fd.append("data", Buffer.from(encryptedFileData.buffer), {
                        filepath: encryptedFileName,
                        contentType: "application/octet-stream",
                    });
                }
                else {
                    throw e;
                }
            }
            yield apiCall(fd);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/file-upload/file-upload.service.ts
var file_upload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class FileUploadService {
    constructor(logService) {
        this.logService = logService;
        this.azureFileUploadService = new AzureFileUploadService(logService);
        this.bitwardenFileUploadService = new BitwardenFileUploadService();
    }
    upload(uploadData, fileName, encryptedFileData, fileUploadMethods) {
        return file_upload_service_awaiter(this, void 0, void 0, function* () {
            try {
                switch (uploadData.fileUploadType) {
                    case FileUploadType.Direct:
                        yield this.bitwardenFileUploadService.upload(fileName.encryptedString, encryptedFileData, (fd) => fileUploadMethods.postDirect(fd));
                        break;
                    case FileUploadType.Azure: {
                        yield this.azureFileUploadService.upload(uploadData.url, encryptedFileData, fileUploadMethods.renewFileUploadUrl);
                        break;
                    }
                    default:
                        throw new Error("Unknown file upload type");
                }
            }
            catch (e) {
                yield fileUploadMethods.rollback();
                throw e;
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/key-generation.service.ts
var key_generation_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class KeyGenerationService {
    constructor(cryptoFunctionService) {
        this.cryptoFunctionService = cryptoFunctionService;
    }
    createKey(bitLength) {
        return key_generation_service_awaiter(this, void 0, void 0, function* () {
            const key = yield this.cryptoFunctionService.aesGenerateKey(bitLength);
            return new SymmetricCryptoKey(key);
        });
    }
    createKeyWithPurpose(bitLength, purpose, salt) {
        return key_generation_service_awaiter(this, void 0, void 0, function* () {
            if (salt == null) {
                const bytes = yield this.cryptoFunctionService.randomBytes(32);
                salt = Utils.fromBufferToUtf8(bytes);
            }
            const material = yield this.cryptoFunctionService.aesGenerateKey(bitLength);
            const key = yield this.cryptoFunctionService.hkdf(material, salt, purpose, 64, "sha256");
            return { salt, material, derivedKey: new SymmetricCryptoKey(key) };
        });
    }
    deriveKeyFromMaterial(material, salt, purpose) {
        return key_generation_service_awaiter(this, void 0, void 0, function* () {
            const key = yield this.cryptoFunctionService.hkdf(material, salt, purpose, 64, "sha256");
            return new SymmetricCryptoKey(key);
        });
    }
    deriveKeyFromPassword(password, salt, kdf, kdfConfig) {
        return key_generation_service_awaiter(this, void 0, void 0, function* () {
            let key = null;
            if (kdf == null || kdf === KdfType.PBKDF2_SHA256) {
                if (kdfConfig.iterations == null) {
                    kdfConfig.iterations = PBKDF2_ITERATIONS.defaultValue;
                }
                key = yield this.cryptoFunctionService.pbkdf2(password, salt, "sha256", kdfConfig.iterations);
            }
            else if (kdf == KdfType.Argon2id) {
                if (kdfConfig.iterations == null) {
                    kdfConfig.iterations = ARGON2_ITERATIONS.defaultValue;
                }
                if (kdfConfig.memory == null) {
                    kdfConfig.memory = ARGON2_MEMORY.defaultValue;
                }
                if (kdfConfig.parallelism == null) {
                    kdfConfig.parallelism = ARGON2_PARALLELISM.defaultValue;
                }
                const saltHash = yield this.cryptoFunctionService.hash(salt, "sha256");
                key = yield this.cryptoFunctionService.argon2(password, saltHash, kdfConfig.iterations, kdfConfig.memory * 1024, // convert to KiB from MiB
                kdfConfig.parallelism);
            }
            else {
                throw new Error("Unknown Kdf.");
            }
            return new SymmetricCryptoKey(key);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/abstractions/storage.service.ts
class AbstractStorageService {
}
class AbstractMemoryStorageService extends AbstractStorageService {
    constructor() {
        super(...arguments);
        this.type = AbstractMemoryStorageService.TYPE;
    }
}
// Used to identify the service in the session sync decorator framework
AbstractMemoryStorageService.TYPE = "MemoryStorageService";

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/memory-storage.service.ts
var memory_storage_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class MemoryStorageService extends AbstractMemoryStorageService {
    constructor() {
        super(...arguments);
        this.store = new Map();
        this.updatesSubject = new external_rxjs_namespaceObject.Subject();
    }
    get valuesRequireDeserialization() {
        return false;
    }
    get updates$() {
        return this.updatesSubject.asObservable();
    }
    get(key) {
        if (this.store.has(key)) {
            const obj = this.store.get(key);
            return Promise.resolve(obj);
        }
        return Promise.resolve(null);
    }
    has(key) {
        return memory_storage_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.get(key)) != null;
        });
    }
    save(key, obj) {
        if (obj == null) {
            return this.remove(key);
        }
        // TODO: Remove once foreground/background contexts are separated in browser
        // Needed to ensure ownership of all memory by the context running the storage service
        const toStore = structuredClone(obj);
        this.store.set(key, toStore);
        this.updatesSubject.next({ key, updateType: "save" });
        return Promise.resolve();
    }
    remove(key) {
        this.store.delete(key);
        this.updatesSubject.next({ key, updateType: "remove" });
        return Promise.resolve();
    }
    getBypassCache(key) {
        return this.get(key);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migration-builder.ts
var migration_builder_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class MigrationBuilder {
    /** Create a new MigrationBuilder with an empty buffer of migrations to perform.
     *
     * Add migrations to the buffer with {@link with} and {@link rollback}.
     * @returns A new MigrationBuilder.
     */
    static create() {
        return new MigrationBuilder([]);
    }
    constructor(migrations) {
        this.migrations = migrations;
    }
    /** Add a migrator to the MigrationBuilder. Types are updated such that the chained MigrationBuilder must currently be
     * at state version equal to the from version of the migrator. Return as MigrationBuilder<TTo> where TTo is the to
     * version of the migrator, so that the next migrator can be chained.
     *
     * @param migrate A migrator class or a tuple of a migrator class, the from version, and the to version. A tuple is
     * required to instantiate version numbers unless a default constructor is defined.
     * @returns A new MigrationBuilder with the to version of the migrator as the current version.
     */
    with(...migrate) {
        return this.addMigrator(migrate, "up");
    }
    /** Add a migrator to rollback on the MigrationBuilder's list of migrations. As with {@link with}, types of
     * MigrationBuilder and Migrator must align. However, this time the migration is reversed so TCurrent of the
     * MigrationBuilder must be equal to the to version of the migrator. Return as MigrationBuilder<TFrom> where TFrom
     * is the from version of the migrator, so that the next migrator can be chained.
     *
     * @param migrate A migrator class or a tuple of a migrator class, the from version, and the to version. A tuple is
     * required to instantiate version numbers unless a default constructor is defined.
     * @returns A new MigrationBuilder with the from version of the migrator as the current version.
     */
    rollback(...migrate) {
        if (migrate.length === 3) {
            migrate = [migrate[0], migrate[2], migrate[1]];
        }
        return this.addMigrator(migrate, "down");
    }
    /** Execute the migrations as defined in the MigrationBuilder's migrator buffer */
    migrate(helper) {
        return this.migrations.reduce((promise, migrator) => promise.then(() => migration_builder_awaiter(this, void 0, void 0, function* () {
            yield this.runMigrator(migrator.migrator, helper, migrator.direction);
        })), Promise.resolve());
    }
    addMigrator(migrate, direction = "up") {
        const newMigration = migrate.length === 1
            ? { migrator: new migrate[0](), direction }
            : { migrator: new migrate[0](migrate[1], migrate[2]), direction };
        return new MigrationBuilder([...this.migrations, newMigration]);
    }
    runMigrator(migrator, helper, direction) {
        return migration_builder_awaiter(this, void 0, void 0, function* () {
            const shouldMigrate = yield migrator.shouldMigrate(helper, direction);
            helper.info(`Migrator ${migrator.constructor.name} (to version ${migrator.toVersion}) should migrate: ${shouldMigrate} - ${direction}`);
            if (shouldMigrate) {
                const method = direction === "up" ? migrator.migrate : migrator.rollback;
                yield method.bind(migrator)(helper);
                helper.info(`Migrator ${migrator.constructor.name} (to version ${migrator.toVersion}) migrated - ${direction}`);
                yield migrator.updateVersion(helper, direction);
                helper.info(`Migrator ${migrator.constructor.name} (to version ${migrator.toVersion}) updated version - ${direction}`);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrator.ts
var migrator_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
const IRREVERSIBLE = new Error("Irreversible migration");
class Migrator {
    constructor(fromVersion, toVersion) {
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        if (fromVersion == null || toVersion == null) {
            throw new Error("Invalid migration");
        }
        if (fromVersion > toVersion) {
            throw new Error("Invalid migration");
        }
    }
    shouldMigrate(helper, direction) {
        const startVersion = direction === "up" ? this.fromVersion : this.toVersion;
        return Promise.resolve(helper.currentVersion === startVersion);
    }
    updateVersion(helper, direction) {
        return migrator_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            yield helper.set("stateVersion", endVersion);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/10-move-ever-had-user-key-to-state-providers.ts
var _10_move_ever_had_user_key_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _10_move_ever_had_user_key_to_state_providers_USER_EVER_HAD_USER_KEY = {
    key: "everHadUserKey",
    stateDefinition: {
        name: "crypto",
    },
};
class EverHadUserKeyMigrator extends Migrator {
    migrate(helper) {
        return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a;
                return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.everHadUserKey;
                    yield helper.setToUser(userId, _10_move_ever_had_user_key_to_state_providers_USER_EVER_HAD_USER_KEY, value !== null && value !== void 0 ? value : false);
                    if (value != null) {
                        delete account.profile.everHadUserKey;
                    }
                    yield helper.set(userId, account);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, _10_move_ever_had_user_key_to_state_providers_USER_EVER_HAD_USER_KEY);
                    if (account) {
                        account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                            everHadUserKey: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _10_move_ever_had_user_key_to_state_providers_USER_EVER_HAD_USER_KEY, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/11-move-org-keys-to-state-providers.ts
var _11_move_org_keys_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _11_move_org_keys_to_state_providers_USER_ENCRYPTED_ORGANIZATION_KEYS = {
    key: "organizationKeys",
    stateDefinition: {
        name: "crypto",
    },
};
class OrganizationKeyMigrator extends Migrator {
    migrate(helper) {
        return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, _11_move_org_keys_to_state_providers_USER_ENCRYPTED_ORGANIZATION_KEYS, value);
                        delete account.keys.organizationKeys;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, _11_move_org_keys_to_state_providers_USER_ENCRYPTED_ORGANIZATION_KEYS);
                    if (account && value) {
                        account.keys = Object.assign((_a = account.keys) !== null && _a !== void 0 ? _a : {}, {
                            organizationKeys: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _11_move_org_keys_to_state_providers_USER_ENCRYPTED_ORGANIZATION_KEYS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/12-move-environment-state-to-providers.ts
var _12_move_environment_state_to_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ENVIRONMENT_STATE = { name: "environment" };
const REGION_KEY = { key: "region", stateDefinition: ENVIRONMENT_STATE };
const URLS_KEY = { key: "urls", stateDefinition: ENVIRONMENT_STATE };
class MoveEnvironmentStateToProviders extends Migrator {
    migrate(helper) {
        return _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            // Move global data
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.region) != null) {
                yield helper.setToGlobal(REGION_KEY, legacyGlobal.region);
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.environmentUrls) != null) {
                yield helper.setToGlobal(URLS_KEY, legacyGlobal.environmentUrls);
            }
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map(({ userId, account }) => _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
                var _a, _b, _c, _d;
                // Move account data
                if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.region) != null) {
                    yield helper.setToUser(userId, REGION_KEY, account.settings.region);
                }
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.environmentUrls) != null) {
                    yield helper.setToUser(userId, URLS_KEY, account.settings.environmentUrls);
                }
                // Delete old account data
                (_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? true : delete _c.region;
                (_d = account === null || account === void 0 ? void 0 : account.settings) === null || _d === void 0 ? true : delete _d.environmentUrls;
                yield helper.set(userId, account);
            })));
            // Delete legacy global data
            legacyGlobal === null || legacyGlobal === void 0 ? true : delete legacyGlobal.region;
            legacyGlobal === null || legacyGlobal === void 0 ? true : delete legacyGlobal.environmentUrls;
            yield helper.set("global", legacyGlobal);
        });
    }
    rollback(helper) {
        return _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
            let legacyGlobal = yield helper.get("global");
            let updatedLegacyGlobal = false;
            const globalRegion = yield helper.getFromGlobal(REGION_KEY);
            if (globalRegion) {
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                updatedLegacyGlobal = true;
                legacyGlobal.region = globalRegion;
                yield helper.setToGlobal(REGION_KEY, null);
            }
            const globalUrls = yield helper.getFromGlobal(URLS_KEY);
            if (globalUrls) {
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                updatedLegacyGlobal = true;
                legacyGlobal.environmentUrls = globalUrls;
                yield helper.setToGlobal(URLS_KEY, null);
            }
            if (updatedLegacyGlobal) {
                yield helper.set("global", legacyGlobal);
            }
            function rollbackUser(userId, account) {
                return _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    const userRegion = yield helper.getFromUser(userId, REGION_KEY);
                    if (userRegion) {
                        if (!account) {
                            account = {};
                        }
                        if (!account.settings) {
                            account.settings = {};
                        }
                        updatedAccount = true;
                        account.settings.region = userRegion;
                        yield helper.setToUser(userId, REGION_KEY, null);
                    }
                    const userUrls = yield helper.getFromUser(userId, URLS_KEY);
                    if (userUrls) {
                        if (!account) {
                            account = {};
                        }
                        if (!account.settings) {
                            account.settings = {};
                        }
                        updatedAccount = true;
                        account.settings.environmentUrls = userUrls;
                        yield helper.setToUser(userId, URLS_KEY, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/13-move-provider-keys-to-state-providers.ts
var _13_move_provider_keys_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _13_move_provider_keys_to_state_providers_USER_ENCRYPTED_PROVIDER_KEYS = {
    key: "providerKeys",
    stateDefinition: {
        name: "crypto",
    },
};
class ProviderKeyMigrator extends Migrator {
    migrate(helper) {
        return _13_move_provider_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _13_move_provider_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.providerKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, _13_move_provider_keys_to_state_providers_USER_ENCRYPTED_PROVIDER_KEYS, value);
                        delete account.keys.providerKeys;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _13_move_provider_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _13_move_provider_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, _13_move_provider_keys_to_state_providers_USER_ENCRYPTED_PROVIDER_KEYS);
                    if (account && value) {
                        account.keys = Object.assign((_a = account.keys) !== null && _a !== void 0 ? _a : {}, {
                            providerKeys: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _13_move_provider_keys_to_state_providers_USER_ENCRYPTED_PROVIDER_KEYS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/14-move-biometric-client-key-half-state-to-providers.ts
var _14_move_biometric_client_key_half_state_to_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// Biometric text, no auto prompt text, fingerprint validated, and prompt cancelled are refreshed on every app start, so we don't need to migrate them
const CLIENT_KEY_HALF = {
    key: "clientKeyHalf",
    stateDefinition: { name: "biometricSettings" },
};
class MoveBiometricClientKeyHalfToStateProviders extends Migrator {
    migrate(helper) {
        return _14_move_biometric_client_key_half_state_to_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map(({ userId, account }) => _14_move_biometric_client_key_half_state_to_providers_awaiter(this, void 0, void 0, function* () {
                var _a, _b;
                // Move account data
                if (((_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.biometricEncryptionClientKeyHalf) != null) {
                    yield helper.setToUser(userId, CLIENT_KEY_HALF, account.keys.biometricEncryptionClientKeyHalf);
                    // Delete old account data
                    (_b = account === null || account === void 0 ? void 0 : account.keys) === null || _b === void 0 ? true : delete _b.biometricEncryptionClientKeyHalf;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _14_move_biometric_client_key_half_state_to_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                var _a;
                return _14_move_biometric_client_key_half_state_to_providers_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    const userKeyHalf = yield helper.getFromUser(userId, CLIENT_KEY_HALF);
                    if (userKeyHalf) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.keys) !== null && _a !== void 0 ? _a : (account.keys = {});
                        updatedAccount = true;
                        account.keys.biometricEncryptionClientKeyHalf = userKeyHalf;
                        yield helper.setToUser(userId, CLIENT_KEY_HALF, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/15-move-folder-state-to-state-provider.ts
var _15_move_folder_state_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_ENCRYPTED_FOLDERS = {
    key: "folders",
    stateDefinition: {
        name: "folder",
    },
};
class FolderMigrator extends Migrator {
    migrate(helper) {
        return _15_move_folder_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _15_move_folder_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.folders) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_ENCRYPTED_FOLDERS, value);
                        delete account.data.folders;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _15_move_folder_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _15_move_folder_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, USER_ENCRYPTED_FOLDERS);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            folders: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_ENCRYPTED_FOLDERS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/16-move-last-sync-to-state-provider.ts
var _16_move_last_sync_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const LAST_SYNC_KEY = {
    key: "lastSync",
    stateDefinition: {
        name: "sync",
    },
};
class LastSyncMigrator extends Migrator {
    migrate(helper) {
        return _16_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a;
                return _16_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.lastSync;
                    yield helper.setToUser(userId, LAST_SYNC_KEY, value !== null && value !== void 0 ? value : null);
                    if (value != null) {
                        delete account.profile.lastSync;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _16_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _16_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, LAST_SYNC_KEY);
                    if (account) {
                        account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                            lastSync: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, LAST_SYNC_KEY, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/17-move-enable-passkeys-to-state-providers.ts
var _17_move_enable_passkeys_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_ENABLE_PASSKEYS = {
    key: "enablePasskeys",
    stateDefinition: {
        name: "vaultSettings",
    },
};
class EnablePasskeysMigrator extends Migrator {
    migrate(helper) {
        return _17_move_enable_passkeys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            if ((global === null || global === void 0 ? void 0 : global.enablePasskeys) != null) {
                yield helper.setToGlobal(USER_ENABLE_PASSKEYS, global.enablePasskeys);
                global === null || global === void 0 ? true : delete global.enablePasskeys;
                yield helper.set("global", global);
            }
        });
    }
    rollback(helper) {
        return _17_move_enable_passkeys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            let global = yield helper.get("global");
            const globalEnablePasskeys = yield helper.getFromGlobal(USER_ENABLE_PASSKEYS);
            if (globalEnablePasskeys != null) {
                global = Object.assign(global !== null && global !== void 0 ? global : {}, { enablePasskeys: globalEnablePasskeys });
                yield helper.set("global", global);
                yield helper.setToGlobal(USER_ENABLE_PASSKEYS, undefined);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/18-move-autofill-settings-to-state-providers.ts
var _18_move_autofill_settings_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const AutofillOverlayVisibility = {
    Off: 0,
    OnButtonClick: 1,
    OnFieldFocus: 2,
};
const autofillSettingsStateDefinition = {
    stateDefinition: {
        name: "autofillSettings",
    },
};
class AutofillSettingsKeyMigrator extends Migrator {
    migrate(helper) {
        return _18_move_autofill_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            // global state (e.g. "autoFillOverlayVisibility -> inlineMenuVisibility")
            const globalState = yield helper.get("global");
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.autoFillOverlayVisibility) != null) {
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "autofillSettingsLocal",
                    },
                    key: "inlineMenuVisibility",
                }, globalState.autoFillOverlayVisibility);
                // delete `autoFillOverlayVisibility` from state global
                delete globalState.autoFillOverlayVisibility;
                yield helper.set("global", globalState);
            }
            // account state (e.g. account settings -> state provider framework keys)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            // migrate account state
            function migrateAccount(userId, account) {
                return _18_move_autofill_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let updateAccount = false;
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.autoFillOnPageLoadDefault) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadDefault" }), accountSettings.autoFillOnPageLoadDefault);
                        delete account.settings.autoFillOnPageLoadDefault;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.enableAutoFillOnPageLoad) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoad" }), accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.enableAutoFillOnPageLoad);
                        delete account.settings.enableAutoFillOnPageLoad;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.dismissedAutoFillOnPageLoadCallout) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadCalloutIsDismissed" }), accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.dismissedAutoFillOnPageLoadCallout);
                        delete account.settings.dismissedAutoFillOnPageLoadCallout;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.disableAutoTotpCopy) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autoCopyTotp" }), 
                        // invert the value to match the new naming convention
                        !(accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.disableAutoTotpCopy));
                        delete account.settings.disableAutoTotpCopy;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.activateAutoFillOnPageLoadFromPolicy) != null) {
                        yield helper.setToUser(userId, {
                            stateDefinition: {
                                name: "autofillSettingsLocal",
                            },
                            key: "activateAutofillOnPageLoadFromPolicy",
                        }, accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.activateAutoFillOnPageLoadFromPolicy);
                        delete account.settings.activateAutoFillOnPageLoadFromPolicy;
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        // update the state account settings with the migrated values deleted
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _18_move_autofill_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            // global state (e.g. "inlineMenuVisibility -> autoFillOverlayVisibility")
            const globalState = (yield helper.get("global")) || {};
            const inlineMenuVisibility = yield helper.getFromGlobal({
                stateDefinition: {
                    name: "autofillSettingsLocal",
                },
                key: "inlineMenuVisibility",
            });
            if (inlineMenuVisibility) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { autoFillOverlayVisibility: inlineMenuVisibility }));
                // remove the global state provider framework key for `inlineMenuVisibility`
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "autofillSettingsLocal",
                    },
                    key: "inlineMenuVisibility",
                }, null);
            }
            // account state (e.g. state provider framework keys -> account settings)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            // rollback account state
            function rollbackAccount(userId, account) {
                return _18_move_autofill_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let updateAccount = false;
                    let settings = (account === null || account === void 0 ? void 0 : account.settings) || {};
                    const autoFillOnPageLoadDefault = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadDefault" }));
                    const enableAutoFillOnPageLoad = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoad" }));
                    const dismissedAutoFillOnPageLoadCallout = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadCalloutIsDismissed" }));
                    const autoCopyTotp = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autoCopyTotp" }));
                    const activateAutoFillOnPageLoadFromPolicy = yield helper.getFromUser(userId, {
                        stateDefinition: {
                            name: "autofillSettingsLocal",
                        },
                        key: "activateAutofillOnPageLoadFromPolicy",
                    });
                    // update new settings and remove the account state provider framework keys for the rolled back values
                    if (autoFillOnPageLoadDefault != null) {
                        settings = Object.assign(Object.assign({}, settings), { autoFillOnPageLoadDefault });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadDefault" }), null);
                        updateAccount = true;
                    }
                    if (enableAutoFillOnPageLoad != null) {
                        settings = Object.assign(Object.assign({}, settings), { enableAutoFillOnPageLoad });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoad" }), null);
                        updateAccount = true;
                    }
                    if (dismissedAutoFillOnPageLoadCallout != null) {
                        settings = Object.assign(Object.assign({}, settings), { dismissedAutoFillOnPageLoadCallout });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadCalloutIsDismissed" }), null);
                        updateAccount = true;
                    }
                    if (autoCopyTotp != null) {
                        // invert the value to match the new naming convention
                        settings = Object.assign(Object.assign({}, settings), { disableAutoTotpCopy: !autoCopyTotp });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autoCopyTotp" }), null);
                        updateAccount = true;
                    }
                    if (activateAutoFillOnPageLoadFromPolicy != null) {
                        settings = Object.assign(Object.assign({}, settings), { activateAutoFillOnPageLoadFromPolicy });
                        yield helper.setToUser(userId, {
                            stateDefinition: {
                                name: "autofillSettingsLocal",
                            },
                            key: "activateAutofillOnPageLoadFromPolicy",
                        }, null);
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        // commit updated settings to state
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/19-migrate-require-password-on-start.ts
var _19_migrate_require_password_on_start_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// Biometric text, no auto prompt text, fingerprint validated, and prompt cancelled are refreshed on every app start, so we don't need to migrate them
const _19_migrate_require_password_on_start_REQUIRE_PASSWORD_ON_START = {
    key: "requirePasswordOnStart",
    stateDefinition: { name: "biometricSettings" },
};
class RequirePasswordOnStartMigrator extends Migrator {
    migrate(helper) {
        return _19_migrate_require_password_on_start_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map(({ userId, account }) => _19_migrate_require_password_on_start_awaiter(this, void 0, void 0, function* () {
                var _a;
                // Move account data
                if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.requirePasswordOnStart) != null) {
                    yield helper.setToUser(userId, _19_migrate_require_password_on_start_REQUIRE_PASSWORD_ON_START, account.settings.requirePasswordOnStart);
                    // Delete old account data
                    delete account.settings.requirePasswordOnStart;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _19_migrate_require_password_on_start_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                var _a;
                return _19_migrate_require_password_on_start_awaiter(this, void 0, void 0, function* () {
                    const requirePassword = yield helper.getFromUser(userId, _19_migrate_require_password_on_start_REQUIRE_PASSWORD_ON_START);
                    if (requirePassword) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        account.settings.requirePasswordOnStart = requirePassword;
                        yield helper.setToUser(userId, _19_migrate_require_password_on_start_REQUIRE_PASSWORD_ON_START, null);
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/20-move-private-key-to-state-providers.ts
var _20_move_private_key_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _20_move_private_key_to_state_providers_USER_ENCRYPTED_PRIVATE_KEY = {
    key: "privateKey",
    stateDefinition: {
        name: "crypto",
    },
};
class PrivateKeyMigrator extends Migrator {
    migrate(helper) {
        return _20_move_private_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _20_move_private_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.privateKey) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, _20_move_private_key_to_state_providers_USER_ENCRYPTED_PRIVATE_KEY, value);
                        delete account.keys.privateKey;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _20_move_private_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _20_move_private_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, _20_move_private_key_to_state_providers_USER_ENCRYPTED_PRIVATE_KEY);
                    if (account && value) {
                        account.keys = Object.assign((_a = account.keys) !== null && _a !== void 0 ? _a : {}, {
                            privateKey: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _20_move_private_key_to_state_providers_USER_ENCRYPTED_PRIVATE_KEY, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/21-move-collections-state-to-state-provider.ts
var _21_move_collections_state_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_ENCRYPTED_COLLECTIONS = {
    key: "collections",
    stateDefinition: {
        name: "collection",
    },
};
class CollectionMigrator extends Migrator {
    migrate(helper) {
        return _21_move_collections_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _21_move_collections_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.collections) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_ENCRYPTED_COLLECTIONS, value);
                        delete account.data.collections;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _21_move_collections_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _21_move_collections_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, USER_ENCRYPTED_COLLECTIONS);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            collections: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_ENCRYPTED_COLLECTIONS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/22-move-collapsed-groupings-to-state-provider.ts
var _22_move_collapsed_groupings_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const COLLAPSED_GROUPINGS = {
    key: "collapsedGroupings",
    stateDefinition: {
        name: "vaultFilter",
    },
};
class CollapsedGroupingsMigrator extends Migrator {
    migrate(helper) {
        return _22_move_collapsed_groupings_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a;
                return _22_move_collapsed_groupings_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.collapsedGroupings;
                    if (value != null) {
                        yield helper.setToUser(userId, COLLAPSED_GROUPINGS, value);
                        delete account.settings.collapsedGroupings;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _22_move_collapsed_groupings_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _22_move_collapsed_groupings_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, COLLAPSED_GROUPINGS);
                    if (account) {
                        account.settings = Object.assign((_a = account.settings) !== null && _a !== void 0 ? _a : {}, {
                            collapsedGroupings: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, COLLAPSED_GROUPINGS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/23-move-biometric-prompts-to-state-providers.ts
var _23_move_biometric_prompts_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// prompt cancelled is refreshed on every app start/quit/unlock, so we don't need to migrate it
const DISMISSED_BIOMETRIC_REQUIRE_PASSWORD_ON_START_CALLOUT = {
    key: "dismissedBiometricRequirePasswordOnStartCallout",
    stateDefinition: { name: "biometricSettings" },
};
const _23_move_biometric_prompts_to_state_providers_PROMPT_AUTOMATICALLY = {
    key: "promptAutomatically",
    stateDefinition: { name: "biometricSettings" },
};
class MoveBiometricPromptsToStateProviders extends Migrator {
    migrate(helper) {
        return _23_move_biometric_prompts_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map(({ userId, account }) => _23_move_biometric_prompts_to_state_providers_awaiter(this, void 0, void 0, function* () {
                var _a, _b, _c, _d;
                if (account == null) {
                    return;
                }
                // Move account data
                if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.dismissedBiometricRequirePasswordOnStartCallout) != null) {
                    yield helper.setToUser(userId, DISMISSED_BIOMETRIC_REQUIRE_PASSWORD_ON_START_CALLOUT, account.settings.dismissedBiometricRequirePasswordOnStartCallout);
                }
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.disableAutoBiometricsPrompt) != null) {
                    yield helper.setToUser(userId, _23_move_biometric_prompts_to_state_providers_PROMPT_AUTOMATICALLY, !account.settings.disableAutoBiometricsPrompt);
                }
                // Delete old account data
                (_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? true : delete _c.dismissedBiometricRequirePasswordOnStartCallout;
                (_d = account === null || account === void 0 ? void 0 : account.settings) === null || _d === void 0 ? true : delete _d.disableAutoBiometricsPrompt;
                yield helper.set(userId, account);
            })));
        });
    }
    rollback(helper) {
        return _23_move_biometric_prompts_to_state_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                var _a, _b;
                return _23_move_biometric_prompts_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    const userDismissed = yield helper.getFromUser(userId, DISMISSED_BIOMETRIC_REQUIRE_PASSWORD_ON_START_CALLOUT);
                    if (userDismissed) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        updatedAccount = true;
                        account.settings.dismissedBiometricRequirePasswordOnStartCallout = userDismissed;
                        yield helper.setToUser(userId, DISMISSED_BIOMETRIC_REQUIRE_PASSWORD_ON_START_CALLOUT, null);
                    }
                    const userPromptAutomatically = yield helper.getFromUser(userId, _23_move_biometric_prompts_to_state_providers_PROMPT_AUTOMATICALLY);
                    if (userPromptAutomatically != null) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_b = account.settings) !== null && _b !== void 0 ? _b : (account.settings = {});
                        updatedAccount = true;
                        account.settings.disableAutoBiometricsPrompt = !userPromptAutomatically;
                        yield helper.setToUser(userId, _23_move_biometric_prompts_to_state_providers_PROMPT_AUTOMATICALLY, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/24-move-sm-onboarding-key-to-state-providers.ts
var _24_move_sm_onboarding_key_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const SM_ONBOARDING_TASKS = {
    key: "tasks",
    stateDefinition: { name: "smOnboarding" },
};
class SmOnboardingTasksMigrator extends Migrator {
    migrate(helper) {
        return _24_move_sm_onboarding_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map(({ userId, account }) => _24_move_sm_onboarding_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                var _a;
                // Move account data
                if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.smOnboardingTasks) != null) {
                    yield helper.setToUser(userId, SM_ONBOARDING_TASKS, account.settings.smOnboardingTasks);
                    // Delete old account data
                    delete account.settings.smOnboardingTasks;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _24_move_sm_onboarding_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                var _a;
                return _24_move_sm_onboarding_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const smOnboardingTasks = yield helper.getFromUser(userId, SM_ONBOARDING_TASKS);
                    if (smOnboardingTasks) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        account.settings.smOnboardingTasks = smOnboardingTasks;
                        yield helper.setToUser(userId, SM_ONBOARDING_TASKS, null);
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/25-move-clear-clipboard-to-autofill-settings-state-provider.ts
var _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ClearClipboardDelay = {
    Never: null,
    TenSeconds: 10,
    TwentySeconds: 20,
    ThirtySeconds: 30,
    OneMinute: 60,
    TwoMinutes: 120,
    FiveMinutes: 300,
};
const autofillSettingsLocalStateDefinition = {
    stateDefinition: {
        name: "autofillSettingsLocal",
    },
};
class ClearClipboardDelayMigrator extends Migrator {
    migrate(helper) {
        return _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            // account state (e.g. account settings -> state provider framework keys)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            // migrate account state
            function migrateAccount(userId, account) {
                return _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.clearClipboard) !== undefined) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsLocalStateDefinition), { key: "clearClipboardDelay" }), accountSettings.clearClipboard);
                        delete account.settings.clearClipboard;
                        // update the state account settings with the migrated values deleted
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            // account state (e.g. state provider framework keys -> account settings)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            // rollback account state
            function rollbackAccount(userId, account) {
                return _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
                    let settings = (account === null || account === void 0 ? void 0 : account.settings) || {};
                    const clearClipboardDelay = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsLocalStateDefinition), { key: "clearClipboardDelay" }));
                    // update new settings and remove the account state provider framework keys for the rolled back values
                    if (clearClipboardDelay !== undefined) {
                        settings = Object.assign(Object.assign({}, settings), { clearClipboard: clearClipboardDelay });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsLocalStateDefinition), { key: "clearClipboardDelay" }), null);
                        // commit updated settings to state
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/26-revert-move-last-sync-to-state-provider.ts
var _26_revert_move_last_sync_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _26_revert_move_last_sync_to_state_provider_LAST_SYNC_KEY = {
    key: "lastSync",
    stateDefinition: {
        name: "sync",
    },
};
class RevertLastSyncMigrator extends Migrator {
    rollback(helper) {
        return _26_revert_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _26_revert_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.lastSync;
                    yield helper.setToUser(userId, _26_revert_move_last_sync_to_state_provider_LAST_SYNC_KEY, value !== null && value !== void 0 ? value : null);
                    if (value != null) {
                        delete account.profile.lastSync;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
    migrate(helper) {
        return _26_revert_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a;
                return _26_revert_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, _26_revert_move_last_sync_to_state_provider_LAST_SYNC_KEY);
                    if (account) {
                        account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                            lastSync: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _26_revert_move_last_sync_to_state_provider_LAST_SYNC_KEY, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/27-move-badge-settings-to-state-providers.ts
var _27_move_badge_settings_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const enableBadgeCounterKeyDefinition = {
    stateDefinition: {
        name: "badgeSettings",
    },
    key: "enableBadgeCounter",
};
class BadgeSettingsMigrator extends Migrator {
    migrate(helper) {
        return _27_move_badge_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            // account state (e.g. account settings -> state provider framework keys)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            // migrate account state
            function migrateAccount(userId, account) {
                return _27_move_badge_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.disableBadgeCounter) != undefined) {
                        yield helper.setToUser(userId, enableBadgeCounterKeyDefinition, !accountSettings.disableBadgeCounter);
                        delete account.settings.disableBadgeCounter;
                        // update the state account settings with the migrated values deleted
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _27_move_badge_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            // account state (e.g. state provider framework keys -> account settings)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            // rollback account state
            function rollbackAccount(userId, account) {
                return _27_move_badge_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let settings = (account === null || account === void 0 ? void 0 : account.settings) || {};
                    const enableBadgeCounter = yield helper.getFromUser(userId, enableBadgeCounterKeyDefinition);
                    // update new settings and remove the account state provider framework keys for the rolled back values
                    if (enableBadgeCounter != undefined) {
                        settings = Object.assign(Object.assign({}, settings), { disableBadgeCounter: !enableBadgeCounter });
                        yield helper.setToUser(userId, enableBadgeCounterKeyDefinition, null);
                        // commit updated settings to state
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/28-move-biometric-unlock-to-state-providers.ts
var _28_move_biometric_unlock_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _28_move_biometric_unlock_to_state_providers_BIOMETRIC_UNLOCK_ENABLED = {
    key: "biometricUnlockEnabled",
    stateDefinition: { name: "biometricSettings" },
};
class MoveBiometricUnlockToStateProviders extends Migrator {
    migrate(helper) {
        return _28_move_biometric_unlock_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map(({ userId, account }) => _28_move_biometric_unlock_to_state_providers_awaiter(this, void 0, void 0, function* () {
                var _a, _b;
                if (account == null) {
                    return;
                }
                // Move account data
                if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.biometricUnlock) != null) {
                    yield helper.setToUser(userId, _28_move_biometric_unlock_to_state_providers_BIOMETRIC_UNLOCK_ENABLED, account.settings.biometricUnlock);
                }
                // Delete old account data
                (_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? true : delete _b.biometricUnlock;
                yield helper.set(userId, account);
            })));
        });
    }
    rollback(helper) {
        return _28_move_biometric_unlock_to_state_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                var _a;
                return _28_move_biometric_unlock_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const biometricUnlock = yield helper.getFromUser(userId, _28_move_biometric_unlock_to_state_providers_BIOMETRIC_UNLOCK_ENABLED);
                    if (biometricUnlock != null) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        account.settings.biometricUnlock = biometricUnlock;
                        yield helper.setToUser(userId, _28_move_biometric_unlock_to_state_providers_BIOMETRIC_UNLOCK_ENABLED, null);
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/29-move-user-notification-settings-to-state-provider.ts
var _29_move_user_notification_settings_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class UserNotificationSettingsKeyMigrator extends Migrator {
    migrate(helper) {
        return _29_move_user_notification_settings_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const globalState = yield helper.get("global");
            // disableAddLoginNotification -> enableAddedLoginPrompt
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.disableAddLoginNotification) != null) {
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "userNotificationSettings",
                    },
                    key: "enableAddedLoginPrompt",
                }, !globalState.disableAddLoginNotification);
                // delete `disableAddLoginNotification` from state global
                delete globalState.disableAddLoginNotification;
                yield helper.set("global", globalState);
            }
            // disableChangedPasswordNotification -> enableChangedPasswordPrompt
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.disableChangedPasswordNotification) != null) {
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "userNotificationSettings",
                    },
                    key: "enableChangedPasswordPrompt",
                }, !globalState.disableChangedPasswordNotification);
                // delete `disableChangedPasswordNotification` from state global
                delete globalState.disableChangedPasswordNotification;
                yield helper.set("global", globalState);
            }
        });
    }
    rollback(helper) {
        return _29_move_user_notification_settings_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const globalState = (yield helper.get("global")) || {};
            const enableAddedLoginPrompt = yield helper.getFromGlobal({
                stateDefinition: {
                    name: "userNotificationSettings",
                },
                key: "enableAddedLoginPrompt",
            });
            const enableChangedPasswordPrompt = yield helper.getFromGlobal({
                stateDefinition: {
                    name: "userNotificationSettings",
                },
                key: "enableChangedPasswordPrompt",
            });
            // enableAddedLoginPrompt -> disableAddLoginNotification
            if (enableAddedLoginPrompt) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { disableAddLoginNotification: !enableAddedLoginPrompt }));
                // remove the global state provider framework key for `enableAddedLoginPrompt`
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "userNotificationSettings",
                    },
                    key: "enableAddedLoginPrompt",
                }, null);
            }
            // enableChangedPasswordPrompt -> disableChangedPasswordNotification
            if (enableChangedPasswordPrompt) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { disableChangedPasswordNotification: !enableChangedPasswordPrompt }));
                // remove the global state provider framework key for `enableChangedPasswordPrompt`
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "userNotificationSettings",
                    },
                    key: "enableChangedPasswordPrompt",
                }, null);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/30-move-policy-state-to-state-provider.ts
var _30_move_policy_state_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

var _30_move_policy_state_to_state_provider_PolicyType;
(function (PolicyType) {
    PolicyType[PolicyType["TwoFactorAuthentication"] = 0] = "TwoFactorAuthentication";
    PolicyType[PolicyType["MasterPassword"] = 1] = "MasterPassword";
    PolicyType[PolicyType["PasswordGenerator"] = 2] = "PasswordGenerator";
    PolicyType[PolicyType["SingleOrg"] = 3] = "SingleOrg";
    PolicyType[PolicyType["RequireSso"] = 4] = "RequireSso";
    PolicyType[PolicyType["PersonalOwnership"] = 5] = "PersonalOwnership";
    PolicyType[PolicyType["DisableSend"] = 6] = "DisableSend";
    PolicyType[PolicyType["SendOptions"] = 7] = "SendOptions";
    PolicyType[PolicyType["ResetPassword"] = 8] = "ResetPassword";
    PolicyType[PolicyType["MaximumVaultTimeout"] = 9] = "MaximumVaultTimeout";
    PolicyType[PolicyType["DisablePersonalVaultExport"] = 10] = "DisablePersonalVaultExport";
    PolicyType[PolicyType["ActivateAutofill"] = 11] = "ActivateAutofill";
})(_30_move_policy_state_to_state_provider_PolicyType || (_30_move_policy_state_to_state_provider_PolicyType = {}));
const POLICIES_KEY = {
    key: "policies",
    stateDefinition: {
        name: "policies",
    },
};
class PolicyMigrator extends Migrator {
    migrate(helper) {
        return _30_move_policy_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _30_move_policy_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.policies) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, POLICIES_KEY, value);
                        delete account.data.policies;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => migrateAccount(userId, account)));
        });
    }
    rollback(helper) {
        return _30_move_policy_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _30_move_policy_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, POLICIES_KEY);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            policies: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, POLICIES_KEY, null);
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => rollbackAccount(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/31-move-enable-context-menu-to-autofill-settings-state-provider.ts
var _31_move_enable_context_menu_to_autofill_settings_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const enableContextMenuKeyDefinition = {
    stateDefinition: {
        name: "autofillSettings",
    },
    key: "enableContextMenu",
};
class EnableContextMenuMigrator extends Migrator {
    migrate(helper) {
        return _31_move_enable_context_menu_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            const globalState = yield helper.get("global");
            // disableContextMenuItem -> enableContextMenu
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.disableContextMenuItem) != null) {
                yield helper.setToGlobal(enableContextMenuKeyDefinition, !globalState.disableContextMenuItem);
                // delete `disableContextMenuItem` from state global
                delete globalState.disableContextMenuItem;
                yield helper.set("global", globalState);
            }
        });
    }
    rollback(helper) {
        return _31_move_enable_context_menu_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            const globalState = (yield helper.get("global")) || {};
            const enableContextMenu = yield helper.getFromGlobal(enableContextMenuKeyDefinition);
            // enableContextMenu -> disableContextMenuItem
            if (enableContextMenu != null) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { disableContextMenuItem: !enableContextMenu }));
                // remove the global state provider framework key for `enableContextMenu`
                yield helper.setToGlobal(enableContextMenuKeyDefinition, null);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/32-move-preferred-language.ts
var _32_move_preferred_language_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const LOCALE_KEY = {
    key: "locale",
    stateDefinition: {
        name: "translation",
    },
};
class PreferredLanguageMigrator extends Migrator {
    migrate(helper) {
        return _32_move_preferred_language_awaiter(this, void 0, void 0, function* () {
            // global state
            const global = yield helper.get("global");
            if (!(global === null || global === void 0 ? void 0 : global.locale)) {
                return;
            }
            yield helper.setToGlobal(LOCALE_KEY, global.locale);
            delete global.locale;
            yield helper.set("global", global);
        });
    }
    rollback(helper) {
        var _a;
        return _32_move_preferred_language_awaiter(this, void 0, void 0, function* () {
            const locale = yield helper.getFromGlobal(LOCALE_KEY);
            if (!locale) {
                return;
            }
            const global = (_a = (yield helper.get("global"))) !== null && _a !== void 0 ? _a : {};
            global.locale = locale;
            yield helper.set("global", global);
            yield helper.setToGlobal(LOCALE_KEY, null);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/33-move-app-id-to-state-providers.ts
var _33_move_app_id_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const APP_ID_STORAGE_KEY = "appId";
const ANONYMOUS_APP_ID_STORAGE_KEY = "anonymousAppId";
const _33_move_app_id_to_state_providers_APP_ID_KEY = {
    key: APP_ID_STORAGE_KEY,
    stateDefinition: { name: "applicationId" },
};
const _33_move_app_id_to_state_providers_ANONYMOUS_APP_ID_KEY = {
    key: ANONYMOUS_APP_ID_STORAGE_KEY,
    stateDefinition: { name: "applicationId" },
};
class AppIdMigrator extends Migrator {
    migrate(helper) {
        return _33_move_app_id_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const appId = yield helper.get(APP_ID_STORAGE_KEY);
            const anonymousAppId = yield helper.get(ANONYMOUS_APP_ID_STORAGE_KEY);
            if (appId != null) {
                yield helper.setToGlobal(_33_move_app_id_to_state_providers_APP_ID_KEY, appId);
                yield helper.set(APP_ID_STORAGE_KEY, null);
            }
            if (anonymousAppId != null) {
                yield helper.setToGlobal(_33_move_app_id_to_state_providers_ANONYMOUS_APP_ID_KEY, anonymousAppId);
                yield helper.set(ANONYMOUS_APP_ID_STORAGE_KEY, null);
            }
        });
    }
    rollback(helper) {
        return _33_move_app_id_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const appId = yield helper.getFromGlobal(_33_move_app_id_to_state_providers_APP_ID_KEY);
            const anonymousAppId = yield helper.getFromGlobal(_33_move_app_id_to_state_providers_ANONYMOUS_APP_ID_KEY);
            if (appId != null) {
                yield helper.set(APP_ID_STORAGE_KEY, appId);
                yield helper.setToGlobal(_33_move_app_id_to_state_providers_APP_ID_KEY, null);
            }
            if (anonymousAppId != null) {
                yield helper.set(ANONYMOUS_APP_ID_STORAGE_KEY, anonymousAppId);
                yield helper.setToGlobal(_33_move_app_id_to_state_providers_ANONYMOUS_APP_ID_KEY, null);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/34-move-domain-settings-to-state-providers.ts
var _34_move_domain_settings_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _34_move_domain_settings_to_state_providers_UriMatchStrategy = {
    Domain: 0,
    Host: 1,
    StartsWith: 2,
    Exact: 3,
    RegularExpression: 4,
    Never: 5,
};
const defaultUriMatchStrategyDefinition = {
    stateDefinition: {
        name: "domainSettings",
    },
    key: "defaultUriMatchStrategy",
};
const equivalentDomainsDefinition = {
    stateDefinition: {
        name: "domainSettings",
    },
    key: "equivalentDomains",
};
const neverDomainsDefinition = {
    stateDefinition: {
        name: "domainSettings",
    },
    key: "neverDomains",
};
class DomainSettingsMigrator extends Migrator {
    migrate(helper) {
        return _34_move_domain_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            let updateAccount = false;
            // global state ("neverDomains")
            const globalState = yield helper.get("global");
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.neverDomains) != null) {
                yield helper.setToGlobal(neverDomainsDefinition, globalState.neverDomains);
                // delete `neverDomains` from state global
                delete globalState.neverDomains;
                yield helper.set("global", globalState);
            }
            // account state ("defaultUriMatch" and "settings.equivalentDomains")
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            // migrate account state
            function migrateAccount(userId, account) {
                var _a;
                return _34_move_domain_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.defaultUriMatch) != undefined) {
                        yield helper.setToUser(userId, defaultUriMatchStrategyDefinition, accountSettings.defaultUriMatch);
                        delete account.settings.defaultUriMatch;
                        updateAccount = true;
                    }
                    if (((_a = accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.settings) === null || _a === void 0 ? void 0 : _a.equivalentDomains) != undefined) {
                        yield helper.setToUser(userId, equivalentDomainsDefinition, accountSettings.settings.equivalentDomains);
                        delete account.settings.settings.equivalentDomains;
                        delete account.settings.settings;
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        // update the state account settings with the migrated values deleted
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _34_move_domain_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            let updateAccount = false;
            // global state ("neverDomains")
            const globalState = (yield helper.get("global")) || {};
            const neverDomains = yield helper.getFromGlobal(neverDomainsDefinition);
            if (neverDomains != null) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { neverDomains: neverDomains }));
                // remove the global state provider framework key for `neverDomains`
                yield helper.setToGlobal(neverDomainsDefinition, null);
            }
            // account state ("defaultUriMatchStrategy" and "equivalentDomains")
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            // rollback account state
            function rollbackAccount(userId, account) {
                return _34_move_domain_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let settings = (account === null || account === void 0 ? void 0 : account.settings) || {};
                    const defaultUriMatchStrategy = yield helper.getFromUser(userId, defaultUriMatchStrategyDefinition);
                    const equivalentDomains = yield helper.getFromUser(userId, equivalentDomainsDefinition);
                    // update new settings and remove the account state provider framework keys for the rolled back values
                    if (defaultUriMatchStrategy != null) {
                        settings = Object.assign(Object.assign({}, settings), { defaultUriMatch: defaultUriMatchStrategy });
                        yield helper.setToUser(userId, defaultUriMatchStrategyDefinition, null);
                        updateAccount = true;
                    }
                    if (equivalentDomains != null) {
                        settings = Object.assign(Object.assign({}, settings), { settings: { equivalentDomains } });
                        yield helper.setToUser(userId, equivalentDomainsDefinition, null);
                        updateAccount = true;
                    }
                    // commit updated settings to state
                    if (updateAccount) {
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/35-move-theme-to-state-providers.ts
var _35_move_theme_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const THEME_SELECTION = {
    key: "selection",
    stateDefinition: { name: "theming" },
};
class MoveThemeToStateProviderMigrator extends Migrator {
    migrate(helper) {
        return _35_move_theme_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyGlobalState = yield helper.get("global");
            const theme = legacyGlobalState === null || legacyGlobalState === void 0 ? void 0 : legacyGlobalState.theme;
            if (theme != null) {
                yield helper.setToGlobal(THEME_SELECTION, theme);
                delete legacyGlobalState.theme;
                yield helper.set("global", legacyGlobalState);
            }
        });
    }
    rollback(helper) {
        var _a;
        return _35_move_theme_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const theme = yield helper.getFromGlobal(THEME_SELECTION);
            if (theme != null) {
                const legacyGlobal = (_a = (yield helper.get("global"))) !== null && _a !== void 0 ? _a : {};
                legacyGlobal.theme = theme;
                yield helper.set("global", legacyGlobal);
                yield helper.removeFromGlobal(THEME_SELECTION);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/36-move-show-card-and-identity-to-state-provider.ts
var _36_move_show_card_and_identity_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const vaultSettingsStateDefinition = {
    stateDefinition: {
        name: "vaultSettings",
    },
};
class VaultSettingsKeyMigrator extends Migrator {
    migrate(helper) {
        return _36_move_show_card_and_identity_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            function migrateAccount(userId, account) {
                return _36_move_show_card_and_identity_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updateAccount = false;
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.dontShowCardsCurrentTab) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showCardsCurrentTab" }), !accountSettings.dontShowCardsCurrentTab);
                        delete account.settings.dontShowCardsCurrentTab;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.dontShowIdentitiesCurrentTab) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showIdentitiesCurrentTab" }), !accountSettings.dontShowIdentitiesCurrentTab);
                        delete account.settings.dontShowIdentitiesCurrentTab;
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _36_move_show_card_and_identity_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            function rollbackAccount(userId, account) {
                var _a;
                return _36_move_show_card_and_identity_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updateAccount = false;
                    let settings = (_a = account === null || account === void 0 ? void 0 : account.settings) !== null && _a !== void 0 ? _a : {};
                    const showCardsCurrentTab = yield helper.getFromUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showCardsCurrentTab" }));
                    const showIdentitiesCurrentTab = yield helper.getFromUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showIdentitiesCurrentTab" }));
                    if (showCardsCurrentTab != null) {
                        // invert the value to match the new naming convention
                        settings = Object.assign(Object.assign({}, settings), { dontShowCardsCurrentTab: !showCardsCurrentTab });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showCardsCurrentTab" }), null);
                        updateAccount = true;
                    }
                    if (showIdentitiesCurrentTab != null) {
                        // invert the value to match the new naming convention
                        settings = Object.assign(Object.assign({}, settings), { dontShowIdentitiesCurrentTab: !showIdentitiesCurrentTab });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showIdentitiesCurrentTab" }), null);
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/37-move-avatar-color-to-state-providers.ts
var _37_move_avatar_color_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const AVATAR_COLOR_STATE = { name: "avatar" };
const AVATAR_COLOR_KEY = {
    key: "avatarColor",
    stateDefinition: AVATAR_COLOR_STATE,
};
class AvatarColorMigrator extends Migrator {
    migrate(helper) {
        return _37_move_avatar_color_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map(({ userId, account }) => _37_move_avatar_color_to_state_providers_awaiter(this, void 0, void 0, function* () {
                var _a, _b;
                // Move account avatarColor
                if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.avatarColor) != null) {
                    yield helper.setToUser(userId, AVATAR_COLOR_KEY, account.settings.avatarColor);
                    // Delete old account avatarColor property
                    (_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? true : delete _b.avatarColor;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _37_move_avatar_color_to_state_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                return _37_move_avatar_color_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    const userAvatarColor = yield helper.getFromUser(userId, AVATAR_COLOR_KEY);
                    if (userAvatarColor) {
                        if (!account) {
                            account = {};
                        }
                        updatedAccount = true;
                        account.settings.avatarColor = userAvatarColor;
                        yield helper.setToUser(userId, AVATAR_COLOR_KEY, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/38-migrate-token-svc-to-state-provider.ts
var _38_migrate_token_svc_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _38_migrate_token_svc_to_state_provider_EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL = {
    key: "emailTwoFactorTokenRecord",
    stateDefinition: {
        name: "tokenDiskLocal",
    },
};
const TOKEN_STATE_DEF_LIKE = {
    name: "token",
};
const _38_migrate_token_svc_to_state_provider_ACCESS_TOKEN_DISK = {
    key: "accessToken",
    stateDefinition: TOKEN_STATE_DEF_LIKE,
};
const _38_migrate_token_svc_to_state_provider_REFRESH_TOKEN_DISK = {
    key: "refreshToken",
    stateDefinition: TOKEN_STATE_DEF_LIKE,
};
const _38_migrate_token_svc_to_state_provider_API_KEY_CLIENT_ID_DISK = {
    key: "apiKeyClientId",
    stateDefinition: TOKEN_STATE_DEF_LIKE,
};
const _38_migrate_token_svc_to_state_provider_API_KEY_CLIENT_SECRET_DISK = {
    key: "apiKeyClientSecret",
    stateDefinition: TOKEN_STATE_DEF_LIKE,
};
class TokenServiceStateProviderMigrator extends Migrator {
    migrate(helper) {
        return _38_migrate_token_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
            // Move global data
            const globalData = yield helper.get("global");
            // Create new global record for 2FA token that we can accumulate data in
            const emailTwoFactorTokenRecord = {};
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account, globalTwoFactorToken, emailTwoFactorTokenRecord) {
                var _a, _b, _c, _d, _e;
                return _38_migrate_token_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    // migrate 2FA token from global to user state
                    // Due to the existing implmentation, n users on the same device share the same global state value for 2FA token.
                    // So, we will just migrate it to all users to keep it valid for whichever was the user that set it previously.
                    // Note: don't bother migrating 2FA Token if user account or email is undefined
                    const email = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.email;
                    if (globalTwoFactorToken != undefined && account != undefined && email != undefined) {
                        emailTwoFactorTokenRecord[email] = globalTwoFactorToken;
                        // Note: don't set updatedAccount to true here as we aren't updating
                        // the legacy user state, just migrating a global state to a new user state
                    }
                    // Migrate access token
                    const existingAccessToken = (_b = account === null || account === void 0 ? void 0 : account.tokens) === null || _b === void 0 ? void 0 : _b.accessToken;
                    if (existingAccessToken != null) {
                        // Only migrate data that exists
                        if (helper.type !== "web-disk-local") {
                            // only migrate access token to session storage - never local.
                            yield helper.setToUser(userId, _38_migrate_token_svc_to_state_provider_ACCESS_TOKEN_DISK, existingAccessToken);
                        }
                        delete account.tokens.accessToken;
                        updatedAccount = true;
                    }
                    // Migrate refresh token
                    const existingRefreshToken = (_c = account === null || account === void 0 ? void 0 : account.tokens) === null || _c === void 0 ? void 0 : _c.refreshToken;
                    if (existingRefreshToken != null) {
                        if (helper.type !== "web-disk-local") {
                            // only migrate refresh token to session storage - never local.
                            yield helper.setToUser(userId, _38_migrate_token_svc_to_state_provider_REFRESH_TOKEN_DISK, existingRefreshToken);
                        }
                        delete account.tokens.refreshToken;
                        updatedAccount = true;
                    }
                    // Migrate API key client id
                    const existingApiKeyClientId = (_d = account === null || account === void 0 ? void 0 : account.profile) === null || _d === void 0 ? void 0 : _d.apiKeyClientId;
                    if (existingApiKeyClientId != null) {
                        if (helper.type !== "web-disk-local") {
                            // only migrate client id to session storage - never local.
                            yield helper.setToUser(userId, _38_migrate_token_svc_to_state_provider_API_KEY_CLIENT_ID_DISK, existingApiKeyClientId);
                        }
                        delete account.profile.apiKeyClientId;
                        updatedAccount = true;
                    }
                    // Migrate API key client secret
                    const existingApiKeyClientSecret = (_e = account === null || account === void 0 ? void 0 : account.keys) === null || _e === void 0 ? void 0 : _e.apiKeyClientSecret;
                    if (existingApiKeyClientSecret != null) {
                        if (helper.type !== "web-disk-local") {
                            // only migrate client secret to session storage - never local.
                            yield helper.setToUser(userId, _38_migrate_token_svc_to_state_provider_API_KEY_CLIENT_SECRET_DISK, existingApiKeyClientSecret);
                        }
                        delete account.keys.apiKeyClientSecret;
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        // Save the migrated account only if it was updated
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([
                ...accounts.map(({ userId, account }) => migrateAccount(userId, account, globalData === null || globalData === void 0 ? void 0 : globalData.twoFactorToken, emailTwoFactorTokenRecord)),
            ]);
            // Save the global 2FA token record
            yield helper.setToGlobal(_38_migrate_token_svc_to_state_provider_EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL, emailTwoFactorTokenRecord);
            // Delete global data
            globalData === null || globalData === void 0 ? true : delete globalData.twoFactorToken;
            yield helper.set("global", globalData);
        });
    }
    rollback(helper) {
        var _a;
        return _38_migrate_token_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            // Since we migrated the global 2FA token to all users, we need to rollback the 2FA token for all users
            // but we only need to set it to the global state once
            // Go through accounts and find the first user that has a non-null email and 2FA token
            let migratedTwoFactorToken = null;
            for (const { account } of accounts) {
                const email = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.email;
                if (email == null) {
                    continue;
                }
                const emailTwoFactorTokenRecord = yield helper.getFromGlobal(_38_migrate_token_svc_to_state_provider_EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL);
                migratedTwoFactorToken = emailTwoFactorTokenRecord[email];
                if (migratedTwoFactorToken != null) {
                    break;
                }
            }
            if (migratedTwoFactorToken != null) {
                let legacyGlobal = yield helper.get("global");
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                legacyGlobal.twoFactorToken = migratedTwoFactorToken;
                yield helper.set("global", legacyGlobal);
            }
            // delete global 2FA token record
            yield helper.setToGlobal(_38_migrate_token_svc_to_state_provider_EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL, null);
            function rollbackAccount(userId, account) {
                return _38_migrate_token_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updatedLegacyAccount = false;
                    // Rollback access token
                    const migratedAccessToken = yield helper.getFromUser(userId, _38_migrate_token_svc_to_state_provider_ACCESS_TOKEN_DISK);
                    if ((account === null || account === void 0 ? void 0 : account.tokens) && migratedAccessToken != null) {
                        account.tokens.accessToken = migratedAccessToken;
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, _38_migrate_token_svc_to_state_provider_ACCESS_TOKEN_DISK, null);
                    // Rollback refresh token
                    const migratedRefreshToken = yield helper.getFromUser(userId, _38_migrate_token_svc_to_state_provider_REFRESH_TOKEN_DISK);
                    if ((account === null || account === void 0 ? void 0 : account.tokens) && migratedRefreshToken != null) {
                        account.tokens.refreshToken = migratedRefreshToken;
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, _38_migrate_token_svc_to_state_provider_REFRESH_TOKEN_DISK, null);
                    // Rollback API key client id
                    const migratedApiKeyClientId = yield helper.getFromUser(userId, _38_migrate_token_svc_to_state_provider_API_KEY_CLIENT_ID_DISK);
                    if ((account === null || account === void 0 ? void 0 : account.profile) && migratedApiKeyClientId != null) {
                        account.profile.apiKeyClientId = migratedApiKeyClientId;
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, _38_migrate_token_svc_to_state_provider_API_KEY_CLIENT_ID_DISK, null);
                    // Rollback API key client secret
                    const migratedApiKeyClientSecret = yield helper.getFromUser(userId, _38_migrate_token_svc_to_state_provider_API_KEY_CLIENT_SECRET_DISK);
                    if ((account === null || account === void 0 ? void 0 : account.keys) && migratedApiKeyClientSecret != null) {
                        account.keys.apiKeyClientSecret = migratedApiKeyClientSecret;
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, _38_migrate_token_svc_to_state_provider_API_KEY_CLIENT_SECRET_DISK, null);
                    if (updatedLegacyAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/39-move-billing-account-profile-to-state-providers.ts
var _39_move_billing_account_profile_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _39_move_billing_account_profile_to_state_providers_BILLING_ACCOUNT_PROFILE_KEY_DEFINITION = {
    key: "accountProfile",
    stateDefinition: {
        name: "billing",
    },
};
class MoveBillingAccountProfileMigrator extends Migrator {
    migrate(helper) {
        return _39_move_billing_account_profile_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            const migrateAccount = (userId, account) => _39_move_billing_account_profile_to_state_providers_awaiter(this, void 0, void 0, function* () {
                var _a, _b, _c, _d;
                const hasPremiumPersonally = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.hasPremiumPersonally;
                const hasPremiumFromOrganization = (_b = account === null || account === void 0 ? void 0 : account.profile) === null || _b === void 0 ? void 0 : _b.hasPremiumFromOrganization;
                if (hasPremiumPersonally != null || hasPremiumFromOrganization != null) {
                    yield helper.setToUser(userId, _39_move_billing_account_profile_to_state_providers_BILLING_ACCOUNT_PROFILE_KEY_DEFINITION, {
                        hasPremiumPersonally: hasPremiumPersonally,
                        hasPremiumFromOrganization: hasPremiumFromOrganization,
                    });
                    (_c = account === null || account === void 0 ? void 0 : account.profile) === null || _c === void 0 ? true : delete _c.hasPremiumPersonally;
                    (_d = account === null || account === void 0 ? void 0 : account.profile) === null || _d === void 0 ? true : delete _d.hasPremiumFromOrganization;
                    yield helper.set(userId, account);
                }
            });
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _39_move_billing_account_profile_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            const rollbackAccount = (userId, account) => _39_move_billing_account_profile_to_state_providers_awaiter(this, void 0, void 0, function* () {
                var _a;
                const value = yield helper.getFromUser(userId, _39_move_billing_account_profile_to_state_providers_BILLING_ACCOUNT_PROFILE_KEY_DEFINITION);
                if (account && value) {
                    account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                        hasPremiumPersonally: value === null || value === void 0 ? void 0 : value.hasPremiumPersonally,
                        hasPremiumFromOrganization: value === null || value === void 0 ? void 0 : value.hasPremiumFromOrganization,
                    });
                    yield helper.set(userId, account);
                }
                yield helper.setToUser(userId, _39_move_billing_account_profile_to_state_providers_BILLING_ACCOUNT_PROFILE_KEY_DEFINITION, null);
            });
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/4-remove-ever-been-unlocked.ts
var _4_remove_ever_been_unlocked_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class RemoveEverBeenUnlockedMigrator extends Migrator {
    migrate(helper) {
        return _4_remove_ever_been_unlocked_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function removeEverBeenUnlocked(userId, account) {
                var _a;
                return _4_remove_ever_been_unlocked_awaiter(this, void 0, void 0, function* () {
                    if (((_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.everBeenUnlocked) != null) {
                        delete account.profile.everBeenUnlocked;
                        return helper.set(userId, account);
                    }
                });
            }
            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            Promise.all(accounts.map(({ userId, account }) => removeEverBeenUnlocked(userId, account)));
        });
    }
    rollback(helper) {
        throw IRREVERSIBLE;
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _4_remove_ever_been_unlocked_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/40-move-organization-state-to-state-provider.ts
var _40_move_organization_state_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// Local declarations of `OrganizationData` and the types of it's properties.
// Duplicated to remain frozen in time when migration occurs.
var _40_move_organization_state_to_state_provider_OrganizationUserStatusType;
(function (OrganizationUserStatusType) {
    OrganizationUserStatusType[OrganizationUserStatusType["Invited"] = 0] = "Invited";
    OrganizationUserStatusType[OrganizationUserStatusType["Accepted"] = 1] = "Accepted";
    OrganizationUserStatusType[OrganizationUserStatusType["Confirmed"] = 2] = "Confirmed";
    OrganizationUserStatusType[OrganizationUserStatusType["Revoked"] = -1] = "Revoked";
})(_40_move_organization_state_to_state_provider_OrganizationUserStatusType || (_40_move_organization_state_to_state_provider_OrganizationUserStatusType = {}));
var _40_move_organization_state_to_state_provider_OrganizationUserType;
(function (OrganizationUserType) {
    OrganizationUserType[OrganizationUserType["Owner"] = 0] = "Owner";
    OrganizationUserType[OrganizationUserType["Admin"] = 1] = "Admin";
    OrganizationUserType[OrganizationUserType["User"] = 2] = "User";
    OrganizationUserType[OrganizationUserType["Manager"] = 3] = "Manager";
    OrganizationUserType[OrganizationUserType["Custom"] = 4] = "Custom";
})(_40_move_organization_state_to_state_provider_OrganizationUserType || (_40_move_organization_state_to_state_provider_OrganizationUserType = {}));
var _40_move_organization_state_to_state_provider_ProviderType;
(function (ProviderType) {
    ProviderType[ProviderType["Msp"] = 0] = "Msp";
    ProviderType[ProviderType["Reseller"] = 1] = "Reseller";
})(_40_move_organization_state_to_state_provider_ProviderType || (_40_move_organization_state_to_state_provider_ProviderType = {}));
var _40_move_organization_state_to_state_provider_ProductType;
(function (ProductType) {
    ProductType[ProductType["Free"] = 0] = "Free";
    ProductType[ProductType["Families"] = 1] = "Families";
    ProductType[ProductType["Teams"] = 2] = "Teams";
    ProductType[ProductType["Enterprise"] = 3] = "Enterprise";
    ProductType[ProductType["TeamsStarter"] = 4] = "TeamsStarter";
})(_40_move_organization_state_to_state_provider_ProductType || (_40_move_organization_state_to_state_provider_ProductType = {}));
const USER_ORGANIZATIONS = {
    key: "organizations",
    stateDefinition: {
        name: "organizations",
    },
};
class OrganizationMigrator extends Migrator {
    migrate(helper) {
        return _40_move_organization_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a;
                return _40_move_organization_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.organizations;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_ORGANIZATIONS, value);
                        delete account.data.organizations;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => migrateAccount(userId, account)));
        });
    }
    rollback(helper) {
        return _40_move_organization_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _40_move_organization_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, USER_ORGANIZATIONS);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            organizations: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_ORGANIZATIONS, null);
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => rollbackAccount(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/41-move-event-collection-to-state-provider.ts
var _41_move_event_collection_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const EVENT_COLLECTION = {
    stateDefinition: {
        name: "eventCollection",
    },
    key: "eventCollection",
};
class EventCollectionMigrator extends Migrator {
    migrate(helper) {
        return _41_move_event_collection_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a;
                return _41_move_event_collection_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.eventCollection;
                    if (value != null) {
                        yield helper.setToUser(userId, EVENT_COLLECTION, value);
                        delete account.data.eventCollection;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _41_move_event_collection_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _41_move_event_collection_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, EVENT_COLLECTION);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            eventCollection: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, EVENT_COLLECTION, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/42-move-enable-favicon-to-domain-settings-state-provider.ts
var _42_move_enable_favicon_to_domain_settings_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ShowFaviconDefinition = {
    stateDefinition: {
        name: "domainSettings",
    },
    key: "showFavicons",
};
class EnableFaviconMigrator extends Migrator {
    migrate(helper) {
        return _42_move_enable_favicon_to_domain_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            // global state ("disableFavicon" -> "showFavicons")
            const globalState = yield helper.get("global");
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.disableFavicon) != null) {
                yield helper.setToGlobal(ShowFaviconDefinition, !globalState.disableFavicon);
                // delete `disableFavicon` from state global
                delete globalState.disableFavicon;
                yield helper.set("global", globalState);
            }
        });
    }
    rollback(helper) {
        return _42_move_enable_favicon_to_domain_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            // global state ("showFavicons" -> "disableFavicon")
            const globalState = (yield helper.get("global")) || {};
            const showFavicons = yield helper.getFromGlobal(ShowFaviconDefinition);
            if (showFavicons != null) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { disableFavicon: !showFavicons }));
                // remove the global state provider framework key for `showFavicons`
                yield helper.setToGlobal(ShowFaviconDefinition, null);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/43-move-auto-confirm-finger-prints-to-state-provider.ts
var _43_move_auto_confirm_finger_prints_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ORGANIZATION_MANAGEMENT_PREFERENCES = {
    name: "organizationManagementPreferences",
};
const AUTO_CONFIRM_FINGERPRINTS = {
    key: "autoConfirmFingerPrints",
    stateDefinition: ORGANIZATION_MANAGEMENT_PREFERENCES,
};
class AutoConfirmFingerPrintsMigrator extends Migrator {
    migrate(helper) {
        return _43_move_auto_confirm_finger_prints_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map(({ userId, account }) => _43_move_auto_confirm_finger_prints_to_state_provider_awaiter(this, void 0, void 0, function* () {
                var _a, _b;
                if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.autoConfirmFingerPrints) != null) {
                    yield helper.setToUser(userId, AUTO_CONFIRM_FINGERPRINTS, account.settings.autoConfirmFingerPrints);
                    (_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? true : delete _b.autoConfirmFingerPrints;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _43_move_auto_confirm_finger_prints_to_state_provider_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                return _43_move_auto_confirm_finger_prints_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    const autoConfirmFingerPrints = yield helper.getFromUser(userId, AUTO_CONFIRM_FINGERPRINTS);
                    if (autoConfirmFingerPrints) {
                        if (!account) {
                            account = {};
                        }
                        updatedAccount = true;
                        account.settings.autoConfirmFingerPrints = autoConfirmFingerPrints;
                        yield helper.setToUser(userId, AUTO_CONFIRM_FINGERPRINTS, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/44-move-user-decryption-options-to-state-provider.ts
var _44_move_user_decryption_options_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _44_move_user_decryption_options_to_state_provider_USER_DECRYPTION_OPTIONS = {
    key: "decryptionOptions",
    stateDefinition: {
        name: "userDecryptionOptions",
    },
};
class UserDecryptionOptionsMigrator extends Migrator {
    migrate(helper) {
        return _44_move_user_decryption_options_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _44_move_user_decryption_options_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = account === null || account === void 0 ? void 0 : account.decryptionOptions;
                    if (value != null) {
                        yield helper.setToUser(userId, _44_move_user_decryption_options_to_state_provider_USER_DECRYPTION_OPTIONS, value);
                        delete account.decryptionOptions;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _44_move_user_decryption_options_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _44_move_user_decryption_options_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, _44_move_user_decryption_options_to_state_provider_USER_DECRYPTION_OPTIONS);
                    if (account) {
                        account.decryptionOptions = Object.assign(account.decryptionOptions, value);
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _44_move_user_decryption_options_to_state_provider_USER_DECRYPTION_OPTIONS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/45-merge-environment-state.ts
var _45_merge_environment_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _45_merge_environment_state_ENVIRONMENT_STATE = { name: "environment" };
const ENVIRONMENT_REGION = {
    key: "region",
    stateDefinition: _45_merge_environment_state_ENVIRONMENT_STATE,
};
const ENVIRONMENT_URLS = {
    key: "urls",
    stateDefinition: _45_merge_environment_state_ENVIRONMENT_STATE,
};
const ENVIRONMENT_ENVIRONMENT = {
    key: "environment",
    stateDefinition: _45_merge_environment_state_ENVIRONMENT_STATE,
};
class MergeEnvironmentState extends Migrator {
    migrate(helper) {
        return _45_merge_environment_state_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _45_merge_environment_state_awaiter(this, void 0, void 0, function* () {
                    const region = yield helper.getFromUser(userId, ENVIRONMENT_REGION);
                    const urls = yield helper.getFromUser(userId, ENVIRONMENT_URLS);
                    if (region == null && urls == null) {
                        return;
                    }
                    yield helper.setToUser(userId, ENVIRONMENT_ENVIRONMENT, {
                        region,
                        urls,
                    });
                    yield helper.removeFromUser(userId, ENVIRONMENT_REGION);
                    yield helper.removeFromUser(userId, ENVIRONMENT_URLS);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            const region = yield helper.getFromGlobal(ENVIRONMENT_REGION);
            const urls = yield helper.getFromGlobal(ENVIRONMENT_URLS);
            if (region == null && urls == null) {
                return;
            }
            yield helper.setToGlobal(ENVIRONMENT_ENVIRONMENT, {
                region,
                urls,
            });
            yield helper.removeFromGlobal(ENVIRONMENT_REGION);
            yield helper.removeFromGlobal(ENVIRONMENT_URLS);
        });
    }
    rollback(helper) {
        return _45_merge_environment_state_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _45_merge_environment_state_awaiter(this, void 0, void 0, function* () {
                    const state = (yield helper.getFromUser(userId, ENVIRONMENT_ENVIRONMENT));
                    yield helper.setToUser(userId, ENVIRONMENT_REGION, state === null || state === void 0 ? void 0 : state.region);
                    yield helper.setToUser(userId, ENVIRONMENT_URLS, state === null || state === void 0 ? void 0 : state.urls);
                    yield helper.removeFromUser(userId, ENVIRONMENT_ENVIRONMENT);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            const state = (yield helper.getFromGlobal(ENVIRONMENT_ENVIRONMENT));
            yield helper.setToGlobal(ENVIRONMENT_REGION, state === null || state === void 0 ? void 0 : state.region);
            yield helper.setToGlobal(ENVIRONMENT_URLS, state === null || state === void 0 ? void 0 : state.urls);
            yield helper.removeFromGlobal(ENVIRONMENT_ENVIRONMENT);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/46-delete-orphaned-biometric-prompt-data.ts
var _46_delete_orphaned_biometric_prompt_data_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _46_delete_orphaned_biometric_prompt_data_PROMPT_CANCELLED = {
    key: "promptCancelled",
    stateDefinition: { name: "biometricSettings" },
};
class DeleteBiometricPromptCancelledData extends Migrator {
    migrate(helper) {
        return _46_delete_orphaned_biometric_prompt_data_awaiter(this, void 0, void 0, function* () {
            yield Promise.all((yield helper.getAccounts()).map(({ userId }) => _46_delete_orphaned_biometric_prompt_data_awaiter(this, void 0, void 0, function* () {
                if (helper.getFromUser(userId, _46_delete_orphaned_biometric_prompt_data_PROMPT_CANCELLED) != null) {
                    yield helper.removeFromUser(userId, _46_delete_orphaned_biometric_prompt_data_PROMPT_CANCELLED);
                }
            })));
        });
    }
    rollback(helper) {
        return _46_delete_orphaned_biometric_prompt_data_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/47-move-desktop-settings.ts
var _47_move_desktop_settings_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const DESKTOP_SETTINGS_STATE = { name: "desktopSettings" };
const WINDOW_KEY = { key: "window", stateDefinition: DESKTOP_SETTINGS_STATE };
const CLOSE_TO_TRAY_KEY = {
    key: "closeToTray",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const MINIMIZE_TO_TRAY_KEY = {
    key: "minimizeToTray",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const START_TO_TRAY_KEY = {
    key: "startToTray",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const TRAY_ENABLED_KEY = {
    key: "trayEnabled",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const OPEN_AT_LOGIN_KEY = {
    key: "openAtLogin",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const ALWAYS_SHOW_DOCK_KEY = {
    key: "alwaysShowDock",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const ALWAYS_ON_TOP_KEY = {
    key: "alwaysOnTop",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
class MoveDesktopSettingsMigrator extends Migrator {
    migrate(helper) {
        return _47_move_desktop_settings_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            let updatedGlobal = false;
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.window) !== undefined) {
                yield helper.setToGlobal(WINDOW_KEY, legacyGlobal.window);
                updatedGlobal = true;
                delete legacyGlobal.window;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableCloseToTray) != null) {
                yield helper.setToGlobal(CLOSE_TO_TRAY_KEY, legacyGlobal.enableCloseToTray);
                updatedGlobal = true;
                delete legacyGlobal.enableCloseToTray;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableMinimizeToTray) != null) {
                yield helper.setToGlobal(MINIMIZE_TO_TRAY_KEY, legacyGlobal.enableMinimizeToTray);
                updatedGlobal = true;
                delete legacyGlobal.enableMinimizeToTray;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableStartToTray) != null) {
                yield helper.setToGlobal(START_TO_TRAY_KEY, legacyGlobal.enableStartToTray);
                updatedGlobal = true;
                delete legacyGlobal.enableStartToTray;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableTray) != null) {
                yield helper.setToGlobal(TRAY_ENABLED_KEY, legacyGlobal.enableTray);
                updatedGlobal = true;
                delete legacyGlobal.enableTray;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.openAtLogin) != null) {
                yield helper.setToGlobal(OPEN_AT_LOGIN_KEY, legacyGlobal.openAtLogin);
                updatedGlobal = true;
                delete legacyGlobal.openAtLogin;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.alwaysShowDock) != null) {
                yield helper.setToGlobal(ALWAYS_SHOW_DOCK_KEY, legacyGlobal.alwaysShowDock);
                updatedGlobal = true;
                delete legacyGlobal.alwaysShowDock;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableAlwaysOnTop) != null) {
                yield helper.setToGlobal(ALWAYS_ON_TOP_KEY, legacyGlobal.enableAlwaysOnTop);
                updatedGlobal = true;
                delete legacyGlobal.enableAlwaysOnTop;
            }
            if (updatedGlobal) {
                yield helper.set("global", legacyGlobal);
            }
            function migrateAccount(userId, account) {
                var _a;
                return _47_move_desktop_settings_awaiter(this, void 0, void 0, function* () {
                    // We only migrate the global setting for this, if we find it on the account object
                    // just delete it.
                    if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.enableAlwaysOnTop) != null) {
                        delete account.settings.enableAlwaysOnTop;
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => migrateAccount(userId, account)));
        });
    }
    rollback(helper) {
        throw IRREVERSIBLE;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/48-move-ddg-to-state-provider.ts
var _48_move_ddg_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const DDG_KEY = {
    key: "enableDuckDuckGoBrowserIntegration",
    stateDefinition: {
        name: "autofillSettings",
    },
};
class MoveDdgToStateProviderMigrator extends Migrator {
    migrate(helper) {
        return _48_move_ddg_to_state_provider_awaiter(this, void 0, void 0, function* () {
            // global state
            const global = yield helper.get("global");
            if ((global === null || global === void 0 ? void 0 : global.enableDuckDuckGoBrowserIntegration) == null) {
                return;
            }
            yield helper.setToGlobal(DDG_KEY, global.enableDuckDuckGoBrowserIntegration);
            delete global.enableDuckDuckGoBrowserIntegration;
            yield helper.set("global", global);
        });
    }
    rollback(helper) {
        var _a;
        return _48_move_ddg_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const enableDdg = yield helper.getFromGlobal(DDG_KEY);
            if (!enableDdg) {
                return;
            }
            const global = (_a = (yield helper.get("global"))) !== null && _a !== void 0 ? _a : {};
            global.enableDuckDuckGoBrowserIntegration = enableDdg;
            yield helper.set("global", global);
            yield helper.removeFromGlobal(DDG_KEY);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/49-move-account-server-configs.ts
var _49_move_account_server_configs_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _49_move_account_server_configs_CONFIG_DISK = { name: "config" };
const _49_move_account_server_configs_USER_SERVER_CONFIG = {
    stateDefinition: _49_move_account_server_configs_CONFIG_DISK,
    key: "serverConfig",
};
class AccountServerConfigMigrator extends Migrator {
    migrate(helper) {
        return _49_move_account_server_configs_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a;
                return _49_move_account_server_configs_awaiter(this, void 0, void 0, function* () {
                    if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.serverConfig) != null) {
                        yield helper.setToUser(userId, _49_move_account_server_configs_USER_SERVER_CONFIG, account.settings.serverConfig);
                        delete account.settings.serverConfig;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _49_move_account_server_configs_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _49_move_account_server_configs_awaiter(this, void 0, void 0, function* () {
                    const serverConfig = yield helper.getFromUser(userId, _49_move_account_server_configs_USER_SERVER_CONFIG);
                    if (serverConfig) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        account.settings.serverConfig = serverConfig;
                        yield helper.setToUser(userId, _49_move_account_server_configs_USER_SERVER_CONFIG, null);
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/5-add-key-type-to-org-keys.ts
var _5_add_key_type_to_org_keys_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class AddKeyTypeToOrgKeysMigrator extends Migrator {
    migrate(helper) {
        return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function updateOrgKey(userId, account) {
                var _a, _b;
                return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
                    const encryptedOrgKeys = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (encryptedOrgKeys == null) {
                        return;
                    }
                    const newOrgKeys = {};
                    Object.entries(encryptedOrgKeys).forEach(([orgId, encKey]) => {
                        newOrgKeys[orgId] = {
                            type: "organization",
                            key: encKey,
                        };
                    });
                    account.keys.organizationKeys.encrypted = newOrgKeys;
                    yield helper.set(userId, account);
                });
            }
            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            Promise.all(accounts.map(({ userId, account }) => updateOrgKey(userId, account)));
        });
    }
    rollback(helper) {
        return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function updateOrgKey(userId, account) {
                var _a, _b;
                return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
                    const encryptedOrgKeys = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (encryptedOrgKeys == null) {
                        return;
                    }
                    const newOrgKeys = {};
                    Object.entries(encryptedOrgKeys).forEach(([orgId, encKey]) => {
                        newOrgKeys[orgId] = encKey.key;
                    });
                    account.keys.organizationKeys.encrypted = newOrgKeys;
                    yield helper.set(userId, account);
                });
            }
            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            Promise.all(accounts.map(({ userId, account }) => _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () { return updateOrgKey(userId, account); })));
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/50-move-key-connector-to-state-provider.ts
var _50_move_key_connector_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const usesKeyConnectorKeyDefinition = {
    key: "usesKeyConnector",
    stateDefinition: {
        name: "keyConnector",
    },
};
const convertAccountToKeyConnectorKeyDefinition = {
    key: "convertAccountToKeyConnector",
    stateDefinition: {
        name: "keyConnector",
    },
};
class KeyConnectorMigrator extends Migrator {
    migrate(helper) {
        return _50_move_key_connector_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _50_move_key_connector_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const usesKeyConnector = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.usesKeyConnector;
                    const convertAccountToKeyConnector = (_b = account === null || account === void 0 ? void 0 : account.profile) === null || _b === void 0 ? void 0 : _b.convertAccountToKeyConnector;
                    if (usesKeyConnector == null && convertAccountToKeyConnector == null) {
                        return;
                    }
                    if (usesKeyConnector != null) {
                        yield helper.setToUser(userId, usesKeyConnectorKeyDefinition, usesKeyConnector);
                        delete account.profile.usesKeyConnector;
                    }
                    if (convertAccountToKeyConnector != null) {
                        yield helper.setToUser(userId, convertAccountToKeyConnectorKeyDefinition, convertAccountToKeyConnector);
                        delete account.profile.convertAccountToKeyConnector;
                    }
                    yield helper.set(userId, account);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _50_move_key_connector_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _50_move_key_connector_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const usesKeyConnector = yield helper.getFromUser(userId, usesKeyConnectorKeyDefinition);
                    const convertAccountToKeyConnector = yield helper.getFromUser(userId, convertAccountToKeyConnectorKeyDefinition);
                    if (usesKeyConnector == null && convertAccountToKeyConnector == null) {
                        return;
                    }
                    if (usesKeyConnector != null) {
                        account.profile.usesKeyConnector = usesKeyConnector;
                        yield helper.setToUser(userId, usesKeyConnectorKeyDefinition, null);
                    }
                    if (convertAccountToKeyConnector != null) {
                        account.profile.convertAccountToKeyConnector = convertAccountToKeyConnector;
                        yield helper.setToUser(userId, convertAccountToKeyConnectorKeyDefinition, null);
                    }
                    yield helper.set(userId, account);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/51-move-remembered-email-to-state-providers.ts
var _51_move_remembered_email_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const LOGIN_EMAIL_STATE = { name: "loginEmail" };
const _51_move_remembered_email_to_state_providers_STORED_EMAIL = {
    key: "storedEmail",
    stateDefinition: LOGIN_EMAIL_STATE,
};
class RememberedEmailMigrator extends Migrator {
    migrate(helper) {
        return _51_move_remembered_email_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            // Move global data
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.rememberedEmail) != null) {
                yield helper.setToGlobal(_51_move_remembered_email_to_state_providers_STORED_EMAIL, legacyGlobal.rememberedEmail);
            }
            // Delete legacy global data
            legacyGlobal === null || legacyGlobal === void 0 ? true : delete legacyGlobal.rememberedEmail;
            yield helper.set("global", legacyGlobal);
        });
    }
    rollback(helper) {
        return _51_move_remembered_email_to_state_providers_awaiter(this, void 0, void 0, function* () {
            let legacyGlobal = yield helper.get("global");
            let updatedLegacyGlobal = false;
            const globalStoredEmail = yield helper.getFromGlobal(_51_move_remembered_email_to_state_providers_STORED_EMAIL);
            if (globalStoredEmail) {
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                updatedLegacyGlobal = true;
                legacyGlobal.rememberedEmail = globalStoredEmail;
                yield helper.setToGlobal(_51_move_remembered_email_to_state_providers_STORED_EMAIL, null);
            }
            if (updatedLegacyGlobal) {
                yield helper.set("global", legacyGlobal);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/52-delete-installed-version.ts
var _52_delete_installed_version_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class DeleteInstalledVersion extends Migrator {
    migrate(helper) {
        return _52_delete_installed_version_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.installedVersion) != null) {
                delete legacyGlobal.installedVersion;
                yield helper.set("global", legacyGlobal);
            }
        });
    }
    rollback(helper) {
        throw IRREVERSIBLE;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/53-migrate-device-trust-crypto-svc-to-state-providers.ts
var _53_migrate_device_trust_crypto_svc_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _53_migrate_device_trust_crypto_svc_to_state_providers_DEVICE_KEY = {
    key: "deviceKey",
    stateDefinition: {
        name: "deviceTrust", // matches StateDefinition.name in StateDefinitions
    },
};
const _53_migrate_device_trust_crypto_svc_to_state_providers_SHOULD_TRUST_DEVICE = {
    key: "shouldTrustDevice",
    stateDefinition: {
        name: "deviceTrust",
    },
};
class DeviceTrustCryptoServiceStateProviderMigrator extends Migrator {
    migrate(helper) {
        return _53_migrate_device_trust_crypto_svc_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _53_migrate_device_trust_crypto_svc_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    // Migrate deviceKey
                    const existingDeviceKey = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.deviceKey;
                    if (existingDeviceKey != null) {
                        // Only migrate data that exists
                        yield helper.setToUser(userId, _53_migrate_device_trust_crypto_svc_to_state_providers_DEVICE_KEY, existingDeviceKey);
                        delete account.keys.deviceKey;
                        updatedAccount = true;
                    }
                    // Migrate shouldTrustDevice
                    const existingShouldTrustDevice = (_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.trustDeviceChoiceForDecryption;
                    if (existingShouldTrustDevice != null) {
                        yield helper.setToUser(userId, _53_migrate_device_trust_crypto_svc_to_state_providers_SHOULD_TRUST_DEVICE, existingShouldTrustDevice);
                        delete account.settings.trustDeviceChoiceForDecryption;
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        // Save the migrated account
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _53_migrate_device_trust_crypto_svc_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _53_migrate_device_trust_crypto_svc_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    // Rollback deviceKey
                    const migratedDeviceKey = yield helper.getFromUser(userId, _53_migrate_device_trust_crypto_svc_to_state_providers_DEVICE_KEY);
                    if ((account === null || account === void 0 ? void 0 : account.keys) && migratedDeviceKey != null) {
                        account.keys.deviceKey = migratedDeviceKey;
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _53_migrate_device_trust_crypto_svc_to_state_providers_DEVICE_KEY, null);
                    // Rollback shouldTrustDevice
                    const migratedShouldTrustDevice = yield helper.getFromUser(userId, _53_migrate_device_trust_crypto_svc_to_state_providers_SHOULD_TRUST_DEVICE);
                    if ((account === null || account === void 0 ? void 0 : account.settings) && migratedShouldTrustDevice != null) {
                        account.settings.trustDeviceChoiceForDecryption = migratedShouldTrustDevice;
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _53_migrate_device_trust_crypto_svc_to_state_providers_SHOULD_TRUST_DEVICE, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/54-move-encrypted-sends.ts
var _54_move_encrypted_sends_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

var SendType;
(function (SendType) {
    SendType[SendType["Text"] = 0] = "Text";
    SendType[SendType["File"] = 1] = "File";
})(SendType || (SendType = {}));
const ENCRYPTED_SENDS = {
    stateDefinition: {
        name: "send",
    },
    key: "sends",
};
/**
 * Only encrypted sends are stored on disk. Only the encrypted items need to be
 * migrated from the previous sends state data.
 */
class SendMigrator extends Migrator {
    migrate(helper) {
        return _54_move_encrypted_sends_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _54_move_encrypted_sends_awaiter(this, void 0, void 0, function* () {
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.sends) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, ENCRYPTED_SENDS, value);
                        delete account.data.sends;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _54_move_encrypted_sends_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _54_move_encrypted_sends_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, ENCRYPTED_SENDS);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            sends: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, ENCRYPTED_SENDS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/55-move-master-key-state-to-provider.ts
var _55_move_master_key_state_to_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const FORCE_SET_PASSWORD_REASON_DEFINITION = {
    key: "forceSetPasswordReason",
    stateDefinition: {
        name: "masterPassword",
    },
};
const MASTER_KEY_HASH_DEFINITION = {
    key: "masterKeyHash",
    stateDefinition: {
        name: "masterPassword",
    },
};
const MASTER_KEY_ENCRYPTED_USER_KEY_DEFINITION = {
    key: "masterKeyEncryptedUserKey",
    stateDefinition: {
        name: "masterPassword",
    },
};
class MoveMasterKeyStateToProviderMigrator extends Migrator {
    migrate(helper) {
        return _55_move_master_key_state_to_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b, _c;
                return _55_move_master_key_state_to_provider_awaiter(this, void 0, void 0, function* () {
                    const forceSetPasswordReason = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.forceSetPasswordReason;
                    if (forceSetPasswordReason != null) {
                        yield helper.setToUser(userId, FORCE_SET_PASSWORD_REASON_DEFINITION, forceSetPasswordReason);
                        delete account.profile.forceSetPasswordReason;
                        yield helper.set(userId, account);
                    }
                    const masterKeyHash = (_b = account === null || account === void 0 ? void 0 : account.profile) === null || _b === void 0 ? void 0 : _b.keyHash;
                    if (masterKeyHash != null) {
                        yield helper.setToUser(userId, MASTER_KEY_HASH_DEFINITION, masterKeyHash);
                        delete account.profile.keyHash;
                        yield helper.set(userId, account);
                    }
                    const masterKeyEncryptedUserKey = (_c = account === null || account === void 0 ? void 0 : account.keys) === null || _c === void 0 ? void 0 : _c.masterKeyEncryptedUserKey;
                    if (masterKeyEncryptedUserKey != null) {
                        yield helper.setToUser(userId, MASTER_KEY_ENCRYPTED_USER_KEY_DEFINITION, masterKeyEncryptedUserKey);
                        delete account.keys.masterKeyEncryptedUserKey;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _55_move_master_key_state_to_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a, _b, _c;
                return _55_move_master_key_state_to_provider_awaiter(this, void 0, void 0, function* () {
                    const forceSetPasswordReason = yield helper.getFromUser(userId, FORCE_SET_PASSWORD_REASON_DEFINITION);
                    const masterKeyHash = yield helper.getFromUser(userId, MASTER_KEY_HASH_DEFINITION);
                    const masterKeyEncryptedUserKey = yield helper.getFromUser(userId, MASTER_KEY_ENCRYPTED_USER_KEY_DEFINITION);
                    if (account != null) {
                        if (forceSetPasswordReason != null) {
                            account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                                forceSetPasswordReason,
                            });
                        }
                        if (masterKeyHash != null) {
                            account.profile = Object.assign((_b = account.profile) !== null && _b !== void 0 ? _b : {}, {
                                keyHash: masterKeyHash,
                            });
                        }
                        if (masterKeyEncryptedUserKey != null) {
                            account.keys = Object.assign((_c = account.keys) !== null && _c !== void 0 ? _c : {}, {
                                masterKeyEncryptedUserKey,
                            });
                        }
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, FORCE_SET_PASSWORD_REASON_DEFINITION, null);
                    yield helper.setToUser(userId, MASTER_KEY_HASH_DEFINITION, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/56-move-auth-requests.ts
var _56_move_auth_requests_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _56_move_auth_requests_ADMIN_AUTH_REQUEST_KEY = {
    stateDefinition: {
        name: "authRequestLocal",
    },
    key: "adminAuthRequest",
};
const _56_move_auth_requests_ACCEPT_AUTH_REQUESTS_KEY = {
    stateDefinition: {
        name: "authRequestLocal",
    },
    key: "acceptAuthRequests",
};
class AuthRequestMigrator extends Migrator {
    migrate(helper) {
        return _56_move_auth_requests_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a;
                return _56_move_auth_requests_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    // Migrate admin auth request
                    const existingAdminAuthRequest = account === null || account === void 0 ? void 0 : account.adminAuthRequest;
                    if (existingAdminAuthRequest != null) {
                        yield helper.setToUser(userId, _56_move_auth_requests_ADMIN_AUTH_REQUEST_KEY, existingAdminAuthRequest);
                        delete account.adminAuthRequest;
                        updatedAccount = true;
                    }
                    // Migrate approve login requests
                    const existingApproveLoginRequests = (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.approveLoginRequests;
                    if (existingApproveLoginRequests != null) {
                        yield helper.setToUser(userId, _56_move_auth_requests_ACCEPT_AUTH_REQUESTS_KEY, existingApproveLoginRequests);
                        delete account.settings.approveLoginRequests;
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        // Save the migrated account
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _56_move_auth_requests_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _56_move_auth_requests_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    // Rollback admin auth request
                    const migratedAdminAuthRequest = yield helper.getFromUser(userId, _56_move_auth_requests_ADMIN_AUTH_REQUEST_KEY);
                    if (migratedAdminAuthRequest != null) {
                        account.adminAuthRequest = migratedAdminAuthRequest;
                        updatedAccount = true;
                    }
                    yield helper.setToUser(userId, _56_move_auth_requests_ADMIN_AUTH_REQUEST_KEY, null);
                    // Rollback approve login requests
                    const migratedAcceptAuthRequest = yield helper.getFromUser(userId, _56_move_auth_requests_ACCEPT_AUTH_REQUESTS_KEY);
                    if (migratedAcceptAuthRequest != null) {
                        account.settings = Object.assign((_a = account.settings) !== null && _a !== void 0 ? _a : {}, {
                            approveLoginRequests: migratedAcceptAuthRequest,
                        });
                        updatedAccount = true;
                    }
                    yield helper.setToUser(userId, _56_move_auth_requests_ACCEPT_AUTH_REQUESTS_KEY, null);
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/57-move-cipher-service-to-state-provider.ts
var _57_move_cipher_service_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _57_move_cipher_service_to_state_provider_CIPHERS_DISK_LOCAL = {
    key: "localData",
    stateDefinition: {
        name: "ciphersLocal",
    },
};
const _57_move_cipher_service_to_state_provider_CIPHERS_DISK = {
    key: "ciphers",
    stateDefinition: {
        name: "ciphers",
    },
};
class CipherServiceMigrator extends Migrator {
    migrate(helper) {
        return _57_move_cipher_service_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b, _c;
                return _57_move_cipher_service_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    //Migrate localData
                    const localData = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.localData;
                    if (localData != null) {
                        yield helper.setToUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK_LOCAL, localData);
                        delete account.data.localData;
                        updatedAccount = true;
                    }
                    //Migrate ciphers
                    const ciphers = (_c = (_b = account === null || account === void 0 ? void 0 : account.data) === null || _b === void 0 ? void 0 : _b.ciphers) === null || _c === void 0 ? void 0 : _c.encrypted;
                    if (ciphers != null) {
                        yield helper.setToUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK, ciphers);
                        delete account.data.ciphers;
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _57_move_cipher_service_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _57_move_cipher_service_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    //rollback localData
                    const localData = yield helper.getFromUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK_LOCAL);
                    if (account.data && localData != null) {
                        account.data.localData = localData;
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK_LOCAL, null);
                    //rollback ciphers
                    const ciphers = yield helper.getFromUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK);
                    if (account.data && ciphers != null) {
                        (_a = account.data).ciphers || (_a.ciphers = { encrypted: null });
                        account.data.ciphers.encrypted = ciphers;
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/58-remove-refresh-token-migrated-state-provider-flag.ts
var _58_remove_refresh_token_migrated_state_provider_flag_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const REFRESH_TOKEN_MIGRATED_TO_SECURE_STORAGE = {
    key: "refreshTokenMigratedToSecureStorage",
    stateDefinition: {
        name: "token", // matches StateDefinition.name in StateDefinitions
    },
};
class RemoveRefreshTokenMigratedFlagMigrator extends Migrator {
    migrate(helper) {
        return _58_remove_refresh_token_migrated_state_provider_flag_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _58_remove_refresh_token_migrated_state_provider_flag_awaiter(this, void 0, void 0, function* () {
                    const refreshTokenMigratedFlag = yield helper.getFromUser(userId, REFRESH_TOKEN_MIGRATED_TO_SECURE_STORAGE);
                    if (refreshTokenMigratedFlag != null) {
                        // Only delete the flag if it exists
                        yield helper.removeFromUser(userId, REFRESH_TOKEN_MIGRATED_TO_SECURE_STORAGE);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _58_remove_refresh_token_migrated_state_provider_flag_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/6-remove-legacy-etm-key.ts
var _6_remove_legacy_etm_key_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class RemoveLegacyEtmKeyMigrator extends Migrator {
    migrate(helper) {
        return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function updateAccount(userId, account) {
                var _a;
                return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
                    if ((_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.legacyEtmKey) {
                        delete account.keys.legacyEtmKey;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => updateAccount(userId, account)));
        });
    }
    rollback(helper) {
        return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/7-move-biometric-auto-prompt-to-account.ts
var _7_move_biometric_auto_prompt_to_account_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MoveBiometricAutoPromptToAccount extends Migrator {
    migrate(helper) {
        var _a;
        return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            const noAutoPromptBiometrics = (_a = global === null || global === void 0 ? void 0 : global.noAutoPromptBiometrics) !== null && _a !== void 0 ? _a : false;
            const accounts = yield helper.getAccounts();
            function updateAccount(userId, account) {
                var _a;
                return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
                    if (account == null) {
                        return;
                    }
                    if (noAutoPromptBiometrics) {
                        account.settings = Object.assign((_a = account === null || account === void 0 ? void 0 : account.settings) !== null && _a !== void 0 ? _a : {}, {
                            disableAutoBiometricsPrompt: true,
                        });
                        yield helper.set(userId, account);
                    }
                });
            }
            delete global.noAutoPromptBiometrics;
            yield Promise.all([
                ...accounts.map(({ userId, account }) => updateAccount(userId, account)),
                helper.set("global", global),
            ]);
        });
    }
    rollback(helper) {
        return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/8-move-state-version.ts
var _8_move_state_version_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MoveStateVersionMigrator extends Migrator {
    migrate(helper) {
        return _8_move_state_version_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            if (global.stateVersion) {
                yield helper.set("stateVersion", global.stateVersion);
                delete global.stateVersion;
                yield helper.set("global", global);
            }
            else {
                throw new Error("Migration failed, state version not found");
            }
        });
    }
    rollback(helper) {
        return _8_move_state_version_awaiter(this, void 0, void 0, function* () {
            const version = yield helper.get("stateVersion");
            const global = yield helper.get("global");
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: version }));
            yield helper.set("stateVersion", undefined);
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but this migration moves
    // it from a `global` object to root.This makes for unique rollback versioning.
    updateVersion(helper, direction) {
        return _8_move_state_version_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            if (direction === "up") {
                yield helper.set("stateVersion", endVersion);
            }
            else {
                const global = (yield helper.get("global")) || {};
                yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/9-move-browser-settings-to-global.ts
var _9_move_browser_settings_to_global_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MoveBrowserSettingsToGlobal extends Migrator {
    // Will first check if any of the accounts have a value from the given accountSelector
    // if they do have a value it will set that value into global state but if multiple
    // users have differing values it will prefer the false setting,
    // if all users have true then it will take true.
    tryAddSetting(accounts, accountSelector, globalSetter) {
        const hasValue = accounts.some(({ account }) => {
            return accountSelector(account) !== undefined;
        });
        if (hasValue) {
            const value = !accounts.some(({ account }) => {
                var _a;
                return ((_a = accountSelector(account)) !== null && _a !== void 0 ? _a : false) === false;
            });
            globalSetter(value);
        }
    }
    migrate(helper) {
        return _9_move_browser_settings_to_global_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            const accounts = yield helper.getAccounts();
            const globalNeverDomainsValue = accounts.reduce((accumulator, { account }) => {
                var _a, _b;
                const normalizedNeverDomains = (_b = (_a = account.settings) === null || _a === void 0 ? void 0 : _a.neverDomains) !== null && _b !== void 0 ? _b : {};
                for (const [id, value] of Object.entries(normalizedNeverDomains)) {
                    accumulator !== null && accumulator !== void 0 ? accumulator : (accumulator = {});
                    accumulator[id] = value;
                }
                return accumulator;
            }, undefined);
            const targetGlobalState = {};
            if (globalNeverDomainsValue != null) {
                targetGlobalState.neverDomains = globalNeverDomainsValue;
            }
            this.tryAddSetting(accounts, (a) => { var _a; return (_a = a.settings) === null || _a === void 0 ? void 0 : _a.disableAddLoginNotification; }, (v) => (targetGlobalState.disableAddLoginNotification = v));
            this.tryAddSetting(accounts, (a) => { var _a; return (_a = a.settings) === null || _a === void 0 ? void 0 : _a.disableChangedPasswordNotification; }, (v) => (targetGlobalState.disableChangedPasswordNotification = v));
            this.tryAddSetting(accounts, (a) => { var _a; return (_a = a.settings) === null || _a === void 0 ? void 0 : _a.disableContextMenuItem; }, (v) => (targetGlobalState.disableContextMenuItem = v));
            yield helper.set("global", Object.assign(Object.assign({}, global), targetGlobalState));
            yield Promise.all(accounts.map(({ userId, account }) => _9_move_browser_settings_to_global_awaiter(this, void 0, void 0, function* () {
                var _a, _b, _c, _d;
                (_a = account.settings) === null || _a === void 0 ? true : delete _a.disableAddLoginNotification;
                (_b = account.settings) === null || _b === void 0 ? true : delete _b.disableChangedPasswordNotification;
                (_c = account.settings) === null || _c === void 0 ? true : delete _c.disableContextMenuItem;
                (_d = account.settings) === null || _d === void 0 ? true : delete _d.neverDomains;
                yield helper.set(userId, account);
            })));
        });
    }
    rollback(helper) {
        throw new Error("Method not implemented.");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/min-version.ts
var min_version_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function minVersionError(current) {
    return `Your local data is too old to be migrated. Your current state version is ${current}, but minimum version is ${MIN_VERSION}.`;
}
class MinVersionMigrator extends Migrator {
    constructor() {
        super(0, MIN_VERSION);
    }
    // Overrides the default implementation to catch any version that may be passed in.
    shouldMigrate(helper) {
        return Promise.resolve(helper.currentVersion < MIN_VERSION);
    }
    migrate(helper) {
        return min_version_awaiter(this, void 0, void 0, function* () {
            if (helper.currentVersion < MIN_VERSION) {
                throw new Error(minVersionError(helper.currentVersion));
            }
        });
    }
    rollback(helper) {
        return min_version_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrate.ts
var migrate_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

























































const MIN_VERSION = 3;
const CURRENT_VERSION = 58;
function createMigrationBuilder() {
    return MigrationBuilder.create()
        .with(MinVersionMigrator)
        .with(RemoveEverBeenUnlockedMigrator, 3, 4)
        .with(AddKeyTypeToOrgKeysMigrator, 4, 5)
        .with(RemoveLegacyEtmKeyMigrator, 5, 6)
        .with(MoveBiometricAutoPromptToAccount, 6, 7)
        .with(MoveStateVersionMigrator, 7, 8)
        .with(MoveBrowserSettingsToGlobal, 8, 9)
        .with(EverHadUserKeyMigrator, 9, 10)
        .with(OrganizationKeyMigrator, 10, 11)
        .with(MoveEnvironmentStateToProviders, 11, 12)
        .with(ProviderKeyMigrator, 12, 13)
        .with(MoveBiometricClientKeyHalfToStateProviders, 13, 14)
        .with(FolderMigrator, 14, 15)
        .with(LastSyncMigrator, 15, 16)
        .with(EnablePasskeysMigrator, 16, 17)
        .with(AutofillSettingsKeyMigrator, 17, 18)
        .with(RequirePasswordOnStartMigrator, 18, 19)
        .with(PrivateKeyMigrator, 19, 20)
        .with(CollectionMigrator, 20, 21)
        .with(CollapsedGroupingsMigrator, 21, 22)
        .with(MoveBiometricPromptsToStateProviders, 22, 23)
        .with(SmOnboardingTasksMigrator, 23, 24)
        .with(ClearClipboardDelayMigrator, 24, 25)
        .with(RevertLastSyncMigrator, 25, 26)
        .with(BadgeSettingsMigrator, 26, 27)
        .with(MoveBiometricUnlockToStateProviders, 27, 28)
        .with(UserNotificationSettingsKeyMigrator, 28, 29)
        .with(PolicyMigrator, 29, 30)
        .with(EnableContextMenuMigrator, 30, 31)
        .with(PreferredLanguageMigrator, 31, 32)
        .with(AppIdMigrator, 32, 33)
        .with(DomainSettingsMigrator, 33, 34)
        .with(MoveThemeToStateProviderMigrator, 34, 35)
        .with(VaultSettingsKeyMigrator, 35, 36)
        .with(AvatarColorMigrator, 36, 37)
        .with(TokenServiceStateProviderMigrator, 37, 38)
        .with(MoveBillingAccountProfileMigrator, 38, 39)
        .with(OrganizationMigrator, 39, 40)
        .with(EventCollectionMigrator, 40, 41)
        .with(EnableFaviconMigrator, 41, 42)
        .with(AutoConfirmFingerPrintsMigrator, 42, 43)
        .with(UserDecryptionOptionsMigrator, 43, 44)
        .with(MergeEnvironmentState, 44, 45)
        .with(DeleteBiometricPromptCancelledData, 45, 46)
        .with(MoveDesktopSettingsMigrator, 46, 47)
        .with(MoveDdgToStateProviderMigrator, 47, 48)
        .with(AccountServerConfigMigrator, 48, 49)
        .with(KeyConnectorMigrator, 49, 50)
        .with(RememberedEmailMigrator, 50, 51)
        .with(DeleteInstalledVersion, 51, 52)
        .with(DeviceTrustCryptoServiceStateProviderMigrator, 52, 53)
        .with(SendMigrator, 53, 54)
        .with(MoveMasterKeyStateToProviderMigrator, 54, 55)
        .with(AuthRequestMigrator, 55, 56)
        .with(CipherServiceMigrator, 56, 57)
        .with(RemoveRefreshTokenMigratedFlagMigrator, 57, CURRENT_VERSION);
}
function currentVersion(storageService, logService) {
    var _a;
    return migrate_awaiter(this, void 0, void 0, function* () {
        let state = yield storageService.get("stateVersion");
        if (state == null) {
            // Pre v8
            state = (_a = (yield storageService.get("global"))) === null || _a === void 0 ? void 0 : _a.stateVersion;
        }
        if (state == null) {
            logService.info("No state version found, assuming empty state.");
            return -1;
        }
        logService.info(`State version: ${state}`);
        return state;
    });
}
/**
 * Waits for migrations to have a chance to run and will resolve the promise once they are.
 *
 * @param storageService Disk storage where the `stateVersion` will or is already saved in.
 * @param logService Log service
 */
function waitForMigrations(storageService, logService) {
    return migrate_awaiter(this, void 0, void 0, function* () {
        const isReady = () => migrate_awaiter(this, void 0, void 0, function* () {
            const version = yield currentVersion(storageService, logService);
            // The saved version is what we consider the latest
            // migrations should be complete, the state version
            // shouldn't become larger than `CURRENT_VERSION` in
            // any normal usage of the application but it is common
            // enough in dev scenarios where we want to consider that
            // ready as well and return true in that scenario.
            return version >= CURRENT_VERSION;
        });
        const wait = (time) => migrate_awaiter(this, void 0, void 0, function* () {
            // Wait exponentially
            const nextTime = time * 2;
            if (nextTime > 8192) {
                // Don't wait longer than ~8 seconds in a single wait,
                // if the migrations still haven't happened. They aren't
                // likely to.
                return;
            }
            return new Promise((resolve) => {
                setTimeout(() => migrate_awaiter(this, void 0, void 0, function* () {
                    if (!(yield isReady())) {
                        logService.info(`Waiting for migrations to finish, waiting for ${nextTime}ms`);
                        yield wait(nextTime);
                    }
                    resolve();
                }), time);
            });
        });
        if (!(yield isReady())) {
            // Wait for 2ms to start with
            yield wait(2);
        }
    });
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/index.ts


;// CONCATENATED MODULE: ../../libs/common/src/platform/services/migration-builder.service.ts

class MigrationBuilderService {
    build() {
        var _a;
        return ((_a = this.migrationBuilderCache) !== null && _a !== void 0 ? _a : (this.migrationBuilderCache = createMigrationBuilder()));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migration-helper.ts
var migration_helper_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class MigrationHelper {
    constructor(currentVersion, storageService, logService, type) {
        this.currentVersion = currentVersion;
        this.storageService = storageService;
        this.logService = logService;
        this.type = type;
    }
    /**
     * Gets a value from the storage service at the given key.
     *
     * This is a brute force method to just get a value from the storage service. If you can use {@link getFromGlobal} or {@link getFromUser}, you should.
     * @param key location
     * @returns the value at the location
     */
    get(key) {
        return this.storageService.get(key);
    }
    /**
     * Sets a value in the storage service at the given key.
     *
     * This is a brute force method to just set a value in the storage service. If you can use {@link setToGlobal} or {@link setToUser}, you should.
     * @param key location
     * @param value the value to set
     * @returns
     */
    set(key, value) {
        this.logService.info(`Setting ${key}`);
        return this.storageService.save(key, value);
    }
    /**
     * Remove a value in the storage service at the given key.
     *
     * This is a brute force method to just remove a value in the storage service. If you can use {@link removeFromGlobal} or {@link removeFromUser}, you should.
     * @param key location
     * @returns void
     */
    remove(key) {
        this.logService.info(`Removing ${key}`);
        return this.storageService.remove(key);
    }
    /**
     * Gets a globally scoped value from a location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link get} for those.
     * @param keyDefinition unique key definition
     * @returns value from store
     */
    getFromGlobal(keyDefinition) {
        return this.get(this.getGlobalKey(keyDefinition));
    }
    /**
     * Sets a globally scoped value to a location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link set} for those.
     * @param keyDefinition unique key definition
     * @param value value to store
     * @returns void
     */
    setToGlobal(keyDefinition, value) {
        return this.set(this.getGlobalKey(keyDefinition), value);
    }
    /**
     * Remove a globally scoped location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link remove} for those.
     * @param keyDefinition unique key definition
     * @returns void
     */
    removeFromGlobal(keyDefinition) {
        return this.remove(this.getGlobalKey(keyDefinition));
    }
    /**
     * Gets a user scoped value from a location derived through the user id and key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link get} for those.
     * @param userId userId to use in the key
     * @param keyDefinition unique key definition
     * @returns value from store
     */
    getFromUser(userId, keyDefinition) {
        return this.get(this.getUserKey(userId, keyDefinition));
    }
    /**
     * Sets a user scoped value to a location derived through the user id and key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link set} for those.
     * @param userId userId to use in the key
     * @param keyDefinition unique key definition
     * @param value value to store
     * @returns void
     */
    setToUser(userId, keyDefinition, value) {
        return this.set(this.getUserKey(userId, keyDefinition), value);
    }
    /**
     * Remove a user scoped location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link remove} for those.
     * @param keyDefinition unique key definition
     * @returns void
     */
    removeFromUser(userId, keyDefinition) {
        return this.remove(this.getUserKey(userId, keyDefinition));
    }
    info(message) {
        this.logService.info(message);
    }
    /**
     * Helper method to read all Account objects stored by the State Service.
     *
     * This is useful from creating migrations off of this paradigm, but should not be used once a value is migrated to a state provider.
     *
     * @returns a list of all accounts that have been authenticated with state service, cast the the expected type.
     */
    getAccounts() {
        var _a;
        return migration_helper_awaiter(this, void 0, void 0, function* () {
            const userIds = (_a = (yield this.get("authenticatedAccounts"))) !== null && _a !== void 0 ? _a : [];
            return Promise.all(userIds.map((userId) => migration_helper_awaiter(this, void 0, void 0, function* () {
                return ({
                    userId,
                    account: yield this.get(userId),
                });
            })));
        });
    }
    /**
     * Builds a user storage key appropriate for the current version.
     *
     * @param userId userId to use in the key
     * @param keyDefinition state and key to use in the key
     * @returns
     */
    getUserKey(userId, keyDefinition) {
        if (this.currentVersion < 9) {
            return userKeyBuilderPre9();
        }
        else {
            return userKeyBuilder(userId, keyDefinition);
        }
    }
    /**
     * Builds a global storage key appropriate for the current version.
     *
     * @param keyDefinition state and key to use in the key
     * @returns
     */
    getGlobalKey(keyDefinition) {
        if (this.currentVersion < 9) {
            return globalKeyBuilderPre9();
        }
        else {
            return migration_helper_globalKeyBuilder(keyDefinition);
        }
    }
}
/**
 * When this is updated, rename this function to `userKeyBuilderXToY` where `X` is the version number it
 * became relevant, and `Y` prior to the version it was updated.
 *
 * Be sure to update the map in `MigrationHelper` to point to the appropriate function for the current version.
 * @param userId The userId of the user you want the key to be for.
 * @param keyDefinition the key definition of which data the key should point to.
 * @returns
 */
function userKeyBuilder(userId, keyDefinition) {
    return `user_${userId}_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}
function userKeyBuilderPre9() {
    throw Error("No key builder should be used for versions prior to 9.");
}
/**
 * When this is updated, rename this function to `globalKeyBuilderXToY` where `X` is the version number
 * it became relevant, and `Y` prior to the version it was updated.
 *
 * Be sure to update the map in `MigrationHelper` to point to the appropriate function for the current version.
 * @param keyDefinition the key definition of which data the key should point to.
 * @returns
 */
function migration_helper_globalKeyBuilder(keyDefinition) {
    return `global_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}
function globalKeyBuilderPre9() {
    throw Error("No key builder should be used for versions prior to 9.");
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/migration-runner.ts
var migration_runner_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class MigrationRunner {
    constructor(diskStorage, logService, migrationBuilderService) {
        this.diskStorage = diskStorage;
        this.logService = logService;
        this.migrationBuilderService = migrationBuilderService;
    }
    run() {
        return migration_runner_awaiter(this, void 0, void 0, function* () {
            const migrationHelper = new MigrationHelper(yield currentVersion(this.diskStorage, this.logService), this.diskStorage, this.logService, "general");
            if (migrationHelper.currentVersion < 0) {
                // Cannot determine state, assuming empty so we don't repeatedly apply a migration.
                yield this.diskStorage.save("stateVersion", CURRENT_VERSION);
                return;
            }
            const migrationBuilder = this.migrationBuilderService.build();
            yield migrationBuilder.migrate(migrationHelper);
        });
    }
    waitForCompletion() {
        return migration_runner_awaiter(this, void 0, void 0, function* () {
            yield waitForMigrations(this.diskStorage, this.logService);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generator-options-evaluator.ts
function initializeBoundaries() {
    const length = Object.freeze({
        min: 5,
        max: 128,
    });
    const minDigits = Object.freeze({
        min: 0,
        max: 9,
    });
    const minSpecialCharacters = Object.freeze({
        min: 0,
        max: 9,
    });
    return Object.freeze({
        length,
        minDigits,
        minSpecialCharacters,
    });
}
/** Immutable default boundaries for password generation.
 * These are used when the policy does not override a value.
 */
const DefaultBoundaries = initializeBoundaries();
/** Enforces policy for password generation.
 */
class password_generator_options_evaluator_PasswordGeneratorOptionsEvaluator {
    /** Instantiates the evaluator.
     * @param policy The policy applied by the evaluator. When this conflicts with
     *               the defaults, the policy takes precedence.
     */
    constructor(policy) {
        function createBoundary(value, defaultBoundary) {
            const boundary = {
                min: Math.max(defaultBoundary.min, value),
                max: Math.max(defaultBoundary.max, value),
            };
            return boundary;
        }
        this.policy = structuredClone(policy);
        this.minDigits = createBoundary(policy.numberCount, DefaultBoundaries.minDigits);
        this.minSpecialCharacters = createBoundary(policy.specialCount, DefaultBoundaries.minSpecialCharacters);
        // the overall length should be at least as long as the sum of the minimums
        const minConsistentLength = this.minDigits.min + this.minSpecialCharacters.min;
        const minPolicyLength = policy.minLength > 0 ? policy.minLength : DefaultBoundaries.length.min;
        const minLength = Math.max(minPolicyLength, minConsistentLength, DefaultBoundaries.length.min);
        this.length = {
            min: minLength,
            max: Math.max(DefaultBoundaries.length.max, minLength),
        };
    }
    /** {@link PolicyEvaluator.policyInEffect} */
    get policyInEffect() {
        const policies = [
            this.policy.useUppercase,
            this.policy.useLowercase,
            this.policy.useNumbers,
            this.policy.useSpecial,
            this.policy.minLength > DefaultBoundaries.length.min,
            this.policy.numberCount > DefaultBoundaries.minDigits.min,
            this.policy.specialCount > DefaultBoundaries.minSpecialCharacters.min,
        ];
        return policies.includes(true);
    }
    /** {@link PolicyEvaluator.applyPolicy} */
    applyPolicy(options) {
        function fitToBounds(value, boundaries) {
            const { min, max } = boundaries;
            const withUpperBound = Math.min(value || 0, max);
            const withLowerBound = Math.max(withUpperBound, min);
            return withLowerBound;
        }
        // apply policy overrides
        const uppercase = this.policy.useUppercase || options.uppercase || false;
        const lowercase = this.policy.useLowercase || options.lowercase || false;
        // these overrides can cascade numeric fields to boolean fields
        const number = this.policy.useNumbers || options.number || options.minNumber > 0;
        const special = this.policy.useSpecial || options.special || options.minSpecial > 0;
        // apply boundaries; the boundaries can cascade boolean fields to numeric fields
        const length = fitToBounds(options.length, this.length);
        const minNumber = fitToBounds(options.minNumber, this.minDigits);
        const minSpecial = fitToBounds(options.minSpecial, this.minSpecialCharacters);
        return Object.assign(Object.assign({}, options), { length,
            uppercase,
            lowercase,
            number,
            minNumber,
            special,
            minSpecial });
    }
    /** {@link PolicyEvaluator.sanitize} */
    sanitize(options) {
        var _a;
        function cascade(enabled, value) {
            const enabledResult = enabled !== null && enabled !== void 0 ? enabled : value > 0;
            const valueResult = enabledResult ? value || 1 : 0;
            return [enabledResult, valueResult];
        }
        const [lowercase, minLowercase] = cascade(options.lowercase, options.minLowercase);
        const [uppercase, minUppercase] = cascade(options.uppercase, options.minUppercase);
        const [number, minNumber] = cascade(options.number, options.minNumber);
        const [special, minSpecial] = cascade(options.special, options.minSpecial);
        // minimums can only increase the length
        const minConsistentLength = minLowercase + minUppercase + minNumber + minSpecial;
        const minLength = Math.max(minConsistentLength, this.length.min);
        const length = Math.max((_a = options.length) !== null && _a !== void 0 ? _a : minLength, minLength);
        return Object.assign(Object.assign({}, options), { length,
            minLength,
            lowercase,
            minLowercase,
            uppercase,
            minUppercase,
            number,
            minNumber,
            special,
            minSpecial });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generation-options.ts

/** The default options for password generation. */
const password_generation_options_DefaultPasswordGenerationOptions = Object.freeze({
    length: 14,
    minLength: DefaultBoundaries.length.min,
    ambiguous: true,
    uppercase: true,
    lowercase: true,
    number: true,
    minNumber: 1,
    special: false,
    minSpecial: 0,
});

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/history/generated-credential.ts
/** A credential generation result */
class GeneratedCredential {
    /**
     * Instantiates a generated credential
     * @param credential The value of the generated credential (e.g. a password)
     * @param category The kind of credential
     * @param generationDate The date that the credential was generated.
     *   Numeric values should are interpreted using {@link Date.valueOf}
     *   semantics.
     */
    constructor(credential, category, generationDate) {
        this.credential = credential;
        this.category = category;
        if (typeof generationDate === "number") {
            this.generationDate = new Date(generationDate);
        }
        else {
            this.generationDate = generationDate;
        }
    }
    /** Constructs a credential from its `toJSON` representation */
    static fromJSON(jsonValue) {
        return new GeneratedCredential(jsonValue.credential, jsonValue.category, jsonValue.generationDate);
    }
    /** Serializes a credential to a JSON-compatible object */
    toJSON() {
        return {
            credential: this.credential,
            category: this.category,
            generationDate: this.generationDate.valueOf(),
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/state/secret-classifier.ts
/** Classifies an object's JSON-serializable data by property into
 *  3 categories:
 *  * Disclosed data MAY be stored in plaintext.
 *  * Excluded data MUST NOT be saved.
 *  * The remaining data is secret and MUST be stored using encryption.
 *
 *  This type should not be used to classify functions.
 *  Data that cannot be serialized by JSON.stringify() should
 *  be excluded.
 */
class SecretClassifier {
    constructor(disclosed, excluded) {
        this.disclosed = disclosed;
        this.excluded = excluded;
    }
    /** Creates a classifier where all properties are secret.
     *  @type {T} The type of secret being classified.
     */
    static allSecret() {
        const disclosed = Object.freeze([]);
        const excluded = Object.freeze([]);
        return new SecretClassifier(disclosed, excluded);
    }
    /** Classify a property as disclosed.
     *  @type {PropertyName} Available secrets to disclose.
     *  @param disclose The property name to disclose.
     *  @returns a new classifier
     */
    disclose(disclose) {
        // update the fluent interface
        const newDisclosed = [...this.disclosed, disclose];
        const classifier = new SecretClassifier(
        // since `NewDisclosed` is opaque to the type checker, it's necessary
        // to assert the type of the array here.
        Object.freeze(newDisclosed), this.excluded);
        return classifier;
    }
    /** Classify a property as excluded.
     *  @type {PropertyName} Available secrets to exclude.
     *  @param exclude The property name to exclude.
     *  @returns a new classifier
     */
    exclude(excludedPropertyName) {
        // update the fluent interface
        const newExcluded = [...this.excluded, excludedPropertyName];
        const classifier = new SecretClassifier(this.disclosed, Object.freeze(newExcluded));
        return classifier;
    }
    /** Partitions `secret` into its disclosed properties and secret properties.
     *  @param value The object to partition
     *  @returns an object that classifies secrets.
     *    The `disclosed` member is new and contains disclosed properties.
     *    The `secret` member is a copy of the secret parameter, including its
     *    prototype, with all disclosed and excluded properties deleted.
     */
    classify(value) {
        // need to JSONify during classification because the prototype is almost guaranteed
        // to be invalid when this  method deletes arbitrary properties.
        const secret = JSON.parse(JSON.stringify(value));
        for (const excludedProp of this.excluded) {
            delete secret[excludedProp];
        }
        const disclosed = {};
        for (const disclosedProp of this.disclosed) {
            // disclosedProp is known to be a subset of the keys of `Plaintext`, so these
            // type assertions are accurate.
            // FIXME: prove it to the compiler
            disclosed[disclosedProp] = secret[disclosedProp];
            delete secret[disclosedProp];
        }
        return {
            disclosed: disclosed,
            secret: secret,
        };
    }
    /** Merges the properties of `secret` and `disclosed`. When `secret` and
     *  `disclosed` contain the same property, the `secret` property overrides
     *  the `disclosed` property.
     *  @param disclosed an object whose disclosed properties are merged into
     *    the output. Unknown properties are ignored.
     *  @param secret an objects whose properties are merged into the output.
     *    Excluded properties are ignored. Unknown properties are retained.
     *  @returns a new object containing the merged data.
     */
    // Declassified data is always jsonified--the purpose of classifying it is to Jsonify it,
    // which causes type conversions.
    declassify(disclosed, secret) {
        // removed unknown keys from `disclosed` to prevent any old edit
        // of plaintext data from being laundered though declassification.
        const cleaned = {};
        for (const disclosedProp of this.disclosed) {
            cleaned[disclosedProp] = disclosed[disclosedProp];
        }
        // merge decrypted into cleaned so that secret data clobbers public data
        const merged = Object.assign(cleaned, secret);
        // delete excluded props
        for (const excludedProp of this.excluded) {
            delete merged[excludedProp];
        }
        return merged;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/state/secret-key-definition.ts

/** Encryption and storage settings for data stored by a `SecretState`.
 */
class SecretKeyDefinition {
    constructor(stateDefinition, key, classifier, options, 
    // type erasure is necessary here because typescript doesn't support
    // higher kinded types that generalize over collections. The invariants
    // needed to make this typesafe are maintained by the static factories.
    deconstruct, reconstruct) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.classifier = classifier;
        this.options = options;
        this.deconstruct = deconstruct;
        this.reconstruct = reconstruct;
    }
    /** Converts the secret key to the `KeyDefinition` used for secret storage. */
    toEncryptedStateKey() {
        const secretKey = new UserKeyDefinition(this.stateDefinition, this.key, {
            cleanupDelayMs: this.options.cleanupDelayMs,
            deserializer: (jsonValue) => jsonValue,
            // Clear encrypted state on logout
            clearOn: this.options.clearOn,
        });
        return secretKey;
    }
    /**
     * Define a secret state for a single value
     * @param stateDefinition The domain of the secret's durable state.
     * @param key Domain key that identifies the stored value. This key must not be reused
     *    in any capacity.
     * @param classifier Partitions the value into encrypted, discarded, and public data.
     * @param options Configures the operation of the secret state.
     */
    static value(stateDefinition, key, classifier, options) {
        return new SecretKeyDefinition(stateDefinition, key, classifier, options, (value) => [[null, value]], ([[, inner]]) => inner);
    }
    /**
     * Define a secret state for an array of values. Each item is encrypted separately.
     * @param stateDefinition The domain of the secret's durable state.
     * @param key Domain key that identifies the stored items. This key must not be reused
     *    in any capacity.
     * @param classifier Partitions each item into encrypted, discarded, and public data.
     * @param options Configures the operation of the secret state.
     */
    static array(stateDefinition, key, classifier, options) {
        return new SecretKeyDefinition(stateDefinition, key, classifier, options, (value) => value.map((v, id) => [id, v]), (values) => values.map(([, v]) => v));
    }
    /**
     * Define a secret state for a record. Each property is encrypted separately.
     * @param stateDefinition The domain of the secret's durable state.
     * @param key Domain key that identifies the stored properties. This key must not be reused
     *    in any capacity.
     * @param classifier Partitions each property into encrypted, discarded, and public data.
     * @param options Configures the operation of the secret state.
     */
    static record(stateDefinition, key, classifier, options) {
        return new SecretKeyDefinition(stateDefinition, key, classifier, options, (value) => Object.entries(value), (values) => Object.fromEntries(values));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/key-definitions.ts




/** plaintext password generation options */
const GENERATOR_SETTINGS = new UserKeyDefinition(GENERATOR_MEMORY, "generatorSettings", {
    deserializer: (value) => value,
    clearOn: ["lock", "logout"],
});
/** plaintext password generation options */
const key_definitions_PASSWORD_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "passwordGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext passphrase generation options */
const key_definitions_PASSPHRASE_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "passphraseGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext username generation options */
const EFF_USERNAME_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "effUsernameGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext configuration for a domain catch-all address. */
const CATCHALL_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "catchallGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** plaintext configuration for an email subaddress. */
const SUBADDRESS_SETTINGS = new UserKeyDefinition(GENERATOR_DISK, "subaddressGeneratorSettings", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.AddyIo} */
const ADDY_IO_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "addyIoForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.DuckDuckGo} */
const DUCK_DUCK_GO_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "duckDuckGoForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.FastMail} */
const FASTMAIL_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "fastmailForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.FireFoxRelay} */
const FIREFOX_RELAY_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "firefoxRelayForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link Forwarders.ForwardEmail} */
const FORWARD_EMAIL_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "forwardEmailForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** backing store configuration for {@link forwarders.SimpleLogin} */
const SIMPLE_LOGIN_FORWARDER = new UserKeyDefinition(GENERATOR_DISK, "simpleLoginForwarder", {
    deserializer: (value) => value,
    clearOn: [],
});
/** encrypted password generation history */
const GENERATOR_HISTORY = SecretKeyDefinition.array(GENERATOR_DISK, "localGeneratorHistory", SecretClassifier.allSecret(), {
    deserializer: GeneratedCredential.fromJSON,
    clearOn: ["logout"],
});

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/reduce-collection.operator.ts

/**
 * An observable operator that reduces an emitted collection to a single object,
 * returning a default if all items are ignored.
 * @param reduce The reduce function to apply to the filtered collection. The
 *  first argument is the accumulator, and the second is the current item. The
 *  return value is the new accumulator.
 * @param defaultValue The default value to return if the collection is empty. The
 *   default value is also the initial value of the accumulator.
 */
function reduce_collection_operator_reduceCollection(reduce, defaultValue) {
    return map((values) => {
        const reduced = (values !== null && values !== void 0 ? values : []).reduce(reduce, structuredClone(defaultValue));
        return reduced;
    });
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generator-policy.ts

/** The default options for password generation policy. */
const password_generator_policy_DisabledPasswordGeneratorPolicy = Object.freeze({
    minLength: 0,
    useUppercase: false,
    useLowercase: false,
    useNumbers: false,
    numberCount: 0,
    useSpecial: false,
    specialCount: 0,
});
/** Reduces a policy into an accumulator by accepting the most restrictive
 *  values from each policy.
 *  @param acc the accumulator
 *  @param policy the policy to reduce
 *  @returns the most restrictive values between the policy and accumulator.
 */
function password_generator_policy_leastPrivilege(acc, policy) {
    var _a, _b, _c;
    if (policy.type !== PolicyType.PasswordGenerator || !policy.enabled) {
        return acc;
    }
    return {
        minLength: Math.max(acc.minLength, (_a = policy.data.minLength) !== null && _a !== void 0 ? _a : acc.minLength),
        useUppercase: policy.data.useUpper || acc.useUppercase,
        useLowercase: policy.data.useLower || acc.useLowercase,
        useNumbers: policy.data.useNumbers || acc.useNumbers,
        numberCount: Math.max(acc.numberCount, (_b = policy.data.minNumbers) !== null && _b !== void 0 ? _b : acc.numberCount),
        useSpecial: policy.data.useSpecial || acc.useSpecial,
        specialCount: Math.max(acc.specialCount, (_c = policy.data.minSpecial) !== null && _c !== void 0 ? _c : acc.specialCount),
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generator-strategy.ts







const ONE_MINUTE = (/* unused pure expression or super */ null && (60 * 1000));
/** {@link GeneratorStrategy} */
class PasswordGeneratorStrategy {
    /** instantiates the password generator strategy.
     *  @param legacy generates the password
     */
    constructor(legacy, stateProvider) {
        this.legacy = legacy;
        this.stateProvider = stateProvider;
    }
    /** {@link GeneratorStrategy.durableState} */
    durableState(id) {
        return this.stateProvider.getUser(id, PASSWORD_SETTINGS);
    }
    /** Gets the default options. */
    defaults$(_) {
        return new BehaviorSubject(Object.assign({}, DefaultPasswordGenerationOptions)).asObservable();
    }
    /** {@link GeneratorStrategy.policy} */
    get policy() {
        return PolicyType.PasswordGenerator;
    }
    get cache_ms() {
        return ONE_MINUTE;
    }
    /** {@link GeneratorStrategy.toEvaluator} */
    toEvaluator() {
        return pipe(reduceCollection(leastPrivilege, DisabledPasswordGeneratorPolicy), map((policy) => new PasswordGeneratorOptionsEvaluator(policy)));
    }
    /** {@link GeneratorStrategy.generate} */
    generate(options) {
        return this.legacy.generatePassword(Object.assign(Object.assign({}, options), { type: "password" }));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/password-generator-policy-options.ts

/** Enterprise policy for the password generator.
 * @see PolicyType.PasswordGenerator
 */
class PasswordGeneratorPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        /** The default kind of credential to generate */
        this.defaultType = "";
        /** The minimum length of generated passwords.
         *  When this is less than or equal to zero, it is ignored.
         *  If this is less than the total number of characters required by
         *  the policy's other settings, then it is ignored.
         *  This field is not used for passphrases.
         */
        this.minLength = 0;
        /** When this is true, an uppercase character must be part of
         *  the generated password.
         *  This field is not used for passphrases.
         */
        this.useUppercase = false;
        /** When this is true, a lowercase character must be part of
         *  the generated password. This field is not used for passphrases.
         */
        this.useLowercase = false;
        /** When this is true, at least one digit must be part of the generated
         *  password. This field is not used for passphrases.
         */
        this.useNumbers = false;
        /** The quantity of digits to include in the generated password.
         *  When this is less than or equal to zero, it is ignored.
         *  This field is not used for passphrases.
         */
        this.numberCount = 0;
        /** When this is true, at least one digit must be part of the generated
         *  password. This field is not used for passphrases.
         */
        this.useSpecial = false;
        /** The quantity of special characters to include in the generated
         *  password. When this is less than or equal to zero, it is ignored.
         *  This field is not used for passphrases.
         */
        this.specialCount = 0;
        /** The minimum number of words required by generated passphrases.
         *  This field is not used for passwords.
         */
        this.minNumberWords = 0;
        /** When this is true, the first letter of each word in the passphrase
         *  is capitalized. This field is not used for passwords.
         */
        this.capitalize = false;
        /** When this is true, a number is included within the passphrase.
         *  This field is not used for passwords.
         */
        this.includeNumber = false;
    }
    /** Checks whether the policy affects the password generator.
     * @returns True if at least one password or passphrase requirement has been set.
     * If it returns False, then no requirements have been set and the policy should
     * not be enforced.
     */
    inEffect() {
        return (this.defaultType !== "" ||
            this.minLength > 0 ||
            this.numberCount > 0 ||
            this.specialCount > 0 ||
            this.useUppercase ||
            this.useLowercase ||
            this.useNumbers ||
            this.useSpecial ||
            this.minNumberWords > 0 ||
            this.capitalize ||
            this.includeNumber);
    }
    /** Creates a copy of the policy.
     */
    clone() {
        const policy = new PasswordGeneratorPolicyOptions();
        Object.assign(policy, this);
        return policy;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/passphrase/passphrase-generation-options.ts
/** The default options for passphrase generation. */
const passphrase_generation_options_DefaultPassphraseGenerationOptions = Object.freeze({
    numWords: 3,
    wordSeparator: "-",
    capitalize: false,
    includeNumber: false,
});

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/passphrase/passphrase-generator-options-evaluator.ts

function passphrase_generator_options_evaluator_initializeBoundaries() {
    const numWords = Object.freeze({
        min: 3,
        max: 20,
    });
    return Object.freeze({
        numWords,
    });
}
/** Immutable default boundaries for passphrase generation.
 * These are used when the policy does not override a value.
 */
const passphrase_generator_options_evaluator_DefaultBoundaries = passphrase_generator_options_evaluator_initializeBoundaries();
/** Enforces policy for passphrase generation options.
 */
class passphrase_generator_options_evaluator_PassphraseGeneratorOptionsEvaluator {
    /** Instantiates the evaluator.
     * @param policy The policy applied by the evaluator. When this conflicts with
     *               the defaults, the policy takes precedence.
     */
    constructor(policy) {
        function createBoundary(value, defaultBoundary) {
            const boundary = {
                min: Math.max(defaultBoundary.min, value),
                max: Math.max(defaultBoundary.max, value),
            };
            return boundary;
        }
        this.policy = structuredClone(policy);
        this.numWords = createBoundary(policy.minNumberWords, passphrase_generator_options_evaluator_DefaultBoundaries.numWords);
    }
    /** {@link PolicyEvaluator.policyInEffect} */
    get policyInEffect() {
        const policies = [
            this.policy.capitalize,
            this.policy.includeNumber,
            this.policy.minNumberWords > passphrase_generator_options_evaluator_DefaultBoundaries.numWords.min,
        ];
        return policies.includes(true);
    }
    /** Apply policy to the input options.
     *  @param options The options to build from. These options are not altered.
     *  @returns A new password generation request with policy applied.
     */
    applyPolicy(options) {
        function fitToBounds(value, boundaries) {
            const { min, max } = boundaries;
            const withUpperBound = Math.min(value !== null && value !== void 0 ? value : boundaries.min, max);
            const withLowerBound = Math.max(withUpperBound, min);
            return withLowerBound;
        }
        // apply policy overrides
        const capitalize = this.policy.capitalize || options.capitalize || false;
        const includeNumber = this.policy.includeNumber || options.includeNumber || false;
        // apply boundaries
        const numWords = fitToBounds(options.numWords, this.numWords);
        return Object.assign(Object.assign({}, options), { numWords,
            capitalize,
            includeNumber });
    }
    /** Ensures internal options consistency.
     *  @param options The options to cascade. These options are not altered.
     *  @returns A passphrase generation request with cascade applied.
     */
    sanitize(options) {
        var _a, _b;
        // ensure words are separated by a single character or the empty string
        const wordSeparator = options.wordSeparator === ""
            ? ""
            : (_b = (_a = options.wordSeparator) === null || _a === void 0 ? void 0 : _a[0]) !== null && _b !== void 0 ? _b : passphrase_generation_options_DefaultPassphraseGenerationOptions.wordSeparator;
        return Object.assign(Object.assign({}, options), { wordSeparator });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/generated-password-history.ts
class GeneratedPasswordHistory {
    constructor(password, date) {
        this.password = password;
        this.date = date;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generation.service.ts
var password_generation_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







const DefaultOptions = {
    length: 14,
    minLength: 5,
    ambiguous: false,
    number: true,
    minNumber: 1,
    uppercase: true,
    minUppercase: 0,
    lowercase: true,
    minLowercase: 0,
    special: false,
    minSpecial: 0,
    type: "password",
    numWords: 3,
    wordSeparator: "-",
    capitalize: false,
    includeNumber: false,
};
const DefaultPolicy = new PasswordGeneratorPolicyOptions();
const MaxPasswordsInHistory = 100;
class PasswordGenerationService {
    constructor(cryptoService, policyService, stateService) {
        this.cryptoService = cryptoService;
        this.policyService = policyService;
        this.stateService = stateService;
    }
    generatePassword(options) {
        var _a;
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (((_a = options.type) !== null && _a !== void 0 ? _a : DefaultOptions.type) === "passphrase") {
                return this.generatePassphrase(Object.assign(Object.assign({}, DefaultOptions), options));
            }
            const evaluator = new password_generator_options_evaluator_PasswordGeneratorOptionsEvaluator(DefaultPolicy);
            const o = evaluator.sanitize(Object.assign(Object.assign({}, DefaultOptions), options));
            const positions = [];
            if (o.lowercase && o.minLowercase > 0) {
                for (let i = 0; i < o.minLowercase; i++) {
                    positions.push("l");
                }
            }
            if (o.uppercase && o.minUppercase > 0) {
                for (let i = 0; i < o.minUppercase; i++) {
                    positions.push("u");
                }
            }
            if (o.number && o.minNumber > 0) {
                for (let i = 0; i < o.minNumber; i++) {
                    positions.push("n");
                }
            }
            if (o.special && o.minSpecial > 0) {
                for (let i = 0; i < o.minSpecial; i++) {
                    positions.push("s");
                }
            }
            while (positions.length < o.length) {
                positions.push("a");
            }
            // shuffle
            yield this.shuffleArray(positions);
            // build out the char sets
            let allCharSet = "";
            let lowercaseCharSet = "abcdefghijkmnopqrstuvwxyz";
            if (o.ambiguous) {
                lowercaseCharSet += "l";
            }
            if (o.lowercase) {
                allCharSet += lowercaseCharSet;
            }
            let uppercaseCharSet = "ABCDEFGHJKLMNPQRSTUVWXYZ";
            if (o.ambiguous) {
                uppercaseCharSet += "IO";
            }
            if (o.uppercase) {
                allCharSet += uppercaseCharSet;
            }
            let numberCharSet = "23456789";
            if (o.ambiguous) {
                numberCharSet += "01";
            }
            if (o.number) {
                allCharSet += numberCharSet;
            }
            const specialCharSet = "!@#$%^&*";
            if (o.special) {
                allCharSet += specialCharSet;
            }
            let password = "";
            for (let i = 0; i < o.length; i++) {
                let positionChars;
                switch (positions[i]) {
                    case "l":
                        positionChars = lowercaseCharSet;
                        break;
                    case "u":
                        positionChars = uppercaseCharSet;
                        break;
                    case "n":
                        positionChars = numberCharSet;
                        break;
                    case "s":
                        positionChars = specialCharSet;
                        break;
                    case "a":
                        positionChars = allCharSet;
                        break;
                    default:
                        break;
                }
                const randomCharIndex = yield this.cryptoService.randomNumber(0, positionChars.length - 1);
                password += positionChars.charAt(randomCharIndex);
            }
            return password;
        });
    }
    generatePassphrase(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            const evaluator = new passphrase_generator_options_evaluator_PassphraseGeneratorOptionsEvaluator(DefaultPolicy);
            const o = evaluator.sanitize(Object.assign(Object.assign({}, DefaultOptions), options));
            if (o.numWords == null || o.numWords <= 2) {
                o.numWords = DefaultOptions.numWords;
            }
            if (o.capitalize == null) {
                o.capitalize = false;
            }
            if (o.includeNumber == null) {
                o.includeNumber = false;
            }
            const listLength = EFFLongWordList.length - 1;
            const wordList = new Array(o.numWords);
            for (let i = 0; i < o.numWords; i++) {
                const wordIndex = yield this.cryptoService.randomNumber(0, listLength);
                if (o.capitalize) {
                    wordList[i] = this.capitalize(EFFLongWordList[wordIndex]);
                }
                else {
                    wordList[i] = EFFLongWordList[wordIndex];
                }
            }
            if (o.includeNumber) {
                yield this.appendRandomNumberToRandomWord(wordList);
            }
            return wordList.join(o.wordSeparator);
        });
    }
    getOptions() {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            let options = yield this.stateService.getPasswordGenerationOptions();
            if (options == null) {
                options = Object.assign({}, DefaultOptions);
            }
            else {
                options = Object.assign({}, DefaultOptions, options);
            }
            yield this.stateService.setPasswordGenerationOptions(options);
            const enforcedOptions = yield this.enforcePasswordGeneratorPoliciesOnOptions(options);
            options = enforcedOptions[0];
            return [options, enforcedOptions[1]];
        });
    }
    enforcePasswordGeneratorPoliciesOnOptions(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            let policy = yield this.getPasswordGeneratorPolicyOptions();
            policy = policy !== null && policy !== void 0 ? policy : new PasswordGeneratorPolicyOptions();
            // Force default type if password/passphrase selected via policy
            if (policy.defaultType === "password" || policy.defaultType === "passphrase") {
                options.type = policy.defaultType;
            }
            const evaluator = options.type == "password"
                ? new password_generator_options_evaluator_PasswordGeneratorOptionsEvaluator(policy)
                : new passphrase_generator_options_evaluator_PassphraseGeneratorOptionsEvaluator(policy);
            // Ensure the options to pass the current rules
            const withPolicy = evaluator.applyPolicy(options);
            const sanitized = evaluator.sanitize(withPolicy);
            // callers assume this function updates the options parameter
            const result = Object.assign(options, sanitized);
            return [result, policy];
        });
    }
    getPasswordGeneratorPolicyOptions() {
        var _a;
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            const policies = yield ((_a = this.policyService) === null || _a === void 0 ? void 0 : _a.getAll(policy_type_enum_PolicyType.PasswordGenerator));
            let enforcedOptions = null;
            if (policies == null || policies.length === 0) {
                return enforcedOptions;
            }
            policies.forEach((currentPolicy) => {
                if (!currentPolicy.enabled || currentPolicy.data == null) {
                    return;
                }
                if (enforcedOptions == null) {
                    enforcedOptions = new PasswordGeneratorPolicyOptions();
                }
                // Password wins in multi-org collisions
                if (currentPolicy.data.defaultType != null && enforcedOptions.defaultType !== "password") {
                    enforcedOptions.defaultType = currentPolicy.data.defaultType;
                }
                if (currentPolicy.data.minLength != null &&
                    currentPolicy.data.minLength > enforcedOptions.minLength) {
                    enforcedOptions.minLength = currentPolicy.data.minLength;
                }
                if (currentPolicy.data.useUpper) {
                    enforcedOptions.useUppercase = true;
                }
                if (currentPolicy.data.useLower) {
                    enforcedOptions.useLowercase = true;
                }
                if (currentPolicy.data.useNumbers) {
                    enforcedOptions.useNumbers = true;
                }
                if (currentPolicy.data.minNumbers != null &&
                    currentPolicy.data.minNumbers > enforcedOptions.numberCount) {
                    enforcedOptions.numberCount = currentPolicy.data.minNumbers;
                }
                if (currentPolicy.data.useSpecial) {
                    enforcedOptions.useSpecial = true;
                }
                if (currentPolicy.data.minSpecial != null &&
                    currentPolicy.data.minSpecial > enforcedOptions.specialCount) {
                    enforcedOptions.specialCount = currentPolicy.data.minSpecial;
                }
                if (currentPolicy.data.minNumberWords != null &&
                    currentPolicy.data.minNumberWords > enforcedOptions.minNumberWords) {
                    enforcedOptions.minNumberWords = currentPolicy.data.minNumberWords;
                }
                if (currentPolicy.data.capitalize) {
                    enforcedOptions.capitalize = true;
                }
                if (currentPolicy.data.includeNumber) {
                    enforcedOptions.includeNumber = true;
                }
            });
            return enforcedOptions;
        });
    }
    saveOptions(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setPasswordGenerationOptions(options);
        });
    }
    getHistory() {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            const hasKey = yield this.cryptoService.hasUserKey();
            if (!hasKey) {
                return new Array();
            }
            if ((yield this.stateService.getDecryptedPasswordGenerationHistory()) == null) {
                const encrypted = yield this.stateService.getEncryptedPasswordGenerationHistory();
                const decrypted = yield this.decryptHistory(encrypted);
                yield this.stateService.setDecryptedPasswordGenerationHistory(decrypted);
            }
            const passwordGenerationHistory = yield this.stateService.getDecryptedPasswordGenerationHistory();
            return passwordGenerationHistory != null
                ? passwordGenerationHistory
                : new Array();
        });
    }
    addHistory(password) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            // Cannot add new history if no key is available
            const hasKey = yield this.cryptoService.hasUserKey();
            if (!hasKey) {
                return;
            }
            const currentHistory = yield this.getHistory();
            // Prevent duplicates
            if (this.matchesPrevious(password, currentHistory)) {
                return;
            }
            currentHistory.unshift(new GeneratedPasswordHistory(password, Date.now()));
            // Remove old items.
            if (currentHistory.length > MaxPasswordsInHistory) {
                currentHistory.pop();
            }
            const newHistory = yield this.encryptHistory(currentHistory);
            yield this.stateService.setDecryptedPasswordGenerationHistory(currentHistory);
            return yield this.stateService.setEncryptedPasswordGenerationHistory(newHistory);
        });
    }
    clear(userId) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setEncryptedPasswordGenerationHistory(null, { userId: userId });
            yield this.stateService.setDecryptedPasswordGenerationHistory(null, { userId: userId });
        });
    }
    capitalize(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
    }
    appendRandomNumberToRandomWord(wordList) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (wordList == null || wordList.length <= 0) {
                return;
            }
            const index = yield this.cryptoService.randomNumber(0, wordList.length - 1);
            const num = yield this.cryptoService.randomNumber(0, 9);
            wordList[index] = wordList[index] + num;
        });
    }
    encryptHistory(history) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (history == null || history.length === 0) {
                return Promise.resolve([]);
            }
            const promises = history.map((item) => password_generation_service_awaiter(this, void 0, void 0, function* () {
                const encrypted = yield this.cryptoService.encrypt(item.password);
                return new GeneratedPasswordHistory(encrypted.encryptedString, item.date);
            }));
            return yield Promise.all(promises);
        });
    }
    decryptHistory(history) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (history == null || history.length === 0) {
                return Promise.resolve([]);
            }
            const promises = history.map((item) => password_generation_service_awaiter(this, void 0, void 0, function* () {
                const decrypted = yield this.cryptoService.decryptToUtf8(new EncString(item.password));
                return new GeneratedPasswordHistory(decrypted, item.date);
            }));
            return yield Promise.all(promises);
        });
    }
    matchesPrevious(password, history) {
        if (history == null || history.length === 0) {
            return false;
        }
        return history[history.length - 1].password === password;
    }
    // ref: https://stackoverflow.com/a/12646864/1090359
    shuffleArray(array) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            for (let i = array.length - 1; i > 0; i--) {
                const j = yield this.cryptoService.randomNumber(0, i);
                [array[i], array[j]] = [array[j], array[i]];
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/index.ts
// password generator "v2" interfaces







;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/state.ts
class State {
    constructor(globals) {
        this.accounts = {};
        this.authenticatedAccounts = [];
        this.accountActivity = {};
        this.globals = globals;
    }
    // TODO, make Jsonify<State,TGlobalState,TAccount> work. It currently doesn't because Globals doesn't implement Jsonify.
    static fromJSON(obj, accountDeserializer) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new State(null), obj, {
            accounts: State.buildAccountMapFromJSON(obj === null || obj === void 0 ? void 0 : obj.accounts, accountDeserializer),
        });
    }
    static buildAccountMapFromJSON(jsonAccounts, accountDeserializer) {
        if (!jsonAccounts) {
            return {};
        }
        const accounts = {};
        for (const userId in jsonAccounts) {
            accounts[userId] = accountDeserializer(jsonAccounts[userId]);
        }
        return accounts;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/state.service.ts
var state_service_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var state_service_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var state_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








const keys = {
    state: "state",
    stateVersion: "stateVersion",
    global: "global",
    authenticatedAccounts: "authenticatedAccounts",
    activeUserId: "activeUserId",
    tempAccountSettings: "tempAccountSettings",
    accountActivity: "accountActivity",
};
const partialKeys = {
    userAutoKey: "_user_auto",
    userBiometricKey: "_user_biometric",
    autoKey: "_masterkey_auto",
    biometricKey: "_masterkey_biometric",
    masterKey: "_masterkey",
};
const DDG_SHARED_KEY = "DuckDuckGoSharedKey";
class StateService {
    constructor(storageService, secureStorageService, memoryStorageService, logService, stateFactory, accountService, environmentService, tokenService, migrationRunner, useAccountCache = true) {
        this.storageService = storageService;
        this.secureStorageService = secureStorageService;
        this.memoryStorageService = memoryStorageService;
        this.logService = logService;
        this.stateFactory = stateFactory;
        this.accountService = accountService;
        this.environmentService = environmentService;
        this.tokenService = tokenService;
        this.migrationRunner = migrationRunner;
        this.useAccountCache = useAccountCache;
        this.accountsSubject = new external_rxjs_namespaceObject.BehaviorSubject({});
        this.accounts$ = this.accountsSubject.asObservable();
        this.activeAccountSubject = new external_rxjs_namespaceObject.BehaviorSubject(null);
        this.activeAccount$ = this.activeAccountSubject.asObservable();
        this.hasBeenInited = false;
        this.isRecoveredSession = false;
        this.accountDiskCache = new external_rxjs_namespaceObject.BehaviorSubject({});
        // default account serializer, must be overridden by child class
        this.accountDeserializer = Account.fromJSON;
    }
    init(initOptions = {}) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            // Deconstruct and apply defaults
            const { runMigrations = true } = initOptions;
            if (this.hasBeenInited) {
                return;
            }
            if (runMigrations) {
                yield this.migrationRunner.run();
            }
            else {
                // It may have been requested to not run the migrations but we should defensively not
                // continue this method until migrations have a chance to be completed elsewhere.
                yield this.migrationRunner.waitForCompletion();
            }
            yield this.state().then((state) => state_service_awaiter(this, void 0, void 0, function* () {
                if (state == null) {
                    yield this.setState(new State(this.createGlobals()));
                }
                else {
                    this.isRecoveredSession = true;
                }
            }));
            yield this.initAccountState();
            this.hasBeenInited = true;
        });
    }
    initAccountState() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (this.isRecoveredSession) {
                return;
            }
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                var _a;
                state.authenticatedAccounts =
                    (_a = (yield this.storageService.get(keys.authenticatedAccounts))) !== null && _a !== void 0 ? _a : [];
                for (const i in state.authenticatedAccounts) {
                    if (i != null) {
                        state = yield this.syncAccountFromDisk(state.authenticatedAccounts[i]);
                    }
                }
                const storedActiveUser = yield this.storageService.get(keys.activeUserId);
                if (storedActiveUser != null) {
                    state.activeUserId = storedActiveUser;
                }
                yield this.pushAccounts();
                this.activeAccountSubject.next(state.activeUserId);
                // TODO: Temporary update to avoid routing all account status changes through account service for now.
                // account service tracks logged out accounts, but State service does not, so we need to add the active account
                // if it's not in the accounts list.
                if (state.activeUserId != null && this.accountsSubject.value[state.activeUserId] == null) {
                    const activeDiskAccount = yield this.getAccountFromDisk({ userId: state.activeUserId });
                    yield this.accountService.addAccount(state.activeUserId, {
                        name: activeDiskAccount.profile.name,
                        email: activeDiskAccount.profile.email,
                    });
                }
                yield this.accountService.switchAccount(state.activeUserId);
                // End TODO
                return state;
            }));
        });
    }
    syncAccountFromDisk(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                return;
            }
            const diskAccount = yield this.getAccountFromDisk({ userId: userId });
            const state = yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                if (state.accounts == null) {
                    state.accounts = {};
                }
                state.accounts[userId] = this.createAccount();
                state.accounts[userId].profile = diskAccount.profile;
                return state;
            }));
            // TODO: Temporary update to avoid routing all account status changes through account service for now.
            // The determination of state should be handled by the various services that control those values.
            yield this.accountService.addAccount(userId, {
                name: diskAccount.profile.name,
                email: diskAccount.profile.email,
            });
            return state;
        });
    }
    addAccount(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.environmentService.seedUserEnvironment(account.profile.userId);
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.authenticatedAccounts.push(account.profile.userId);
                yield this.storageService.save(keys.authenticatedAccounts, state.authenticatedAccounts);
                state.accounts[account.profile.userId] = account;
                return state;
            }));
            yield this.scaffoldNewAccountStorage(account);
            yield this.setLastActive(new Date().getTime(), { userId: account.profile.userId });
            // TODO: Temporary update to avoid routing all account status changes through account service for now.
            yield this.accountService.addAccount(account.profile.userId, {
                name: account.profile.name,
                email: account.profile.email,
            });
            yield this.setActiveUser(account.profile.userId);
        });
    }
    setActiveUser(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearDecryptedDataForActiveUser();
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.activeUserId = userId;
                yield this.storageService.save(keys.activeUserId, userId);
                this.activeAccountSubject.next(state.activeUserId);
                // TODO: temporary update to avoid routing all account status changes through account service for now.
                yield this.accountService.switchAccount(userId);
                return state;
            }));
            yield this.pushAccounts();
        });
    }
    clean(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultInMemoryOptions());
            yield this.deAuthenticateAccount(options.userId);
            let currentUser = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId;
            if (options.userId === currentUser) {
                currentUser = yield this.dynamicallySetActiveUser();
            }
            yield this.removeAccountFromDisk(options === null || options === void 0 ? void 0 : options.userId);
            yield this.removeAccountFromMemory(options === null || options === void 0 ? void 0 : options.userId);
            yield this.pushAccounts();
            return currentUser;
        });
    }
    /**
     * user key when using the "never" option of vault timeout
     */
    getUserKeyAutoUnlock(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.userAutoKey}`, options);
        });
    }
    /**
     * user key when using the "never" option of vault timeout
     */
    setUserKeyAutoUnlock(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.userAutoKey, value, options);
        });
    }
    /**
     * User's encrypted symmetric key when using biometrics
     */
    getUserKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.userBiometricKey}`, options);
        });
    }
    hasUserKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return false;
            }
            return yield this.secureStorageService.has(`${options.userId}${partialKeys.userBiometricKey}`, options);
        });
    }
    setUserKeyBiometric(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.userBiometricKey, value, options);
        });
    }
    getPinKeyEncryptedUserKey(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return EncString.fromJSON((_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.pinKeyEncryptedUserKey);
        });
    }
    setPinKeyEncryptedUserKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.pinKeyEncryptedUserKey = value === null || value === void 0 ? void 0 : value.encryptedString;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getPinKeyEncryptedUserKeyEphemeral(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return EncString.fromJSON((_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.pinKeyEncryptedUserKeyEphemeral);
        });
    }
    setPinKeyEncryptedUserKeyEphemeral(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.settings.pinKeyEncryptedUserKeyEphemeral = value === null || value === void 0 ? void 0 : value.encryptedString;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    /**
     * @deprecated Use UserKeyAuto instead
     */
    getCryptoMasterKeyAuto(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.autoKey}`, options);
        });
    }
    /**
     * @deprecated Use UserKeyAuto instead
     */
    setCryptoMasterKeyAuto(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.autoKey, value, options);
        });
    }
    /**
     * @deprecated I don't see where this is even used
     */
    getCryptoMasterKeyB64(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options === null || options === void 0 ? void 0 : options.userId}${partialKeys.masterKey}`, options);
        });
    }
    /**
     * @deprecated I don't see where this is even used
     */
    setCryptoMasterKeyB64(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.masterKey, value, options);
        });
    }
    /**
     * @deprecated Use UserKeyBiometric instead
     */
    getCryptoMasterKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.biometricKey}`, options);
        });
    }
    /**
     * @deprecated Use UserKeyBiometric instead
     */
    hasCryptoMasterKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return false;
            }
            return yield this.secureStorageService.has(`${options.userId}${partialKeys.biometricKey}`, options);
        });
    }
    /**
     * @deprecated Use UserKeyBiometric instead
     */
    setCryptoMasterKeyBiometric(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.biometricKey, value, options);
        });
    }
    getDecryptedPasswordGenerationHistory(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.passwordGenerationHistory) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedPasswordGenerationHistory(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.passwordGenerationHistory.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    /**
     * @deprecated Use getPinKeyEncryptedUserKeyEphemeral instead
     */
    getDecryptedPinProtected(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.pinProtected) === null || _c === void 0 ? void 0 : _c.de