/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.jcache;

import io.micronaut.cache.CacheManager;
import io.micronaut.cache.DefaultCacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.jcache.JCacheSyncCache;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import jakarta.inject.Named;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.cache.Cache;

@Replaces(value=DefaultCacheManager.class)
@Requirements(value={@Requires(beans={javax.cache.CacheManager.class}), @Requires(property="micronaut.jcache.enabled", value="true", defaultValue="true")})
@Primary
public class JCacheManager
implements CacheManager<Cache> {
    public static final String JCACHE_ENABLED = "micronaut.jcache.enabled";
    private final javax.cache.CacheManager cacheManager;
    private final ConversionService<?> conversionService;
    private final ExecutorService executorService;

    protected JCacheManager(@NonNull javax.cache.CacheManager cacheManager, @NonNull @Named(value="io") ExecutorService executorService, @NonNull ConversionService<?> conversionService) {
        this.cacheManager = cacheManager;
        this.conversionService = conversionService;
        this.executorService = executorService;
    }

    @Override
    @NonNull
    public Set<String> getCacheNames() {
        return CollectionUtils.iterableToSet((Iterable)this.cacheManager.getCacheNames());
    }

    @Override
    @NonNull
    public SyncCache<Cache> getCache(String name) {
        Cache cache = this.cacheManager.getCache(name);
        if (cache == null) {
            throw new ConfigurationException("No cache configured for name: " + name);
        }
        return new JCacheSyncCache(cache, this.conversionService, this.executorService);
    }

    @NonNull
    public javax.cache.CacheManager getCacheManager() {
        return this.cacheManager;
    }
}

