/*
 * Decompiled with CFR 0.152.
 */
package org.grails.io.support;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.grails.io.support.AntPathMatcher;
import org.grails.io.support.DefaultResourceLoader;
import org.grails.io.support.FileSystemResource;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.Resource;
import org.grails.io.support.ResourceLoader;
import org.grails.io.support.UrlResource;

public class PathMatchingResourcePatternResolver {
    private static final String CLASSPATH_ALL_URL_PREFIX = "classpath*:";
    private final ResourceLoader resourceLoader;
    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public PathMatchingResourcePatternResolver() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public PathMatchingResourcePatternResolver(ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    public void setPathMatcher(AntPathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public AntPathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public Resource getResource(String location) {
        return this.getResourceLoader().getResource(location);
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith(CLASSPATH_ALL_URL_PREFIX)) {
            if (this.getPathMatcher().isPattern(locationPattern.substring(CLASSPATH_ALL_URL_PREFIX.length()))) {
                return this.findPathMatchingResources(locationPattern);
            }
            return this.findAllClassPathResources(locationPattern.substring(CLASSPATH_ALL_URL_PREFIX.length()));
        }
        int prefixEnd = locationPattern.indexOf(":") + 1;
        if (this.getPathMatcher().isPattern(locationPattern.substring(prefixEnd))) {
            return this.findPathMatchingResources(locationPattern);
        }
        return new Resource[]{this.getResourceLoader().getResource(locationPattern)};
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Enumeration<URL> resourceUrls = this.getClassLoader().getResources(path);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(this.convertClassLoaderURL(url));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected Resource convertClassLoaderURL(URL url) {
        return new UrlResource(url);
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.getResources(rootDirPath);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        for (Resource rootDirResource : rootDirResources) {
            if (this.isJarResource(rootDirResource = this.resolveRootDirResource(rootDirResource))) {
                result.addAll(this.doFindPathMatchingJarResources(rootDirResource, subPattern));
                continue;
            }
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected String determineRootDir(String location) {
        int prefixEnd = location.indexOf(":") + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.getPathMatcher().isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    protected Resource resolveRootDirResource(Resource original) throws IOException {
        return original;
    }

    protected boolean isJarResource(Resource resource) throws IOException {
        return GrailsResourceUtils.isJarURL(resource.getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Resource> doFindPathMatchingJarResources(Resource rootDirResource, String subPattern) throws IOException {
        Object rootEntryPath;
        String jarFileUrl;
        JarFile jarFile;
        URLConnection con = rootDirResource.getURL().openConnection();
        boolean newJarFile = false;
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            GrailsResourceUtils.useCachesIfNecessary(jarCon);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = rootDirResource.getURL().getFile();
            int separatorIndex = urlFile.indexOf("!/");
            if (separatorIndex != -1) {
                jarFileUrl = urlFile.substring(0, separatorIndex);
                rootEntryPath = urlFile.substring(separatorIndex + "!/".length());
                jarFile = this.getJarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
                jarFileUrl = urlFile;
                rootEntryPath = "";
            }
            newJarFile = true;
        }
        try {
            if (!"".equals(rootEntryPath) && !((String)rootEntryPath).endsWith("/")) {
                rootEntryPath = (String)rootEntryPath + "/";
            }
            LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(8);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith((String)rootEntryPath)) continue;
                String relativePath = entryPath.substring(((String)rootEntryPath).length());
                if (!this.getPathMatcher().match(subPattern, relativePath)) continue;
                result.add(rootDirResource.createRelative(relativePath));
            }
            LinkedHashSet<Resource> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
    }

    protected JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(GrailsResourceUtils.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        File rootDir;
        try {
            rootDir = rootDirResource.getFile().getAbsoluteFile();
        }
        catch (IOException ex) {
            return Collections.emptySet();
        }
        return this.doFindMatchingFileSystemResources(rootDir, subPattern);
    }

    protected Set<Resource> doFindMatchingFileSystemResources(File rootDir, String subPattern) throws IOException {
        Set<File> matchingFiles = this.retrieveMatchingFiles(rootDir, subPattern);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(matchingFiles.size());
        for (File file : matchingFiles) {
            result.add(new FileSystemResource(file));
        }
        return result;
    }

    protected Set<File> retrieveMatchingFiles(File rootDir, String pattern) throws IOException {
        if (!rootDir.exists()) {
            return Collections.emptySet();
        }
        if (!rootDir.isDirectory()) {
            return Collections.emptySet();
        }
        if (!rootDir.canRead()) {
            return Collections.emptySet();
        }
        Object fullPattern = rootDir.getAbsolutePath().replace(File.separator, "/");
        if (!pattern.startsWith("/")) {
            fullPattern = (String)fullPattern + "/";
        }
        fullPattern = (String)fullPattern + pattern.replace(File.separator, "/");
        LinkedHashSet<File> result = new LinkedHashSet<File>(8);
        this.doRetrieveMatchingFiles((String)fullPattern, rootDir, result);
        return result;
    }

    protected void doRetrieveMatchingFiles(String fullPattern, File dir, Set<File> result) throws IOException {
        File[] dirContents = dir.listFiles();
        if (dirContents == null) {
            return;
        }
        for (File content : dirContents) {
            String currPath = content.getAbsolutePath().replace(File.separator, "/");
            if (content.isDirectory() && this.getPathMatcher().matchStart(fullPattern, currPath + "/") && content.canRead()) {
                this.doRetrieveMatchingFiles(fullPattern, content, result);
            }
            if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
            result.add(content);
        }
    }
}

