/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.PackageElement;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.PackageNode;

@Internal
public class GroovyPackageElement
extends AbstractGroovyElement
implements PackageElement {
    private final PackageNode packageNode;

    public GroovyPackageElement(GroovyVisitorContext visitorContext, PackageNode packageNode, AnnotationMetadata annotationMetadata) {
        super(visitorContext, (AnnotatedNode)packageNode, annotationMetadata);
        this.packageNode = packageNode;
    }

    @NonNull
    public String getName() {
        String n = this.packageNode.getName();
        if (n.endsWith(".")) {
            return n.substring(0, n.length() - 1);
        }
        return n;
    }

    public String getSimpleName() {
        String name = this.getName();
        int index = name.lastIndexOf(".");
        if (index > -1) {
            return name.substring(index + 1);
        }
        return name;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPublic() {
        return true;
    }

    @NonNull
    public Object getNativeType() {
        return this.packageNode;
    }
}

