/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.remote.netty;

import groovyx.gpars.remote.BroadcastDiscovery;
import groovyx.gpars.remote.LocalHost;
import groovyx.gpars.remote.netty.NettyHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class NettyTransportProvider
extends LocalHost {
    private final Map<UUID, Client> clients = new HashMap<UUID, Client>();
    final Server server = new Server();
    final BroadcastDiscovery broadcastDiscovery;

    public NettyTransportProvider() {
        this.server.start(this);
        this.broadcastDiscovery = new BroadcastDiscovery(this.getId(), this.server.getAddress()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onDiscovery(UUID uuid, SocketAddress address) {
                if (uuid.equals(NettyTransportProvider.this.getId())) {
                    return;
                }
                Map map = NettyTransportProvider.this.clients;
                synchronized (map) {
                    Client client = (Client)NettyTransportProvider.this.clients.get(uuid);
                    if (client == null) {
                        NettyTransportProvider.this.clients.put(uuid, new Client(NettyTransportProvider.this, address, uuid));
                    }
                }
            }
        };
        this.broadcastDiscovery.start();
    }

    @Override
    public void disconnect() {
        this.broadcastDiscovery.stop();
        super.disconnect();
        this.server.stop();
        for (Client client : this.clients.values()) {
            client.stop();
        }
    }

    private static class MyThreadFactory
    implements ThreadFactory {
        static final MyThreadFactory instance = new MyThreadFactory();

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    e.printStackTrace();
                }
            });
            return thread;
        }
    }

    @ChannelHandler.Sharable
    public static class ClientHandler
    extends NettyHandler {
        private final UUID id;
        private final NettyTransportProvider provider;

        public ClientHandler(NettyTransportProvider provider, UUID id) {
            super(provider);
            this.id = id;
            this.provider = provider;
        }

        @Override
        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            this.provider.clients.remove(this.id);
            super.channelDisconnected(ctx, e);
        }
    }

    public static class ServerPipelineFactory
    implements ChannelPipelineFactory {
        private final NettyTransportProvider provider;

        public ServerPipelineFactory(NettyTransportProvider provider) {
            this.provider = provider;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("handler", (ChannelHandler)new NettyHandler(this.provider));
            return pipeline;
        }
    }

    public static class Client {
        private final NettyTransportProvider provider;
        final ChannelFuture channelFuture;
        final ChannelFactory factory;

        public Client(NettyTransportProvider provider, SocketAddress address, UUID id) {
            this.provider = provider;
            this.factory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(MyThreadFactory.instance), (Executor)Executors.newCachedThreadPool(MyThreadFactory.instance));
            ClientBootstrap bootstrap = new ClientBootstrap(this.factory);
            ClientHandler handler = new ClientHandler(this.provider, id);
            bootstrap.getPipeline().addLast("handler", (ChannelHandler)handler);
            bootstrap.setOption("tcpNoDelay", (Object)true);
            bootstrap.setOption("keepAlive", (Object)true);
            this.channelFuture = bootstrap.connect(address);
        }

        public void stop() {
            this.channelFuture.getChannel().close().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Client.this.factory.releaseExternalResources();
                }
            });
        }
    }

    public static class Server {
        private InetSocketAddress address;
        final ChannelFactory factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(MyThreadFactory.instance), (Executor)Executors.newCachedThreadPool(MyThreadFactory.instance));
        final ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
        Channel channel;
        private ServerPipelineFactory pipelineFactory;

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public void start(NettyTransportProvider provider) {
            InetAddress inetAddress;
            this.pipelineFactory = new ServerPipelineFactory(provider);
            this.bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFactory);
            this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
            this.bootstrap.setOption("child.keepAlive", (Object)true);
            this.channel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(0));
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                inetAddress = ((InetSocketAddress)this.channel.getLocalAddress()).getAddress();
            }
            this.address = new InetSocketAddress(inetAddress, ((InetSocketAddress)this.channel.getLocalAddress()).getPort());
        }

        public void stop() {
            final CountDownLatch latch = new CountDownLatch(1);
            this.channel.close().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Server.this.bootstrap.getFactory().releaseExternalResources();
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

