/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.render.gradient.Function;
import org.apache.fop.render.gradient.GradientMaker;

public class PDFFunction
extends PDFObject {
    private final Function function;
    private final List<PDFFunction> pdfFunctions;

    public PDFFunction(List<Double> domain, List<Double> range, float[] cZero, float[] cOne, double interpolationExponentN) {
        this(new Function(domain, range, cZero, cOne, interpolationExponentN));
    }

    public PDFFunction(Function function) {
        this(function, Collections.EMPTY_LIST);
    }

    public PDFFunction(Function function, List<PDFFunction> pdfFunctions) {
        this.function = function;
        this.pdfFunctions = pdfFunctions;
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public byte[] toPDF() {
        return this.toByteString();
    }

    public byte[] toByteString() {
        Function.SubFunctionRenderer subFunctionRenderer = new Function.SubFunctionRenderer(){

            @Override
            public void outputFunction(StringBuilder out, int functionIndex) {
                out.append(((PDFFunction)PDFFunction.this.pdfFunctions.get(functionIndex)).referencePDF());
            }
        };
        StringBuilder out = new StringBuilder();
        GradientMaker.DoubleFormatter doubleFormatter = new GradientMaker.DoubleFormatter(){

            @Override
            public String formatDouble(double d) {
                return PDFNumber.doubleOut(d);
            }
        };
        this.function.output(out, doubleFormatter, subFunctionRenderer);
        return PDFFunction.encode(out.toString());
    }

    @Override
    protected boolean contentEquals(PDFObject obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PDFFunction)) {
            return false;
        }
        Function func = ((PDFFunction)obj).function;
        if (this.function.getFunctionType() != func.getFunctionType()) {
            return false;
        }
        if (this.function.getBitsPerSample() != func.getBitsPerSample()) {
            return false;
        }
        if (this.function.getOrder() != func.getOrder()) {
            return false;
        }
        if (this.function.getInterpolationExponentN() != func.getInterpolationExponentN()) {
            return false;
        }
        if (this.function.getDomain() != null ? !this.function.getDomain().equals(func.getDomain()) : func.getDomain() != null) {
            return false;
        }
        if (this.function.getRange() != null ? !this.function.getRange().equals(func.getRange()) : func.getRange() != null) {
            return false;
        }
        if (this.function.getEncode() != null ? !this.function.getEncode().equals(func.getEncode()) : func.getEncode() != null) {
            return false;
        }
        if (!Arrays.equals(this.function.getCZero(), func.getCZero())) {
            return false;
        }
        if (!Arrays.equals(this.function.getCOne(), func.getCOne())) {
            return false;
        }
        if (!this.pdfFunctions.equals(((PDFFunction)obj).pdfFunctions)) {
            return false;
        }
        return !(this.function.getBounds() != null ? !this.function.getBounds().equals(func.getBounds()) : func.getBounds() != null);
    }
}

