/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.c.PAL;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Text;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.shape.AtomShape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Font;
import org.jmol.viewer.JC;

public class Labels
extends AtomShape {
    public String[] strings;
    public String[] formats;
    public short[] bgcolixes;
    public int[] fids;
    public int[] offsets;
    private Map<Integer, Text> atomLabels = new Hashtable<Integer, Text>();
    private Map<Integer, float[]> labelBoxes;
    public BS bsFontSet;
    public BS bsBgColixSet;
    public int defaultOffset;
    public int defaultAlignment;
    public int defaultZPos;
    public int defaultFontId;
    public short defaultColix;
    public short defaultBgcolix;
    public byte defaultPaletteID;
    public int defaultPointer;
    public int zeroFontId;
    private boolean setDefaults = false;
    private static final LabelToken[][] nullToken = new LabelToken[][]{null};
    private boolean isScaled;
    private float scalePixelsPerMicron;
    private P3 ptTemp = new P3();
    private int pickedAtom = -1;
    private int lastPicked = -1;
    private int pickedOffset = 0;
    private int pickedX;
    private int pickedY;

    @Override
    public void initShape() {
        this.defaultFontId = this.zeroFontId = this.vwr.gdata.getFont3DFSS((String)"SansSerif", (String)"Plain", (float)13.0f).fid;
        this.defaultColix = 0;
        this.defaultBgcolix = 0;
        this.defaultOffset = JC.LABEL_DEFAULT_OFFSET;
        this.defaultAlignment = 4;
        this.defaultPointer = 0;
        this.defaultZPos = 0;
        this.translucentAllowed = false;
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        this.isActive = true;
        Atom[] atoms = this.ms.at;
        int ac = this.ms.ac;
        if ("setDefaults" == propertyName) {
            this.setDefaults = (Boolean)value;
            return;
        }
        if ("color" == propertyName) {
            byte pid = PAL.pidOf(value);
            short colix = C.getColixO(value);
            if (this.setDefaults) {
                this.defaultColix = colix;
                this.defaultPaletteID = pid;
            } else {
                int n = this.checkColixLength(colix, bs.length());
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < n) {
                    this.setLabelColix(i, colix, pid);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if ("scalereference" == propertyName) {
            if (this.strings == null) {
                return;
            }
            float val = ((Float)value).floatValue();
            float scalePixelsPerMicron = val == 0.0f ? 0.0f : 10000.0f / val;
            int n = Math.min(ac, this.strings.length);
            int i = bs.nextSetBit(0);
            while (i >= 0 && i < n) {
                Text text = this.getLabel(i);
                if (text == null) {
                    text = Text.newLabel(this.vwr, null, this.strings[i], (short)0, (short)0, 0, scalePixelsPerMicron);
                    this.putLabel(i, text);
                } else {
                    text.setScalePixelsPerMicron(scalePixelsPerMicron);
                }
                i = bs.nextSetBit(i + 1);
            }
            return;
        }
        if ("label" == propertyName) {
            boolean isPicked = this.isPickingMode() && bs.cardinality() == 1 && bs.nextSetBit(0) == this.lastPicked;
            this.setScaling();
            LabelToken[][] tokens = null;
            int nbs = this.checkStringLength(bs.length());
            if (this.defaultColix != 0 || this.defaultPaletteID != 0) {
                this.checkColixLength(this.defaultColix, bs.length());
            }
            if (this.defaultBgcolix != 0) {
                this.checkBgColixLength(this.defaultBgcolix, bs.length());
            }
            if (value instanceof Lst) {
                Lst list = (Lst)value;
                int n = list.size();
                tokens = new LabelToken[][]{null};
                int pt = 0;
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < nbs) {
                    if (pt >= n) {
                        this.setLabel(nullToken, "", i, !isPicked);
                    } else {
                        tokens[0] = null;
                        this.setLabel(tokens, SV.sValue((T)list.get(pt++)), i, !isPicked);
                    }
                    i = bs.nextSetBit(i + 1);
                }
            } else {
                LabelToken[][] labelTokenArray;
                String strLabel = (String)value;
                if (strLabel == null || strLabel.length() == 0) {
                    labelTokenArray = nullToken;
                } else {
                    LabelToken[][] labelTokenArrayArray = new LabelToken[1][];
                    labelTokenArray = labelTokenArrayArray;
                    labelTokenArrayArray[0] = null;
                }
                tokens = labelTokenArray;
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < ac) {
                    this.setLabel(tokens, strLabel, i, !isPicked);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if (propertyName.startsWith("label:")) {
            this.setScaling();
            this.checkStringLength(ac);
            String label = propertyName.substring(6);
            if (label.length() == 0) {
                label = null;
            }
            this.setLabel(new LabelToken[][]{null}, label, ((Number)value).intValue(), false);
            return;
        }
        if ("clearBoxes" == propertyName) {
            this.labelBoxes = null;
            return;
        }
        if ("translucency" == propertyName || "bgtranslucency" == propertyName) {
            return;
        }
        if ("bgcolor" == propertyName) {
            this.isActive = true;
            if (this.bsBgColixSet == null) {
                this.bsBgColixSet = BS.newN(ac);
            }
            short bgcolix = C.getColixO(value);
            if (this.setDefaults) {
                this.defaultBgcolix = bgcolix;
            } else {
                int n = this.checkBgColixLength(bgcolix, bs.length());
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < n) {
                    this.setBgcolix(i, bgcolix);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if (this.bsFontSet == null) {
            this.bsFontSet = BS.newN(ac);
        }
        if ("fontsize" == propertyName) {
            int fontsize = (Integer)value;
            if (fontsize < 0) {
                this.fids = null;
                return;
            }
            if (this.setDefaults) {
                Font f = Font.getFont3D(this.defaultFontId);
                this.defaultFontId = this.vwr.getFont3D((String)f.fontFace, (String)f.fontStyle, (float)((float)fontsize)).fid;
            } else {
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < ac) {
                    Font f = Font.getFont3D(this.fids == null || i >= this.fids.length ? this.fids[i] : this.defaultFontId);
                    this.setFont(i, this.vwr.getFont3D((String)f.fontFace, (String)f.fontStyle, (float)((float)fontsize)).fid);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if ("font" == propertyName) {
            int fid = ((Font)value).fid;
            if (this.setDefaults) {
                this.defaultFontId = fid;
            } else {
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < ac) {
                    this.setFont(i, fid);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if ("offset" == propertyName) {
            if (value instanceof Integer) {
                int offset = (Integer)value;
                if (this.setDefaults) {
                    this.defaultOffset = offset;
                } else {
                    int i = bs.nextSetBit(0);
                    while (i >= 0 && i < ac) {
                        this.setOffsets(i, offset);
                        i = bs.nextSetBit(i + 1);
                    }
                }
            } else if (!this.setDefaults) {
                this.checkColixLength((short)-1, ac);
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < ac) {
                    this.setPymolOffset(i, (float[])value);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if ("align" == propertyName) {
            int hAlignment;
            String type = (String)value;
            int n = type.equalsIgnoreCase("right") ? 12 : (hAlignment = type.equalsIgnoreCase("center") ? 8 : 4);
            if (this.setDefaults) {
                this.defaultAlignment = hAlignment;
            } else {
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < ac) {
                    this.setHorizAlignment(i, hAlignment);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if ("pointer" == propertyName) {
            int pointer = (Integer)value;
            if (this.setDefaults) {
                this.defaultPointer = pointer;
            } else {
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < ac) {
                    this.setPointer(i, pointer);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if ("front" == propertyName) {
            boolean TF = (Boolean)value;
            if (this.setDefaults) {
                this.defaultZPos = TF ? 32 : 0;
            } else {
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < ac) {
                    this.setZPos(i, 32, TF);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if ("group" == propertyName) {
            boolean TF = (Boolean)value;
            if (this.setDefaults) {
                this.defaultZPos = TF ? 16 : 0;
            } else {
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < ac) {
                    this.setZPos(i, 16, TF);
                    i = bs.nextSetBit(i + 1);
                }
            }
            return;
        }
        if ("display" == propertyName || "toggleLabel" == propertyName) {
            int mode;
            int n = "toggleLabel" == propertyName ? 0 : (mode = (Boolean)value != false ? 1 : -1);
            if (this.mads == null) {
                this.mads = new short[ac];
            }
            String strLabelPDB = null;
            LabelToken[] tokensPDB = null;
            String strLabelUNK = null;
            LabelToken[] tokensUNK = null;
            int nstr = this.checkStringLength(bs.length());
            short bgcolix = this.defaultBgcolix;
            int nbg = this.checkBgColixLength(bgcolix, bs.length());
            short thisMad = (short)(mode >= 0 ? 1 : -1);
            int i = bs.nextSetBit(0);
            while (i >= 0 && i < ac) {
                Atom atom = atoms[i];
                if (i < nstr && this.strings[i] != null) {
                    this.mads[i] = (short)(mode == 1 || mode == 0 && this.mads[i] < 0 ? 1 : -1);
                } else {
                    LabelToken[] tokens;
                    String strLabel;
                    this.mads[i] = thisMad;
                    if (atom.getGroup3(false).equals("UNK")) {
                        if (strLabelUNK == null) {
                            strLabelUNK = this.vwr.getStandardLabelFormat(1);
                            tokensUNK = LabelToken.compile(this.vwr, strLabelUNK, '\u0000', null);
                        }
                        strLabel = strLabelUNK;
                        tokens = tokensUNK;
                    } else {
                        if (strLabelPDB == null) {
                            strLabelPDB = this.vwr.getStandardLabelFormat(2);
                            tokensPDB = LabelToken.compile(this.vwr, strLabelPDB, '\u0000', null);
                        }
                        strLabel = strLabelPDB;
                        tokens = tokensPDB;
                    }
                    this.strings[i] = LabelToken.formatLabelAtomArray(this.vwr, atom, tokens, '\u0000', null, this.ptTemp);
                    this.formats[i] = strLabel;
                    this.bsSizeSet.set(i);
                    if (i < nbg && !this.bsBgColixSet.get(i)) {
                        this.setBgcolix(i, this.defaultBgcolix);
                    }
                }
                atom.setShapeVisibility(this.vf, this.strings != null && i < this.strings.length && this.strings[i] != null && this.mads[i] >= 0);
                i = bs.nextSetBit(i + 1);
            }
            return;
        }
        if ("pymolLabels" == propertyName) {
            this.setPymolLabels((Map)value, bs);
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            this.labelBoxes = null;
            int firstAtomDeleted = ((int[])((Object[])value)[2])[1];
            int nAtomsDeleted = ((int[])((Object[])value)[2])[2];
            this.fids = (int[])AU.deleteElements(this.fids, firstAtomDeleted, nAtomsDeleted);
            this.bgcolixes = (short[])AU.deleteElements(this.bgcolixes, firstAtomDeleted, nAtomsDeleted);
            this.offsets = (int[])AU.deleteElements(this.offsets, firstAtomDeleted, nAtomsDeleted);
            this.formats = (String[])AU.deleteElements(this.formats, firstAtomDeleted, nAtomsDeleted);
            this.strings = (String[])AU.deleteElements(this.strings, firstAtomDeleted, nAtomsDeleted);
            BSUtil.deleteBits(this.bsFontSet, bs);
            BSUtil.deleteBits(this.bsBgColixSet, bs);
        }
        this.setPropAS(propertyName, value, bs);
    }

    private boolean isPickingMode() {
        return this.vwr.getPickingMode() == 2 && this.labelBoxes != null;
    }

    private int checkStringLength(int n) {
        int ac = this.ms.ac;
        n = Math.min(ac, n);
        if (this.strings == null || n > this.strings.length) {
            this.formats = AU.ensureLengthS(this.formats, n);
            this.strings = AU.ensureLengthS(this.strings, n);
            if (this.bsSizeSet == null) {
                this.bsSizeSet = BS.newN(n);
            }
        }
        return n;
    }

    private int checkBgColixLength(short colix, int n) {
        n = Math.min(this.ms.ac, n);
        if (colix == 0) {
            return this.bgcolixes == null ? 0 : this.bgcolixes.length;
        }
        if (this.bgcolixes == null || n > this.bgcolixes.length) {
            this.bgcolixes = AU.ensureLengthShort(this.bgcolixes, n);
        }
        return n;
    }

    private void setPymolLabels(Map<Integer, Text> labels, BS bsSelected) {
        this.setScaling();
        int n = this.checkStringLength(this.ms.ac);
        this.checkColixLength((short)-1, n);
        int i = bsSelected.nextSetBit(0);
        while (i >= 0 && i < n) {
            this.setPymolLabel(i, labels.get(i), null);
            i = bsSelected.nextSetBit(i + 1);
        }
    }

    private void setPymolOffset(int i, float[] value) {
        Text text = this.getLabel(i);
        if (text == null) {
            int fid;
            if (this.strings == null || i >= this.strings.length || this.strings[i] == null) {
                return;
            }
            int n = fid = this.bsFontSet != null && this.bsFontSet.get(i) ? this.fids[i] : -1;
            if (fid < 0) {
                fid = this.defaultFontId;
                this.setFont(i, fid);
            }
            Atom a = this.ms.at[i];
            text = Text.newLabel(this.vwr, Font.getFont3D(fid), this.strings[i], this.getColix2(i, a, false), this.getColix2(i, a, true), 0, this.scalePixelsPerMicron);
            this.setPymolLabel(i, text, this.formats[i]);
        }
        text.pymolOffset = value;
    }

    private void setScaling() {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = BS.newN(this.ms.ac);
        }
        this.isScaled = this.vwr.getBoolean(603979847);
        this.scalePixelsPerMicron = this.isScaled ? this.vwr.getScalePixelsPerAngstrom(false) * 10000.0f : 0.0f;
    }

    private void setPymolLabel(int i, Text t, String format) {
        if (t == null) {
            return;
        }
        String label = t.text;
        Atom atom = this.ms.at[i];
        if (atom == null) {
            return;
        }
        this.addString(atom, i, label, format == null ? PT.rep(label, "%", "%%") : format);
        atom.setShapeVisibility(this.vf, true);
        if (t.colix >= 0) {
            this.setLabelColix(i, t.colix, PAL.UNKNOWN.id);
        }
        this.setFont(i, t.font.fid);
        this.putLabel(i, t);
    }

    private void setLabel(LabelToken[][] temp, String strLabel, int i, boolean doAll) {
        Atom atom = this.ms.at[i];
        LabelToken[] tokens = temp[0];
        if (tokens == null) {
            temp[0] = LabelToken.compile(this.vwr, strLabel, '\u0000', null);
            tokens = temp[0];
        }
        String label = tokens == null ? null : LabelToken.formatLabelAtomArray(this.vwr, atom, tokens, '\u0000', null, this.ptTemp);
        boolean isNew = this.addString(atom, i, label, strLabel);
        Text text = this.getLabel(i);
        if (this.isScaled && (doAll |= isNew || label == null)) {
            text = Text.newLabel(this.vwr, null, label, (short)0, (short)0, 0, this.scalePixelsPerMicron);
            this.putLabel(i, text);
        } else if (text != null) {
            if (label == null) {
                this.putLabel(i, null);
            } else {
                text.setText(label);
                text.textUnformatted = strLabel;
            }
        }
        if (!doAll) {
            return;
        }
        if (this.defaultOffset != JC.LABEL_DEFAULT_OFFSET) {
            this.setOffsets(i, this.defaultOffset);
        }
        if (this.defaultAlignment != 4) {
            this.setHorizAlignment(i, this.defaultAlignment);
        }
        if ((this.defaultZPos & 0x20) != 0) {
            this.setZPos(i, 32, true);
        } else if ((this.defaultZPos & 0x10) != 0) {
            this.setZPos(i, 16, true);
        }
        if (this.defaultPointer != 0) {
            this.setPointer(i, this.defaultPointer);
        }
        if (this.defaultColix != 0 || this.defaultPaletteID != 0) {
            this.setLabelColix(i, this.defaultColix, this.defaultPaletteID);
        }
        if (this.defaultBgcolix != 0) {
            this.setBgcolix(i, this.defaultBgcolix);
        }
        if (this.defaultFontId != this.zeroFontId) {
            this.setFont(i, this.defaultFontId);
        }
    }

    private boolean addString(Atom atom, int i, String label, String strLabel) {
        atom.setShapeVisibility(this.vf, label != null);
        boolean notNull = strLabel != null;
        boolean isNew = this.strings[i] == null;
        this.strings[i] = label;
        this.formats[i] = notNull && strLabel.indexOf("%{") >= 0 ? label : strLabel;
        this.bsSizeSet.setBitTo(i, notNull);
        return isNew;
    }

    @Override
    public Object getProperty(String property, int index) {
        if (property.equals("font")) {
            return Font.getFont3D(this.defaultFontId);
        }
        if (property.equals("offsets")) {
            return this.offsets;
        }
        if (property.equals("label")) {
            return this.strings != null && index < this.strings.length && this.strings[index] != null ? this.strings[index] : "";
        }
        return null;
    }

    public void putLabel(int i, Text text) {
        if (text == null) {
            this.atomLabels.remove(i);
        } else {
            this.atomLabels.put(i, text);
            text.textUnformatted = this.formats[i];
        }
    }

    public Text getLabel(int i) {
        return this.atomLabels.get(i);
    }

    public void putBox(int i, float[] boxXY) {
        if (this.labelBoxes == null) {
            this.labelBoxes = new Hashtable<Integer, float[]>();
        }
        this.labelBoxes.put(i, boxXY);
    }

    public float[] getBox(int i) {
        if (this.labelBoxes == null) {
            return null;
        }
        return this.labelBoxes.get(i);
    }

    private void setLabelColix(int i, short colix, byte pid) {
        Text text;
        this.setColixAndPalette(colix, pid, i);
        if (this.colixes != null && (text = this.getLabel(i)) != null) {
            text.colix = this.colixes[i];
        }
    }

    private void setBgcolix(int i, short bgcolix) {
        this.bgcolixes[i] = bgcolix;
        this.bsBgColixSet.setBitTo(i, bgcolix != 0);
        Text text = this.getLabel(i);
        if (text != null) {
            text.bgcolix = bgcolix;
        }
    }

    private void setOffsets(int i, int offset) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (offset == JC.LABEL_DEFAULT_OFFSET) {
                return;
            }
            this.offsets = AU.ensureLengthI(this.offsets, this.ms.ac);
        }
        this.offsets[i] = this.offsets[i] & 0x3F | offset;
        Text text = this.getLabel(i);
        if (text != null) {
            text.setOffset(offset);
        }
    }

    private void setHorizAlignment(int i, int hAlign) {
        if (this.offsets == null || i >= this.offsets.length) {
            switch (hAlign) {
                case 0: 
                case 4: {
                    return;
                }
            }
            this.offsets = AU.ensureLengthI(this.offsets, this.ms.ac);
        }
        if (hAlign == 0) {
            hAlign = 4;
        }
        this.offsets[i] = JC.setHorizAlignment(this.offsets[i], hAlign);
        Text text = this.getLabel(i);
        if (text != null) {
            text.setAlignment(hAlign);
        }
    }

    private void setPointer(int i, int pointer) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (pointer == 0) {
                return;
            }
            this.offsets = AU.ensureLengthI(this.offsets, this.ms.ac);
        }
        this.offsets[i] = JC.setPointer(this.offsets[i], pointer);
        Text text = this.getLabel(i);
        if (text != null) {
            text.pointer = pointer;
        }
    }

    private void setZPos(int i, int flag, boolean TF) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (!TF) {
                return;
            }
            this.offsets = AU.ensureLengthI(this.offsets, this.ms.ac);
        }
        this.offsets[i] = JC.setZPosition(this.offsets[i], TF ? flag : 0);
    }

    private void setFont(int i, int fid) {
        if (this.fids == null || i >= this.fids.length) {
            if (fid == this.zeroFontId) {
                return;
            }
            this.fids = AU.ensureLengthI(this.fids, this.ms.ac);
        }
        this.fids[i] = fid;
        this.bsFontSet.set(i);
        Text text = this.getLabel(i);
        if (text != null) {
            text.setFontFromFid(fid);
        }
    }

    @Override
    public void setAtomClickability() {
        if (this.strings == null) {
            return;
        }
        int i = this.strings.length;
        while (--i >= 0) {
            String label = this.strings[i];
            if (label == null || this.ms.at.length <= i || this.ms.at[i] == null || this.ms.isAtomHidden(i)) continue;
            this.ms.at[i].setClickable(this.vf);
        }
    }

    @Override
    public Map<String, Object> checkObjectClicked(int x, int y, int modifiers, BS bsVisible, boolean drawPicking) {
        if (!this.isPickingMode()) {
            return null;
        }
        int iAtom = this.findNearestLabel(x, y);
        if (iAtom < 0) {
            return null;
        }
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        map.put("type", "label");
        map.put("atomIndex", iAtom);
        this.lastPicked = iAtom;
        return map;
    }

    @Override
    public synchronized boolean checkObjectDragged(int prevX, int prevY, int x, int y, int dragAction, BS bsVisible) {
        if (!this.isPickingMode()) {
            return false;
        }
        if (prevX == Integer.MIN_VALUE) {
            int iAtom = this.findNearestLabel(x, y);
            if (iAtom >= 0) {
                this.lastPicked = this.pickedAtom = iAtom;
                this.vwr.acm.setDragAtomIndex(iAtom);
                this.pickedX = x;
                this.pickedY = y;
                this.pickedOffset = this.offsets == null || this.pickedAtom >= this.offsets.length ? JC.LABEL_DEFAULT_OFFSET : this.offsets[this.pickedAtom];
                return true;
            }
            return false;
        }
        if (prevX == Integer.MAX_VALUE) {
            this.pickedAtom = -1;
        }
        if (this.pickedAtom < 0) {
            return false;
        }
        this.move2D(this.pickedAtom, x, y);
        return true;
    }

    private int findNearestLabel(int x, int y) {
        if (this.labelBoxes == null) {
            return -1;
        }
        float dmin = Float.MAX_VALUE;
        int imin = -1;
        float zmin = Float.MAX_VALUE;
        float afactor = this.vwr.antialiased ? 2 : 1;
        Atom[] atoms = this.ms.at;
        for (Map.Entry<Integer, float[]> entry : this.labelBoxes.entrySet()) {
            if (!atoms[entry.getKey()].isVisible(this.vf | 9)) continue;
            float[] boxXY = entry.getValue();
            float dx = ((float)x - boxXY[0]) * afactor;
            float dy = ((float)y - boxXY[1]) * afactor;
            if (dx <= 0.0f || dy <= 0.0f || dx >= boxXY[2] || dy >= boxXY[3] || boxXY[4] > zmin) continue;
            zmin = boxXY[4];
            float d = Math.min(Math.abs(dx - boxXY[2] / 2.0f), Math.abs(dy - boxXY[3] / 2.0f));
            if (!(d <= dmin)) continue;
            dmin = d;
            imin = entry.getKey();
        }
        return imin;
    }

    private void move2D(int pickedAtom, int x, int y) {
        int xOffset = JC.getXOffset(this.pickedOffset);
        int yOffset = JC.getYOffset(this.pickedOffset);
        int offset = JC.getOffset(xOffset += x - this.pickedX, yOffset -= y - this.pickedY, true);
        this.setOffsets(pickedAtom, offset);
    }

    public short getColix2(int i, Atom atom, boolean isBg) {
        short colix;
        if (isBg) {
            colix = this.bgcolixes == null || i >= this.bgcolixes.length ? (short)0 : this.bgcolixes[i];
        } else {
            colix = this.colixes == null || i >= this.colixes.length ? (short)0 : this.colixes[i];
            if (C.isColixTranslucent(colix = C.getColixInherited(colix, atom.colixAtom))) {
                colix = C.getColixTranslucent3(colix, false, 0.0f);
            }
        }
        return colix;
    }
}

