/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.PsiTypeAnnotationCollector;
import org.jetbrains.kotlin.codegen.TypePathInfo;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

public abstract class AnnotationCodegen {
    public static final List<JvmFlagAnnotation> FIELD_FLAGS = Arrays.asList(new JvmFlagAnnotation(JvmStandardClassIds.VOLATILE_ANNOTATION_FQ_NAME.asString(), 64), new JvmFlagAnnotation(JvmStandardClassIds.TRANSIENT_ANNOTATION_FQ_NAME.asString(), 128));
    public static final List<JvmFlagAnnotation> METHOD_FLAGS = Arrays.asList(new JvmFlagAnnotation(JvmStandardClassIds.STRICTFP_ANNOTATION_FQ_NAME.asString(), 2048), new JvmFlagAnnotation(JvmStandardClassIds.SYNCHRONIZED_ANNOTATION_FQ_NAME.asString(), 32));
    private static final AnnotationVisitor NO_ANNOTATION_VISITOR = new AnnotationVisitor(589824){

        @Override
        public AnnotationVisitor visitAnnotation(String name2, @NotNull String desc) {
            if (desc == null) {
                1.$$$reportNull$$$0(0);
            }
            return AnnotationCodegen.safe(super.visitAnnotation(name2, desc));
        }

        @Override
        public AnnotationVisitor visitArray(String name2) {
            return AnnotationCodegen.safe(super.visitArray(name2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/AnnotationCodegen$1", "visitAnnotation"));
        }
    };
    private final InnerClassConsumer innerClassConsumer;
    private final KotlinTypeMapper typeMapper;
    private final ModuleDescriptor module;
    private final GenerationState state;
    private final boolean skipNullabilityAnnotations;
    private static final Map<KotlinTarget, ElementType> annotationTargetMap = new EnumMap<KotlinTarget, ElementType>(KotlinTarget.class);
    private static final Map<KotlinRetention, RetentionPolicy> annotationRetentionMap;

    private AnnotationCodegen(@NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state) {
        if (innerClassConsumer == null) {
            AnnotationCodegen.$$$reportNull$$$0(0);
        }
        if (state == null) {
            AnnotationCodegen.$$$reportNull$$$0(1);
        }
        this(innerClassConsumer, state, false);
    }

    private AnnotationCodegen(@NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state, boolean skipNullabilityAnnotations) {
        if (innerClassConsumer == null) {
            AnnotationCodegen.$$$reportNull$$$0(2);
        }
        if (state == null) {
            AnnotationCodegen.$$$reportNull$$$0(3);
        }
        this.innerClassConsumer = innerClassConsumer;
        this.typeMapper = state.getTypeMapper();
        this.module = state.getModule();
        this.state = state;
        this.skipNullabilityAnnotations = skipNullabilityAnnotations;
    }

    public void genAnnotations(@Nullable Annotated annotated, @Nullable Type returnType, @Nullable KotlinType typeForTypeAnnotations) {
        this.genAnnotations(annotated, returnType, typeForTypeAnnotations, null, Collections.emptyList());
    }

    public void genAnnotations(@Nullable Annotated annotated, @Nullable Type returnType, @Nullable KotlinType typeForTypeAnnotations, @Nullable DeclarationDescriptorWithVisibility parameterContainer, @NotNull List<String> additionalVisibleAnnotations) {
        if (additionalVisibleAnnotations == null) {
            AnnotationCodegen.$$$reportNull$$$0(4);
        }
        if (annotated == null) {
            return;
        }
        HashSet<String> annotationDescriptorsAlreadyPresent = new HashSet<String>();
        Annotations annotations2 = annotated.getAnnotations();
        for (AnnotationDescriptor annotationDescriptor : annotations2) {
            ClassDescriptor classDescriptor;
            Set<KotlinTarget> applicableTargets = AnnotationChecker.applicableTargetSet(annotationDescriptor);
            if (annotated instanceof AnonymousFunctionDescriptor && !applicableTargets.contains((Object)KotlinTarget.FUNCTION) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_SETTER)) {
                assert (applicableTargets.contains((Object)KotlinTarget.EXPRESSION)) : "Inconsistent target list for lambda annotation: " + applicableTargets + " on " + annotated;
                continue;
            }
            if (annotated instanceof ClassDescriptor && !applicableTargets.contains((Object)KotlinTarget.CLASS) && !applicableTargets.contains((Object)KotlinTarget.ANNOTATION_CLASS) && (classDescriptor = (ClassDescriptor)annotated).getVisibility() == DescriptorVisibilities.LOCAL) {
                assert (applicableTargets.contains((Object)KotlinTarget.EXPRESSION)) : "Inconsistent target list for object literal annotation: " + applicableTargets + " on " + annotated;
                continue;
            }
            String descriptor = this.genAnnotation(annotationDescriptor, null, false);
            if (descriptor == null) continue;
            annotationDescriptorsAlreadyPresent.add(descriptor);
        }
        for (String string2 : additionalVisibleAnnotations) {
            this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, string2, true);
            annotationDescriptorsAlreadyPresent.add(string2);
        }
        this.generateAdditionalAnnotations(annotated, returnType, annotationDescriptorsAlreadyPresent, parameterContainer);
        this.generateTypeAnnotations(annotated, typeForTypeAnnotations);
    }

    private void generateAdditionalAnnotations(@NotNull Annotated annotated, @Nullable Type returnType, @NotNull Set<String> annotationDescriptorsAlreadyPresent, @Nullable DeclarationDescriptorWithVisibility parameterContainer) {
        if (annotated == null) {
            AnnotationCodegen.$$$reportNull$$$0(5);
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            AnnotationCodegen.$$$reportNull$$$0(6);
        }
        if (annotated instanceof CallableDescriptor) {
            this.generateAdditionalCallableAnnotations((CallableDescriptor)annotated, returnType, annotationDescriptorsAlreadyPresent, parameterContainer);
        } else if (annotated instanceof FieldDescriptor) {
            this.generateAdditionalCallableAnnotations(((FieldDescriptor)annotated).getCorrespondingProperty(), returnType, annotationDescriptorsAlreadyPresent, parameterContainer);
        } else if (annotated instanceof ClassDescriptor) {
            this.generateAdditionalClassAnnotations(annotationDescriptorsAlreadyPresent, (ClassDescriptor)annotated);
        }
    }

    private void generateAdditionalCallableAnnotations(@NotNull CallableDescriptor descriptor, @Nullable Type returnType, @NotNull Set<String> annotationDescriptorsAlreadyPresent, @Nullable DeclarationDescriptorWithVisibility parameterContainer) {
        if (descriptor == null) {
            AnnotationCodegen.$$$reportNull$$$0(7);
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            AnnotationCodegen.$$$reportNull$$$0(8);
        }
        if (AnnotationCodegen.isInvisibleFromTheOutside(descriptor)) {
            return;
        }
        if (descriptor instanceof ParameterDescriptor && AnnotationCodegen.isInvisibleFromTheOutside(parameterContainer != null ? parameterContainer : descriptor.getContainingDeclaration())) {
            return;
        }
        if (descriptor instanceof PropertyGetterDescriptor && DescriptorUtils.isAnnotationClass(descriptor.getContainingDeclaration())) {
            return;
        }
        if (returnType != null && !AsmUtil.isPrimitive(returnType) && !this.skipNullabilityAnnotations) {
            this.generateNullabilityAnnotation(descriptor.getReturnType(), annotationDescriptorsAlreadyPresent);
        }
    }

    private void generateAdditionalClassAnnotations(@NotNull Set<String> annotationDescriptorsAlreadyPresent, @NotNull ClassDescriptor descriptor) {
        if (annotationDescriptorsAlreadyPresent == null) {
            AnnotationCodegen.$$$reportNull$$$0(9);
        }
        if (descriptor == null) {
            AnnotationCodegen.$$$reportNull$$$0(10);
        }
        if (descriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            this.generateDocumentedAnnotation(descriptor, annotationDescriptorsAlreadyPresent);
            this.generateRetentionAnnotation(descriptor, annotationDescriptorsAlreadyPresent);
            this.generateTargetAnnotation(descriptor, annotationDescriptorsAlreadyPresent);
        }
    }

    private static boolean isInvisibleFromTheOutside(@Nullable DeclarationDescriptor descriptor) {
        if (AnnotationCodegen.isAccessor(descriptor)) {
            return true;
        }
        if (descriptor instanceof MemberDescriptor) {
            return DescriptorAsmUtil.getVisibilityAccessFlag((MemberDescriptor)descriptor) == 2;
        }
        return false;
    }

    private static boolean isAccessor(@Nullable Annotated descriptor) {
        return descriptor instanceof CallableMemberDescriptor && KotlinTypeMapper.isAccessor((CallableMemberDescriptor)descriptor);
    }

    private void generateNullabilityAnnotation(@Nullable KotlinType type2, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        FlexibleType flexibleType;
        if (annotationDescriptorsAlreadyPresent == null) {
            AnnotationCodegen.$$$reportNull$$$0(11);
        }
        if (type2 == null) {
            return;
        }
        if (AnnotationCodegen.isBareTypeParameterWithNullableUpperBound(type2)) {
            return;
        }
        if (FlexibleTypesKt.isFlexible(type2) && !TypeUtils.isNullableType((flexibleType = FlexibleTypesKt.asFlexibleType(type2)).getLowerBound()) && TypeUtils.isNullableType(flexibleType.getUpperBound())) {
            AnnotationDescriptor notNull = type2.getAnnotations().findAnnotation(JvmAnnotationNames.JETBRAINS_NOT_NULL_ANNOTATION);
            if (notNull != null) {
                this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, Type.getType(NotNull.class).getDescriptor(), false);
            }
            return;
        }
        this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, TypeUtils.isNullableType(type2) ? Type.getType(Nullable.class).getDescriptor() : Type.getType(NotNull.class).getDescriptor(), false);
    }

    private void generateTargetAnnotation(@NotNull ClassDescriptor classDescriptor, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        Set<ElementType> javaTargets;
        String descriptor;
        if (classDescriptor == null) {
            AnnotationCodegen.$$$reportNull$$$0(12);
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            AnnotationCodegen.$$$reportNull$$$0(13);
        }
        if (!annotationDescriptorsAlreadyPresent.add(descriptor = Type.getType(Target.class).getDescriptor())) {
            return;
        }
        Set<KotlinTarget> targets = AnnotationChecker.Companion.applicableTargetSetFromTargetAnnotationOrNull(classDescriptor);
        if (targets == null) {
            javaTargets = AnnotationCodegen.getJavaTargetList(classDescriptor);
            if (javaTargets == null) {
                return;
            }
        } else {
            javaTargets = EnumSet.noneOf(ElementType.class);
            for (KotlinTarget target : targets) {
                ElementType elementType = annotationTargetMap.get((Object)target);
                if (elementType == null) continue;
                javaTargets.add(elementType);
            }
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(descriptor, true);
        AnnotationVisitor arrayVisitor = visitor2.visitArray("value");
        for (ElementType javaTarget : javaTargets) {
            arrayVisitor.visitEnum(null, Type.getType(ElementType.class).getDescriptor(), javaTarget.name());
        }
        arrayVisitor.visitEnd();
        visitor2.visitEnd();
    }

    private void generateRetentionAnnotation(@NotNull ClassDescriptor classDescriptor, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        if (classDescriptor == null) {
            AnnotationCodegen.$$$reportNull$$$0(14);
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            AnnotationCodegen.$$$reportNull$$$0(15);
        }
        RetentionPolicy policy = AnnotationCodegen.getRetentionPolicy(classDescriptor);
        String descriptor = Type.getType(Retention.class).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.add(descriptor)) {
            return;
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(descriptor, true);
        visitor2.visitEnum("value", Type.getType(RetentionPolicy.class).getDescriptor(), policy.name());
        visitor2.visitEnd();
    }

    private void generateDocumentedAnnotation(@NotNull ClassDescriptor classDescriptor, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        boolean documented;
        if (classDescriptor == null) {
            AnnotationCodegen.$$$reportNull$$$0(16);
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            AnnotationCodegen.$$$reportNull$$$0(17);
        }
        if (!(documented = DescriptorUtilsKt.isDocumentedAnnotation(classDescriptor))) {
            return;
        }
        String descriptor = Type.getType(Documented.class).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.add(descriptor)) {
            return;
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(descriptor, true);
        visitor2.visitEnd();
    }

    private void generateAnnotationIfNotPresent(Set<String> annotationDescriptorsAlreadyPresent, String annotationDescriptor, boolean visible) {
        if (!annotationDescriptorsAlreadyPresent.contains(annotationDescriptor)) {
            this.visitAnnotation(annotationDescriptor, visible).visitEnd();
        }
    }

    private static boolean isBareTypeParameterWithNullableUpperBound(@NotNull KotlinType type2) {
        if (type2 == null) {
            AnnotationCodegen.$$$reportNull$$$0(18);
        }
        ClassifierDescriptor classifier = type2.getConstructor().getDeclarationDescriptor();
        return !type2.isMarkedNullable() && classifier instanceof TypeParameterDescriptor && TypeUtils.hasNullableSuperType(type2);
    }

    public void generateAnnotationDefaultValue(@NotNull ConstantValue<?> value2, @NotNull KotlinType expectedType) {
        if (value2 == null) {
            AnnotationCodegen.$$$reportNull$$$0(19);
        }
        if (expectedType == null) {
            AnnotationCodegen.$$$reportNull$$$0(20);
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(null, false);
        this.genCompileTimeValue(null, value2, visitor2);
        visitor2.visitEnd();
    }

    @Nullable
    private String genAnnotation(@NotNull AnnotationDescriptor annotationDescriptor, @Nullable TypePath path, boolean isTypeAnnotation) {
        if (annotationDescriptor == null) {
            AnnotationCodegen.$$$reportNull$$$0(21);
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        assert (classDescriptor != null) : "Annotation descriptor has no class: " + annotationDescriptor;
        RetentionPolicy rp = AnnotationCodegen.getRetentionPolicy(classDescriptor);
        if (rp == RetentionPolicy.SOURCE && !this.typeMapper.getClassBuilderMode().generateSourceRetentionAnnotations) {
            return null;
        }
        if (OptionalAnnotationUtil.isOptionalAnnotationClass(classDescriptor)) {
            return null;
        }
        this.innerClassConsumer.addInnerClassInfoFromAnnotation(classDescriptor);
        String asmTypeDescriptor = this.typeMapper.mapType(annotationDescriptor.getType()).getDescriptor();
        AnnotationVisitor annotationVisitor = isTypeAnnotation ? this.visitTypeAnnotation(asmTypeDescriptor, path, rp == RetentionPolicy.RUNTIME) : this.visitAnnotation(asmTypeDescriptor, rp == RetentionPolicy.RUNTIME);
        this.genAnnotationArguments(annotationDescriptor, annotationVisitor);
        annotationVisitor.visitEnd();
        return asmTypeDescriptor;
    }

    private void genAnnotationArguments(AnnotationDescriptor annotationDescriptor, AnnotationVisitor annotationVisitor) {
        ClassDescriptor annotationClass = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        for (Map.Entry<Name, ConstantValue<?>> entry : annotationDescriptor.getAllValueArguments().entrySet()) {
            this.genCompileTimeValue(this.getAnnotationArgumentJvmName(annotationClass, entry.getKey()), entry.getValue(), annotationVisitor);
        }
    }

    private String getAnnotationArgumentJvmName(@Nullable ClassDescriptor annotationClass, @NotNull Name parameterName) {
        if (parameterName == null) {
            AnnotationCodegen.$$$reportNull$$$0(22);
        }
        if (annotationClass == null) {
            return parameterName.asString();
        }
        Collection<? extends PropertyDescriptor> variables2 = annotationClass.getUnsubstitutedMemberScope().getContributedVariables(parameterName, NoLookupLocation.FROM_BACKEND);
        if (variables2.size() != 1) {
            return parameterName.asString();
        }
        return this.typeMapper.mapAnnotationParameterName(variables2.iterator().next());
    }

    private void genCompileTimeValue(final @Nullable String name2, @NotNull ConstantValue<?> value2, final @NotNull AnnotationVisitor annotationVisitor) {
        if (value2 == null) {
            AnnotationCodegen.$$$reportNull$$$0(23);
        }
        if (annotationVisitor == null) {
            AnnotationCodegen.$$$reportNull$$$0(24);
        }
        AnnotationArgumentVisitor<Void, Void> argumentVisitor = new AnnotationArgumentVisitor<Void, Void>(){

            @Override
            public Void visitLongValue(@NotNull LongValue value2, Void data) {
                if (value2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitIntValue(IntValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitShortValue(ShortValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitByteValue(ByteValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitDoubleValue(DoubleValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitFloatValue(FloatValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitBooleanValue(BooleanValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitCharValue(CharValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitStringValue(StringValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitEnumValue(EnumValue value2, Void data) {
                ClassId enumClassId = value2.getEnumClassId();
                String enumClassInternalName = AsmUtil.asmTypeByClassId(enumClassId).getDescriptor();
                String enumEntryName = value2.getEnumEntryName().asString();
                ClassDescriptor descriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(AnnotationCodegen.this.state.getModule(), enumClassId);
                if (descriptor != null) {
                    AnnotationCodegen.this.innerClassConsumer.addInnerClassInfoFromAnnotation(descriptor);
                }
                annotationVisitor.visitEnum(name2, enumClassInternalName, enumEntryName);
                return null;
            }

            @Override
            public Void visitArrayValue(ArrayValue value2, Void data) {
                AnnotationVisitor visitor2 = annotationVisitor.visitArray(name2);
                for (ConstantValue argument : (List)value2.getValue()) {
                    AnnotationCodegen.this.genCompileTimeValue(null, argument, visitor2);
                }
                visitor2.visitEnd();
                return null;
            }

            @Override
            public Void visitAnnotationValue(AnnotationValue value2, Void data) {
                KotlinType classType = ((AnnotationDescriptor)value2.getValue()).getType();
                AnnotationCodegen.this.innerClassConsumer.addInnerClassInfoFromAnnotation(DescriptorUtils.getClassDescriptorForType(classType));
                AnnotationVisitor visitor2 = annotationVisitor.visitAnnotation(name2, AnnotationCodegen.this.typeMapper.mapType(classType).getDescriptor());
                AnnotationCodegen.this.genAnnotationArguments((AnnotationDescriptor)value2.getValue(), visitor2);
                visitor2.visitEnd();
                return null;
            }

            @Override
            public Void visitKClassValue(KClassValue value2, Void data) {
                KotlinType classType = value2.getArgumentType(AnnotationCodegen.this.module);
                AnnotationCodegen.this.innerClassConsumer.addInnerClassInfoFromAnnotation(DescriptorUtils.getClassDescriptorForType(classType));
                if (InlineClassesUtilsKt.isInlineClassType(classType)) {
                    classType = TypeUtils.makeNullable(classType);
                }
                annotationVisitor.visit(name2, AnnotationCodegen.this.typeMapper.mapType(classType));
                return null;
            }

            @Override
            public Void visitUByteValue(UByteValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitUShortValue(UShortValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitUIntValue(UIntValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            @Override
            public Void visitULongValue(ULongValue value2, Void data) {
                return this.visitSimpleValue(value2);
            }

            private Void visitSimpleValue(ConstantValue<?> value2) {
                annotationVisitor.visit(name2, value2.getValue());
                return null;
            }

            @Override
            public Void visitErrorValue(ErrorValue value2, Void data) {
                return this.visitUnsupportedValue(value2);
            }

            @Override
            public Void visitNullValue(NullValue value2, Void data) {
                return this.visitUnsupportedValue(value2);
            }

            private Void visitUnsupportedValue(ConstantValue<?> value2) {
                ClassBuilderMode mode = AnnotationCodegen.this.typeMapper.getClassBuilderMode();
                if (mode.generateBodies) {
                    throw new IllegalStateException("Don't know how to compile annotation value " + value2);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/AnnotationCodegen$2", "visitLongValue"));
            }
        };
        value2.accept(argumentVisitor, null);
    }

    @Nullable
    private static Set<ElementType> getJavaTargetList(ClassDescriptor descriptor) {
        ConstantValue<?> compileTimeConstant;
        Collection<ConstantValue<?>> valueArguments;
        AnnotationDescriptor targetAnnotation = descriptor.getAnnotations().findAnnotation(new FqName(Target.class.getName()));
        if (targetAnnotation != null && !(valueArguments = targetAnnotation.getAllValueArguments().values()).isEmpty() && (compileTimeConstant = valueArguments.iterator().next()) instanceof ArrayValue) {
            List values2 = (List)((ArrayValue)compileTimeConstant).getValue();
            EnumSet<ElementType> result2 = EnumSet.noneOf(ElementType.class);
            for (ConstantValue value2 : values2) {
                if (!(value2 instanceof EnumValue)) continue;
                FqName enumClassFqName = ((EnumValue)value2).getEnumClassId().asSingleFqName();
                if (!ElementType.class.getName().equals(enumClassFqName.asString())) continue;
                result2.add(ElementType.valueOf(((EnumValue)value2).getEnumEntryName().asString()));
            }
            return result2;
        }
        return null;
    }

    @NotNull
    private static RetentionPolicy getRetentionPolicy(@NotNull Annotated descriptor) {
        ConstantValue<?> value2;
        KotlinRetention retention;
        if (descriptor == null) {
            AnnotationCodegen.$$$reportNull$$$0(25);
        }
        if ((retention = DescriptorUtilsKt.getAnnotationRetention(descriptor)) != null) {
            RetentionPolicy retentionPolicy = annotationRetentionMap.get((Object)retention);
            if (retentionPolicy == null) {
                AnnotationCodegen.$$$reportNull$$$0(26);
            }
            return retentionPolicy;
        }
        AnnotationDescriptor retentionAnnotation = descriptor.getAnnotations().findAnnotation(new FqName(Retention.class.getName()));
        if (retentionAnnotation != null && (value2 = CollectionsKt.firstOrNull(retentionAnnotation.getAllValueArguments().values())) instanceof EnumValue) {
            FqName enumClassFqName = ((EnumValue)value2).getEnumClassId().asSingleFqName();
            if (RetentionPolicy.class.getName().equals(enumClassFqName.asString())) {
                RetentionPolicy retentionPolicy = RetentionPolicy.valueOf(((EnumValue)value2).getEnumEntryName().asString());
                if (retentionPolicy == null) {
                    AnnotationCodegen.$$$reportNull$$$0(27);
                }
                return retentionPolicy;
            }
        }
        RetentionPolicy retentionPolicy = RetentionPolicy.RUNTIME;
        if (retentionPolicy == null) {
            AnnotationCodegen.$$$reportNull$$$0(28);
        }
        return retentionPolicy;
    }

    @NotNull
    abstract AnnotationVisitor visitAnnotation(String var1, boolean var2);

    @NotNull
    AnnotationVisitor visitTypeAnnotation(String descr, TypePath path, boolean visible) {
        throw new RuntimeException("Not implemented");
    }

    public static AnnotationCodegen forClass(final @NotNull ClassVisitor cv, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state) {
        if (cv == null) {
            AnnotationCodegen.$$$reportNull$$$0(29);
        }
        if (innerClassConsumer == null) {
            AnnotationCodegen.$$$reportNull$$$0(30);
        }
        if (state == null) {
            AnnotationCodegen.$$$reportNull$$$0(31);
        }
        return new AnnotationCodegen(innerClassConsumer, state){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(cv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    3.$$$reportNull$$$0(0);
                }
                return annotationVisitor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$3", "visitAnnotation"));
            }
        };
    }

    public static AnnotationCodegen forMethod(@NotNull MethodVisitor mv2, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state) {
        if (mv2 == null) {
            AnnotationCodegen.$$$reportNull$$$0(32);
        }
        if (innerClassConsumer == null) {
            AnnotationCodegen.$$$reportNull$$$0(33);
        }
        if (state == null) {
            AnnotationCodegen.$$$reportNull$$$0(34);
        }
        return AnnotationCodegen.forMethod(mv2, innerClassConsumer, state, false);
    }

    public static AnnotationCodegen forMethod(final @NotNull MethodVisitor mv2, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state, boolean skipNullabilityAnnotations) {
        if (mv2 == null) {
            AnnotationCodegen.$$$reportNull$$$0(35);
        }
        if (innerClassConsumer == null) {
            AnnotationCodegen.$$$reportNull$$$0(36);
        }
        if (state == null) {
            AnnotationCodegen.$$$reportNull$$$0(37);
        }
        return new AnnotationCodegen(innerClassConsumer, state, skipNullabilityAnnotations){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv2.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    4.$$$reportNull$$$0(0);
                }
                return annotationVisitor;
            }

            @Override
            @NotNull
            AnnotationVisitor visitTypeAnnotation(String descr, TypePath path, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv2.visitTypeAnnotation(TypeReference.newTypeReference(20).getValue(), path, descr, visible));
                if (annotationVisitor == null) {
                    4.$$$reportNull$$$0(1);
                }
                return annotationVisitor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/codegen/AnnotationCodegen$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitAnnotation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitTypeAnnotation";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static AnnotationCodegen forField(@NotNull FieldVisitor fv, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state) {
        if (fv == null) {
            AnnotationCodegen.$$$reportNull$$$0(38);
        }
        if (innerClassConsumer == null) {
            AnnotationCodegen.$$$reportNull$$$0(39);
        }
        if (state == null) {
            AnnotationCodegen.$$$reportNull$$$0(40);
        }
        return AnnotationCodegen.forField(fv, innerClassConsumer, state, false);
    }

    public static AnnotationCodegen forField(final @NotNull FieldVisitor fv, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state, boolean skipNullabilityAnnotations) {
        if (fv == null) {
            AnnotationCodegen.$$$reportNull$$$0(41);
        }
        if (innerClassConsumer == null) {
            AnnotationCodegen.$$$reportNull$$$0(42);
        }
        if (state == null) {
            AnnotationCodegen.$$$reportNull$$$0(43);
        }
        return new AnnotationCodegen(innerClassConsumer, state, skipNullabilityAnnotations){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(fv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    5.$$$reportNull$$$0(0);
                }
                return annotationVisitor;
            }

            @Override
            @NotNull
            AnnotationVisitor visitTypeAnnotation(String descr, TypePath path, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(fv.visitTypeAnnotation(TypeReference.newTypeReference(19).getValue(), path, descr, visible));
                if (annotationVisitor == null) {
                    5.$$$reportNull$$$0(1);
                }
                return annotationVisitor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/codegen/AnnotationCodegen$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitAnnotation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitTypeAnnotation";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static AnnotationCodegen forParameter(final int parameter, final @NotNull MethodVisitor mv2, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state, boolean skipNullabilityAnnotations) {
        if (mv2 == null) {
            AnnotationCodegen.$$$reportNull$$$0(44);
        }
        if (innerClassConsumer == null) {
            AnnotationCodegen.$$$reportNull$$$0(45);
        }
        if (state == null) {
            AnnotationCodegen.$$$reportNull$$$0(46);
        }
        return new AnnotationCodegen(innerClassConsumer, state, skipNullabilityAnnotations){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv2.visitParameterAnnotation(parameter, descr, visible));
                if (annotationVisitor == null) {
                    6.$$$reportNull$$$0(0);
                }
                return annotationVisitor;
            }

            @Override
            @NotNull
            AnnotationVisitor visitTypeAnnotation(String descr, TypePath path, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv2.visitTypeAnnotation(TypeReference.newFormalParameterReference(parameter).getValue(), path, descr, visible));
                if (annotationVisitor == null) {
                    6.$$$reportNull$$$0(1);
                }
                return annotationVisitor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/codegen/AnnotationCodegen$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitAnnotation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitTypeAnnotation";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static AnnotationCodegen forAnnotationDefaultValue(final @NotNull MethodVisitor mv2, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state) {
        if (mv2 == null) {
            AnnotationCodegen.$$$reportNull$$$0(47);
        }
        if (innerClassConsumer == null) {
            AnnotationCodegen.$$$reportNull$$$0(48);
        }
        if (state == null) {
            AnnotationCodegen.$$$reportNull$$$0(49);
        }
        return new AnnotationCodegen(innerClassConsumer, state){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv2.visitAnnotationDefault());
                if (annotationVisitor == null) {
                    7.$$$reportNull$$$0(0);
                }
                return annotationVisitor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$7", "visitAnnotation"));
            }
        };
    }

    @NotNull
    private static AnnotationVisitor safe(@Nullable AnnotationVisitor av) {
        AnnotationVisitor annotationVisitor = av == null ? NO_ANNOTATION_VISITOR : av;
        if (annotationVisitor == null) {
            AnnotationCodegen.$$$reportNull$$$0(50);
        }
        return annotationVisitor;
    }

    private void generateTypeAnnotations(@NotNull Annotated annotated, @Nullable KotlinType type2) {
        if (annotated == null) {
            AnnotationCodegen.$$$reportNull$$$0(51);
        }
        if (AnnotationCodegen.isAccessor(annotated) || type2 == null || !this.state.getConfig().getEmitJvmTypeAnnotations()) {
            return;
        }
        ArrayList infos = new PsiTypeAnnotationCollector().collectTypeAnnotations(type2);
        for (TypePathInfo typePathInfo : infos) {
            for (AnnotationDescriptor annotationDescriptor : typePathInfo.getAnnotations()) {
                this.genAnnotation(annotationDescriptor, typePathInfo.getPath(), true);
            }
        }
    }

    static {
        annotationTargetMap.put(KotlinTarget.CLASS, ElementType.TYPE);
        annotationTargetMap.put(KotlinTarget.ANNOTATION_CLASS, ElementType.ANNOTATION_TYPE);
        annotationTargetMap.put(KotlinTarget.CONSTRUCTOR, ElementType.CONSTRUCTOR);
        annotationTargetMap.put(KotlinTarget.LOCAL_VARIABLE, ElementType.LOCAL_VARIABLE);
        annotationTargetMap.put(KotlinTarget.FUNCTION, ElementType.METHOD);
        annotationTargetMap.put(KotlinTarget.PROPERTY_GETTER, ElementType.METHOD);
        annotationTargetMap.put(KotlinTarget.PROPERTY_SETTER, ElementType.METHOD);
        annotationTargetMap.put(KotlinTarget.FIELD, ElementType.FIELD);
        annotationTargetMap.put(KotlinTarget.VALUE_PARAMETER, ElementType.PARAMETER);
        annotationTargetMap.put(KotlinTarget.TYPE_PARAMETER, ElementType.TYPE_PARAMETER);
        annotationTargetMap.put(KotlinTarget.TYPE, ElementType.TYPE_USE);
        annotationRetentionMap = new EnumMap<KotlinRetention, RetentionPolicy>(KotlinRetention.class);
        annotationRetentionMap.put(KotlinRetention.SOURCE, RetentionPolicy.SOURCE);
        annotationRetentionMap.put(KotlinRetention.BINARY, RetentionPolicy.CLASS);
        annotationRetentionMap.put(KotlinRetention.RUNTIME, RetentionPolicy.RUNTIME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 50: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClassConsumer";
                break;
            }
            case 1: 
            case 3: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalVisibleAnnotations";
                break;
            }
            case 5: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationDescriptorsAlreadyPresent";
                break;
            }
            case 7: 
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationDescriptor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationVisitor";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/AnnotationCodegen";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cv";
                break;
            }
            case 32: 
            case 35: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AnnotationCodegen";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRetentionPolicy";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "safe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "genAnnotations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateAdditionalAnnotations";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateAdditionalCallableAnnotations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateAdditionalClassAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateNullabilityAnnotation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateTargetAnnotation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateRetentionAnnotation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateDocumentedAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isBareTypeParameterWithNullableUpperBound";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "generateAnnotationDefaultValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "genAnnotation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationArgumentJvmName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "genCompileTimeValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRetentionPolicy";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 50: {
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "forClass";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "forMethod";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "forField";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "forParameter";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "forAnnotationDefaultValue";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "generateTypeAnnotations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 50: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JvmFlagAnnotation {
        private final FqName fqName;
        private final int jvmFlag;

        public JvmFlagAnnotation(@NotNull String fqName, int jvmFlag) {
            if (fqName == null) {
                JvmFlagAnnotation.$$$reportNull$$$0(0);
            }
            this.fqName = new FqName(fqName);
            this.jvmFlag = jvmFlag;
        }

        public int getJvmFlag(@Nullable Annotated annotated) {
            return annotated != null && annotated.getAnnotations().hasAnnotation(this.fqName) ? this.jvmFlag : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/AnnotationCodegen$JvmFlagAnnotation", "<init>"));
        }
    }
}

