/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallableKt;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/codegen/intrinsics/CompareTo;", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethod;", "<init>", "()V", "genInvoke", "", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "toCallable", "Lorg/jetbrains/kotlin/codegen/Callable;", "method", "Lorg/jetbrains/kotlin/codegen/CallableMethod;", "backend"})
public final class CompareTo
extends IntrinsicMethod {
    private final void genInvoke(Type type2, InstructionAdapter v) {
        Type type3 = type2;
        if (Intrinsics.areEqual(type3, Type.INT_TYPE) || Intrinsics.areEqual(type3, Type.CHAR_TYPE)) {
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "compare", "(II)I", false);
        } else if (Intrinsics.areEqual(type3, Type.LONG_TYPE)) {
            v.lcmp();
        } else if (Intrinsics.areEqual(type3, Type.FLOAT_TYPE)) {
            v.invokestatic("java/lang/Float", "compare", "(FF)I", false);
        } else if (Intrinsics.areEqual(type3, Type.DOUBLE_TYPE)) {
            v.invokestatic("java/lang/Double", "compare", "(DD)I", false);
        } else if (Intrinsics.areEqual(type3, Type.BOOLEAN_TYPE)) {
            v.invokestatic("java/lang/Boolean", "compare", "(ZZ)I", false);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    @NotNull
    protected Callable toCallable(@NotNull CallableMethod method) {
        Intrinsics.checkNotNullParameter(method, "method");
        Type type2 = method.getDispatchReceiverType();
        if (type2 == null) {
            type2 = method.getExtensionReceiverType();
        }
        Type parameterType = AsmUtil.comparisonOperandType(type2, ArraysKt.single(method.getParameterTypes()));
        Type type3 = method.getReturnType();
        Intrinsics.checkNotNull(parameterType);
        return IntrinsicCallableKt.createBinaryIntrinsicCallable(type3, parameterType, parameterType, null, (arg_0, arg_1) -> CompareTo.toCallable$lambda$0(this, parameterType, arg_0, arg_1));
    }

    private static final Unit toCallable$lambda$0(CompareTo this$0, Type $parameterType, IntrinsicCallable $this$createBinaryIntrinsicCallable, InstructionAdapter it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$createBinaryIntrinsicCallable, "$this$createBinaryIntrinsicCallable");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.genInvoke($parameterType, it);
        return Unit.INSTANCE;
    }
}

