/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataElement;
import org.jetbrains.kotlin.fir.resolve.calls.ContextReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.scopes.impl.FirLocalScope;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR'\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\fR+\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u000e0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0012\u001a\u0004\b\u0015\u0010\fR1\u0010\u0017\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\t0\u000e0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerDataElementsForName;", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "towerDataContext", "Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataContext;", "<init>", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataContext;)V", "nonLocalTowerDataElements", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataElement;", "getNonLocalTowerDataElements", "()Ljava/util/List;", "reversedFilteredLocalScopes", "Lkotlin/collections/IndexedValue;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "getReversedFilteredLocalScopes", "reversedFilteredLocalScopes$delegate", "Lkotlin/Lazy;", "implicitReceivers", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "getImplicitReceivers", "implicitReceivers$delegate", "contextReceiverGroups", "Lorg/jetbrains/kotlin/fir/resolve/calls/ContextReceiverValue;", "getContextReceiverGroups", "contextReceiverGroups$delegate", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirTowerResolveTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTowerResolveTask.kt\norg/jetbrains/kotlin/fir/resolve/calls/tower/TowerDataElementsForName\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,518:1\n1577#2,11:519\n1872#2,2:530\n1874#2:534\n1588#2:535\n1577#2,11:536\n1872#2,2:547\n1874#2:550\n1588#2:551\n1#3:532\n1#3:533\n1#3:549\n*S KotlinDebug\n*F\n+ 1 FirTowerResolveTask.kt\norg/jetbrains/kotlin/fir/resolve/calls/tower/TowerDataElementsForName\n*L\n48#1:519,11\n48#1:530,2\n48#1:534\n48#1:535\n54#1:536,11\n54#1:547,2\n54#1:550\n54#1:551\n48#1:533\n54#1:549\n*E\n"})
public final class TowerDataElementsForName {
    @NotNull
    private final List<FirTowerDataElement> nonLocalTowerDataElements;
    @NotNull
    private final Lazy reversedFilteredLocalScopes$delegate;
    @NotNull
    private final Lazy implicitReceivers$delegate;
    @NotNull
    private final Lazy contextReceiverGroups$delegate;

    public TowerDataElementsForName(@NotNull Name name2, @NotNull FirTowerDataContext towerDataContext) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(towerDataContext, "towerDataContext");
        this.nonLocalTowerDataElements = CollectionsKt.asReversed((List)towerDataContext.getNonLocalTowerDataElements());
        this.reversedFilteredLocalScopes$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> TowerDataElementsForName.reversedFilteredLocalScopes_delegate$lambda$1(towerDataContext, name2));
        this.implicitReceivers$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> TowerDataElementsForName.implicitReceivers_delegate$lambda$4(this));
        this.contextReceiverGroups$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> TowerDataElementsForName.contextReceiverGroups_delegate$lambda$7(this));
    }

    @NotNull
    public final List<FirTowerDataElement> getNonLocalTowerDataElements() {
        return this.nonLocalTowerDataElements;
    }

    @NotNull
    public final List<IndexedValue<FirLocalScope>> getReversedFilteredLocalScopes() {
        Lazy lazy = this.reversedFilteredLocalScopes$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<IndexedValue<ImplicitReceiverValue<?>>> getImplicitReceivers() {
        Lazy lazy = this.implicitReceivers$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<IndexedValue<List<ContextReceiverValue<?>>>> getContextReceiverGroups() {
        Lazy lazy = this.contextReceiverGroups$delegate;
        return (List)lazy.getValue();
    }

    private static final List reversedFilteredLocalScopes_delegate$lambda$1(FirTowerDataContext $towerDataContext, Name $name) {
        int lastIndex;
        List<IndexedValue<FirLocalScope>> list;
        Intrinsics.checkNotNullParameter($towerDataContext, "$towerDataContext");
        Intrinsics.checkNotNullParameter($name, "$name");
        List<IndexedValue<FirLocalScope>> $this$reversedFilteredLocalScopes_delegate_u24lambda_u241_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        PersistentList<FirLocalScope> localScopesBase = $towerDataContext.getLocalScopes();
        for (int i = lastIndex = CollectionsKt.getLastIndex((List)localScopesBase); -1 < i; --i) {
            FirLocalScope localScope = (FirLocalScope)localScopesBase.get(i);
            if (!localScope.mayContainName($name)) continue;
            $this$reversedFilteredLocalScopes_delegate_u24lambda_u241_u24lambda_u240.add(new IndexedValue<FirLocalScope>(lastIndex - i, localScope));
        }
        return CollectionsKt.build(list);
    }

    /*
     * WARNING - void declaration
     */
    private static final List implicitReceivers_delegate$lambda$4(TowerDataElementsForName this$0) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$mapIndexedNotNull$iv = this$0.nonLocalTowerDataElements;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            IndexedValue indexedValue;
            void towerDataElement;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            FirTowerDataElement firTowerDataElement = (FirTowerDataElement)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (towerDataElement.getImplicitReceiver() != null) {
                ImplicitReceiverValue<?> receiver;
                boolean bl3 = false;
                indexedValue = new IndexedValue(index, receiver);
            } else {
                indexedValue = null;
            }
            if (indexedValue == null) continue;
            IndexedValue it$iv$iv = indexedValue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List contextReceiverGroups_delegate$lambda$7(TowerDataElementsForName this$0) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$mapIndexedNotNull$iv = this$0.nonLocalTowerDataElements;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            IndexedValue indexedValue;
            void towerDataElement;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            FirTowerDataElement firTowerDataElement = (FirTowerDataElement)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (towerDataElement.getContextReceiverGroup() != null) {
                List<ContextReceiverValue<?>> receiver;
                boolean bl3 = false;
                indexedValue = new IndexedValue(index, receiver);
            } else {
                indexedValue = null;
            }
            if (indexedValue == null) continue;
            IndexedValue it$iv$iv = indexedValue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

