"use strict";(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["src_components_ViewPublic_vue"],{69100:(t,n,s)=>{s.d(n,{Z:()=>i});var o=s(87537),e=s.n(o),r=s(23645),a=s.n(r)()(e());a.push([t.id,"\n#app-content {\n\tmax-width: 100%;\n}\n","",{version:3,sources:["webpack://./src/components/ViewPublic.vue"],names:[],mappings:";AAmHA;CACA,eAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcContent app-name=\"bookmarks\">\n\t\t<NcAppContent>\n\t\t\t<Controls />\n\t\t\t<BookmarksList :loading=\"!!loading.bookmarks\" :bookmarks=\"bookmarks\" />\n\t\t</NcAppContent>\n\t\t<BookmarkContent />\n\t</NcContent>\n</template>\n\n<script>\nimport { NcContent, NcAppContent } from '@nextcloud/vue'\nimport BookmarksList from './BookmarksList.vue'\nimport Controls from './Controls.vue'\nimport { actions, mutations } from '../store/index.js'\nimport BookmarkContent from './BookmarkContent.vue'\n\nexport default {\n\tname: 'ViewPublic',\n\tcomponents: {\n\t\tBookmarkContent,\n\t\tNcContent,\n\t\tNcAppContent,\n\t\tControls,\n\t\tBookmarksList,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tnewBookmark: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tbookmarks() {\n\t\t\treturn this.$store.state.bookmarks\n\t\t},\n\t\tfolders() {\n\t\t\treturn this.$store.state.folders\n\t\t},\n\t\ttags() {\n\t\t\treturn this.$store.state.tags\n\t\t},\n\t\tloading() {\n\t\t\treturn this.$store.state.loading\n\t\t},\n\t},\n\n\twatch: {\n\t\t$route: 'onRoute',\n\t},\n\n\tasync created() {\n\t\t// this.search = new OCA.Search(this.onSearch, this.onResetSearch)\n\t\tthis.$store.commit(mutations.SET_AUTH_TOKEN, this.$route.params.token)\n\t\t// set loading indicator\n\t\tthis.$store.commit(mutations.FETCH_START, { type: 'bookmarks' })\n\t\tawait Promise.all([\n\t\t\t// this.reloadTags(),\n\t\t\tthis.reloadFolders(),\n\t\t])\n\t\tthis.onRoute()\n\t},\n\n\tmethods: {\n\t\tasync onRoute() {\n\t\t\tconst route = this.$route\n\t\t\tswitch (route.name) {\n\t\t\tcase this.routes.HOME:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_FOLDER, { folder: '-1' })\n\t\t\tcase this.routes.RECENT:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_RECENT)\n\t\t\tcase this.routes.UNTAGGED:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_UNTAGGED)\n\t\t\tcase this.routes.FOLDER:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_FOLDER, { folder: route.params.folder })\n\t\t\tcase this.routes.TAGS:\n\t\t\t\treturn this.$store.dispatch(\n\t\t\t\t\tactions.FILTER_BY_TAGS,\n\t\t\t\t\troute.params.tags.split(',')\n\t\t\t\t)\n\t\t\tcase this.routes.SEARCH:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_SEARCH, { search: route.params.search, folder: route.params.folder || -1 })\n\t\t\tdefault:\n\t\t\t\tthrow new Error('Nothing here. Move along.')\n\t\t\t}\n\t\t},\n\n\t\tasync reloadTags() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_TAGS)\n\t\t},\n\t\tasync reloadFolders() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_FOLDERS)\n\t\t},\n\n\t\tonSearch(search) {\n\t\t\tthis.$router.push({ name: this.routes.SEARCH, params: { search } })\n\t\t},\n\n\t\tonResetSearch() {\n\t\t\tthis.$router.push({ name: this.routes.HOME })\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\t#app-content {\n\t\tmax-width: 100%;\n\t}\n</style>\n"],sourceRoot:""}]);const i=a},9892:(t,n,s)=>{s.r(n),s.d(n,{default:()=>$});var o=s(33911),e=s(35037),r=s(45914),a=s(81283);const i={name:"ViewPublic",components:{BookmarkContent:s(30301).Z,NcContent:o.qF,NcAppContent:o.Mb,Controls:r.Z,BookmarksList:e.Z},data:()=>({newBookmark:!1}),computed:{bookmarks(){return this.$store.state.bookmarks},folders(){return this.$store.state.folders},tags(){return this.$store.state.tags},loading(){return this.$store.state.loading}},watch:{$route:"onRoute"},async created(){this.$store.commit(a.P$.SET_AUTH_TOKEN,this.$route.params.token),this.$store.commit(a.P$.FETCH_START,{type:"bookmarks"}),await Promise.all([this.reloadFolders()]),this.onRoute()},methods:{async onRoute(){const t=this.$route;switch(t.name){case this.routes.HOME:return this.$store.dispatch(a.Nw.FILTER_BY_FOLDER,{folder:"-1"});case this.routes.RECENT:return this.$store.dispatch(a.Nw.FILTER_BY_RECENT);case this.routes.UNTAGGED:return this.$store.dispatch(a.Nw.FILTER_BY_UNTAGGED);case this.routes.FOLDER:return this.$store.dispatch(a.Nw.FILTER_BY_FOLDER,{folder:t.params.folder});case this.routes.TAGS:return this.$store.dispatch(a.Nw.FILTER_BY_TAGS,t.params.tags.split(","));case this.routes.SEARCH:return this.$store.dispatch(a.Nw.FILTER_BY_SEARCH,{search:t.params.search,folder:t.params.folder||-1});default:throw new Error("Nothing here. Move along.")}},async reloadTags(){return this.$store.dispatch(a.Nw.LOAD_TAGS)},async reloadFolders(){return this.$store.dispatch(a.Nw.LOAD_FOLDERS)},onSearch(t){this.$router.push({name:this.routes.SEARCH,params:{search:t}})},onResetSearch(){this.$router.push({name:this.routes.HOME})}}};var c=s(93379),h=s.n(c),u=s(7795),m=s.n(u),l=s(90569),p=s.n(l),d=s(3565),k=s.n(d),E=s(19216),A=s.n(E),C=s(44589),T=s.n(C),R=s(69100),_={};_.styleTagTransform=T(),_.setAttributes=k(),_.insert=p().bind(null,"head"),_.domAPI=m(),_.insertStyleElement=A();h()(R.Z,_);R.Z&&R.Z.locals&&R.Z.locals;const $=(0,s(51900).Z)(i,(function(){var t=this,n=t._self._c;return n("NcContent",{attrs:{"app-name":"bookmarks"}},[n("NcAppContent",[n("Controls"),t._v(" "),n("BookmarksList",{attrs:{loading:!!t.loading.bookmarks,bookmarks:t.bookmarks}})],1),t._v(" "),n("BookmarkContent")],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=bookmarks-src_components_ViewPublic_vue.js.map?v=5485d822fd25d7dfc4bf