/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fy extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Sintraal-Afrikaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskou-standerttiid",
               "",
               "Moskou-simmertiid",
               "",
               "Moskou-tiid",
               "",
            };
        final String[] Japan = new String[] {
               "Japanske standerttiid",
               "",
               "Japanske simmertiid",
               "",
               "Japanske tiid",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistaanske standerttiid",
               "",
               "Pakistaanske simmertiid",
               "",
               "Pakistaanske tiid",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei standerttiid",
               "",
               "Taipei simmertiid",
               "",
               "Taipei tiid",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd standerttiid",
               "",
               "Hovd simmertiid",
               "",
               "Hovd tiid",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan-standerttiid",
               "",
               "Magadan-simmertiid",
               "",
               "Magadan-tiid",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Midden-Australyske westelijke standerttiid",
               "",
               "Midden-Australyske westelijke simmertiid",
               "",
               "Midden-Australyske westelijke tiid",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Midden-Europeeske standerttiid",
               "CET",
               "Midden-Europeeske simmertiid",
               "CEST",
               "Midden-Europeeske tiid",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sachalin-standerttiid",
               "",
               "Sachalin-simmertiid",
               "",
               "Sachalin-tiid",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguayaanske standerttiid",
               "",
               "Paraguayaanske simmertiid",
               "",
               "Paraguayaanske tiid",
               "",
            };
        final String[] Acre = new String[] {
               "Acre-standerttiid",
               "",
               "Acre-simmertiid",
               "",
               "Acre-tiid",
               "",
            };
        final String[] Malaysia = new String[] {
               "Maleisyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Eastern-standerttiid",
               "",
               "Eastern-simmertiid",
               "",
               "Eastern-tiid",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-eil\u00e2nske standerttiid",
               "",
               "Lord Howe-eil\u00e2nske simmertiid",
               "",
               "Lord Howe-eil\u00e2nske tiid",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Nij-Seel\u00e2nske standerttiid",
               "",
               "Nij-Seel\u00e2nske simmertiid",
               "",
               "Nij-Seel\u00e2nske tiid",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Yndyske Oceaan-tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakoetsk-standerttiid",
               "",
               "Jakoetsk-simmertiid",
               "",
               "Jakoetsk-tiid",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiaanske standerttiid",
               "",
               "Mauritiaanske simmertiid",
               "",
               "Mauritiaanske tiid",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "East-Afrikaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "East-Timorese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonseil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosraese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalleil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "East-Europeeske standerttiid",
               "EET",
               "East-Europeeske simmertiid",
               "EEST",
               "East-Europeeske tiid",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundl\u00e2nske-standerttiid",
               "",
               "Newfoundl\u00e2nske-simmertiid",
               "",
               "Newfoundl\u00e2nske-tiid",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongse standerttiid",
               "",
               "Hongkongse simmertiid",
               "",
               "Hongkongse tiid",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "West-Argentynske standerttiid",
               "",
               "West-Argentynske simmertiid",
               "",
               "West-Argentynske tiid",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic-standerttiid",
               "",
               "Atlantic-simmertiid",
               "",
               "Atlantic-tiid",
               "",
            };
        final String[] Ponape = new String[] {
               "Pohnpei tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliviaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint Pierre en Miquelon-standerttiid",
               "",
               "Saint Pierre en Miquelon-simmertiid",
               "",
               "Saint Pierre en Miquelon-tiid",
               "",
            };
        final String[] Indochina = new String[] {
               "Yndochinese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinenburg-standerttiid",
               "",
               "Jekaterinenburg-simmertiid",
               "",
               "Jekaterinenburg-tiid",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitiaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Isra\u00eblyske standerttiid",
               "",
               "Isra\u00eblyske simmertiid",
               "",
               "Isra\u00eblyske tiid",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Sintraal-Yndonezyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis en Futunase tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "S\u00fbd-Afrikaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowa tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line-eil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Oezbeekse standerttiid",
               "",
               "Oezbeekse simmertiid",
               "",
               "Oezbeekse tiid",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk-standerttiid",
               "",
               "Omsk-simmertiid",
               "",
               "Omsk-tiid",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguayaanske standerttiid",
               "",
               "Uruguayaanske simmertiid",
               "",
               "Uruguayaanske tiid",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar standerttiid",
               "",
               "Ulaanbaatar simmertiid",
               "",
               "Ulaanbaatar tiid",
               "",
            };
        final String[] America_Central = new String[] {
               "Central-standerttiid",
               "",
               "Central-simmertiid",
               "",
               "Central-tiid",
               "",
            };
        final String[] Truk = new String[] {
               "Chuukse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Niue = new String[] {
               "Niuese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake-eil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Falkl\u00e2neil\u00e2nske standerttiid",
               "",
               "Falkl\u00e2neil\u00e2nske simmertiid",
               "",
               "Falkl\u00e2neil\u00e2nske tiid",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatuaanske standerttiid",
               "",
               "Vanuatuaanske simmertiid",
               "",
               "Vanuatuaanske tiid",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk-standerttiid",
               "",
               "Novosibirsk-simmertiid",
               "",
               "Novosibirsk-tiid",
               "",
            };
        final String[] Singapore = new String[] {
               "Singaporese standerttiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azoren-standerttiid",
               "",
               "Azoren-simmertiid",
               "",
               "Azoren-tiid",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinaamske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauruaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-standerttiid",
               "",
               "Krasnojarsk-simmertiid",
               "",
               "Krasnojarsk-tiid",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "West-Kazachse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarese tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Krysteil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazone-standerttiid",
               "",
               "Amazone-simmertiid",
               "",
               "Amazone-tiid",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "East-Kazachse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fijyske standerttiid",
               "",
               "Fijyske simmertiid",
               "",
               "Fijyske tiid",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unionse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Kokoseil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham standerttiid",
               "",
               "Chatham simmertiid",
               "",
               "Chatham tiid",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentynske standerttiid",
               "",
               "Argentynske simmertiid",
               "",
               "Argentynske tiid",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiereil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamtsjatski-standerttiid",
               "",
               "Petropavlovsk-Kamtsjatski-simmertiid",
               "",
               "Petropavlovsk-Kamtsjatski-tiid",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaluaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagoseil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Macquarie-eil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Fenezolaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleoetyske standerttiid",
               "",
               "Hawaii-Aleoetyske simmertiid",
               "",
               "Hawaii-Aleoetyske tiid",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Midden-Australyske standerttiid",
               "",
               "Midden-Australyske simmertiid",
               "",
               "Midden-Australyske tiid",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Pasifik-standerttiid",
               "",
               "Pasifik-simmertiid",
               "",
               "Pasifik-tiid",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixeil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmeense standerttiid",
               "",
               "Turkmeense simmertiid",
               "",
               "Turkmeense tiid",
               "",
            };
        final String[] Europe_Western = new String[] {
               "West-Europeeske standerttiid",
               "WET",
               "West-Europeeske simmertiid",
               "WEST",
               "West-Europeeske tiid",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kaapverdyske standerttiid",
               "",
               "Kaapverdyske simmertiid",
               "",
               "Kaapverdyske tiid",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkeil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairneill\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoaanske standerttiid",
               "",
               "Samoaanske simmertiid",
               "",
               "Samoaanske tiid",
               "",
            };
        final String[] Palau = new String[] {
               "Belause tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbeidzjaanske standerttiid",
               "",
               "Azerbeidzjaanske simmertiid",
               "",
               "Azerbeidzjaanske tiid",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubaanske standerttiid",
               "",
               "Kubaanske simmertiid",
               "",
               "Kubaanske tiid",
               "",
            };
        final String[] Africa_Western = new String[] {
               "West-Afrikaanske standerttiid",
               "",
               "West-Afrikaanske simmertiid",
               "",
               "West-Afrikaanske tiid",
               "",
            };
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipijnse standerttiid",
               "",
               "Filipijnse simmertiid",
               "",
               "Filipijnse tiid",
               "",
            };
        final String[] French_Southern = new String[] {
               "Fr\u00e2nske S\u00fadlike en Antarctyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "S\u00fbd-Georgyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nij-Kaledonyske standerttiid",
               "",
               "Nij-Kaledonyske simmertiid",
               "",
               "Nij-Kaledonyske tiid",
               "",
            };
        final String[] Brunei = new String[] {
               "Bruneise tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Iraanske standerttiid",
               "",
               "Iraanske simmertiid",
               "",
               "Iraanske tiid",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Peaskeeil\u00e2nske standerttiid",
               "",
               "Peaskeeil\u00e2nske simmertiid",
               "",
               "Peaskeeil\u00e2nske tiid",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadzjiekse tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongaanske standerttiid",
               "",
               "Tongaanske simmertiid",
               "",
               "Tongaanske tiid",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bengalese standerttiid",
               "",
               "Bengalese simmertiid",
               "",
               "Bengalese tiid",
               "",
            };
        final String[] Peru = new String[] {
               "Peruaanske standerttiid",
               "",
               "Peruaanske simmertiid",
               "",
               "Peruaanske tiid",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "West-Groenl\u00e2nske standerttiid",
               "",
               "West-Groenl\u00e2nske simmertiid",
               "",
               "West-Groenl\u00e2nske tiid",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadoraanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "East-Groenl\u00e2nske standerttiid",
               "",
               "East-Groenl\u00e2nske simmertiid",
               "",
               "East-Groenl\u00e2nske tiid",
               "",
            };
        final String[] Gulf = new String[] {
               "Golf standerttiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "East-Yndonezyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Koreaanske standerttiid",
               "",
               "Koreaanske simmertiid",
               "",
               "Koreaanske tiid",
               "",
            };
        final String[] Australia_Western = new String[] {
               "West-Australyske standerttiid",
               "",
               "West-Australyske simmertiid",
               "",
               "West-Australyske tiid",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "West-Yndonezyske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "East-Australyske standerttiid",
               "",
               "East-Australyske simmertiid",
               "",
               "East-Australyske tiid",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Fr\u00e2ns-Guyaanske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolombiaanske standerttiid",
               "",
               "Kolombiaanske simmertiid",
               "",
               "Kolombiaanske tiid",
               "",
            };
        final String[] Chile = new String[] {
               "Sileenske standerttiid",
               "",
               "Sileenske simmertiid",
               "",
               "Sileenske tiid",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberteil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain-standerttiid",
               "",
               "Mountain-simmertiid",
               "",
               "Mountain-tiid",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesaseil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabyske standerttiid",
               "",
               "Arabyske simmertiid",
               "",
               "Arabyske tiid",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska-standerttiid",
               "",
               "Alaska-simmertiid",
               "",
               "Alaska-tiid",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok-standerttiid",
               "",
               "Vladivostok-simmertiid",
               "",
               "Vladivostok-tiid",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkoetsk-standerttiid",
               "",
               "Irkoetsk-simmertiid",
               "",
               "Irkoetsk-tiid",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgyske standerttiid",
               "",
               "Georgyske simmertiid",
               "",
               "Georgyske tiid",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-eil\u00e2nske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papoea-Nij-Guineeske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-standerttiid",
               "",
               "Fernando de Noronha-simmertiid",
               "",
               "Fernando de Noronha-tiid",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Tsjojbalsan standerttiid",
               "",
               "Tsjojbalsan simmertiid",
               "",
               "Tsjojbalsan tiid",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brazyljaanske standerttiid",
               "",
               "Brazyljaanske simmertiid",
               "",
               "Brazyljaanske tiid",
               "",
            };
        final String[] China = new String[] {
               "Sineeske standerttiid",
               "",
               "Sineeske simmertiid",
               "",
               "Sineeske tiid",
               "",
            };
        final String[] Armenia = new String[] {
               "Armeense standerttiid",
               "",
               "Armeense simmertiid",
               "",
               "Armeense tiid",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyr-standerttiid",
               "",
               "Anadyr-simmertiid",
               "",
               "Anadyr-tiid",
               "",
            };
        final String[] Samara = new String[] {
               "Samara-standerttiid",
               "",
               "Samara-simmertiid",
               "",
               "Samara-tiid",
               "",
            };
        final String[] India = new String[] {
               "Yndiaaske tiid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Cookeil\u00e2nse standerttiid",
               "",
               "Cookeil\u00e2nse halve simmertiid",
               "",
               "Cookeil\u00e2nse tiid",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Asia/Irkutsk", "Irkoetsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "timezone.excity.Pacific/Marquesas", "Marquesaseilannen" },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "",
                    "Britse simmertiid",
                    "",
                    "",
                    "",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Noard-Dakota" },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "JST", Japan },
            { "timezone.excity.Asia/Kamchatka", "Kamtsjatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakoetsk" },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Asia/Tashkent", "Tasjkent" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Asia/Shanghai", "Sjanghai" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Asia/Dushanbe", "Dusjanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "BET", Brasilia },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Peaskeeil\u00e2n" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Europe/London", "Londen" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Atlantic/Canary", "Kanaryske Eilannen" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Africa/Cairo", "Ca\u00efro" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "timezone.excity.Europe/Warsaw", "Warschau" },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.Europe/Berlin", "Berlyn" },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Lower_Princes", "Beneden Prinsen Kwartier" },
            { "Asia/Choibalsan", Choibalsan },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tom\u00e9" },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.Europe/Vatican", "Fatikaanst\u00ead" },
            { "timezone.excity.Asia/Almaty", "Alma-Ata" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Noard-Dakota" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "timezone.excity.Asia/Beirut", "Beiroet" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.Atlantic/South_Georgia", "S\u00fbd-Georgia" },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "CNT", Newfoundland },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom-Penh" },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury-eil\u00e2n" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.Europe/Bucharest", "Boekarest" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Noard-Dakota" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Athene" },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "timezone.excity.Asia/Bishkek", "Bisjkek" },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "P\u00f4rto Velho" },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "NET", Armenia },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Etc/Unknown", "Unbekende st\u00ead" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "America/Yakutat", Alaska },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.Europe/Uzhgorod", "Oezjhorod" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Asia/Baku", "Bakoe" },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "timezone.excity.Africa/Khartoum", "Khartoem" },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minhstad" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinenburg" },
            { "CST", America_Central },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "",
                    "Ierse simmertiid",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "timezone.excity.Atlantic/St_Helena", "Sint-Helena" },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.America/Mexico_City", "Mexico-stad" },
            { "Pacific/Saipan", Chamorro },
            { "SystemV/YST9", Gambier },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "Africa/Douala", Africa_Western },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Pacific/Gambier", "Gambiereilannen" },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Parys" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporizja" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Boedapest" },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda de Banderas" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Koeweit" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskou" },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "",
                    "Britse simmertiid",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manilla" },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.Europe/Istanbul", "Istanboel" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "NST", New_Zealand },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Wenen" },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Atlantic/Faeroe", "Faer\u00f6er" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Atlantic/Cape_Verde", "Kaapverdi\u00eb" },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azoren" },
            { "timezone.excity.Asia/Ashgabat", "Asjchabad" },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Indian/Christmas", "Krysteil\u00e2n" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Anadyr },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "timezone.excity.Indian/Chagos", "Chagosarchipel" },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Prague", "Praach" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.Indian/Cocos", "Cocoseilannen" },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "SystemV/AST4ADT", Atlantic },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.Europe/Brussels", "Brussel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.Indian/Maldives", "Maldiven" },
        };
        return data;
    }
}
