/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseDatabase
extends AbstractTextualComponent {
    private final TextBlock stickman;
    private final boolean head;

    public ComponentRoseDatabase(Style style, Style stereo, Display stringsToDisplay, boolean head, ISkinSimple spriteContainer) {
        super(style, stereo, LineBreakStrategy.NONE, 3, 3, 0, spriteContainer, stringsToDisplay, false);
        this.head = head;
        Fashion biColor = style.getSymbolContext(this.getIHtmlColorSet());
        Fashion symbolContext = new Fashion(biColor.getBackColor(), biColor.getForeColor()).withStroke(UStroke.withThickness(1.5)).withShadow(biColor.getDeltaShadow());
        this.stickman = USymbols.DATABASE.asSmall(null, TextBlockUtils.empty(16.0, 17.0), TextBlockUtils.empty(0.0, 0.0), symbolContext, HorizontalAlignment.CENTER);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        double delta = (this.getPreferredWidth(stringBounder) - dimStickman.getWidth()) / 2.0;
        if (this.head) {
            textBlock.drawU(ug.apply(new UTranslate(this.getTextMiddlePostion(stringBounder), dimStickman.getHeight())));
            ug = ug.apply(UTranslate.dx(delta));
        } else {
            textBlock.drawU(ug.apply(UTranslate.dx(this.getTextMiddlePostion(stringBounder))));
            ug = ug.apply(new UTranslate(delta, this.getTextHeight(stringBounder)));
        }
        this.stickman.drawU(ug);
    }

    private double getTextMiddlePostion(StringBounder stringBounder) {
        return (this.getPreferredWidth(stringBounder) - this.getTextWidth(stringBounder)) / 2.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        XDimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return dimStickman.getHeight() + this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        XDimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return Math.max(dimStickman.getWidth(), this.getTextWidth(stringBounder));
    }
}

