/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.retrieve.EndRetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.EndRetrieveEvent;
import org.apache.ivy.core.event.retrieve.StartRetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.StartRetrieveEvent;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.retrieve.RetrieveEngine;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.retrieve.RetrieveReport;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxesRunTime;
import xsbt.boot.ParallelRetrieveEngine$;
import xsbt.boot.RetResult;

public class ParallelRetrieveEngine
extends RetrieveEngine {
    private final RetrieveEngineSettings settings;
    private final EventManager eventManager;

    /*
     * WARNING - void declaration
     */
    @Override
    public RetrieveReport retrieve(ModuleRevisionId mrid, RetrieveOptions options) {
        RetrieveReport report = new RetrieveReport();
        ModuleId moduleId = mrid.getModuleId();
        if ("default".equals(options.getLog())) {
            Message.info(new StringBuilder(17).append(":: retrieving :: ").append(moduleId).toString());
        } else {
            Message.verbose(new StringBuilder(17).append(":: retrieving :: ").append(moduleId).toString());
        }
        Message.verbose(new StringBuilder(15).append("\tcheckUpToDate=").append(this.settings.isCheckUpToDate()).toString());
        long start = System.currentTimeMillis();
        String destFilePattern = IvyPatternHelper.substituteVariables(options.getDestArtifactPattern(), this.settings.getVariables());
        String destIvyPattern = IvyPatternHelper.substituteVariables(options.getDestIvyPattern(), this.settings.getVariables());
        String[] confs = this.getConfs(mrid, options);
        if ("default".equals(options.getLog())) {
            Message.info(new StringBuilder(8).append("\tconfs: ").append(Arrays.asList((Object[])confs)).toString());
        } else {
            Message.verbose(new StringBuilder(8).append("\tconfs: ").append(Arrays.asList((Object[])confs)).toString());
        }
        if (this.eventManager != null) {
            this.eventManager.fireIvyEvent(new StartRetrieveEvent(mrid, confs, options));
        }
        try {
            void var3_4;
            Map artifactsToCopy = this.determineArtifactsToCopy(mrid, destFilePattern, options);
            File fileRetrieveRoot = this.settings.resolveFile(IvyPatternHelper.getTokenRoot(destFilePattern));
            report.setRetrieveRoot(fileRetrieveRoot);
            if (destIvyPattern != null) {
                this.settings.resolveFile(IvyPatternHelper.getTokenRoot(destIvyPattern));
            }
            ExecutionContextExecutor ec = ParallelRetrieveEngine$.MODULE$.xsbt$boot$ParallelRetrieveEngine$$retrieveExecutionContext();
            scala.collection.mutable.Set allRetrivedFuture = (scala.collection.mutable.Set)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(artifactsToCopy.entrySet()).asScala()).map((Function1<Map.Entry, Future> & Serializable)x0$1 -> {
                Future future;
                Future<Object> future2;
                Map.Entry entry = x0$1;
                if (entry instanceof Map.Entry) {
                    ArtifactDownloadReport artifact = (ArtifactDownloadReport)entry.getKey();
                    File archive = artifact.getLocalFile();
                    if (archive == null) {
                        Message.verbose(new StringBuilder(39).append("\tno local file available for ").append(artifact).append(": skipping").toString());
                        future2 = Future$.MODULE$.apply((Function0<scala.collection.mutable.Set> & Serializable)() -> (scala.collection.mutable.Set)Set$.MODULE$.apply(Nil$.MODULE$), ec);
                    } else {
                        void var1_1;
                        void var2_2;
                        Message.verbose(new StringBuilder(12).append("\tretrieving ").append(archive).toString());
                        future2 = Future$.MODULE$.traverse((IterableOnce)JavaConverters$.MODULE$.asScalaSetConverter((Set)entry.getValue()).asScala(), arg_0 -> ParallelRetrieveEngine.$anonfun$retrieve$3((ParallelRetrieveEngine)((Object)future), artifact, archive, (RetrieveOptions)var2_2, ec, arg_0), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)var1_1);
                    }
                } else {
                    throw new MatchError(entry);
                }
                future = future2;
                return future;
            });
            scala.collection.mutable.Set set = (scala.collection.mutable.Set)Await$.MODULE$.result(Future$.MODULE$.reduceLeft(allRetrivedFuture.toList(), (Function2<scala.collection.mutable.Set, scala.collection.mutable.Set, scala.collection.mutable.Set> & Serializable)(x$3, x$4) -> {
                void var1_1;
                return (scala.collection.mutable.Set)x$3.$plus$plus(var1_1);
            }, ec), Duration$.MODULE$.Inf());
            long totalCopiedSize = BoxesRunTime.unboxToLong(set.foldLeft(BoxesRunTime.boxToLong(0L), (Function2<Object, RetResult, Object> & Serializable)(x0$3, x1$1) -> {
                void var2_2;
                void var1_1;
                return BoxesRunTime.boxToLong(ParallelRetrieveEngine.$anonfun$retrieve$6(report, BoxesRunTime.unboxToLong(var1_1), (RetResult)var2_2));
            }));
            long elapsedTime = System.currentTimeMillis() - start;
            String msg2 = this.settings.isCheckUpToDate() ? new StringBuilder(20).append(", ").append(report.getNbrArtifactsUpToDate()).append(" already retrieved").toString() : new StringBuilder(8).append(" (").append(totalCopiedSize / 1024L).append("kB/").append(elapsedTime).append("ms)").toString();
            String msg = new StringBuilder(18).append("\t").append(report.getNbrArtifactsCopied()).append(" artifacts copied").append(msg2).toString();
            if ("default".equals(options.getLog())) {
                Message.info(msg);
            } else {
                Message.verbose(msg);
            }
            Message.verbose(new StringBuilder(19).append("\tretrieve done (").append(elapsedTime).append("ms)").toString());
            if (this.eventManager != null) {
                void var2_3;
                this.eventManager.fireIvyEvent(new EndRetrieveEvent(mrid, confs, elapsedTime, report.getNbrArtifactsCopied(), report.getNbrArtifactsUpToDate(), totalCopiedSize, (RetrieveOptions)var2_3));
            }
            return var3_4;
        }
        catch (Exception ex) {
            void var1_2;
            throw new RuntimeException(new StringBuilder(29).append("problem during retrieve of ").append(moduleId).append(": ").append(ex).toString(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public RetResult retrieveFile(RetrieveEngineSettings settings, EventManager eventManager, ArtifactDownloadReport artifact, File archive, String path, RetrieveOptions options) {
        void var3_4;
        File destFile = settings.resolveFile(path);
        if (!settings.isCheckUpToDate() || !this.upToDate(archive, destFile, options)) {
            Message.verbose(new StringBuilder(5).append("\t\tto ").append(destFile).toString());
            if (eventManager != null) {
                eventManager.fireIvyEvent(new StartRetrieveArtifactEvent(artifact, destFile));
            }
            if (options.isMakeSymlinks()) {
                void var1_2;
                boolean symlinkCreated;
                try {
                    FileUtil.symlink(archive, destFile, null, true);
                    symlinkCreated = true;
                }
                catch (IOException iOException) {
                    symlinkCreated = false;
                    Message.warn(new StringBuilder(32).append("symlink creation failed at path ").append(destFile).toString());
                }
                if (var1_2 == false) {
                    Message.info(new StringBuilder(68).append("attempting a copy operation (since symlink creation failed) at path ").append(destFile).toString());
                    BoxesRunTime.boxToBoolean(FileUtil.copy(archive, destFile, null, true));
                }
            } else {
                BoxesRunTime.boxToBoolean(FileUtil.copy(archive, destFile, null, true));
            }
            if (eventManager != null) {
                void var2_3;
                var2_3.fireIvyEvent(new EndRetrieveArtifactEvent(artifact, destFile));
            }
            long copiedSize = destFile.length();
            return new RetResult(destFile, artifact, copiedSize, true);
        }
        Message.verbose(new StringBuilder(20).append("\t\tto ").append(destFile).append(" [NOT REQUIRED]").toString());
        return new RetResult(destFile, (ArtifactDownloadReport)var3_4, 0L, false);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getConfs(ModuleRevisionId mrid, RetrieveOptions options) {
        void var3_4;
        String[] confs = options.getConfs();
        if (confs == null || confs.length == 1 && "*".equals(confs[0])) {
            Object md;
            try {
                void var2_3;
                md = this.getCache().getResolvedModuleDescriptor(mrid);
                Message.verbose(new StringBuilder(54).append("no explicit confs given for retrieve, using ivy file: ").append(md.getResource().getName()).toString());
                confs = md.getConfigurationsNames();
                var2_3.setConfs(confs);
            }
            catch (IOException iOException) {
                md = iOException;
                throw iOException;
            }
            catch (Exception ex) {
                void var1_2;
                throw new IOException(ex.getMessage(), (Throwable)var1_2);
            }
        }
        return var3_4;
    }

    public ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    /*
     * WARNING - void declaration
     */
    public boolean upToDate(File source, File target, RetrieveOptions options) {
        void var3_3;
        if (!target.exists()) {
            return false;
        }
        String overwriteMode = options.getOverwriteMode();
        if ("always".equals(overwriteMode)) {
            return false;
        }
        if ("never".equals(overwriteMode)) {
            return true;
        }
        if ("newer".equals(overwriteMode)) {
            return source.lastModified() <= target.lastModified();
        }
        if ("different".equals(var3_3)) {
            void var2_2;
            void var1_1;
            return var1_1.lastModified() == var2_2.lastModified();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ RetResult $anonfun$retrieve$4(ParallelRetrieveEngine $this, String x2$1, ArtifactDownloadReport artifact$1, File archive$1, RetrieveOptions options$1) {
        void var1_1;
        void var3_3;
        void var2_2;
        ParallelRetrieveEngine parallelRetrieveEngine;
        IvyContext.getContext().checkInterrupted();
        $this.settings.resolveFile(x2$1);
        ParallelRetrieveEngine parallelRetrieveEngine2 = $this;
        return parallelRetrieveEngine2.retrieveFile(parallelRetrieveEngine2.settings, parallelRetrieveEngine.eventManager, (ArtifactDownloadReport)var2_2, (File)var3_3, (String)var1_1, options$1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Future $anonfun$retrieve$3(ParallelRetrieveEngine $this, ArtifactDownloadReport artifact$1, File archive$1, RetrieveOptions options$1, ExecutionContextExecutor ec$1, String x0$2) {
        void var3_3;
        void var2_2;
        void var1_1;
        Future future;
        String string = x0$2;
        if (string == null) {
            throw new MatchError((Object)string);
        }
        future = Future$.MODULE$.apply(() -> ParallelRetrieveEngine.$anonfun$retrieve$4((ParallelRetrieveEngine)((Object)future), string, (ArtifactDownloadReport)var1_1, (File)var2_2, (RetrieveOptions)var3_3), ec$1);
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$retrieve$6(RetrieveReport report$1, long x0$32, RetResult x1$1) {
        void var1_2;
        void var3_3;
        Tuple2<Long, void> x0$32 = new Tuple2<Long, void>(BoxesRunTime.boxToLong(x0$32), var3_3);
        long sum = x0$32._1$mcJ$sp();
        RetResult ret = (RetResult)x0$32._2();
        if (ret.copied()) {
            report$1.addCopiedFile(ret.destFile(), ret.artifact());
        } else {
            RetrieveReport retrieveReport;
            retrieveReport.addUpToDateFile(ret.destFile(), ret.artifact());
        }
        long l = sum + var1_2.totalSizeDownloaded();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public ParallelRetrieveEngine(RetrieveEngineSettings settings, EventManager eventManager) {
        void var2_2;
        void var1_1;
        this.settings = settings;
        this.eventManager = eventManager;
        super((RetrieveEngineSettings)var1_1, (EventManager)var2_2);
    }
}

