# Clients

This page describes how to configure IRC clients to better integrate with soju.

Also see the [IRCv3 support tables] for a more general list of clients.

# catgirl

catgirl doesn't implement cap-3.2, so many capabilities will be disabled.
catgirl developers have publicly stated that supporting bouncers such as soju
is a non-goal.

# [Emacs]

There are two clients provided with Emacs. They require some setup to work
properly.

## Erc

Create an interactive function for connecting:

```elisp
(defun run-erc ()
  (interactive)
  (erc-tls :server "<server>"
           :port 6697
           :nick "<nick>"
           :user "<username>/irc.libera.chat" ;; Example with Libera.Chat
           :password "<password>"))
```

Then run `M-x run-erc`.

## Rcirc

The only thing needed here is the general config:

```elisp
(setq rcirc-server-alist
      '(("<server>"
         :port 6697
         :encryption tls
         :nick "<nick>"
         :user-name "<username>/irc.libera.chat" ;; Example with Libera.Chat
         :password "<password>")))
```

Then run `M-x irc`.

# [gamja]

gamja has been designed together with soju, so should have excellent
integration. gamja supports many IRCv3 features including chat history.
gamja also provides UI to manage soju networks via the
`soju.im/bouncer-networks` extension.

# [goguma]

Much like gamja, goguma has been designed together with soju, so should have
excellent integration. goguma supports many IRCv3 features including chat
history. goguma should seamlessly connect to all networks configured in soju via
the `soju.im/bouncer-networks` extension.

# [Hexchat]

Hexchat has support for a small set of IRCv3 capabilities. To prevent
automatically reconnecting to channels parted from soju, and prevent buffering
outgoing messages:

    /set irc_reconnect_rejoin off
    /set net_throttle off

Older Hexchat versions (without the [hexchat password length fix]) do not
support long passwords, which include personal access tokens from sourcehut with
limited scope. To work around this issue for sourcehut, [generate a sourcehut
personal access token] without limiting the grant (by not selecting any
permissions).

# [irssi]

To connect irssi to a network, for example Libera Chat:

    /network add -user <soju user>/irc.libera.chat libera
    /server add -auto -tls -network libera <soju ip or hostname> <soju port> <soju password>

Then, to actually connect:

    /connect libera

# [senpai]

senpai is being developed with soju in mind, so should have excellent
integration. senpai supports many IRCv3 features including chat history.
senpai should seamlessly connect to all networks configured in soju via the
`soju.im/bouncer-networks` extension.

# [Weechat]

A [soju.py] Weechat script is available to provide better integration with soju.
The script will automatically connect to all of your networks once a single
connection to soju is set up in Weechat.

Additionally, [read_marker.py] can be enabled to synchronize the read marker
between multiple clients.

On WeeChat 3.2-, no IRCv3 capabilities are enabled by default. To enable them:

    /set irc.server_default.capabilities account-notify,away-notify,cap-notify,chghost,extended-join,invite-notify,multi-prefix,server-time,userhost-in-names
    /save
    /reconnect -all

See `/help cap` for more information.

[IRCv3 support tables]: https://ircv3.net/software/clients
[gamja]: https://sr.ht/~emersion/gamja/
[goguma]: https://sr.ht/~emersion/goguma/
[senpai]: https://sr.ht/~delthas/senpai/
[Weechat]: https://weechat.org/
[soju.py]: https://weechat.org/scripts/source/soju.py.html/
[read_marker.py]: https://weechat.org/scripts/source/read_marker.py.html/
[Hexchat]: https://hexchat.github.io/
[hexchat password length fix]: https://github.com/hexchat/hexchat/commit/778047bc65e529804c3342ee0f3a8d5d7550fde5
[generate a sourcehut personal access token]: https://meta.sr.ht/oauth2/personal-token
[Emacs]: https://www.gnu.org/software/emacs/
[irssi]: https://irssi.org/
