
#ifndef SYNDICATION_EXPORT_H
#define SYNDICATION_EXPORT_H

#ifdef SYNDICATION_STATIC_DEFINE
#  define SYNDICATION_EXPORT
#  define SYNDICATION_NO_EXPORT
#else
#  ifndef SYNDICATION_EXPORT
#    ifdef KF6Syndication_EXPORTS
        /* We are building this library */
#      define SYNDICATION_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define SYNDICATION_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef SYNDICATION_NO_EXPORT
#    define SYNDICATION_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef SYNDICATION_DECL_DEPRECATED
#  define SYNDICATION_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef SYNDICATION_DECL_DEPRECATED_EXPORT
#  define SYNDICATION_DECL_DEPRECATED_EXPORT SYNDICATION_EXPORT SYNDICATION_DECL_DEPRECATED
#endif

#ifndef SYNDICATION_DECL_DEPRECATED_NO_EXPORT
#  define SYNDICATION_DECL_DEPRECATED_NO_EXPORT SYNDICATION_NO_EXPORT SYNDICATION_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef SYNDICATION_NO_DEPRECATED
#    define SYNDICATION_NO_DEPRECATED
#  endif
#endif
#include <syndication_version.h>

#define SYNDICATION_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(SYNDICATION_NO_DEPRECATED) && !defined(SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define SYNDICATION_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(SYNDICATION_NO_DEPRECATED_WARNINGS) && !defined(SYNDICATION_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define SYNDICATION_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define SYNDICATION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(SYNDICATION_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define SYNDICATION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(SYNDICATION_NO_DEPRECATED)
#  undef SYNDICATION_DEPRECATED
#  define SYNDICATION_DEPRECATED_EXPORT SYNDICATION_EXPORT
#  define SYNDICATION_DEPRECATED_NO_EXPORT SYNDICATION_NO_EXPORT
#elif defined(SYNDICATION_NO_DEPRECATED_WARNINGS)
#  define SYNDICATION_DEPRECATED
#  define SYNDICATION_DEPRECATED_EXPORT SYNDICATION_EXPORT
#  define SYNDICATION_DEPRECATED_NO_EXPORT SYNDICATION_NO_EXPORT
#else
#  define SYNDICATION_DEPRECATED SYNDICATION_DECL_DEPRECATED
#  define SYNDICATION_DEPRECATED_EXPORT SYNDICATION_DECL_DEPRECATED_EXPORT
#  define SYNDICATION_DEPRECATED_NO_EXPORT SYNDICATION_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define SYNDICATION_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define SYNDICATION_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef SYNDICATION_NO_DEPRECATED
#  define SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT SYNDICATION_VERSION
#endif
#ifdef SYNDICATION_NO_DEPRECATED_WARNINGS
#  define SYNDICATION_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef SYNDICATION_DEPRECATED_WARNINGS_SINCE
#  ifdef SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define SYNDICATION_DEPRECATED_WARNINGS_SINCE SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define SYNDICATION_DEPRECATED_WARNINGS_SINCE SYNDICATION_VERSION
#  endif
#endif

#ifndef SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef SYNDICATION_DEPRECATED
#  define SYNDICATION_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > SYNDICATION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define SYNDICATION_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* SYNDICATION_EXPORT_H */
