/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class FieldValueCs
implements FieldValueElement {
    private FieldValueElement fieldValueElem;

    public FieldValueCs(FieldValueElement fieldValueElement) {
        this.fieldValueElem = fieldValueElement;
    }

    @Override
    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        String string = this.getCsName(bib2GlsEntry);
        if (string == null) {
            return null;
        }
        return new BibUserString(new TeXCsRef(string));
    }

    @Override
    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        String string = this.getCsName(bib2GlsEntry);
        if (string == null) {
            return null;
        }
        if (!Character.isAlphabetic(string.codePointAt(0))) {
            return String.format("\\%s", string);
        }
        return String.format("\\%s ", string);
    }

    protected String getCsName(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        BibValue bibValue = this.fieldValueElem.getValue(bib2GlsEntry);
        if (bibValue == null) {
            return null;
        }
        GlsResource glsResource = bib2GlsEntry.getResource();
        TeXParser teXParser = glsResource.getParser();
        TeXObjectList teXObjectList = (TeXObjectList)bibValue.expand(teXParser).clone();
        String string = teXObjectList.toString(teXParser);
        return string.isEmpty() ? null : string;
    }

    public String toString() {
        return String.format("\\CS{%s}", this.fieldValueElem);
    }
}

