/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.MultiToken;
import com.dickimawbooks.texparserlib.StackMarker;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import java.io.IOException;

public class Group
extends TeXObjectList {
    public Group() {
    }

    public Group(int n) {
        super(n);
    }

    public Group(TeXParserListener teXParserListener, String string) {
        super(teXParserListener, string);
    }

    @Override
    public boolean isStack() {
        return false;
    }

    public boolean isMathGroup() {
        return false;
    }

    public TeXObjectList toList() {
        TeXObjectList teXObjectList = new TeXObjectList(this.size());
        teXObjectList.addAll(this);
        return teXObjectList;
    }

    @Override
    public TeXObjectList createList() {
        return new Group(this.capacity());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser.isDebugMode(128)) {
            teXParser.logMessage(String.format("PROCESSING %s: %s SUBSTACK: ", this.getClass().getSimpleName(), this.toString(teXParser), teXObjectList.toString(teXParser)));
        }
        if (teXParser.isDebugMode(256)) {
            teXParser.logMessage("PROCESSING GROUP: " + this.toString() + teXObjectList);
        }
        StackMarker stackMarker = new StackMarker();
        teXObjectList.push(stackMarker);
        teXObjectList.addAll(0, this);
        this.clear();
        this.startGroup(teXParser);
        teXObjectList.processList(teXParser, stackMarker);
        this.endGroup(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (teXParser.isDebugMode(128)) {
            teXParser.logMessage(String.format("PROCESSING %s: %s", this.getClass().getSimpleName(), this.toString(teXParser)));
        }
        if (teXParser.isDebugMode(256)) {
            teXParser.logMessage("PROCESSING GROUP: " + this.toString());
        }
        StackMarker stackMarker = new StackMarker();
        TeXObjectList teXObjectList = this.toList();
        teXObjectList.add(stackMarker);
        this.clear();
        this.startGroup(teXParser);
        teXObjectList.processList(teXParser, stackMarker);
        this.endGroup(teXParser);
        teXParser.push(teXObjectList, true);
    }

    public void startGroup(TeXParser teXParser) throws IOException {
        teXParser.startGroup();
    }

    public void endGroup(TeXParser teXParser) throws IOException {
        teXParser.endGroup();
    }

    public TeXObjectList splitTokens(TeXParser teXParser) {
        TeXObjectList teXObjectList = new TeXObjectList();
        TeXObject teXObject = this.getBegin(teXParser);
        if (teXObject instanceof MultiToken) {
            teXObjectList.addAll(((MultiToken)teXObject).splitTokens(teXParser));
        } else {
            teXObjectList.add(teXObject);
        }
        teXObjectList.addAll(this);
        teXObject = this.getEnd(teXParser);
        if (teXObject instanceof MultiToken) {
            teXObjectList.addAll(((MultiToken)teXObject).splitTokens(teXParser));
        } else {
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(this.getBegin(teXParser));
        teXObjectList.addAll(this);
        teXObjectList.add(this.getEnd(teXParser));
        return teXObjectList.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        teXObjectList2.add(this.getBegin(teXParser));
        teXObjectList2.addAll(this);
        teXObjectList2.add(this.getEnd(teXParser));
        if (teXObjectList != null && teXObjectList != teXParser) {
            while (teXObjectList.size() > 0) {
                teXObjectList2.add((TeXObject)teXObjectList.remove(0));
            }
        }
        return teXObjectList2.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(this.getBegin(teXParser));
        teXObjectList.addAll(this);
        teXObjectList.add(this.getEnd(teXParser));
        return teXObjectList.expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        teXObjectList2.add(this.getBegin(teXParser));
        teXObjectList2.addAll(this);
        teXObjectList2.add(this.getEnd(teXParser));
        StackMarker stackMarker = null;
        if (teXObjectList != null && teXObjectList != teXParser && !teXObjectList.isEmpty()) {
            stackMarker = new StackMarker();
            teXObjectList2.add(stackMarker);
            while (teXObjectList.size() > 0) {
                teXObjectList2.add((TeXObject)teXObjectList.remove(0), true);
            }
        }
        TeXObjectList teXObjectList3 = teXObjectList2.expandfully(teXParser);
        if (stackMarker != null) {
            int n = -1;
            for (int i = 0; i < teXObjectList3.size(); ++i) {
                TeXObject teXObject = (TeXObject)teXObjectList3.get(i);
                if (n != -1) {
                    teXObjectList.add(teXObject);
                    continue;
                }
                if (!teXObject.equals(stackMarker)) continue;
                n = i;
            }
            if (n != -1) {
                teXObjectList3.setSize(n);
            }
        }
        return teXObjectList3;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return String.format("%s%s%s", this.getBegin(teXParser).toString(teXParser), super.toString(teXParser), this.getEnd(teXParser).toString(teXParser));
    }

    @Override
    public String toString() {
        return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
    }

    @Override
    public String format() {
        return "{" + super.format() + "}";
    }

    @Override
    public String toTruncatedString(TeXParser teXParser, int n, String string) {
        return String.format("%s%s%s", this.getBegin(teXParser).toString(teXParser), super.toTruncatedString(teXParser, n, string), this.getEnd(teXParser).toString(teXParser));
    }

    public TeXObject getBegin(TeXParser teXParser) {
        return teXParser.getListener().getBgChar(teXParser.getBgChar());
    }

    public TeXObject getEnd(TeXParser teXParser) {
        return teXParser.getListener().getEgChar(teXParser.getEgChar());
    }
}

