/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.ReadBufferOverflowException;

public class AsyncChannelWrapperSecure
implements AsyncChannelWrapper {
    private final Log log = LogFactory.getLog(AsyncChannelWrapperSecure.class);
    private static final StringManager sm = StringManager.getManager(AsyncChannelWrapperSecure.class);
    private static final ByteBuffer DUMMY = ByteBuffer.allocate(16921);
    private final AsynchronousSocketChannel socketChannel;
    private final SSLEngine sslEngine;
    private final ByteBuffer socketReadBuffer;
    private final ByteBuffer socketWriteBuffer;
    private final ExecutorService executor = Executors.newFixedThreadPool(2, new SecureIOThreadFactory());
    private AtomicBoolean writing = new AtomicBoolean(false);
    private AtomicBoolean reading = new AtomicBoolean(false);

    public AsyncChannelWrapperSecure(AsynchronousSocketChannel asynchronousSocketChannel, SSLEngine sSLEngine) {
        this.socketChannel = asynchronousSocketChannel;
        this.sslEngine = sSLEngine;
        int n = sSLEngine.getSession().getPacketBufferSize();
        this.socketReadBuffer = ByteBuffer.allocateDirect(n);
        this.socketWriteBuffer = ByteBuffer.allocateDirect(n);
    }

    @Override
    public Future<Integer> read(ByteBuffer byteBuffer) {
        WrapperFuture wrapperFuture = new WrapperFuture();
        if (!this.reading.compareAndSet(false, true)) {
            throw new IllegalStateException(sm.getString("asyncChannelWrapperSecure.concurrentRead"));
        }
        ReadTask readTask = new ReadTask(byteBuffer, wrapperFuture);
        this.executor.execute(readTask);
        return wrapperFuture;
    }

    @Override
    public <B, A extends B> void read(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, B> completionHandler) {
        WrapperFuture<Integer, B> wrapperFuture = new WrapperFuture<Integer, B>(completionHandler, a);
        if (!this.reading.compareAndSet(false, true)) {
            throw new IllegalStateException(sm.getString("asyncChannelWrapperSecure.concurrentRead"));
        }
        ReadTask readTask = new ReadTask(byteBuffer, wrapperFuture);
        this.executor.execute(readTask);
    }

    @Override
    public Future<Integer> write(ByteBuffer byteBuffer) {
        WrapperFuture wrapperFuture = new WrapperFuture();
        if (!this.writing.compareAndSet(false, true)) {
            throw new IllegalStateException(sm.getString("asyncChannelWrapperSecure.concurrentWrite"));
        }
        WriteTask writeTask = new WriteTask(new ByteBuffer[]{byteBuffer}, 0, 1, wrapperFuture);
        this.executor.execute(writeTask);
        LongToIntegerFuture longToIntegerFuture = new LongToIntegerFuture(wrapperFuture);
        return longToIntegerFuture;
    }

    @Override
    public <B, A extends B> void write(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, B> completionHandler) {
        WrapperFuture<Long, B> wrapperFuture = new WrapperFuture<Long, B>(completionHandler, a);
        if (!this.writing.compareAndSet(false, true)) {
            throw new IllegalStateException(sm.getString("asyncChannelWrapperSecure.concurrentWrite"));
        }
        WriteTask writeTask = new WriteTask(byteBufferArray, n, n2, wrapperFuture);
        this.executor.execute(writeTask);
    }

    @Override
    public void close() {
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            this.log.info((Object)sm.getString("asyncChannelWrapperSecure.closeFail"));
        }
        this.executor.shutdownNow();
    }

    @Override
    public Future<Void> handshake() throws SSLException {
        WrapperFuture<Void, Void> wrapperFuture = new WrapperFuture<Void, Void>();
        WebSocketSslHandshakeThread webSocketSslHandshakeThread = new WebSocketSslHandshakeThread(wrapperFuture);
        webSocketSslHandshakeThread.start();
        return wrapperFuture;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.socketChannel.getLocalAddress();
    }

    static /* synthetic */ AtomicBoolean access$700(AsyncChannelWrapperSecure asyncChannelWrapperSecure) {
        return asyncChannelWrapperSecure.reading;
    }

    private static class SecureIOThreadFactory
    implements ThreadFactory {
        private AtomicInteger count = new AtomicInteger(0);

        private SecureIOThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("WebSocketClient-SecureIO-" + this.count.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class WrapperFuture<T, A>
    implements Future<T> {
        private final CompletionHandler<T, A> handler;
        private final A attachment;
        private volatile T result = null;
        private volatile Throwable throwable = null;
        private CountDownLatch completionLatch = new CountDownLatch(1);

        WrapperFuture() {
            this(null, null);
        }

        WrapperFuture(CompletionHandler<T, A> completionHandler, A a) {
            this.handler = completionHandler;
            this.attachment = a;
        }

        public void complete(T t) {
            this.result = t;
            this.completionLatch.countDown();
            if (this.handler != null) {
                this.handler.completed(t, this.attachment);
            }
        }

        public void fail(Throwable throwable) {
            this.throwable = throwable;
            this.completionLatch.countDown();
            if (this.handler != null) {
                this.handler.failed(this.throwable, this.attachment);
            }
        }

        @Override
        public final boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public final boolean isCancelled() {
            return false;
        }

        @Override
        public final boolean isDone() {
            return this.completionLatch.getCount() > 0L;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.completionLatch.await();
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            return this.result;
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            boolean bl = this.completionLatch.await(l, timeUnit);
            if (!bl) {
                throw new TimeoutException();
            }
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            return this.result;
        }
    }

    private class ReadTask
    implements Runnable {
        private final ByteBuffer dest;
        private final WrapperFuture<Integer, ?> future;

        ReadTask(ByteBuffer byteBuffer, WrapperFuture<Integer, ?> wrapperFuture) {
            this.dest = byteBuffer;
            this.future = wrapperFuture;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void run() {
            var1_1 = 0;
            var2_2 = false;
lbl3:
            // 2 sources

            try {
                while (var1_1 == 0) {
                    block15: {
                        AsyncChannelWrapperSecure.access$600(AsyncChannelWrapperSecure.this).compact();
                        if (var2_2) {
                            var2_2 = false;
                            var3_3 = AsyncChannelWrapperSecure.access$400(AsyncChannelWrapperSecure.this).read(AsyncChannelWrapperSecure.access$600(AsyncChannelWrapperSecure.this));
                            var4_5 /* !! */  = var3_3.get();
                            if (var4_5 /* !! */  == -1) {
                                throw new EOFException(AsyncChannelWrapperSecure.access$300().getString("asyncChannelWrapperSecure.eof"));
                            }
                        }
                        AsyncChannelWrapperSecure.access$600(AsyncChannelWrapperSecure.this).flip();
                        if (!AsyncChannelWrapperSecure.access$600(AsyncChannelWrapperSecure.this).hasRemaining()) break block15;
                        var3_3 = AsyncChannelWrapperSecure.access$200(AsyncChannelWrapperSecure.this).unwrap(AsyncChannelWrapperSecure.access$600(AsyncChannelWrapperSecure.this), this.dest);
                        var1_1 += var3_3.bytesProduced();
                        var4_5 /* !! */  = var3_3.getStatus();
                        if (var4_5 /* !! */  != SSLEngineResult.Status.OK) {
                            if (var4_5 /* !! */  == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                                if (var1_1 == 0) {
                                    var2_2 = true;
                                }
                            } else if (var4_5 /* !! */  == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                                if (AsyncChannelWrapperSecure.access$700(AsyncChannelWrapperSecure.this).compareAndSet(true, false)) {
                                    throw new ReadBufferOverflowException(AsyncChannelWrapperSecure.access$200(AsyncChannelWrapperSecure.this).getSession().getApplicationBufferSize());
                                }
                                this.future.fail(new IllegalStateException(AsyncChannelWrapperSecure.access$300().getString("asyncChannelWrapperSecure.wrongStateRead")));
                            } else {
                                throw new IllegalStateException(AsyncChannelWrapperSecure.access$300().getString("asyncChannelWrapperSecure.statusUnwrap"));
                            }
                        }
                        if (var3_3.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                        var5_6 = AsyncChannelWrapperSecure.access$200(AsyncChannelWrapperSecure.this).getDelegatedTask();
                        while (var5_6 != null) {
                            var5_6.run();
                            var5_6 = AsyncChannelWrapperSecure.access$200(AsyncChannelWrapperSecure.this).getDelegatedTask();
                        }
                        ** GOTO lbl3
                    }
                    var2_2 = true;
                }
                if (AsyncChannelWrapperSecure.access$700(AsyncChannelWrapperSecure.this).compareAndSet(true, false)) {
                    this.future.complete(var1_1);
                } else {
                    this.future.fail(new IllegalStateException(AsyncChannelWrapperSecure.access$300().getString("asyncChannelWrapperSecure.wrongStateRead")));
                }
            }
            catch (EOFException | InterruptedException | RuntimeException | ExecutionException | SSLException | ReadBufferOverflowException var3_4) {
                AsyncChannelWrapperSecure.access$700(AsyncChannelWrapperSecure.this).set(false);
                this.future.fail(var3_4);
            }
        }
    }

    private class WriteTask
    implements Runnable {
        private final ByteBuffer[] srcs;
        private final int offset;
        private final int length;
        private final WrapperFuture<Long, ?> future;

        WriteTask(ByteBuffer[] byteBufferArray, int n, int n2, WrapperFuture<Long, ?> wrapperFuture) {
            this.srcs = byteBufferArray;
            this.future = wrapperFuture;
            this.offset = n;
            this.length = n2;
        }

        @Override
        public void run() {
            long l = 0L;
            try {
                for (int i = this.offset; i < this.offset + this.length; ++i) {
                    ByteBuffer byteBuffer = this.srcs[i];
                    while (byteBuffer.hasRemaining()) {
                        Integer n;
                        AsyncChannelWrapperSecure.this.socketWriteBuffer.clear();
                        SSLEngineResult sSLEngineResult = AsyncChannelWrapperSecure.this.sslEngine.wrap(byteBuffer, AsyncChannelWrapperSecure.this.socketWriteBuffer);
                        l += (long)sSLEngineResult.bytesConsumed();
                        SSLEngineResult.Status status = sSLEngineResult.getStatus();
                        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            throw new IllegalStateException(sm.getString("asyncChannelWrapperSecure.statusWrap"));
                        }
                        if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            Runnable runnable = AsyncChannelWrapperSecure.this.sslEngine.getDelegatedTask();
                            while (runnable != null) {
                                runnable.run();
                                runnable = AsyncChannelWrapperSecure.this.sslEngine.getDelegatedTask();
                            }
                        }
                        AsyncChannelWrapperSecure.this.socketWriteBuffer.flip();
                        for (int j = sSLEngineResult.bytesProduced(); j > 0; j -= n.intValue()) {
                            Future<Integer> future = AsyncChannelWrapperSecure.this.socketChannel.write(AsyncChannelWrapperSecure.this.socketWriteBuffer);
                            n = future.get();
                        }
                    }
                }
                if (AsyncChannelWrapperSecure.this.writing.compareAndSet(true, false)) {
                    this.future.complete(l);
                } else {
                    this.future.fail(new IllegalStateException(sm.getString("asyncChannelWrapperSecure.wrongStateWrite")));
                }
            }
            catch (Exception exception) {
                AsyncChannelWrapperSecure.this.writing.set(false);
                this.future.fail(exception);
            }
        }
    }

    private static final class LongToIntegerFuture
    implements Future<Integer> {
        private final Future<Long> wrapped;

        LongToIntegerFuture(Future<Long> future) {
            this.wrapped = future;
        }

        @Override
        public boolean cancel(boolean bl) {
            return this.wrapped.cancel(bl);
        }

        @Override
        public boolean isCancelled() {
            return this.wrapped.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.wrapped.isDone();
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            Long l = this.wrapped.get();
            if (l > Integer.MAX_VALUE) {
                throw new ExecutionException(sm.getString("asyncChannelWrapperSecure.tooBig", new Object[]{l}), null);
            }
            return l.intValue();
        }

        @Override
        public Integer get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            Long l2 = this.wrapped.get(l, timeUnit);
            if (l2 > Integer.MAX_VALUE) {
                throw new ExecutionException(sm.getString("asyncChannelWrapperSecure.tooBig", new Object[]{l2}), null);
            }
            return l2.intValue();
        }
    }

    private class WebSocketSslHandshakeThread
    extends Thread {
        private final WrapperFuture<Void, Void> hFuture;
        private SSLEngineResult.HandshakeStatus handshakeStatus;
        private SSLEngineResult.Status resultStatus;

        WebSocketSslHandshakeThread(WrapperFuture<Void, Void> wrapperFuture) {
            this.hFuture = wrapperFuture;
        }

        @Override
        public void run() {
            try {
                AsyncChannelWrapperSecure.this.sslEngine.beginHandshake();
                AsyncChannelWrapperSecure.this.socketReadBuffer.position(AsyncChannelWrapperSecure.this.socketReadBuffer.limit());
                this.handshakeStatus = AsyncChannelWrapperSecure.this.sslEngine.getHandshakeStatus();
                this.resultStatus = SSLEngineResult.Status.OK;
                boolean bl = true;
                while (bl) {
                    switch (this.handshakeStatus) {
                        case NEED_WRAP: {
                            AsyncChannelWrapperSecure.this.socketWriteBuffer.clear();
                            Object object = AsyncChannelWrapperSecure.this.sslEngine.wrap(DUMMY, AsyncChannelWrapperSecure.this.socketWriteBuffer);
                            this.checkResult((SSLEngineResult)object, true);
                            AsyncChannelWrapperSecure.this.socketWriteBuffer.flip();
                            Future<Integer> future = AsyncChannelWrapperSecure.this.socketChannel.write(AsyncChannelWrapperSecure.this.socketWriteBuffer);
                            future.get();
                            break;
                        }
                        case NEED_UNWRAP: {
                            Object object;
                            AsyncChannelWrapperSecure.this.socketReadBuffer.compact();
                            if (AsyncChannelWrapperSecure.this.socketReadBuffer.position() == 0 || this.resultStatus == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                                object = AsyncChannelWrapperSecure.this.socketChannel.read(AsyncChannelWrapperSecure.this.socketReadBuffer);
                                object.get();
                            }
                            AsyncChannelWrapperSecure.this.socketReadBuffer.flip();
                            object = AsyncChannelWrapperSecure.this.sslEngine.unwrap(AsyncChannelWrapperSecure.this.socketReadBuffer, DUMMY);
                            this.checkResult((SSLEngineResult)object, false);
                            break;
                        }
                        case NEED_TASK: {
                            Object object = null;
                            while ((object = AsyncChannelWrapperSecure.this.sslEngine.getDelegatedTask()) != null) {
                                object.run();
                            }
                            this.handshakeStatus = AsyncChannelWrapperSecure.this.sslEngine.getHandshakeStatus();
                            break;
                        }
                        case FINISHED: {
                            bl = false;
                            break;
                        }
                        case NOT_HANDSHAKING: {
                            throw new SSLException(sm.getString("asyncChannelWrapperSecure.notHandshaking"));
                        }
                    }
                }
            }
            catch (Exception exception) {
                this.hFuture.fail(exception);
                return;
            }
            this.hFuture.complete(null);
        }

        private void checkResult(SSLEngineResult sSLEngineResult, boolean bl) throws SSLException {
            this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
            this.resultStatus = sSLEngineResult.getStatus();
            if (this.resultStatus != SSLEngineResult.Status.OK && (bl || this.resultStatus != SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
                throw new SSLException(sm.getString("asyncChannelWrapperSecure.check.notOk", new Object[]{this.resultStatus}));
            }
            if (bl && sSLEngineResult.bytesConsumed() != 0) {
                throw new SSLException(sm.getString("asyncChannelWrapperSecure.check.wrap"));
            }
            if (!bl && sSLEngineResult.bytesProduced() != 0) {
                throw new SSLException(sm.getString("asyncChannelWrapperSecure.check.unwrap"));
            }
        }
    }
}

