import { Definition, Fz, KeyValue, KeyValueAny, Logger, Publish, Tz, Zh } from './types';
export declare function isLegacyEnabled(options: KeyValue): unknown;
export declare function precisionRound(number: number, precision: number): number;
export declare function toLocalISOString(dDate: Date): string;
export declare function numberWithinRange(number: number, min: number, max: number): number;
/**
 * Maps number from one range to another. In other words it performs a linear interpolation.
 * Note that this function can interpolate values outside source range (linear extrapolation).
 * @param {number} value value to map
 * @param {number} fromLow source range lower value
 * @param {number} fromHigh source range upper value
 * @param {number} toLow target range lower value
 * @param {number} toHigh target range upper value
 * @param {number} [precision=0] number of decimal places to which result should be rounded
 * @return {number} value mapped to new range
 */
export declare function mapNumberRange(value: number, fromLow: number, fromHigh: number, toLow: number, toHigh: number, precision?: number): number;
export declare function hasAlreadyProcessedMessage(msg: Fz.Message, model: Definition, ID?: number, key?: string): boolean;
export declare const calibrateAndPrecisionRoundOptionsDefaultPrecision: KeyValue;
export declare function calibrateAndPrecisionRoundOptionsIsPercentual(type: string): boolean;
export declare function calibrateAndPrecisionRoundOptions(number: number, options: KeyValue, type: string): number;
export declare function toPercentage(value: number, min: number, max: number, log?: boolean): number;
export declare function addActionGroup(payload: KeyValue, msg: Fz.Message, definition: Definition): void;
export declare function postfixWithEndpointName(value: string, msg: Fz.Message, definition: Definition, meta: Fz.Meta): string;
export declare function enforceEndpoint(entity: Zh.Endpoint, key: string, meta: Tz.Meta): import("zigbee-herdsman/dist/controller/model/endpoint").default;
export declare function getKey<T>(object: {
    [s: string]: T;
}, value: T, fallback?: T, convertTo?: (v: unknown) => T): string | T;
export declare function batteryVoltageToPercentage(voltage: number, option: string | {
    min: number;
    max: number;
}): number;
export declare function getMetaValue<T>(entity: Zh.Group | Zh.Endpoint, definition: Definition | Definition[], key: string, groupStrategy?: string, defaultValue?: T): T;
export declare function hasEndpoints(device: Zh.Device, endpoints: number[]): boolean;
export declare function isInRange(min: number, max: number, value: number): boolean;
export declare function replaceInArray<T>(arr: T[], oldElements: T[], newElements: T[]): T[];
export declare function filterObject(obj: KeyValue, keys: string[]): KeyValue;
export declare function sleep(ms: number): Promise<unknown>;
export declare function toSnakeCase(value: string | KeyValueAny): string | KeyValueAny;
export declare function toCamelCase(value: KeyValueAny | string): string | KeyValueAny;
export declare function getLabelFromName(name: string): string;
export declare function saveSceneState(entity: Zh.Endpoint, sceneID: number, groupID: number, state: KeyValue, name: string): void;
export declare function deleteSceneState(entity: Zh.Endpoint, sceneID?: number, groupID?: number): void;
export declare function getSceneState(entity: Zh.Group | Zh.Endpoint, sceneID: number, groupID: number): any;
export declare function getEntityOrFirstGroupMember(entity: Zh.Group | Zh.Endpoint): import("zigbee-herdsman/dist/controller/model/endpoint").default;
export declare function getTransition(entity: Zh.Endpoint | Zh.Group, key: string, meta: Tz.Meta): {
    time: number;
    specified: boolean;
};
export declare function getOptions(definition: Definition, entity: Zh.Endpoint | Zh.Group, options?: {}): KeyValue;
export declare function getMetaValues(definition: Definition, entity: Zh.Endpoint | Zh.Group, allowed?: string[], options?: {}): KeyValue;
export declare function getObjectProperty(object: KeyValue, key: string, defaultValue: unknown): unknown;
export declare function validateValue(value: unknown, allowed: unknown[]): void;
export declare function normalizeCelsiusVersionOfFahrenheit(value: number): string;
export declare function noOccupancySince(endpoint: Zh.Endpoint, options: KeyValueAny, publish: Publish, action: 'start' | 'stop'): void;
export declare function attachOutputCluster(device: Zh.Device, clusterKey: string): void;
/**
 * @param {number} value
 * @param {number} hexLength
 * @return {string}
 */
export declare function printNumberAsHex(value: number, hexLength: number): string;
/**
 * @param {number[]} numbers
 * @param {number} hexLength
 * @return {string}
 */
export declare function printNumbersAsHexSequence(numbers: number[], hexLength: number): string;
/**
 * @param {logger} logger
 * @param {vendor} vendor
 * @param {key} key
 * @returns {(level: string, message: string) => void}
 */
export declare const createLogger: (logger: Logger, vendor: string, key: string) => (level: 'debug' | 'info' | 'warn' | 'error', message: string) => void;
export declare function assertString(value: unknown, property?: string): asserts value is string;
export declare function assertNumber(value: unknown, property?: string): asserts value is number;
export declare function toNumber(value: unknown, property?: string): number;
export declare function getFromLookup<V>(value: unknown, lookup: {
    [s: number | string]: V;
}): V;
export declare function assertEndpoint(obj: unknown): asserts obj is Zh.Endpoint;
export declare function isEndpoint(obj: Zh.Endpoint | Zh.Group | Zh.Device): obj is Zh.Endpoint;
export declare function isDevice(obj: Zh.Endpoint | Zh.Group | Zh.Device): obj is Zh.Device;
export declare function isGroup(obj: Zh.Endpoint | Zh.Group | Zh.Device): obj is Zh.Group;
//# sourceMappingURL=utils.d.ts.map