/* Generated by wayland-scanner 1.23.0 */

#ifndef FROG_COLOR_MANAGEMENT_V1_SERVER_PROTOCOL_H
#define FROG_COLOR_MANAGEMENT_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_frog_color_management_v1 The frog_color_management_v1 protocol
 * experimental color management protocol
 *
 * @section page_desc_frog_color_management_v1 Description
 *
 * The aim of this color management extension is to get HDR games working quickly,
 * and have an easy way to test implementations in the wild before the upstream
 * protocol is ready to be merged.
 * For that purpose it's intentionally limited and cut down and does not serve
 * all uses cases.
 *
 * @section page_ifaces_frog_color_management_v1 Interfaces
 * - @subpage page_iface_frog_color_management_factory_v1 - color management factory
 * - @subpage page_iface_frog_color_managed_surface - color managed surface
 * @section page_copyright_frog_color_management_v1 Copyright
 * <pre>
 *
 * Copyright © 2023 Joshua Ashton for Valve Software
 * Copyright © 2023 Xaver Hugl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct frog_color_managed_surface;
struct frog_color_management_factory_v1;
struct wl_surface;

#ifndef FROG_COLOR_MANAGEMENT_FACTORY_V1_INTERFACE
#define FROG_COLOR_MANAGEMENT_FACTORY_V1_INTERFACE
/**
 * @page page_iface_frog_color_management_factory_v1 frog_color_management_factory_v1
 * @section page_iface_frog_color_management_factory_v1_desc Description
 *
 * The color management factory singleton creates color managed surface objects.
 * @section page_iface_frog_color_management_factory_v1_api API
 * See @ref iface_frog_color_management_factory_v1.
 */
/**
 * @defgroup iface_frog_color_management_factory_v1 The frog_color_management_factory_v1 interface
 *
 * The color management factory singleton creates color managed surface objects.
 */
extern const struct wl_interface frog_color_management_factory_v1_interface;
#endif
#ifndef FROG_COLOR_MANAGED_SURFACE_INTERFACE
#define FROG_COLOR_MANAGED_SURFACE_INTERFACE
/**
 * @page page_iface_frog_color_managed_surface frog_color_managed_surface
 * @section page_iface_frog_color_managed_surface_desc Description
 *
 * Interface for changing surface color management and HDR state.
 *
 * An implementation must: support every part of the version
 * of the frog_color_managed_surface interface it exposes.
 * Including all known enums associated with a given version.
 * @section page_iface_frog_color_managed_surface_api API
 * See @ref iface_frog_color_managed_surface.
 */
/**
 * @defgroup iface_frog_color_managed_surface The frog_color_managed_surface interface
 *
 * Interface for changing surface color management and HDR state.
 *
 * An implementation must: support every part of the version
 * of the frog_color_managed_surface interface it exposes.
 * Including all known enums associated with a given version.
 */
extern const struct wl_interface frog_color_managed_surface_interface;
#endif

/**
 * @ingroup iface_frog_color_management_factory_v1
 * @struct frog_color_management_factory_v1_interface
 */
struct frog_color_management_factory_v1_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create color management interface for surface
	 *
	 * 
	 * @param surface target surface
	 * @param callback new color managed surface object
	 */
	void (*get_color_managed_surface)(struct wl_client *client,
					  struct wl_resource *resource,
					  struct wl_resource *surface,
					  uint32_t callback);
};


/**
 * @ingroup iface_frog_color_management_factory_v1
 */
#define FROG_COLOR_MANAGEMENT_FACTORY_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_frog_color_management_factory_v1
 */
#define FROG_COLOR_MANAGEMENT_FACTORY_V1_GET_COLOR_MANAGED_SURFACE_SINCE_VERSION 1

#ifndef FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_ENUM
#define FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_ENUM
/**
 * @ingroup iface_frog_color_managed_surface
 * known transfer functions
 *
 * Extended information on the transfer functions described
 * here can be found in the Khronos Data Format specification:
 *
 * https://registry.khronos.org/DataFormat/specs/1.3/dataformat.1.3.html
 */
enum frog_color_managed_surface_transfer_function {
	/**
	 * specifies undefined, implementation-specific handling of the surface's transfer function.
	 */
	FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_UNDEFINED = 0,
	/**
	 * specifies the sRGB non-linear EOTF. An implementation may: display this as Gamma 2.2 for the purposes of being consistent with content rendering across displays, rendering_intent and user expectations.
	 */
	FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_SRGB = 1,
	/**
	 * specifies gamma 2.2 power curve as the EOTF
	 */
	FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_GAMMA_22 = 2,
	/**
	 * specifies the SMPTE ST2084 Perceptual Quantizer (PQ) EOTF
	 */
	FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_ST2084_PQ = 3,
	/**
	 * specifies the scRGB (extended sRGB) linear EOTF. Note: Primaries outside the gamut triangle specified can be expressed with negative values for this transfer function.
	 */
	FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_SCRGB_LINEAR = 4,
};
/**
 * @ingroup iface_frog_color_managed_surface
 * Validate a frog_color_managed_surface transfer_function value.
 *
 * @return true on success, false on error.
 * @ref frog_color_managed_surface_transfer_function
 */
static inline bool
frog_color_managed_surface_transfer_function_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_UNDEFINED:
		return version >= 1;
	case FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_SRGB:
		return version >= 1;
	case FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_GAMMA_22:
		return version >= 1;
	case FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_ST2084_PQ:
		return version >= 1;
	case FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_SCRGB_LINEAR:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* FROG_COLOR_MANAGED_SURFACE_TRANSFER_FUNCTION_ENUM */

#ifndef FROG_COLOR_MANAGED_SURFACE_PRIMARIES_ENUM
#define FROG_COLOR_MANAGED_SURFACE_PRIMARIES_ENUM
/**
 * @ingroup iface_frog_color_managed_surface
 * known primaries
 */
enum frog_color_managed_surface_primaries {
	/**
	 * specifies undefined, implementation-specific handling
	 */
	FROG_COLOR_MANAGED_SURFACE_PRIMARIES_UNDEFINED = 0,
	/**
	 * specifies Rec.709/sRGB primaries with D65 white point
	 */
	FROG_COLOR_MANAGED_SURFACE_PRIMARIES_REC709 = 1,
	/**
	 * specifies Rec.2020/HDR10 primaries with D65 white point
	 */
	FROG_COLOR_MANAGED_SURFACE_PRIMARIES_REC2020 = 2,
};
/**
 * @ingroup iface_frog_color_managed_surface
 * Validate a frog_color_managed_surface primaries value.
 *
 * @return true on success, false on error.
 * @ref frog_color_managed_surface_primaries
 */
static inline bool
frog_color_managed_surface_primaries_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case FROG_COLOR_MANAGED_SURFACE_PRIMARIES_UNDEFINED:
		return version >= 1;
	case FROG_COLOR_MANAGED_SURFACE_PRIMARIES_REC709:
		return version >= 1;
	case FROG_COLOR_MANAGED_SURFACE_PRIMARIES_REC2020:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* FROG_COLOR_MANAGED_SURFACE_PRIMARIES_ENUM */

#ifndef FROG_COLOR_MANAGED_SURFACE_RENDER_INTENT_ENUM
#define FROG_COLOR_MANAGED_SURFACE_RENDER_INTENT_ENUM
/**
 * @ingroup iface_frog_color_managed_surface
 * known render intents
 *
 * Extended information on render intents described
 * here can be found in ICC.1:2022:
 *
 * https://www.color.org/specification/ICC.1-2022-05.pdf
 */
enum frog_color_managed_surface_render_intent {
	/**
	 * perceptual
	 */
	FROG_COLOR_MANAGED_SURFACE_RENDER_INTENT_PERCEPTUAL = 0,
};
/**
 * @ingroup iface_frog_color_managed_surface
 * Validate a frog_color_managed_surface render_intent value.
 *
 * @return true on success, false on error.
 * @ref frog_color_managed_surface_render_intent
 */
static inline bool
frog_color_managed_surface_render_intent_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case FROG_COLOR_MANAGED_SURFACE_RENDER_INTENT_PERCEPTUAL:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* FROG_COLOR_MANAGED_SURFACE_RENDER_INTENT_ENUM */

/**
 * @ingroup iface_frog_color_managed_surface
 * @struct frog_color_managed_surface_interface
 */
struct frog_color_managed_surface_interface {
	/**
	 * destroy color managed surface
	 *
	 * Destroying the color managed surface resets all known color
	 * state for the surface back to 'undefined'
	 * implementation-specific values.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * sets a known transfer function for a surface
	 *
	 * 
	 * @param transfer_function transfer function for the surface
	 */
	void (*set_known_transfer_function)(struct wl_client *client,
					    struct wl_resource *resource,
					    uint32_t transfer_function);
	/**
	 * sets the container color volume (primaries) for a surface
	 *
	 * 
	 * @param primaries primaries for the surface
	 */
	void (*set_known_container_color_volume)(struct wl_client *client,
						 struct wl_resource *resource,
						 uint32_t primaries);
	/**
	 * sets the render intent for a surface
	 *
	 * NOTE: On a surface with "perceptual" (default) render intent,
	 * handling of the container's color volume is
	 * implementation-specific, and may differ between different
	 * transfer functions it is paired with: ie. sRGB + 709 rendering
	 * may have it's primaries widened to more of the available
	 * display's gamut to be be more pleasing for the viewer. Compared
	 * to scRGB Linear + 709 being treated faithfully as 709 (including
	 * utilizing negatives out of the 709 gamut triangle)
	 * @param render_intent render intent for the surface
	 */
	void (*set_render_intent)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t render_intent);
	/**
	 * max frame average light level
	 *
	 * Max Frame Average Light Level. This value is coded as an
	 * unsigned 16-bit value in units of 1 cd/m2, where 0x0001
	 * represents 1 cd/m2 and 0xFFFF represents 65535 cd/m2.
	 */
	void (*set_hdr_metadata)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t mastering_display_primary_red_x,
				 uint32_t mastering_display_primary_red_y,
				 uint32_t mastering_display_primary_green_x,
				 uint32_t mastering_display_primary_green_y,
				 uint32_t mastering_display_primary_blue_x,
				 uint32_t mastering_display_primary_blue_y,
				 uint32_t mastering_white_point_x,
				 uint32_t mastering_white_point_y,
				 uint32_t max_display_mastering_luminance,
				 uint32_t min_display_mastering_luminance,
				 uint32_t max_cll,
				 uint32_t max_fall);
};

#define FROG_COLOR_MANAGED_SURFACE_PREFERRED_METADATA 0

/**
 * @ingroup iface_frog_color_managed_surface
 */
#define FROG_COLOR_MANAGED_SURFACE_PREFERRED_METADATA_SINCE_VERSION 1

/**
 * @ingroup iface_frog_color_managed_surface
 */
#define FROG_COLOR_MANAGED_SURFACE_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_frog_color_managed_surface
 */
#define FROG_COLOR_MANAGED_SURFACE_SET_KNOWN_TRANSFER_FUNCTION_SINCE_VERSION 1
/**
 * @ingroup iface_frog_color_managed_surface
 */
#define FROG_COLOR_MANAGED_SURFACE_SET_KNOWN_CONTAINER_COLOR_VOLUME_SINCE_VERSION 1
/**
 * @ingroup iface_frog_color_managed_surface
 */
#define FROG_COLOR_MANAGED_SURFACE_SET_RENDER_INTENT_SINCE_VERSION 1
/**
 * @ingroup iface_frog_color_managed_surface
 */
#define FROG_COLOR_MANAGED_SURFACE_SET_HDR_METADATA_SINCE_VERSION 1

/**
 * @ingroup iface_frog_color_managed_surface
 * Sends an preferred_metadata event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
frog_color_managed_surface_send_preferred_metadata(struct wl_resource *resource_, uint32_t transfer_function, uint32_t output_display_primary_red_x, uint32_t output_display_primary_red_y, uint32_t output_display_primary_green_x, uint32_t output_display_primary_green_y, uint32_t output_display_primary_blue_x, uint32_t output_display_primary_blue_y, uint32_t output_white_point_x, uint32_t output_white_point_y, uint32_t max_luminance, uint32_t min_luminance, uint32_t max_full_frame_luminance)
{
	wl_resource_post_event(resource_, FROG_COLOR_MANAGED_SURFACE_PREFERRED_METADATA, transfer_function, output_display_primary_red_x, output_display_primary_red_y, output_display_primary_green_x, output_display_primary_green_y, output_display_primary_blue_x, output_display_primary_blue_y, output_white_point_x, output_white_point_y, max_luminance, min_luminance, max_full_frame_luminance);
}

#ifdef  __cplusplus
}
#endif

#endif
