"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkbenchPlugin = void 0;
var _routes = _interopRequireDefault(require("./routes"));
var _sqlPlugin = _interopRequireDefault(require("./clusters/sql/sqlPlugin"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class WorkbenchPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core) {
    this.logger.debug('queryWorkbenchDashboards: Setup');
    const router = core.http.createRouter();
    const client = core.opensearch.legacy.createClient('query_workbench', {
      plugins: [_sqlPlugin.default]
    });

    // Register server side APIs
    (0, _routes.default)(router, client);
    return {};
  }
  start(core) {
    this.logger.debug('queryWorkbenchDashboards: Started');
    return {};
  }
  stop() {}
}
exports.WorkbenchPlugin = WorkbenchPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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