set(XdgUtils_VERSION 0.1.1)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was XdgUtilsConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/XdgUtils" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(XDGUTILS_LIBDIR ${PACKAGE_PREFIX_DIR}/lib/XdgUtils)
set_and_check(XDGUTILS_INCLUDE_DIRECTORIES ${PACKAGE_PREFIX_DIR}/include/XdgUtils)

set(XDGUTILS_LINK_LIBRARIES XdgUtilsDesktopEntry;XdgUtilsBaseDir)

## Try to find the required components
foreach(comp ${XdgUtils_FIND_COMPONENTS})
    set(COMPONENT_TARGETS_FILE "${CMAKE_CURRENT_LIST_DIR}/XdgUtils${comp}.cmake")
    if(EXISTS "${COMPONENT_TARGETS_FILE}")
        set(XdgUtils_${comp}_FOUND TRUE)
        include("${COMPONENT_TARGETS_FILE}")

        message(STATUS "XdgUtils::${comp} found")
    else()
        if(XdgUtils_FIND_REQUIRED_${comp})
            message(FATAL_ERROR "XdgUtils::${comp} not found !")
        endif()
    endif()
endforeach()

check_required_components(XdgUtils)
