/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.docprovider;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.config.Defaults;
import net.sourceforge.jnlp.config.InfrastructureFileDescriptor;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.docprovider.IcedTeaWebTextsProvider;
import net.sourceforge.jnlp.util.docprovider.ItwebPluginTextProvider;
import net.sourceforge.jnlp.util.docprovider.ItwebSettingsTextsProvider;
import net.sourceforge.jnlp.util.docprovider.JavaWsTextsProvider;
import net.sourceforge.jnlp.util.docprovider.PolicyEditorTextsProvider;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.Formatter;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.HtmlFormatter;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.ManFormatter;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.PlainTextFormatter;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.ReplacingTextFormatter;

public abstract class TextsProvider {
    private static File authorFileFromUserInput = null;
    private final String encoding;
    private final Formatter formatter;
    private final boolean forceTitles;
    protected final boolean expandVariables;
    private boolean prepared = false;
    private File authorFilePath = null;
    private boolean introduction = true;
    private boolean synopsis = true;
    private boolean description = true;
    private boolean commands = true;
    private boolean options = true;
    private boolean examples = true;
    private boolean files = true;
    private boolean bugs = true;
    private boolean authors = true;
    private boolean seeAlso = true;
    public static final String IT_BASE = "http://icedtea.classpath.org/wiki";
    public static final String ITW_HOME = "http://icedtea.classpath.org/wiki/IcedTea-Web";
    public static final String ITW_EAS = "http://icedtea.classpath.org/wiki/Extended_Applets_Security";
    public static final String ITW_STYLE = "http://icedtea.classpath.org/wiki/IcedTea-Web#Code_style";
    public static final String ITW_ECLIPSE = "http://icedtea.classpath.org/wiki/IcedTea-Web/DevelopingWithEclipse";
    public static final String ITW_REPO = "http://icedtea.classpath.org/hg/icedtea-web";
    public static final String JAVAWS = "javaws";
    public static final String ITWEB_SETTINGS = "itweb-settings";
    public static final String ITW = "icedtea-web";
    public static final String ITW_PLUGIN = "icedtea-web-plugin";
    public static final String POLICY_EDITOR = "policyeditor";
    public static final String DISTRO_PKG = "http://mail.openjdk.java.net/mailman/listinfo/distro-pkg-dev";
    public static final String IT_MAIN = "http://icedtea.classpath.org/wiki/Main_Page";
    public static final String IT_QUICK = "http://icedtea.classpath.org/wiki/DeveloperQuickStart";
    public static final String ITW_ISSUES = "http://icedtea.classpath.org/wiki/IcedTea-Web#Common_Issues";
    public static final String ITW_REPRODUCERS = "http://icedtea.classpath.org/wiki/Reproducers";
    public static final String ITW_BUGS = "http://icedtea.classpath.org/wiki/IcedTea-Web#Filing_bugs";
    public static final String ITW_PLUGIN_URL = "http://icedtea.classpath.org/wiki/IcedTea-Web#Plugin";
    public static final String ITW_BUGZILLAHOME = "http://icedtea.classpath.org/bugzilla";
    private static final String logo_name = "itw_logo.png";
    private static final String logo_url = "/net/sourceforge/jnlp/resources/itw_logo.png";
    private static final int BUF_SIZE = 4096;

    public TextsProvider(String encoding, Formatter formatter, boolean forceTitles, boolean expandFiles) {
        this.encoding = encoding;
        this.formatter = formatter;
        this.forceTitles = forceTitles;
        this.expandVariables = expandFiles;
    }

    public abstract String getId();

    public String getHeader() {
        return this.getFormatter().getHeaders(this.getId(), this.getEncoding());
    }

    public String getTail() {
        return this.getFormatter().getTail();
    }

    public String getIntroduction() {
        if (this.forceTitles) {
            return this.getFormatter().getTitle("NAME");
        }
        return "";
    }

    public String getSynopsis() {
        if (this.forceTitles) {
            return this.getFormatter().getTitle("SYNOPSIS");
        }
        return "";
    }

    public String getDescription() {
        if (this.forceTitles) {
            return this.getFormatter().getTitle("DESCRIPTION");
        }
        return "";
    }

    public String getOptions() {
        if (this.forceTitles) {
            return this.getFormatter().getTitle("OPTIONS");
        }
        return "";
    }

    public String getCommands() {
        if (this.forceTitles) {
            return this.getFormatter().getTitle("COMMANDS");
        }
        return "";
    }

    public String getExamples() {
        if (this.forceTitles) {
            return this.getFormatter().getTitle("EXAMPLES");
        }
        return "";
    }

    public String getFiles() {
        if (this.forceTitles) {
            return this.getFormatter().getTitle("FILES");
        }
        return "";
    }

    protected String getFilesAppendix() {
        if (!this.expandVariables) {
            return this.getFormatter().wrapParagraph(Translator.R("ITWTBdirs"));
        }
        return "";
    }

    protected String getFiles(List<InfrastructureFileDescriptor> files) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, Setting<String>>> defs = Defaults.getDefaults().entrySet();
        Collections.sort(files, new Comparator<InfrastructureFileDescriptor>(){

            @Override
            public int compare(InfrastructureFileDescriptor o1, InfrastructureFileDescriptor o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (InfrastructureFileDescriptor f : files) {
            String fGetDefaultFullPath;
            String path = this.expandVariables ? f.getFullPath() : f.toString();
            String modified = "";
            String fGetFullPath = this.removeFileProtocol(f.getFullPath());
            if (!fGetFullPath.equals(fGetDefaultFullPath = this.removeFileProtocol(f.getDefaultFullPath())) && this.expandVariables) {
                modified = this.getFormatter().getBold("[" + Translator.R("BUTmodified") + "] ");
            }
            String controlledBy = "";
            for (Map.Entry<String, Setting<String>> entry : defs) {
                if (!this.matchSttingsValueWithInfrastrucutreFile(entry.getValue(), f)) continue;
                controlledBy = " " + Translator.R("BUTControlledBy", this.getFormatter().getBold(entry.getKey()));
                break;
            }
            sb.append(this.getFormatter().getOption(path, modified + f.getDescription() + controlledBy));
        }
        return this.formatter.wrapParagraph(sb.toString());
    }

    protected boolean matchSttingsValueWithInfrastrucutreFile(Setting<String> entry, InfrastructureFileDescriptor f) {
        if (entry == null || entry.getDefaultValue() == null) {
            return false;
        }
        return entry.getDefaultValue().equals(f.getDefaultFullPath()) || entry.getDefaultValue().equals("file://" + f.getDefaultFullPath());
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    protected String optionsToString(List<OptionsDefinitions.OPTIONS> opts) {
        Collections.sort(opts, new Comparator<OptionsDefinitions.OPTIONS>(){

            @Override
            public int compare(OptionsDefinitions.OPTIONS o1, OptionsDefinitions.OPTIONS o2) {
                return o1.option.compareToIgnoreCase(o2.option);
            }
        });
        StringBuilder sb = new StringBuilder();
        for (OptionsDefinitions.OPTIONS o : opts) {
            sb.append(this.getFormatter().getOption(o.option + " " + o.helperString, o.getLocalizedDescription() + "(" + o.getArgumentExplanation() + ")"));
        }
        return sb.toString();
    }

    public String getBugs() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormatter().process(Translator.R("ITWTBbugs") + ":"));
        sb.append(this.getFormatter().getNewLine());
        sb.append(this.getFormatter().getUrl(ITW_BUGS));
        sb.append(this.getFormatter().getNewLine());
        sb.append(this.getFormatter().getUrl(ITW_BUGZILLAHOME));
        sb.append(this.getFormatter().getNewLine());
        sb.append(this.getFormatter().getNewLine());
        sb.append(this.getFormatter().process(Translator.R("ITWTBdebug")));
        sb.append(this.getFormatter().getNewLine());
        if (this.forceTitles) {
            return this.getFormatter().getTitle("BUGS") + this.getFormatter().wrapParagraph(sb.toString());
        }
        return this.getFormatter().wrapParagraph(sb.toString());
    }

    public String getAuthors() {
        if (this.forceTitles) {
            return this.getFormatter().getTitle("AUTHOR") + this.generateAuthorsSection(this.authorFilePath);
        }
        return this.generateAuthorsSection(this.authorFilePath);
    }

    public String getSeeAlso() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormatter().getSeeAlso(ITW));
        sb.append(this.getFormatter().getSeeAlso(JAVAWS));
        sb.append(this.getFormatter().getSeeAlso(ITW_PLUGIN));
        sb.append(this.getFormatter().getSeeAlso(ITWEB_SETTINGS));
        sb.append(this.getFormatter().getSeeAlso(POLICY_EDITOR));
        sb.append(this.getFormatter().getSeeAlso("policytool"));
        sb.append(this.getFormatter().getSeeAlso("java"));
        sb.append(this.getFormatter().getNewLine());
        sb.append(this.getFormatter().getUrl(ITW_HOME));
        sb.append(this.getFormatter().getNewLine());
        sb.append(this.getFormatter().getUrl(ITW_REPO));
        sb.append(this.getFormatter().getNewLine());
        if (this.forceTitles) {
            return this.getFormatter().getTitle("SEE_ALSO") + this.getFormatter().wrapParagraph(sb.toString());
        }
        return this.getFormatter().wrapParagraph(sb.toString());
    }

    public TextsProvider prepare() {
        if (!this.prepared) {
            this.writeToStringReal();
            this.prepared = true;
        }
        return this;
    }

    public String writeToString() {
        return this.prepare().writeToStringReal();
    }

    private String writeToStringReal() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHeader());
        sb.append(PlainTextFormatter.getLineSeparator());
        if (this.getFormatter() instanceof HtmlFormatter) {
            sb.append(((HtmlFormatter)this.getFormatter()).generateLogo());
            sb.append(PlainTextFormatter.getLineSeparator());
            sb.append((CharSequence)((HtmlFormatter)this.getFormatter()).generateIndex());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isIntroduction()) {
            sb.append(this.getIntroduction());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isSynopsis()) {
            sb.append(this.getSynopsis());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isDescription()) {
            sb.append(this.getDescription());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isCommands()) {
            sb.append(this.getCommands());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isOptions()) {
            sb.append(this.getOptions());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isExamples()) {
            sb.append(this.getExamples());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isFiles()) {
            sb.append(this.getFiles());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isBugs()) {
            sb.append(this.getBugs());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isAuthors()) {
            sb.append(this.getAuthors());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        if (this.isSeeAlso()) {
            sb.append(this.getSeeAlso());
            sb.append(PlainTextFormatter.getLineSeparator());
        }
        sb.append(this.getTail());
        return sb.toString();
    }

    public void writeToWriter(Writer w) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(w);){
            bw.write(this.writeToString());
        }
    }

    public void writeToStream(OutputStream os) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(os, this.encoding);){
            this.writeToWriter(osw);
        }
    }

    public void writeToFile(File f) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            this.writeToStream(fos);
        }
    }

    public void writeToDir(File dir) throws IOException {
        this.writeToFile(new File(dir, this.getId() + this.getFormatter().getFileSuffix()));
    }

    public static void main(String[] args) throws IOException {
        JNLPRuntime.setHeadless(true);
        if (args.length == 0) {
            System.out.println(" * IcedTea-Web self documentation tool list of arguments *");
            System.out.println(" * argument version - last parameter of each command, is used when there is no internal versionknown *");
            System.out.println(" *                  - is mandatory, but not used if real version do exists *");
            System.out.println(" * argument expand - one before last argument, false/true - is used to not/expand variables *");
            System.out.println(" * -------------------- *");
            System.out.println("all expand version - will generate all reports in theirs defaults into current directory");
            System.out.println("html targetDir expand version - will generate html documentation to target dir");
            System.out.println("htmlIntro targetFile  expand version - will generate html intro page to specified file");
            System.out.println("man encoding targetDir expand version - will generate man documentation to target dir in desired encoding");
            System.out.println("plain targetDir maxLineWidth expand version - will generate plain text documentation to target dir in desired encoding");
            System.out.println("                                            - maxLineWidth is in <5,2147483647>");
            System.out.println("to generate informations about authors from a file, use argument '-authorFile' with path to AUTHORS file located in icedtea-web.\n eg. -authorFile=/home/user/icedtea-web/AUTHORS");
        } else {
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.addAll(Arrays.asList(args));
            for (String s : argsList) {
                if (!s.startsWith("-authorFile=")) continue;
                authorFileFromUserInput = new File(s.split("=")[1]);
                if (!authorFileFromUserInput.exists()) {
                    throw new RuntimeException(authorFileFromUserInput.getAbsolutePath() + " does not exists");
                }
                argsList.remove(s);
                break;
            }
            ReplacingTextFormatter.backupVersion = (String)argsList.get(argsList.size() - 1);
            boolean expand = Boolean.valueOf((String)argsList.get(argsList.size() - 2));
            switch ((String)argsList.get(0)) {
                case "all": {
                    TextsProvider.generateAll(new File(System.getProperty("user.dir")), expand);
                    break;
                }
                case "html": {
                    TextsProvider.generateOnlineHtmlHelp(new File((String)argsList.get(1)), expand);
                    break;
                }
                case "htmlIntro": {
                    TextsProvider.generateItwIntro(new File((String)argsList.get(1)), expand);
                    break;
                }
                case "man": {
                    TextsProvider.generateManText((String)argsList.get(1), new File((String)argsList.get(2)), expand);
                    break;
                }
                case "plain": {
                    TextsProvider.generatePlainTextDocs(new File((String)argsList.get(1)), Integer.valueOf((String)argsList.get(2)), expand);
                    break;
                }
                default: {
                    System.out.println("unknown param");
                    TextsProvider.main(new String[0]);
                }
            }
        }
    }

    public static void generateItwIntro(File f, boolean expand) throws IOException {
        IcedTeaWebTextsProvider itw = new IcedTeaWebTextsProvider("utf-8", new HtmlFormatter(false, true, false), false, expand);
        itw.setSeeAlso(false);
        itw.writeToFile(f);
    }

    public static void generateAll(File f, boolean expand) throws IOException {
        TextsProvider.generateOnlineHtmlHelp(f, expand);
        TextsProvider.generateManText("UTF-8", f, expand);
        TextsProvider.generatePlainTextDocs(f, 160, expand);
    }

    public static void generateRuntimeHtmlTexts(File f) throws IOException {
        TextsProvider.generateHtmlTexts(f, false, true);
    }

    public static void generateOnlineHtmlHelp(File f, boolean expand) throws IOException {
        TextsProvider.generateHtmlTexts(f, true, expand);
    }

    public static void generateHtmlTexts(File dir, boolean includeXmlHeader, boolean expand) throws IOException {
        TextsProvider.generateHtmlTextsUtf8(dir, true, true, includeXmlHeader, true, expand);
    }

    public static void generateHtmlTextsUtf8(File dir, boolean allowContext, boolean allowLogo, boolean includeXmlHeader, boolean titles, boolean expand) throws IOException {
        TextsProvider.generateHtmlTexts("UTF-8", dir, allowContext, allowLogo, includeXmlHeader, titles, expand);
    }

    public static void generateHtmlTexts(String encoding, File dir, boolean allowContext, boolean allowLogo, boolean includeXmlHeader, boolean titles, boolean expand) throws IOException {
        TextsProvider[] providers;
        if (allowLogo) {
            File flogo = new File(dir, logo_name);
            try (InputStream is = TextsProvider.class.getResourceAsStream(logo_url);
                 FileOutputStream os = new FileOutputStream(flogo);){
                TextsProvider.copy(is, os);
                os.flush();
            }
        }
        JavaWsTextsProvider javaws = new JavaWsTextsProvider(encoding, new HtmlFormatter(allowContext, allowLogo, includeXmlHeader), titles, expand);
        ItwebSettingsTextsProvider itws = new ItwebSettingsTextsProvider(encoding, new HtmlFormatter(allowContext, allowLogo, includeXmlHeader), titles, expand);
        PolicyEditorTextsProvider pe = new PolicyEditorTextsProvider(encoding, new HtmlFormatter(allowContext, allowLogo, includeXmlHeader), titles, expand);
        IcedTeaWebTextsProvider itw = new IcedTeaWebTextsProvider(encoding, new HtmlFormatter(allowContext, allowLogo, includeXmlHeader), titles, expand);
        ItwebPluginTextProvider pl = new ItwebPluginTextProvider(encoding, new HtmlFormatter(allowContext, allowLogo, includeXmlHeader), titles, expand);
        for (TextsProvider provider : providers = new TextsProvider[]{javaws, itws, pe, itw, pl}) {
            provider.setAuthorFilePath(authorFileFromUserInput);
            provider.writeToDir(dir);
        }
    }

    public static void generateManText(String encoding, File dir, boolean expand) throws IOException {
        TextsProvider.generateManText(encoding, dir, true, expand);
    }

    public static void generateManText(String encoding, File dir, boolean titles, boolean expand) throws IOException {
        TextsProvider[] providers;
        JavaWsTextsProvider javaws = new JavaWsTextsProvider(encoding, new ManFormatter(), titles, expand);
        ItwebSettingsTextsProvider itws = new ItwebSettingsTextsProvider(encoding, new ManFormatter(), titles, expand);
        PolicyEditorTextsProvider pe = new PolicyEditorTextsProvider(encoding, new ManFormatter(), titles, expand);
        IcedTeaWebTextsProvider itw = new IcedTeaWebTextsProvider(encoding, new ManFormatter(), titles, expand);
        ItwebPluginTextProvider pl = new ItwebPluginTextProvider(encoding, new ManFormatter(), titles, expand);
        for (TextsProvider provider : providers = new TextsProvider[]{javaws, itws, pe, itw, pl}) {
            provider.setAuthorFilePath(authorFileFromUserInput);
            provider.writeToDir(dir);
        }
    }

    public static void generatePlainTextDocs(File dir, int lineWidth, boolean expand) throws IOException {
        TextsProvider.generatePlainTextDocs("UTF-8", dir, "    ", lineWidth, true, expand);
    }

    public static void generatePlainTextDocs(String encoding, File dir, String indent, int lineWidth, boolean titles, boolean expand) throws IOException {
        TextsProvider[] providers;
        JavaWsTextsProvider javaws = new JavaWsTextsProvider(encoding, new PlainTextFormatter(indent, lineWidth), titles, expand);
        ItwebSettingsTextsProvider itws = new ItwebSettingsTextsProvider(encoding, new PlainTextFormatter(indent, lineWidth), titles, expand);
        PolicyEditorTextsProvider pe = new PolicyEditorTextsProvider(encoding, new PlainTextFormatter(indent, lineWidth), titles, expand);
        IcedTeaWebTextsProvider itw = new IcedTeaWebTextsProvider(encoding, new PlainTextFormatter(indent, lineWidth), titles, expand);
        ItwebPluginTextProvider pl = new ItwebPluginTextProvider(encoding, new PlainTextFormatter(indent, lineWidth), titles, expand);
        for (TextsProvider provider : providers = new TextsProvider[]{javaws, itws, pe, itw, pl}) {
            provider.setAuthorFilePath(authorFileFromUserInput);
            provider.writeToDir(dir);
        }
    }

    private static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public boolean isIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(boolean introduction) {
        this.introduction = introduction;
    }

    public boolean isSynopsis() {
        return this.synopsis;
    }

    public void setSynopsis(boolean synopsis) {
        this.synopsis = synopsis;
    }

    public boolean isDescription() {
        return this.description;
    }

    public void setDescription(boolean description) {
        this.description = description;
    }

    public boolean isCommands() {
        return this.commands;
    }

    public void setCommands(boolean commands) {
        this.commands = commands;
    }

    public boolean isOptions() {
        return this.options;
    }

    public void setOptions(boolean options) {
        this.options = options;
    }

    public boolean isExamples() {
        return this.examples;
    }

    public void setExamples(boolean examples) {
        this.examples = examples;
    }

    public boolean isFiles() {
        return this.files;
    }

    public void setFiles(boolean files) {
        this.files = files;
    }

    public boolean isBugs() {
        return this.bugs;
    }

    public void setBugs(boolean bugs) {
        this.bugs = bugs;
    }

    public boolean isAuthors() {
        return this.authors;
    }

    public void setAuthors(boolean authors) {
        this.authors = authors;
    }

    public void setAuthorFilePath(File authorFilePath) {
        this.authorFilePath = authorFilePath;
    }

    public boolean isSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(boolean seeAlso) {
        this.seeAlso = seeAlso;
    }

    private String removeFileProtocol(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("file://")) {
            s = s.substring(7);
        }
        return s;
    }

    private String readAuthors(File authors) {
        try {
            return this.readAuthorsImpl(authors);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readAuthorsImpl(File authors) throws IOException {
        return this.readAuthorsImpl(new InputStreamReader((InputStream)new FileInputStream(authors), "UTF-8"));
    }

    String readAuthorsImpl(Reader authors) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        boolean areAuthors = false;
        BufferedReader reader = new BufferedReader(authors);
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty()) {
                areAuthors = !areAuthors;
            }
            sb.append(this.getFormatter().process(this.getFormatter().getAdressLink(line)));
            if (!(this.getFormatter() instanceof HtmlFormatter) && areAuthors) continue;
            sb.append(this.getFormatter().getNewLine());
        }
        return sb.toString();
    }

    private String generateAuthorsSection(File filePath) {
        if (filePath == null) {
            return this.getFormatter().wrapParagraph(this.getFormatter().process(Translator.R("ITWdocsMissingAuthors")) + this.getFormatter().getNewLine());
        }
        return this.getFormatter().wrapParagraph(this.getFormatter().process(this.readAuthors(filePath)) + this.getFormatter().getNewLine());
    }
}

