/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IWaySegment;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.PrimitiveHoverListener;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.util.CursorManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public class NavigatableComponent
extends JComponent
implements Helpful {
    private static final double ALIGNMENT_EPSILON = 0.001;
    public transient Predicate<OsmPrimitive> isSelectablePredicate = prim -> {
        if (!prim.isSelectable()) {
            return false;
        }
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            boolean bl = !MapPaintStyles.getStyles().get((IPrimitive)prim, this.getDist100Pixel(), this).isEmpty();
            return bl;
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
    };
    public static final IntegerProperty PROP_SNAP_DISTANCE = new IntegerProperty("mappaint.node.snap-distance", 10);
    public static final DoubleProperty PROP_ZOOM_RATIO = new DoubleProperty("zoom.ratio", 2.0);
    public static final BooleanProperty PROP_ZOOM_INTERMEDIATE_STEPS = new BooleanProperty("zoom.intermediate-steps", true);
    public static final BooleanProperty PROP_ZOOM_SCALE_FOLLOW_NATIVE_RES_AT_LOAD = new BooleanProperty("zoom.scale-follow-native-resolution-at-load", true);
    private transient NativeScaleLayer nativeScaleLayer;
    private static final CopyOnWriteArrayList<ZoomChangeListener> zoomChangeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<PrimitiveHoverListener> primitiveHoverListeners = new CopyOnWriteArrayList();
    private IPrimitive previousHoveredPrimitive;
    private final PrimitiveHoverMouseListener primitiveHoverMouseListenerHelper = new PrimitiveHoverMouseListener();
    private final transient HierarchyListener hierarchyListenerNavigatableComponent = e -> {
        long interestingFlags = 1405L;
        if ((e.getChangeFlags() & interestingFlags) != 0L) {
            this.updateLocationState();
        }
    };
    private final transient ComponentAdapter componentListenerNavigatableComponent = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent e) {
            NavigatableComponent.this.updateLocationState();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            NavigatableComponent.this.updateLocationState();
        }
    };
    protected transient ViewportData initialViewport;
    protected final transient CursorManager cursorManager = new CursorManager(this);
    private transient MapViewState state;
    private final ProjectionChangeListener projectionChangeListener = (oldValue, newValue) -> this.fixProjection();
    private final transient Stack<ZoomData> zoomUndoBuffer = new Stack();
    private final transient Stack<ZoomData> zoomRedoBuffer = new Stack();
    private long zoomTimestamp = System.currentTimeMillis();

    public static void removeZoomChangeListener(ZoomChangeListener listener) {
        zoomChangeListeners.remove(listener);
    }

    public static void addZoomChangeListener(ZoomChangeListener listener) {
        if (listener != null) {
            zoomChangeListeners.addIfAbsent(listener);
        }
    }

    protected static void fireZoomChanged() {
        GuiHelper.runInEDTAndWait(() -> {
            for (ZoomChangeListener l : zoomChangeListeners) {
                l.zoomChanged();
            }
        });
    }

    public void removePrimitiveHoverListener(PrimitiveHoverListener listener) {
        this.primitiveHoverListeners.remove(listener);
    }

    public void addPrimitiveHoverListener(PrimitiveHoverListener listener) {
        if (listener != null) {
            this.primitiveHoverListeners.addIfAbsent(listener);
        }
    }

    protected void firePrimitiveHovered(PrimitiveHoverListener.PrimitiveHoverEvent e) {
        GuiHelper.runInEDT(() -> {
            for (PrimitiveHoverListener l : this.primitiveHoverListeners) {
                try {
                    l.primitiveHovered(e);
                }
                catch (RuntimeException ex) {
                    Logging.logWithStackTrace(Logging.LEVEL_ERROR, "Error in primitive hover listener", ex);
                    BugReportExceptionHandler.handleException(ex);
                }
            }
        });
    }

    private void updateHoveredPrimitive(IPrimitive hovered, MouseEvent e) {
        if (!Objects.equals(hovered, this.previousHoveredPrimitive)) {
            this.firePrimitiveHovered(new PrimitiveHoverListener.PrimitiveHoverEvent(hovered, this.previousHoveredPrimitive, e));
            this.previousHoveredPrimitive = hovered;
        }
    }

    public NavigatableComponent() {
        this.setLayout(null);
        this.state = MapViewState.createDefaultState(this.getWidth(), this.getHeight());
        ProjectionRegistry.addProjectionChangeListener(this.projectionChangeListener);
    }

    @Override
    public void addNotify() {
        this.updateLocationState();
        this.addHierarchyListener(this.hierarchyListenerNavigatableComponent);
        this.addComponentListener(this.componentListenerNavigatableComponent);
        this.addPrimitiveHoverMouseListeners();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this.hierarchyListenerNavigatableComponent);
        this.removeComponentListener(this.componentListenerNavigatableComponent);
        this.removePrimitiveHoverMouseListeners();
        super.removeNotify();
    }

    private void addPrimitiveHoverMouseListeners() {
        this.addMouseMotionListener(this.primitiveHoverMouseListenerHelper);
        this.addMouseListener(this.primitiveHoverMouseListenerHelper);
    }

    private void removePrimitiveHoverMouseListeners() {
        this.removeMouseMotionListener(this.primitiveHoverMouseListenerHelper);
        this.removeMouseListener(this.primitiveHoverMouseListenerHelper);
    }

    public void setNativeScaleLayer(NativeScaleLayer nativeScaleLayer) {
        this.nativeScaleLayer = nativeScaleLayer;
        this.zoomTo(this.getCenter(), this.scaleRound(this.getScale()));
        this.repaint();
    }

    public NativeScaleLayer getNativeScaleLayer() {
        return this.nativeScaleLayer;
    }

    public double scaleZoomIn() {
        return this.scaleZoomManyTimes(-1);
    }

    public double scaleZoomOut() {
        return this.scaleZoomManyTimes(1);
    }

    public double scaleZoomManyTimes(int times) {
        NativeScaleLayer.ScaleList scaleList;
        if (this.nativeScaleLayer != null && (scaleList = this.nativeScaleLayer.getNativeScales()) != null) {
            NativeScaleLayer.Scale s;
            if (Boolean.TRUE.equals(PROP_ZOOM_INTERMEDIATE_STEPS.get())) {
                scaleList = scaleList.withIntermediateSteps(PROP_ZOOM_RATIO.get());
            }
            return (s = scaleList.scaleZoomTimes(this.getScale(), PROP_ZOOM_RATIO.get(), times)) != null ? s.getScale() : 0.0;
        }
        return this.getScale() * Math.pow(PROP_ZOOM_RATIO.get(), times);
    }

    public double scaleRound(double scale) {
        return this.scaleSnap(scale, false);
    }

    public double scaleFloor(double scale) {
        return this.scaleSnap(scale, true);
    }

    public double scaleSnap(double scale, boolean floor) {
        NativeScaleLayer.ScaleList scaleList;
        if (this.nativeScaleLayer != null && (scaleList = this.nativeScaleLayer.getNativeScales()) != null) {
            NativeScaleLayer.Scale snapscale;
            if (Boolean.TRUE.equals(PROP_ZOOM_INTERMEDIATE_STEPS.get())) {
                scaleList = scaleList.withIntermediateSteps(PROP_ZOOM_RATIO.get());
            }
            return (snapscale = scaleList.getSnapScale(scale, PROP_ZOOM_RATIO.get(), floor)) != null ? snapscale.getScale() : scale;
        }
        return scale;
    }

    public void zoomIn() {
        this.zoomTo(this.state.getCenter().getEastNorth(), this.scaleZoomIn());
    }

    public void zoomOut() {
        this.zoomTo(this.state.getCenter().getEastNorth(), this.scaleZoomOut());
    }

    protected void updateLocationState() {
        if (this.isVisibleOnScreen()) {
            this.state = this.state.usingLocation(this);
        }
    }

    protected boolean isVisibleOnScreen() {
        return SwingUtilities.getWindowAncestor(this) != null && this.isShowing();
    }

    public void fixProjection() {
        this.state = this.state.usingProjection(ProjectionRegistry.getProjection());
        this.repaint();
    }

    public MapViewState getState() {
        return this.state;
    }

    public static String getDistText(double dist) {
        return SystemOfMeasurement.getSystemOfMeasurement().getDistText(dist);
    }

    public static String getDistText(double dist, NumberFormat format, double threshold) {
        return SystemOfMeasurement.getSystemOfMeasurement().getDistText(dist, format, threshold);
    }

    public String getDist100PixelText() {
        return NavigatableComponent.getDistText(this.getDist100Pixel());
    }

    public double getDist100Pixel() {
        return this.getDist100Pixel(true);
    }

    public double getDist100Pixel(boolean alwaysPositive) {
        int w = this.getWidth() / 2;
        int h = this.getHeight() / 2;
        LatLon ll1 = this.getLatLon(w - 50, h);
        LatLon ll2 = this.getLatLon(w + 50, h);
        double gcd = ll1.greatCircleDistance((ILatLon)ll2);
        if (alwaysPositive && gcd <= 0.0) {
            return 0.1;
        }
        return gcd;
    }

    public EastNorth getCenter() {
        return this.state.getCenter().getEastNorth();
    }

    public double getScale() {
        return this.state.getScale();
    }

    public EastNorth getEastNorth(int x, int y) {
        return this.state.getForView(x, y).getEastNorth();
    }

    public ProjectionBounds getProjectionBounds() {
        return this.getState().getViewArea().getProjectionBounds();
    }

    public ProjectionBounds getMaxProjectionBounds() {
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        return new ProjectionBounds(this.getProjection().latlon2eastNorth(b.getMin()), this.getProjection().latlon2eastNorth(b.getMax()));
    }

    public Bounds getRealBounds() {
        return this.getState().getViewArea().getCornerBounds();
    }

    public LatLon getLatLon(int x, int y) {
        return this.getProjection().eastNorth2latlon(this.getEastNorth(x, y));
    }

    public LatLon getLatLon(double x, double y) {
        return this.getLatLon((int)x, (int)y);
    }

    public ProjectionBounds getProjectionBounds(Rectangle r) {
        return this.getState().getViewArea(r).getProjectionBounds();
    }

    public Bounds getLatLonBounds(Rectangle r) {
        return ProjectionRegistry.getProjection().getLatLonBoundsBox(this.getProjectionBounds(r));
    }

    public AffineTransform getAffineTransform() {
        return this.getState().getAffineTransform();
    }

    public Point2D getPoint2D(EastNorth p) {
        if (null == p) {
            return new Point();
        }
        return this.getState().getPointFor(p).getInView();
    }

    public Point2D getPoint2D(ILatLon latlon) {
        if (latlon == null) {
            return new Point();
        }
        return this.getPoint2D(latlon.getEastNorth(ProjectionRegistry.getProjection()));
    }

    public Point2D getPoint2D(LatLon latlon) {
        return this.getPoint2D((ILatLon)latlon);
    }

    public Point2D getPoint2D(Node n) {
        return this.getPoint2D(n.getEastNorth());
    }

    public Point getPoint(EastNorth p) {
        Point2D d = this.getPoint2D(p);
        return new Point((int)d.getX(), (int)d.getY());
    }

    public Point getPoint(ILatLon latlon) {
        Point2D d = this.getPoint2D(latlon);
        return new Point((int)d.getX(), (int)d.getY());
    }

    public Point getPoint(LatLon latlon) {
        return this.getPoint((ILatLon)latlon);
    }

    public Point getPoint(Node n) {
        Point2D d = this.getPoint2D(n);
        return new Point((int)d.getX(), (int)d.getY());
    }

    public void zoomTo(EastNorth newCenter, double newScale) {
        this.zoomTo(newCenter, newScale, false);
    }

    public void zoomTo(EastNorth center, double scale, boolean initial) {
        EastNorth oldCenter;
        Point2D enOrigin;
        Point2D.Double enOriginAligned;
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        ProjectionBounds pb = this.getProjection().getWorldBoundsBoxEastNorth();
        double newScale = scale;
        int width = this.getWidth();
        int height = this.getHeight();
        double east = center.east();
        double north = center.north();
        east = Math.max(east, pb.minEast);
        east = Math.min(east, pb.maxEast);
        north = Math.max(north, pb.minNorth);
        north = Math.min(north, pb.maxNorth);
        EastNorth newCenter = new EastNorth(east, north);
        double pbHeight = pb.maxNorth - pb.minNorth;
        if (height > 0 && 2.0 * pbHeight < (double)height * newScale) {
            double newScaleH = 2.0 * pbHeight / (double)height;
            double pbWidth = pb.maxEast - pb.minEast;
            if (width > 0 && 2.0 * pbWidth < (double)width * newScale) {
                double newScaleW = 2.0 * pbWidth / (double)width;
                newScale = Math.max(newScaleH, newScaleW);
            }
        }
        LatLon ll1 = this.getLatLon(width / 2 - 50, height / 2);
        LatLon ll2 = this.getLatLon(width / 2 + 50, height / 2);
        if (ll1.isValid() && ll2.isValid() && b.contains(ll1) && b.contains(ll2)) {
            double dm = ll1.greatCircleDistance((ILatLon)ll2);
            double den = 100.0 * this.getScale();
            double scaleMin = 0.01 * den / dm / 100.0;
            if (newScale < scaleMin && !Double.isInfinite(scaleMin)) {
                newScale = scaleMin;
            }
        }
        newScale = this.scaleRound(newScale);
        MapViewState mvs = this.getState().usingScale(newScale);
        EastNorth enShift = (mvs = mvs.movedTo(mvs.getCenter(), newCenter)).getForView(((Point2D)(enOriginAligned = new Point2D.Double((double)Math.round((enOrigin = mvs.getPointFor(new EastNorth(0.0, 0.0)).getInView()).getX()) + 0.001, (double)Math.round(enOrigin.getY()) + 0.001))).getX(), ((Point2D)enOriginAligned).getY()).getEastNorth();
        if (!(newCenter = newCenter.subtract(enShift)).equals(oldCenter = this.getCenter()) || !Utils.equalsEpsilon(this.getScale(), newScale)) {
            if (!initial) {
                this.pushZoomUndo(oldCenter, this.getScale());
            }
            this.zoomNoUndoTo(newCenter, newScale, initial);
        }
    }

    private void zoomNoUndoTo(EastNorth newCenter, double newScale, boolean initial) {
        if (!Utils.equalsEpsilon(this.getScale(), newScale)) {
            this.state = this.state.usingScale(newScale);
        }
        if (!newCenter.equals(this.getCenter())) {
            this.state = this.state.movedTo(this.state.getCenter(), newCenter);
        }
        if (!initial) {
            this.repaint();
            NavigatableComponent.fireZoomChanged();
        }
    }

    public void zoomTo(EastNorth newCenter) {
        this.zoomTo(newCenter, this.getScale());
    }

    public void zoomTo(ILatLon newCenter) {
        this.zoomTo(this.getProjection().latlon2eastNorth(newCenter));
    }

    public void zoomTo(LatLon newCenter) {
        this.zoomTo((ILatLon)newCenter);
    }

    public void smoothScrollTo(EastNorth newCenter) {
        EastNorth oldCenter = this.getCenter();
        if (!newCenter.equals(oldCenter)) {
            int fps = Config.getPref().getInt("smooth.scroll.fps", 20);
            int speed = Config.getPref().getInt("smooth.scroll.speed", 1500);
            int maxtime = Config.getPref().getInt("smooth.scroll.maxtime", 5000);
            double distance = newCenter.distance(oldCenter) / this.getScale();
            double milliseconds = distance / (double)this.getWidth() * (double)speed;
            if (milliseconds > (double)maxtime) {
                milliseconds = maxtime;
            }
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            Thread[] threads = new Thread[group.activeCount()];
            group.enumerate(threads, true);
            boolean stopped = false;
            for (Thread t : threads) {
                if (!(t instanceof SmoothScrollThread)) continue;
                ((SmoothScrollThread)t).stopIt();
                stopped = true;
            }
            if (stopped && milliseconds > (double)maxtime / 2.0) {
                Logging.warn("Skip smooth scrolling");
                this.zoomTo(newCenter);
            } else {
                long frames = Math.round(milliseconds * (double)fps / 1000.0);
                if (frames <= 1L) {
                    this.zoomTo(newCenter);
                } else {
                    new SmoothScrollThread(newCenter, frames, fps).start();
                }
            }
        }
    }

    public void zoomManyTimes(double x, double y, int times) {
        double oldScale = this.getScale();
        double newScale = this.scaleZoomManyTimes(times);
        this.zoomToFactor(x, y, newScale / oldScale);
    }

    public void zoomToFactor(double x, double y, double factor) {
        double newScale = this.getScale() * factor;
        EastNorth oldUnderMouse = this.getState().getForView(x, y).getEastNorth();
        MapViewState newState = this.getState().usingScale(newScale);
        newState = newState.movedTo(newState.getForView(x, y), oldUnderMouse);
        this.zoomTo(newState.getCenter().getEastNorth(), newScale);
    }

    public void zoomToFactor(EastNorth newCenter, double factor) {
        this.zoomTo(newCenter, this.getScale() * factor);
    }

    public void zoomToFactor(double factor) {
        this.zoomTo(this.getCenter(), this.getScale() * factor);
    }

    public void zoomTo(ProjectionBounds box) {
        double newScale = box.getScale(this.getWidth(), this.getHeight());
        newScale = this.scaleFloor(newScale);
        this.zoomTo(box.getCenter(), newScale);
    }

    public void zoomTo(Bounds box) {
        this.zoomTo(new ProjectionBounds(this.getProjection().latlon2eastNorth(box.getMin()), this.getProjection().latlon2eastNorth(box.getMax())));
    }

    public void zoomTo(ViewportData viewport) {
        if (viewport == null) {
            return;
        }
        if (viewport.getBounds() != null) {
            if (!viewport.getBounds().hasExtend()) {
                BoundingXYVisitor v = new BoundingXYVisitor();
                v.visit(viewport.getBounds());
                this.zoomTo(v);
            } else {
                this.zoomTo(viewport.getBounds());
            }
        } else {
            this.zoomTo(viewport.getCenter(), viewport.getScale(), true);
        }
    }

    public void zoomTo(BoundingXYVisitor v) {
        if (v == null) {
            v = new BoundingXYVisitor();
        }
        if (v.getBounds() == null) {
            v.visit(this.getProjection().getWorldBoundsLatLon());
        }
        MapView mapView = MainApplication.getMap().mapView;
        double mapScale = mapView.getScale();
        double minScale = v.getBounds().getScale(mapView.getWidth(), mapView.getHeight());
        v.enlargeBoundingBoxLogarithmically();
        double maxScale = v.getBounds().getScale(mapView.getWidth(), mapView.getHeight());
        if (minScale <= mapScale && mapScale < maxScale) {
            mapView.zoomTo(v.getBounds().getCenter());
        } else {
            this.zoomTo(v.getBounds());
        }
    }

    private void pushZoomUndo(EastNorth center, double scale) {
        long now = System.currentTimeMillis();
        if ((double)(now - this.zoomTimestamp) > Config.getPref().getDouble("zoom.undo.delay", 1.0) * 1000.0) {
            this.zoomUndoBuffer.push(new ZoomData(center, scale));
            if (this.zoomUndoBuffer.size() > Config.getPref().getInt("zoom.undo.max", 50)) {
                this.zoomUndoBuffer.remove(0);
            }
            this.zoomRedoBuffer.clear();
        }
        this.zoomTimestamp = now;
    }

    public void zoomPrevious() {
        if (!this.zoomUndoBuffer.isEmpty()) {
            ZoomData zoom = this.zoomUndoBuffer.pop();
            this.zoomRedoBuffer.push(new ZoomData(this.getCenter(), this.getScale()));
            this.zoomNoUndoTo(zoom.getCenterEastNorth(), zoom.getScale(), false);
        }
    }

    public void zoomNext() {
        if (!this.zoomRedoBuffer.isEmpty()) {
            ZoomData zoom = this.zoomRedoBuffer.pop();
            this.zoomUndoBuffer.push(new ZoomData(this.getCenter(), this.getScale()));
            this.zoomNoUndoTo(zoom.getCenterEastNorth(), zoom.getScale(), false);
        }
    }

    public boolean hasZoomUndoEntries() {
        return !this.zoomUndoBuffer.isEmpty();
    }

    public boolean hasZoomRedoEntries() {
        return !this.zoomRedoBuffer.isEmpty();
    }

    private BBox getBBox(Point p, int snapDistance) {
        return new BBox(this.getLatLon(p.x - snapDistance, p.y - snapDistance), this.getLatLon(p.x + snapDistance, p.y + snapDistance));
    }

    private Map<Double, List<Node>> getNearestNodesImpl(Point p, Predicate<OsmPrimitive> predicate) {
        TreeMap<Double, List<Node>> nearestMap = new TreeMap<Double, List<Node>>();
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (ds != null) {
            double snapDistanceSq = PROP_SNAP_DISTANCE.get().intValue();
            snapDistanceSq *= snapDistanceSq;
            for (Node n : ds.searchNodes(this.getBBox(p, PROP_SNAP_DISTANCE.get()))) {
                double d;
                if (!predicate.test(n)) continue;
                double dist = this.getPoint2D(n).distanceSq(p);
                if (!(d < snapDistanceSq)) continue;
                nearestMap.computeIfAbsent(dist, k -> new LinkedList()).add(n);
            }
        }
        return nearestMap;
    }

    public final List<Node> getNearestNodes(Point p, Collection<Node> ignore, Predicate<OsmPrimitive> predicate) {
        Map<Double, List<Node>> nlists;
        List<Node> nearestList = Collections.emptyList();
        if (ignore == null) {
            ignore = Collections.emptySet();
        }
        if (!(nlists = this.getNearestNodesImpl(p, predicate)).isEmpty()) {
            Double minDistSq = null;
            for (Map.Entry<Double, List<Node>> entry : nlists.entrySet()) {
                Double distSq = entry.getKey();
                List<Node> nlist = entry.getValue();
                nlist.removeAll(ignore);
                if (minDistSq == null) {
                    if (nlist.isEmpty()) continue;
                    minDistSq = distSq;
                    nearestList = new ArrayList<Node>(nlist);
                    continue;
                }
                if (!(distSq - minDistSq < 16.0)) continue;
                nearestList.addAll(nlist);
            }
        }
        return nearestList;
    }

    public final List<Node> getNearestNodes(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNodes(p, null, predicate);
    }

    public final Node getNearestNode(Point p, Predicate<OsmPrimitive> predicate, boolean useSelected) {
        return this.getNearestNode(p, predicate, useSelected, null);
    }

    public final Node getNearestNode(Point p, Predicate<OsmPrimitive> predicate, boolean useSelected, Collection<OsmPrimitive> preferredRefs) {
        Map<Double, List<Node>> nlists = this.getNearestNodesImpl(p, predicate);
        if (nlists.isEmpty()) {
            return null;
        }
        if (preferredRefs != null && preferredRefs.isEmpty()) {
            preferredRefs = null;
        }
        Node ntsel = null;
        Node ntnew = null;
        Node ntref = null;
        boolean useNtsel = useSelected;
        double minDistSq = nlists.keySet().iterator().next();
        for (Map.Entry<Double, List<Node>> entry : nlists.entrySet()) {
            Double distSq = entry.getKey();
            for (Node nd : entry.getValue()) {
                if (ntsel == null && nd.isSelected()) {
                    ntsel = nd;
                    useNtsel |= Utils.equalsEpsilon(distSq, minDistSq);
                }
                if (ntref == null && preferredRefs != null && Utils.equalsEpsilon(distSq, minDistSq)) {
                    List<OsmPrimitive> ndRefs = nd.getReferrers();
                    if (preferredRefs.stream().anyMatch(ndRefs::contains)) {
                        ntref = nd;
                    }
                }
                if (ntnew != null || !nd.isNew() || !(distSq - minDistSq < 1.0)) continue;
                ntnew = nd;
            }
        }
        if (ntsel != null && useNtsel) {
            return ntsel;
        }
        if (ntref != null) {
            return ntref;
        }
        if (ntnew != null) {
            return ntnew;
        }
        return nlists.values().iterator().next().get(0);
    }

    public final Node getNearestNode(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNode(p, predicate, true);
    }

    private Map<Double, List<WaySegment>> getNearestWaySegmentsImpl(Point p, Predicate<OsmPrimitive> predicate) {
        TreeMap<Double, List<WaySegment>> nearestMap = new TreeMap<Double, List<WaySegment>>();
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (ds != null) {
            double snapDistanceSq = Config.getPref().getInt("mappaint.segment.snap-distance", 10);
            snapDistanceSq *= snapDistanceSq;
            for (Way w : ds.searchWays(this.getBBox(p, Config.getPref().getInt("mappaint.segment.snap-distance", 10)))) {
                if (!predicate.test(w)) continue;
                Node lastN = null;
                int i = -2;
                for (Node n : w.getNodes()) {
                    double b;
                    ++i;
                    if (n.isDeleted() || n.isIncomplete()) continue;
                    if (lastN == null) {
                        lastN = n;
                        continue;
                    }
                    Point2D pA = this.getPoint2D(lastN);
                    Point2D pB = this.getPoint2D(n);
                    double c = pA.distanceSq(pB);
                    double a = p.distanceSq(pB);
                    double perDistSq = Double.longBitsToDouble(Double.doubleToLongBits(a - (a - (b = p.distanceSq(pA)) + c) * (a - b + c) / 4.0 / c) >> 32 << 32);
                    if (perDistSq < snapDistanceSq && a < c + snapDistanceSq && b < c + snapDistanceSq) {
                        nearestMap.computeIfAbsent(perDistSq, k -> new LinkedList()).add(new WaySegment(w, i));
                    }
                    lastN = n;
                }
            }
        }
        return nearestMap;
    }

    public final List<WaySegment> getNearestWaySegments(Point p, Collection<WaySegment> ignore, Predicate<OsmPrimitive> predicate) {
        ArrayList<WaySegment> nearestList = new ArrayList<WaySegment>();
        LinkedList unselected = new LinkedList();
        for (List<WaySegment> wss : this.getNearestWaySegmentsImpl(p, predicate).values()) {
            for (WaySegment ws : wss) {
                (((Way)ws.getWay()).isSelected() ? nearestList : unselected).add((WaySegment)ws);
            }
            nearestList.addAll(unselected);
            unselected.clear();
        }
        if (ignore != null) {
            nearestList.removeAll(ignore);
        }
        return nearestList;
    }

    public final List<WaySegment> getNearestWaySegments(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWaySegments(p, null, predicate);
    }

    public final WaySegment getNearestWaySegment(Point p, Predicate<OsmPrimitive> predicate, boolean useSelected) {
        WaySegment wayseg = null;
        WaySegment ntsel = null;
        for (List<WaySegment> wslist : this.getNearestWaySegmentsImpl(p, predicate).values()) {
            if (wayseg != null && ntsel != null) break;
            for (WaySegment ws : wslist) {
                if (wayseg == null) {
                    wayseg = ws;
                }
                if (ntsel != null || !((Way)ws.getWay()).isSelected()) continue;
                ntsel = ws;
            }
        }
        return ntsel != null && useSelected ? ntsel : wayseg;
    }

    public final WaySegment getNearestWaySegment(Point p, Predicate<OsmPrimitive> predicate, boolean useSelected, Collection<OsmPrimitive> preferredRefs) {
        WaySegment wayseg = null;
        if (preferredRefs != null && preferredRefs.isEmpty()) {
            preferredRefs = null;
        }
        for (List<WaySegment> wslist : this.getNearestWaySegmentsImpl(p, predicate).values()) {
            for (WaySegment ws : wslist) {
                if (wayseg == null) {
                    wayseg = ws;
                }
                if (useSelected && ((Way)ws.getWay()).isSelected()) {
                    return ws;
                }
                if (Utils.isEmpty(preferredRefs)) continue;
                if (preferredRefs.contains(ws.getFirstNode()) || preferredRefs.contains(ws.getSecondNode())) {
                    return ws;
                }
                List<OsmPrimitive> wayRefs = ((Way)ws.getWay()).getReferrers();
                for (OsmPrimitive ref : preferredRefs) {
                    if (!(ref instanceof Relation) || !wayRefs.contains(ref)) continue;
                    return ws;
                }
            }
        }
        return wayseg;
    }

    public final WaySegment getNearestWaySegment(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWaySegment(p, predicate, true);
    }

    public final List<Way> getNearestWays(Point p, Collection<Way> ignore, Predicate<OsmPrimitive> predicate) {
        HashSet wset = new HashSet();
        List<Way> nearestList = this.getNearestWaySegmentsImpl(p, predicate).values().stream().flatMap(Collection::stream).filter(ws -> wset.add((Way)ws.getWay())).map(IWaySegment::getWay).collect(Collectors.toList());
        if (ignore != null) {
            nearestList.removeAll(ignore);
        }
        return nearestList;
    }

    public final List<Way> getNearestWays(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWays(p, null, predicate);
    }

    public final Way getNearestWay(Point p, Predicate<OsmPrimitive> predicate) {
        WaySegment nearestWaySeg = this.getNearestWaySegment(p, predicate);
        return nearestWaySeg == null ? null : (Way)nearestWaySeg.getWay();
    }

    public final List<OsmPrimitive> getNearestNodesOrWays(Point p, Collection<OsmPrimitive> ignore, Predicate<OsmPrimitive> predicate) {
        List<OsmPrimitive> nearestList = Collections.emptyList();
        OsmPrimitive osm = this.getNearestNodeOrWay(p, predicate, false);
        if (osm != null) {
            if (osm instanceof Node) {
                nearestList = new ArrayList<Node>(this.getNearestNodes(p, predicate));
            } else if (osm instanceof Way) {
                nearestList = new ArrayList<Way>(this.getNearestWays(p, predicate));
            }
            if (ignore != null) {
                nearestList.removeAll(ignore);
            }
        }
        return nearestList;
    }

    public final List<OsmPrimitive> getNearestNodesOrWays(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNodesOrWays(p, null, predicate);
    }

    private boolean isPrecedenceNode(Node osm, Point p, boolean useSelected) {
        if (osm != null) {
            if (p.distanceSq(this.getPoint2D(osm)) <= 16.0) {
                return true;
            }
            if (osm.isTagged()) {
                return true;
            }
            if (useSelected && osm.isSelected()) {
                return true;
            }
        }
        return false;
    }

    public final OsmPrimitive getNearestNodeOrWay(Point p, Predicate<OsmPrimitive> predicate, boolean useSelected) {
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        Collection<OsmPrimitive> sel = useSelected && ds != null ? ds.getSelected() : null;
        OsmPrimitive osm = this.getNearestNode(p, predicate, useSelected, sel);
        if (this.isPrecedenceNode((Node)osm, p, useSelected)) {
            return osm;
        }
        WaySegment ws = useSelected ? this.getNearestWaySegment(p, predicate, useSelected, sel) : this.getNearestWaySegment(p, predicate, useSelected);
        if (ws == null) {
            return osm;
        }
        if (((Way)ws.getWay()).isSelected() && useSelected || osm == null) {
            osm = (OsmPrimitive)ws.getWay();
        } else {
            Point2D wp2;
            int maxWaySegLenSq = 3 * PROP_SNAP_DISTANCE.get();
            maxWaySegLenSq *= maxWaySegLenSq;
            Point2D wp1 = this.getPoint2D((Node)ws.getFirstNode());
            if (wp1.distanceSq(wp2 = this.getPoint2D((Node)ws.getSecondNode())) < (double)maxWaySegLenSq && p.distanceSq(NavigatableComponent.project(0.5, wp1, wp2)) < p.distanceSq(this.getPoint2D((Node)osm))) {
                osm = (OsmPrimitive)ws.getWay();
            }
        }
        return osm;
    }

    public static Point2D project(double r, Point2D a, Point2D b) {
        Point2D.Double ret = null;
        if (a != null && b != null) {
            ret = new Point2D.Double(a.getX() + r * (b.getX() - a.getX()), a.getY() + r * (b.getY() - a.getY()));
        }
        return ret;
    }

    public final List<OsmPrimitive> getAllNearest(Point p, Collection<OsmPrimitive> ignore, Predicate<OsmPrimitive> predicate) {
        HashSet wset = new HashSet();
        List<OsmPrimitive> nearestList = this.getNearestWaySegmentsImpl(p, predicate).values().stream().flatMap(Collection::stream).filter(ws -> wset.add((Way)ws.getWay())).map(IWaySegment::getWay).collect(Collectors.toList());
        this.getNearestNodesImpl(p, predicate).values().forEach(nearestList::addAll);
        Set parentRelations = nearestList.stream().flatMap(o -> o.referrers(Relation.class)).filter(predicate).collect(Collectors.toSet());
        nearestList.addAll(parentRelations);
        if (ignore != null) {
            nearestList.removeAll(ignore);
        }
        return nearestList;
    }

    public final List<OsmPrimitive> getAllNearest(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getAllNearest(p, null, predicate);
    }

    public Projection getProjection() {
        return this.state.getProjection();
    }

    @Override
    public String helpTopic() {
        String n = this.getClass().getName();
        return n.substring(n.lastIndexOf(46) + 1);
    }

    public int getViewID() {
        EastNorth center = this.getCenter();
        String x = String.valueOf(center.east()) + '_' + center.north() + '_' + this.getScale() + '_' + this.getWidth() + '_' + this.getHeight() + '_' + this.getProjection();
        CRC32 id = new CRC32();
        id.update(x.getBytes(StandardCharsets.UTF_8));
        return (int)id.getValue();
    }

    public void setNewCursor(Cursor cursor, Object reference) {
        this.cursorManager.setNewCursor(cursor, reference);
    }

    public void setNewCursor(int cursor, Object reference) {
        this.setNewCursor(Cursor.getPredefinedCursor(cursor), reference);
    }

    public void resetCursor(Object reference) {
        this.cursorManager.resetCursor(reference);
    }

    public CursorManager getCursorManager() {
        return this.cursorManager;
    }

    public double getMaxScale() {
        ProjectionBounds world = this.getMaxProjectionBounds();
        return Math.max(world.maxNorth - world.minNorth, world.maxEast - world.minEast) / 512.0;
    }

    private class PrimitiveHoverMouseListener
    extends MouseAdapter {
        private PrimitiveHoverMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            OsmPrimitive hovered = NavigatableComponent.this.getNearestNodeOrWay(e.getPoint(), NavigatableComponent.this.isSelectablePredicate, true);
            NavigatableComponent.this.updateHoveredPrimitive(hovered, e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            NavigatableComponent.this.updateHoveredPrimitive(null, e);
        }
    }

    private static class ZoomData {
        private final EastNorth center;
        private final double scale;

        ZoomData(EastNorth center, double scale) {
            this.center = center;
            this.scale = scale;
        }

        public EastNorth getCenterEastNorth() {
            return this.center;
        }

        public double getScale() {
            return this.scale;
        }
    }

    private class SmoothScrollThread
    extends Thread {
        private boolean doStop;
        private final EastNorth oldCenter;
        private final EastNorth finalNewCenter;
        private final long frames;
        private final long sleepTime;

        SmoothScrollThread(EastNorth newCenter, long frameNum, int fps) {
            super("smooth-scroller");
            this.oldCenter = NavigatableComponent.this.getCenter();
            this.finalNewCenter = newCenter;
            this.frames = frameNum;
            this.sleepTime = 1000L / (long)fps;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while ((long)i < this.frames && !this.doStop) {
                    EastNorth z = this.oldCenter.interpolate(this.finalNewCenter, (1.0 + (double)i) / (double)this.frames);
                    GuiHelper.runInEDTAndWait(() -> NavigatableComponent.this.zoomTo(z));
                    Thread.sleep(this.sleepTime);
                    ++i;
                }
            }
            catch (InterruptedException ex) {
                Logging.warn("Interruption during smooth scrolling");
            }
        }

        public void stopIt() {
            this.doStop = true;
        }
    }

    @FunctionalInterface
    public static interface ZoomChangeListener {
        public void zoomChanged();
    }
}

