/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.alerting.MonitorRunner;
import org.opensearch.alerting.MonitorRunnerExecutionContext;
import org.opensearch.alerting.action.DocLevelMonitorFanOutResponse;
import org.opensearch.alerting.model.DocumentLevelTriggerRunResult;
import org.opensearch.alerting.model.InputRunResults;
import org.opensearch.alerting.model.MonitorRunResult;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.alerting.workflow.WorkflowRunContext;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JF\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001d2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0#2\u0006\u0010%\u001a\u00020\u000fH\u0002J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020'0\u001d2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020\u000fH\u0002J8\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020-0\u001d2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020-0\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\u000fH\u0002JY\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0010002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u00142\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u000206H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J6\u00108\u001a\u0002092\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u001e\u0010:\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020-0\u000e0\u000eH\u0002J\u0010\u0010;\u001a\u0002092\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006<"}, d2={"Lorg/opensearch/alerting/DocumentLevelMonitorRunner;", "Lorg/opensearch/alerting/MonitorRunner;", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "totalTimeTakenStat", "", "buildInputRunResults", "Lorg/opensearch/alerting/model/InputRunResults;", "docLevelMonitorFanOutResponses", "", "Lorg/opensearch/alerting/action/DocLevelMonitorFanOutResponse;", "buildTriggerResults", "", "", "Lorg/opensearch/alerting/model/DocumentLevelTriggerRunResult;", "checkAndThrowExceptionIfAllFanOutsFailed", "Lorg/opensearch/alerting/util/AlertingException;", "createdRecently", "", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "periodStart", "Ljava/time/Instant;", "periodEnd", "indexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "distributeShards", "", "", "Lorg/opensearch/core/index/shard/ShardId;", "monitorCtx", "Lorg/opensearch/alerting/MonitorRunnerExecutionContext;", "allNodes", "", "shards", "index", "getNodes", "Lorg/opensearch/cluster/node/DiscoveryNode;", "getShardsCount", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "initializeNewLastRunContext", "", "lastRunContext", "runMonitor", "Lorg/opensearch/alerting/model/MonitorRunResult;", "dryrun", "workflowRunContext", "Lorg/opensearch/alerting/workflow/WorkflowRunContext;", "executionId", "transportService", "Lorg/opensearch/transport/TransportService;", "(Lorg/opensearch/commons/alerting/model/Monitor;Lorg/opensearch/alerting/MonitorRunnerExecutionContext;Ljava/time/Instant;Ljava/time/Instant;ZLorg/opensearch/alerting/workflow/WorkflowRunContext;Ljava/lang/String;Lorg/opensearch/transport/TransportService;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateLastRunContextFromFanOutResponses", "", "updatedLastRunContext", "validate", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nDocumentLevelMonitorRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentLevelMonitorRunner.kt\norg/opensearch/alerting/DocumentLevelMonitorRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,607:1\n1855#2:608\n1855#2:610\n1856#2:618\n1856#2:619\n1855#2,2:620\n766#2:633\n857#2,2:634\n1549#2:643\n1620#2,3:644\n1#3:609\n361#4,7:611\n361#4,7:624\n515#4:636\n500#4,6:637\n37#5,2:622\n37#5,2:631\n*S KotlinDebug\n*F\n+ 1 DocumentLevelMonitorRunner.kt\norg/opensearch/alerting/DocumentLevelMonitorRunner\n*L\n146#1:608\n175#1:610\n175#1:618\n146#1:619\n413#1:620,2\n563#1:633\n563#1:634,2\n582#1:643\n582#1:644,3\n177#1:611,7\n512#1:624,7\n567#1:636\n567#1:637,6\n442#1:622,2\n517#1:631,2\n*E\n"})
public final class DocumentLevelMonitorRunner
extends MonitorRunner {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private long totalTimeTakenStat;

    /*
     * Exception decompiling
     */
    @Nullable
    public Object runMonitor(@NotNull Monitor var1_1, @NotNull MonitorRunnerExecutionContext var2_2, @NotNull Instant var3_3, @NotNull Instant var4_4, boolean var5_5, @Nullable WorkflowRunContext var6_6, @NotNull String var7_7, @NotNull TransportService var8_8, @NotNull Continuation<? super MonitorRunResult<DocumentLevelTriggerRunResult>> var9_9) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void updateLastRunContextFromFanOutResponses(List<DocLevelMonitorFanOutResponse> docLevelMonitorFanOutResponses, Map<String, Map<String, Object>> updatedLastRunContext) {
        for (String indexName : updatedLastRunContext.keySet()) {
            for (DocLevelMonitorFanOutResponse fanOutResponse : docLevelMonitorFanOutResponses) {
                if (fanOutResponse.getException() != null) continue;
                Map<String, Object> map = updatedLastRunContext.get(indexName);
                Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                Map indexLastRunContext = TypeIntrinsics.asMutableMap(map);
                if (!fanOutResponse.getLastRunContexts().containsKey("index") || !Intrinsics.areEqual((Object)fanOutResponse.getLastRunContexts().get("index"), (Object)indexName)) continue;
                Iterable $this$forEach$iv = fanOutResponse.getLastRunContexts().keySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Integer seq_no = StringsKt.toIntOrNull((String)String.valueOf(fanOutResponse.getLastRunContexts().get(it)));
                    if (Intrinsics.areEqual((Object)it, (Object)"shards_count") || Intrinsics.areEqual((Object)it, (Object)"index") || seq_no == null || seq_no < 0) continue;
                    indexLastRunContext.put(it, seq_no);
                }
            }
        }
    }

    private final AlertingException checkAndThrowExceptionIfAllFanOutsFailed(List<DocLevelMonitorFanOutResponse> docLevelMonitorFanOutResponses) {
        List exceptions = new ArrayList();
        for (DocLevelMonitorFanOutResponse res2 : docLevelMonitorFanOutResponses) {
            if (res2.getException() == null) {
                return null;
            }
            exceptions.add(res2.getException());
        }
        Collection $this$toTypedArray$iv = exceptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AlertingException[] alertingExceptionArray = thisCollection$iv.toArray(new AlertingException[0]);
        return AlertingException.Companion.merge(Arrays.copyOf(alertingExceptionArray, alertingExceptionArray.length));
    }

    private final Map<String, DocumentLevelTriggerRunResult> buildTriggerResults(List<DocLevelMonitorFanOutResponse> docLevelMonitorFanOutResponses) {
        Map triggerResults = new LinkedHashMap();
        Map triggerErrorMap = new LinkedHashMap();
        for (DocLevelMonitorFanOutResponse res2 : docLevelMonitorFanOutResponses) {
            if (res2.getException() != null) continue;
            for (String triggerId : res2.getTriggerResults().keySet()) {
                DocumentLevelTriggerRunResult documentLevelTriggerRunResult = res2.getTriggerResults().get(triggerId);
                if (documentLevelTriggerRunResult == null) continue;
                if (!triggerResults.containsKey(triggerId)) {
                    List list;
                    Object error;
                    triggerResults.put(triggerId, documentLevelTriggerRunResult);
                    Map map = triggerErrorMap;
                    if (documentLevelTriggerRunResult.getError() != null) {
                        AlertingException alertingException;
                        if (documentLevelTriggerRunResult.getError() instanceof AlertingException) {
                            Exception exception = documentLevelTriggerRunResult.getError();
                            Intrinsics.checkNotNull((Object)exception, (String)"null cannot be cast to non-null type org.opensearch.alerting.util.AlertingException");
                            alertingException = (AlertingException)((Object)exception);
                        } else {
                            Exception exception = documentLevelTriggerRunResult.getError();
                            Intrinsics.checkNotNull((Object)exception);
                            OpenSearchException openSearchException = AlertingException.Companion.wrap(exception);
                            Intrinsics.checkNotNull((Object)openSearchException, (String)"null cannot be cast to non-null type org.opensearch.alerting.util.AlertingException");
                            alertingException = (AlertingException)openSearchException;
                        }
                        error = alertingException;
                        AlertingException[] alertingExceptionArray = new AlertingException[]{error};
                        list = CollectionsKt.mutableListOf((Object[])alertingExceptionArray);
                    } else {
                        list = new ArrayList();
                    }
                    error = list;
                    map.put(triggerId, error);
                    continue;
                }
                DocumentLevelTriggerRunResult currVal = (DocumentLevelTriggerRunResult)triggerResults.get(triggerId);
                List newTriggeredDocs = new ArrayList();
                DocumentLevelTriggerRunResult documentLevelTriggerRunResult2 = currVal;
                Intrinsics.checkNotNull((Object)documentLevelTriggerRunResult2);
                newTriggeredDocs.addAll((Collection)documentLevelTriggerRunResult2.getTriggeredDocs());
                newTriggeredDocs.addAll((Collection)documentLevelTriggerRunResult.getTriggeredDocs());
                Map newActionResults = new LinkedHashMap();
                newActionResults.putAll(currVal.getActionResultsMap());
                newActionResults.putAll(documentLevelTriggerRunResult.getActionResultsMap());
                triggerResults.put(triggerId, DocumentLevelTriggerRunResult.copy$default(currVal, null, newTriggeredDocs, null, newActionResults, 5, null));
                if (documentLevelTriggerRunResult.getError() == null) continue;
                Object v = triggerErrorMap.get(triggerId);
                Intrinsics.checkNotNull(v);
                List list = (List)v;
                Exception exception = documentLevelTriggerRunResult.getError();
                Intrinsics.checkNotNull((Object)exception, (String)"null cannot be cast to non-null type org.opensearch.alerting.util.AlertingException");
                list.add((AlertingException)((Object)exception));
            }
        }
        triggerErrorMap.forEach((arg_0, arg_1) -> DocumentLevelMonitorRunner.buildTriggerResults$lambda$6((Function2)new Function2<String, List<AlertingException>, Unit>((Map<String, DocumentLevelTriggerRunResult>)triggerResults){
            final /* synthetic */ Map<String, DocumentLevelTriggerRunResult> $triggerResults;
            {
                this.$triggerResults = $triggerResults;
                super(2);
            }

            public final void invoke(@NotNull String triggerId, @NotNull List<AlertingException> errorList) {
                Intrinsics.checkNotNullParameter((Object)triggerId, (String)"triggerId");
                Intrinsics.checkNotNullParameter(errorList, (String)"errorList");
                if (!((Collection)errorList).isEmpty()) {
                    DocumentLevelTriggerRunResult documentLevelTriggerRunResult = this.$triggerResults.get(triggerId);
                    Intrinsics.checkNotNull((Object)documentLevelTriggerRunResult);
                    Collection $this$toTypedArray$iv = errorList;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    AlertingException[] alertingExceptionArray = thisCollection$iv.toArray(new AlertingException[0]);
                    documentLevelTriggerRunResult.setError((Exception)((Object)AlertingException.Companion.merge(Arrays.copyOf(alertingExceptionArray, alertingExceptionArray.length))));
                }
            }
        }, arg_0, arg_1));
        return triggerResults;
    }

    private final InputRunResults buildInputRunResults(List<DocLevelMonitorFanOutResponse> docLevelMonitorFanOutResponses) {
        AlertingException alertingException;
        Map inputRunResults = new LinkedHashMap();
        List errors = new ArrayList();
        for (DocLevelMonitorFanOutResponse response2 : docLevelMonitorFanOutResponses) {
            if (response2.getException() != null) continue;
            if (response2.getInputResults().getError() != null) {
                if (response2.getInputResults().getError() instanceof AlertingException) {
                    errors.add(response2.getInputResults().getError());
                } else {
                    OpenSearchException openSearchException = AlertingException.Companion.wrap(response2.getInputResults().getError());
                    Intrinsics.checkNotNull((Object)openSearchException, (String)"null cannot be cast to non-null type org.opensearch.alerting.util.AlertingException");
                    errors.add((AlertingException)openSearchException);
                }
            }
            List<Map<String, Object>> partialResult = response2.getInputResults().getResults();
            for (Map<String, Object> result : partialResult) {
                for (String id : result.keySet()) {
                    Object object;
                    Map $this$getOrPut$iv = inputRunResults;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(id);
                    if (value$iv == null) {
                        boolean bl = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(id, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    Set set = (Set)object;
                    Object object2 = result.get(id);
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Collection<kotlin.String>");
                    set.addAll((Collection)object2);
                }
            }
        }
        List list = CollectionsKt.listOf((Object)inputRunResults);
        if (!errors.isEmpty()) {
            Collection $this$toTypedArray$iv = errors;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AlertingException[] alertingExceptionArray = thisCollection$iv.toArray(new AlertingException[0]);
            alertingException = AlertingException.Companion.merge(Arrays.copyOf(alertingExceptionArray, alertingExceptionArray.length));
        } else {
            alertingException = null;
        }
        return new InputRunResults(list, (Exception)((Object)alertingException), null, 4, null);
    }

    private final Map<String, Object> initializeNewLastRunContext(Map<String, ? extends Object> lastRunContext, MonitorRunnerExecutionContext monitorCtx, String index) {
        ClusterService clusterService = monitorCtx.getClusterService();
        Intrinsics.checkNotNull((Object)clusterService);
        int count = this.getShardsCount(clusterService, index);
        Map updatedLastRunContext = MapsKt.toMutableMap(lastRunContext);
        for (int i = 0; i < count; ++i) {
            String shard = String.valueOf(i);
            updatedLastRunContext.put(shard, "-2");
        }
        return updatedLastRunContext;
    }

    private final void validate(Monitor monitor) {
        if (monitor.getInputs().size() > 1) {
            throw new IOException("Only one input is supported with document-level-monitor.");
        }
        if (!Intrinsics.areEqual((Object)((Input)monitor.getInputs().get(0)).name(), (Object)"doc_level_input")) {
            throw new IOException("Invalid input with document-level-monitor.");
        }
        Object e = monitor.getInputs().get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.DocLevelMonitorInput");
        if (((DocLevelMonitorInput)e).getIndices().isEmpty()) {
            throw new IllegalArgumentException("DocLevelMonitorInput has no indices");
        }
    }

    private final boolean createdRecently(Monitor monitor, Instant periodStart, Instant periodEnd, IndexMetadata indexMetadata) {
        Instant lastExecutionTime = Intrinsics.areEqual((Object)periodStart, (Object)periodEnd) ? monitor.getLastUpdateTime() : periodStart;
        String string = indexMetadata.getSettings().get("index.creation_date");
        long indexCreationDate = string != null ? Long.parseLong(string) : 0L;
        return indexCreationDate > lastExecutionTime.toEpochMilli();
    }

    /*
     * WARNING - void declaration
     */
    private final int getShardsCount(ClusterService clusterService, String index) {
        void $this$filterTo$iv$iv;
        ClusterService clusterService2 = clusterService;
        Intrinsics.checkNotNull((Object)clusterService2);
        List list = clusterService2.state().routingTable().allShards(index);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"clusterService!!.state()\u2026gTable().allShards(index)");
        List allShards = list;
        Iterable $this$filter$iv = allShards;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShardRouting it = (ShardRouting)element$iv$iv;
            boolean bl = false;
            if (!it.primary()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DiscoveryNode> getNodes(MonitorRunnerExecutionContext monitorCtx) {
        void $this$filterTo$iv$iv;
        ClusterService clusterService = monitorCtx.getClusterService();
        Intrinsics.checkNotNull((Object)clusterService);
        Map map = clusterService.state().getNodes().getDataNodes();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"monitorCtx.clusterServic\u2026!.state().nodes.dataNodes");
        Map $this$filter$iv = map;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((DiscoveryNode)it.getValue()).getVersion().compareTo(Version.CURRENT) >= 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Set<ShardId>> distributeShards(MonitorRunnerExecutionContext monitorCtx, List<String> allNodes, List<String> shards, String index) {
        void $this$mapTo$iv$iv;
        int totalShards = shards.size();
        int numFanOutNodes = RangesKt.coerceAtMost((int)allNodes.size(), (int)((totalShards + 1) / 2));
        int totalNodes = RangesKt.coerceAtMost((int)monitorCtx.getTotalNodesFanOut(), (int)numFanOutNodes);
        int shardsPerNode = totalShards / totalNodes;
        int shardsRemaining = totalShards % totalNodes;
        Iterable $this$map$iv = shards;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ClusterService clusterService = monitorCtx.getClusterService();
            Intrinsics.checkNotNull((Object)clusterService);
            collection.add(new ShardId(clusterService.state().getMetadata().index(index).getIndex(), Integer.parseInt((String)it)));
        }
        List shardIdList = (List)destination$iv$iv;
        List<String> nodes = allNodes.subList(0, totalNodes);
        Map nodeShardAssignments = new LinkedHashMap();
        int idx = 0;
        for (String node : nodes) {
            Set nodeShardAssignment = new LinkedHashSet();
            int i = 1;
            if (i <= shardsPerNode) {
                while (true) {
                    nodeShardAssignment.add(shardIdList.get(idx++));
                    if (i == shardsPerNode) break;
                    ++i;
                }
            }
            nodeShardAssignments.put(node, nodeShardAssignment);
        }
        for (String node : nodes) {
            if (shardsRemaining == 0) break;
            Object v = nodeShardAssignments.get(node);
            Intrinsics.checkNotNull(v);
            ((Set)v).add(shardIdList.get(idx++));
            --shardsRemaining;
        }
        return nodeShardAssignments;
    }

    private static final void buildTriggerResults$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DocumentLevelMonitorRunner $this) {
        return $this.logger;
    }
}

